SELECT DISTINCT
    `statistics`.`block_id` AS `id`,
    `statistics`.`page_id` AS `page_id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'context_on_site_adblock'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `context_on_site_adblock`.`id` AS `id`,
    `context_on_site_adblock`.`page_id` AS `page_id`
FROM `context_on_site_adblock`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`block_id` AS `id`,
    `statistics`.`page_id` AS `page_id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'context_on_site_adblock'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `context_on_site_adblock`.`id` AS `id`,
    `context_on_site_adblock`.`page_id` AS `page_id`
FROM `context_on_site_adblock`
WHERE (
    (
        `context_on_site_adblock`.`page_id` = '1'
        AND `context_on_site_adblock`.`id` IN ('1')
    )
    OR (
        `context_on_site_adblock`.`page_id` = '2'
        AND `context_on_site_adblock`.`id` IN ('1', '2')
    )
)

SELECT
    `context_on_site_campaign`.`id` AS `id`
FROM `context_on_site_campaign`
WHERE (
    (
        `context_on_site_campaign`.`page_id` IN ('1', '2')
    )
    AND (
        `context_on_site_campaign`.`multistate` IN ('104', '1088', '1096', '1104', '1105', '1106', '1108', '1112', '1116', '112', '1120', '1128', '113', '1136', '1137', '1138', '114', '1140', '1144', '1148', '116', '120', '1216', '1224', '1232', '1233', '1234', '1236', '124', '1240', '1244', '1248', '1256', '1264', '1265', '1266', '1268', '1272', '1276', '1344', '1352', '1360', '1361', '1362', '1364', '1368', '1372', '1376', '1384', '1392', '1393', '1394', '1396', '1400', '1404', '1600', '1608', '1616', '1617', '1618', '1620', '1624', '1628', '1632', '1640', '1648', '1649', '1650', '1652', '1656', '1660', '1728', '1736', '1744', '1745', '1746', '1748', '1752', '1756', '1760', '1768', '1776', '1777', '1778', '1780', '1784', '1788', '192', '200', '208', '209', '210', '2112', '212', '2120', '2128', '2129', '2130', '2132', '2136', '2140', '2144', '2152', '216', '2160', '2161', '2162', '2164', '2168', '2172', '220', '224', '2240', '2248', '2256', '2257', '2258', '2260', '2264', '2268', '2272', '2280', '2288', '2289', '2290', '2292', '2296', '2300', '232', '2368', '2376', '2384', '2385', '2386', '2388', '2392', '2396', '240', '2400', '2408', '241', '2416', '2417', '2418', '242', '2420', '2424', '2428', '244', '248', '252', '2624', '2632', '2640', '2641', '2642', '2644', '2648', '2652', '2656', '2664', '2672', '2673', '2674', '2676', '2680', '2684', '2752', '2760', '2768', '2769', '2770', '2772', '2776', '2780', '2784', '2792', '2800', '2801', '2802', '2804', '2808', '2812', '3136', '3144', '3152', '3153', '3154', '3156', '3160', '3164', '3168', '3176', '3184', '3185', '3186', '3188', '3192', '3196', '320', '3264', '3272', '328', '3280', '3281', '3282', '3284', '3288', '3292', '3296', '3304', '3312', '3313', '3314', '3316', '3320', '3324', '336', '337', '338', '3392', '340', '3400', '3408', '3409', '3410', '3412', '3416', '3420', '3424', '3432', '344', '3440', '3441', '3442', '3444', '3448', '3452', '348', '352', '360', '3648', '3656', '3664', '3665', '3666', '3668', '3672', '3676', '368', '3680', '3688', '369', '3696', '3697', '3698', '370', '3700', '3704', '3708', '372', '376', '3776', '3784', '3792', '3793', '3794', '3796', '380', '3800', '3804', '3808', '3816', '3824', '3825', '3826', '3828', '3832', '3836', '4160', '4168', '4176', '4177', '4178', '4180', '4184', '4188', '4192', '4200', '4208', '4209', '4210', '4212', '4216', '4220', '4288', '4296', '4304', '4305', '4306', '4308', '4312', '4316', '4320', '4328', '4336', '4337', '4338', '4340', '4344', '4348', '4416', '4424', '4432', '4433', '4434', '4436', '4440', '4444', '4448', '4456', '4464', '4465', '4466', '4468', '4472', '4476', '4672', '4680', '4688', '4689', '4690', '4692', '4696', '4700', '4704', '4712', '4720', '4721', '4722', '4724', '4728', '4732', '4800', '4808', '4816', '4817', '4818', '4820', '4824', '4828', '4832', '4840', '4848', '4849', '4850', '4852', '4856', '4860', '5184', '5192', '5200', '5201', '5202', '5204', '5208', '5212', '5216', '5224', '5232', '5233', '5234', '5236', '5240', '5244', '5312', '5320', '5328', '5329', '5330', '5332', '5336', '5340', '5344', '5352', '5360', '5361', '5362', '5364', '5368', '5372', '5440', '5448', '5456', '5457', '5458', '5460', '5464', '5468', '5472', '5480', '5488', '5489', '5490', '5492', '5496', '5500', '5696', '5704', '5712', '5713', '5714', '5716', '5720', '5724', '5728', '5736', '5744', '5745', '5746', '5748', '5752', '5756', '576', '5824', '5832', '584', '5840', '5841', '5842', '5844', '5848', '5852', '5856', '5864', '5872', '5873', '5874', '5876', '5880', '5884', '592', '593', '594', '596', '600', '604', '608', '616', '6208', '6216', '6224', '6225', '6226', '6228', '6232', '6236', '624', '6240', '6248', '625', '6256', '6257', '6258', '626', '6260', '6264', '6268', '628', '632', '6336', '6344', '6352', '6353', '6354', '6356', '636', '6360', '6364', '6368', '6376', '6384', '6385', '6386', '6388', '6392', '6396', '64', '6464', '6472', '6480', '6481', '6482', '6484', '6488', '6492', '6496', '6504', '6512', '6513', '6514', '6516', '6520', '6524', '6720', '6728', '6736', '6737', '6738', '6740', '6744', '6748', '6752', '6760', '6768', '6769', '6770', '6772', '6776', '6780', '6848', '6856', '6864', '6865', '6866', '6868', '6872', '6876', '6880', '6888', '6896', '6897', '6898', '6900', '6904', '6908', '704', '712', '72', '720', '721', '722', '7232', '724', '7240', '7248', '7249', '7250', '7252', '7256', '7260', '7264', '7272', '728', '7280', '7281', '7282', '7284', '7288', '7292', '732', '736', '7360', '7368', '7376', '7377', '7378', '7380', '7384', '7388', '7392', '7400', '7408', '7409', '7410', '7412', '7416', '7420', '744', '7488', '7496', '7504', '7505', '7506', '7508', '7512', '7516', '752', '7520', '7528', '753', '7536', '7537', '7538', '754', '7540', '7544', '7548', '756', '760', '764', '7744', '7752', '7760', '7761', '7762', '7764', '7768', '7772', '7776', '7784', '7792', '7793', '7794', '7796', '7800', '7804', '7872', '7880', '7888', '7889', '7890', '7892', '7896', '7900', '7904', '7912', '7920', '7921', '7922', '7924', '7928', '7932', '80', '81', '82', '84', '88', '92', '96')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'context_on_site_content'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `context_on_site_content`.`campaign_id` AS `campaign_id`,
    `context_on_site_content`.`id` AS `id`
FROM `context_on_site_content`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'context_on_site_content'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `context_on_site_content`.`campaign_id` AS `campaign_id`,
    `context_on_site_content`.`id` AS `id`
FROM `context_on_site_content`
WHERE (
    (
        `context_on_site_content`.`campaign_id` = '1'
        AND `context_on_site_content`.`id` IN ('1')
    )
    OR (
        `context_on_site_content`.`campaign_id` = '2'
        AND `context_on_site_content`.`id` IN ('1', '2')
    )
)

SELECT
    `context_on_site_campaign`.`id` AS `id`
FROM `context_on_site_campaign`
WHERE (
    (
        `context_on_site_campaign`.`page_id` IN ('1', '2')
    )
    AND (
        `context_on_site_campaign`.`multistate` IN ('104', '1088', '1096', '1104', '1105', '1106', '1108', '1112', '1116', '112', '1120', '1128', '113', '1136', '1137', '1138', '114', '1140', '1144', '1148', '116', '120', '1216', '1224', '1232', '1233', '1234', '1236', '124', '1240', '1244', '1248', '1256', '1264', '1265', '1266', '1268', '1272', '1276', '1344', '1352', '1360', '1361', '1362', '1364', '1368', '1372', '1376', '1384', '1392', '1393', '1394', '1396', '1400', '1404', '1600', '1608', '1616', '1617', '1618', '1620', '1624', '1628', '1632', '1640', '1648', '1649', '1650', '1652', '1656', '1660', '1728', '1736', '1744', '1745', '1746', '1748', '1752', '1756', '1760', '1768', '1776', '1777', '1778', '1780', '1784', '1788', '192', '200', '208', '209', '210', '2112', '212', '2120', '2128', '2129', '2130', '2132', '2136', '2140', '2144', '2152', '216', '2160', '2161', '2162', '2164', '2168', '2172', '220', '224', '2240', '2248', '2256', '2257', '2258', '2260', '2264', '2268', '2272', '2280', '2288', '2289', '2290', '2292', '2296', '2300', '232', '2368', '2376', '2384', '2385', '2386', '2388', '2392', '2396', '240', '2400', '2408', '241', '2416', '2417', '2418', '242', '2420', '2424', '2428', '244', '248', '252', '2624', '2632', '2640', '2641', '2642', '2644', '2648', '2652', '2656', '2664', '2672', '2673', '2674', '2676', '2680', '2684', '2752', '2760', '2768', '2769', '2770', '2772', '2776', '2780', '2784', '2792', '2800', '2801', '2802', '2804', '2808', '2812', '3136', '3144', '3152', '3153', '3154', '3156', '3160', '3164', '3168', '3176', '3184', '3185', '3186', '3188', '3192', '3196', '320', '3264', '3272', '328', '3280', '3281', '3282', '3284', '3288', '3292', '3296', '3304', '3312', '3313', '3314', '3316', '3320', '3324', '336', '337', '338', '3392', '340', '3400', '3408', '3409', '3410', '3412', '3416', '3420', '3424', '3432', '344', '3440', '3441', '3442', '3444', '3448', '3452', '348', '352', '360', '3648', '3656', '3664', '3665', '3666', '3668', '3672', '3676', '368', '3680', '3688', '369', '3696', '3697', '3698', '370', '3700', '3704', '3708', '372', '376', '3776', '3784', '3792', '3793', '3794', '3796', '380', '3800', '3804', '3808', '3816', '3824', '3825', '3826', '3828', '3832', '3836', '4160', '4168', '4176', '4177', '4178', '4180', '4184', '4188', '4192', '4200', '4208', '4209', '4210', '4212', '4216', '4220', '4288', '4296', '4304', '4305', '4306', '4308', '4312', '4316', '4320', '4328', '4336', '4337', '4338', '4340', '4344', '4348', '4416', '4424', '4432', '4433', '4434', '4436', '4440', '4444', '4448', '4456', '4464', '4465', '4466', '4468', '4472', '4476', '4672', '4680', '4688', '4689', '4690', '4692', '4696', '4700', '4704', '4712', '4720', '4721', '4722', '4724', '4728', '4732', '4800', '4808', '4816', '4817', '4818', '4820', '4824', '4828', '4832', '4840', '4848', '4849', '4850', '4852', '4856', '4860', '5184', '5192', '5200', '5201', '5202', '5204', '5208', '5212', '5216', '5224', '5232', '5233', '5234', '5236', '5240', '5244', '5312', '5320', '5328', '5329', '5330', '5332', '5336', '5340', '5344', '5352', '5360', '5361', '5362', '5364', '5368', '5372', '5440', '5448', '5456', '5457', '5458', '5460', '5464', '5468', '5472', '5480', '5488', '5489', '5490', '5492', '5496', '5500', '5696', '5704', '5712', '5713', '5714', '5716', '5720', '5724', '5728', '5736', '5744', '5745', '5746', '5748', '5752', '5756', '576', '5824', '5832', '584', '5840', '5841', '5842', '5844', '5848', '5852', '5856', '5864', '5872', '5873', '5874', '5876', '5880', '5884', '592', '593', '594', '596', '600', '604', '608', '616', '6208', '6216', '6224', '6225', '6226', '6228', '6232', '6236', '624', '6240', '6248', '625', '6256', '6257', '6258', '626', '6260', '6264', '6268', '628', '632', '6336', '6344', '6352', '6353', '6354', '6356', '636', '6360', '6364', '6368', '6376', '6384', '6385', '6386', '6388', '6392', '6396', '64', '6464', '6472', '6480', '6481', '6482', '6484', '6488', '6492', '6496', '6504', '6512', '6513', '6514', '6516', '6520', '6524', '6720', '6728', '6736', '6737', '6738', '6740', '6744', '6748', '6752', '6760', '6768', '6769', '6770', '6772', '6776', '6780', '6848', '6856', '6864', '6865', '6866', '6868', '6872', '6876', '6880', '6888', '6896', '6897', '6898', '6900', '6904', '6908', '704', '712', '72', '720', '721', '722', '7232', '724', '7240', '7248', '7249', '7250', '7252', '7256', '7260', '7264', '7272', '728', '7280', '7281', '7282', '7284', '7288', '7292', '732', '736', '7360', '7368', '7376', '7377', '7378', '7380', '7384', '7388', '7392', '7400', '7408', '7409', '7410', '7412', '7416', '7420', '744', '7488', '7496', '7504', '7505', '7506', '7508', '7512', '7516', '752', '7520', '7528', '753', '7536', '7537', '7538', '754', '7540', '7544', '7548', '756', '760', '764', '7744', '7752', '7760', '7761', '7762', '7764', '7768', '7772', '7776', '7784', '7792', '7793', '7794', '7796', '7800', '7804', '7872', '7880', '7888', '7889', '7890', '7892', '7896', '7900', '7904', '7912', '7920', '7921', '7922', '7924', '7928', '7932', '80', '81', '82', '84', '88', '92', '96')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'context_on_site_direct'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `context_on_site_direct`.`active` AS `active`,
    `context_on_site_direct`.`campaign_id` AS `campaign_id`,
    `context_on_site_direct`.`id` AS `id`
FROM `context_on_site_direct`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'context_on_site_direct'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `context_on_site_direct`.`active` AS `active`,
    `context_on_site_direct`.`campaign_id` AS `campaign_id`,
    `context_on_site_direct`.`id` AS `id`
FROM `context_on_site_direct`
WHERE (
    (
        `context_on_site_direct`.`campaign_id` = '1'
        AND `context_on_site_direct`.`id` IN ('1')
    )
    OR (
        `context_on_site_direct`.`campaign_id` = '2'
        AND `context_on_site_direct`.`id` IN ('1', '2')
    )
)

SELECT
    `context_on_site_campaign`.`id` AS `id`
FROM `context_on_site_campaign`
WHERE (
    (
        `context_on_site_campaign`.`page_id` IN ('2')
    )
    AND (
        `context_on_site_campaign`.`multistate` IN ('104', '1088', '1096', '1104', '1105', '1106', '1108', '1112', '1116', '112', '1120', '1128', '113', '1136', '1137', '1138', '114', '1140', '1144', '1148', '116', '120', '1216', '1224', '1232', '1233', '1234', '1236', '124', '1240', '1244', '1248', '1256', '1264', '1265', '1266', '1268', '1272', '1276', '1344', '1352', '1360', '1361', '1362', '1364', '1368', '1372', '1376', '1384', '1392', '1393', '1394', '1396', '1400', '1404', '1600', '1608', '1616', '1617', '1618', '1620', '1624', '1628', '1632', '1640', '1648', '1649', '1650', '1652', '1656', '1660', '1728', '1736', '1744', '1745', '1746', '1748', '1752', '1756', '1760', '1768', '1776', '1777', '1778', '1780', '1784', '1788', '192', '200', '208', '209', '210', '2112', '212', '2120', '2128', '2129', '2130', '2132', '2136', '2140', '2144', '2152', '216', '2160', '2161', '2162', '2164', '2168', '2172', '220', '224', '2240', '2248', '2256', '2257', '2258', '2260', '2264', '2268', '2272', '2280', '2288', '2289', '2290', '2292', '2296', '2300', '232', '2368', '2376', '2384', '2385', '2386', '2388', '2392', '2396', '240', '2400', '2408', '241', '2416', '2417', '2418', '242', '2420', '2424', '2428', '244', '248', '252', '2624', '2632', '2640', '2641', '2642', '2644', '2648', '2652', '2656', '2664', '2672', '2673', '2674', '2676', '2680', '2684', '2752', '2760', '2768', '2769', '2770', '2772', '2776', '2780', '2784', '2792', '2800', '2801', '2802', '2804', '2808', '2812', '3136', '3144', '3152', '3153', '3154', '3156', '3160', '3164', '3168', '3176', '3184', '3185', '3186', '3188', '3192', '3196', '320', '3264', '3272', '328', '3280', '3281', '3282', '3284', '3288', '3292', '3296', '3304', '3312', '3313', '3314', '3316', '3320', '3324', '336', '337', '338', '3392', '340', '3400', '3408', '3409', '3410', '3412', '3416', '3420', '3424', '3432', '344', '3440', '3441', '3442', '3444', '3448', '3452', '348', '352', '360', '3648', '3656', '3664', '3665', '3666', '3668', '3672', '3676', '368', '3680', '3688', '369', '3696', '3697', '3698', '370', '3700', '3704', '3708', '372', '376', '3776', '3784', '3792', '3793', '3794', '3796', '380', '3800', '3804', '3808', '3816', '3824', '3825', '3826', '3828', '3832', '3836', '4160', '4168', '4176', '4177', '4178', '4180', '4184', '4188', '4192', '4200', '4208', '4209', '4210', '4212', '4216', '4220', '4288', '4296', '4304', '4305', '4306', '4308', '4312', '4316', '4320', '4328', '4336', '4337', '4338', '4340', '4344', '4348', '4416', '4424', '4432', '4433', '4434', '4436', '4440', '4444', '4448', '4456', '4464', '4465', '4466', '4468', '4472', '4476', '4672', '4680', '4688', '4689', '4690', '4692', '4696', '4700', '4704', '4712', '4720', '4721', '4722', '4724', '4728', '4732', '4800', '4808', '4816', '4817', '4818', '4820', '4824', '4828', '4832', '4840', '4848', '4849', '4850', '4852', '4856', '4860', '5184', '5192', '5200', '5201', '5202', '5204', '5208', '5212', '5216', '5224', '5232', '5233', '5234', '5236', '5240', '5244', '5312', '5320', '5328', '5329', '5330', '5332', '5336', '5340', '5344', '5352', '5360', '5361', '5362', '5364', '5368', '5372', '5440', '5448', '5456', '5457', '5458', '5460', '5464', '5468', '5472', '5480', '5488', '5489', '5490', '5492', '5496', '5500', '5696', '5704', '5712', '5713', '5714', '5716', '5720', '5724', '5728', '5736', '5744', '5745', '5746', '5748', '5752', '5756', '576', '5824', '5832', '584', '5840', '5841', '5842', '5844', '5848', '5852', '5856', '5864', '5872', '5873', '5874', '5876', '5880', '5884', '592', '593', '594', '596', '600', '604', '608', '616', '6208', '6216', '6224', '6225', '6226', '6228', '6232', '6236', '624', '6240', '6248', '625', '6256', '6257', '6258', '626', '6260', '6264', '6268', '628', '632', '6336', '6344', '6352', '6353', '6354', '6356', '636', '6360', '6364', '6368', '6376', '6384', '6385', '6386', '6388', '6392', '6396', '64', '6464', '6472', '6480', '6481', '6482', '6484', '6488', '6492', '6496', '6504', '6512', '6513', '6514', '6516', '6520', '6524', '6720', '6728', '6736', '6737', '6738', '6740', '6744', '6748', '6752', '6760', '6768', '6769', '6770', '6772', '6776', '6780', '6848', '6856', '6864', '6865', '6866', '6868', '6872', '6876', '6880', '6888', '6896', '6897', '6898', '6900', '6904', '6908', '704', '712', '72', '720', '721', '722', '7232', '724', '7240', '7248', '7249', '7250', '7252', '7256', '7260', '7264', '7272', '728', '7280', '7281', '7282', '7284', '7288', '7292', '732', '736', '7360', '7368', '7376', '7377', '7378', '7380', '7384', '7388', '7392', '7400', '7408', '7409', '7410', '7412', '7416', '7420', '744', '7488', '7496', '7504', '7505', '7506', '7508', '7512', '7516', '752', '7520', '7528', '753', '7536', '7537', '7538', '754', '7540', '7544', '7548', '756', '760', '764', '7744', '7752', '7760', '7761', '7762', '7764', '7768', '7772', '7776', '7784', '7792', '7793', '7794', '7796', '7800', '7804', '7872', '7880', '7888', '7889', '7890', '7892', '7896', '7900', '7904', '7912', '7920', '7921', '7922', '7924', '7928', '7932', '80', '81', '82', '84', '88', '92', '96')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'context_on_site_market'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 2)
) FORMAT JSONCompact

SELECT
    `context_on_site_market`.`campaign_id` AS `campaign_id`,
    `context_on_site_market`.`id` AS `id`
FROM `context_on_site_market`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'context_on_site_market'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 2)
) FORMAT JSONCompact

SELECT
    `context_on_site_market`.`campaign_id` AS `campaign_id`,
    `context_on_site_market`.`id` AS `id`
FROM `context_on_site_market`
WHERE (
    (
        `context_on_site_market`.`campaign_id` = '1'
        AND `context_on_site_market`.`id` IN ('1')
    )
    OR (
        `context_on_site_market`.`campaign_id` = '2'
        AND `context_on_site_market`.`id` IN ('1', '2')
    )
)

SELECT
    `context_on_site_campaign`.`id` AS `id`
FROM `context_on_site_campaign`
WHERE (
    (
        `context_on_site_campaign`.`page_id` IN ('1', '2')
    )
    AND (
        `context_on_site_campaign`.`multistate` IN ('104', '1088', '1096', '1104', '1105', '1106', '1108', '1112', '1116', '112', '1120', '1128', '113', '1136', '1137', '1138', '114', '1140', '1144', '1148', '116', '120', '1216', '1224', '1232', '1233', '1234', '1236', '124', '1240', '1244', '1248', '1256', '1264', '1265', '1266', '1268', '1272', '1276', '1344', '1352', '1360', '1361', '1362', '1364', '1368', '1372', '1376', '1384', '1392', '1393', '1394', '1396', '1400', '1404', '1600', '1608', '1616', '1617', '1618', '1620', '1624', '1628', '1632', '1640', '1648', '1649', '1650', '1652', '1656', '1660', '1728', '1736', '1744', '1745', '1746', '1748', '1752', '1756', '1760', '1768', '1776', '1777', '1778', '1780', '1784', '1788', '192', '200', '208', '209', '210', '2112', '212', '2120', '2128', '2129', '2130', '2132', '2136', '2140', '2144', '2152', '216', '2160', '2161', '2162', '2164', '2168', '2172', '220', '224', '2240', '2248', '2256', '2257', '2258', '2260', '2264', '2268', '2272', '2280', '2288', '2289', '2290', '2292', '2296', '2300', '232', '2368', '2376', '2384', '2385', '2386', '2388', '2392', '2396', '240', '2400', '2408', '241', '2416', '2417', '2418', '242', '2420', '2424', '2428', '244', '248', '252', '2624', '2632', '2640', '2641', '2642', '2644', '2648', '2652', '2656', '2664', '2672', '2673', '2674', '2676', '2680', '2684', '2752', '2760', '2768', '2769', '2770', '2772', '2776', '2780', '2784', '2792', '2800', '2801', '2802', '2804', '2808', '2812', '3136', '3144', '3152', '3153', '3154', '3156', '3160', '3164', '3168', '3176', '3184', '3185', '3186', '3188', '3192', '3196', '320', '3264', '3272', '328', '3280', '3281', '3282', '3284', '3288', '3292', '3296', '3304', '3312', '3313', '3314', '3316', '3320', '3324', '336', '337', '338', '3392', '340', '3400', '3408', '3409', '3410', '3412', '3416', '3420', '3424', '3432', '344', '3440', '3441', '3442', '3444', '3448', '3452', '348', '352', '360', '3648', '3656', '3664', '3665', '3666', '3668', '3672', '3676', '368', '3680', '3688', '369', '3696', '3697', '3698', '370', '3700', '3704', '3708', '372', '376', '3776', '3784', '3792', '3793', '3794', '3796', '380', '3800', '3804', '3808', '3816', '3824', '3825', '3826', '3828', '3832', '3836', '4160', '4168', '4176', '4177', '4178', '4180', '4184', '4188', '4192', '4200', '4208', '4209', '4210', '4212', '4216', '4220', '4288', '4296', '4304', '4305', '4306', '4308', '4312', '4316', '4320', '4328', '4336', '4337', '4338', '4340', '4344', '4348', '4416', '4424', '4432', '4433', '4434', '4436', '4440', '4444', '4448', '4456', '4464', '4465', '4466', '4468', '4472', '4476', '4672', '4680', '4688', '4689', '4690', '4692', '4696', '4700', '4704', '4712', '4720', '4721', '4722', '4724', '4728', '4732', '4800', '4808', '4816', '4817', '4818', '4820', '4824', '4828', '4832', '4840', '4848', '4849', '4850', '4852', '4856', '4860', '5184', '5192', '5200', '5201', '5202', '5204', '5208', '5212', '5216', '5224', '5232', '5233', '5234', '5236', '5240', '5244', '5312', '5320', '5328', '5329', '5330', '5332', '5336', '5340', '5344', '5352', '5360', '5361', '5362', '5364', '5368', '5372', '5440', '5448', '5456', '5457', '5458', '5460', '5464', '5468', '5472', '5480', '5488', '5489', '5490', '5492', '5496', '5500', '5696', '5704', '5712', '5713', '5714', '5716', '5720', '5724', '5728', '5736', '5744', '5745', '5746', '5748', '5752', '5756', '576', '5824', '5832', '584', '5840', '5841', '5842', '5844', '5848', '5852', '5856', '5864', '5872', '5873', '5874', '5876', '5880', '5884', '592', '593', '594', '596', '600', '604', '608', '616', '6208', '6216', '6224', '6225', '6226', '6228', '6232', '6236', '624', '6240', '6248', '625', '6256', '6257', '6258', '626', '6260', '6264', '6268', '628', '632', '6336', '6344', '6352', '6353', '6354', '6356', '636', '6360', '6364', '6368', '6376', '6384', '6385', '6386', '6388', '6392', '6396', '64', '6464', '6472', '6480', '6481', '6482', '6484', '6488', '6492', '6496', '6504', '6512', '6513', '6514', '6516', '6520', '6524', '6720', '6728', '6736', '6737', '6738', '6740', '6744', '6748', '6752', '6760', '6768', '6769', '6770', '6772', '6776', '6780', '6848', '6856', '6864', '6865', '6866', '6868', '6872', '6876', '6880', '6888', '6896', '6897', '6898', '6900', '6904', '6908', '704', '712', '72', '720', '721', '722', '7232', '724', '7240', '7248', '7249', '7250', '7252', '7256', '7260', '7264', '7272', '728', '7280', '7281', '7282', '7284', '7288', '7292', '732', '736', '7360', '7368', '7376', '7377', '7378', '7380', '7384', '7388', '7392', '7400', '7408', '7409', '7410', '7412', '7416', '7420', '744', '7488', '7496', '7504', '7505', '7506', '7508', '7512', '7516', '752', '7520', '7528', '753', '7536', '7537', '7538', '754', '7540', '7544', '7548', '756', '760', '764', '7744', '7752', '7760', '7761', '7762', '7764', '7768', '7772', '7776', '7784', '7792', '7793', '7794', '7796', '7800', '7804', '7872', '7880', '7888', '7889', '7890', '7892', '7896', '7900', '7904', '7912', '7920', '7921', '7922', '7924', '7928', '7932', '80', '81', '82', '84', '88', '92', '96')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'context_on_site_market_api'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 2)
) FORMAT JSONCompact

SELECT
    `context_on_site_market_api`.`campaign_id` AS `campaign_id`,
    `context_on_site_market_api`.`id` AS `id`
FROM `context_on_site_market_api`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'context_on_site_market_api'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 2)
) FORMAT JSONCompact

SELECT
    `context_on_site_market_api`.`campaign_id` AS `campaign_id`,
    `context_on_site_market_api`.`id` AS `id`
FROM `context_on_site_market_api`
WHERE (
    (
        `context_on_site_market_api`.`campaign_id` = '1'
        AND `context_on_site_market_api`.`id` IN ('1')
    )
    OR (
        `context_on_site_market_api`.`campaign_id` = '2'
        AND `context_on_site_market_api`.`id` IN ('1', '2')
    )
)

SELECT
    `context_on_site_campaign`.`id` AS `id`
FROM `context_on_site_campaign`
WHERE (
    (
        `context_on_site_campaign`.`page_id` IN ('1', '2')
    )
    AND (
        `context_on_site_campaign`.`multistate` IN ('104', '1088', '1096', '1104', '1105', '1106', '1108', '1112', '1116', '112', '1120', '1128', '113', '1136', '1137', '1138', '114', '1140', '1144', '1148', '116', '120', '1216', '1224', '1232', '1233', '1234', '1236', '124', '1240', '1244', '1248', '1256', '1264', '1265', '1266', '1268', '1272', '1276', '1344', '1352', '1360', '1361', '1362', '1364', '1368', '1372', '1376', '1384', '1392', '1393', '1394', '1396', '1400', '1404', '1600', '1608', '1616', '1617', '1618', '1620', '1624', '1628', '1632', '1640', '1648', '1649', '1650', '1652', '1656', '1660', '1728', '1736', '1744', '1745', '1746', '1748', '1752', '1756', '1760', '1768', '1776', '1777', '1778', '1780', '1784', '1788', '192', '200', '208', '209', '210', '2112', '212', '2120', '2128', '2129', '2130', '2132', '2136', '2140', '2144', '2152', '216', '2160', '2161', '2162', '2164', '2168', '2172', '220', '224', '2240', '2248', '2256', '2257', '2258', '2260', '2264', '2268', '2272', '2280', '2288', '2289', '2290', '2292', '2296', '2300', '232', '2368', '2376', '2384', '2385', '2386', '2388', '2392', '2396', '240', '2400', '2408', '241', '2416', '2417', '2418', '242', '2420', '2424', '2428', '244', '248', '252', '2624', '2632', '2640', '2641', '2642', '2644', '2648', '2652', '2656', '2664', '2672', '2673', '2674', '2676', '2680', '2684', '2752', '2760', '2768', '2769', '2770', '2772', '2776', '2780', '2784', '2792', '2800', '2801', '2802', '2804', '2808', '2812', '3136', '3144', '3152', '3153', '3154', '3156', '3160', '3164', '3168', '3176', '3184', '3185', '3186', '3188', '3192', '3196', '320', '3264', '3272', '328', '3280', '3281', '3282', '3284', '3288', '3292', '3296', '3304', '3312', '3313', '3314', '3316', '3320', '3324', '336', '337', '338', '3392', '340', '3400', '3408', '3409', '3410', '3412', '3416', '3420', '3424', '3432', '344', '3440', '3441', '3442', '3444', '3448', '3452', '348', '352', '360', '3648', '3656', '3664', '3665', '3666', '3668', '3672', '3676', '368', '3680', '3688', '369', '3696', '3697', '3698', '370', '3700', '3704', '3708', '372', '376', '3776', '3784', '3792', '3793', '3794', '3796', '380', '3800', '3804', '3808', '3816', '3824', '3825', '3826', '3828', '3832', '3836', '4160', '4168', '4176', '4177', '4178', '4180', '4184', '4188', '4192', '4200', '4208', '4209', '4210', '4212', '4216', '4220', '4288', '4296', '4304', '4305', '4306', '4308', '4312', '4316', '4320', '4328', '4336', '4337', '4338', '4340', '4344', '4348', '4416', '4424', '4432', '4433', '4434', '4436', '4440', '4444', '4448', '4456', '4464', '4465', '4466', '4468', '4472', '4476', '4672', '4680', '4688', '4689', '4690', '4692', '4696', '4700', '4704', '4712', '4720', '4721', '4722', '4724', '4728', '4732', '4800', '4808', '4816', '4817', '4818', '4820', '4824', '4828', '4832', '4840', '4848', '4849', '4850', '4852', '4856', '4860', '5184', '5192', '5200', '5201', '5202', '5204', '5208', '5212', '5216', '5224', '5232', '5233', '5234', '5236', '5240', '5244', '5312', '5320', '5328', '5329', '5330', '5332', '5336', '5340', '5344', '5352', '5360', '5361', '5362', '5364', '5368', '5372', '5440', '5448', '5456', '5457', '5458', '5460', '5464', '5468', '5472', '5480', '5488', '5489', '5490', '5492', '5496', '5500', '5696', '5704', '5712', '5713', '5714', '5716', '5720', '5724', '5728', '5736', '5744', '5745', '5746', '5748', '5752', '5756', '576', '5824', '5832', '584', '5840', '5841', '5842', '5844', '5848', '5852', '5856', '5864', '5872', '5873', '5874', '5876', '5880', '5884', '592', '593', '594', '596', '600', '604', '608', '616', '6208', '6216', '6224', '6225', '6226', '6228', '6232', '6236', '624', '6240', '6248', '625', '6256', '6257', '6258', '626', '6260', '6264', '6268', '628', '632', '6336', '6344', '6352', '6353', '6354', '6356', '636', '6360', '6364', '6368', '6376', '6384', '6385', '6386', '6388', '6392', '6396', '64', '6464', '6472', '6480', '6481', '6482', '6484', '6488', '6492', '6496', '6504', '6512', '6513', '6514', '6516', '6520', '6524', '6720', '6728', '6736', '6737', '6738', '6740', '6744', '6748', '6752', '6760', '6768', '6769', '6770', '6772', '6776', '6780', '6848', '6856', '6864', '6865', '6866', '6868', '6872', '6876', '6880', '6888', '6896', '6897', '6898', '6900', '6904', '6908', '704', '712', '72', '720', '721', '722', '7232', '724', '7240', '7248', '7249', '7250', '7252', '7256', '7260', '7264', '7272', '728', '7280', '7281', '7282', '7284', '7288', '7292', '732', '736', '7360', '7368', '7376', '7377', '7378', '7380', '7384', '7388', '7392', '7400', '7408', '7409', '7410', '7412', '7416', '7420', '744', '7488', '7496', '7504', '7505', '7506', '7508', '7512', '7516', '752', '7520', '7528', '753', '7536', '7537', '7538', '754', '7540', '7544', '7548', '756', '760', '764', '7744', '7752', '7760', '7761', '7762', '7764', '7768', '7772', '7776', '7784', '7792', '7793', '7794', '7796', '7800', '7804', '7872', '7880', '7888', '7889', '7890', '7892', '7896', '7900', '7904', '7912', '7920', '7921', '7922', '7924', '7928', '7932', '80', '81', '82', '84', '88', '92', '96')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'context_on_site_mcb'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 2)
) FORMAT JSONCompact

SELECT
    `context_on_site_mcb`.`campaign_id` AS `campaign_id`,
    `context_on_site_mcb`.`id` AS `id`
FROM `context_on_site_mcb`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'context_on_site_mcb'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 2)
) FORMAT JSONCompact

SELECT
    `context_on_site_mcb`.`campaign_id` AS `campaign_id`,
    `context_on_site_mcb`.`id` AS `id`
FROM `context_on_site_mcb`
WHERE (
    (
        `context_on_site_mcb`.`campaign_id` = '1'
        AND `context_on_site_mcb`.`id` IN ('1')
    )
    OR (
        `context_on_site_mcb`.`campaign_id` = '2'
        AND `context_on_site_mcb`.`id` IN ('1', '2')
    )
)

SELECT
    `context_on_site_campaign`.`id` AS `id`
FROM `context_on_site_campaign`
WHERE (
    (
        `context_on_site_campaign`.`page_id` IN ('1', '2')
    )
    AND (
        `context_on_site_campaign`.`multistate` IN ('104', '1088', '1096', '1104', '1105', '1106', '1108', '1112', '1116', '112', '1120', '1128', '113', '1136', '1137', '1138', '114', '1140', '1144', '1148', '116', '120', '1216', '1224', '1232', '1233', '1234', '1236', '124', '1240', '1244', '1248', '1256', '1264', '1265', '1266', '1268', '1272', '1276', '1344', '1352', '1360', '1361', '1362', '1364', '1368', '1372', '1376', '1384', '1392', '1393', '1394', '1396', '1400', '1404', '1600', '1608', '1616', '1617', '1618', '1620', '1624', '1628', '1632', '1640', '1648', '1649', '1650', '1652', '1656', '1660', '1728', '1736', '1744', '1745', '1746', '1748', '1752', '1756', '1760', '1768', '1776', '1777', '1778', '1780', '1784', '1788', '192', '200', '208', '209', '210', '2112', '212', '2120', '2128', '2129', '2130', '2132', '2136', '2140', '2144', '2152', '216', '2160', '2161', '2162', '2164', '2168', '2172', '220', '224', '2240', '2248', '2256', '2257', '2258', '2260', '2264', '2268', '2272', '2280', '2288', '2289', '2290', '2292', '2296', '2300', '232', '2368', '2376', '2384', '2385', '2386', '2388', '2392', '2396', '240', '2400', '2408', '241', '2416', '2417', '2418', '242', '2420', '2424', '2428', '244', '248', '252', '2624', '2632', '2640', '2641', '2642', '2644', '2648', '2652', '2656', '2664', '2672', '2673', '2674', '2676', '2680', '2684', '2752', '2760', '2768', '2769', '2770', '2772', '2776', '2780', '2784', '2792', '2800', '2801', '2802', '2804', '2808', '2812', '3136', '3144', '3152', '3153', '3154', '3156', '3160', '3164', '3168', '3176', '3184', '3185', '3186', '3188', '3192', '3196', '320', '3264', '3272', '328', '3280', '3281', '3282', '3284', '3288', '3292', '3296', '3304', '3312', '3313', '3314', '3316', '3320', '3324', '336', '337', '338', '3392', '340', '3400', '3408', '3409', '3410', '3412', '3416', '3420', '3424', '3432', '344', '3440', '3441', '3442', '3444', '3448', '3452', '348', '352', '360', '3648', '3656', '3664', '3665', '3666', '3668', '3672', '3676', '368', '3680', '3688', '369', '3696', '3697', '3698', '370', '3700', '3704', '3708', '372', '376', '3776', '3784', '3792', '3793', '3794', '3796', '380', '3800', '3804', '3808', '3816', '3824', '3825', '3826', '3828', '3832', '3836', '4160', '4168', '4176', '4177', '4178', '4180', '4184', '4188', '4192', '4200', '4208', '4209', '4210', '4212', '4216', '4220', '4288', '4296', '4304', '4305', '4306', '4308', '4312', '4316', '4320', '4328', '4336', '4337', '4338', '4340', '4344', '4348', '4416', '4424', '4432', '4433', '4434', '4436', '4440', '4444', '4448', '4456', '4464', '4465', '4466', '4468', '4472', '4476', '4672', '4680', '4688', '4689', '4690', '4692', '4696', '4700', '4704', '4712', '4720', '4721', '4722', '4724', '4728', '4732', '4800', '4808', '4816', '4817', '4818', '4820', '4824', '4828', '4832', '4840', '4848', '4849', '4850', '4852', '4856', '4860', '5184', '5192', '5200', '5201', '5202', '5204', '5208', '5212', '5216', '5224', '5232', '5233', '5234', '5236', '5240', '5244', '5312', '5320', '5328', '5329', '5330', '5332', '5336', '5340', '5344', '5352', '5360', '5361', '5362', '5364', '5368', '5372', '5440', '5448', '5456', '5457', '5458', '5460', '5464', '5468', '5472', '5480', '5488', '5489', '5490', '5492', '5496', '5500', '5696', '5704', '5712', '5713', '5714', '5716', '5720', '5724', '5728', '5736', '5744', '5745', '5746', '5748', '5752', '5756', '576', '5824', '5832', '584', '5840', '5841', '5842', '5844', '5848', '5852', '5856', '5864', '5872', '5873', '5874', '5876', '5880', '5884', '592', '593', '594', '596', '600', '604', '608', '616', '6208', '6216', '6224', '6225', '6226', '6228', '6232', '6236', '624', '6240', '6248', '625', '6256', '6257', '6258', '626', '6260', '6264', '6268', '628', '632', '6336', '6344', '6352', '6353', '6354', '6356', '636', '6360', '6364', '6368', '6376', '6384', '6385', '6386', '6388', '6392', '6396', '64', '6464', '6472', '6480', '6481', '6482', '6484', '6488', '6492', '6496', '6504', '6512', '6513', '6514', '6516', '6520', '6524', '6720', '6728', '6736', '6737', '6738', '6740', '6744', '6748', '6752', '6760', '6768', '6769', '6770', '6772', '6776', '6780', '6848', '6856', '6864', '6865', '6866', '6868', '6872', '6876', '6880', '6888', '6896', '6897', '6898', '6900', '6904', '6908', '704', '712', '72', '720', '721', '722', '7232', '724', '7240', '7248', '7249', '7250', '7252', '7256', '7260', '7264', '7272', '728', '7280', '7281', '7282', '7284', '7288', '7292', '732', '736', '7360', '7368', '7376', '7377', '7378', '7380', '7384', '7388', '7392', '7400', '7408', '7409', '7410', '7412', '7416', '7420', '744', '7488', '7496', '7504', '7505', '7506', '7508', '7512', '7516', '752', '7520', '7528', '753', '7536', '7537', '7538', '754', '7540', '7544', '7548', '756', '760', '764', '7744', '7752', '7760', '7761', '7762', '7764', '7768', '7772', '7776', '7784', '7792', '7793', '7794', '7796', '7800', '7804', '7872', '7880', '7888', '7889', '7890', '7892', '7896', '7900', '7904', '7912', '7920', '7921', '7922', '7924', '7928', '7932', '80', '81', '82', '84', '88', '92', '96')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'context_on_site_natural'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `context_on_site_natural`.`campaign_id` AS `campaign_id`,
    `context_on_site_natural`.`id` AS `id`
FROM `context_on_site_natural`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'context_on_site_natural'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `context_on_site_natural`.`campaign_id` AS `campaign_id`,
    `context_on_site_natural`.`id` AS `id`
FROM `context_on_site_natural`
WHERE (
    (
        `context_on_site_natural`.`campaign_id` = '1'
        AND `context_on_site_natural`.`id` IN ('1')
    )
    OR (
        `context_on_site_natural`.`campaign_id` = '2'
        AND `context_on_site_natural`.`id` IN ('1', '2')
    )
)

SELECT
    `context_on_site_campaign`.`id` AS `id`
FROM `context_on_site_campaign`
WHERE (
    (
        `context_on_site_campaign`.`page_id` IN ('1', '2')
    )
    AND (
        `context_on_site_campaign`.`multistate` IN ('104', '1088', '1096', '1104', '1105', '1106', '1108', '1112', '1116', '112', '1120', '1128', '113', '1136', '1137', '1138', '114', '1140', '1144', '1148', '116', '120', '1216', '1224', '1232', '1233', '1234', '1236', '124', '1240', '1244', '1248', '1256', '1264', '1265', '1266', '1268', '1272', '1276', '1344', '1352', '1360', '1361', '1362', '1364', '1368', '1372', '1376', '1384', '1392', '1393', '1394', '1396', '1400', '1404', '1600', '1608', '1616', '1617', '1618', '1620', '1624', '1628', '1632', '1640', '1648', '1649', '1650', '1652', '1656', '1660', '1728', '1736', '1744', '1745', '1746', '1748', '1752', '1756', '1760', '1768', '1776', '1777', '1778', '1780', '1784', '1788', '192', '200', '208', '209', '210', '2112', '212', '2120', '2128', '2129', '2130', '2132', '2136', '2140', '2144', '2152', '216', '2160', '2161', '2162', '2164', '2168', '2172', '220', '224', '2240', '2248', '2256', '2257', '2258', '2260', '2264', '2268', '2272', '2280', '2288', '2289', '2290', '2292', '2296', '2300', '232', '2368', '2376', '2384', '2385', '2386', '2388', '2392', '2396', '240', '2400', '2408', '241', '2416', '2417', '2418', '242', '2420', '2424', '2428', '244', '248', '252', '2624', '2632', '2640', '2641', '2642', '2644', '2648', '2652', '2656', '2664', '2672', '2673', '2674', '2676', '2680', '2684', '2752', '2760', '2768', '2769', '2770', '2772', '2776', '2780', '2784', '2792', '2800', '2801', '2802', '2804', '2808', '2812', '3136', '3144', '3152', '3153', '3154', '3156', '3160', '3164', '3168', '3176', '3184', '3185', '3186', '3188', '3192', '3196', '320', '3264', '3272', '328', '3280', '3281', '3282', '3284', '3288', '3292', '3296', '3304', '3312', '3313', '3314', '3316', '3320', '3324', '336', '337', '338', '3392', '340', '3400', '3408', '3409', '3410', '3412', '3416', '3420', '3424', '3432', '344', '3440', '3441', '3442', '3444', '3448', '3452', '348', '352', '360', '3648', '3656', '3664', '3665', '3666', '3668', '3672', '3676', '368', '3680', '3688', '369', '3696', '3697', '3698', '370', '3700', '3704', '3708', '372', '376', '3776', '3784', '3792', '3793', '3794', '3796', '380', '3800', '3804', '3808', '3816', '3824', '3825', '3826', '3828', '3832', '3836', '4160', '4168', '4176', '4177', '4178', '4180', '4184', '4188', '4192', '4200', '4208', '4209', '4210', '4212', '4216', '4220', '4288', '4296', '4304', '4305', '4306', '4308', '4312', '4316', '4320', '4328', '4336', '4337', '4338', '4340', '4344', '4348', '4416', '4424', '4432', '4433', '4434', '4436', '4440', '4444', '4448', '4456', '4464', '4465', '4466', '4468', '4472', '4476', '4672', '4680', '4688', '4689', '4690', '4692', '4696', '4700', '4704', '4712', '4720', '4721', '4722', '4724', '4728', '4732', '4800', '4808', '4816', '4817', '4818', '4820', '4824', '4828', '4832', '4840', '4848', '4849', '4850', '4852', '4856', '4860', '5184', '5192', '5200', '5201', '5202', '5204', '5208', '5212', '5216', '5224', '5232', '5233', '5234', '5236', '5240', '5244', '5312', '5320', '5328', '5329', '5330', '5332', '5336', '5340', '5344', '5352', '5360', '5361', '5362', '5364', '5368', '5372', '5440', '5448', '5456', '5457', '5458', '5460', '5464', '5468', '5472', '5480', '5488', '5489', '5490', '5492', '5496', '5500', '5696', '5704', '5712', '5713', '5714', '5716', '5720', '5724', '5728', '5736', '5744', '5745', '5746', '5748', '5752', '5756', '576', '5824', '5832', '584', '5840', '5841', '5842', '5844', '5848', '5852', '5856', '5864', '5872', '5873', '5874', '5876', '5880', '5884', '592', '593', '594', '596', '600', '604', '608', '616', '6208', '6216', '6224', '6225', '6226', '6228', '6232', '6236', '624', '6240', '6248', '625', '6256', '6257', '6258', '626', '6260', '6264', '6268', '628', '632', '6336', '6344', '6352', '6353', '6354', '6356', '636', '6360', '6364', '6368', '6376', '6384', '6385', '6386', '6388', '6392', '6396', '64', '6464', '6472', '6480', '6481', '6482', '6484', '6488', '6492', '6496', '6504', '6512', '6513', '6514', '6516', '6520', '6524', '6720', '6728', '6736', '6737', '6738', '6740', '6744', '6748', '6752', '6760', '6768', '6769', '6770', '6772', '6776', '6780', '6848', '6856', '6864', '6865', '6866', '6868', '6872', '6876', '6880', '6888', '6896', '6897', '6898', '6900', '6904', '6908', '704', '712', '72', '720', '721', '722', '7232', '724', '7240', '7248', '7249', '7250', '7252', '7256', '7260', '7264', '7272', '728', '7280', '7281', '7282', '7284', '7288', '7292', '732', '736', '7360', '7368', '7376', '7377', '7378', '7380', '7384', '7388', '7392', '7400', '7408', '7409', '7410', '7412', '7416', '7420', '744', '7488', '7496', '7504', '7505', '7506', '7508', '7512', '7516', '752', '7520', '7528', '753', '7536', '7537', '7538', '754', '7540', '7544', '7548', '756', '760', '764', '7744', '7752', '7760', '7761', '7762', '7764', '7768', '7772', '7776', '7784', '7792', '7793', '7794', '7796', '7800', '7804', '7872', '7880', '7888', '7889', '7890', '7892', '7896', '7900', '7904', '7912', '7920', '7921', '7922', '7924', '7928', '7932', '80', '81', '82', '84', '88', '92', '96')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'context_on_site_rtb'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `context_on_site_rtb`.`active` AS `active`,
    `context_on_site_rtb`.`campaign_id` AS `campaign_id`,
    `context_on_site_rtb`.`id` AS `id`
FROM `context_on_site_rtb`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'context_on_site_rtb'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `context_on_site_rtb`.`active` AS `active`,
    `context_on_site_rtb`.`campaign_id` AS `campaign_id`,
    `context_on_site_rtb`.`id` AS `id`
FROM `context_on_site_rtb`
WHERE (
    (
        `context_on_site_rtb`.`campaign_id` = '1'
        AND `context_on_site_rtb`.`id` IN ('1')
    )
    OR (
        `context_on_site_rtb`.`campaign_id` = '2'
        AND `context_on_site_rtb`.`id` IN ('1', '2')
    )
)

SELECT
    `context_on_site_campaign`.`id` AS `id`
FROM `context_on_site_campaign`
WHERE (
    (
        `context_on_site_campaign`.`page_id` IN ('2')
    )
    AND (
        `context_on_site_campaign`.`multistate` IN ('104', '1088', '1096', '1104', '1105', '1106', '1108', '1112', '1116', '112', '1120', '1128', '113', '1136', '1137', '1138', '114', '1140', '1144', '1148', '116', '120', '1216', '1224', '1232', '1233', '1234', '1236', '124', '1240', '1244', '1248', '1256', '1264', '1265', '1266', '1268', '1272', '1276', '1344', '1352', '1360', '1361', '1362', '1364', '1368', '1372', '1376', '1384', '1392', '1393', '1394', '1396', '1400', '1404', '1600', '1608', '1616', '1617', '1618', '1620', '1624', '1628', '1632', '1640', '1648', '1649', '1650', '1652', '1656', '1660', '1728', '1736', '1744', '1745', '1746', '1748', '1752', '1756', '1760', '1768', '1776', '1777', '1778', '1780', '1784', '1788', '192', '200', '208', '209', '210', '2112', '212', '2120', '2128', '2129', '2130', '2132', '2136', '2140', '2144', '2152', '216', '2160', '2161', '2162', '2164', '2168', '2172', '220', '224', '2240', '2248', '2256', '2257', '2258', '2260', '2264', '2268', '2272', '2280', '2288', '2289', '2290', '2292', '2296', '2300', '232', '2368', '2376', '2384', '2385', '2386', '2388', '2392', '2396', '240', '2400', '2408', '241', '2416', '2417', '2418', '242', '2420', '2424', '2428', '244', '248', '252', '2624', '2632', '2640', '2641', '2642', '2644', '2648', '2652', '2656', '2664', '2672', '2673', '2674', '2676', '2680', '2684', '2752', '2760', '2768', '2769', '2770', '2772', '2776', '2780', '2784', '2792', '2800', '2801', '2802', '2804', '2808', '2812', '3136', '3144', '3152', '3153', '3154', '3156', '3160', '3164', '3168', '3176', '3184', '3185', '3186', '3188', '3192', '3196', '320', '3264', '3272', '328', '3280', '3281', '3282', '3284', '3288', '3292', '3296', '3304', '3312', '3313', '3314', '3316', '3320', '3324', '336', '337', '338', '3392', '340', '3400', '3408', '3409', '3410', '3412', '3416', '3420', '3424', '3432', '344', '3440', '3441', '3442', '3444', '3448', '3452', '348', '352', '360', '3648', '3656', '3664', '3665', '3666', '3668', '3672', '3676', '368', '3680', '3688', '369', '3696', '3697', '3698', '370', '3700', '3704', '3708', '372', '376', '3776', '3784', '3792', '3793', '3794', '3796', '380', '3800', '3804', '3808', '3816', '3824', '3825', '3826', '3828', '3832', '3836', '4160', '4168', '4176', '4177', '4178', '4180', '4184', '4188', '4192', '4200', '4208', '4209', '4210', '4212', '4216', '4220', '4288', '4296', '4304', '4305', '4306', '4308', '4312', '4316', '4320', '4328', '4336', '4337', '4338', '4340', '4344', '4348', '4416', '4424', '4432', '4433', '4434', '4436', '4440', '4444', '4448', '4456', '4464', '4465', '4466', '4468', '4472', '4476', '4672', '4680', '4688', '4689', '4690', '4692', '4696', '4700', '4704', '4712', '4720', '4721', '4722', '4724', '4728', '4732', '4800', '4808', '4816', '4817', '4818', '4820', '4824', '4828', '4832', '4840', '4848', '4849', '4850', '4852', '4856', '4860', '5184', '5192', '5200', '5201', '5202', '5204', '5208', '5212', '5216', '5224', '5232', '5233', '5234', '5236', '5240', '5244', '5312', '5320', '5328', '5329', '5330', '5332', '5336', '5340', '5344', '5352', '5360', '5361', '5362', '5364', '5368', '5372', '5440', '5448', '5456', '5457', '5458', '5460', '5464', '5468', '5472', '5480', '5488', '5489', '5490', '5492', '5496', '5500', '5696', '5704', '5712', '5713', '5714', '5716', '5720', '5724', '5728', '5736', '5744', '5745', '5746', '5748', '5752', '5756', '576', '5824', '5832', '584', '5840', '5841', '5842', '5844', '5848', '5852', '5856', '5864', '5872', '5873', '5874', '5876', '5880', '5884', '592', '593', '594', '596', '600', '604', '608', '616', '6208', '6216', '6224', '6225', '6226', '6228', '6232', '6236', '624', '6240', '6248', '625', '6256', '6257', '6258', '626', '6260', '6264', '6268', '628', '632', '6336', '6344', '6352', '6353', '6354', '6356', '636', '6360', '6364', '6368', '6376', '6384', '6385', '6386', '6388', '6392', '6396', '64', '6464', '6472', '6480', '6481', '6482', '6484', '6488', '6492', '6496', '6504', '6512', '6513', '6514', '6516', '6520', '6524', '6720', '6728', '6736', '6737', '6738', '6740', '6744', '6748', '6752', '6760', '6768', '6769', '6770', '6772', '6776', '6780', '6848', '6856', '6864', '6865', '6866', '6868', '6872', '6876', '6880', '6888', '6896', '6897', '6898', '6900', '6904', '6908', '704', '712', '72', '720', '721', '722', '7232', '724', '7240', '7248', '7249', '7250', '7252', '7256', '7260', '7264', '7272', '728', '7280', '7281', '7282', '7284', '7288', '7292', '732', '736', '7360', '7368', '7376', '7377', '7378', '7380', '7384', '7388', '7392', '7400', '7408', '7409', '7410', '7412', '7416', '7420', '744', '7488', '7496', '7504', '7505', '7506', '7508', '7512', '7516', '752', '7520', '7528', '753', '7536', '7537', '7538', '754', '7540', '7544', '7548', '756', '760', '764', '7744', '7752', '7760', '7761', '7762', '7764', '7768', '7772', '7776', '7784', '7792', '7793', '7794', '7796', '7800', '7804', '7872', '7880', '7888', '7889', '7890', '7892', '7896', '7900', '7904', '7912', '7920', '7921', '7922', '7924', '7928', '7932', '80', '81', '82', '84', '88', '92', '96')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'context_on_site_stripe'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `context_on_site_stripe`.`campaign_id` AS `campaign_id`,
    `context_on_site_stripe`.`id` AS `id`
FROM `context_on_site_stripe`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'context_on_site_stripe'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `context_on_site_stripe`.`campaign_id` AS `campaign_id`,
    `context_on_site_stripe`.`id` AS `id`
FROM `context_on_site_stripe`
WHERE (
    (
        `context_on_site_stripe`.`campaign_id` = '1'
        AND `context_on_site_stripe`.`id` IN ('1')
    )
    OR (
        `context_on_site_stripe`.`campaign_id` = '2'
        AND `context_on_site_stripe`.`id` IN ('1', '2')
    )
)

SELECT
    `context_on_site_campaign`.`id` AS `id`
FROM `context_on_site_campaign`
WHERE (
    (
        `context_on_site_campaign`.`page_id` IN ('1', '2')
    )
    AND (
        `context_on_site_campaign`.`multistate` IN ('104', '1088', '1096', '1104', '1105', '1106', '1108', '1112', '1116', '112', '1120', '1128', '113', '1136', '1137', '1138', '114', '1140', '1144', '1148', '116', '120', '1216', '1224', '1232', '1233', '1234', '1236', '124', '1240', '1244', '1248', '1256', '1264', '1265', '1266', '1268', '1272', '1276', '1344', '1352', '1360', '1361', '1362', '1364', '1368', '1372', '1376', '1384', '1392', '1393', '1394', '1396', '1400', '1404', '1600', '1608', '1616', '1617', '1618', '1620', '1624', '1628', '1632', '1640', '1648', '1649', '1650', '1652', '1656', '1660', '1728', '1736', '1744', '1745', '1746', '1748', '1752', '1756', '1760', '1768', '1776', '1777', '1778', '1780', '1784', '1788', '192', '200', '208', '209', '210', '2112', '212', '2120', '2128', '2129', '2130', '2132', '2136', '2140', '2144', '2152', '216', '2160', '2161', '2162', '2164', '2168', '2172', '220', '224', '2240', '2248', '2256', '2257', '2258', '2260', '2264', '2268', '2272', '2280', '2288', '2289', '2290', '2292', '2296', '2300', '232', '2368', '2376', '2384', '2385', '2386', '2388', '2392', '2396', '240', '2400', '2408', '241', '2416', '2417', '2418', '242', '2420', '2424', '2428', '244', '248', '252', '2624', '2632', '2640', '2641', '2642', '2644', '2648', '2652', '2656', '2664', '2672', '2673', '2674', '2676', '2680', '2684', '2752', '2760', '2768', '2769', '2770', '2772', '2776', '2780', '2784', '2792', '2800', '2801', '2802', '2804', '2808', '2812', '3136', '3144', '3152', '3153', '3154', '3156', '3160', '3164', '3168', '3176', '3184', '3185', '3186', '3188', '3192', '3196', '320', '3264', '3272', '328', '3280', '3281', '3282', '3284', '3288', '3292', '3296', '3304', '3312', '3313', '3314', '3316', '3320', '3324', '336', '337', '338', '3392', '340', '3400', '3408', '3409', '3410', '3412', '3416', '3420', '3424', '3432', '344', '3440', '3441', '3442', '3444', '3448', '3452', '348', '352', '360', '3648', '3656', '3664', '3665', '3666', '3668', '3672', '3676', '368', '3680', '3688', '369', '3696', '3697', '3698', '370', '3700', '3704', '3708', '372', '376', '3776', '3784', '3792', '3793', '3794', '3796', '380', '3800', '3804', '3808', '3816', '3824', '3825', '3826', '3828', '3832', '3836', '4160', '4168', '4176', '4177', '4178', '4180', '4184', '4188', '4192', '4200', '4208', '4209', '4210', '4212', '4216', '4220', '4288', '4296', '4304', '4305', '4306', '4308', '4312', '4316', '4320', '4328', '4336', '4337', '4338', '4340', '4344', '4348', '4416', '4424', '4432', '4433', '4434', '4436', '4440', '4444', '4448', '4456', '4464', '4465', '4466', '4468', '4472', '4476', '4672', '4680', '4688', '4689', '4690', '4692', '4696', '4700', '4704', '4712', '4720', '4721', '4722', '4724', '4728', '4732', '4800', '4808', '4816', '4817', '4818', '4820', '4824', '4828', '4832', '4840', '4848', '4849', '4850', '4852', '4856', '4860', '5184', '5192', '5200', '5201', '5202', '5204', '5208', '5212', '5216', '5224', '5232', '5233', '5234', '5236', '5240', '5244', '5312', '5320', '5328', '5329', '5330', '5332', '5336', '5340', '5344', '5352', '5360', '5361', '5362', '5364', '5368', '5372', '5440', '5448', '5456', '5457', '5458', '5460', '5464', '5468', '5472', '5480', '5488', '5489', '5490', '5492', '5496', '5500', '5696', '5704', '5712', '5713', '5714', '5716', '5720', '5724', '5728', '5736', '5744', '5745', '5746', '5748', '5752', '5756', '576', '5824', '5832', '584', '5840', '5841', '5842', '5844', '5848', '5852', '5856', '5864', '5872', '5873', '5874', '5876', '5880', '5884', '592', '593', '594', '596', '600', '604', '608', '616', '6208', '6216', '6224', '6225', '6226', '6228', '6232', '6236', '624', '6240', '6248', '625', '6256', '6257', '6258', '626', '6260', '6264', '6268', '628', '632', '6336', '6344', '6352', '6353', '6354', '6356', '636', '6360', '6364', '6368', '6376', '6384', '6385', '6386', '6388', '6392', '6396', '64', '6464', '6472', '6480', '6481', '6482', '6484', '6488', '6492', '6496', '6504', '6512', '6513', '6514', '6516', '6520', '6524', '6720', '6728', '6736', '6737', '6738', '6740', '6744', '6748', '6752', '6760', '6768', '6769', '6770', '6772', '6776', '6780', '6848', '6856', '6864', '6865', '6866', '6868', '6872', '6876', '6880', '6888', '6896', '6897', '6898', '6900', '6904', '6908', '704', '712', '72', '720', '721', '722', '7232', '724', '7240', '7248', '7249', '7250', '7252', '7256', '7260', '7264', '7272', '728', '7280', '7281', '7282', '7284', '7288', '7292', '732', '736', '7360', '7368', '7376', '7377', '7378', '7380', '7384', '7388', '7392', '7400', '7408', '7409', '7410', '7412', '7416', '7420', '744', '7488', '7496', '7504', '7505', '7506', '7508', '7512', '7516', '752', '7520', '7528', '753', '7536', '7537', '7538', '754', '7540', '7544', '7548', '756', '760', '764', '7744', '7752', '7760', '7761', '7762', '7764', '7768', '7772', '7776', '7784', '7792', '7793', '7794', '7796', '7800', '7804', '7872', '7880', '7888', '7889', '7890', '7892', '7896', '7900', '7904', '7912', '7920', '7921', '7922', '7924', '7928', '7932', '80', '81', '82', '84', '88', '92', '96')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'search_on_site_direct'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `search_on_site_direct`.`campaign_id` AS `campaign_id`,
    `search_on_site_direct`.`id` AS `id`
FROM `search_on_site_direct`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'search_on_site_direct'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `search_on_site_direct`.`campaign_id` AS `campaign_id`,
    `search_on_site_direct`.`id` AS `id`
FROM `search_on_site_direct`
WHERE (
    (
        `search_on_site_direct`.`campaign_id` = '1'
        AND `search_on_site_direct`.`id` IN ('1')
    )
    OR (
        `search_on_site_direct`.`campaign_id` = '2'
        AND `search_on_site_direct`.`id` IN ('1', '2')
    )
)

SELECT
    `search_on_site_campaign`.`id` AS `id`
FROM `search_on_site_campaign`
WHERE (
    (
        `search_on_site_campaign`.`page_id` IN ('1', '2')
    )
    AND (
        `search_on_site_campaign`.`multistate` IN ('104', '1088', '1096', '1104', '1105', '1106', '1108', '1112', '1116', '112', '1120', '1128', '113', '1136', '1137', '1138', '114', '1140', '1144', '1148', '116', '120', '1216', '1224', '1232', '1233', '1234', '1236', '124', '1240', '1244', '1248', '1256', '1264', '1265', '1266', '1268', '1272', '1276', '1344', '1352', '1360', '1361', '1362', '1364', '1368', '1372', '1376', '1384', '1392', '1393', '1394', '1396', '1400', '1404', '1600', '1608', '1616', '1617', '1618', '1620', '1624', '1628', '1632', '1640', '1648', '1649', '1650', '1652', '1656', '1660', '1728', '1736', '1744', '1745', '1746', '1748', '1752', '1756', '1760', '1768', '1776', '1777', '1778', '1780', '1784', '1788', '192', '200', '208', '209', '210', '2112', '212', '2120', '2128', '2129', '2130', '2132', '2136', '2140', '2144', '2152', '216', '2160', '2161', '2162', '2164', '2168', '2172', '220', '224', '2240', '2248', '2256', '2257', '2258', '2260', '2264', '2268', '2272', '2280', '2288', '2289', '2290', '2292', '2296', '2300', '232', '2368', '2376', '2384', '2385', '2386', '2388', '2392', '2396', '240', '2400', '2408', '241', '2416', '2417', '2418', '242', '2420', '2424', '2428', '244', '248', '252', '2624', '2632', '2640', '2641', '2642', '2644', '2648', '2652', '2656', '2664', '2672', '2673', '2674', '2676', '2680', '2684', '2752', '2760', '2768', '2769', '2770', '2772', '2776', '2780', '2784', '2792', '2800', '2801', '2802', '2804', '2808', '2812', '3136', '3144', '3152', '3153', '3154', '3156', '3160', '3164', '3168', '3176', '3184', '3185', '3186', '3188', '3192', '3196', '320', '3264', '3272', '328', '3280', '3281', '3282', '3284', '3288', '3292', '3296', '3304', '3312', '3313', '3314', '3316', '3320', '3324', '336', '337', '338', '3392', '340', '3400', '3408', '3409', '3410', '3412', '3416', '3420', '3424', '3432', '344', '3440', '3441', '3442', '3444', '3448', '3452', '348', '352', '360', '3648', '3656', '3664', '3665', '3666', '3668', '3672', '3676', '368', '3680', '3688', '369', '3696', '3697', '3698', '370', '3700', '3704', '3708', '372', '376', '3776', '3784', '3792', '3793', '3794', '3796', '380', '3800', '3804', '3808', '3816', '3824', '3825', '3826', '3828', '3832', '3836', '4160', '4168', '4176', '4177', '4178', '4180', '4184', '4188', '4192', '4200', '4208', '4209', '4210', '4212', '4216', '4220', '4288', '4296', '4304', '4305', '4306', '4308', '4312', '4316', '4320', '4328', '4336', '4337', '4338', '4340', '4344', '4348', '4416', '4424', '4432', '4433', '4434', '4436', '4440', '4444', '4448', '4456', '4464', '4465', '4466', '4468', '4472', '4476', '4672', '4680', '4688', '4689', '4690', '4692', '4696', '4700', '4704', '4712', '4720', '4721', '4722', '4724', '4728', '4732', '4800', '4808', '4816', '4817', '4818', '4820', '4824', '4828', '4832', '4840', '4848', '4849', '4850', '4852', '4856', '4860', '5184', '5192', '5200', '5201', '5202', '5204', '5208', '5212', '5216', '5224', '5232', '5233', '5234', '5236', '5240', '5244', '5312', '5320', '5328', '5329', '5330', '5332', '5336', '5340', '5344', '5352', '5360', '5361', '5362', '5364', '5368', '5372', '5440', '5448', '5456', '5457', '5458', '5460', '5464', '5468', '5472', '5480', '5488', '5489', '5490', '5492', '5496', '5500', '5696', '5704', '5712', '5713', '5714', '5716', '5720', '5724', '5728', '5736', '5744', '5745', '5746', '5748', '5752', '5756', '576', '5824', '5832', '584', '5840', '5841', '5842', '5844', '5848', '5852', '5856', '5864', '5872', '5873', '5874', '5876', '5880', '5884', '592', '593', '594', '596', '600', '604', '608', '616', '6208', '6216', '6224', '6225', '6226', '6228', '6232', '6236', '624', '6240', '6248', '625', '6256', '6257', '6258', '626', '6260', '6264', '6268', '628', '632', '6336', '6344', '6352', '6353', '6354', '6356', '636', '6360', '6364', '6368', '6376', '6384', '6385', '6386', '6388', '6392', '6396', '64', '6464', '6472', '6480', '6481', '6482', '6484', '6488', '6492', '6496', '6504', '6512', '6513', '6514', '6516', '6520', '6524', '6720', '6728', '6736', '6737', '6738', '6740', '6744', '6748', '6752', '6760', '6768', '6769', '6770', '6772', '6776', '6780', '6848', '6856', '6864', '6865', '6866', '6868', '6872', '6876', '6880', '6888', '6896', '6897', '6898', '6900', '6904', '6908', '704', '712', '72', '720', '721', '722', '7232', '724', '7240', '7248', '7249', '7250', '7252', '7256', '7260', '7264', '7272', '728', '7280', '7281', '7282', '7284', '7288', '7292', '732', '736', '7360', '7368', '7376', '7377', '7378', '7380', '7384', '7388', '7392', '7400', '7408', '7409', '7410', '7412', '7416', '7420', '744', '7488', '7496', '7504', '7505', '7506', '7508', '7512', '7516', '752', '7520', '7528', '753', '7536', '7537', '7538', '754', '7540', '7544', '7548', '756', '760', '764', '7744', '7752', '7760', '7761', '7762', '7764', '7768', '7772', '7776', '7784', '7792', '7793', '7794', '7796', '7800', '7804', '7872', '7880', '7888', '7889', '7890', '7892', '7896', '7900', '7904', '7912', '7920', '7921', '7922', '7924', '7928', '7932', '80', '81', '82', '84', '88', '92', '96')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'search_on_site_market'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 2)
) FORMAT JSONCompact

SELECT
    `search_on_site_market`.`campaign_id` AS `campaign_id`,
    `search_on_site_market`.`id` AS `id`
FROM `search_on_site_market`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'search_on_site_market'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 2)
) FORMAT JSONCompact

SELECT
    `search_on_site_market`.`campaign_id` AS `campaign_id`,
    `search_on_site_market`.`id` AS `id`
FROM `search_on_site_market`
WHERE (
    (
        `search_on_site_market`.`campaign_id` = '1'
        AND `search_on_site_market`.`id` IN ('1')
    )
    OR (
        `search_on_site_market`.`campaign_id` = '2'
        AND `search_on_site_market`.`id` IN ('1', '2')
    )
)

SELECT
    `search_on_site_campaign`.`id` AS `id`
FROM `search_on_site_campaign`
WHERE (
    (
        `search_on_site_campaign`.`page_id` IN ('1', '2')
    )
    AND (
        `search_on_site_campaign`.`multistate` IN ('104', '1088', '1096', '1104', '1105', '1106', '1108', '1112', '1116', '112', '1120', '1128', '113', '1136', '1137', '1138', '114', '1140', '1144', '1148', '116', '120', '1216', '1224', '1232', '1233', '1234', '1236', '124', '1240', '1244', '1248', '1256', '1264', '1265', '1266', '1268', '1272', '1276', '1344', '1352', '1360', '1361', '1362', '1364', '1368', '1372', '1376', '1384', '1392', '1393', '1394', '1396', '1400', '1404', '1600', '1608', '1616', '1617', '1618', '1620', '1624', '1628', '1632', '1640', '1648', '1649', '1650', '1652', '1656', '1660', '1728', '1736', '1744', '1745', '1746', '1748', '1752', '1756', '1760', '1768', '1776', '1777', '1778', '1780', '1784', '1788', '192', '200', '208', '209', '210', '2112', '212', '2120', '2128', '2129', '2130', '2132', '2136', '2140', '2144', '2152', '216', '2160', '2161', '2162', '2164', '2168', '2172', '220', '224', '2240', '2248', '2256', '2257', '2258', '2260', '2264', '2268', '2272', '2280', '2288', '2289', '2290', '2292', '2296', '2300', '232', '2368', '2376', '2384', '2385', '2386', '2388', '2392', '2396', '240', '2400', '2408', '241', '2416', '2417', '2418', '242', '2420', '2424', '2428', '244', '248', '252', '2624', '2632', '2640', '2641', '2642', '2644', '2648', '2652', '2656', '2664', '2672', '2673', '2674', '2676', '2680', '2684', '2752', '2760', '2768', '2769', '2770', '2772', '2776', '2780', '2784', '2792', '2800', '2801', '2802', '2804', '2808', '2812', '3136', '3144', '3152', '3153', '3154', '3156', '3160', '3164', '3168', '3176', '3184', '3185', '3186', '3188', '3192', '3196', '320', '3264', '3272', '328', '3280', '3281', '3282', '3284', '3288', '3292', '3296', '3304', '3312', '3313', '3314', '3316', '3320', '3324', '336', '337', '338', '3392', '340', '3400', '3408', '3409', '3410', '3412', '3416', '3420', '3424', '3432', '344', '3440', '3441', '3442', '3444', '3448', '3452', '348', '352', '360', '3648', '3656', '3664', '3665', '3666', '3668', '3672', '3676', '368', '3680', '3688', '369', '3696', '3697', '3698', '370', '3700', '3704', '3708', '372', '376', '3776', '3784', '3792', '3793', '3794', '3796', '380', '3800', '3804', '3808', '3816', '3824', '3825', '3826', '3828', '3832', '3836', '4160', '4168', '4176', '4177', '4178', '4180', '4184', '4188', '4192', '4200', '4208', '4209', '4210', '4212', '4216', '4220', '4288', '4296', '4304', '4305', '4306', '4308', '4312', '4316', '4320', '4328', '4336', '4337', '4338', '4340', '4344', '4348', '4416', '4424', '4432', '4433', '4434', '4436', '4440', '4444', '4448', '4456', '4464', '4465', '4466', '4468', '4472', '4476', '4672', '4680', '4688', '4689', '4690', '4692', '4696', '4700', '4704', '4712', '4720', '4721', '4722', '4724', '4728', '4732', '4800', '4808', '4816', '4817', '4818', '4820', '4824', '4828', '4832', '4840', '4848', '4849', '4850', '4852', '4856', '4860', '5184', '5192', '5200', '5201', '5202', '5204', '5208', '5212', '5216', '5224', '5232', '5233', '5234', '5236', '5240', '5244', '5312', '5320', '5328', '5329', '5330', '5332', '5336', '5340', '5344', '5352', '5360', '5361', '5362', '5364', '5368', '5372', '5440', '5448', '5456', '5457', '5458', '5460', '5464', '5468', '5472', '5480', '5488', '5489', '5490', '5492', '5496', '5500', '5696', '5704', '5712', '5713', '5714', '5716', '5720', '5724', '5728', '5736', '5744', '5745', '5746', '5748', '5752', '5756', '576', '5824', '5832', '584', '5840', '5841', '5842', '5844', '5848', '5852', '5856', '5864', '5872', '5873', '5874', '5876', '5880', '5884', '592', '593', '594', '596', '600', '604', '608', '616', '6208', '6216', '6224', '6225', '6226', '6228', '6232', '6236', '624', '6240', '6248', '625', '6256', '6257', '6258', '626', '6260', '6264', '6268', '628', '632', '6336', '6344', '6352', '6353', '6354', '6356', '636', '6360', '6364', '6368', '6376', '6384', '6385', '6386', '6388', '6392', '6396', '64', '6464', '6472', '6480', '6481', '6482', '6484', '6488', '6492', '6496', '6504', '6512', '6513', '6514', '6516', '6520', '6524', '6720', '6728', '6736', '6737', '6738', '6740', '6744', '6748', '6752', '6760', '6768', '6769', '6770', '6772', '6776', '6780', '6848', '6856', '6864', '6865', '6866', '6868', '6872', '6876', '6880', '6888', '6896', '6897', '6898', '6900', '6904', '6908', '704', '712', '72', '720', '721', '722', '7232', '724', '7240', '7248', '7249', '7250', '7252', '7256', '7260', '7264', '7272', '728', '7280', '7281', '7282', '7284', '7288', '7292', '732', '736', '7360', '7368', '7376', '7377', '7378', '7380', '7384', '7388', '7392', '7400', '7408', '7409', '7410', '7412', '7416', '7420', '744', '7488', '7496', '7504', '7505', '7506', '7508', '7512', '7516', '752', '7520', '7528', '753', '7536', '7537', '7538', '754', '7540', '7544', '7548', '756', '760', '764', '7744', '7752', '7760', '7761', '7762', '7764', '7768', '7772', '7776', '7784', '7792', '7793', '7794', '7796', '7800', '7804', '7872', '7880', '7888', '7889', '7890', '7892', '7896', '7900', '7904', '7912', '7920', '7921', '7922', '7924', '7928', '7932', '80', '81', '82', '84', '88', '92', '96')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'search_on_site_market_api'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 2)
) FORMAT JSONCompact

SELECT
    `search_on_site_market_api`.`campaign_id` AS `campaign_id`,
    `search_on_site_market_api`.`id` AS `id`
FROM `search_on_site_market_api`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'search_on_site_market_api'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 2)
) FORMAT JSONCompact

SELECT
    `search_on_site_market_api`.`campaign_id` AS `campaign_id`,
    `search_on_site_market_api`.`id` AS `id`
FROM `search_on_site_market_api`
WHERE (
    (
        `search_on_site_market_api`.`campaign_id` = '1'
        AND `search_on_site_market_api`.`id` IN ('1')
    )
    OR (
        `search_on_site_market_api`.`campaign_id` = '2'
        AND `search_on_site_market_api`.`id` IN ('1', '2')
    )
)

SELECT
    `search_on_site_campaign`.`id` AS `id`
FROM `search_on_site_campaign`
WHERE (
    (
        `search_on_site_campaign`.`page_id` IN ('1', '2')
    )
    AND (
        `search_on_site_campaign`.`multistate` IN ('104', '1088', '1096', '1104', '1105', '1106', '1108', '1112', '1116', '112', '1120', '1128', '113', '1136', '1137', '1138', '114', '1140', '1144', '1148', '116', '120', '1216', '1224', '1232', '1233', '1234', '1236', '124', '1240', '1244', '1248', '1256', '1264', '1265', '1266', '1268', '1272', '1276', '1344', '1352', '1360', '1361', '1362', '1364', '1368', '1372', '1376', '1384', '1392', '1393', '1394', '1396', '1400', '1404', '1600', '1608', '1616', '1617', '1618', '1620', '1624', '1628', '1632', '1640', '1648', '1649', '1650', '1652', '1656', '1660', '1728', '1736', '1744', '1745', '1746', '1748', '1752', '1756', '1760', '1768', '1776', '1777', '1778', '1780', '1784', '1788', '192', '200', '208', '209', '210', '2112', '212', '2120', '2128', '2129', '2130', '2132', '2136', '2140', '2144', '2152', '216', '2160', '2161', '2162', '2164', '2168', '2172', '220', '224', '2240', '2248', '2256', '2257', '2258', '2260', '2264', '2268', '2272', '2280', '2288', '2289', '2290', '2292', '2296', '2300', '232', '2368', '2376', '2384', '2385', '2386', '2388', '2392', '2396', '240', '2400', '2408', '241', '2416', '2417', '2418', '242', '2420', '2424', '2428', '244', '248', '252', '2624', '2632', '2640', '2641', '2642', '2644', '2648', '2652', '2656', '2664', '2672', '2673', '2674', '2676', '2680', '2684', '2752', '2760', '2768', '2769', '2770', '2772', '2776', '2780', '2784', '2792', '2800', '2801', '2802', '2804', '2808', '2812', '3136', '3144', '3152', '3153', '3154', '3156', '3160', '3164', '3168', '3176', '3184', '3185', '3186', '3188', '3192', '3196', '320', '3264', '3272', '328', '3280', '3281', '3282', '3284', '3288', '3292', '3296', '3304', '3312', '3313', '3314', '3316', '3320', '3324', '336', '337', '338', '3392', '340', '3400', '3408', '3409', '3410', '3412', '3416', '3420', '3424', '3432', '344', '3440', '3441', '3442', '3444', '3448', '3452', '348', '352', '360', '3648', '3656', '3664', '3665', '3666', '3668', '3672', '3676', '368', '3680', '3688', '369', '3696', '3697', '3698', '370', '3700', '3704', '3708', '372', '376', '3776', '3784', '3792', '3793', '3794', '3796', '380', '3800', '3804', '3808', '3816', '3824', '3825', '3826', '3828', '3832', '3836', '4160', '4168', '4176', '4177', '4178', '4180', '4184', '4188', '4192', '4200', '4208', '4209', '4210', '4212', '4216', '4220', '4288', '4296', '4304', '4305', '4306', '4308', '4312', '4316', '4320', '4328', '4336', '4337', '4338', '4340', '4344', '4348', '4416', '4424', '4432', '4433', '4434', '4436', '4440', '4444', '4448', '4456', '4464', '4465', '4466', '4468', '4472', '4476', '4672', '4680', '4688', '4689', '4690', '4692', '4696', '4700', '4704', '4712', '4720', '4721', '4722', '4724', '4728', '4732', '4800', '4808', '4816', '4817', '4818', '4820', '4824', '4828', '4832', '4840', '4848', '4849', '4850', '4852', '4856', '4860', '5184', '5192', '5200', '5201', '5202', '5204', '5208', '5212', '5216', '5224', '5232', '5233', '5234', '5236', '5240', '5244', '5312', '5320', '5328', '5329', '5330', '5332', '5336', '5340', '5344', '5352', '5360', '5361', '5362', '5364', '5368', '5372', '5440', '5448', '5456', '5457', '5458', '5460', '5464', '5468', '5472', '5480', '5488', '5489', '5490', '5492', '5496', '5500', '5696', '5704', '5712', '5713', '5714', '5716', '5720', '5724', '5728', '5736', '5744', '5745', '5746', '5748', '5752', '5756', '576', '5824', '5832', '584', '5840', '5841', '5842', '5844', '5848', '5852', '5856', '5864', '5872', '5873', '5874', '5876', '5880', '5884', '592', '593', '594', '596', '600', '604', '608', '616', '6208', '6216', '6224', '6225', '6226', '6228', '6232', '6236', '624', '6240', '6248', '625', '6256', '6257', '6258', '626', '6260', '6264', '6268', '628', '632', '6336', '6344', '6352', '6353', '6354', '6356', '636', '6360', '6364', '6368', '6376', '6384', '6385', '6386', '6388', '6392', '6396', '64', '6464', '6472', '6480', '6481', '6482', '6484', '6488', '6492', '6496', '6504', '6512', '6513', '6514', '6516', '6520', '6524', '6720', '6728', '6736', '6737', '6738', '6740', '6744', '6748', '6752', '6760', '6768', '6769', '6770', '6772', '6776', '6780', '6848', '6856', '6864', '6865', '6866', '6868', '6872', '6876', '6880', '6888', '6896', '6897', '6898', '6900', '6904', '6908', '704', '712', '72', '720', '721', '722', '7232', '724', '7240', '7248', '7249', '7250', '7252', '7256', '7260', '7264', '7272', '728', '7280', '7281', '7282', '7284', '7288', '7292', '732', '736', '7360', '7368', '7376', '7377', '7378', '7380', '7384', '7388', '7392', '7400', '7408', '7409', '7410', '7412', '7416', '7420', '744', '7488', '7496', '7504', '7505', '7506', '7508', '7512', '7516', '752', '7520', '7528', '753', '7536', '7537', '7538', '754', '7540', '7544', '7548', '756', '760', '764', '7744', '7752', '7760', '7761', '7762', '7764', '7768', '7772', '7776', '7784', '7792', '7793', '7794', '7796', '7800', '7804', '7872', '7880', '7888', '7889', '7890', '7892', '7896', '7900', '7904', '7912', '7920', '7921', '7922', '7924', '7928', '7932', '80', '81', '82', '84', '88', '92', '96')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'search_on_site_mcb'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 2)
) FORMAT JSONCompact

SELECT
    `search_on_site_mcb`.`campaign_id` AS `campaign_id`,
    `search_on_site_mcb`.`id` AS `id`
FROM `search_on_site_mcb`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'search_on_site_mcb'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 2)
) FORMAT JSONCompact

SELECT
    `search_on_site_mcb`.`campaign_id` AS `campaign_id`,
    `search_on_site_mcb`.`id` AS `id`
FROM `search_on_site_mcb`
WHERE (
    (
        `search_on_site_mcb`.`campaign_id` = '1'
        AND `search_on_site_mcb`.`id` IN ('1')
    )
    OR (
        `search_on_site_mcb`.`campaign_id` = '2'
        AND `search_on_site_mcb`.`id` IN ('1', '2')
    )
)

SELECT
    `search_on_site_campaign`.`id` AS `id`
FROM `search_on_site_campaign`
WHERE (
    (
        `search_on_site_campaign`.`page_id` IN ('1', '2')
    )
    AND (
        `search_on_site_campaign`.`multistate` IN ('104', '1088', '1096', '1104', '1105', '1106', '1108', '1112', '1116', '112', '1120', '1128', '113', '1136', '1137', '1138', '114', '1140', '1144', '1148', '116', '120', '1216', '1224', '1232', '1233', '1234', '1236', '124', '1240', '1244', '1248', '1256', '1264', '1265', '1266', '1268', '1272', '1276', '1344', '1352', '1360', '1361', '1362', '1364', '1368', '1372', '1376', '1384', '1392', '1393', '1394', '1396', '1400', '1404', '1600', '1608', '1616', '1617', '1618', '1620', '1624', '1628', '1632', '1640', '1648', '1649', '1650', '1652', '1656', '1660', '1728', '1736', '1744', '1745', '1746', '1748', '1752', '1756', '1760', '1768', '1776', '1777', '1778', '1780', '1784', '1788', '192', '200', '208', '209', '210', '2112', '212', '2120', '2128', '2129', '2130', '2132', '2136', '2140', '2144', '2152', '216', '2160', '2161', '2162', '2164', '2168', '2172', '220', '224', '2240', '2248', '2256', '2257', '2258', '2260', '2264', '2268', '2272', '2280', '2288', '2289', '2290', '2292', '2296', '2300', '232', '2368', '2376', '2384', '2385', '2386', '2388', '2392', '2396', '240', '2400', '2408', '241', '2416', '2417', '2418', '242', '2420', '2424', '2428', '244', '248', '252', '2624', '2632', '2640', '2641', '2642', '2644', '2648', '2652', '2656', '2664', '2672', '2673', '2674', '2676', '2680', '2684', '2752', '2760', '2768', '2769', '2770', '2772', '2776', '2780', '2784', '2792', '2800', '2801', '2802', '2804', '2808', '2812', '3136', '3144', '3152', '3153', '3154', '3156', '3160', '3164', '3168', '3176', '3184', '3185', '3186', '3188', '3192', '3196', '320', '3264', '3272', '328', '3280', '3281', '3282', '3284', '3288', '3292', '3296', '3304', '3312', '3313', '3314', '3316', '3320', '3324', '336', '337', '338', '3392', '340', '3400', '3408', '3409', '3410', '3412', '3416', '3420', '3424', '3432', '344', '3440', '3441', '3442', '3444', '3448', '3452', '348', '352', '360', '3648', '3656', '3664', '3665', '3666', '3668', '3672', '3676', '368', '3680', '3688', '369', '3696', '3697', '3698', '370', '3700', '3704', '3708', '372', '376', '3776', '3784', '3792', '3793', '3794', '3796', '380', '3800', '3804', '3808', '3816', '3824', '3825', '3826', '3828', '3832', '3836', '4160', '4168', '4176', '4177', '4178', '4180', '4184', '4188', '4192', '4200', '4208', '4209', '4210', '4212', '4216', '4220', '4288', '4296', '4304', '4305', '4306', '4308', '4312', '4316', '4320', '4328', '4336', '4337', '4338', '4340', '4344', '4348', '4416', '4424', '4432', '4433', '4434', '4436', '4440', '4444', '4448', '4456', '4464', '4465', '4466', '4468', '4472', '4476', '4672', '4680', '4688', '4689', '4690', '4692', '4696', '4700', '4704', '4712', '4720', '4721', '4722', '4724', '4728', '4732', '4800', '4808', '4816', '4817', '4818', '4820', '4824', '4828', '4832', '4840', '4848', '4849', '4850', '4852', '4856', '4860', '5184', '5192', '5200', '5201', '5202', '5204', '5208', '5212', '5216', '5224', '5232', '5233', '5234', '5236', '5240', '5244', '5312', '5320', '5328', '5329', '5330', '5332', '5336', '5340', '5344', '5352', '5360', '5361', '5362', '5364', '5368', '5372', '5440', '5448', '5456', '5457', '5458', '5460', '5464', '5468', '5472', '5480', '5488', '5489', '5490', '5492', '5496', '5500', '5696', '5704', '5712', '5713', '5714', '5716', '5720', '5724', '5728', '5736', '5744', '5745', '5746', '5748', '5752', '5756', '576', '5824', '5832', '584', '5840', '5841', '5842', '5844', '5848', '5852', '5856', '5864', '5872', '5873', '5874', '5876', '5880', '5884', '592', '593', '594', '596', '600', '604', '608', '616', '6208', '6216', '6224', '6225', '6226', '6228', '6232', '6236', '624', '6240', '6248', '625', '6256', '6257', '6258', '626', '6260', '6264', '6268', '628', '632', '6336', '6344', '6352', '6353', '6354', '6356', '636', '6360', '6364', '6368', '6376', '6384', '6385', '6386', '6388', '6392', '6396', '64', '6464', '6472', '6480', '6481', '6482', '6484', '6488', '6492', '6496', '6504', '6512', '6513', '6514', '6516', '6520', '6524', '6720', '6728', '6736', '6737', '6738', '6740', '6744', '6748', '6752', '6760', '6768', '6769', '6770', '6772', '6776', '6780', '6848', '6856', '6864', '6865', '6866', '6868', '6872', '6876', '6880', '6888', '6896', '6897', '6898', '6900', '6904', '6908', '704', '712', '72', '720', '721', '722', '7232', '724', '7240', '7248', '7249', '7250', '7252', '7256', '7260', '7264', '7272', '728', '7280', '7281', '7282', '7284', '7288', '7292', '732', '736', '7360', '7368', '7376', '7377', '7378', '7380', '7384', '7388', '7392', '7400', '7408', '7409', '7410', '7412', '7416', '7420', '744', '7488', '7496', '7504', '7505', '7506', '7508', '7512', '7516', '752', '7520', '7528', '753', '7536', '7537', '7538', '754', '7540', '7544', '7548', '756', '760', '764', '7744', '7752', '7760', '7761', '7762', '7764', '7768', '7772', '7776', '7784', '7792', '7793', '7794', '7796', '7800', '7804', '7872', '7880', '7888', '7889', '7890', '7892', '7896', '7900', '7904', '7912', '7920', '7921', '7922', '7924', '7928', '7932', '80', '81', '82', '84', '88', '92', '96')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'search_on_site_premium'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `search_on_site_premium`.`campaign_id` AS `campaign_id`,
    `search_on_site_premium`.`id` AS `id`
FROM `search_on_site_premium`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'search_on_site_premium'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `search_on_site_premium`.`campaign_id` AS `campaign_id`,
    `search_on_site_premium`.`id` AS `id`
FROM `search_on_site_premium`
WHERE (
    (
        `search_on_site_premium`.`campaign_id` = '1'
        AND `search_on_site_premium`.`id` IN ('1')
    )
    OR (
        `search_on_site_premium`.`campaign_id` = '2'
        AND `search_on_site_premium`.`id` IN ('1', '2')
    )
)

SELECT
    `search_on_site_campaign`.`id` AS `id`
FROM `search_on_site_campaign`
WHERE (
    (
        `search_on_site_campaign`.`page_id` IN ('1', '2')
    )
    AND (
        `search_on_site_campaign`.`multistate` IN ('104', '1088', '1096', '1104', '1105', '1106', '1108', '1112', '1116', '112', '1120', '1128', '113', '1136', '1137', '1138', '114', '1140', '1144', '1148', '116', '120', '1216', '1224', '1232', '1233', '1234', '1236', '124', '1240', '1244', '1248', '1256', '1264', '1265', '1266', '1268', '1272', '1276', '1344', '1352', '1360', '1361', '1362', '1364', '1368', '1372', '1376', '1384', '1392', '1393', '1394', '1396', '1400', '1404', '1600', '1608', '1616', '1617', '1618', '1620', '1624', '1628', '1632', '1640', '1648', '1649', '1650', '1652', '1656', '1660', '1728', '1736', '1744', '1745', '1746', '1748', '1752', '1756', '1760', '1768', '1776', '1777', '1778', '1780', '1784', '1788', '192', '200', '208', '209', '210', '2112', '212', '2120', '2128', '2129', '2130', '2132', '2136', '2140', '2144', '2152', '216', '2160', '2161', '2162', '2164', '2168', '2172', '220', '224', '2240', '2248', '2256', '2257', '2258', '2260', '2264', '2268', '2272', '2280', '2288', '2289', '2290', '2292', '2296', '2300', '232', '2368', '2376', '2384', '2385', '2386', '2388', '2392', '2396', '240', '2400', '2408', '241', '2416', '2417', '2418', '242', '2420', '2424', '2428', '244', '248', '252', '2624', '2632', '2640', '2641', '2642', '2644', '2648', '2652', '2656', '2664', '2672', '2673', '2674', '2676', '2680', '2684', '2752', '2760', '2768', '2769', '2770', '2772', '2776', '2780', '2784', '2792', '2800', '2801', '2802', '2804', '2808', '2812', '3136', '3144', '3152', '3153', '3154', '3156', '3160', '3164', '3168', '3176', '3184', '3185', '3186', '3188', '3192', '3196', '320', '3264', '3272', '328', '3280', '3281', '3282', '3284', '3288', '3292', '3296', '3304', '3312', '3313', '3314', '3316', '3320', '3324', '336', '337', '338', '3392', '340', '3400', '3408', '3409', '3410', '3412', '3416', '3420', '3424', '3432', '344', '3440', '3441', '3442', '3444', '3448', '3452', '348', '352', '360', '3648', '3656', '3664', '3665', '3666', '3668', '3672', '3676', '368', '3680', '3688', '369', '3696', '3697', '3698', '370', '3700', '3704', '3708', '372', '376', '3776', '3784', '3792', '3793', '3794', '3796', '380', '3800', '3804', '3808', '3816', '3824', '3825', '3826', '3828', '3832', '3836', '4160', '4168', '4176', '4177', '4178', '4180', '4184', '4188', '4192', '4200', '4208', '4209', '4210', '4212', '4216', '4220', '4288', '4296', '4304', '4305', '4306', '4308', '4312', '4316', '4320', '4328', '4336', '4337', '4338', '4340', '4344', '4348', '4416', '4424', '4432', '4433', '4434', '4436', '4440', '4444', '4448', '4456', '4464', '4465', '4466', '4468', '4472', '4476', '4672', '4680', '4688', '4689', '4690', '4692', '4696', '4700', '4704', '4712', '4720', '4721', '4722', '4724', '4728', '4732', '4800', '4808', '4816', '4817', '4818', '4820', '4824', '4828', '4832', '4840', '4848', '4849', '4850', '4852', '4856', '4860', '5184', '5192', '5200', '5201', '5202', '5204', '5208', '5212', '5216', '5224', '5232', '5233', '5234', '5236', '5240', '5244', '5312', '5320', '5328', '5329', '5330', '5332', '5336', '5340', '5344', '5352', '5360', '5361', '5362', '5364', '5368', '5372', '5440', '5448', '5456', '5457', '5458', '5460', '5464', '5468', '5472', '5480', '5488', '5489', '5490', '5492', '5496', '5500', '5696', '5704', '5712', '5713', '5714', '5716', '5720', '5724', '5728', '5736', '5744', '5745', '5746', '5748', '5752', '5756', '576', '5824', '5832', '584', '5840', '5841', '5842', '5844', '5848', '5852', '5856', '5864', '5872', '5873', '5874', '5876', '5880', '5884', '592', '593', '594', '596', '600', '604', '608', '616', '6208', '6216', '6224', '6225', '6226', '6228', '6232', '6236', '624', '6240', '6248', '625', '6256', '6257', '6258', '626', '6260', '6264', '6268', '628', '632', '6336', '6344', '6352', '6353', '6354', '6356', '636', '6360', '6364', '6368', '6376', '6384', '6385', '6386', '6388', '6392', '6396', '64', '6464', '6472', '6480', '6481', '6482', '6484', '6488', '6492', '6496', '6504', '6512', '6513', '6514', '6516', '6520', '6524', '6720', '6728', '6736', '6737', '6738', '6740', '6744', '6748', '6752', '6760', '6768', '6769', '6770', '6772', '6776', '6780', '6848', '6856', '6864', '6865', '6866', '6868', '6872', '6876', '6880', '6888', '6896', '6897', '6898', '6900', '6904', '6908', '704', '712', '72', '720', '721', '722', '7232', '724', '7240', '7248', '7249', '7250', '7252', '7256', '7260', '7264', '7272', '728', '7280', '7281', '7282', '7284', '7288', '7292', '732', '736', '7360', '7368', '7376', '7377', '7378', '7380', '7384', '7388', '7392', '7400', '7408', '7409', '7410', '7412', '7416', '7420', '744', '7488', '7496', '7504', '7505', '7506', '7508', '7512', '7516', '752', '7520', '7528', '753', '7536', '7537', '7538', '754', '7540', '7544', '7548', '756', '760', '764', '7744', '7752', '7760', '7761', '7762', '7764', '7768', '7772', '7776', '7784', '7792', '7793', '7794', '7796', '7800', '7804', '7872', '7880', '7888', '7889', '7890', '7892', '7896', '7900', '7904', '7912', '7920', '7921', '7922', '7924', '7928', '7932', '80', '81', '82', '84', '88', '92', '96')
    )
)

SELECT DISTINCT
    `statistics`.`block_id` AS `id`,
    `statistics`.`page_id` AS `page_id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'indoor_block'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `indoor_block`.`id` AS `id`,
    `indoor_block`.`page_id` AS `page_id`
FROM `indoor_block`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`block_id` AS `id`,
    `statistics`.`page_id` AS `page_id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'indoor_block'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `indoor_block`.`id` AS `id`,
    `indoor_block`.`page_id` AS `page_id`
FROM `indoor_block`
WHERE (
    (
        `indoor_block`.`page_id` = '1'
        AND `indoor_block`.`id` IN ('1')
    )
    OR (
        `indoor_block`.`page_id` = '2'
        AND `indoor_block`.`id` IN ('1', '2')
    )
)

SELECT
    `indoor`.`id` AS `id`
FROM `indoor`
WHERE (
    (
        `indoor`.`page_id` IN ('1', '2')
    )
    AND (
        `indoor`.`multistate` IN ('1008', '10112', '10113', '10114', '10116', '10118', '1012', '10120', '10121', '10122', '10124', '10126', '10128', '10129', '10130', '10132', '10134', '10136', '10137', '10138', '10140', '10142', '10144', '10145', '10146', '10148', '10150', '10152', '10153', '10154', '10156', '10158', '10160', '10161', '10162', '10164', '10166', '10168', '10169', '10170', '10172', '10174', '10176', '10177', '10178', '10180', '10182', '10184', '10185', '10186', '10188', '10190', '10192', '10193', '10194', '10196', '10198', '10200', '10201', '10202', '10204', '10206', '10208', '10209', '10210', '10212', '10214', '10216', '10217', '10218', '10220', '10222', '10224', '10225', '10226', '10228', '10230', '10232', '10233', '10234', '10236', '10238', '10368', '10372', '10376', '10380', '10384', '10388', '10392', '10396', '10400', '10404', '10408', '10412', '10416', '10420', '10424', '10428', '10432', '10436', '10440', '10444', '10448', '10452', '10456', '10460', '10464', '10468', '10472', '10476', '10480', '10484', '10488', '10492', '10624', '10628', '10632', '10636', '10640', '10644', '10648', '10652', '10656', '10660', '10664', '10668', '10672', '10676', '10680', '10684', '10688', '10692', '10696', '10700', '10704', '10708', '10712', '10716', '10720', '10724', '10728', '10732', '10736', '10740', '10744', '10748', '10880', '10884', '10888', '10892', '10896', '10900', '10904', '10908', '10912', '10916', '10920', '10924', '10928', '10932', '10936', '10940', '10944', '10948', '10952', '10956', '10960', '10964', '10968', '10972', '10976', '10980', '10984', '10988', '10992', '10996', '11000', '11004', '11136', '11140', '11144', '11148', '11152', '11156', '11160', '11164', '11168', '11172', '11176', '11180', '11184', '11188', '11192', '11196', '11200', '11204', '11208', '11212', '11216', '11220', '11224', '11228', '11232', '11236', '11240', '11244', '11248', '11252', '11256', '11260', '1152', '1156', '1160', '1164', '1168', '1172', '1176', '1180', '1184', '1188', '1192', '1196', '1200', '1204', '1208', '1212', '1216', '1220', '1224', '1228', '1232', '1236', '1240', '12416', '12420', '12424', '12428', '12432', '12436', '1244', '12440', '12444', '12448', '12452', '12456', '12460', '12464', '12468', '12472', '12476', '1248', '12480', '12484', '12488', '12492', '12496', '12500', '12504', '12508', '12512', '12516', '1252', '12520', '12524', '12528', '12532', '12536', '12540', '1256', '1260', '1264', '12672', '12676', '1268', '12680', '12684', '12688', '12692', '12696', '12700', '12704', '12708', '12712', '12716', '1272', '12720', '12724', '12728', '12732', '12736', '12740', '12744', '12748', '12752', '12756', '1276', '12760', '12764', '12768', '12772', '12776', '12780', '12784', '12788', '12792', '12796', '128', '12928', '12932', '12936', '12940', '12944', '12948', '12952', '12956', '12960', '12964', '12968', '12972', '12976', '12980', '12984', '12988', '12992', '12996', '13000', '13004', '13008', '13012', '13016', '13020', '13024', '13028', '13032', '13036', '13040', '13044', '13048', '13052', '13184', '13188', '13192', '13196', '132', '13200', '13204', '13208', '13212', '13216', '13220', '13224', '13228', '13232', '13236', '13240', '13244', '13248', '13252', '13256', '13260', '13264', '13268', '13272', '13276', '13280', '13284', '13288', '13292', '13296', '13300', '13304', '13308', '13440', '13444', '13448', '13452', '13456', '13460', '13464', '13468', '13472', '13476', '13480', '13484', '13488', '13492', '13496', '13500', '13504', '13508', '13512', '13516', '13520', '13524', '13528', '13532', '13536', '13540', '13544', '13548', '13552', '13556', '13560', '13564', '13696', '13697', '13698', '13700', '13702', '13704', '13705', '13706', '13708', '13710', '13712', '13713', '13714', '13716', '13718', '13720', '13721', '13722', '13724', '13726', '13728', '13729', '13730', '13732', '13734', '13736', '13737', '13738', '13740', '13742', '13744', '13745', '13746', '13748', '13750', '13752', '13753', '13754', '13756', '13758', '13760', '13761', '13762', '13764', '13766', '13768', '13769', '13770', '13772', '13774', '13776', '13777', '13778', '13780', '13782', '13784', '13785', '13786', '13788', '13790', '13792', '13793', '13794', '13796', '13798', '13800', '13801', '13802', '13804', '13806', '13808', '13809', '13810', '13812', '13814', '13816', '13817', '13818', '13820', '13822', '13952', '13956', '13960', '13964', '13968', '13972', '13976', '13980', '13984', '13988', '13992', '13996', '14000', '14004', '14008', '14012', '14016', '14020', '14024', '14028', '14032', '14036', '14040', '14044', '14048', '14052', '14056', '14060', '14064', '14068', '14072', '14076', '1408', '1409', '1410', '1412', '1414', '1416', '1417', '1418', '1420', '14208', '14209', '14210', '14212', '14214', '14216', '14217', '14218', '1422', '14220', '14222', '14224', '14225', '14226', '14228', '14230', '14232', '14233', '14234', '14236', '14238', '1424', '14240', '14241', '14242', '14244', '14246', '14248', '14249', '1425', '14250', '14252', '14254', '14256', '14257', '14258', '1426', '14260', '14262', '14264', '14265', '14266', '14268', '14270', '14272', '14273', '14274', '14276', '14278', '1428', '14280', '14281', '14282', '14284', '14286', '14288', '14289', '14290', '14292', '14294', '14296', '14297', '14298', '1430', '14300', '14302', '14304', '14305', '14306', '14308', '14310', '14312', '14313', '14314', '14316', '14318', '1432', '14320', '14321', '14322', '14324', '14326', '14328', '14329', '1433', '14330', '14332', '14334', '1434', '1436', '1438', '1440', '1441', '1442', '1444', '1446', '14464', '14468', '14472', '14476', '1448', '14480', '14484', '14488', '1449', '14492', '14496', '1450', '14500', '14504', '14508', '14512', '14516', '1452', '14520', '14524', '14528', '14532', '14536', '1454', '14540', '14544', '14548', '14552', '14556', '1456', '14560', '14564', '14568', '1457', '14572', '14576', '1458', '14580', '14584', '14588', '1460', '1462', '1464', '1465', '1466', '1468', '1470', '1472', '14720', '14724', '14728', '1473', '14732', '14736', '1474', '14740', '14744', '14748', '14752', '14756', '1476', '14760', '14764', '14768', '14772', '14776', '1478', '14780', '14784', '14788', '14792', '14796', '1480', '14800', '14804', '14808', '1481', '14812', '14816', '1482', '14820', '14824', '14828', '14832', '14836', '1484', '14840', '14844', '1486', '1488', '1489', '1490', '1492', '1494', '1496', '1497', '14976', '1498', '14980', '14984', '14988', '14992', '14996', '1500', '15000', '15004', '15008', '15012', '15016', '1502', '15020', '15024', '15028', '15032', '15036', '1504', '15040', '15044', '15048', '1505', '15052', '15056', '1506', '15060', '15064', '15068', '15072', '15076', '1508', '15080', '15084', '15088', '15092', '15096', '1510', '15100', '1512', '1513', '1514', '1516', '1518', '1520', '1521', '1522', '15232', '15236', '1524', '15240', '15244', '15248', '15252', '15256', '1526', '15260', '15264', '15268', '15272', '15276', '1528', '15280', '15284', '15288', '1529', '15292', '15296', '1530', '15300', '15304', '15308', '15312', '15316', '1532', '15320', '15324', '15328', '15332', '15336', '1534', '15340', '15344', '15348', '15352', '15356', '160', '164', '1664', '1668', '1672', '1676', '1680', '1684', '1688', '1692', '1696', '1700', '1704', '1708', '1712', '1716', '1720', '1724', '1728', '1732', '1736', '1740', '1744', '1748', '1752', '1756', '1760', '1764', '1768', '1772', '1776', '1780', '1784', '1788', '192', '1920', '1921', '1922', '1924', '1926', '1928', '1929', '1930', '1932', '1934', '1936', '1937', '1938', '1940', '1942', '1944', '1945', '1946', '1948', '1950', '1952', '1953', '1954', '1956', '1958', '196', '1960', '1961', '1962', '1964', '1966', '1968', '1969', '1970', '1972', '1974', '1976', '1977', '1978', '1980', '1982', '1984', '1985', '1986', '1988', '1990', '1992', '1993', '1994', '1996', '1998', '2000', '2001', '2002', '2004', '2006', '2008', '2009', '2010', '2012', '2014', '2016', '2017', '2018', '2020', '2022', '2024', '2025', '2026', '2028', '2030', '2032', '2033', '2034', '2036', '2038', '2040', '2041', '2042', '2044', '2046', '2176', '2180', '2192', '2196', '2208', '2212', '2224', '2228', '224', '2240', '2244', '2256', '2260', '2272', '2276', '228', '2288', '2292', '2432', '2436', '2448', '2452', '2464', '2468', '2480', '2484', '2496', '2500', '2512', '2516', '2528', '2532', '2544', '2548', '2688', '2692', '2704', '2708', '2720', '2724', '2736', '2740', '2752', '2756', '2768', '2772', '2784', '2788', '2800', '2804', '2944', '2948', '2960', '2964', '2976', '2980', '2992', '2996', '3008', '3012', '3024', '3028', '3040', '3044', '3056', '3060', '384', '388', '416', '420', '4224', '4228', '4256', '4260', '4288', '4292', '4320', '4324', '448', '4480', '4484', '4512', '4516', '452', '4544', '4548', '4576', '4580', '4736', '4740', '4752', '4756', '4768', '4772', '4784', '4788', '480', '4800', '4804', '4816', '4820', '4832', '4836', '484', '4848', '4852', '4992', '4996', '5008', '5012', '5024', '5028', '5040', '5044', '5056', '5060', '5072', '5076', '5088', '5092', '5104', '5108', '5248', '5252', '5256', '5260', '5264', '5268', '5272', '5276', '5280', '5284', '5288', '5292', '5296', '5300', '5304', '5308', '5312', '5316', '5320', '5324', '5328', '5332', '5336', '5340', '5344', '5348', '5352', '5356', '5360', '5364', '5368', '5372', '5504', '5505', '5506', '5508', '5510', '5512', '5513', '5514', '5516', '5518', '5520', '5521', '5522', '5524', '5526', '5528', '5529', '5530', '5532', '5534', '5536', '5537', '5538', '5540', '5542', '5544', '5545', '5546', '5548', '5550', '5552', '5553', '5554', '5556', '5558', '5560', '5561', '5562', '5564', '5566', '5568', '5569', '5570', '5572', '5574', '5576', '5577', '5578', '5580', '5582', '5584', '5585', '5586', '5588', '5590', '5592', '5593', '5594', '5596', '5598', '5600', '5601', '5602', '5604', '5606', '5608', '5609', '5610', '5612', '5614', '5616', '5617', '5618', '5620', '5622', '5624', '5625', '5626', '5628', '5630', '5760', '5764', '5768', '5772', '5776', '5780', '5784', '5788', '5792', '5796', '5800', '5804', '5808', '5812', '5816', '5820', '5824', '5828', '5832', '5836', '5840', '5844', '5848', '5852', '5856', '5860', '5864', '5868', '5872', '5876', '5880', '5884', '6016', '6017', '6018', '6020', '6022', '6024', '6025', '6026', '6028', '6030', '6032', '6033', '6034', '6036', '6038', '6040', '6041', '6042', '6044', '6046', '6048', '6049', '6050', '6052', '6054', '6056', '6057', '6058', '6060', '6062', '6064', '6065', '6066', '6068', '6070', '6072', '6073', '6074', '6076', '6078', '6080', '6081', '6082', '6084', '6086', '6088', '6089', '6090', '6092', '6094', '6096', '6097', '6098', '6100', '6102', '6104', '6105', '6106', '6108', '6110', '6112', '6113', '6114', '6116', '6118', '6120', '6121', '6122', '6124', '6126', '6128', '6129', '6130', '6132', '6134', '6136', '6137', '6138', '6140', '6142', '6272', '6276', '6288', '6292', '6304', '6308', '6320', '6324', '6336', '6340', '6352', '6356', '6368', '6372', '6384', '6388', '640', '644', '6528', '6532', '6544', '6548', '656', '6560', '6564', '6576', '6580', '6592', '6596', '660', '6608', '6612', '6624', '6628', '6640', '6644', '672', '676', '6784', '6788', '6800', '6804', '6816', '6820', '6832', '6836', '6848', '6852', '6864', '6868', '688', '6880', '6884', '6896', '6900', '692', '704', '7040', '7044', '7056', '7060', '7072', '7076', '708', '7088', '7092', '7104', '7108', '7120', '7124', '7136', '7140', '7152', '7156', '720', '724', '736', '740', '752', '756', '8320', '8324', '8328', '8332', '8336', '8340', '8344', '8348', '8352', '8356', '8360', '8364', '8368', '8372', '8376', '8380', '8384', '8388', '8392', '8396', '8400', '8404', '8408', '8412', '8416', '8420', '8424', '8428', '8432', '8436', '8440', '8444', '8576', '8580', '8584', '8588', '8592', '8596', '8600', '8604', '8608', '8612', '8616', '8620', '8624', '8628', '8632', '8636', '8640', '8644', '8648', '8652', '8656', '8660', '8664', '8668', '8672', '8676', '8680', '8684', '8688', '8692', '8696', '8700', '8832', '8836', '8840', '8844', '8848', '8852', '8856', '8860', '8864', '8868', '8872', '8876', '8880', '8884', '8888', '8892', '8896', '8900', '8904', '8908', '8912', '8916', '8920', '8924', '8928', '8932', '8936', '8940', '8944', '8948', '8952', '8956', '896', '900', '9088', '9092', '9096', '9100', '9104', '9108', '9112', '9116', '912', '9120', '9124', '9128', '9132', '9136', '9140', '9144', '9148', '9152', '9156', '916', '9160', '9164', '9168', '9172', '9176', '9180', '9184', '9188', '9192', '9196', '9200', '9204', '9208', '9212', '928', '932', '9344', '9348', '9352', '9356', '9360', '9364', '9368', '9372', '9376', '9380', '9384', '9388', '9392', '9396', '9400', '9404', '9408', '9412', '9416', '9420', '9424', '9428', '9432', '9436', '944', '9440', '9444', '9448', '9452', '9456', '9460', '9464', '9468', '948', '960', '9600', '9601', '9602', '9604', '9606', '9608', '9609', '9610', '9612', '9614', '9616', '9617', '9618', '9620', '9622', '9624', '9625', '9626', '9628', '9630', '9632', '9633', '9634', '9636', '9638', '964', '9640', '9641', '9642', '9644', '9646', '9648', '9649', '9650', '9652', '9654', '9656', '9657', '9658', '9660', '9662', '9664', '9665', '9666', '9668', '9670', '9672', '9673', '9674', '9676', '9678', '9680', '9681', '9682', '9684', '9686', '9688', '9689', '9690', '9692', '9694', '9696', '9697', '9698', '9700', '9702', '9704', '9705', '9706', '9708', '9710', '9712', '9713', '9714', '9716', '9718', '9720', '9721', '9722', '9724', '9726', '976', '980', '9856', '9860', '9864', '9868', '9872', '9876', '9880', '9884', '9888', '9892', '9896', '9900', '9904', '9908', '9912', '9916', '992', '9920', '9924', '9928', '9932', '9936', '9940', '9944', '9948', '9952', '9956', '996', '9960', '9964', '9968', '9972', '9976', '9980')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'internal_context_on_site_content'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `internal_context_on_site_content`.`campaign_id` AS `campaign_id`,
    `internal_context_on_site_content`.`id` AS `id`
FROM `internal_context_on_site_content`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'internal_context_on_site_content'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `internal_context_on_site_content`.`campaign_id` AS `campaign_id`,
    `internal_context_on_site_content`.`id` AS `id`
FROM `internal_context_on_site_content`
WHERE (
    (
        `internal_context_on_site_content`.`campaign_id` = '1'
        AND `internal_context_on_site_content`.`id` IN ('1')
    )
    OR (
        `internal_context_on_site_content`.`campaign_id` = '2'
        AND `internal_context_on_site_content`.`id` IN ('1', '2')
    )
)

SELECT
    `internal_context_on_site_campaign`.`id` AS `id`
FROM `internal_context_on_site_campaign`
WHERE (
    (
        `internal_context_on_site_campaign`.`id` IN ('1', '2')
    )
    AND (
        `internal_context_on_site_campaign`.`multistate` IN ('100', '1000', '1002', '1004', '1006', '1008', '1009', '101', '1010', '1011', '1012', '1013', '1014', '1016', '1018', '102', '1020', '1022', '104', '106', '108', '110', '112', '113', '114', '115', '116', '117', '118', '120', '122', '124', '126', '192', '193', '194', '195', '196', '197', '198', '200', '202', '204', '206', '208', '209', '210', '211', '212', '213', '214', '216', '218', '220', '222', '224', '225', '226', '227', '228', '229', '230', '232', '234', '236', '238', '240', '241', '242', '243', '244', '245', '246', '248', '250', '252', '254', '320', '321', '322', '323', '324', '325', '326', '328', '330', '332', '334', '336', '337', '338', '339', '340', '341', '342', '344', '346', '348', '350', '352', '353', '354', '355', '356', '357', '358', '360', '362', '364', '366', '368', '369', '370', '371', '372', '373', '374', '376', '378', '380', '382', '448', '449', '450', '451', '452', '453', '454', '456', '458', '460', '462', '464', '465', '466', '467', '468', '469', '470', '472', '474', '476', '478', '480', '481', '482', '483', '484', '485', '486', '488', '490', '492', '494', '496', '497', '498', '499', '500', '501', '502', '504', '506', '508', '510', '576', '577', '578', '579', '580', '581', '582', '584', '586', '588', '590', '592', '593', '594', '595', '596', '597', '598', '600', '602', '604', '606', '608', '609', '610', '611', '612', '613', '614', '616', '618', '620', '622', '624', '625', '626', '627', '628', '629', '630', '632', '634', '636', '638', '64', '65', '66', '67', '68', '69', '70', '704', '705', '706', '707', '708', '709', '710', '712', '714', '716', '718', '72', '720', '721', '722', '723', '724', '725', '726', '728', '730', '732', '734', '736', '737', '738', '739', '74', '740', '741', '742', '744', '746', '748', '750', '752', '753', '754', '755', '756', '757', '758', '76', '760', '762', '764', '766', '78', '80', '81', '82', '83', '832', '833', '834', '835', '836', '837', '838', '84', '840', '842', '844', '846', '848', '849', '85', '850', '851', '852', '853', '854', '856', '858', '86', '860', '862', '864', '865', '866', '867', '868', '869', '870', '872', '874', '876', '878', '88', '880', '881', '882', '883', '884', '885', '886', '888', '890', '892', '894', '90', '92', '94', '96', '960', '961', '962', '963', '964', '965', '966', '968', '97', '970', '972', '974', '976', '977', '978', '979', '98', '980', '981', '982', '984', '986', '988', '99', '990', '992', '993', '994', '995', '996', '997', '998')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'internal_context_on_site_direct'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `internal_context_on_site_direct`.`active` AS `active`,
    `internal_context_on_site_direct`.`campaign_id` AS `campaign_id`,
    `internal_context_on_site_direct`.`id` AS `id`
FROM `internal_context_on_site_direct`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'internal_context_on_site_direct'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `internal_context_on_site_direct`.`active` AS `active`,
    `internal_context_on_site_direct`.`campaign_id` AS `campaign_id`,
    `internal_context_on_site_direct`.`id` AS `id`
FROM `internal_context_on_site_direct`
WHERE (
    (
        `internal_context_on_site_direct`.`campaign_id` = '1'
        AND `internal_context_on_site_direct`.`id` IN ('1')
    )
    OR (
        `internal_context_on_site_direct`.`campaign_id` = '2'
        AND `internal_context_on_site_direct`.`id` IN ('1', '2')
    )
)

SELECT
    `internal_context_on_site_campaign`.`id` AS `id`
FROM `internal_context_on_site_campaign`
WHERE (
    (
        `internal_context_on_site_campaign`.`id` IN ('2')
    )
    AND (
        `internal_context_on_site_campaign`.`multistate` IN ('100', '1000', '1002', '1004', '1006', '1008', '1009', '101', '1010', '1011', '1012', '1013', '1014', '1016', '1018', '102', '1020', '1022', '104', '106', '108', '110', '112', '113', '114', '115', '116', '117', '118', '120', '122', '124', '126', '192', '193', '194', '195', '196', '197', '198', '200', '202', '204', '206', '208', '209', '210', '211', '212', '213', '214', '216', '218', '220', '222', '224', '225', '226', '227', '228', '229', '230', '232', '234', '236', '238', '240', '241', '242', '243', '244', '245', '246', '248', '250', '252', '254', '320', '321', '322', '323', '324', '325', '326', '328', '330', '332', '334', '336', '337', '338', '339', '340', '341', '342', '344', '346', '348', '350', '352', '353', '354', '355', '356', '357', '358', '360', '362', '364', '366', '368', '369', '370', '371', '372', '373', '374', '376', '378', '380', '382', '448', '449', '450', '451', '452', '453', '454', '456', '458', '460', '462', '464', '465', '466', '467', '468', '469', '470', '472', '474', '476', '478', '480', '481', '482', '483', '484', '485', '486', '488', '490', '492', '494', '496', '497', '498', '499', '500', '501', '502', '504', '506', '508', '510', '576', '577', '578', '579', '580', '581', '582', '584', '586', '588', '590', '592', '593', '594', '595', '596', '597', '598', '600', '602', '604', '606', '608', '609', '610', '611', '612', '613', '614', '616', '618', '620', '622', '624', '625', '626', '627', '628', '629', '630', '632', '634', '636', '638', '64', '65', '66', '67', '68', '69', '70', '704', '705', '706', '707', '708', '709', '710', '712', '714', '716', '718', '72', '720', '721', '722', '723', '724', '725', '726', '728', '730', '732', '734', '736', '737', '738', '739', '74', '740', '741', '742', '744', '746', '748', '750', '752', '753', '754', '755', '756', '757', '758', '76', '760', '762', '764', '766', '78', '80', '81', '82', '83', '832', '833', '834', '835', '836', '837', '838', '84', '840', '842', '844', '846', '848', '849', '85', '850', '851', '852', '853', '854', '856', '858', '86', '860', '862', '864', '865', '866', '867', '868', '869', '870', '872', '874', '876', '878', '88', '880', '881', '882', '883', '884', '885', '886', '888', '890', '892', '894', '90', '92', '94', '96', '960', '961', '962', '963', '964', '965', '966', '968', '97', '970', '972', '974', '976', '977', '978', '979', '98', '980', '981', '982', '984', '986', '988', '99', '990', '992', '993', '994', '995', '996', '997', '998')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'internal_context_on_site_natural'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `internal_context_on_site_natural`.`campaign_id` AS `campaign_id`,
    `internal_context_on_site_natural`.`id` AS `id`
FROM `internal_context_on_site_natural`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'internal_context_on_site_natural'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `internal_context_on_site_natural`.`campaign_id` AS `campaign_id`,
    `internal_context_on_site_natural`.`id` AS `id`
FROM `internal_context_on_site_natural`
WHERE (
    (
        `internal_context_on_site_natural`.`campaign_id` = '1'
        AND `internal_context_on_site_natural`.`id` IN ('1')
    )
    OR (
        `internal_context_on_site_natural`.`campaign_id` = '2'
        AND `internal_context_on_site_natural`.`id` IN ('1', '2')
    )
)

SELECT
    `internal_context_on_site_campaign`.`id` AS `id`
FROM `internal_context_on_site_campaign`
WHERE (
    (
        `internal_context_on_site_campaign`.`id` IN ('1', '2')
    )
    AND (
        `internal_context_on_site_campaign`.`multistate` IN ('100', '1000', '1002', '1004', '1006', '1008', '1009', '101', '1010', '1011', '1012', '1013', '1014', '1016', '1018', '102', '1020', '1022', '104', '106', '108', '110', '112', '113', '114', '115', '116', '117', '118', '120', '122', '124', '126', '192', '193', '194', '195', '196', '197', '198', '200', '202', '204', '206', '208', '209', '210', '211', '212', '213', '214', '216', '218', '220', '222', '224', '225', '226', '227', '228', '229', '230', '232', '234', '236', '238', '240', '241', '242', '243', '244', '245', '246', '248', '250', '252', '254', '320', '321', '322', '323', '324', '325', '326', '328', '330', '332', '334', '336', '337', '338', '339', '340', '341', '342', '344', '346', '348', '350', '352', '353', '354', '355', '356', '357', '358', '360', '362', '364', '366', '368', '369', '370', '371', '372', '373', '374', '376', '378', '380', '382', '448', '449', '450', '451', '452', '453', '454', '456', '458', '460', '462', '464', '465', '466', '467', '468', '469', '470', '472', '474', '476', '478', '480', '481', '482', '483', '484', '485', '486', '488', '490', '492', '494', '496', '497', '498', '499', '500', '501', '502', '504', '506', '508', '510', '576', '577', '578', '579', '580', '581', '582', '584', '586', '588', '590', '592', '593', '594', '595', '596', '597', '598', '600', '602', '604', '606', '608', '609', '610', '611', '612', '613', '614', '616', '618', '620', '622', '624', '625', '626', '627', '628', '629', '630', '632', '634', '636', '638', '64', '65', '66', '67', '68', '69', '70', '704', '705', '706', '707', '708', '709', '710', '712', '714', '716', '718', '72', '720', '721', '722', '723', '724', '725', '726', '728', '730', '732', '734', '736', '737', '738', '739', '74', '740', '741', '742', '744', '746', '748', '750', '752', '753', '754', '755', '756', '757', '758', '76', '760', '762', '764', '766', '78', '80', '81', '82', '83', '832', '833', '834', '835', '836', '837', '838', '84', '840', '842', '844', '846', '848', '849', '85', '850', '851', '852', '853', '854', '856', '858', '86', '860', '862', '864', '865', '866', '867', '868', '869', '870', '872', '874', '876', '878', '88', '880', '881', '882', '883', '884', '885', '886', '888', '890', '892', '894', '90', '92', '94', '96', '960', '961', '962', '963', '964', '965', '966', '968', '97', '970', '972', '974', '976', '977', '978', '979', '98', '980', '981', '982', '984', '986', '988', '99', '990', '992', '993', '994', '995', '996', '997', '998')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'internal_context_on_site_rtb'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `internal_context_on_site_rtb`.`active` AS `active`,
    `internal_context_on_site_rtb`.`campaign_id` AS `campaign_id`,
    `internal_context_on_site_rtb`.`id` AS `id`
FROM `internal_context_on_site_rtb`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'internal_context_on_site_rtb'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `internal_context_on_site_rtb`.`active` AS `active`,
    `internal_context_on_site_rtb`.`campaign_id` AS `campaign_id`,
    `internal_context_on_site_rtb`.`id` AS `id`
FROM `internal_context_on_site_rtb`
WHERE (
    (
        `internal_context_on_site_rtb`.`campaign_id` = '1'
        AND `internal_context_on_site_rtb`.`id` IN ('1')
    )
    OR (
        `internal_context_on_site_rtb`.`campaign_id` = '2'
        AND `internal_context_on_site_rtb`.`id` IN ('1', '2')
    )
)

SELECT
    `internal_context_on_site_campaign`.`id` AS `id`
FROM `internal_context_on_site_campaign`
WHERE (
    (
        `internal_context_on_site_campaign`.`id` IN ('2')
    )
    AND (
        `internal_context_on_site_campaign`.`multistate` IN ('100', '1000', '1002', '1004', '1006', '1008', '1009', '101', '1010', '1011', '1012', '1013', '1014', '1016', '1018', '102', '1020', '1022', '104', '106', '108', '110', '112', '113', '114', '115', '116', '117', '118', '120', '122', '124', '126', '192', '193', '194', '195', '196', '197', '198', '200', '202', '204', '206', '208', '209', '210', '211', '212', '213', '214', '216', '218', '220', '222', '224', '225', '226', '227', '228', '229', '230', '232', '234', '236', '238', '240', '241', '242', '243', '244', '245', '246', '248', '250', '252', '254', '320', '321', '322', '323', '324', '325', '326', '328', '330', '332', '334', '336', '337', '338', '339', '340', '341', '342', '344', '346', '348', '350', '352', '353', '354', '355', '356', '357', '358', '360', '362', '364', '366', '368', '369', '370', '371', '372', '373', '374', '376', '378', '380', '382', '448', '449', '450', '451', '452', '453', '454', '456', '458', '460', '462', '464', '465', '466', '467', '468', '469', '470', '472', '474', '476', '478', '480', '481', '482', '483', '484', '485', '486', '488', '490', '492', '494', '496', '497', '498', '499', '500', '501', '502', '504', '506', '508', '510', '576', '577', '578', '579', '580', '581', '582', '584', '586', '588', '590', '592', '593', '594', '595', '596', '597', '598', '600', '602', '604', '606', '608', '609', '610', '611', '612', '613', '614', '616', '618', '620', '622', '624', '625', '626', '627', '628', '629', '630', '632', '634', '636', '638', '64', '65', '66', '67', '68', '69', '70', '704', '705', '706', '707', '708', '709', '710', '712', '714', '716', '718', '72', '720', '721', '722', '723', '724', '725', '726', '728', '730', '732', '734', '736', '737', '738', '739', '74', '740', '741', '742', '744', '746', '748', '750', '752', '753', '754', '755', '756', '757', '758', '76', '760', '762', '764', '766', '78', '80', '81', '82', '83', '832', '833', '834', '835', '836', '837', '838', '84', '840', '842', '844', '846', '848', '849', '85', '850', '851', '852', '853', '854', '856', '858', '86', '860', '862', '864', '865', '866', '867', '868', '869', '870', '872', '874', '876', '878', '88', '880', '881', '882', '883', '884', '885', '886', '888', '890', '892', '894', '90', '92', '94', '96', '960', '961', '962', '963', '964', '965', '966', '968', '97', '970', '972', '974', '976', '977', '978', '979', '98', '980', '981', '982', '984', '986', '988', '99', '990', '992', '993', '994', '995', '996', '997', '998')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'internal_context_on_site_stripe'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `internal_context_on_site_stripe`.`campaign_id` AS `campaign_id`,
    `internal_context_on_site_stripe`.`id` AS `id`
FROM `internal_context_on_site_stripe`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'internal_context_on_site_stripe'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `internal_context_on_site_stripe`.`campaign_id` AS `campaign_id`,
    `internal_context_on_site_stripe`.`id` AS `id`
FROM `internal_context_on_site_stripe`
WHERE (
    (
        `internal_context_on_site_stripe`.`campaign_id` = '1'
        AND `internal_context_on_site_stripe`.`id` IN ('1')
    )
    OR (
        `internal_context_on_site_stripe`.`campaign_id` = '2'
        AND `internal_context_on_site_stripe`.`id` IN ('1', '2')
    )
)

SELECT
    `internal_context_on_site_campaign`.`id` AS `id`
FROM `internal_context_on_site_campaign`
WHERE (
    (
        `internal_context_on_site_campaign`.`id` IN ('1', '2')
    )
    AND (
        `internal_context_on_site_campaign`.`multistate` IN ('100', '1000', '1002', '1004', '1006', '1008', '1009', '101', '1010', '1011', '1012', '1013', '1014', '1016', '1018', '102', '1020', '1022', '104', '106', '108', '110', '112', '113', '114', '115', '116', '117', '118', '120', '122', '124', '126', '192', '193', '194', '195', '196', '197', '198', '200', '202', '204', '206', '208', '209', '210', '211', '212', '213', '214', '216', '218', '220', '222', '224', '225', '226', '227', '228', '229', '230', '232', '234', '236', '238', '240', '241', '242', '243', '244', '245', '246', '248', '250', '252', '254', '320', '321', '322', '323', '324', '325', '326', '328', '330', '332', '334', '336', '337', '338', '339', '340', '341', '342', '344', '346', '348', '350', '352', '353', '354', '355', '356', '357', '358', '360', '362', '364', '366', '368', '369', '370', '371', '372', '373', '374', '376', '378', '380', '382', '448', '449', '450', '451', '452', '453', '454', '456', '458', '460', '462', '464', '465', '466', '467', '468', '469', '470', '472', '474', '476', '478', '480', '481', '482', '483', '484', '485', '486', '488', '490', '492', '494', '496', '497', '498', '499', '500', '501', '502', '504', '506', '508', '510', '576', '577', '578', '579', '580', '581', '582', '584', '586', '588', '590', '592', '593', '594', '595', '596', '597', '598', '600', '602', '604', '606', '608', '609', '610', '611', '612', '613', '614', '616', '618', '620', '622', '624', '625', '626', '627', '628', '629', '630', '632', '634', '636', '638', '64', '65', '66', '67', '68', '69', '70', '704', '705', '706', '707', '708', '709', '710', '712', '714', '716', '718', '72', '720', '721', '722', '723', '724', '725', '726', '728', '730', '732', '734', '736', '737', '738', '739', '74', '740', '741', '742', '744', '746', '748', '750', '752', '753', '754', '755', '756', '757', '758', '76', '760', '762', '764', '766', '78', '80', '81', '82', '83', '832', '833', '834', '835', '836', '837', '838', '84', '840', '842', '844', '846', '848', '849', '85', '850', '851', '852', '853', '854', '856', '858', '86', '860', '862', '864', '865', '866', '867', '868', '869', '870', '872', '874', '876', '878', '88', '880', '881', '882', '883', '884', '885', '886', '888', '890', '892', '894', '90', '92', '94', '96', '960', '961', '962', '963', '964', '965', '966', '968', '97', '970', '972', '974', '976', '977', '978', '979', '98', '980', '981', '982', '984', '986', '988', '99', '990', '992', '993', '994', '995', '996', '997', '998')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'internal_search_on_site_direct'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `internal_search_on_site_direct`.`campaign_id` AS `campaign_id`,
    `internal_search_on_site_direct`.`id` AS `id`
FROM `internal_search_on_site_direct`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'internal_search_on_site_direct'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `internal_search_on_site_direct`.`campaign_id` AS `campaign_id`,
    `internal_search_on_site_direct`.`id` AS `id`
FROM `internal_search_on_site_direct`
WHERE (
    (
        `internal_search_on_site_direct`.`campaign_id` = '1'
        AND `internal_search_on_site_direct`.`id` IN ('1')
    )
    OR (
        `internal_search_on_site_direct`.`campaign_id` = '2'
        AND `internal_search_on_site_direct`.`id` IN ('1', '2')
    )
)

SELECT
    `internal_search_on_site_campaign`.`id` AS `id`
FROM `internal_search_on_site_campaign`
WHERE (
    (
        `internal_search_on_site_campaign`.`id` IN ('1', '2')
    )
    AND (
        `internal_search_on_site_campaign`.`multistate` IN ('100', '1000', '1002', '1004', '1006', '1008', '1009', '101', '1010', '1011', '1012', '1013', '1014', '1016', '1018', '102', '1020', '1022', '104', '106', '108', '110', '112', '113', '114', '115', '116', '117', '118', '120', '122', '124', '126', '192', '193', '194', '195', '196', '197', '198', '200', '202', '204', '206', '208', '209', '210', '211', '212', '213', '214', '216', '218', '220', '222', '224', '225', '226', '227', '228', '229', '230', '232', '234', '236', '238', '240', '241', '242', '243', '244', '245', '246', '248', '250', '252', '254', '320', '321', '322', '323', '324', '325', '326', '328', '330', '332', '334', '336', '337', '338', '339', '340', '341', '342', '344', '346', '348', '350', '352', '353', '354', '355', '356', '357', '358', '360', '362', '364', '366', '368', '369', '370', '371', '372', '373', '374', '376', '378', '380', '382', '448', '449', '450', '451', '452', '453', '454', '456', '458', '460', '462', '464', '465', '466', '467', '468', '469', '470', '472', '474', '476', '478', '480', '481', '482', '483', '484', '485', '486', '488', '490', '492', '494', '496', '497', '498', '499', '500', '501', '502', '504', '506', '508', '510', '576', '577', '578', '579', '580', '581', '582', '584', '586', '588', '590', '592', '593', '594', '595', '596', '597', '598', '600', '602', '604', '606', '608', '609', '610', '611', '612', '613', '614', '616', '618', '620', '622', '624', '625', '626', '627', '628', '629', '630', '632', '634', '636', '638', '64', '65', '66', '67', '68', '69', '70', '704', '705', '706', '707', '708', '709', '710', '712', '714', '716', '718', '72', '720', '721', '722', '723', '724', '725', '726', '728', '730', '732', '734', '736', '737', '738', '739', '74', '740', '741', '742', '744', '746', '748', '750', '752', '753', '754', '755', '756', '757', '758', '76', '760', '762', '764', '766', '78', '80', '81', '82', '83', '832', '833', '834', '835', '836', '837', '838', '84', '840', '842', '844', '846', '848', '849', '85', '850', '851', '852', '853', '854', '856', '858', '86', '860', '862', '864', '865', '866', '867', '868', '869', '870', '872', '874', '876', '878', '88', '880', '881', '882', '883', '884', '885', '886', '888', '890', '892', '894', '90', '92', '94', '96', '960', '961', '962', '963', '964', '965', '966', '968', '97', '970', '972', '974', '976', '977', '978', '979', '98', '980', '981', '982', '984', '986', '988', '99', '990', '992', '993', '994', '995', '996', '997', '998')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'internal_search_on_site_premium'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `internal_search_on_site_premium`.`campaign_id` AS `campaign_id`,
    `internal_search_on_site_premium`.`id` AS `id`
FROM `internal_search_on_site_premium`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'internal_search_on_site_premium'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `internal_search_on_site_premium`.`campaign_id` AS `campaign_id`,
    `internal_search_on_site_premium`.`id` AS `id`
FROM `internal_search_on_site_premium`
WHERE (
    (
        `internal_search_on_site_premium`.`campaign_id` = '1'
        AND `internal_search_on_site_premium`.`id` IN ('1')
    )
    OR (
        `internal_search_on_site_premium`.`campaign_id` = '2'
        AND `internal_search_on_site_premium`.`id` IN ('1', '2')
    )
)

SELECT
    `internal_search_on_site_campaign`.`id` AS `id`
FROM `internal_search_on_site_campaign`
WHERE (
    (
        `internal_search_on_site_campaign`.`id` IN ('1', '2')
    )
    AND (
        `internal_search_on_site_campaign`.`multistate` IN ('100', '1000', '1002', '1004', '1006', '1008', '1009', '101', '1010', '1011', '1012', '1013', '1014', '1016', '1018', '102', '1020', '1022', '104', '106', '108', '110', '112', '113', '114', '115', '116', '117', '118', '120', '122', '124', '126', '192', '193', '194', '195', '196', '197', '198', '200', '202', '204', '206', '208', '209', '210', '211', '212', '213', '214', '216', '218', '220', '222', '224', '225', '226', '227', '228', '229', '230', '232', '234', '236', '238', '240', '241', '242', '243', '244', '245', '246', '248', '250', '252', '254', '320', '321', '322', '323', '324', '325', '326', '328', '330', '332', '334', '336', '337', '338', '339', '340', '341', '342', '344', '346', '348', '350', '352', '353', '354', '355', '356', '357', '358', '360', '362', '364', '366', '368', '369', '370', '371', '372', '373', '374', '376', '378', '380', '382', '448', '449', '450', '451', '452', '453', '454', '456', '458', '460', '462', '464', '465', '466', '467', '468', '469', '470', '472', '474', '476', '478', '480', '481', '482', '483', '484', '485', '486', '488', '490', '492', '494', '496', '497', '498', '499', '500', '501', '502', '504', '506', '508', '510', '576', '577', '578', '579', '580', '581', '582', '584', '586', '588', '590', '592', '593', '594', '595', '596', '597', '598', '600', '602', '604', '606', '608', '609', '610', '611', '612', '613', '614', '616', '618', '620', '622', '624', '625', '626', '627', '628', '629', '630', '632', '634', '636', '638', '64', '65', '66', '67', '68', '69', '70', '704', '705', '706', '707', '708', '709', '710', '712', '714', '716', '718', '72', '720', '721', '722', '723', '724', '725', '726', '728', '730', '732', '734', '736', '737', '738', '739', '74', '740', '741', '742', '744', '746', '748', '750', '752', '753', '754', '755', '756', '757', '758', '76', '760', '762', '764', '766', '78', '80', '81', '82', '83', '832', '833', '834', '835', '836', '837', '838', '84', '840', '842', '844', '846', '848', '849', '85', '850', '851', '852', '853', '854', '856', '858', '86', '860', '862', '864', '865', '866', '867', '868', '869', '870', '872', '874', '876', '878', '88', '880', '881', '882', '883', '884', '885', '886', '888', '890', '892', '894', '90', '92', '94', '96', '960', '961', '962', '963', '964', '965', '966', '968', '97', '970', '972', '974', '976', '977', '978', '979', '98', '980', '981', '982', '984', '986', '988', '99', '990', '992', '993', '994', '995', '996', '997', '998')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `application_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'internal_mobile_app_rtb'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `internal_mobile_app_rtb`.`application_id` AS `application_id`,
    `internal_mobile_app_rtb`.`id` AS `id`
FROM `internal_mobile_app_rtb`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `application_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'internal_mobile_app_rtb'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `internal_mobile_app_rtb`.`application_id` AS `application_id`,
    `internal_mobile_app_rtb`.`id` AS `id`
FROM `internal_mobile_app_rtb`
WHERE (
    (
        `internal_mobile_app_rtb`.`application_id` = '1'
        AND `internal_mobile_app_rtb`.`id` IN ('1')
    )
    OR (
        `internal_mobile_app_rtb`.`application_id` = '2'
        AND `internal_mobile_app_rtb`.`id` IN ('1', '2')
    )
)

SELECT
    `internal_mobile_app`.`id` AS `id`
FROM `internal_mobile_app`
WHERE (
    (
        `internal_mobile_app`.`id` IN ('1', '2')
    )
    AND (
        `internal_mobile_app`.`multistate` IN ('113', '114', '116', '124', '145', '146', '148', '156', '17', '177', '178', '18', '180', '188', '20', '209', '210', '212', '220', '241', '242', '244', '252', '28', '49', '50', '52', '60', '81', '82', '84', '92')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `context_page_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'mobile_app_rtb'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `mobile_app_rtb`.`context_page_id` AS `context_page_id`,
    `mobile_app_rtb`.`id` AS `id`
FROM `mobile_app_rtb`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `context_page_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'mobile_app_rtb'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `mobile_app_rtb`.`context_page_id` AS `context_page_id`,
    `mobile_app_rtb`.`id` AS `id`
FROM `mobile_app_rtb`
WHERE (
    (
        `mobile_app_rtb`.`context_page_id` = '1'
        AND `mobile_app_rtb`.`id` IN ('1')
    )
    OR (
        `mobile_app_rtb`.`context_page_id` = '2'
        AND `mobile_app_rtb`.`id` IN ('1', '2')
    )
)

SELECT
    `mobile_app_settings`.`id` AS `id`
FROM `mobile_app_settings`
WHERE (
    (
        `mobile_app_settings`.`context_page_id` IN ('1', '2')
    )
    AND (
        `mobile_app_settings`.`multistate` IN ('1072', '1073', '1074', '1076', '1080', '1081', '1082', '1084', '1200', '1201', '1202', '1204', '1208', '1209', '1210', '1212', '1328', '1329', '1330', '1332', '1336', '1337', '1338', '1340', '144', '1456', '1457', '1458', '1460', '1464', '1465', '1466', '1468', '152', '1584', '1585', '1586', '1588', '1592', '1593', '1594', '1596', '16', '1712', '1713', '1714', '1716', '1720', '1721', '1722', '1724', '176', '177', '178', '180', '184', '1840', '1841', '1842', '1844', '1848', '1849', '185', '1850', '1852', '186', '188', '1968', '1969', '1970', '1972', '1976', '1977', '1978', '1980', '2064', '2072', '2096', '2097', '2098', '2100', '2104', '2105', '2106', '2108', '2320', '2328', '2352', '2353', '2354', '2356', '2360', '2361', '2362', '2364', '24', '2608', '2609', '2610', '2612', '2616', '2617', '2618', '2620', '272', '280', '2864', '2865', '2866', '2868', '2872', '2873', '2874', '2876', '304', '305', '306', '308', '312', '3120', '3121', '3122', '3124', '3128', '3129', '313', '3130', '3132', '314', '316', '3376', '3377', '3378', '3380', '3384', '3385', '3386', '3388', '3632', '3633', '3634', '3636', '3640', '3641', '3642', '3644', '3888', '3889', '3890', '3892', '3896', '3897', '3898', '3900', '400', '408', '4112', '4120', '4144', '4145', '4146', '4148', '4152', '4153', '4154', '4156', '4240', '4248', '4272', '4273', '4274', '4276', '4280', '4281', '4282', '4284', '432', '433', '434', '436', '4368', '4376', '440', '4400', '4401', '4402', '4404', '4408', '4409', '441', '4410', '4412', '442', '444', '4496', '4504', '4528', '4529', '4530', '4532', '4536', '4537', '4538', '4540', '4656', '4657', '4658', '4660', '4664', '4665', '4666', '4668', '4784', '4785', '4786', '4788', '4792', '4793', '4794', '4796', '48', '49', '4912', '4913', '4914', '4916', '4920', '4921', '4922', '4924', '50', '5040', '5041', '5042', '5044', '5048', '5049', '5050', '5052', '5168', '5169', '5170', '5172', '5176', '5177', '5178', '5180', '52', '5296', '5297', '5298', '5300', '5304', '5305', '5306', '5308', '5424', '5425', '5426', '5428', '5432', '5433', '5434', '5436', '5552', '5553', '5554', '5556', '5560', '5561', '5562', '5564', '56', '560', '561', '562', '564', '568', '5680', '5681', '5682', '5684', '5688', '5689', '569', '5690', '5692', '57', '570', '572', '58', '5808', '5809', '5810', '5812', '5816', '5817', '5818', '5820', '5936', '5937', '5938', '5940', '5944', '5945', '5946', '5948', '60', '6064', '6065', '6066', '6068', '6072', '6073', '6074', '6076', '688', '689', '690', '692', '696', '697', '698', '700', '816', '817', '818', '820', '824', '825', '826', '828', '944', '945', '946', '948', '952', '953', '954', '956')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `context_page_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'mobile_mediation_block'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `mobile_app_rtb`.`context_page_id` AS `context_page_id`,
    `mobile_app_rtb`.`id` AS `id`
FROM `mobile_app_rtb`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `context_page_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'mobile_mediation_block'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `mobile_app_rtb`.`context_page_id` AS `context_page_id`,
    `mobile_app_rtb`.`id` AS `id`
FROM `mobile_app_rtb`
WHERE (
    (
        `mobile_app_rtb`.`context_page_id` = '1'
        AND `mobile_app_rtb`.`id` IN ('1')
    )
    OR (
        `mobile_app_rtb`.`context_page_id` = '2'
        AND `mobile_app_rtb`.`id` IN ('1', '2')
    )
)

SELECT
    `mobile_app_settings`.`id` AS `id`
FROM `mobile_app_settings`
WHERE (
    (
        `mobile_app_settings`.`context_page_id` IN ('1', '2')
    )
    AND (
        `mobile_app_settings`.`multistate` IN ('1072', '1073', '1074', '1076', '1080', '1081', '1082', '1084', '1200', '1201', '1202', '1204', '1208', '1209', '1210', '1212', '1328', '1329', '1330', '1332', '1336', '1337', '1338', '1340', '144', '1456', '1457', '1458', '1460', '1464', '1465', '1466', '1468', '152', '1584', '1585', '1586', '1588', '1592', '1593', '1594', '1596', '16', '1712', '1713', '1714', '1716', '1720', '1721', '1722', '1724', '176', '177', '178', '180', '184', '1840', '1841', '1842', '1844', '1848', '1849', '185', '1850', '1852', '186', '188', '1968', '1969', '1970', '1972', '1976', '1977', '1978', '1980', '2064', '2072', '2096', '2097', '2098', '2100', '2104', '2105', '2106', '2108', '2320', '2328', '2352', '2353', '2354', '2356', '2360', '2361', '2362', '2364', '24', '2608', '2609', '2610', '2612', '2616', '2617', '2618', '2620', '272', '280', '2864', '2865', '2866', '2868', '2872', '2873', '2874', '2876', '304', '305', '306', '308', '312', '3120', '3121', '3122', '3124', '3128', '3129', '313', '3130', '3132', '314', '316', '3376', '3377', '3378', '3380', '3384', '3385', '3386', '3388', '3632', '3633', '3634', '3636', '3640', '3641', '3642', '3644', '3888', '3889', '3890', '3892', '3896', '3897', '3898', '3900', '400', '408', '4112', '4120', '4144', '4145', '4146', '4148', '4152', '4153', '4154', '4156', '4240', '4248', '4272', '4273', '4274', '4276', '4280', '4281', '4282', '4284', '432', '433', '434', '436', '4368', '4376', '440', '4400', '4401', '4402', '4404', '4408', '4409', '441', '4410', '4412', '442', '444', '4496', '4504', '4528', '4529', '4530', '4532', '4536', '4537', '4538', '4540', '4656', '4657', '4658', '4660', '4664', '4665', '4666', '4668', '4784', '4785', '4786', '4788', '4792', '4793', '4794', '4796', '48', '49', '4912', '4913', '4914', '4916', '4920', '4921', '4922', '4924', '50', '5040', '5041', '5042', '5044', '5048', '5049', '5050', '5052', '5168', '5169', '5170', '5172', '5176', '5177', '5178', '5180', '52', '5296', '5297', '5298', '5300', '5304', '5305', '5306', '5308', '5424', '5425', '5426', '5428', '5432', '5433', '5434', '5436', '5552', '5553', '5554', '5556', '5560', '5561', '5562', '5564', '56', '560', '561', '562', '564', '568', '5680', '5681', '5682', '5684', '5688', '5689', '569', '5690', '5692', '57', '570', '572', '58', '5808', '5809', '5810', '5812', '5816', '5817', '5818', '5820', '5936', '5937', '5938', '5940', '5944', '5945', '5946', '5948', '60', '6064', '6065', '6066', '6068', '6072', '6073', '6074', '6076', '688', '689', '690', '692', '696', '697', '698', '700', '816', '817', '818', '820', '824', '825', '826', '828', '944', '945', '946', '948', '952', '953', '954', '956')
    )
)

SELECT DISTINCT
    `statistics`.`block_id` AS `id`,
    `statistics`.`page_id` AS `page_id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'outdoor_block'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `outdoor_block`.`id` AS `id`,
    `outdoor_block`.`page_id` AS `page_id`
FROM `outdoor_block`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`block_id` AS `id`,
    `statistics`.`page_id` AS `page_id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'outdoor_block'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `outdoor_block`.`id` AS `id`,
    `outdoor_block`.`page_id` AS `page_id`
FROM `outdoor_block`
WHERE (
    (
        `outdoor_block`.`page_id` = '1'
        AND `outdoor_block`.`id` IN ('1')
    )
    OR (
        `outdoor_block`.`page_id` = '2'
        AND `outdoor_block`.`id` IN ('1', '2')
    )
)

SELECT
    `outdoor`.`id` AS `id`
FROM `outdoor`
WHERE (
    (
        `outdoor`.`page_id` IN ('1', '2')
    )
    AND (
        `outdoor`.`multistate` IN ('1008', '10112', '10113', '10114', '10116', '10118', '1012', '10120', '10121', '10122', '10124', '10126', '10128', '10129', '10130', '10132', '10134', '10136', '10137', '10138', '10140', '10142', '10144', '10145', '10146', '10148', '10150', '10152', '10153', '10154', '10156', '10158', '10160', '10161', '10162', '10164', '10166', '10168', '10169', '10170', '10172', '10174', '10176', '10177', '10178', '10180', '10182', '10184', '10185', '10186', '10188', '10190', '10192', '10193', '10194', '10196', '10198', '10200', '10201', '10202', '10204', '10206', '10208', '10209', '10210', '10212', '10214', '10216', '10217', '10218', '10220', '10222', '10224', '10225', '10226', '10228', '10230', '10232', '10233', '10234', '10236', '10238', '10368', '10372', '10376', '10380', '10384', '10388', '10392', '10396', '10400', '10404', '10408', '10412', '10416', '10420', '10424', '10428', '10432', '10436', '10440', '10444', '10448', '10452', '10456', '10460', '10464', '10468', '10472', '10476', '10480', '10484', '10488', '10492', '10624', '10628', '10632', '10636', '10640', '10644', '10648', '10652', '10656', '10660', '10664', '10668', '10672', '10676', '10680', '10684', '10688', '10692', '10696', '10700', '10704', '10708', '10712', '10716', '10720', '10724', '10728', '10732', '10736', '10740', '10744', '10748', '10880', '10884', '10888', '10892', '10896', '10900', '10904', '10908', '10912', '10916', '10920', '10924', '10928', '10932', '10936', '10940', '10944', '10948', '10952', '10956', '10960', '10964', '10968', '10972', '10976', '10980', '10984', '10988', '10992', '10996', '11000', '11004', '11136', '11140', '11144', '11148', '11152', '11156', '11160', '11164', '11168', '11172', '11176', '11180', '11184', '11188', '11192', '11196', '11200', '11204', '11208', '11212', '11216', '11220', '11224', '11228', '11232', '11236', '11240', '11244', '11248', '11252', '11256', '11260', '1152', '1156', '1160', '1164', '1168', '1172', '1176', '1180', '1184', '1188', '1192', '1196', '1200', '1204', '1208', '1212', '1216', '1220', '1224', '1228', '1232', '1236', '1240', '12416', '12420', '12424', '12428', '12432', '12436', '1244', '12440', '12444', '12448', '12452', '12456', '12460', '12464', '12468', '12472', '12476', '1248', '12480', '12484', '12488', '12492', '12496', '12500', '12504', '12508', '12512', '12516', '1252', '12520', '12524', '12528', '12532', '12536', '12540', '1256', '1260', '1264', '12672', '12676', '1268', '12680', '12684', '12688', '12692', '12696', '12700', '12704', '12708', '12712', '12716', '1272', '12720', '12724', '12728', '12732', '12736', '12740', '12744', '12748', '12752', '12756', '1276', '12760', '12764', '12768', '12772', '12776', '12780', '12784', '12788', '12792', '12796', '128', '12928', '12932', '12936', '12940', '12944', '12948', '12952', '12956', '12960', '12964', '12968', '12972', '12976', '12980', '12984', '12988', '12992', '12996', '13000', '13004', '13008', '13012', '13016', '13020', '13024', '13028', '13032', '13036', '13040', '13044', '13048', '13052', '13184', '13188', '13192', '13196', '132', '13200', '13204', '13208', '13212', '13216', '13220', '13224', '13228', '13232', '13236', '13240', '13244', '13248', '13252', '13256', '13260', '13264', '13268', '13272', '13276', '13280', '13284', '13288', '13292', '13296', '13300', '13304', '13308', '13440', '13444', '13448', '13452', '13456', '13460', '13464', '13468', '13472', '13476', '13480', '13484', '13488', '13492', '13496', '13500', '13504', '13508', '13512', '13516', '13520', '13524', '13528', '13532', '13536', '13540', '13544', '13548', '13552', '13556', '13560', '13564', '13696', '13697', '13698', '13700', '13702', '13704', '13705', '13706', '13708', '13710', '13712', '13713', '13714', '13716', '13718', '13720', '13721', '13722', '13724', '13726', '13728', '13729', '13730', '13732', '13734', '13736', '13737', '13738', '13740', '13742', '13744', '13745', '13746', '13748', '13750', '13752', '13753', '13754', '13756', '13758', '13760', '13761', '13762', '13764', '13766', '13768', '13769', '13770', '13772', '13774', '13776', '13777', '13778', '13780', '13782', '13784', '13785', '13786', '13788', '13790', '13792', '13793', '13794', '13796', '13798', '13800', '13801', '13802', '13804', '13806', '13808', '13809', '13810', '13812', '13814', '13816', '13817', '13818', '13820', '13822', '13952', '13956', '13960', '13964', '13968', '13972', '13976', '13980', '13984', '13988', '13992', '13996', '14000', '14004', '14008', '14012', '14016', '14020', '14024', '14028', '14032', '14036', '14040', '14044', '14048', '14052', '14056', '14060', '14064', '14068', '14072', '14076', '1408', '1409', '1410', '1412', '1414', '1416', '1417', '1418', '1420', '14208', '14209', '14210', '14212', '14214', '14216', '14217', '14218', '1422', '14220', '14222', '14224', '14225', '14226', '14228', '14230', '14232', '14233', '14234', '14236', '14238', '1424', '14240', '14241', '14242', '14244', '14246', '14248', '14249', '1425', '14250', '14252', '14254', '14256', '14257', '14258', '1426', '14260', '14262', '14264', '14265', '14266', '14268', '14270', '14272', '14273', '14274', '14276', '14278', '1428', '14280', '14281', '14282', '14284', '14286', '14288', '14289', '14290', '14292', '14294', '14296', '14297', '14298', '1430', '14300', '14302', '14304', '14305', '14306', '14308', '14310', '14312', '14313', '14314', '14316', '14318', '1432', '14320', '14321', '14322', '14324', '14326', '14328', '14329', '1433', '14330', '14332', '14334', '1434', '1436', '1438', '1440', '1441', '1442', '1444', '1446', '14464', '14468', '14472', '14476', '1448', '14480', '14484', '14488', '1449', '14492', '14496', '1450', '14500', '14504', '14508', '14512', '14516', '1452', '14520', '14524', '14528', '14532', '14536', '1454', '14540', '14544', '14548', '14552', '14556', '1456', '14560', '14564', '14568', '1457', '14572', '14576', '1458', '14580', '14584', '14588', '1460', '1462', '1464', '1465', '1466', '1468', '1470', '1472', '14720', '14724', '14728', '1473', '14732', '14736', '1474', '14740', '14744', '14748', '14752', '14756', '1476', '14760', '14764', '14768', '14772', '14776', '1478', '14780', '14784', '14788', '14792', '14796', '1480', '14800', '14804', '14808', '1481', '14812', '14816', '1482', '14820', '14824', '14828', '14832', '14836', '1484', '14840', '14844', '1486', '1488', '1489', '1490', '1492', '1494', '1496', '1497', '14976', '1498', '14980', '14984', '14988', '14992', '14996', '1500', '15000', '15004', '15008', '15012', '15016', '1502', '15020', '15024', '15028', '15032', '15036', '1504', '15040', '15044', '15048', '1505', '15052', '15056', '1506', '15060', '15064', '15068', '15072', '15076', '1508', '15080', '15084', '15088', '15092', '15096', '1510', '15100', '1512', '1513', '1514', '1516', '1518', '1520', '1521', '1522', '15232', '15236', '1524', '15240', '15244', '15248', '15252', '15256', '1526', '15260', '15264', '15268', '15272', '15276', '1528', '15280', '15284', '15288', '1529', '15292', '15296', '1530', '15300', '15304', '15308', '15312', '15316', '1532', '15320', '15324', '15328', '15332', '15336', '1534', '15340', '15344', '15348', '15352', '15356', '160', '164', '1664', '1668', '1672', '1676', '1680', '1684', '1688', '1692', '1696', '1700', '1704', '1708', '1712', '1716', '1720', '1724', '1728', '1732', '1736', '1740', '1744', '1748', '1752', '1756', '1760', '1764', '1768', '1772', '1776', '1780', '1784', '1788', '192', '1920', '1921', '1922', '1924', '1926', '1928', '1929', '1930', '1932', '1934', '1936', '1937', '1938', '1940', '1942', '1944', '1945', '1946', '1948', '1950', '1952', '1953', '1954', '1956', '1958', '196', '1960', '1961', '1962', '1964', '1966', '1968', '1969', '1970', '1972', '1974', '1976', '1977', '1978', '1980', '1982', '1984', '1985', '1986', '1988', '1990', '1992', '1993', '1994', '1996', '1998', '2000', '2001', '2002', '2004', '2006', '2008', '2009', '2010', '2012', '2014', '2016', '2017', '2018', '2020', '2022', '2024', '2025', '2026', '2028', '2030', '2032', '2033', '2034', '2036', '2038', '2040', '2041', '2042', '2044', '2046', '2176', '2180', '2192', '2196', '2208', '2212', '2224', '2228', '224', '2240', '2244', '2256', '2260', '2272', '2276', '228', '2288', '2292', '2432', '2436', '2448', '2452', '2464', '2468', '2480', '2484', '2496', '2500', '2512', '2516', '2528', '2532', '2544', '2548', '2688', '2692', '2704', '2708', '2720', '2724', '2736', '2740', '2752', '2756', '2768', '2772', '2784', '2788', '2800', '2804', '2944', '2948', '2960', '2964', '2976', '2980', '2992', '2996', '3008', '3012', '3024', '3028', '3040', '3044', '3056', '3060', '384', '388', '416', '420', '4224', '4228', '4256', '4260', '4288', '4292', '4320', '4324', '448', '4480', '4484', '4512', '4516', '452', '4544', '4548', '4576', '4580', '4736', '4740', '4752', '4756', '4768', '4772', '4784', '4788', '480', '4800', '4804', '4816', '4820', '4832', '4836', '484', '4848', '4852', '4992', '4996', '5008', '5012', '5024', '5028', '5040', '5044', '5056', '5060', '5072', '5076', '5088', '5092', '5104', '5108', '5248', '5252', '5256', '5260', '5264', '5268', '5272', '5276', '5280', '5284', '5288', '5292', '5296', '5300', '5304', '5308', '5312', '5316', '5320', '5324', '5328', '5332', '5336', '5340', '5344', '5348', '5352', '5356', '5360', '5364', '5368', '5372', '5504', '5505', '5506', '5508', '5510', '5512', '5513', '5514', '5516', '5518', '5520', '5521', '5522', '5524', '5526', '5528', '5529', '5530', '5532', '5534', '5536', '5537', '5538', '5540', '5542', '5544', '5545', '5546', '5548', '5550', '5552', '5553', '5554', '5556', '5558', '5560', '5561', '5562', '5564', '5566', '5568', '5569', '5570', '5572', '5574', '5576', '5577', '5578', '5580', '5582', '5584', '5585', '5586', '5588', '5590', '5592', '5593', '5594', '5596', '5598', '5600', '5601', '5602', '5604', '5606', '5608', '5609', '5610', '5612', '5614', '5616', '5617', '5618', '5620', '5622', '5624', '5625', '5626', '5628', '5630', '5760', '5764', '5768', '5772', '5776', '5780', '5784', '5788', '5792', '5796', '5800', '5804', '5808', '5812', '5816', '5820', '5824', '5828', '5832', '5836', '5840', '5844', '5848', '5852', '5856', '5860', '5864', '5868', '5872', '5876', '5880', '5884', '6016', '6017', '6018', '6020', '6022', '6024', '6025', '6026', '6028', '6030', '6032', '6033', '6034', '6036', '6038', '6040', '6041', '6042', '6044', '6046', '6048', '6049', '6050', '6052', '6054', '6056', '6057', '6058', '6060', '6062', '6064', '6065', '6066', '6068', '6070', '6072', '6073', '6074', '6076', '6078', '6080', '6081', '6082', '6084', '6086', '6088', '6089', '6090', '6092', '6094', '6096', '6097', '6098', '6100', '6102', '6104', '6105', '6106', '6108', '6110', '6112', '6113', '6114', '6116', '6118', '6120', '6121', '6122', '6124', '6126', '6128', '6129', '6130', '6132', '6134', '6136', '6137', '6138', '6140', '6142', '6272', '6276', '6288', '6292', '6304', '6308', '6320', '6324', '6336', '6340', '6352', '6356', '6368', '6372', '6384', '6388', '640', '644', '6528', '6532', '6544', '6548', '656', '6560', '6564', '6576', '6580', '6592', '6596', '660', '6608', '6612', '6624', '6628', '6640', '6644', '672', '676', '6784', '6788', '6800', '6804', '6816', '6820', '6832', '6836', '6848', '6852', '6864', '6868', '688', '6880', '6884', '6896', '6900', '692', '704', '7040', '7044', '7056', '7060', '7072', '7076', '708', '7088', '7092', '7104', '7108', '7120', '7124', '7136', '7140', '7152', '7156', '720', '724', '736', '740', '752', '756', '8320', '8324', '8328', '8332', '8336', '8340', '8344', '8348', '8352', '8356', '8360', '8364', '8368', '8372', '8376', '8380', '8384', '8388', '8392', '8396', '8400', '8404', '8408', '8412', '8416', '8420', '8424', '8428', '8432', '8436', '8440', '8444', '8576', '8580', '8584', '8588', '8592', '8596', '8600', '8604', '8608', '8612', '8616', '8620', '8624', '8628', '8632', '8636', '8640', '8644', '8648', '8652', '8656', '8660', '8664', '8668', '8672', '8676', '8680', '8684', '8688', '8692', '8696', '8700', '8832', '8836', '8840', '8844', '8848', '8852', '8856', '8860', '8864', '8868', '8872', '8876', '8880', '8884', '8888', '8892', '8896', '8900', '8904', '8908', '8912', '8916', '8920', '8924', '8928', '8932', '8936', '8940', '8944', '8948', '8952', '8956', '896', '900', '9088', '9092', '9096', '9100', '9104', '9108', '9112', '9116', '912', '9120', '9124', '9128', '9132', '9136', '9140', '9144', '9148', '9152', '9156', '916', '9160', '9164', '9168', '9172', '9176', '9180', '9184', '9188', '9192', '9196', '9200', '9204', '9208', '9212', '928', '932', '9344', '9348', '9352', '9356', '9360', '9364', '9368', '9372', '9376', '9380', '9384', '9388', '9392', '9396', '9400', '9404', '9408', '9412', '9416', '9420', '9424', '9428', '9432', '9436', '944', '9440', '9444', '9448', '9452', '9456', '9460', '9464', '9468', '948', '960', '9600', '9601', '9602', '9604', '9606', '9608', '9609', '9610', '9612', '9614', '9616', '9617', '9618', '9620', '9622', '9624', '9625', '9626', '9628', '9630', '9632', '9633', '9634', '9636', '9638', '964', '9640', '9641', '9642', '9644', '9646', '9648', '9649', '9650', '9652', '9654', '9656', '9657', '9658', '9660', '9662', '9664', '9665', '9666', '9668', '9670', '9672', '9673', '9674', '9676', '9678', '9680', '9681', '9682', '9684', '9686', '9688', '9689', '9690', '9692', '9694', '9696', '9697', '9698', '9700', '9702', '9704', '9705', '9706', '9708', '9710', '9712', '9713', '9714', '9716', '9718', '9720', '9721', '9722', '9724', '9726', '976', '980', '9856', '9860', '9864', '9868', '9872', '9876', '9880', '9884', '9888', '9892', '9896', '9900', '9904', '9908', '9912', '9916', '992', '9920', '9924', '9928', '9932', '9936', '9940', '9944', '9948', '9952', '9956', '996', '9960', '9964', '9968', '9972', '9976', '9980')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'ssp_context_on_site_rtb'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `ssp_context_on_site_rtb`.`campaign_id` AS `campaign_id`,
    `ssp_context_on_site_rtb`.`id` AS `id`
FROM `ssp_context_on_site_rtb`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'ssp_context_on_site_rtb'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `ssp_context_on_site_rtb`.`campaign_id` AS `campaign_id`,
    `ssp_context_on_site_rtb`.`id` AS `id`
FROM `ssp_context_on_site_rtb`
WHERE (
    (
        `ssp_context_on_site_rtb`.`campaign_id` = '1'
        AND `ssp_context_on_site_rtb`.`id` IN ('1')
    )
    OR (
        `ssp_context_on_site_rtb`.`campaign_id` = '2'
        AND `ssp_context_on_site_rtb`.`id` IN ('1', '2')
    )
)

SELECT
    `ssp_context_on_site_campaign`.`id` AS `id`
FROM `ssp_context_on_site_campaign`
WHERE (
    (
        `ssp_context_on_site_campaign`.`page_id` IN ('1', '2')
    )
    AND (
        `ssp_context_on_site_campaign`.`multistate` IN ('1000', '1008', '1009', '1010', '1012', '1016', '1020', '104', '1088', '1096', '1104', '1105', '1106', '1108', '1112', '1116', '112', '1120', '1128', '113', '1136', '1137', '1138', '114', '1140', '1144', '1148', '116', '120', '1216', '1224', '1232', '1233', '1234', '1236', '124', '1240', '1244', '1248', '1256', '1264', '1265', '1266', '1268', '1272', '1276', '1344', '1352', '1360', '1361', '1362', '1364', '1368', '1372', '1376', '1384', '1392', '1393', '1394', '1396', '1400', '1404', '1472', '1480', '1488', '1489', '1490', '1492', '1496', '1500', '1504', '1512', '1520', '1521', '1522', '1524', '1528', '1532', '1600', '1608', '1616', '1617', '1618', '1620', '1624', '1628', '1632', '1640', '1648', '1649', '1650', '1652', '1656', '1660', '1728', '1736', '1744', '1745', '1746', '1748', '1752', '1756', '1760', '1768', '1776', '1777', '1778', '1780', '1784', '1788', '1856', '1864', '1872', '1873', '1874', '1876', '1880', '1884', '1888', '1896', '1904', '1905', '1906', '1908', '1912', '1916', '192', '1984', '1992', '200', '2000', '2001', '2002', '2004', '2008', '2012', '2016', '2024', '2032', '2033', '2034', '2036', '2040', '2044', '208', '209', '210', '2112', '212', '2120', '2128', '2129', '2130', '2132', '2136', '2140', '2144', '2152', '216', '2160', '2161', '2162', '2164', '2168', '2172', '220', '224', '2240', '2248', '2256', '2257', '2258', '2260', '2264', '2268', '2272', '2280', '2288', '2289', '2290', '2292', '2296', '2300', '232', '2368', '2376', '2384', '2385', '2386', '2388', '2392', '2396', '240', '2400', '2408', '241', '2416', '2417', '2418', '242', '2420', '2424', '2428', '244', '248', '2496', '2504', '2512', '2513', '2514', '2516', '252', '2520', '2524', '2528', '2536', '2544', '2545', '2546', '2548', '2552', '2556', '2624', '2632', '2640', '2641', '2642', '2644', '2648', '2652', '2656', '2664', '2672', '2673', '2674', '2676', '2680', '2684', '2752', '2760', '2768', '2769', '2770', '2772', '2776', '2780', '2784', '2792', '2800', '2801', '2802', '2804', '2808', '2812', '2880', '2888', '2896', '2897', '2898', '2900', '2904', '2908', '2912', '2920', '2928', '2929', '2930', '2932', '2936', '2940', '3008', '3016', '3024', '3025', '3026', '3028', '3032', '3036', '3040', '3048', '3056', '3057', '3058', '3060', '3064', '3068', '3136', '3144', '3152', '3153', '3154', '3156', '3160', '3164', '3168', '3176', '3184', '3185', '3186', '3188', '3192', '3196', '320', '3264', '3272', '328', '3280', '3281', '3282', '3284', '3288', '3292', '3296', '3304', '3312', '3313', '3314', '3316', '3320', '3324', '336', '337', '338', '3392', '340', '3400', '3408', '3409', '3410', '3412', '3416', '3420', '3424', '3432', '344', '3440', '3441', '3442', '3444', '3448', '3452', '348', '352', '3520', '3528', '3536', '3537', '3538', '3540', '3544', '3548', '3552', '3560', '3568', '3569', '3570', '3572', '3576', '3580', '360', '3648', '3656', '3664', '3665', '3666', '3668', '3672', '3676', '368', '3680', '3688', '369', '3696', '3697', '3698', '370', '3700', '3704', '3708', '372', '376', '3776', '3784', '3792', '3793', '3794', '3796', '380', '3800', '3804', '3808', '3816', '3824', '3825', '3826', '3828', '3832', '3836', '3904', '3912', '3920', '3921', '3922', '3924', '3928', '3932', '3936', '3944', '3952', '3953', '3954', '3956', '3960', '3964', '4032', '4040', '4048', '4049', '4050', '4052', '4056', '4060', '4064', '4072', '4080', '4081', '4082', '4084', '4088', '4092', '4160', '4168', '4176', '4177', '4178', '4180', '4184', '4188', '4192', '4200', '4208', '4209', '4210', '4212', '4216', '4220', '4288', '4296', '4304', '4305', '4306', '4308', '4312', '4316', '4320', '4328', '4336', '4337', '4338', '4340', '4344', '4348', '4416', '4424', '4432', '4433', '4434', '4436', '4440', '4444', '4448', '4456', '4464', '4465', '4466', '4468', '4472', '4476', '448', '4544', '4552', '456', '4560', '4561', '4562', '4564', '4568', '4572', '4576', '4584', '4592', '4593', '4594', '4596', '4600', '4604', '464', '465', '466', '4672', '468', '4680', '4688', '4689', '4690', '4692', '4696', '4700', '4704', '4712', '472', '4720', '4721', '4722', '4724', '4728', '4732', '476', '480', '4800', '4808', '4816', '4817', '4818', '4820', '4824', '4828', '4832', '4840', '4848', '4849', '4850', '4852', '4856', '4860', '488', '4928', '4936', '4944', '4945', '4946', '4948', '4952', '4956', '496', '4960', '4968', '497', '4976', '4977', '4978', '498', '4980', '4984', '4988', '500', '504', '5056', '5064', '5072', '5073', '5074', '5076', '508', '5080', '5084', '5088', '5096', '5104', '5105', '5106', '5108', '5112', '5116', '5184', '5192', '5200', '5201', '5202', '5204', '5208', '5212', '5216', '5224', '5232', '5233', '5234', '5236', '5240', '5244', '5312', '5320', '5328', '5329', '5330', '5332', '5336', '5340', '5344', '5352', '5360', '5361', '5362', '5364', '5368', '5372', '5440', '5448', '5456', '5457', '5458', '5460', '5464', '5468', '5472', '5480', '5488', '5489', '5490', '5492', '5496', '5500', '5568', '5576', '5584', '5585', '5586', '5588', '5592', '5596', '5600', '5608', '5616', '5617', '5618', '5620', '5624', '5628', '5696', '5704', '5712', '5713', '5714', '5716', '5720', '5724', '5728', '5736', '5744', '5745', '5746', '5748', '5752', '5756', '576', '5824', '5832', '584', '5840', '5841', '5842', '5844', '5848', '5852', '5856', '5864', '5872', '5873', '5874', '5876', '5880', '5884', '592', '593', '594', '5952', '596', '5960', '5968', '5969', '5970', '5972', '5976', '5980', '5984', '5992', '600', '6000', '6001', '6002', '6004', '6008', '6012', '604', '608', '6080', '6088', '6096', '6097', '6098', '6100', '6104', '6108', '6112', '6120', '6128', '6129', '6130', '6132', '6136', '6140', '616', '6208', '6216', '6224', '6225', '6226', '6228', '6232', '6236', '624', '6240', '6248', '625', '6256', '6257', '6258', '626', '6260', '6264', '6268', '628', '632', '6336', '6344', '6352', '6353', '6354', '6356', '636', '6360', '6364', '6368', '6376', '6384', '6385', '6386', '6388', '6392', '6396', '64', '6464', '6472', '6480', '6481', '6482', '6484', '6488', '6492', '6496', '6504', '6512', '6513', '6514', '6516', '6520', '6524', '6592', '6600', '6608', '6609', '6610', '6612', '6616', '6620', '6624', '6632', '6640', '6641', '6642', '6644', '6648', '6652', '6720', '6728', '6736', '6737', '6738', '6740', '6744', '6748', '6752', '6760', '6768', '6769', '6770', '6772', '6776', '6780', '6848', '6856', '6864', '6865', '6866', '6868', '6872', '6876', '6880', '6888', '6896', '6897', '6898', '6900', '6904', '6908', '6976', '6984', '6992', '6993', '6994', '6996', '7000', '7004', '7008', '7016', '7024', '7025', '7026', '7028', '7032', '7036', '704', '7104', '7112', '712', '7120', '7121', '7122', '7124', '7128', '7132', '7136', '7144', '7152', '7153', '7154', '7156', '7160', '7164', '72', '720', '721', '722', '7232', '724', '7240', '7248', '7249', '7250', '7252', '7256', '7260', '7264', '7272', '728', '7280', '7281', '7282', '7284', '7288', '7292', '732', '736', '7360', '7368', '7376', '7377', '7378', '7380', '7384', '7388', '7392', '7400', '7408', '7409', '7410', '7412', '7416', '7420', '744', '7488', '7496', '7504', '7505', '7506', '7508', '7512', '7516', '752', '7520', '7528', '753', '7536', '7537', '7538', '754', '7540', '7544', '7548', '756', '760', '7616', '7624', '7632', '7633', '7634', '7636', '764', '7640', '7644', '7648', '7656', '7664', '7665', '7666', '7668', '7672', '7676', '7744', '7752', '7760', '7761', '7762', '7764', '7768', '7772', '7776', '7784', '7792', '7793', '7794', '7796', '7800', '7804', '7872', '7880', '7888', '7889', '7890', '7892', '7896', '7900', '7904', '7912', '7920', '7921', '7922', '7924', '7928', '7932', '80', '8000', '8008', '8016', '8017', '8018', '8020', '8024', '8028', '8032', '8040', '8048', '8049', '8050', '8052', '8056', '8060', '81', '8128', '8136', '8144', '8145', '8146', '8148', '8152', '8156', '8160', '8168', '8176', '8177', '8178', '8180', '8184', '8188', '82', '832', '84', '840', '848', '849', '850', '852', '856', '860', '864', '872', '88', '880', '881', '882', '884', '888', '892', '92', '96', '960', '968', '976', '977', '978', '980', '984', '988', '992')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'ssp_mobile_app_rtb'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `ssp_mobile_app_rtb`.`campaign_id` AS `campaign_id`,
    `ssp_mobile_app_rtb`.`id` AS `id`
FROM `ssp_mobile_app_rtb`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'ssp_mobile_app_rtb'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `ssp_mobile_app_rtb`.`campaign_id` AS `campaign_id`,
    `ssp_mobile_app_rtb`.`id` AS `id`
FROM `ssp_mobile_app_rtb`
WHERE (
    (
        `ssp_mobile_app_rtb`.`campaign_id` = '1'
        AND `ssp_mobile_app_rtb`.`id` IN ('1')
    )
    OR (
        `ssp_mobile_app_rtb`.`campaign_id` = '2'
        AND `ssp_mobile_app_rtb`.`id` IN ('1', '2')
    )
)

SELECT
    `ssp_mobile_app_settings`.`id` AS `id`
FROM `ssp_mobile_app_settings`
WHERE (
    (
        `ssp_mobile_app_settings`.`page_id` IN ('1', '2')
    )
    AND (
        `ssp_mobile_app_settings`.`multistate` IN ('1000', '1008', '1009', '1010', '1012', '1016', '1020', '104', '1088', '1096', '1104', '1105', '1106', '1108', '1112', '1116', '112', '1120', '1128', '113', '1136', '1137', '1138', '114', '1140', '1144', '1148', '116', '120', '1216', '1224', '1232', '1233', '1234', '1236', '124', '1240', '1244', '1248', '1256', '1264', '1265', '1266', '1268', '1272', '1276', '1344', '1352', '1360', '1361', '1362', '1364', '1368', '1372', '1376', '1384', '1392', '1393', '1394', '1396', '1400', '1404', '1472', '1480', '1488', '1489', '1490', '1492', '1496', '1500', '1504', '1512', '1520', '1521', '1522', '1524', '1528', '1532', '1600', '1608', '1616', '1617', '1618', '1620', '1624', '1628', '1632', '1640', '1648', '1649', '1650', '1652', '1656', '1660', '1728', '1736', '1744', '1745', '1746', '1748', '1752', '1756', '1760', '1768', '1776', '1777', '1778', '1780', '1784', '1788', '1856', '1864', '1872', '1873', '1874', '1876', '1880', '1884', '1888', '1896', '1904', '1905', '1906', '1908', '1912', '1916', '192', '1984', '1992', '200', '2000', '2001', '2002', '2004', '2008', '2012', '2016', '2024', '2032', '2033', '2034', '2036', '2040', '2044', '208', '209', '210', '2112', '212', '2120', '2128', '2129', '2130', '2132', '2136', '2140', '2144', '2152', '216', '2160', '2161', '2162', '2164', '2168', '2172', '220', '224', '2240', '2248', '2256', '2257', '2258', '2260', '2264', '2268', '2272', '2280', '2288', '2289', '2290', '2292', '2296', '2300', '232', '2368', '2376', '2384', '2385', '2386', '2388', '2392', '2396', '240', '2400', '2408', '241', '2416', '2417', '2418', '242', '2420', '2424', '2428', '244', '248', '2496', '2504', '2512', '2513', '2514', '2516', '252', '2520', '2524', '2528', '2536', '2544', '2545', '2546', '2548', '2552', '2556', '2624', '2632', '2640', '2641', '2642', '2644', '2648', '2652', '2656', '2664', '2672', '2673', '2674', '2676', '2680', '2684', '2752', '2760', '2768', '2769', '2770', '2772', '2776', '2780', '2784', '2792', '2800', '2801', '2802', '2804', '2808', '2812', '2880', '2888', '2896', '2897', '2898', '2900', '2904', '2908', '2912', '2920', '2928', '2929', '2930', '2932', '2936', '2940', '3008', '3016', '3024', '3025', '3026', '3028', '3032', '3036', '3040', '3048', '3056', '3057', '3058', '3060', '3064', '3068', '3136', '3144', '3152', '3153', '3154', '3156', '3160', '3164', '3168', '3176', '3184', '3185', '3186', '3188', '3192', '3196', '320', '3264', '3272', '328', '3280', '3281', '3282', '3284', '3288', '3292', '3296', '3304', '3312', '3313', '3314', '3316', '3320', '3324', '336', '337', '338', '3392', '340', '3400', '3408', '3409', '3410', '3412', '3416', '3420', '3424', '3432', '344', '3440', '3441', '3442', '3444', '3448', '3452', '348', '352', '3520', '3528', '3536', '3537', '3538', '3540', '3544', '3548', '3552', '3560', '3568', '3569', '3570', '3572', '3576', '3580', '360', '3648', '3656', '3664', '3665', '3666', '3668', '3672', '3676', '368', '3680', '3688', '369', '3696', '3697', '3698', '370', '3700', '3704', '3708', '372', '376', '3776', '3784', '3792', '3793', '3794', '3796', '380', '3800', '3804', '3808', '3816', '3824', '3825', '3826', '3828', '3832', '3836', '3904', '3912', '3920', '3921', '3922', '3924', '3928', '3932', '3936', '3944', '3952', '3953', '3954', '3956', '3960', '3964', '4032', '4040', '4048', '4049', '4050', '4052', '4056', '4060', '4064', '4072', '4080', '4081', '4082', '4084', '4088', '4092', '4160', '4168', '4176', '4177', '4178', '4180', '4184', '4188', '4192', '4200', '4208', '4209', '4210', '4212', '4216', '4220', '4288', '4296', '4304', '4305', '4306', '4308', '4312', '4316', '4320', '4328', '4336', '4337', '4338', '4340', '4344', '4348', '4416', '4424', '4432', '4433', '4434', '4436', '4440', '4444', '4448', '4456', '4464', '4465', '4466', '4468', '4472', '4476', '448', '4544', '4552', '456', '4560', '4561', '4562', '4564', '4568', '4572', '4576', '4584', '4592', '4593', '4594', '4596', '4600', '4604', '464', '465', '466', '4672', '468', '4680', '4688', '4689', '4690', '4692', '4696', '4700', '4704', '4712', '472', '4720', '4721', '4722', '4724', '4728', '4732', '476', '480', '4800', '4808', '4816', '4817', '4818', '4820', '4824', '4828', '4832', '4840', '4848', '4849', '4850', '4852', '4856', '4860', '488', '4928', '4936', '4944', '4945', '4946', '4948', '4952', '4956', '496', '4960', '4968', '497', '4976', '4977', '4978', '498', '4980', '4984', '4988', '500', '504', '5056', '5064', '5072', '5073', '5074', '5076', '508', '5080', '5084', '5088', '5096', '5104', '5105', '5106', '5108', '5112', '5116', '5184', '5192', '5200', '5201', '5202', '5204', '5208', '5212', '5216', '5224', '5232', '5233', '5234', '5236', '5240', '5244', '5312', '5320', '5328', '5329', '5330', '5332', '5336', '5340', '5344', '5352', '5360', '5361', '5362', '5364', '5368', '5372', '5440', '5448', '5456', '5457', '5458', '5460', '5464', '5468', '5472', '5480', '5488', '5489', '5490', '5492', '5496', '5500', '5568', '5576', '5584', '5585', '5586', '5588', '5592', '5596', '5600', '5608', '5616', '5617', '5618', '5620', '5624', '5628', '5696', '5704', '5712', '5713', '5714', '5716', '5720', '5724', '5728', '5736', '5744', '5745', '5746', '5748', '5752', '5756', '576', '5824', '5832', '584', '5840', '5841', '5842', '5844', '5848', '5852', '5856', '5864', '5872', '5873', '5874', '5876', '5880', '5884', '592', '593', '594', '5952', '596', '5960', '5968', '5969', '5970', '5972', '5976', '5980', '5984', '5992', '600', '6000', '6001', '6002', '6004', '6008', '6012', '604', '608', '6080', '6088', '6096', '6097', '6098', '6100', '6104', '6108', '6112', '6120', '6128', '6129', '6130', '6132', '6136', '6140', '616', '6208', '6216', '6224', '6225', '6226', '6228', '6232', '6236', '624', '6240', '6248', '625', '6256', '6257', '6258', '626', '6260', '6264', '6268', '628', '632', '6336', '6344', '6352', '6353', '6354', '6356', '636', '6360', '6364', '6368', '6376', '6384', '6385', '6386', '6388', '6392', '6396', '64', '6464', '6472', '6480', '6481', '6482', '6484', '6488', '6492', '6496', '6504', '6512', '6513', '6514', '6516', '6520', '6524', '6592', '6600', '6608', '6609', '6610', '6612', '6616', '6620', '6624', '6632', '6640', '6641', '6642', '6644', '6648', '6652', '6720', '6728', '6736', '6737', '6738', '6740', '6744', '6748', '6752', '6760', '6768', '6769', '6770', '6772', '6776', '6780', '6848', '6856', '6864', '6865', '6866', '6868', '6872', '6876', '6880', '6888', '6896', '6897', '6898', '6900', '6904', '6908', '6976', '6984', '6992', '6993', '6994', '6996', '7000', '7004', '7008', '7016', '7024', '7025', '7026', '7028', '7032', '7036', '704', '7104', '7112', '712', '7120', '7121', '7122', '7124', '7128', '7132', '7136', '7144', '7152', '7153', '7154', '7156', '7160', '7164', '72', '720', '721', '722', '7232', '724', '7240', '7248', '7249', '7250', '7252', '7256', '7260', '7264', '7272', '728', '7280', '7281', '7282', '7284', '7288', '7292', '732', '736', '7360', '7368', '7376', '7377', '7378', '7380', '7384', '7388', '7392', '7400', '7408', '7409', '7410', '7412', '7416', '7420', '744', '7488', '7496', '7504', '7505', '7506', '7508', '7512', '7516', '752', '7520', '7528', '753', '7536', '7537', '7538', '754', '7540', '7544', '7548', '756', '760', '7616', '7624', '7632', '7633', '7634', '7636', '764', '7640', '7644', '7648', '7656', '7664', '7665', '7666', '7668', '7672', '7676', '7744', '7752', '7760', '7761', '7762', '7764', '7768', '7772', '7776', '7784', '7792', '7793', '7794', '7796', '7800', '7804', '7872', '7880', '7888', '7889', '7890', '7892', '7896', '7900', '7904', '7912', '7920', '7921', '7922', '7924', '7928', '7932', '80', '8000', '8008', '8016', '8017', '8018', '8020', '8024', '8028', '8032', '8040', '8048', '8049', '8050', '8052', '8056', '8060', '81', '8128', '8136', '8144', '8145', '8146', '8148', '8152', '8156', '8160', '8168', '8176', '8177', '8178', '8180', '8184', '8188', '82', '832', '84', '840', '848', '849', '850', '852', '856', '860', '864', '872', '88', '880', '881', '882', '884', '888', '892', '92', '96', '960', '968', '976', '977', '978', '980', '984', '988', '992')
    )
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'ssp_video_an_site_rtb'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `ssp_video_an_site_rtb`.`campaign_id` AS `campaign_id`,
    `ssp_video_an_site_rtb`.`id` AS `id`
FROM `ssp_video_an_site_rtb`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`page_id` AS `campaign_id`,
    `statistics`.`block_id` AS `id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'ssp_video_an_site_rtb'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `ssp_video_an_site_rtb`.`campaign_id` AS `campaign_id`,
    `ssp_video_an_site_rtb`.`id` AS `id`
FROM `ssp_video_an_site_rtb`
WHERE (
    (
        `ssp_video_an_site_rtb`.`campaign_id` = '1'
        AND `ssp_video_an_site_rtb`.`id` IN ('1')
    )
    OR (
        `ssp_video_an_site_rtb`.`campaign_id` = '2'
        AND `ssp_video_an_site_rtb`.`id` IN ('1', '2')
    )
)

SELECT
    `ssp_video_an_site`.`id` AS `id`
FROM `ssp_video_an_site`
WHERE (
    (
        `ssp_video_an_site`.`page_id` IN ('1', '2')
    )
    AND (
        `ssp_video_an_site`.`multistate` IN ('1000', '1008', '1009', '1010', '1012', '1016', '1020', '104', '1088', '1096', '1104', '1105', '1106', '1108', '1112', '1116', '112', '1120', '1128', '113', '1136', '1137', '1138', '114', '1140', '1144', '1148', '116', '120', '1216', '1224', '1232', '1233', '1234', '1236', '124', '1240', '1244', '1248', '1256', '1264', '1265', '1266', '1268', '1272', '1276', '1344', '1352', '1360', '1361', '1362', '1364', '1368', '1372', '1376', '1384', '1392', '1393', '1394', '1396', '1400', '1404', '1472', '1480', '1488', '1489', '1490', '1492', '1496', '1500', '1504', '1512', '1520', '1521', '1522', '1524', '1528', '1532', '1600', '1608', '1616', '1617', '1618', '1620', '1624', '1628', '1632', '1640', '1648', '1649', '1650', '1652', '1656', '1660', '1728', '1736', '1744', '1745', '1746', '1748', '1752', '1756', '1760', '1768', '1776', '1777', '1778', '1780', '1784', '1788', '1856', '1864', '1872', '1873', '1874', '1876', '1880', '1884', '1888', '1896', '1904', '1905', '1906', '1908', '1912', '1916', '192', '1984', '1992', '200', '2000', '2001', '2002', '2004', '2008', '2012', '2016', '2024', '2032', '2033', '2034', '2036', '2040', '2044', '208', '209', '210', '2112', '212', '2120', '2128', '2129', '2130', '2132', '2136', '2140', '2144', '2152', '216', '2160', '2161', '2162', '2164', '2168', '2172', '220', '224', '2240', '2248', '2256', '2257', '2258', '2260', '2264', '2268', '2272', '2280', '2288', '2289', '2290', '2292', '2296', '2300', '232', '2368', '2376', '2384', '2385', '2386', '2388', '2392', '2396', '240', '2400', '2408', '241', '2416', '2417', '2418', '242', '2420', '2424', '2428', '244', '248', '2496', '2504', '2512', '2513', '2514', '2516', '252', '2520', '2524', '2528', '2536', '2544', '2545', '2546', '2548', '2552', '2556', '2624', '2632', '2640', '2641', '2642', '2644', '2648', '2652', '2656', '2664', '2672', '2673', '2674', '2676', '2680', '2684', '2752', '2760', '2768', '2769', '2770', '2772', '2776', '2780', '2784', '2792', '2800', '2801', '2802', '2804', '2808', '2812', '2880', '2888', '2896', '2897', '2898', '2900', '2904', '2908', '2912', '2920', '2928', '2929', '2930', '2932', '2936', '2940', '3008', '3016', '3024', '3025', '3026', '3028', '3032', '3036', '3040', '3048', '3056', '3057', '3058', '3060', '3064', '3068', '3136', '3144', '3152', '3153', '3154', '3156', '3160', '3164', '3168', '3176', '3184', '3185', '3186', '3188', '3192', '3196', '320', '3264', '3272', '328', '3280', '3281', '3282', '3284', '3288', '3292', '3296', '3304', '3312', '3313', '3314', '3316', '3320', '3324', '336', '337', '338', '3392', '340', '3400', '3408', '3409', '3410', '3412', '3416', '3420', '3424', '3432', '344', '3440', '3441', '3442', '3444', '3448', '3452', '348', '352', '3520', '3528', '3536', '3537', '3538', '3540', '3544', '3548', '3552', '3560', '3568', '3569', '3570', '3572', '3576', '3580', '360', '3648', '3656', '3664', '3665', '3666', '3668', '3672', '3676', '368', '3680', '3688', '369', '3696', '3697', '3698', '370', '3700', '3704', '3708', '372', '376', '3776', '3784', '3792', '3793', '3794', '3796', '380', '3800', '3804', '3808', '3816', '3824', '3825', '3826', '3828', '3832', '3836', '3904', '3912', '3920', '3921', '3922', '3924', '3928', '3932', '3936', '3944', '3952', '3953', '3954', '3956', '3960', '3964', '4032', '4040', '4048', '4049', '4050', '4052', '4056', '4060', '4064', '4072', '4080', '4081', '4082', '4084', '4088', '4092', '4160', '4168', '4176', '4177', '4178', '4180', '4184', '4188', '4192', '4200', '4208', '4209', '4210', '4212', '4216', '4220', '4288', '4296', '4304', '4305', '4306', '4308', '4312', '4316', '4320', '4328', '4336', '4337', '4338', '4340', '4344', '4348', '4416', '4424', '4432', '4433', '4434', '4436', '4440', '4444', '4448', '4456', '4464', '4465', '4466', '4468', '4472', '4476', '448', '4544', '4552', '456', '4560', '4561', '4562', '4564', '4568', '4572', '4576', '4584', '4592', '4593', '4594', '4596', '4600', '4604', '464', '465', '466', '4672', '468', '4680', '4688', '4689', '4690', '4692', '4696', '4700', '4704', '4712', '472', '4720', '4721', '4722', '4724', '4728', '4732', '476', '480', '4800', '4808', '4816', '4817', '4818', '4820', '4824', '4828', '4832', '4840', '4848', '4849', '4850', '4852', '4856', '4860', '488', '4928', '4936', '4944', '4945', '4946', '4948', '4952', '4956', '496', '4960', '4968', '497', '4976', '4977', '4978', '498', '4980', '4984', '4988', '500', '504', '5056', '5064', '5072', '5073', '5074', '5076', '508', '5080', '5084', '5088', '5096', '5104', '5105', '5106', '5108', '5112', '5116', '5184', '5192', '5200', '5201', '5202', '5204', '5208', '5212', '5216', '5224', '5232', '5233', '5234', '5236', '5240', '5244', '5312', '5320', '5328', '5329', '5330', '5332', '5336', '5340', '5344', '5352', '5360', '5361', '5362', '5364', '5368', '5372', '5440', '5448', '5456', '5457', '5458', '5460', '5464', '5468', '5472', '5480', '5488', '5489', '5490', '5492', '5496', '5500', '5568', '5576', '5584', '5585', '5586', '5588', '5592', '5596', '5600', '5608', '5616', '5617', '5618', '5620', '5624', '5628', '5696', '5704', '5712', '5713', '5714', '5716', '5720', '5724', '5728', '5736', '5744', '5745', '5746', '5748', '5752', '5756', '576', '5824', '5832', '584', '5840', '5841', '5842', '5844', '5848', '5852', '5856', '5864', '5872', '5873', '5874', '5876', '5880', '5884', '592', '593', '594', '5952', '596', '5960', '5968', '5969', '5970', '5972', '5976', '5980', '5984', '5992', '600', '6000', '6001', '6002', '6004', '6008', '6012', '604', '608', '6080', '6088', '6096', '6097', '6098', '6100', '6104', '6108', '6112', '6120', '6128', '6129', '6130', '6132', '6136', '6140', '616', '6208', '6216', '6224', '6225', '6226', '6228', '6232', '6236', '624', '6240', '6248', '625', '6256', '6257', '6258', '626', '6260', '6264', '6268', '628', '632', '6336', '6344', '6352', '6353', '6354', '6356', '636', '6360', '6364', '6368', '6376', '6384', '6385', '6386', '6388', '6392', '6396', '64', '6464', '6472', '6480', '6481', '6482', '6484', '6488', '6492', '6496', '6504', '6512', '6513', '6514', '6516', '6520', '6524', '6592', '6600', '6608', '6609', '6610', '6612', '6616', '6620', '6624', '6632', '6640', '6641', '6642', '6644', '6648', '6652', '6720', '6728', '6736', '6737', '6738', '6740', '6744', '6748', '6752', '6760', '6768', '6769', '6770', '6772', '6776', '6780', '6848', '6856', '6864', '6865', '6866', '6868', '6872', '6876', '6880', '6888', '6896', '6897', '6898', '6900', '6904', '6908', '6976', '6984', '6992', '6993', '6994', '6996', '7000', '7004', '7008', '7016', '7024', '7025', '7026', '7028', '7032', '7036', '704', '7104', '7112', '712', '7120', '7121', '7122', '7124', '7128', '7132', '7136', '7144', '7152', '7153', '7154', '7156', '7160', '7164', '72', '720', '721', '722', '7232', '724', '7240', '7248', '7249', '7250', '7252', '7256', '7260', '7264', '7272', '728', '7280', '7281', '7282', '7284', '7288', '7292', '732', '736', '7360', '7368', '7376', '7377', '7378', '7380', '7384', '7388', '7392', '7400', '7408', '7409', '7410', '7412', '7416', '7420', '744', '7488', '7496', '7504', '7505', '7506', '7508', '7512', '7516', '752', '7520', '7528', '753', '7536', '7537', '7538', '754', '7540', '7544', '7548', '756', '760', '7616', '7624', '7632', '7633', '7634', '7636', '764', '7640', '7644', '7648', '7656', '7664', '7665', '7666', '7668', '7672', '7676', '7744', '7752', '7760', '7761', '7762', '7764', '7768', '7772', '7776', '7784', '7792', '7793', '7794', '7796', '7800', '7804', '7872', '7880', '7888', '7889', '7890', '7892', '7896', '7900', '7904', '7912', '7920', '7921', '7922', '7924', '7928', '7932', '80', '8000', '8008', '8016', '8017', '8018', '8020', '8024', '8028', '8032', '8040', '8048', '8049', '8050', '8052', '8056', '8060', '81', '8128', '8136', '8144', '8145', '8146', '8148', '8152', '8156', '8160', '8168', '8176', '8177', '8178', '8180', '8184', '8188', '82', '832', '84', '840', '848', '849', '850', '852', '856', '860', '864', '872', '88', '880', '881', '882', '884', '888', '892', '92', '96', '960', '968', '976', '977', '978', '980', '984', '988', '992')
    )
)

SELECT DISTINCT
    `statistics`.`block_id` AS `id`,
    `statistics`.`page_id` AS `page_id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'video_an_site_fullscreen'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `video_an_site_fullscreen`.`id` AS `id`,
    `video_an_site_fullscreen`.`page_id` AS `page_id`
FROM `video_an_site_fullscreen`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`block_id` AS `id`,
    `statistics`.`page_id` AS `page_id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'video_an_site_fullscreen'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `video_an_site_fullscreen`.`id` AS `id`,
    `video_an_site_fullscreen`.`page_id` AS `page_id`
FROM `video_an_site_fullscreen`
WHERE (
    (
        `video_an_site_fullscreen`.`page_id` = '1'
        AND `video_an_site_fullscreen`.`id` IN ('1')
    )
    OR (
        `video_an_site_fullscreen`.`page_id` = '2'
        AND `video_an_site_fullscreen`.`id` IN ('1', '2')
    )
)

SELECT
    `video_an_site`.`id` AS `id`
FROM `video_an_site`
WHERE (
    (
        `video_an_site`.`id` IN ('1', '2')
    )
    AND (
        `video_an_site`.`multistate` IN ('113', '114', '116', '124', '145', '146', '148', '156', '17', '177', '178', '18', '180', '188', '20', '209', '210', '212', '220', '241', '242', '244', '252', '28', '49', '50', '52', '60', '81', '82', '84', '92')
    )
)

SELECT DISTINCT
    `statistics`.`block_id` AS `id`,
    `statistics`.`page_id` AS `page_id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'video_an_site_inpage'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `video_an_site_inpage`.`id` AS `id`,
    `video_an_site_inpage`.`page_id` AS `page_id`
FROM `video_an_site_inpage`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`block_id` AS `id`,
    `statistics`.`page_id` AS `page_id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'video_an_site_inpage'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `video_an_site_inpage`.`id` AS `id`,
    `video_an_site_inpage`.`page_id` AS `page_id`
FROM `video_an_site_inpage`
WHERE (
    (
        `video_an_site_inpage`.`page_id` = '1'
        AND `video_an_site_inpage`.`id` IN ('1')
    )
    OR (
        `video_an_site_inpage`.`page_id` = '2'
        AND `video_an_site_inpage`.`id` IN ('1', '2')
    )
)

SELECT
    `video_an_site`.`id` AS `id`
FROM `video_an_site`
WHERE (
    (
        `video_an_site`.`id` IN ('1', '2')
    )
    AND (
        `video_an_site`.`multistate` IN ('113', '114', '116', '124', '145', '146', '148', '156', '17', '177', '178', '18', '180', '188', '20', '209', '210', '212', '220', '241', '242', '244', '252', '28', '49', '50', '52', '60', '81', '82', '84', '92')
    )
)

SELECT DISTINCT
    `statistics`.`block_id` AS `id`,
    `statistics`.`page_id` AS `page_id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'video_an_site_instream'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `video_an_site_instream`.`id` AS `id`,
    `video_an_site_instream`.`page_id` AS `page_id`
FROM `video_an_site_instream`
WHERE (
    NULL
)

SELECT DISTINCT
    `statistics`.`block_id` AS `id`,
    `statistics`.`page_id` AS `page_id`
FROM `statistics`
WHERE (
    `statistics`.`dt` = '2019-07-25'
    AND `statistics`.`shows` > 0
    AND `statistics`.`product_id` = 'video_an_site_instream'
    AND bitAnd(dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`statistics`.`product_id`), toUInt32(`statistics`.`page_id`), toUInt32(`statistics`.`block_id`))), 4)
) FORMAT JSONCompact

SELECT
    `video_an_site_instream`.`id` AS `id`,
    `video_an_site_instream`.`page_id` AS `page_id`
FROM `video_an_site_instream`
WHERE (
    (
        `video_an_site_instream`.`page_id` = '1'
        AND `video_an_site_instream`.`id` IN ('1')
    )
    OR (
        `video_an_site_instream`.`page_id` = '2'
        AND `video_an_site_instream`.`id` IN ('1', '2')
    )
)

SELECT
    `video_an_site`.`id` AS `id`
FROM `video_an_site`
WHERE (
    (
        `video_an_site`.`id` IN ('1', '2')
    )
    AND (
        `video_an_site`.`multistate` IN ('113', '114', '116', '124', '145', '146', '148', '156', '17', '177', '178', '18', '180', '188', '20', '209', '210', '212', '220', '241', '242', '244', '252', '28', '49', '50', '52', '60', '81', '82', '84', '92')
    )
)
