SELECT
    `_additional_income_partner_wo_nds` AS `additional_income_partner_wo_nds`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_login` AS `login`
FROM (
    SELECT
        round((SUM((`partner_wo_nds` / 1000)) / 10000000), 2) AS `_additional_income_partner_wo_nds`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetString('users_dict', 'login', toUInt64(`user_id`)) AS `_login`
    FROM `statistics_additional_income`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND (
            dictGetString('users_dict', 'login', toUInt64(`user_id`)) = 'mock__login'
        )
        AND (
            dictGetUInt8('users_dict', 'is_efir_blogger', toUInt64(`user_id`)) = 1
            OR dictGetUInt8('users_dict', 'is_video_blogger', toUInt64(`user_id`)) = 1
            OR dictGetUInt8('users_dict', 'is_tutby', toUInt64(`user_id`)) = 1
            OR dictGetUInt8('users_dict', 'is_adfox_partner', toUInt64(`user_id`)) = 1
            OR dictGetUInt8('users_dict', 'is_mobile_mediation', toUInt64(`user_id`)) = 1
            OR dictGetUInt8('users_dict', 'is_games', toUInt64(`user_id`)) = 1
        )
        AND (
            dictGetString('users_dict', 'email', toUInt64(`user_id`)) = 'mock__email'
        )
        AND (
            dictGetString('users_dict', 'phone', toUInt64(`user_id`)) = 'mock__phone'
        )
        AND (
            dictGetUInt32('users_dict', 'client_id', toUInt64(`user_id`)) = 'mock__client_id'
        )
        AND (
            dictGetUInt32('users_dict', 'client_id', toUInt64(`user_id`)) IN ('mock__contract_id')
        )
        AND (
            dictGetString('users_dict', 'lastname', toUInt64(`user_id`)) = 'mock__lastname'
        )
        AND (
            dictGetString('users_dict', 'name', toUInt64(`user_id`)) = 'mock__name'
        )
        AND (
            `user_id` = 'mock__id'
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
    )
    GROUP BY `_currency_id`, `_date`, `_login`
) `statistics`
WHERE (
    (if(isNaN(`additional_income_partner_wo_nds`), 0, `additional_income_partner_wo_nds`)) > 0
) FORMAT JSONCompact
