SELECT
    `_adblock_all_wo_nds` AS `adblock_all_wo_nds`,
    `_adblock_block_all_hits` AS `adblock_block_all_hits`,
    `_adblock_block_cover_ratio` AS `adblock_block_cover_ratio`,
    `_adblock_block_cpm_all_wo_nds` AS `adblock_block_cpm_all_wo_nds`,
    `_adblock_block_cpm_partner_wo_nds` AS `adblock_block_cpm_partner_wo_nds`,
    `_adblock_block_cpmh_all_wo_nds` AS `adblock_block_cpmh_all_wo_nds`,
    `_adblock_block_cpmh_partner_wo_nds` AS `adblock_block_cpmh_partner_wo_nds`,
    `_adblock_block_hits` AS `adblock_block_hits`,
    `_adblock_block_hits_own_adv` AS `adblock_block_hits_own_adv`,
    `_adblock_block_hits_unsold` AS `adblock_block_hits_unsold`,
    `_adblock_block_rpm_all_wo_nds` AS `adblock_block_rpm_all_wo_nds`,
    `_adblock_block_rpm_partner_wo_nds` AS `adblock_block_rpm_partner_wo_nds`,
    `_adblock_block_shows` AS `adblock_block_shows`,
    `_adblock_block_shows_own_adv` AS `adblock_block_shows_own_adv`,
    `_adblock_block_visibility` AS `adblock_block_visibility`,
    `_adblock_block_winrate` AS `adblock_block_winrate`,
    `_adblock_partner_wo_nds` AS `adblock_partner_wo_nds`,
    `_adfox_block` AS `adfox_block`,
    `_all_wo_nds` AS `all_wo_nds`,
    `_bad_win_partner_price_wo_nds` AS `bad_win_partner_price_wo_nds`,
    `_bad_win_price_wo_nds` AS `bad_win_price_wo_nds`,
    `_caption` AS `caption`,
    `_content_all_wo_nds` AS `content_all_wo_nds`,
    `_content_bad_win_partner_price_wo_nds` AS `content_bad_win_partner_price_wo_nds`,
    `_content_bad_win_price_wo_nds` AS `content_bad_win_price_wo_nds`,
    `_content_block_all_hits` AS `content_block_all_hits`,
    `_content_block_bad_shows` AS `content_block_bad_shows`,
    `_content_block_bad_shows_own_adv` AS `content_block_bad_shows_own_adv`,
    `_content_block_bad_shows_percent` AS `content_block_bad_shows_percent`,
    `_content_block_bad_win_hits` AS `content_block_bad_win_hits`,
    `_content_block_bad_win_hits_own_adv` AS `content_block_bad_win_hits_own_adv`,
    `_content_block_bad_win_hits_percent` AS `content_block_bad_win_hits_percent`,
    `_content_block_bad_win_hits_unsold` AS `content_block_bad_win_hits_unsold`,
    `_content_block_cover_ratio` AS `content_block_cover_ratio`,
    `_content_block_cpm_all_wo_nds` AS `content_block_cpm_all_wo_nds`,
    `_content_block_cpm_partner_wo_nds` AS `content_block_cpm_partner_wo_nds`,
    `_content_block_cpmh_all_wo_nds` AS `content_block_cpmh_all_wo_nds`,
    `_content_block_cpmh_partner_wo_nds` AS `content_block_cpmh_partner_wo_nds`,
    `_content_block_direct_clicks` AS `content_block_direct_clicks`,
    `_content_block_direct_ctr` AS `content_block_direct_ctr`,
    `_content_block_direct_shows` AS `content_block_direct_shows`,
    `_content_block_hits` AS `content_block_hits`,
    `_content_block_hits_own_adv` AS `content_block_hits_own_adv`,
    `_content_block_hits_unsold` AS `content_block_hits_unsold`,
    `_content_block_rpm_all_wo_nds` AS `content_block_rpm_all_wo_nds`,
    `_content_block_rpm_partner_wo_nds` AS `content_block_rpm_partner_wo_nds`,
    `_content_block_shows` AS `content_block_shows`,
    `_content_block_shows_own_adv` AS `content_block_shows_own_adv`,
    `_content_block_visibility` AS `content_block_visibility`,
    `_content_block_winrate` AS `content_block_winrate`,
    `_content_partner_wo_nds` AS `content_partner_wo_nds`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_direct_context_all_wo_nds` AS `direct_context_all_wo_nds`,
    `_direct_context_clicks` AS `direct_context_clicks`,
    `_direct_context_cpc_direct_context_all_wo_nds` AS `direct_context_cpc_direct_context_all_wo_nds`,
    `_direct_context_cpc_direct_context_partner_wo_nds` AS `direct_context_cpc_direct_context_partner_wo_nds`,
    `_direct_context_cpm_direct_context_all_wo_nds` AS `direct_context_cpm_direct_context_all_wo_nds`,
    `_direct_context_cpm_direct_context_partner_wo_nds` AS `direct_context_cpm_direct_context_partner_wo_nds`,
    `_direct_context_ctr` AS `direct_context_ctr`,
    `_direct_context_partner_wo_nds` AS `direct_context_partner_wo_nds`,
    `_direct_context_shows` AS `direct_context_shows`,
    `_domain` AS `domain`,
    `_domain_id` AS `domain_id`,
    `_id` AS `id`,
    `_login` AS `login`,
    `_market_api_context_all_wo_nds` AS `market_api_context_all_wo_nds`,
    `_market_api_context_clicks` AS `market_api_context_clicks`,
    `_market_api_context_cpc_market_api_context_all_wo_nds` AS `market_api_context_cpc_market_api_context_all_wo_nds`,
    `_market_api_context_cpc_market_api_context_partner_wo_nds` AS `market_api_context_cpc_market_api_context_partner_wo_nds`,
    `_market_api_context_cpm_market_api_context_all_wo_nds` AS `market_api_context_cpm_market_api_context_all_wo_nds`,
    `_market_api_context_cpm_market_api_context_partner_wo_nds` AS `market_api_context_cpm_market_api_context_partner_wo_nds`,
    `_market_api_context_ctr` AS `market_api_context_ctr`,
    `_market_api_context_partner_wo_nds` AS `market_api_context_partner_wo_nds`,
    `_market_api_context_shows` AS `market_api_context_shows`,
    `_market_context_all_wo_nds` AS `market_context_all_wo_nds`,
    `_market_context_clicks` AS `market_context_clicks`,
    `_market_context_cpc_market_context_all_wo_nds` AS `market_context_cpc_market_context_all_wo_nds`,
    `_market_context_cpc_market_context_partner_wo_nds` AS `market_context_cpc_market_context_partner_wo_nds`,
    `_market_context_cpm_market_context_all_wo_nds` AS `market_context_cpm_market_context_all_wo_nds`,
    `_market_context_cpm_market_context_partner_wo_nds` AS `market_context_cpm_market_context_partner_wo_nds`,
    `_market_context_ctr` AS `market_context_ctr`,
    `_market_context_partner_wo_nds` AS `market_context_partner_wo_nds`,
    `_market_context_shows` AS `market_context_shows`,
    `_mcb_context_all_wo_nds` AS `mcb_context_all_wo_nds`,
    `_mcb_context_clicks` AS `mcb_context_clicks`,
    `_mcb_context_cpm_mcb_context_all_wo_nds` AS `mcb_context_cpm_mcb_context_all_wo_nds`,
    `_mcb_context_cpm_mcb_context_partner_wo_nds` AS `mcb_context_cpm_mcb_context_partner_wo_nds`,
    `_mcb_context_ctr` AS `mcb_context_ctr`,
    `_mcb_context_partner_wo_nds` AS `mcb_context_partner_wo_nds`,
    `_mcb_context_shows` AS `mcb_context_shows`,
    `_natural_all_wo_nds` AS `natural_all_wo_nds`,
    `_natural_bad_win_partner_price_wo_nds` AS `natural_bad_win_partner_price_wo_nds`,
    `_natural_bad_win_price_wo_nds` AS `natural_bad_win_price_wo_nds`,
    `_natural_block_all_hits` AS `natural_block_all_hits`,
    `_natural_block_bad_shows` AS `natural_block_bad_shows`,
    `_natural_block_bad_shows_own_adv` AS `natural_block_bad_shows_own_adv`,
    `_natural_block_bad_shows_percent` AS `natural_block_bad_shows_percent`,
    `_natural_block_bad_win_hits` AS `natural_block_bad_win_hits`,
    `_natural_block_bad_win_hits_own_adv` AS `natural_block_bad_win_hits_own_adv`,
    `_natural_block_bad_win_hits_percent` AS `natural_block_bad_win_hits_percent`,
    `_natural_block_bad_win_hits_unsold` AS `natural_block_bad_win_hits_unsold`,
    `_natural_block_cover_ratio` AS `natural_block_cover_ratio`,
    `_natural_block_cpm_all_wo_nds` AS `natural_block_cpm_all_wo_nds`,
    `_natural_block_cpm_partner_wo_nds` AS `natural_block_cpm_partner_wo_nds`,
    `_natural_block_cpmh_all_wo_nds` AS `natural_block_cpmh_all_wo_nds`,
    `_natural_block_cpmh_partner_wo_nds` AS `natural_block_cpmh_partner_wo_nds`,
    `_natural_block_direct_clicks` AS `natural_block_direct_clicks`,
    `_natural_block_direct_ctr` AS `natural_block_direct_ctr`,
    `_natural_block_direct_shows` AS `natural_block_direct_shows`,
    `_natural_block_hits` AS `natural_block_hits`,
    `_natural_block_hits_own_adv` AS `natural_block_hits_own_adv`,
    `_natural_block_hits_unsold` AS `natural_block_hits_unsold`,
    `_natural_block_rpm_all_wo_nds` AS `natural_block_rpm_all_wo_nds`,
    `_natural_block_rpm_partner_wo_nds` AS `natural_block_rpm_partner_wo_nds`,
    `_natural_block_shows` AS `natural_block_shows`,
    `_natural_block_shows_own_adv` AS `natural_block_shows_own_adv`,
    `_natural_block_visibility` AS `natural_block_visibility`,
    `_natural_block_winrate` AS `natural_block_winrate`,
    `_natural_partner_wo_nds` AS `natural_partner_wo_nds`,
    `_page_id` AS `page_id`,
    `_partner_wo_nds` AS `partner_wo_nds`,
    `_percent_content_bad_win_partner_price_content_partner_wo_nds` AS `percent_content_bad_win_partner_price_content_partner_wo_nds`,
    `_percent_content_bad_win_price_content_all_wo_nds` AS `percent_content_bad_win_price_content_all_wo_nds`,
    `_percent_natural_bad_win_partner_price_natural_partner_wo_nds` AS `percent_natural_bad_win_partner_price_natural_partner_wo_nds`,
    `_percent_natural_bad_win_price_natural_all_wo_nds` AS `percent_natural_bad_win_price_natural_all_wo_nds`,
    `_percent_rtb_bad_win_partner_price_rtb_partner_wo_nds` AS `percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`,
    `_percent_rtb_bad_win_price_rtb_all_wo_nds` AS `percent_rtb_bad_win_price_rtb_all_wo_nds`,
    `_rtb_all_wo_nds` AS `rtb_all_wo_nds`,
    `_rtb_bad_win_partner_price_wo_nds` AS `rtb_bad_win_partner_price_wo_nds`,
    `_rtb_bad_win_price_wo_nds` AS `rtb_bad_win_price_wo_nds`,
    `_rtb_block_all_hits` AS `rtb_block_all_hits`,
    `_rtb_block_bad_shows` AS `rtb_block_bad_shows`,
    `_rtb_block_bad_shows_own_adv` AS `rtb_block_bad_shows_own_adv`,
    `_rtb_block_bad_shows_percent` AS `rtb_block_bad_shows_percent`,
    `_rtb_block_bad_win_hits` AS `rtb_block_bad_win_hits`,
    `_rtb_block_bad_win_hits_own_adv` AS `rtb_block_bad_win_hits_own_adv`,
    `_rtb_block_bad_win_hits_percent` AS `rtb_block_bad_win_hits_percent`,
    `_rtb_block_bad_win_hits_unsold` AS `rtb_block_bad_win_hits_unsold`,
    `_rtb_block_cover_ratio` AS `rtb_block_cover_ratio`,
    `_rtb_block_cpm_all_wo_nds` AS `rtb_block_cpm_all_wo_nds`,
    `_rtb_block_cpm_partner_wo_nds` AS `rtb_block_cpm_partner_wo_nds`,
    `_rtb_block_cpmh_all_wo_nds` AS `rtb_block_cpmh_all_wo_nds`,
    `_rtb_block_cpmh_partner_wo_nds` AS `rtb_block_cpmh_partner_wo_nds`,
    `_rtb_block_direct_clicks` AS `rtb_block_direct_clicks`,
    `_rtb_block_direct_ctr` AS `rtb_block_direct_ctr`,
    `_rtb_block_direct_shows` AS `rtb_block_direct_shows`,
    `_rtb_block_hits` AS `rtb_block_hits`,
    `_rtb_block_hits_own_adv` AS `rtb_block_hits_own_adv`,
    `_rtb_block_hits_unsold` AS `rtb_block_hits_unsold`,
    `_rtb_block_rpm_all_wo_nds` AS `rtb_block_rpm_all_wo_nds`,
    `_rtb_block_rpm_partner_wo_nds` AS `rtb_block_rpm_partner_wo_nds`,
    `_rtb_block_shows` AS `rtb_block_shows`,
    `_rtb_block_shows_own_adv` AS `rtb_block_shows_own_adv`,
    `_rtb_block_visibility` AS `rtb_block_visibility`,
    `_rtb_block_winrate` AS `rtb_block_winrate`,
    `_rtb_partner_wo_nds` AS `rtb_partner_wo_nds`,
    `_stripe_all_wo_nds` AS `stripe_all_wo_nds`,
    `_stripe_clicks` AS `stripe_clicks`,
    `_stripe_cpc_all_wo_nds` AS `stripe_cpc_all_wo_nds`,
    `_stripe_cpc_partner_wo_nds` AS `stripe_cpc_partner_wo_nds`,
    `_stripe_cpm_all_wo_nds` AS `stripe_cpm_all_wo_nds`,
    `_stripe_cpm_partner_wo_nds` AS `stripe_cpm_partner_wo_nds`,
    `_stripe_cpmh_all_wo_nds` AS `stripe_cpmh_all_wo_nds`,
    `_stripe_cpmh_partner_wo_nds` AS `stripe_cpmh_partner_wo_nds`,
    `_stripe_ctr` AS `stripe_ctr`,
    `_stripe_hits` AS `stripe_hits`,
    `_stripe_partner_wo_nds` AS `stripe_partner_wo_nds`,
    `_stripe_shows` AS `stripe_shows`
FROM (
    SELECT
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000), 2) AS `_adblock_all_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_adblock') AS `_adblock_block_all_hits`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_adblock')) AS `_adblock_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpmh_partner_wo_nds`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_adblock')), 2) AS `_adblock_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_adblock')), 2) AS `_adblock_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_adblock'
        ))) AS `_adblock_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_adblock'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_adblock'
            )))) AS `_adblock_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000), 2) AS `_adblock_partner_wo_nds`,
        dictGetUInt8('blocks_dict', 'adfox_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_adfox_block`,
        round((SUM((`all_wo_nds` / 1000)) / 10000000), 2) AS `_all_wo_nds`,
        round((SUM((`bad_win_partner_price_wo_nds` / 1000)) / 10000000), 2) AS `_bad_win_partner_price_wo_nds`,
        round((SUM((`bad_win_price_wo_nds` / 1000)) / 10000000), 2) AS `_bad_win_price_wo_nds`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_caption`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_content') AS `_content_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )))) AS `_content_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )))) AS `_content_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_content')) AS `_content_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'context_on_site_content'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'context_on_site_content')) AS `_content_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'context_on_site_content') AS `_content_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_content')), 2) AS `_content_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_content')), 2) AS `_content_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_content'
        ))) AS `_content_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_content'
            )))) AS `_content_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_partner_wo_nds`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000), 2) AS `_direct_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_direct') AS `_direct_context_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpc_direct_context_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpc_direct_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpm_direct_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpm_direct_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_direct') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_direct')) AS `_direct_context_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000), 2) AS `_direct_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_direct') AS `_direct_context_shows`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_domain_id`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_id`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000), 2) AS `_market_api_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_market_api') AS `_market_api_context_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpc_market_api_context_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpc_market_api_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpm_market_api_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpm_market_api_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_market_api') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_market_api')) AS `_market_api_context_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000), 2) AS `_market_api_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_market_api') AS `_market_api_context_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000), 2) AS `_market_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_market') AS `_market_context_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpc_market_context_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpc_market_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpm_market_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpm_market_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_market') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_market')) AS `_market_context_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000), 2) AS `_market_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_market') AS `_market_context_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000), 2) AS `_mcb_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_mcb') AS `_mcb_context_clicks`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_mcb')), 2) AS `_mcb_context_cpm_mcb_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_mcb')), 2) AS `_mcb_context_cpm_mcb_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_mcb') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_mcb')) AS `_mcb_context_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000), 2) AS `_mcb_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_mcb') AS `_mcb_context_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_natural') AS `_natural_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )))) AS `_natural_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )))) AS `_natural_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_natural')) AS `_natural_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'context_on_site_natural')) AS `_natural_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'context_on_site_natural') AS `_natural_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_natural')), 2) AS `_natural_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_natural')), 2) AS `_natural_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_natural'
        ))) AS `_natural_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_natural'
            )))) AS `_natural_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_partner_wo_nds`,
        `page_id` AS `_page_id`,
        round((SUM((`partner_wo_nds` / 1000)) / 10000000), 2) AS `_partner_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_content'))) AS `_percent_content_bad_win_partner_price_content_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_content'))) AS `_percent_content_bad_win_price_content_all_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural'))) AS `_percent_natural_bad_win_partner_price_natural_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural'))) AS `_percent_natural_bad_win_price_natural_all_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_rtb'))) AS `_percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_rtb'))) AS `_percent_rtb_bad_win_price_rtb_all_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000), 2) AS `_rtb_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000), 2) AS `_rtb_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000), 2) AS `_rtb_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_rtb') AS `_rtb_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            )))) AS `_rtb_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            )))) AS `_rtb_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_rtb')) AS `_rtb_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'context_on_site_rtb'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'context_on_site_rtb')) AS `_rtb_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'context_on_site_rtb') AS `_rtb_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_rtb')), 2) AS `_rtb_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_rtb')), 2) AS `_rtb_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_rtb'
        ))) AS `_rtb_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_rtb'
            )))) AS `_rtb_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000), 2) AS `_rtb_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000), 2) AS `_stripe_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_stripe') AS `_stripe_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpc_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpc_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpmh_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_stripe') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_stripe')) AS `_stripe_ctr`,
        sumIf(`hits`, `product_id` = 'context_on_site_stripe') AS `_stripe_hits`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000), 2) AS `_stripe_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_stripe') AS `_stripe_shows`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('context_on_site_rtb', 'context_on_site_direct', 'context_on_site_stripe', 'context_on_site_mcb', 'context_on_site_market', 'context_on_site_adblock', 'context_on_site_market_api', 'context_on_site_content', 'context_on_site_natural')
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["AND",[["login","=","mock__owner-login"]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["OR",[["is_efir_blogger","=",1],["is_video_blogger","=",1],["is_tutby","=",1],["is_adfox_partner","=",1],["is_mobile_mediation","=",1],["is_games","=",1]]]')
        )
        AND (
            `page_id` = 'mock__page_id'
        )
        AND (
            dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) = 'mock__caption'
        )
        AND (
            dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) IN ('id__from_table__site__with_filter__["AND",[["domain","=","mock__domain.domain"]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'multistate', toUInt64(`page_id`)) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
        AND (
            dictGetUInt8('blocks_dict', 'adfox_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 1
        )
    )
    GROUP BY `_adfox_block`, `_caption`, `_currency_id`, `_date`, `_domain`, `_domain_id`, `_id`, `_login`, `_page_id`
) `statistics`
WHERE (
    (if(isNaN(`rtb_block_bad_shows`), 0, `rtb_block_bad_shows`) + if(isNaN(`market_context_ctr`), 0, `market_context_ctr`) + if(isNaN(`percent_natural_bad_win_price_natural_all_wo_nds`), 0, `percent_natural_bad_win_price_natural_all_wo_nds`) + if(isNaN(`rtb_bad_win_price_wo_nds`), 0, `rtb_bad_win_price_wo_nds`) + if(isNaN(`content_block_bad_shows_percent`), 0, `content_block_bad_shows_percent`) + if(isNaN(`rtb_block_cpmh_partner_wo_nds`), 0, `rtb_block_cpmh_partner_wo_nds`) + if(isNaN(`adblock_block_all_hits`), 0, `adblock_block_all_hits`) + if(isNaN(`adblock_block_cpm_partner_wo_nds`), 0, `adblock_block_cpm_partner_wo_nds`) + if(isNaN(`natural_block_direct_shows`), 0, `natural_block_direct_shows`) + if(isNaN(`content_block_bad_win_hits_unsold`), 0, `content_block_bad_win_hits_unsold`) + if(isNaN(`natural_block_hits`), 0, `natural_block_hits`) + if(isNaN(`content_block_bad_shows`), 0, `content_block_bad_shows`) + if(isNaN(`rtb_block_direct_ctr`), 0, `rtb_block_direct_ctr`) + if(isNaN(`stripe_shows`), 0, `stripe_shows`) + if(isNaN(`market_api_context_clicks`), 0, `market_api_context_clicks`) + if(isNaN(`adblock_block_hits_unsold`), 0, `adblock_block_hits_unsold`) + if(isNaN(`natural_block_cpm_partner_wo_nds`), 0, `natural_block_cpm_partner_wo_nds`) + if(isNaN(`stripe_all_wo_nds`), 0, `stripe_all_wo_nds`) + if(isNaN(`percent_content_bad_win_partner_price_content_partner_wo_nds`), 0, `percent_content_bad_win_partner_price_content_partner_wo_nds`) + if(isNaN(`adblock_block_shows`), 0, `adblock_block_shows`) + if(isNaN(`natural_bad_win_partner_price_wo_nds`), 0, `natural_bad_win_partner_price_wo_nds`) + if(isNaN(`adblock_all_wo_nds`), 0, `adblock_all_wo_nds`) + if(isNaN(`rtb_block_direct_shows`), 0, `rtb_block_direct_shows`) + if(isNaN(`content_block_cpmh_all_wo_nds`), 0, `content_block_cpmh_all_wo_nds`) + if(isNaN(`rtb_partner_wo_nds`), 0, `rtb_partner_wo_nds`) + if(isNaN(`direct_context_cpm_direct_context_all_wo_nds`), 0, `direct_context_cpm_direct_context_all_wo_nds`) + if(isNaN(`content_block_rpm_partner_wo_nds`), 0, `content_block_rpm_partner_wo_nds`) + if(isNaN(`mcb_context_ctr`), 0, `mcb_context_ctr`) + if(isNaN(`natural_block_winrate`), 0, `natural_block_winrate`) + if(isNaN(`natural_block_shows`), 0, `natural_block_shows`) + if(isNaN(`adblock_block_visibility`), 0, `adblock_block_visibility`) + if(isNaN(`stripe_cpm_all_wo_nds`), 0, `stripe_cpm_all_wo_nds`) + if(isNaN(`natural_block_direct_clicks`), 0, `natural_block_direct_clicks`) + if(isNaN(`direct_context_cpm_direct_context_partner_wo_nds`), 0, `direct_context_cpm_direct_context_partner_wo_nds`) + if(isNaN(`content_block_direct_clicks`), 0, `content_block_direct_clicks`) + if(isNaN(`natural_block_hits_own_adv`), 0, `natural_block_hits_own_adv`) + if(isNaN(`adblock_block_hits`), 0, `adblock_block_hits`) + if(isNaN(`natural_block_bad_win_hits_unsold`), 0, `natural_block_bad_win_hits_unsold`) + if(isNaN(`content_bad_win_price_wo_nds`), 0, `content_bad_win_price_wo_nds`) + if(isNaN(`content_block_direct_shows`), 0, `content_block_direct_shows`) + if(isNaN(`bad_win_partner_price_wo_nds`), 0, `bad_win_partner_price_wo_nds`) + if(isNaN(`content_block_all_hits`), 0, `content_block_all_hits`) + if(isNaN(`adblock_block_cpmh_partner_wo_nds`), 0, `adblock_block_cpmh_partner_wo_nds`) + if(isNaN(`stripe_hits`), 0, `stripe_hits`) + if(isNaN(`rtb_block_hits`), 0, `rtb_block_hits`) + if(isNaN(`mcb_context_all_wo_nds`), 0, `mcb_context_all_wo_nds`) + if(isNaN(`market_context_shows`), 0, `market_context_shows`) + if(isNaN(`natural_block_bad_win_hits_own_adv`), 0, `natural_block_bad_win_hits_own_adv`) + if(isNaN(`market_context_cpc_market_context_partner_wo_nds`), 0, `market_context_cpc_market_context_partner_wo_nds`) + if(isNaN(`natural_bad_win_price_wo_nds`), 0, `natural_bad_win_price_wo_nds`) + if(isNaN(`natural_block_cpm_all_wo_nds`), 0, `natural_block_cpm_all_wo_nds`) + if(isNaN(`partner_wo_nds`), 0, `partner_wo_nds`) + if(isNaN(`mcb_context_clicks`), 0, `mcb_context_clicks`) + if(isNaN(`content_partner_wo_nds`), 0, `content_partner_wo_nds`) + if(isNaN(`market_api_context_cpc_market_api_context_partner_wo_nds`), 0, `market_api_context_cpc_market_api_context_partner_wo_nds`) + if(isNaN(`adblock_partner_wo_nds`), 0, `adblock_partner_wo_nds`) + if(isNaN(`percent_rtb_bad_win_price_rtb_all_wo_nds`), 0, `percent_rtb_bad_win_price_rtb_all_wo_nds`) + if(isNaN(`content_block_shows_own_adv`), 0, `content_block_shows_own_adv`) + if(isNaN(`direct_context_shows`), 0, `direct_context_shows`) + if(isNaN(`stripe_cpc_all_wo_nds`), 0, `stripe_cpc_all_wo_nds`) + if(isNaN(`content_block_cpmh_partner_wo_nds`), 0, `content_block_cpmh_partner_wo_nds`) + if(isNaN(`content_block_direct_ctr`), 0, `content_block_direct_ctr`) + if(isNaN(`stripe_ctr`), 0, `stripe_ctr`) + if(isNaN(`content_block_cpm_partner_wo_nds`), 0, `content_block_cpm_partner_wo_nds`) + if(isNaN(`adblock_block_cpm_all_wo_nds`), 0, `adblock_block_cpm_all_wo_nds`) + if(isNaN(`stripe_cpc_partner_wo_nds`), 0, `stripe_cpc_partner_wo_nds`) + if(isNaN(`stripe_clicks`), 0, `stripe_clicks`) + if(isNaN(`content_block_visibility`), 0, `content_block_visibility`) + if(isNaN(`market_context_all_wo_nds`), 0, `market_context_all_wo_nds`) + if(isNaN(`rtb_block_bad_win_hits_own_adv`), 0, `rtb_block_bad_win_hits_own_adv`) + if(isNaN(`percent_content_bad_win_price_content_all_wo_nds`), 0, `percent_content_bad_win_price_content_all_wo_nds`) + if(isNaN(`content_block_bad_win_hits_own_adv`), 0, `content_block_bad_win_hits_own_adv`) + if(isNaN(`natural_block_visibility`), 0, `natural_block_visibility`) + if(isNaN(`direct_context_clicks`), 0, `direct_context_clicks`) + if(isNaN(`content_block_shows`), 0, `content_block_shows`) + if(isNaN(`market_api_context_all_wo_nds`), 0, `market_api_context_all_wo_nds`) + if(isNaN(`rtb_bad_win_partner_price_wo_nds`), 0, `rtb_bad_win_partner_price_wo_nds`) + if(isNaN(`adblock_block_rpm_partner_wo_nds`), 0, `adblock_block_rpm_partner_wo_nds`) + if(isNaN(`rtb_block_cpm_all_wo_nds`), 0, `rtb_block_cpm_all_wo_nds`) + if(isNaN(`market_api_context_cpm_market_api_context_all_wo_nds`), 0, `market_api_context_cpm_market_api_context_all_wo_nds`) + if(isNaN(`rtb_block_visibility`), 0, `rtb_block_visibility`) + if(isNaN(`rtb_block_rpm_all_wo_nds`), 0, `rtb_block_rpm_all_wo_nds`) + if(isNaN(`natural_partner_wo_nds`), 0, `natural_partner_wo_nds`) + if(isNaN(`market_context_clicks`), 0, `market_context_clicks`) + if(isNaN(`natural_block_cover_ratio`), 0, `natural_block_cover_ratio`) + if(isNaN(`adblock_block_cpmh_all_wo_nds`), 0, `adblock_block_cpmh_all_wo_nds`) + if(isNaN(`content_block_cpm_all_wo_nds`), 0, `content_block_cpm_all_wo_nds`) + if(isNaN(`direct_context_ctr`), 0, `direct_context_ctr`) + if(isNaN(`natural_block_direct_ctr`), 0, `natural_block_direct_ctr`) + if(isNaN(`market_context_cpm_market_context_all_wo_nds`), 0, `market_context_cpm_market_context_all_wo_nds`) + if(isNaN(`content_block_cover_ratio`), 0, `content_block_cover_ratio`) + if(isNaN(`direct_context_partner_wo_nds`), 0, `direct_context_partner_wo_nds`) + if(isNaN(`adblock_block_cover_ratio`), 0, `adblock_block_cover_ratio`) + if(isNaN(`stripe_partner_wo_nds`), 0, `stripe_partner_wo_nds`) + if(isNaN(`adblock_block_winrate`), 0, `adblock_block_winrate`) + if(isNaN(`adblock_block_hits_own_adv`), 0, `adblock_block_hits_own_adv`) + if(isNaN(`market_api_context_cpc_market_api_context_all_wo_nds`), 0, `market_api_context_cpc_market_api_context_all_wo_nds`) + if(isNaN(`stripe_cpmh_all_wo_nds`), 0, `stripe_cpmh_all_wo_nds`) + if(isNaN(`natural_block_bad_shows`), 0, `natural_block_bad_shows`) + if(isNaN(`direct_context_cpc_direct_context_partner_wo_nds`), 0, `direct_context_cpc_direct_context_partner_wo_nds`) + if(isNaN(`mcb_context_cpm_mcb_context_all_wo_nds`), 0, `mcb_context_cpm_mcb_context_all_wo_nds`) + if(isNaN(`natural_block_hits_unsold`), 0, `natural_block_hits_unsold`) + if(isNaN(`natural_block_bad_shows_percent`), 0, `natural_block_bad_shows_percent`) + if(isNaN(`content_block_bad_shows_own_adv`), 0, `content_block_bad_shows_own_adv`) + if(isNaN(`direct_context_cpc_direct_context_all_wo_nds`), 0, `direct_context_cpc_direct_context_all_wo_nds`) + if(isNaN(`market_context_cpm_market_context_partner_wo_nds`), 0, `market_context_cpm_market_context_partner_wo_nds`) + if(isNaN(`mcb_context_cpm_mcb_context_partner_wo_nds`), 0, `mcb_context_cpm_mcb_context_partner_wo_nds`) + if(isNaN(`percent_natural_bad_win_partner_price_natural_partner_wo_nds`), 0, `percent_natural_bad_win_partner_price_natural_partner_wo_nds`) + if(isNaN(`mcb_context_partner_wo_nds`), 0, `mcb_context_partner_wo_nds`) + if(isNaN(`rtb_block_bad_shows_percent`), 0, `rtb_block_bad_shows_percent`) + if(isNaN(`content_block_hits`), 0, `content_block_hits`) + if(isNaN(`rtb_block_cover_ratio`), 0, `rtb_block_cover_ratio`) + if(isNaN(`adblock_block_rpm_all_wo_nds`), 0, `adblock_block_rpm_all_wo_nds`) + if(isNaN(`all_wo_nds`), 0, `all_wo_nds`) + if(isNaN(`direct_context_all_wo_nds`), 0, `direct_context_all_wo_nds`) + if(isNaN(`rtb_block_bad_win_hits_percent`), 0, `rtb_block_bad_win_hits_percent`) + if(isNaN(`natural_block_rpm_all_wo_nds`), 0, `natural_block_rpm_all_wo_nds`) + if(isNaN(`rtb_block_rpm_partner_wo_nds`), 0, `rtb_block_rpm_partner_wo_nds`) + if(isNaN(`content_block_bad_win_hits`), 0, `content_block_bad_win_hits`) + if(isNaN(`percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`), 0, `percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`) + if(isNaN(`content_block_hits_own_adv`), 0, `content_block_hits_own_adv`) + if(isNaN(`natural_block_bad_shows_own_adv`), 0, `natural_block_bad_shows_own_adv`) + if(isNaN(`natural_block_bad_win_hits_percent`), 0, `natural_block_bad_win_hits_percent`) + if(isNaN(`market_context_cpc_market_context_all_wo_nds`), 0, `market_context_cpc_market_context_all_wo_nds`) + if(isNaN(`natural_block_cpmh_partner_wo_nds`), 0, `natural_block_cpmh_partner_wo_nds`) + if(isNaN(`natural_all_wo_nds`), 0, `natural_all_wo_nds`) + if(isNaN(`rtb_block_direct_clicks`), 0, `rtb_block_direct_clicks`) + if(isNaN(`mcb_context_shows`), 0, `mcb_context_shows`) + if(isNaN(`rtb_block_winrate`), 0, `rtb_block_winrate`) + if(isNaN(`market_api_context_shows`), 0, `market_api_context_shows`) + if(isNaN(`content_block_winrate`), 0, `content_block_winrate`) + if(isNaN(`rtb_block_bad_win_hits`), 0, `rtb_block_bad_win_hits`) + if(isNaN(`natural_block_all_hits`), 0, `natural_block_all_hits`) + if(isNaN(`rtb_block_hits_unsold`), 0, `rtb_block_hits_unsold`) + if(isNaN(`content_block_hits_unsold`), 0, `content_block_hits_unsold`) + if(isNaN(`rtb_block_bad_win_hits_unsold`), 0, `rtb_block_bad_win_hits_unsold`) + if(isNaN(`bad_win_price_wo_nds`), 0, `bad_win_price_wo_nds`) + if(isNaN(`rtb_block_hits_own_adv`), 0, `rtb_block_hits_own_adv`) + if(isNaN(`content_bad_win_partner_price_wo_nds`), 0, `content_bad_win_partner_price_wo_nds`) + if(isNaN(`natural_block_shows_own_adv`), 0, `natural_block_shows_own_adv`) + if(isNaN(`natural_block_cpmh_all_wo_nds`), 0, `natural_block_cpmh_all_wo_nds`) + if(isNaN(`rtb_block_shows`), 0, `rtb_block_shows`) + if(isNaN(`adblock_block_shows_own_adv`), 0, `adblock_block_shows_own_adv`) + if(isNaN(`content_all_wo_nds`), 0, `content_all_wo_nds`) + if(isNaN(`stripe_cpmh_partner_wo_nds`), 0, `stripe_cpmh_partner_wo_nds`) + if(isNaN(`natural_block_bad_win_hits`), 0, `natural_block_bad_win_hits`) + if(isNaN(`market_api_context_cpm_market_api_context_partner_wo_nds`), 0, `market_api_context_cpm_market_api_context_partner_wo_nds`) + if(isNaN(`rtb_block_all_hits`), 0, `rtb_block_all_hits`) + if(isNaN(`market_api_context_ctr`), 0, `market_api_context_ctr`) + if(isNaN(`rtb_all_wo_nds`), 0, `rtb_all_wo_nds`) + if(isNaN(`rtb_block_shows_own_adv`), 0, `rtb_block_shows_own_adv`) + if(isNaN(`market_api_context_partner_wo_nds`), 0, `market_api_context_partner_wo_nds`) + if(isNaN(`market_context_partner_wo_nds`), 0, `market_context_partner_wo_nds`) + if(isNaN(`content_block_rpm_all_wo_nds`), 0, `content_block_rpm_all_wo_nds`) + if(isNaN(`stripe_cpm_partner_wo_nds`), 0, `stripe_cpm_partner_wo_nds`) + if(isNaN(`rtb_block_bad_shows_own_adv`), 0, `rtb_block_bad_shows_own_adv`) + if(isNaN(`rtb_block_cpmh_all_wo_nds`), 0, `rtb_block_cpmh_all_wo_nds`) + if(isNaN(`rtb_block_cpm_partner_wo_nds`), 0, `rtb_block_cpm_partner_wo_nds`) + if(isNaN(`content_block_bad_win_hits_percent`), 0, `content_block_bad_win_hits_percent`) + if(isNaN(`natural_block_rpm_partner_wo_nds`), 0, `natural_block_rpm_partner_wo_nds`)) > 0
) FORMAT JSONCompact

SELECT
    `_adblock_all_wo_nds` AS `adblock_all_wo_nds`,
    `_adblock_block_all_hits` AS `adblock_block_all_hits`,
    `_adblock_block_cover_ratio` AS `adblock_block_cover_ratio`,
    `_adblock_block_cpm_all_wo_nds` AS `adblock_block_cpm_all_wo_nds`,
    `_adblock_block_cpm_partner_wo_nds` AS `adblock_block_cpm_partner_wo_nds`,
    `_adblock_block_cpmh_all_wo_nds` AS `adblock_block_cpmh_all_wo_nds`,
    `_adblock_block_cpmh_partner_wo_nds` AS `adblock_block_cpmh_partner_wo_nds`,
    `_adblock_block_hits` AS `adblock_block_hits`,
    `_adblock_block_hits_own_adv` AS `adblock_block_hits_own_adv`,
    `_adblock_block_hits_unsold` AS `adblock_block_hits_unsold`,
    `_adblock_block_rpm_all_wo_nds` AS `adblock_block_rpm_all_wo_nds`,
    `_adblock_block_rpm_partner_wo_nds` AS `adblock_block_rpm_partner_wo_nds`,
    `_adblock_block_shows` AS `adblock_block_shows`,
    `_adblock_block_shows_own_adv` AS `adblock_block_shows_own_adv`,
    `_adblock_block_visibility` AS `adblock_block_visibility`,
    `_adblock_block_winrate` AS `adblock_block_winrate`,
    `_adblock_partner_wo_nds` AS `adblock_partner_wo_nds`,
    `_adfox_block` AS `adfox_block`,
    `_all_wo_nds` AS `all_wo_nds`,
    `_bad_win_partner_price_wo_nds` AS `bad_win_partner_price_wo_nds`,
    `_bad_win_price_wo_nds` AS `bad_win_price_wo_nds`,
    `_content_all_wo_nds` AS `content_all_wo_nds`,
    `_content_bad_win_partner_price_wo_nds` AS `content_bad_win_partner_price_wo_nds`,
    `_content_bad_win_price_wo_nds` AS `content_bad_win_price_wo_nds`,
    `_content_block_all_hits` AS `content_block_all_hits`,
    `_content_block_bad_shows` AS `content_block_bad_shows`,
    `_content_block_bad_shows_own_adv` AS `content_block_bad_shows_own_adv`,
    `_content_block_bad_shows_percent` AS `content_block_bad_shows_percent`,
    `_content_block_bad_win_hits` AS `content_block_bad_win_hits`,
    `_content_block_bad_win_hits_own_adv` AS `content_block_bad_win_hits_own_adv`,
    `_content_block_bad_win_hits_percent` AS `content_block_bad_win_hits_percent`,
    `_content_block_bad_win_hits_unsold` AS `content_block_bad_win_hits_unsold`,
    `_content_block_cover_ratio` AS `content_block_cover_ratio`,
    `_content_block_cpm_all_wo_nds` AS `content_block_cpm_all_wo_nds`,
    `_content_block_cpm_partner_wo_nds` AS `content_block_cpm_partner_wo_nds`,
    `_content_block_cpmh_all_wo_nds` AS `content_block_cpmh_all_wo_nds`,
    `_content_block_cpmh_partner_wo_nds` AS `content_block_cpmh_partner_wo_nds`,
    `_content_block_direct_clicks` AS `content_block_direct_clicks`,
    `_content_block_direct_ctr` AS `content_block_direct_ctr`,
    `_content_block_direct_shows` AS `content_block_direct_shows`,
    `_content_block_hits` AS `content_block_hits`,
    `_content_block_hits_own_adv` AS `content_block_hits_own_adv`,
    `_content_block_hits_unsold` AS `content_block_hits_unsold`,
    `_content_block_rpm_all_wo_nds` AS `content_block_rpm_all_wo_nds`,
    `_content_block_rpm_partner_wo_nds` AS `content_block_rpm_partner_wo_nds`,
    `_content_block_shows` AS `content_block_shows`,
    `_content_block_shows_own_adv` AS `content_block_shows_own_adv`,
    `_content_block_visibility` AS `content_block_visibility`,
    `_content_block_winrate` AS `content_block_winrate`,
    `_content_partner_wo_nds` AS `content_partner_wo_nds`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_direct_context_all_wo_nds` AS `direct_context_all_wo_nds`,
    `_direct_context_clicks` AS `direct_context_clicks`,
    `_direct_context_cpc_direct_context_all_wo_nds` AS `direct_context_cpc_direct_context_all_wo_nds`,
    `_direct_context_cpc_direct_context_partner_wo_nds` AS `direct_context_cpc_direct_context_partner_wo_nds`,
    `_direct_context_cpm_direct_context_all_wo_nds` AS `direct_context_cpm_direct_context_all_wo_nds`,
    `_direct_context_cpm_direct_context_partner_wo_nds` AS `direct_context_cpm_direct_context_partner_wo_nds`,
    `_direct_context_ctr` AS `direct_context_ctr`,
    `_direct_context_partner_wo_nds` AS `direct_context_partner_wo_nds`,
    `_direct_context_shows` AS `direct_context_shows`,
    `_domain` AS `domain`,
    `_domain_id` AS `domain_id`,
    `_id` AS `id`,
    `_login` AS `login`,
    `_market_api_context_all_wo_nds` AS `market_api_context_all_wo_nds`,
    `_market_api_context_clicks` AS `market_api_context_clicks`,
    `_market_api_context_cpc_market_api_context_all_wo_nds` AS `market_api_context_cpc_market_api_context_all_wo_nds`,
    `_market_api_context_cpc_market_api_context_partner_wo_nds` AS `market_api_context_cpc_market_api_context_partner_wo_nds`,
    `_market_api_context_cpm_market_api_context_all_wo_nds` AS `market_api_context_cpm_market_api_context_all_wo_nds`,
    `_market_api_context_cpm_market_api_context_partner_wo_nds` AS `market_api_context_cpm_market_api_context_partner_wo_nds`,
    `_market_api_context_ctr` AS `market_api_context_ctr`,
    `_market_api_context_partner_wo_nds` AS `market_api_context_partner_wo_nds`,
    `_market_api_context_shows` AS `market_api_context_shows`,
    `_market_context_all_wo_nds` AS `market_context_all_wo_nds`,
    `_market_context_clicks` AS `market_context_clicks`,
    `_market_context_cpc_market_context_all_wo_nds` AS `market_context_cpc_market_context_all_wo_nds`,
    `_market_context_cpc_market_context_partner_wo_nds` AS `market_context_cpc_market_context_partner_wo_nds`,
    `_market_context_cpm_market_context_all_wo_nds` AS `market_context_cpm_market_context_all_wo_nds`,
    `_market_context_cpm_market_context_partner_wo_nds` AS `market_context_cpm_market_context_partner_wo_nds`,
    `_market_context_ctr` AS `market_context_ctr`,
    `_market_context_partner_wo_nds` AS `market_context_partner_wo_nds`,
    `_market_context_shows` AS `market_context_shows`,
    `_mcb_context_all_wo_nds` AS `mcb_context_all_wo_nds`,
    `_mcb_context_clicks` AS `mcb_context_clicks`,
    `_mcb_context_cpm_mcb_context_all_wo_nds` AS `mcb_context_cpm_mcb_context_all_wo_nds`,
    `_mcb_context_cpm_mcb_context_partner_wo_nds` AS `mcb_context_cpm_mcb_context_partner_wo_nds`,
    `_mcb_context_ctr` AS `mcb_context_ctr`,
    `_mcb_context_partner_wo_nds` AS `mcb_context_partner_wo_nds`,
    `_mcb_context_shows` AS `mcb_context_shows`,
    `_natural_all_wo_nds` AS `natural_all_wo_nds`,
    `_natural_bad_win_partner_price_wo_nds` AS `natural_bad_win_partner_price_wo_nds`,
    `_natural_bad_win_price_wo_nds` AS `natural_bad_win_price_wo_nds`,
    `_natural_block_all_hits` AS `natural_block_all_hits`,
    `_natural_block_bad_shows` AS `natural_block_bad_shows`,
    `_natural_block_bad_shows_own_adv` AS `natural_block_bad_shows_own_adv`,
    `_natural_block_bad_shows_percent` AS `natural_block_bad_shows_percent`,
    `_natural_block_bad_win_hits` AS `natural_block_bad_win_hits`,
    `_natural_block_bad_win_hits_own_adv` AS `natural_block_bad_win_hits_own_adv`,
    `_natural_block_bad_win_hits_percent` AS `natural_block_bad_win_hits_percent`,
    `_natural_block_bad_win_hits_unsold` AS `natural_block_bad_win_hits_unsold`,
    `_natural_block_cover_ratio` AS `natural_block_cover_ratio`,
    `_natural_block_cpm_all_wo_nds` AS `natural_block_cpm_all_wo_nds`,
    `_natural_block_cpm_partner_wo_nds` AS `natural_block_cpm_partner_wo_nds`,
    `_natural_block_cpmh_all_wo_nds` AS `natural_block_cpmh_all_wo_nds`,
    `_natural_block_cpmh_partner_wo_nds` AS `natural_block_cpmh_partner_wo_nds`,
    `_natural_block_direct_clicks` AS `natural_block_direct_clicks`,
    `_natural_block_direct_ctr` AS `natural_block_direct_ctr`,
    `_natural_block_direct_shows` AS `natural_block_direct_shows`,
    `_natural_block_hits` AS `natural_block_hits`,
    `_natural_block_hits_own_adv` AS `natural_block_hits_own_adv`,
    `_natural_block_hits_unsold` AS `natural_block_hits_unsold`,
    `_natural_block_rpm_all_wo_nds` AS `natural_block_rpm_all_wo_nds`,
    `_natural_block_rpm_partner_wo_nds` AS `natural_block_rpm_partner_wo_nds`,
    `_natural_block_shows` AS `natural_block_shows`,
    `_natural_block_shows_own_adv` AS `natural_block_shows_own_adv`,
    `_natural_block_visibility` AS `natural_block_visibility`,
    `_natural_block_winrate` AS `natural_block_winrate`,
    `_natural_partner_wo_nds` AS `natural_partner_wo_nds`,
    `_page_id` AS `page_id`,
    `_partner_wo_nds` AS `partner_wo_nds`,
    `_percent_content_bad_win_partner_price_content_partner_wo_nds` AS `percent_content_bad_win_partner_price_content_partner_wo_nds`,
    `_percent_content_bad_win_price_content_all_wo_nds` AS `percent_content_bad_win_price_content_all_wo_nds`,
    `_percent_natural_bad_win_partner_price_natural_partner_wo_nds` AS `percent_natural_bad_win_partner_price_natural_partner_wo_nds`,
    `_percent_natural_bad_win_price_natural_all_wo_nds` AS `percent_natural_bad_win_price_natural_all_wo_nds`,
    `_percent_rtb_bad_win_partner_price_rtb_partner_wo_nds` AS `percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`,
    `_percent_rtb_bad_win_price_rtb_all_wo_nds` AS `percent_rtb_bad_win_price_rtb_all_wo_nds`,
    `_public_id` AS `public_id`,
    `_rtb_all_wo_nds` AS `rtb_all_wo_nds`,
    `_rtb_bad_win_partner_price_wo_nds` AS `rtb_bad_win_partner_price_wo_nds`,
    `_rtb_bad_win_price_wo_nds` AS `rtb_bad_win_price_wo_nds`,
    `_rtb_block_all_hits` AS `rtb_block_all_hits`,
    `_rtb_block_bad_shows` AS `rtb_block_bad_shows`,
    `_rtb_block_bad_shows_own_adv` AS `rtb_block_bad_shows_own_adv`,
    `_rtb_block_bad_shows_percent` AS `rtb_block_bad_shows_percent`,
    `_rtb_block_bad_win_hits` AS `rtb_block_bad_win_hits`,
    `_rtb_block_bad_win_hits_own_adv` AS `rtb_block_bad_win_hits_own_adv`,
    `_rtb_block_bad_win_hits_percent` AS `rtb_block_bad_win_hits_percent`,
    `_rtb_block_bad_win_hits_unsold` AS `rtb_block_bad_win_hits_unsold`,
    `_rtb_block_cover_ratio` AS `rtb_block_cover_ratio`,
    `_rtb_block_cpm_all_wo_nds` AS `rtb_block_cpm_all_wo_nds`,
    `_rtb_block_cpm_partner_wo_nds` AS `rtb_block_cpm_partner_wo_nds`,
    `_rtb_block_cpmh_all_wo_nds` AS `rtb_block_cpmh_all_wo_nds`,
    `_rtb_block_cpmh_partner_wo_nds` AS `rtb_block_cpmh_partner_wo_nds`,
    `_rtb_block_direct_clicks` AS `rtb_block_direct_clicks`,
    `_rtb_block_direct_ctr` AS `rtb_block_direct_ctr`,
    `_rtb_block_direct_shows` AS `rtb_block_direct_shows`,
    `_rtb_block_hits` AS `rtb_block_hits`,
    `_rtb_block_hits_own_adv` AS `rtb_block_hits_own_adv`,
    `_rtb_block_hits_unsold` AS `rtb_block_hits_unsold`,
    `_rtb_block_rpm_all_wo_nds` AS `rtb_block_rpm_all_wo_nds`,
    `_rtb_block_rpm_partner_wo_nds` AS `rtb_block_rpm_partner_wo_nds`,
    `_rtb_block_shows` AS `rtb_block_shows`,
    `_rtb_block_shows_own_adv` AS `rtb_block_shows_own_adv`,
    `_rtb_block_visibility` AS `rtb_block_visibility`,
    `_rtb_block_winrate` AS `rtb_block_winrate`,
    `_rtb_partner_wo_nds` AS `rtb_partner_wo_nds`,
    `_stripe_all_wo_nds` AS `stripe_all_wo_nds`,
    `_stripe_clicks` AS `stripe_clicks`,
    `_stripe_cpc_all_wo_nds` AS `stripe_cpc_all_wo_nds`,
    `_stripe_cpc_partner_wo_nds` AS `stripe_cpc_partner_wo_nds`,
    `_stripe_cpm_all_wo_nds` AS `stripe_cpm_all_wo_nds`,
    `_stripe_cpm_partner_wo_nds` AS `stripe_cpm_partner_wo_nds`,
    `_stripe_cpmh_all_wo_nds` AS `stripe_cpmh_all_wo_nds`,
    `_stripe_cpmh_partner_wo_nds` AS `stripe_cpmh_partner_wo_nds`,
    `_stripe_ctr` AS `stripe_ctr`,
    `_stripe_hits` AS `stripe_hits`,
    `_stripe_partner_wo_nds` AS `stripe_partner_wo_nds`,
    `_stripe_shows` AS `stripe_shows`
FROM (
    SELECT
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000), 2) AS `_adblock_all_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_adblock') AS `_adblock_block_all_hits`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_adblock')) AS `_adblock_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpmh_partner_wo_nds`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_adblock')), 2) AS `_adblock_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_adblock')), 2) AS `_adblock_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_adblock'
        ))) AS `_adblock_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_adblock'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_adblock'
            )))) AS `_adblock_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000), 2) AS `_adblock_partner_wo_nds`,
        dictGetUInt8('blocks_dict', 'adfox_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_adfox_block`,
        round((SUM((`all_wo_nds` / 1000)) / 10000000), 2) AS `_all_wo_nds`,
        round((SUM((`bad_win_partner_price_wo_nds` / 1000)) / 10000000), 2) AS `_bad_win_partner_price_wo_nds`,
        round((SUM((`bad_win_price_wo_nds` / 1000)) / 10000000), 2) AS `_bad_win_price_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_content') AS `_content_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )))) AS `_content_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )))) AS `_content_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_content')) AS `_content_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'context_on_site_content'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'context_on_site_content')) AS `_content_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'context_on_site_content') AS `_content_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_content')), 2) AS `_content_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_content')), 2) AS `_content_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_content'
        ))) AS `_content_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_content'
            )))) AS `_content_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_partner_wo_nds`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000), 2) AS `_direct_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_direct') AS `_direct_context_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpc_direct_context_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpc_direct_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpm_direct_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpm_direct_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_direct') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_direct')) AS `_direct_context_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000), 2) AS `_direct_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_direct') AS `_direct_context_shows`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_domain_id`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_id`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000), 2) AS `_market_api_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_market_api') AS `_market_api_context_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpc_market_api_context_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpc_market_api_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpm_market_api_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpm_market_api_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_market_api') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_market_api')) AS `_market_api_context_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000), 2) AS `_market_api_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_market_api') AS `_market_api_context_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000), 2) AS `_market_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_market') AS `_market_context_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpc_market_context_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpc_market_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpm_market_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpm_market_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_market') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_market')) AS `_market_context_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000), 2) AS `_market_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_market') AS `_market_context_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000), 2) AS `_mcb_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_mcb') AS `_mcb_context_clicks`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_mcb')), 2) AS `_mcb_context_cpm_mcb_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_mcb')), 2) AS `_mcb_context_cpm_mcb_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_mcb') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_mcb')) AS `_mcb_context_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000), 2) AS `_mcb_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_mcb') AS `_mcb_context_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_natural') AS `_natural_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )))) AS `_natural_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )))) AS `_natural_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_natural')) AS `_natural_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'context_on_site_natural')) AS `_natural_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'context_on_site_natural') AS `_natural_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_natural')), 2) AS `_natural_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_natural')), 2) AS `_natural_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_natural'
        ))) AS `_natural_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_natural'
            )))) AS `_natural_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_partner_wo_nds`,
        `page_id` AS `_page_id`,
        round((SUM((`partner_wo_nds` / 1000)) / 10000000), 2) AS `_partner_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_content'))) AS `_percent_content_bad_win_partner_price_content_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_content'))) AS `_percent_content_bad_win_price_content_all_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural'))) AS `_percent_natural_bad_win_partner_price_natural_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural'))) AS `_percent_natural_bad_win_price_natural_all_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_rtb'))) AS `_percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_rtb'))) AS `_percent_rtb_bad_win_price_rtb_all_wo_nds`,
        concat(transform(toString(`product_id`), ['context_on_site_adblock', 'context_on_site_content', 'context_on_site_direct', 'context_on_site_market', 'context_on_site_market_api', 'context_on_site_mcb', 'context_on_site_natural', 'context_on_site_rtb', 'context_on_site_stripe'], ['R-AB-', 'C-A-', 'D-A-', 'M-A-', 'MA-A-', 'C-A-', 'N-A-', 'R-A-', 'S-A-']), toString(`page_id`), '-', toString(`block_id`)) AS `_public_id`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000), 2) AS `_rtb_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000), 2) AS `_rtb_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000), 2) AS `_rtb_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_rtb') AS `_rtb_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            )))) AS `_rtb_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            )))) AS `_rtb_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_rtb')) AS `_rtb_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'context_on_site_rtb'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'context_on_site_rtb')) AS `_rtb_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'context_on_site_rtb') AS `_rtb_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_rtb')), 2) AS `_rtb_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_rtb')), 2) AS `_rtb_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_rtb'
        ))) AS `_rtb_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_rtb'
            )))) AS `_rtb_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000), 2) AS `_rtb_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000), 2) AS `_stripe_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_stripe') AS `_stripe_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpc_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpc_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpmh_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_stripe') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_stripe')) AS `_stripe_ctr`,
        sumIf(`hits`, `product_id` = 'context_on_site_stripe') AS `_stripe_hits`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000), 2) AS `_stripe_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_stripe') AS `_stripe_shows`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('context_on_site_rtb', 'context_on_site_direct', 'context_on_site_stripe', 'context_on_site_mcb', 'context_on_site_market', 'context_on_site_adblock', 'context_on_site_market_api', 'context_on_site_content', 'context_on_site_natural')
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["AND",[["login","=","mock__owner-login"]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["OR",[["is_efir_blogger","=",1],["is_video_blogger","=",1],["is_tutby","=",1],["is_adfox_partner","=",1],["is_mobile_mediation","=",1],["is_games","=",1]]]')
        )
        AND (
            `page_id` = 'mock__page_id'
        )
        AND (
            dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) IN ('id__from_table__site__with_filter__["AND",[["domain","=","mock__domain.domain"]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'multistate', toUInt64(`page_id`)) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
        AND (
            dictGetUInt8('blocks_dict', 'adfox_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 1
        )
    )
    GROUP BY `_adfox_block`, `_currency_id`, `_date`, `_domain`, `_domain_id`, `_id`, `_login`, `_page_id`, `_public_id`
) `statistics`
WHERE (
    (if(isNaN(`rtb_block_bad_shows`), 0, `rtb_block_bad_shows`) + if(isNaN(`market_context_ctr`), 0, `market_context_ctr`) + if(isNaN(`percent_natural_bad_win_price_natural_all_wo_nds`), 0, `percent_natural_bad_win_price_natural_all_wo_nds`) + if(isNaN(`rtb_bad_win_price_wo_nds`), 0, `rtb_bad_win_price_wo_nds`) + if(isNaN(`content_block_bad_shows_percent`), 0, `content_block_bad_shows_percent`) + if(isNaN(`rtb_block_cpmh_partner_wo_nds`), 0, `rtb_block_cpmh_partner_wo_nds`) + if(isNaN(`adblock_block_all_hits`), 0, `adblock_block_all_hits`) + if(isNaN(`adblock_block_cpm_partner_wo_nds`), 0, `adblock_block_cpm_partner_wo_nds`) + if(isNaN(`natural_block_direct_shows`), 0, `natural_block_direct_shows`) + if(isNaN(`content_block_bad_win_hits_unsold`), 0, `content_block_bad_win_hits_unsold`) + if(isNaN(`natural_block_hits`), 0, `natural_block_hits`) + if(isNaN(`content_block_bad_shows`), 0, `content_block_bad_shows`) + if(isNaN(`rtb_block_direct_ctr`), 0, `rtb_block_direct_ctr`) + if(isNaN(`stripe_shows`), 0, `stripe_shows`) + if(isNaN(`market_api_context_clicks`), 0, `market_api_context_clicks`) + if(isNaN(`adblock_block_hits_unsold`), 0, `adblock_block_hits_unsold`) + if(isNaN(`natural_block_cpm_partner_wo_nds`), 0, `natural_block_cpm_partner_wo_nds`) + if(isNaN(`stripe_all_wo_nds`), 0, `stripe_all_wo_nds`) + if(isNaN(`percent_content_bad_win_partner_price_content_partner_wo_nds`), 0, `percent_content_bad_win_partner_price_content_partner_wo_nds`) + if(isNaN(`adblock_block_shows`), 0, `adblock_block_shows`) + if(isNaN(`natural_bad_win_partner_price_wo_nds`), 0, `natural_bad_win_partner_price_wo_nds`) + if(isNaN(`adblock_all_wo_nds`), 0, `adblock_all_wo_nds`) + if(isNaN(`rtb_block_direct_shows`), 0, `rtb_block_direct_shows`) + if(isNaN(`content_block_cpmh_all_wo_nds`), 0, `content_block_cpmh_all_wo_nds`) + if(isNaN(`rtb_partner_wo_nds`), 0, `rtb_partner_wo_nds`) + if(isNaN(`direct_context_cpm_direct_context_all_wo_nds`), 0, `direct_context_cpm_direct_context_all_wo_nds`) + if(isNaN(`content_block_rpm_partner_wo_nds`), 0, `content_block_rpm_partner_wo_nds`) + if(isNaN(`mcb_context_ctr`), 0, `mcb_context_ctr`) + if(isNaN(`natural_block_winrate`), 0, `natural_block_winrate`) + if(isNaN(`natural_block_shows`), 0, `natural_block_shows`) + if(isNaN(`adblock_block_visibility`), 0, `adblock_block_visibility`) + if(isNaN(`stripe_cpm_all_wo_nds`), 0, `stripe_cpm_all_wo_nds`) + if(isNaN(`natural_block_direct_clicks`), 0, `natural_block_direct_clicks`) + if(isNaN(`direct_context_cpm_direct_context_partner_wo_nds`), 0, `direct_context_cpm_direct_context_partner_wo_nds`) + if(isNaN(`content_block_direct_clicks`), 0, `content_block_direct_clicks`) + if(isNaN(`natural_block_hits_own_adv`), 0, `natural_block_hits_own_adv`) + if(isNaN(`adblock_block_hits`), 0, `adblock_block_hits`) + if(isNaN(`natural_block_bad_win_hits_unsold`), 0, `natural_block_bad_win_hits_unsold`) + if(isNaN(`content_bad_win_price_wo_nds`), 0, `content_bad_win_price_wo_nds`) + if(isNaN(`content_block_direct_shows`), 0, `content_block_direct_shows`) + if(isNaN(`bad_win_partner_price_wo_nds`), 0, `bad_win_partner_price_wo_nds`) + if(isNaN(`content_block_all_hits`), 0, `content_block_all_hits`) + if(isNaN(`adblock_block_cpmh_partner_wo_nds`), 0, `adblock_block_cpmh_partner_wo_nds`) + if(isNaN(`stripe_hits`), 0, `stripe_hits`) + if(isNaN(`rtb_block_hits`), 0, `rtb_block_hits`) + if(isNaN(`mcb_context_all_wo_nds`), 0, `mcb_context_all_wo_nds`) + if(isNaN(`market_context_shows`), 0, `market_context_shows`) + if(isNaN(`natural_block_bad_win_hits_own_adv`), 0, `natural_block_bad_win_hits_own_adv`) + if(isNaN(`market_context_cpc_market_context_partner_wo_nds`), 0, `market_context_cpc_market_context_partner_wo_nds`) + if(isNaN(`natural_bad_win_price_wo_nds`), 0, `natural_bad_win_price_wo_nds`) + if(isNaN(`natural_block_cpm_all_wo_nds`), 0, `natural_block_cpm_all_wo_nds`) + if(isNaN(`partner_wo_nds`), 0, `partner_wo_nds`) + if(isNaN(`mcb_context_clicks`), 0, `mcb_context_clicks`) + if(isNaN(`content_partner_wo_nds`), 0, `content_partner_wo_nds`) + if(isNaN(`market_api_context_cpc_market_api_context_partner_wo_nds`), 0, `market_api_context_cpc_market_api_context_partner_wo_nds`) + if(isNaN(`adblock_partner_wo_nds`), 0, `adblock_partner_wo_nds`) + if(isNaN(`percent_rtb_bad_win_price_rtb_all_wo_nds`), 0, `percent_rtb_bad_win_price_rtb_all_wo_nds`) + if(isNaN(`content_block_shows_own_adv`), 0, `content_block_shows_own_adv`) + if(isNaN(`direct_context_shows`), 0, `direct_context_shows`) + if(isNaN(`stripe_cpc_all_wo_nds`), 0, `stripe_cpc_all_wo_nds`) + if(isNaN(`content_block_cpmh_partner_wo_nds`), 0, `content_block_cpmh_partner_wo_nds`) + if(isNaN(`content_block_direct_ctr`), 0, `content_block_direct_ctr`) + if(isNaN(`stripe_ctr`), 0, `stripe_ctr`) + if(isNaN(`content_block_cpm_partner_wo_nds`), 0, `content_block_cpm_partner_wo_nds`) + if(isNaN(`adblock_block_cpm_all_wo_nds`), 0, `adblock_block_cpm_all_wo_nds`) + if(isNaN(`stripe_cpc_partner_wo_nds`), 0, `stripe_cpc_partner_wo_nds`) + if(isNaN(`stripe_clicks`), 0, `stripe_clicks`) + if(isNaN(`content_block_visibility`), 0, `content_block_visibility`) + if(isNaN(`market_context_all_wo_nds`), 0, `market_context_all_wo_nds`) + if(isNaN(`rtb_block_bad_win_hits_own_adv`), 0, `rtb_block_bad_win_hits_own_adv`) + if(isNaN(`percent_content_bad_win_price_content_all_wo_nds`), 0, `percent_content_bad_win_price_content_all_wo_nds`) + if(isNaN(`content_block_bad_win_hits_own_adv`), 0, `content_block_bad_win_hits_own_adv`) + if(isNaN(`natural_block_visibility`), 0, `natural_block_visibility`) + if(isNaN(`direct_context_clicks`), 0, `direct_context_clicks`) + if(isNaN(`content_block_shows`), 0, `content_block_shows`) + if(isNaN(`market_api_context_all_wo_nds`), 0, `market_api_context_all_wo_nds`) + if(isNaN(`rtb_bad_win_partner_price_wo_nds`), 0, `rtb_bad_win_partner_price_wo_nds`) + if(isNaN(`adblock_block_rpm_partner_wo_nds`), 0, `adblock_block_rpm_partner_wo_nds`) + if(isNaN(`rtb_block_cpm_all_wo_nds`), 0, `rtb_block_cpm_all_wo_nds`) + if(isNaN(`market_api_context_cpm_market_api_context_all_wo_nds`), 0, `market_api_context_cpm_market_api_context_all_wo_nds`) + if(isNaN(`rtb_block_visibility`), 0, `rtb_block_visibility`) + if(isNaN(`rtb_block_rpm_all_wo_nds`), 0, `rtb_block_rpm_all_wo_nds`) + if(isNaN(`natural_partner_wo_nds`), 0, `natural_partner_wo_nds`) + if(isNaN(`market_context_clicks`), 0, `market_context_clicks`) + if(isNaN(`natural_block_cover_ratio`), 0, `natural_block_cover_ratio`) + if(isNaN(`adblock_block_cpmh_all_wo_nds`), 0, `adblock_block_cpmh_all_wo_nds`) + if(isNaN(`content_block_cpm_all_wo_nds`), 0, `content_block_cpm_all_wo_nds`) + if(isNaN(`direct_context_ctr`), 0, `direct_context_ctr`) + if(isNaN(`natural_block_direct_ctr`), 0, `natural_block_direct_ctr`) + if(isNaN(`market_context_cpm_market_context_all_wo_nds`), 0, `market_context_cpm_market_context_all_wo_nds`) + if(isNaN(`content_block_cover_ratio`), 0, `content_block_cover_ratio`) + if(isNaN(`direct_context_partner_wo_nds`), 0, `direct_context_partner_wo_nds`) + if(isNaN(`adblock_block_cover_ratio`), 0, `adblock_block_cover_ratio`) + if(isNaN(`stripe_partner_wo_nds`), 0, `stripe_partner_wo_nds`) + if(isNaN(`adblock_block_winrate`), 0, `adblock_block_winrate`) + if(isNaN(`adblock_block_hits_own_adv`), 0, `adblock_block_hits_own_adv`) + if(isNaN(`market_api_context_cpc_market_api_context_all_wo_nds`), 0, `market_api_context_cpc_market_api_context_all_wo_nds`) + if(isNaN(`stripe_cpmh_all_wo_nds`), 0, `stripe_cpmh_all_wo_nds`) + if(isNaN(`natural_block_bad_shows`), 0, `natural_block_bad_shows`) + if(isNaN(`direct_context_cpc_direct_context_partner_wo_nds`), 0, `direct_context_cpc_direct_context_partner_wo_nds`) + if(isNaN(`mcb_context_cpm_mcb_context_all_wo_nds`), 0, `mcb_context_cpm_mcb_context_all_wo_nds`) + if(isNaN(`natural_block_hits_unsold`), 0, `natural_block_hits_unsold`) + if(isNaN(`natural_block_bad_shows_percent`), 0, `natural_block_bad_shows_percent`) + if(isNaN(`content_block_bad_shows_own_adv`), 0, `content_block_bad_shows_own_adv`) + if(isNaN(`direct_context_cpc_direct_context_all_wo_nds`), 0, `direct_context_cpc_direct_context_all_wo_nds`) + if(isNaN(`market_context_cpm_market_context_partner_wo_nds`), 0, `market_context_cpm_market_context_partner_wo_nds`) + if(isNaN(`mcb_context_cpm_mcb_context_partner_wo_nds`), 0, `mcb_context_cpm_mcb_context_partner_wo_nds`) + if(isNaN(`percent_natural_bad_win_partner_price_natural_partner_wo_nds`), 0, `percent_natural_bad_win_partner_price_natural_partner_wo_nds`) + if(isNaN(`mcb_context_partner_wo_nds`), 0, `mcb_context_partner_wo_nds`) + if(isNaN(`rtb_block_bad_shows_percent`), 0, `rtb_block_bad_shows_percent`) + if(isNaN(`content_block_hits`), 0, `content_block_hits`) + if(isNaN(`rtb_block_cover_ratio`), 0, `rtb_block_cover_ratio`) + if(isNaN(`adblock_block_rpm_all_wo_nds`), 0, `adblock_block_rpm_all_wo_nds`) + if(isNaN(`all_wo_nds`), 0, `all_wo_nds`) + if(isNaN(`direct_context_all_wo_nds`), 0, `direct_context_all_wo_nds`) + if(isNaN(`rtb_block_bad_win_hits_percent`), 0, `rtb_block_bad_win_hits_percent`) + if(isNaN(`natural_block_rpm_all_wo_nds`), 0, `natural_block_rpm_all_wo_nds`) + if(isNaN(`rtb_block_rpm_partner_wo_nds`), 0, `rtb_block_rpm_partner_wo_nds`) + if(isNaN(`content_block_bad_win_hits`), 0, `content_block_bad_win_hits`) + if(isNaN(`percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`), 0, `percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`) + if(isNaN(`content_block_hits_own_adv`), 0, `content_block_hits_own_adv`) + if(isNaN(`natural_block_bad_shows_own_adv`), 0, `natural_block_bad_shows_own_adv`) + if(isNaN(`natural_block_bad_win_hits_percent`), 0, `natural_block_bad_win_hits_percent`) + if(isNaN(`market_context_cpc_market_context_all_wo_nds`), 0, `market_context_cpc_market_context_all_wo_nds`) + if(isNaN(`natural_block_cpmh_partner_wo_nds`), 0, `natural_block_cpmh_partner_wo_nds`) + if(isNaN(`natural_all_wo_nds`), 0, `natural_all_wo_nds`) + if(isNaN(`rtb_block_direct_clicks`), 0, `rtb_block_direct_clicks`) + if(isNaN(`mcb_context_shows`), 0, `mcb_context_shows`) + if(isNaN(`rtb_block_winrate`), 0, `rtb_block_winrate`) + if(isNaN(`market_api_context_shows`), 0, `market_api_context_shows`) + if(isNaN(`content_block_winrate`), 0, `content_block_winrate`) + if(isNaN(`rtb_block_bad_win_hits`), 0, `rtb_block_bad_win_hits`) + if(isNaN(`natural_block_all_hits`), 0, `natural_block_all_hits`) + if(isNaN(`rtb_block_hits_unsold`), 0, `rtb_block_hits_unsold`) + if(isNaN(`content_block_hits_unsold`), 0, `content_block_hits_unsold`) + if(isNaN(`rtb_block_bad_win_hits_unsold`), 0, `rtb_block_bad_win_hits_unsold`) + if(isNaN(`bad_win_price_wo_nds`), 0, `bad_win_price_wo_nds`) + if(isNaN(`rtb_block_hits_own_adv`), 0, `rtb_block_hits_own_adv`) + if(isNaN(`content_bad_win_partner_price_wo_nds`), 0, `content_bad_win_partner_price_wo_nds`) + if(isNaN(`natural_block_shows_own_adv`), 0, `natural_block_shows_own_adv`) + if(isNaN(`natural_block_cpmh_all_wo_nds`), 0, `natural_block_cpmh_all_wo_nds`) + if(isNaN(`rtb_block_shows`), 0, `rtb_block_shows`) + if(isNaN(`adblock_block_shows_own_adv`), 0, `adblock_block_shows_own_adv`) + if(isNaN(`content_all_wo_nds`), 0, `content_all_wo_nds`) + if(isNaN(`stripe_cpmh_partner_wo_nds`), 0, `stripe_cpmh_partner_wo_nds`) + if(isNaN(`natural_block_bad_win_hits`), 0, `natural_block_bad_win_hits`) + if(isNaN(`market_api_context_cpm_market_api_context_partner_wo_nds`), 0, `market_api_context_cpm_market_api_context_partner_wo_nds`) + if(isNaN(`rtb_block_all_hits`), 0, `rtb_block_all_hits`) + if(isNaN(`market_api_context_ctr`), 0, `market_api_context_ctr`) + if(isNaN(`rtb_all_wo_nds`), 0, `rtb_all_wo_nds`) + if(isNaN(`rtb_block_shows_own_adv`), 0, `rtb_block_shows_own_adv`) + if(isNaN(`market_api_context_partner_wo_nds`), 0, `market_api_context_partner_wo_nds`) + if(isNaN(`market_context_partner_wo_nds`), 0, `market_context_partner_wo_nds`) + if(isNaN(`content_block_rpm_all_wo_nds`), 0, `content_block_rpm_all_wo_nds`) + if(isNaN(`stripe_cpm_partner_wo_nds`), 0, `stripe_cpm_partner_wo_nds`) + if(isNaN(`rtb_block_bad_shows_own_adv`), 0, `rtb_block_bad_shows_own_adv`) + if(isNaN(`rtb_block_cpmh_all_wo_nds`), 0, `rtb_block_cpmh_all_wo_nds`) + if(isNaN(`rtb_block_cpm_partner_wo_nds`), 0, `rtb_block_cpm_partner_wo_nds`) + if(isNaN(`content_block_bad_win_hits_percent`), 0, `content_block_bad_win_hits_percent`) + if(isNaN(`natural_block_rpm_partner_wo_nds`), 0, `natural_block_rpm_partner_wo_nds`)) > 0
) FORMAT JSONCompact

SELECT
    `_adblock_all_wo_nds` AS `adblock_all_wo_nds`,
    `_adblock_block_all_hits` AS `adblock_block_all_hits`,
    `_adblock_block_cover_ratio` AS `adblock_block_cover_ratio`,
    `_adblock_block_cpm_all_wo_nds` AS `adblock_block_cpm_all_wo_nds`,
    `_adblock_block_cpm_partner_wo_nds` AS `adblock_block_cpm_partner_wo_nds`,
    `_adblock_block_cpmh_all_wo_nds` AS `adblock_block_cpmh_all_wo_nds`,
    `_adblock_block_cpmh_partner_wo_nds` AS `adblock_block_cpmh_partner_wo_nds`,
    `_adblock_block_hits` AS `adblock_block_hits`,
    `_adblock_block_hits_own_adv` AS `adblock_block_hits_own_adv`,
    `_adblock_block_hits_unsold` AS `adblock_block_hits_unsold`,
    `_adblock_block_rpm_all_wo_nds` AS `adblock_block_rpm_all_wo_nds`,
    `_adblock_block_rpm_partner_wo_nds` AS `adblock_block_rpm_partner_wo_nds`,
    `_adblock_block_shows` AS `adblock_block_shows`,
    `_adblock_block_shows_own_adv` AS `adblock_block_shows_own_adv`,
    `_adblock_block_visibility` AS `adblock_block_visibility`,
    `_adblock_block_winrate` AS `adblock_block_winrate`,
    `_adblock_partner_wo_nds` AS `adblock_partner_wo_nds`,
    `_all_wo_nds` AS `all_wo_nds`,
    `_an_cover_direct_hits` AS `an_cover_direct_hits`,
    `_an_cover_hits` AS `an_cover_hits`,
    `_an_cover_market_hits` AS `an_cover_market_hits`,
    `_an_cover_mcb_hits` AS `an_cover_mcb_hits`,
    `_an_cover_senthits` AS `an_cover_senthits`,
    `_an_fraud_clicks` AS `an_fraud_clicks`,
    `_an_fraud_shows` AS `an_fraud_shows`,
    `_an_rtb_cover_direct_hits` AS `an_rtb_cover_direct_hits`,
    `_an_rtb_cover_hits` AS `an_rtb_cover_hits`,
    `_an_rtb_cover_senthits` AS `an_rtb_cover_senthits`,
    `_bad_win_partner_price_wo_nds` AS `bad_win_partner_price_wo_nds`,
    `_bad_win_price_wo_nds` AS `bad_win_price_wo_nds`,
    `_caption` AS `caption`,
    `_content_all_wo_nds` AS `content_all_wo_nds`,
    `_content_bad_win_partner_price_wo_nds` AS `content_bad_win_partner_price_wo_nds`,
    `_content_bad_win_price_wo_nds` AS `content_bad_win_price_wo_nds`,
    `_content_block_all_hits` AS `content_block_all_hits`,
    `_content_block_bad_shows` AS `content_block_bad_shows`,
    `_content_block_bad_shows_own_adv` AS `content_block_bad_shows_own_adv`,
    `_content_block_bad_shows_percent` AS `content_block_bad_shows_percent`,
    `_content_block_bad_win_hits` AS `content_block_bad_win_hits`,
    `_content_block_bad_win_hits_own_adv` AS `content_block_bad_win_hits_own_adv`,
    `_content_block_bad_win_hits_percent` AS `content_block_bad_win_hits_percent`,
    `_content_block_bad_win_hits_unsold` AS `content_block_bad_win_hits_unsold`,
    `_content_block_cover_ratio` AS `content_block_cover_ratio`,
    `_content_block_cpm_all_wo_nds` AS `content_block_cpm_all_wo_nds`,
    `_content_block_cpm_partner_wo_nds` AS `content_block_cpm_partner_wo_nds`,
    `_content_block_cpmh_all_wo_nds` AS `content_block_cpmh_all_wo_nds`,
    `_content_block_cpmh_partner_wo_nds` AS `content_block_cpmh_partner_wo_nds`,
    `_content_block_direct_clicks` AS `content_block_direct_clicks`,
    `_content_block_direct_ctr` AS `content_block_direct_ctr`,
    `_content_block_direct_shows` AS `content_block_direct_shows`,
    `_content_block_hits` AS `content_block_hits`,
    `_content_block_hits_own_adv` AS `content_block_hits_own_adv`,
    `_content_block_hits_unsold` AS `content_block_hits_unsold`,
    `_content_block_rpm_all_wo_nds` AS `content_block_rpm_all_wo_nds`,
    `_content_block_rpm_partner_wo_nds` AS `content_block_rpm_partner_wo_nds`,
    `_content_block_shows` AS `content_block_shows`,
    `_content_block_shows_own_adv` AS `content_block_shows_own_adv`,
    `_content_block_visibility` AS `content_block_visibility`,
    `_content_block_winrate` AS `content_block_winrate`,
    `_content_partner_wo_nds` AS `content_partner_wo_nds`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_direct_ad_coverage` AS `direct_ad_coverage`,
    `_direct_ad_reach` AS `direct_ad_reach`,
    `_direct_ad_visibility` AS `direct_ad_visibility`,
    `_direct_context_ads` AS `direct_context_ads`,
    `_direct_context_all_wo_nds` AS `direct_context_all_wo_nds`,
    `_direct_context_clicks` AS `direct_context_clicks`,
    `_direct_context_cpc_direct_context_all_wo_nds` AS `direct_context_cpc_direct_context_all_wo_nds`,
    `_direct_context_cpc_direct_context_partner_wo_nds` AS `direct_context_cpc_direct_context_partner_wo_nds`,
    `_direct_context_cpm_direct_context_all_wo_nds` AS `direct_context_cpm_direct_context_all_wo_nds`,
    `_direct_context_cpm_direct_context_partner_wo_nds` AS `direct_context_cpm_direct_context_partner_wo_nds`,
    `_direct_context_cpmh_direct_context_all_wo_nds` AS `direct_context_cpmh_direct_context_all_wo_nds`,
    `_direct_context_cpmh_direct_context_partner_wo_nds` AS `direct_context_cpmh_direct_context_partner_wo_nds`,
    `_direct_context_ctr` AS `direct_context_ctr`,
    `_direct_context_hits` AS `direct_context_hits`,
    `_direct_context_page_ad_shows` AS `direct_context_page_ad_shows`,
    `_direct_context_partner_wo_nds` AS `direct_context_partner_wo_nds`,
    `_direct_context_shows` AS `direct_context_shows`,
    `_domain` AS `domain`,
    `_domain_id` AS `domain_id`,
    `_id` AS `id`,
    `_login` AS `login`,
    `_market_api_context_all_wo_nds` AS `market_api_context_all_wo_nds`,
    `_market_api_context_clicks` AS `market_api_context_clicks`,
    `_market_api_context_cpc_market_api_context_all_wo_nds` AS `market_api_context_cpc_market_api_context_all_wo_nds`,
    `_market_api_context_cpc_market_api_context_partner_wo_nds` AS `market_api_context_cpc_market_api_context_partner_wo_nds`,
    `_market_api_context_cpm_market_api_context_all_wo_nds` AS `market_api_context_cpm_market_api_context_all_wo_nds`,
    `_market_api_context_cpm_market_api_context_partner_wo_nds` AS `market_api_context_cpm_market_api_context_partner_wo_nds`,
    `_market_api_context_ctr` AS `market_api_context_ctr`,
    `_market_api_context_partner_wo_nds` AS `market_api_context_partner_wo_nds`,
    `_market_api_context_shows` AS `market_api_context_shows`,
    `_market_context_all_wo_nds` AS `market_context_all_wo_nds`,
    `_market_context_clicks` AS `market_context_clicks`,
    `_market_context_cpc_market_context_all_wo_nds` AS `market_context_cpc_market_context_all_wo_nds`,
    `_market_context_cpc_market_context_partner_wo_nds` AS `market_context_cpc_market_context_partner_wo_nds`,
    `_market_context_cpm_market_context_all_wo_nds` AS `market_context_cpm_market_context_all_wo_nds`,
    `_market_context_cpm_market_context_partner_wo_nds` AS `market_context_cpm_market_context_partner_wo_nds`,
    `_market_context_cpmh_market_context_all_wo_nds` AS `market_context_cpmh_market_context_all_wo_nds`,
    `_market_context_cpmh_market_context_partner_wo_nds` AS `market_context_cpmh_market_context_partner_wo_nds`,
    `_market_context_ctr` AS `market_context_ctr`,
    `_market_context_hits` AS `market_context_hits`,
    `_market_context_partner_wo_nds` AS `market_context_partner_wo_nds`,
    `_market_context_shows` AS `market_context_shows`,
    `_mcb_context_all_wo_nds` AS `mcb_context_all_wo_nds`,
    `_mcb_context_clicks` AS `mcb_context_clicks`,
    `_mcb_context_cpm_mcb_context_all_wo_nds` AS `mcb_context_cpm_mcb_context_all_wo_nds`,
    `_mcb_context_cpm_mcb_context_partner_wo_nds` AS `mcb_context_cpm_mcb_context_partner_wo_nds`,
    `_mcb_context_cpmh_mcb_context_all_wo_nds` AS `mcb_context_cpmh_mcb_context_all_wo_nds`,
    `_mcb_context_cpmh_mcb_context_partner_wo_nds` AS `mcb_context_cpmh_mcb_context_partner_wo_nds`,
    `_mcb_context_ctr` AS `mcb_context_ctr`,
    `_mcb_context_hits` AS `mcb_context_hits`,
    `_mcb_context_partner_wo_nds` AS `mcb_context_partner_wo_nds`,
    `_mcb_context_shows` AS `mcb_context_shows`,
    `_natural_all_wo_nds` AS `natural_all_wo_nds`,
    `_natural_bad_win_partner_price_wo_nds` AS `natural_bad_win_partner_price_wo_nds`,
    `_natural_bad_win_price_wo_nds` AS `natural_bad_win_price_wo_nds`,
    `_natural_block_all_hits` AS `natural_block_all_hits`,
    `_natural_block_bad_shows` AS `natural_block_bad_shows`,
    `_natural_block_bad_shows_own_adv` AS `natural_block_bad_shows_own_adv`,
    `_natural_block_bad_shows_percent` AS `natural_block_bad_shows_percent`,
    `_natural_block_bad_win_hits` AS `natural_block_bad_win_hits`,
    `_natural_block_bad_win_hits_own_adv` AS `natural_block_bad_win_hits_own_adv`,
    `_natural_block_bad_win_hits_percent` AS `natural_block_bad_win_hits_percent`,
    `_natural_block_bad_win_hits_unsold` AS `natural_block_bad_win_hits_unsold`,
    `_natural_block_cover_ratio` AS `natural_block_cover_ratio`,
    `_natural_block_cpm_all_wo_nds` AS `natural_block_cpm_all_wo_nds`,
    `_natural_block_cpm_partner_wo_nds` AS `natural_block_cpm_partner_wo_nds`,
    `_natural_block_cpmh_all_wo_nds` AS `natural_block_cpmh_all_wo_nds`,
    `_natural_block_cpmh_partner_wo_nds` AS `natural_block_cpmh_partner_wo_nds`,
    `_natural_block_direct_clicks` AS `natural_block_direct_clicks`,
    `_natural_block_direct_ctr` AS `natural_block_direct_ctr`,
    `_natural_block_direct_shows` AS `natural_block_direct_shows`,
    `_natural_block_hits` AS `natural_block_hits`,
    `_natural_block_hits_own_adv` AS `natural_block_hits_own_adv`,
    `_natural_block_hits_unsold` AS `natural_block_hits_unsold`,
    `_natural_block_rpm_all_wo_nds` AS `natural_block_rpm_all_wo_nds`,
    `_natural_block_rpm_partner_wo_nds` AS `natural_block_rpm_partner_wo_nds`,
    `_natural_block_shows` AS `natural_block_shows`,
    `_natural_block_shows_own_adv` AS `natural_block_shows_own_adv`,
    `_natural_block_visibility` AS `natural_block_visibility`,
    `_natural_block_winrate` AS `natural_block_winrate`,
    `_natural_partner_wo_nds` AS `natural_partner_wo_nds`,
    `_page_id` AS `page_id`,
    `_partner_wo_nds` AS `partner_wo_nds`,
    `_percent_content_bad_win_partner_price_content_partner_wo_nds` AS `percent_content_bad_win_partner_price_content_partner_wo_nds`,
    `_percent_content_bad_win_price_content_all_wo_nds` AS `percent_content_bad_win_price_content_all_wo_nds`,
    `_percent_natural_bad_win_partner_price_natural_partner_wo_nds` AS `percent_natural_bad_win_partner_price_natural_partner_wo_nds`,
    `_percent_natural_bad_win_price_natural_all_wo_nds` AS `percent_natural_bad_win_price_natural_all_wo_nds`,
    `_percent_rtb_bad_win_partner_price_rtb_partner_wo_nds` AS `percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`,
    `_percent_rtb_bad_win_price_rtb_all_wo_nds` AS `percent_rtb_bad_win_price_rtb_all_wo_nds`,
    `_rtb_all_wo_nds` AS `rtb_all_wo_nds`,
    `_rtb_bad_win_partner_price_wo_nds` AS `rtb_bad_win_partner_price_wo_nds`,
    `_rtb_bad_win_price_wo_nds` AS `rtb_bad_win_price_wo_nds`,
    `_rtb_block_all_hits` AS `rtb_block_all_hits`,
    `_rtb_block_bad_shows` AS `rtb_block_bad_shows`,
    `_rtb_block_bad_shows_own_adv` AS `rtb_block_bad_shows_own_adv`,
    `_rtb_block_bad_shows_percent` AS `rtb_block_bad_shows_percent`,
    `_rtb_block_bad_win_hits` AS `rtb_block_bad_win_hits`,
    `_rtb_block_bad_win_hits_own_adv` AS `rtb_block_bad_win_hits_own_adv`,
    `_rtb_block_bad_win_hits_percent` AS `rtb_block_bad_win_hits_percent`,
    `_rtb_block_bad_win_hits_unsold` AS `rtb_block_bad_win_hits_unsold`,
    `_rtb_block_cover_ratio` AS `rtb_block_cover_ratio`,
    `_rtb_block_cpm_all_wo_nds` AS `rtb_block_cpm_all_wo_nds`,
    `_rtb_block_cpm_partner_wo_nds` AS `rtb_block_cpm_partner_wo_nds`,
    `_rtb_block_cpmh_all_wo_nds` AS `rtb_block_cpmh_all_wo_nds`,
    `_rtb_block_cpmh_partner_wo_nds` AS `rtb_block_cpmh_partner_wo_nds`,
    `_rtb_block_direct_clicks` AS `rtb_block_direct_clicks`,
    `_rtb_block_direct_ctr` AS `rtb_block_direct_ctr`,
    `_rtb_block_direct_shows` AS `rtb_block_direct_shows`,
    `_rtb_block_hits` AS `rtb_block_hits`,
    `_rtb_block_hits_own_adv` AS `rtb_block_hits_own_adv`,
    `_rtb_block_hits_unsold` AS `rtb_block_hits_unsold`,
    `_rtb_block_rpm_all_wo_nds` AS `rtb_block_rpm_all_wo_nds`,
    `_rtb_block_rpm_partner_wo_nds` AS `rtb_block_rpm_partner_wo_nds`,
    `_rtb_block_shows` AS `rtb_block_shows`,
    `_rtb_block_shows_own_adv` AS `rtb_block_shows_own_adv`,
    `_rtb_block_visibility` AS `rtb_block_visibility`,
    `_rtb_block_winrate` AS `rtb_block_winrate`,
    `_rtb_partner_wo_nds` AS `rtb_partner_wo_nds`,
    `_stripe_all_wo_nds` AS `stripe_all_wo_nds`,
    `_stripe_clicks` AS `stripe_clicks`,
    `_stripe_cpc_all_wo_nds` AS `stripe_cpc_all_wo_nds`,
    `_stripe_cpc_partner_wo_nds` AS `stripe_cpc_partner_wo_nds`,
    `_stripe_cpm_all_wo_nds` AS `stripe_cpm_all_wo_nds`,
    `_stripe_cpm_partner_wo_nds` AS `stripe_cpm_partner_wo_nds`,
    `_stripe_cpmh_all_wo_nds` AS `stripe_cpmh_all_wo_nds`,
    `_stripe_cpmh_partner_wo_nds` AS `stripe_cpmh_partner_wo_nds`,
    `_stripe_ctr` AS `stripe_ctr`,
    `_stripe_hits` AS `stripe_hits`,
    `_stripe_partner_wo_nds` AS `stripe_partner_wo_nds`,
    `_stripe_shows` AS `stripe_shows`
FROM (
    SELECT
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000), 2) AS `_adblock_all_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_adblock') AS `_adblock_block_all_hits`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_adblock')) AS `_adblock_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpmh_partner_wo_nds`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_adblock')), 2) AS `_adblock_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_adblock')), 2) AS `_adblock_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_adblock'
        ))) AS `_adblock_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_adblock'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_adblock'
            )))) AS `_adblock_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000), 2) AS `_adblock_partner_wo_nds`,
        round((SUM((`all_wo_nds` / 1000)) / 10000000), 2) AS `_all_wo_nds`,
        sumIf(`an_cover_direct_hits`, `product_id` = 'context_on_site_campaign') AS `_an_cover_direct_hits`,
        sumIf(`an_cover_hits`, `product_id` = 'context_on_site_campaign') AS `_an_cover_hits`,
        sumIf(`an_cover_market_hits`, `product_id` = 'context_on_site_campaign') AS `_an_cover_market_hits`,
        sumIf(`an_cover_mcb_hits`, `product_id` = 'context_on_site_campaign') AS `_an_cover_mcb_hits`,
        sumIf(`an_cover_senthits`, `product_id` = 'context_on_site_campaign') AS `_an_cover_senthits`,
        sumIf(`an_fraud_clicks`, `product_id` = 'context_on_site_campaign') AS `_an_fraud_clicks`,
        sumIf(`an_fraud_shows`, `product_id` = 'context_on_site_campaign') AS `_an_fraud_shows`,
        sumIf(`an_rtb_cover_direct_hits`, `product_id` = 'context_on_site_campaign') AS `_an_rtb_cover_direct_hits`,
        sumIf(`an_rtb_cover_hits`, `product_id` = 'context_on_site_campaign') AS `_an_rtb_cover_hits`,
        sumIf(`an_rtb_cover_senthits`, `product_id` = 'context_on_site_campaign') AS `_an_rtb_cover_senthits`,
        round((SUM((`bad_win_partner_price_wo_nds` / 1000)) / 10000000), 2) AS `_bad_win_partner_price_wo_nds`,
        round((SUM((`bad_win_price_wo_nds` / 1000)) / 10000000), 2) AS `_bad_win_price_wo_nds`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_caption`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_content') AS `_content_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )))) AS `_content_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )))) AS `_content_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_content')) AS `_content_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'context_on_site_content'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'context_on_site_content')) AS `_content_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'context_on_site_content') AS `_content_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_content')), 2) AS `_content_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_content')), 2) AS `_content_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_content'
        ))) AS `_content_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_content'
            )))) AS `_content_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_partner_wo_nds`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        ((sumIf(`an_cover_direct_hits`, `product_id` = 'context_on_site_campaign') * 100) / sumIf(`an_cover_hits`, `product_id` = 'context_on_site_campaign')) AS `_direct_ad_coverage`,
        ((sumIf(`an_cover_senthits`, `product_id` = 'context_on_site_campaign') * 100) / sumIf(`an_cover_hits`, `product_id` = 'context_on_site_campaign')) AS `_direct_ad_reach`,
        ((sumIf(`an_cover_direct_hits`, `product_id` = 'context_on_site_campaign') * 100) / sumIf(`an_cover_senthits`, `product_id` = 'context_on_site_campaign')) AS `_direct_ad_visibility`,
        (sumIf(`shows`, `product_id` = 'context_on_site_direct') / sumIf(`direct_page_ad_shows`, `product_id` = 'context_on_site_campaign')) AS `_direct_context_ads`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000), 2) AS `_direct_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_direct') AS `_direct_context_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpc_direct_context_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpc_direct_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpm_direct_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpm_direct_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) * 1000) / sumIf(`direct_hits`, `product_id` = 'context_on_site_campaign')), 2) AS `_direct_context_cpmh_direct_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) * 1000) / sumIf(`direct_hits`, `product_id` = 'context_on_site_campaign')), 2) AS `_direct_context_cpmh_direct_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_direct') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_direct')) AS `_direct_context_ctr`,
        sumIf(`direct_hits`, `product_id` = 'context_on_site_campaign') AS `_direct_context_hits`,
        sumIf(`direct_page_ad_shows`, `product_id` = 'context_on_site_campaign') AS `_direct_context_page_ad_shows`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000), 2) AS `_direct_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_direct') AS `_direct_context_shows`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_domain_id`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_id`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000), 2) AS `_market_api_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_market_api') AS `_market_api_context_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpc_market_api_context_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpc_market_api_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpm_market_api_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpm_market_api_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_market_api') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_market_api')) AS `_market_api_context_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000), 2) AS `_market_api_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_market_api') AS `_market_api_context_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000), 2) AS `_market_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_market') AS `_market_context_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpc_market_context_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpc_market_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpm_market_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpm_market_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) * 1000) / sumIf(`market_hits`, `product_id` = 'context_on_site_campaign')), 2) AS `_market_context_cpmh_market_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) * 1000) / sumIf(`market_hits`, `product_id` = 'context_on_site_campaign')), 2) AS `_market_context_cpmh_market_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_market') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_market')) AS `_market_context_ctr`,
        sumIf(`market_hits`, `product_id` = 'context_on_site_campaign') AS `_market_context_hits`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000), 2) AS `_market_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_market') AS `_market_context_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000), 2) AS `_mcb_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_mcb') AS `_mcb_context_clicks`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_mcb')), 2) AS `_mcb_context_cpm_mcb_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_mcb')), 2) AS `_mcb_context_cpm_mcb_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000) * 1000) / sumIf(`mcb_hits`, `product_id` = 'context_on_site_campaign')), 2) AS `_mcb_context_cpmh_mcb_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000) * 1000) / sumIf(`mcb_hits`, `product_id` = 'context_on_site_campaign')), 2) AS `_mcb_context_cpmh_mcb_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_mcb') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_mcb')) AS `_mcb_context_ctr`,
        sumIf(`mcb_hits`, `product_id` = 'context_on_site_campaign') AS `_mcb_context_hits`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000), 2) AS `_mcb_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_mcb') AS `_mcb_context_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_natural') AS `_natural_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )))) AS `_natural_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )))) AS `_natural_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_natural')) AS `_natural_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'context_on_site_natural')) AS `_natural_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'context_on_site_natural') AS `_natural_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_natural')), 2) AS `_natural_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_natural')), 2) AS `_natural_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_natural'
        ))) AS `_natural_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_natural'
            )))) AS `_natural_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_partner_wo_nds`,
        `page_id` AS `_page_id`,
        round((SUM((`partner_wo_nds` / 1000)) / 10000000), 2) AS `_partner_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_content'))) AS `_percent_content_bad_win_partner_price_content_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_content'))) AS `_percent_content_bad_win_price_content_all_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural'))) AS `_percent_natural_bad_win_partner_price_natural_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural'))) AS `_percent_natural_bad_win_price_natural_all_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_rtb'))) AS `_percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_rtb'))) AS `_percent_rtb_bad_win_price_rtb_all_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000), 2) AS `_rtb_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000), 2) AS `_rtb_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000), 2) AS `_rtb_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_rtb') AS `_rtb_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            )))) AS `_rtb_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            )))) AS `_rtb_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_rtb')) AS `_rtb_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'context_on_site_rtb'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'context_on_site_rtb')) AS `_rtb_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'context_on_site_rtb') AS `_rtb_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_rtb')), 2) AS `_rtb_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_rtb')), 2) AS `_rtb_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_rtb'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_rtb'
        ))) AS `_rtb_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_rtb'
            )))) AS `_rtb_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_rtb') / 10000000), 2) AS `_rtb_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000), 2) AS `_stripe_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_stripe') AS `_stripe_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpc_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpc_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpmh_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_stripe') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_stripe')) AS `_stripe_ctr`,
        sumIf(`hits`, `product_id` = 'context_on_site_stripe') AS `_stripe_hits`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000), 2) AS `_stripe_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_stripe') AS `_stripe_shows`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('context_on_site_campaign', 'context_on_site_rtb', 'context_on_site_direct', 'context_on_site_stripe', 'context_on_site_mcb', 'context_on_site_market', 'context_on_site_adblock', 'context_on_site_market_api', 'context_on_site_content', 'context_on_site_natural')
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["AND",[["login","=","mock__owner-login"]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["OR",[["is_efir_blogger","=",1],["is_video_blogger","=",1],["is_tutby","=",1],["is_adfox_partner","=",1],["is_mobile_mediation","=",1],["is_games","=",1]]]')
        )
        AND (
            `page_id` = 'mock__page_id'
        )
        AND (
            dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) = 'mock__caption'
        )
        AND (
            dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) IN ('id__from_table__site__with_filter__["AND",[["domain","=","mock__domain.domain"]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'multistate', toUInt64(`page_id`)) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
    )
    GROUP BY `_caption`, `_currency_id`, `_date`, `_domain`, `_domain_id`, `_id`, `_login`, `_page_id`
) `statistics`
WHERE (
    (if(isNaN(`an_fraud_clicks`), 0, `an_fraud_clicks`) + if(isNaN(`rtb_block_bad_shows`), 0, `rtb_block_bad_shows`) + if(isNaN(`market_context_ctr`), 0, `market_context_ctr`) + if(isNaN(`percent_natural_bad_win_price_natural_all_wo_nds`), 0, `percent_natural_bad_win_price_natural_all_wo_nds`) + if(isNaN(`rtb_bad_win_price_wo_nds`), 0, `rtb_bad_win_price_wo_nds`) + if(isNaN(`an_rtb_cover_direct_hits`), 0, `an_rtb_cover_direct_hits`) + if(isNaN(`content_block_bad_shows_percent`), 0, `content_block_bad_shows_percent`) + if(isNaN(`rtb_block_cpmh_partner_wo_nds`), 0, `rtb_block_cpmh_partner_wo_nds`) + if(isNaN(`an_cover_hits`), 0, `an_cover_hits`) + if(isNaN(`adblock_block_all_hits`), 0, `adblock_block_all_hits`) + if(isNaN(`adblock_block_cpm_partner_wo_nds`), 0, `adblock_block_cpm_partner_wo_nds`) + if(isNaN(`an_cover_direct_hits`), 0, `an_cover_direct_hits`) + if(isNaN(`natural_block_direct_shows`), 0, `natural_block_direct_shows`) + if(isNaN(`content_block_bad_win_hits_unsold`), 0, `content_block_bad_win_hits_unsold`) + if(isNaN(`natural_block_hits`), 0, `natural_block_hits`) + if(isNaN(`content_block_bad_shows`), 0, `content_block_bad_shows`) + if(isNaN(`rtb_block_direct_ctr`), 0, `rtb_block_direct_ctr`) + if(isNaN(`direct_ad_coverage`), 0, `direct_ad_coverage`) + if(isNaN(`stripe_shows`), 0, `stripe_shows`) + if(isNaN(`market_api_context_clicks`), 0, `market_api_context_clicks`) + if(isNaN(`adblock_block_hits_unsold`), 0, `adblock_block_hits_unsold`) + if(isNaN(`an_cover_senthits`), 0, `an_cover_senthits`) + if(isNaN(`natural_block_cpm_partner_wo_nds`), 0, `natural_block_cpm_partner_wo_nds`) + if(isNaN(`stripe_all_wo_nds`), 0, `stripe_all_wo_nds`) + if(isNaN(`adblock_block_shows`), 0, `adblock_block_shows`) + if(isNaN(`percent_content_bad_win_partner_price_content_partner_wo_nds`), 0, `percent_content_bad_win_partner_price_content_partner_wo_nds`) + if(isNaN(`natural_bad_win_partner_price_wo_nds`), 0, `natural_bad_win_partner_price_wo_nds`) + if(isNaN(`direct_context_cpmh_direct_context_partner_wo_nds`), 0, `direct_context_cpmh_direct_context_partner_wo_nds`) + if(isNaN(`adblock_all_wo_nds`), 0, `adblock_all_wo_nds`) + if(isNaN(`rtb_block_direct_shows`), 0, `rtb_block_direct_shows`) + if(isNaN(`content_block_cpmh_all_wo_nds`), 0, `content_block_cpmh_all_wo_nds`) + if(isNaN(`rtb_partner_wo_nds`), 0, `rtb_partner_wo_nds`) + if(isNaN(`direct_context_cpm_direct_context_all_wo_nds`), 0, `direct_context_cpm_direct_context_all_wo_nds`) + if(isNaN(`content_block_rpm_partner_wo_nds`), 0, `content_block_rpm_partner_wo_nds`) + if(isNaN(`an_fraud_shows`), 0, `an_fraud_shows`) + if(isNaN(`mcb_context_ctr`), 0, `mcb_context_ctr`) + if(isNaN(`market_context_cpmh_market_context_partner_wo_nds`), 0, `market_context_cpmh_market_context_partner_wo_nds`) + if(isNaN(`natural_block_winrate`), 0, `natural_block_winrate`) + if(isNaN(`natural_block_shows`), 0, `natural_block_shows`) + if(isNaN(`adblock_block_visibility`), 0, `adblock_block_visibility`) + if(isNaN(`stripe_cpm_all_wo_nds`), 0, `stripe_cpm_all_wo_nds`) + if(isNaN(`natural_block_direct_clicks`), 0, `natural_block_direct_clicks`) + if(isNaN(`direct_context_cpm_direct_context_partner_wo_nds`), 0, `direct_context_cpm_direct_context_partner_wo_nds`) + if(isNaN(`content_block_direct_clicks`), 0, `content_block_direct_clicks`) + if(isNaN(`natural_block_hits_own_adv`), 0, `natural_block_hits_own_adv`) + if(isNaN(`adblock_block_hits`), 0, `adblock_block_hits`) + if(isNaN(`natural_block_bad_win_hits_unsold`), 0, `natural_block_bad_win_hits_unsold`) + if(isNaN(`content_bad_win_price_wo_nds`), 0, `content_bad_win_price_wo_nds`) + if(isNaN(`content_block_direct_shows`), 0, `content_block_direct_shows`) + if(isNaN(`bad_win_partner_price_wo_nds`), 0, `bad_win_partner_price_wo_nds`) + if(isNaN(`content_block_all_hits`), 0, `content_block_all_hits`) + if(isNaN(`adblock_block_cpmh_partner_wo_nds`), 0, `adblock_block_cpmh_partner_wo_nds`) + if(isNaN(`rtb_block_hits`), 0, `rtb_block_hits`) + if(isNaN(`stripe_hits`), 0, `stripe_hits`) + if(isNaN(`mcb_context_all_wo_nds`), 0, `mcb_context_all_wo_nds`) + if(isNaN(`market_context_shows`), 0, `market_context_shows`) + if(isNaN(`natural_block_bad_win_hits_own_adv`), 0, `natural_block_bad_win_hits_own_adv`) + if(isNaN(`market_context_cpc_market_context_partner_wo_nds`), 0, `market_context_cpc_market_context_partner_wo_nds`) + if(isNaN(`natural_bad_win_price_wo_nds`), 0, `natural_bad_win_price_wo_nds`) + if(isNaN(`natural_block_cpm_all_wo_nds`), 0, `natural_block_cpm_all_wo_nds`) + if(isNaN(`mcb_context_clicks`), 0, `mcb_context_clicks`) + if(isNaN(`partner_wo_nds`), 0, `partner_wo_nds`) + if(isNaN(`market_api_context_cpc_market_api_context_partner_wo_nds`), 0, `market_api_context_cpc_market_api_context_partner_wo_nds`) + if(isNaN(`content_partner_wo_nds`), 0, `content_partner_wo_nds`) + if(isNaN(`adblock_partner_wo_nds`), 0, `adblock_partner_wo_nds`) + if(isNaN(`percent_rtb_bad_win_price_rtb_all_wo_nds`), 0, `percent_rtb_bad_win_price_rtb_all_wo_nds`) + if(isNaN(`content_block_shows_own_adv`), 0, `content_block_shows_own_adv`) + if(isNaN(`an_cover_mcb_hits`), 0, `an_cover_mcb_hits`) + if(isNaN(`direct_context_shows`), 0, `direct_context_shows`) + if(isNaN(`direct_context_page_ad_shows`), 0, `direct_context_page_ad_shows`) + if(isNaN(`stripe_cpc_all_wo_nds`), 0, `stripe_cpc_all_wo_nds`) + if(isNaN(`content_block_cpmh_partner_wo_nds`), 0, `content_block_cpmh_partner_wo_nds`) + if(isNaN(`content_block_direct_ctr`), 0, `content_block_direct_ctr`) + if(isNaN(`stripe_ctr`), 0, `stripe_ctr`) + if(isNaN(`content_block_cpm_partner_wo_nds`), 0, `content_block_cpm_partner_wo_nds`) + if(isNaN(`adblock_block_cpm_all_wo_nds`), 0, `adblock_block_cpm_all_wo_nds`) + if(isNaN(`stripe_cpc_partner_wo_nds`), 0, `stripe_cpc_partner_wo_nds`) + if(isNaN(`direct_context_hits`), 0, `direct_context_hits`) + if(isNaN(`stripe_clicks`), 0, `stripe_clicks`) + if(isNaN(`content_block_visibility`), 0, `content_block_visibility`) + if(isNaN(`market_context_all_wo_nds`), 0, `market_context_all_wo_nds`) + if(isNaN(`rtb_block_bad_win_hits_own_adv`), 0, `rtb_block_bad_win_hits_own_adv`) + if(isNaN(`percent_content_bad_win_price_content_all_wo_nds`), 0, `percent_content_bad_win_price_content_all_wo_nds`) + if(isNaN(`content_block_bad_win_hits_own_adv`), 0, `content_block_bad_win_hits_own_adv`) + if(isNaN(`natural_block_visibility`), 0, `natural_block_visibility`) + if(isNaN(`direct_context_clicks`), 0, `direct_context_clicks`) + if(isNaN(`content_block_shows`), 0, `content_block_shows`) + if(isNaN(`market_api_context_all_wo_nds`), 0, `market_api_context_all_wo_nds`) + if(isNaN(`rtb_bad_win_partner_price_wo_nds`), 0, `rtb_bad_win_partner_price_wo_nds`) + if(isNaN(`mcb_context_cpmh_mcb_context_all_wo_nds`), 0, `mcb_context_cpmh_mcb_context_all_wo_nds`) + if(isNaN(`adblock_block_rpm_partner_wo_nds`), 0, `adblock_block_rpm_partner_wo_nds`) + if(isNaN(`rtb_block_cpm_all_wo_nds`), 0, `rtb_block_cpm_all_wo_nds`) + if(isNaN(`market_api_context_cpm_market_api_context_all_wo_nds`), 0, `market_api_context_cpm_market_api_context_all_wo_nds`) + if(isNaN(`rtb_block_visibility`), 0, `rtb_block_visibility`) + if(isNaN(`rtb_block_rpm_all_wo_nds`), 0, `rtb_block_rpm_all_wo_nds`) + if(isNaN(`natural_partner_wo_nds`), 0, `natural_partner_wo_nds`) + if(isNaN(`market_context_clicks`), 0, `market_context_clicks`) + if(isNaN(`natural_block_cover_ratio`), 0, `natural_block_cover_ratio`) + if(isNaN(`adblock_block_cpmh_all_wo_nds`), 0, `adblock_block_cpmh_all_wo_nds`) + if(isNaN(`content_block_cpm_all_wo_nds`), 0, `content_block_cpm_all_wo_nds`) + if(isNaN(`direct_context_ctr`), 0, `direct_context_ctr`) + if(isNaN(`market_context_cpm_market_context_all_wo_nds`), 0, `market_context_cpm_market_context_all_wo_nds`) + if(isNaN(`natural_block_direct_ctr`), 0, `natural_block_direct_ctr`) + if(isNaN(`content_block_cover_ratio`), 0, `content_block_cover_ratio`) + if(isNaN(`direct_context_partner_wo_nds`), 0, `direct_context_partner_wo_nds`) + if(isNaN(`adblock_block_cover_ratio`), 0, `adblock_block_cover_ratio`) + if(isNaN(`stripe_partner_wo_nds`), 0, `stripe_partner_wo_nds`) + if(isNaN(`adblock_block_winrate`), 0, `adblock_block_winrate`) + if(isNaN(`adblock_block_hits_own_adv`), 0, `adblock_block_hits_own_adv`) + if(isNaN(`market_api_context_cpc_market_api_context_all_wo_nds`), 0, `market_api_context_cpc_market_api_context_all_wo_nds`) + if(isNaN(`stripe_cpmh_all_wo_nds`), 0, `stripe_cpmh_all_wo_nds`) + if(isNaN(`direct_context_cpc_direct_context_partner_wo_nds`), 0, `direct_context_cpc_direct_context_partner_wo_nds`) + if(isNaN(`natural_block_bad_shows`), 0, `natural_block_bad_shows`) + if(isNaN(`mcb_context_cpm_mcb_context_all_wo_nds`), 0, `mcb_context_cpm_mcb_context_all_wo_nds`) + if(isNaN(`natural_block_hits_unsold`), 0, `natural_block_hits_unsold`) + if(isNaN(`natural_block_bad_shows_percent`), 0, `natural_block_bad_shows_percent`) + if(isNaN(`direct_context_cpc_direct_context_all_wo_nds`), 0, `direct_context_cpc_direct_context_all_wo_nds`) + if(isNaN(`content_block_bad_shows_own_adv`), 0, `content_block_bad_shows_own_adv`) + if(isNaN(`market_context_cpm_market_context_partner_wo_nds`), 0, `market_context_cpm_market_context_partner_wo_nds`) + if(isNaN(`mcb_context_cpm_mcb_context_partner_wo_nds`), 0, `mcb_context_cpm_mcb_context_partner_wo_nds`) + if(isNaN(`percent_natural_bad_win_partner_price_natural_partner_wo_nds`), 0, `percent_natural_bad_win_partner_price_natural_partner_wo_nds`) + if(isNaN(`direct_ad_reach`), 0, `direct_ad_reach`) + if(isNaN(`rtb_block_bad_shows_percent`), 0, `rtb_block_bad_shows_percent`) + if(isNaN(`mcb_context_partner_wo_nds`), 0, `mcb_context_partner_wo_nds`) + if(isNaN(`content_block_hits`), 0, `content_block_hits`) + if(isNaN(`rtb_block_cover_ratio`), 0, `rtb_block_cover_ratio`) + if(isNaN(`adblock_block_rpm_all_wo_nds`), 0, `adblock_block_rpm_all_wo_nds`) + if(isNaN(`all_wo_nds`), 0, `all_wo_nds`) + if(isNaN(`direct_context_ads`), 0, `direct_context_ads`) + if(isNaN(`rtb_block_bad_win_hits_percent`), 0, `rtb_block_bad_win_hits_percent`) + if(isNaN(`an_rtb_cover_hits`), 0, `an_rtb_cover_hits`) + if(isNaN(`direct_context_all_wo_nds`), 0, `direct_context_all_wo_nds`) + if(isNaN(`natural_block_rpm_all_wo_nds`), 0, `natural_block_rpm_all_wo_nds`) + if(isNaN(`rtb_block_rpm_partner_wo_nds`), 0, `rtb_block_rpm_partner_wo_nds`) + if(isNaN(`content_block_bad_win_hits`), 0, `content_block_bad_win_hits`) + if(isNaN(`an_rtb_cover_senthits`), 0, `an_rtb_cover_senthits`) + if(isNaN(`percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`), 0, `percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`) + if(isNaN(`content_block_hits_own_adv`), 0, `content_block_hits_own_adv`) + if(isNaN(`direct_ad_visibility`), 0, `direct_ad_visibility`) + if(isNaN(`natural_block_bad_shows_own_adv`), 0, `natural_block_bad_shows_own_adv`) + if(isNaN(`natural_block_bad_win_hits_percent`), 0, `natural_block_bad_win_hits_percent`) + if(isNaN(`mcb_context_hits`), 0, `mcb_context_hits`) + if(isNaN(`market_context_cpc_market_context_all_wo_nds`), 0, `market_context_cpc_market_context_all_wo_nds`) + if(isNaN(`natural_block_cpmh_partner_wo_nds`), 0, `natural_block_cpmh_partner_wo_nds`) + if(isNaN(`direct_context_cpmh_direct_context_all_wo_nds`), 0, `direct_context_cpmh_direct_context_all_wo_nds`) + if(isNaN(`natural_all_wo_nds`), 0, `natural_all_wo_nds`) + if(isNaN(`rtb_block_direct_clicks`), 0, `rtb_block_direct_clicks`) + if(isNaN(`mcb_context_shows`), 0, `mcb_context_shows`) + if(isNaN(`rtb_block_winrate`), 0, `rtb_block_winrate`) + if(isNaN(`market_api_context_shows`), 0, `market_api_context_shows`) + if(isNaN(`mcb_context_cpmh_mcb_context_partner_wo_nds`), 0, `mcb_context_cpmh_mcb_context_partner_wo_nds`) + if(isNaN(`content_block_winrate`), 0, `content_block_winrate`) + if(isNaN(`natural_block_all_hits`), 0, `natural_block_all_hits`) + if(isNaN(`rtb_block_bad_win_hits`), 0, `rtb_block_bad_win_hits`) + if(isNaN(`rtb_block_hits_unsold`), 0, `rtb_block_hits_unsold`) + if(isNaN(`rtb_block_bad_win_hits_unsold`), 0, `rtb_block_bad_win_hits_unsold`) + if(isNaN(`content_block_hits_unsold`), 0, `content_block_hits_unsold`) + if(isNaN(`bad_win_price_wo_nds`), 0, `bad_win_price_wo_nds`) + if(isNaN(`rtb_block_hits_own_adv`), 0, `rtb_block_hits_own_adv`) + if(isNaN(`content_bad_win_partner_price_wo_nds`), 0, `content_bad_win_partner_price_wo_nds`) + if(isNaN(`natural_block_shows_own_adv`), 0, `natural_block_shows_own_adv`) + if(isNaN(`natural_block_cpmh_all_wo_nds`), 0, `natural_block_cpmh_all_wo_nds`) + if(isNaN(`an_cover_market_hits`), 0, `an_cover_market_hits`) + if(isNaN(`rtb_block_shows`), 0, `rtb_block_shows`) + if(isNaN(`adblock_block_shows_own_adv`), 0, `adblock_block_shows_own_adv`) + if(isNaN(`content_all_wo_nds`), 0, `content_all_wo_nds`) + if(isNaN(`stripe_cpmh_partner_wo_nds`), 0, `stripe_cpmh_partner_wo_nds`) + if(isNaN(`natural_block_bad_win_hits`), 0, `natural_block_bad_win_hits`) + if(isNaN(`rtb_block_all_hits`), 0, `rtb_block_all_hits`) + if(isNaN(`market_api_context_cpm_market_api_context_partner_wo_nds`), 0, `market_api_context_cpm_market_api_context_partner_wo_nds`) + if(isNaN(`market_api_context_ctr`), 0, `market_api_context_ctr`) + if(isNaN(`rtb_all_wo_nds`), 0, `rtb_all_wo_nds`) + if(isNaN(`rtb_block_shows_own_adv`), 0, `rtb_block_shows_own_adv`) + if(isNaN(`market_api_context_partner_wo_nds`), 0, `market_api_context_partner_wo_nds`) + if(isNaN(`market_context_partner_wo_nds`), 0, `market_context_partner_wo_nds`) + if(isNaN(`content_block_rpm_all_wo_nds`), 0, `content_block_rpm_all_wo_nds`) + if(isNaN(`stripe_cpm_partner_wo_nds`), 0, `stripe_cpm_partner_wo_nds`) + if(isNaN(`rtb_block_bad_shows_own_adv`), 0, `rtb_block_bad_shows_own_adv`) + if(isNaN(`rtb_block_cpmh_all_wo_nds`), 0, `rtb_block_cpmh_all_wo_nds`) + if(isNaN(`rtb_block_cpm_partner_wo_nds`), 0, `rtb_block_cpm_partner_wo_nds`) + if(isNaN(`content_block_bad_win_hits_percent`), 0, `content_block_bad_win_hits_percent`) + if(isNaN(`market_context_hits`), 0, `market_context_hits`) + if(isNaN(`natural_block_rpm_partner_wo_nds`), 0, `natural_block_rpm_partner_wo_nds`) + if(isNaN(`market_context_cpmh_market_context_all_wo_nds`), 0, `market_context_cpmh_market_context_all_wo_nds`)) > 0
) FORMAT JSONCompact
