SELECT
    `_adblock_all_wo_nds` AS `adblock_all_wo_nds`,
    `_adblock_block_all_hits` AS `adblock_block_all_hits`,
    `_adblock_block_cover_ratio` AS `adblock_block_cover_ratio`,
    `_adblock_block_cpm_all_wo_nds` AS `adblock_block_cpm_all_wo_nds`,
    `_adblock_block_cpm_partner_wo_nds` AS `adblock_block_cpm_partner_wo_nds`,
    `_adblock_block_cpmh_all_wo_nds` AS `adblock_block_cpmh_all_wo_nds`,
    `_adblock_block_cpmh_partner_wo_nds` AS `adblock_block_cpmh_partner_wo_nds`,
    `_adblock_block_hits` AS `adblock_block_hits`,
    `_adblock_block_hits_own_adv` AS `adblock_block_hits_own_adv`,
    `_adblock_block_hits_unsold` AS `adblock_block_hits_unsold`,
    `_adblock_block_rpm_all_wo_nds` AS `adblock_block_rpm_all_wo_nds`,
    `_adblock_block_rpm_partner_wo_nds` AS `adblock_block_rpm_partner_wo_nds`,
    `_adblock_block_shows` AS `adblock_block_shows`,
    `_adblock_block_shows_own_adv` AS `adblock_block_shows_own_adv`,
    `_adblock_block_visibility` AS `adblock_block_visibility`,
    `_adblock_block_winrate` AS `adblock_block_winrate`,
    `_adblock_partner_wo_nds` AS `adblock_partner_wo_nds`,
    `_caption` AS `caption`,
    `_context_campaign_caption` AS `context_campaign_caption`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_direct_block` AS `direct_block`,
    `_domain` AS `domain`,
    `_domain_id` AS `domain_id`,
    `_dsp_caption` AS `dsp_caption`,
    `_dsp_id_name` AS `dsp_id_name`,
    `_internal_campaign_id` AS `internal_campaign_id`,
    `_login` AS `login`,
    `_page_id` AS `page_id`,
    `_public_id` AS `public_id`,
    `_tag_caption` AS `tag_caption`,
    `_tag_id` AS `tag_id`
FROM (
    SELECT
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000), 2) AS `_adblock_all_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_adblock') AS `_adblock_block_all_hits`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_adblock')) AS `_adblock_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpmh_partner_wo_nds`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_adblock')), 2) AS `_adblock_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_adblock')), 2) AS `_adblock_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_adblock'
        ))) AS `_adblock_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_adblock'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_adblock'
            )))) AS `_adblock_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000), 2) AS `_adblock_partner_wo_nds`,
        dictGetString('blocks_dict', 'caption', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_caption`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_context_campaign_caption`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetString('blocks_dict', 'direct_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_direct_block`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_domain_id`,
        dictGetStringOrDefault('dsps_dict', 'short_caption', toUInt64(`dsp_id`), concat('DSP #', toString(`dsp_id`))) AS `_dsp_caption`,
        `dsp_id` AS `_dsp_id_name`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_internal_campaign_id`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        `page_id` AS `_page_id`,
        concat(transform(toString(`product_id`), ['context_on_site_adblock'], ['R-AB-']), toString(`page_id`), '-', toString(`block_id`)) AS `_public_id`,
        dictGetStringOrDefault('block_tags_dict', 'caption', tuple(toUInt32(`page_id`), toUInt64(`tag_id`)), concat('Slice #', toString(`tag_id`))) AS `_tag_caption`,
        `tag_id` AS `_tag_id`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('context_on_site_adblock')
        AND (
            `page_id` IN ('page_id__from_table__context_on_site_campaign__with_filter__["AND",[["owner_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"login\\",\\"=\\",\\"mock__login\\"]]]"]]]]')
        )
        AND (
            `page_id` IN ('page_id__from_table__context_on_site_campaign__with_filter__["AND",[["owner_id","= ANY",["id__from_table__users__with_filter__[\\"OR\\",[[\\"is_efir_blogger\\",\\"=\\",1],[\\"is_video_blogger\\",\\"=\\",1],[\\"is_tutby\\",\\"=\\",1],[\\"is_adfox_partner\\",\\"=\\",1],[\\"is_mobile_mediation\\",\\"=\\",1],[\\"is_games\\",\\"=\\",1]]]"]]]]')
        )
        AND (
            `page_id` = 'mock__page_id'
        )
        AND (
            `block_id` = 1
        )
        AND (
            dictGetString('blocks_dict', 'caption', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 'mock__caption'
        )
        AND (
            `page_id` IN ('page_id__from_table__context_on_site_campaign__with_filter__["OR",[["AND",[["domain_id","= ANY",["id__from_table__site__with_filter__[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__page.all_domain\\"]]]"]]]],["AND",[["id","= ANY",["campaign_id__from_table__context_on_site_mirrors__with_filter__[\\"AND\\",[[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__page.all_domain\\"]]],[\\"AND\\",[[\\"multistate\\",\\"=\\",[\\"mock_multistate\\"]]]]]]"]]]]]]')
        )
        AND (
            dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
        AND `dsp_id` = 'mock__dsp_id_name'
        AND `dsp_id` = 'mock__dsp_caption'
        AND `tag_id` = 'mock__tag_id'
        AND `page_id` = 'mock__context_campaign_caption'
    )
    GROUP BY `_caption`, `_context_campaign_caption`, `_currency_id`, `_date`, `_direct_block`, `_domain`, `_domain_id`, `_dsp_caption`, `_dsp_id_name`, `_internal_campaign_id`, `_login`, `_page_id`, `_public_id`, `_tag_caption`, `_tag_id`
) `statistics`
WHERE (
    (if(isNaN(`adblock_block_hits`), 0, `adblock_block_hits`) + if(isNaN(`adblock_block_cpmh_partner_wo_nds`), 0, `adblock_block_cpmh_partner_wo_nds`) + if(isNaN(`adblock_block_all_hits`), 0, `adblock_block_all_hits`) + if(isNaN(`adblock_block_cpm_partner_wo_nds`), 0, `adblock_block_cpm_partner_wo_nds`) + if(isNaN(`adblock_block_cover_ratio`), 0, `adblock_block_cover_ratio`) + if(isNaN(`adblock_block_winrate`), 0, `adblock_block_winrate`) + if(isNaN(`adblock_block_hits_own_adv`), 0, `adblock_block_hits_own_adv`) + if(isNaN(`adblock_partner_wo_nds`), 0, `adblock_partner_wo_nds`) + if(isNaN(`adblock_block_shows_own_adv`), 0, `adblock_block_shows_own_adv`) + if(isNaN(`adblock_block_hits_unsold`), 0, `adblock_block_hits_unsold`) + if(isNaN(`adblock_block_shows`), 0, `adblock_block_shows`) + if(isNaN(`adblock_all_wo_nds`), 0, `adblock_all_wo_nds`) + if(isNaN(`adblock_block_rpm_all_wo_nds`), 0, `adblock_block_rpm_all_wo_nds`) + if(isNaN(`adblock_block_cpm_all_wo_nds`), 0, `adblock_block_cpm_all_wo_nds`) + if(isNaN(`adblock_block_rpm_partner_wo_nds`), 0, `adblock_block_rpm_partner_wo_nds`) + if(isNaN(`adblock_block_visibility`), 0, `adblock_block_visibility`) + if(isNaN(`adblock_block_cpmh_all_wo_nds`), 0, `adblock_block_cpmh_all_wo_nds`)) > 0
) FORMAT JSONCompact
