SELECT
    `_adfox_block` AS `adfox_block`,
    `_campaign_id` AS `campaign_id`,
    `_caption` AS `caption`,
    `_context_campaign_caption` AS `context_campaign_caption`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_domain` AS `domain`,
    `_domain_id` AS `domain_id`,
    `_dsp_caption` AS `dsp_caption`,
    `_dsp_id_name` AS `dsp_id_name`,
    `_internal_campaign_id` AS `internal_campaign_id`,
    `_login` AS `login`,
    `_natural_all_wo_nds` AS `natural_all_wo_nds`,
    `_natural_bad_win_partner_price_wo_nds` AS `natural_bad_win_partner_price_wo_nds`,
    `_natural_bad_win_price_wo_nds` AS `natural_bad_win_price_wo_nds`,
    `_natural_block_all_hits` AS `natural_block_all_hits`,
    `_natural_block_bad_shows` AS `natural_block_bad_shows`,
    `_natural_block_bad_shows_own_adv` AS `natural_block_bad_shows_own_adv`,
    `_natural_block_bad_shows_percent` AS `natural_block_bad_shows_percent`,
    `_natural_block_bad_win_hits` AS `natural_block_bad_win_hits`,
    `_natural_block_bad_win_hits_own_adv` AS `natural_block_bad_win_hits_own_adv`,
    `_natural_block_bad_win_hits_percent` AS `natural_block_bad_win_hits_percent`,
    `_natural_block_bad_win_hits_unsold` AS `natural_block_bad_win_hits_unsold`,
    `_natural_block_cover_ratio` AS `natural_block_cover_ratio`,
    `_natural_block_cpm_all_wo_nds` AS `natural_block_cpm_all_wo_nds`,
    `_natural_block_cpm_partner_wo_nds` AS `natural_block_cpm_partner_wo_nds`,
    `_natural_block_cpmh_all_wo_nds` AS `natural_block_cpmh_all_wo_nds`,
    `_natural_block_cpmh_partner_wo_nds` AS `natural_block_cpmh_partner_wo_nds`,
    `_natural_block_direct_clicks` AS `natural_block_direct_clicks`,
    `_natural_block_direct_ctr` AS `natural_block_direct_ctr`,
    `_natural_block_direct_shows` AS `natural_block_direct_shows`,
    `_natural_block_hits` AS `natural_block_hits`,
    `_natural_block_hits_own_adv` AS `natural_block_hits_own_adv`,
    `_natural_block_hits_unsold` AS `natural_block_hits_unsold`,
    `_natural_block_rpm_all_wo_nds` AS `natural_block_rpm_all_wo_nds`,
    `_natural_block_rpm_partner_wo_nds` AS `natural_block_rpm_partner_wo_nds`,
    `_natural_block_shows` AS `natural_block_shows`,
    `_natural_block_shows_own_adv` AS `natural_block_shows_own_adv`,
    `_natural_block_visibility` AS `natural_block_visibility`,
    `_natural_block_winrate` AS `natural_block_winrate`,
    `_natural_partner_wo_nds` AS `natural_partner_wo_nds`,
    `_percent_natural_bad_win_partner_price_natural_partner_wo_nds` AS `percent_natural_bad_win_partner_price_natural_partner_wo_nds`,
    `_percent_natural_bad_win_price_natural_all_wo_nds` AS `percent_natural_bad_win_price_natural_all_wo_nds`,
    `_public_id` AS `public_id`,
    `_tag_caption` AS `tag_caption`,
    `_tag_id` AS `tag_id`
FROM (
    SELECT
        dictGetUInt8('blocks_dict', 'adfox_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_adfox_block`,
        `page_id` AS `_campaign_id`,
        dictGetString('blocks_dict', 'caption', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_caption`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_context_campaign_caption`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_domain_id`,
        dictGetStringOrDefault('dsps_dict', 'short_caption', toUInt64(`dsp_id`), concat('DSP #', toString(`dsp_id`))) AS `_dsp_caption`,
        `dsp_id` AS `_dsp_id_name`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_internal_campaign_id`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_natural') AS `_natural_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )))) AS `_natural_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )))) AS `_natural_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_natural')) AS `_natural_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'context_on_site_natural')) AS `_natural_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'context_on_site_natural') AS `_natural_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_natural')), 2) AS `_natural_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_natural')), 2) AS `_natural_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_natural'
        ))) AS `_natural_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_natural'
            )))) AS `_natural_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_partner_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural'))) AS `_percent_natural_bad_win_partner_price_natural_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural'))) AS `_percent_natural_bad_win_price_natural_all_wo_nds`,
        concat(transform(toString(`product_id`), ['context_on_site_natural'], ['N-A-']), toString(`page_id`), '-', toString(`block_id`)) AS `_public_id`,
        dictGetStringOrDefault('block_tags_dict', 'caption', tuple(toUInt32(`page_id`), toUInt64(`tag_id`)), concat('Slice #', toString(`tag_id`))) AS `_tag_caption`,
        `tag_id` AS `_tag_id`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('context_on_site_natural')
        AND (
            `page_id` IN ('page_id__from_table__context_on_site_campaign__with_filter__["AND",[["owner_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"login\\",\\"=\\",\\"mock__login\\"]]]"]]]]')
        )
        AND (
            `page_id` IN ('page_id__from_table__context_on_site_campaign__with_filter__["AND",[["owner_id","= ANY",["id__from_table__users__with_filter__[\\"OR\\",[[\\"is_efir_blogger\\",\\"=\\",1],[\\"is_video_blogger\\",\\"=\\",1],[\\"is_tutby\\",\\"=\\",1],[\\"is_adfox_partner\\",\\"=\\",1],[\\"is_mobile_mediation\\",\\"=\\",1],[\\"is_games\\",\\"=\\",1]]]"]]]]')
        )
        AND (
            dictGetUInt8('blocks_dict', 'adfox_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 1
        )
        AND (
            `page_id` = 'mock__campaign_id'
        )
        AND (
            `block_id` = 1
        )
        AND (
            dictGetString('blocks_dict', 'caption', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 'mock__caption'
        )
        AND (
            `page_id` IN ('page_id__from_table__context_on_site_campaign__with_filter__["OR",[["AND",[["domain_id","= ANY",["id__from_table__site__with_filter__[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]]"]]]],["AND",[["id","= ANY",["campaign_id__from_table__context_on_site_mirrors__with_filter__[\\"AND\\",[[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]],[\\"AND\\",[[\\"multistate\\",\\"=\\",[\\"mock_multistate\\"]]]]]]"]]]]]]')
        )
        AND (
            dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) IN ('mock_multistate')
        )
        AND (
            dictGetString('blocks_dict', 'site_version', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) IN ('general', 'turbo', 'turbo_desktop')
        )
        AND (
            dictGetUInt8('blocks_dict', 'adfox_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 1
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
        AND `dsp_id` = 'mock__dsp_id_name'
        AND `dsp_id` = 'mock__dsp_caption'
        AND `tag_id` = 'mock__tag_id'
        AND `page_id` = 'mock__context_campaign_caption'
    )
    GROUP BY `_adfox_block`, `_campaign_id`, `_caption`, `_context_campaign_caption`, `_currency_id`, `_date`, `_domain`, `_domain_id`, `_dsp_caption`, `_dsp_id_name`, `_internal_campaign_id`, `_login`, `_public_id`, `_tag_caption`, `_tag_id`
) `statistics`
WHERE (
    (if(isNaN(`natural_block_cpmh_partner_wo_nds`), 0, `natural_block_cpmh_partner_wo_nds`) + if(isNaN(`natural_all_wo_nds`), 0, `natural_all_wo_nds`) + if(isNaN(`natural_block_hits_own_adv`), 0, `natural_block_hits_own_adv`) + if(isNaN(`natural_block_direct_ctr`), 0, `natural_block_direct_ctr`) + if(isNaN(`natural_block_bad_win_hits_unsold`), 0, `natural_block_bad_win_hits_unsold`) + if(isNaN(`percent_natural_bad_win_price_natural_all_wo_nds`), 0, `percent_natural_bad_win_price_natural_all_wo_nds`) + if(isNaN(`natural_block_bad_win_hits_own_adv`), 0, `natural_block_bad_win_hits_own_adv`) + if(isNaN(`natural_block_all_hits`), 0, `natural_block_all_hits`) + if(isNaN(`natural_block_direct_shows`), 0, `natural_block_direct_shows`) + if(isNaN(`natural_bad_win_price_wo_nds`), 0, `natural_bad_win_price_wo_nds`) + if(isNaN(`natural_block_bad_shows`), 0, `natural_block_bad_shows`) + if(isNaN(`natural_block_cpm_all_wo_nds`), 0, `natural_block_cpm_all_wo_nds`) + if(isNaN(`natural_block_hits`), 0, `natural_block_hits`) + if(isNaN(`natural_block_bad_shows_percent`), 0, `natural_block_bad_shows_percent`) + if(isNaN(`natural_block_hits_unsold`), 0, `natural_block_hits_unsold`) + if(isNaN(`natural_block_shows_own_adv`), 0, `natural_block_shows_own_adv`) + if(isNaN(`natural_block_cpmh_all_wo_nds`), 0, `natural_block_cpmh_all_wo_nds`) + if(isNaN(`natural_block_cpm_partner_wo_nds`), 0, `natural_block_cpm_partner_wo_nds`) + if(isNaN(`percent_natural_bad_win_partner_price_natural_partner_wo_nds`), 0, `percent_natural_bad_win_partner_price_natural_partner_wo_nds`) + if(isNaN(`natural_bad_win_partner_price_wo_nds`), 0, `natural_bad_win_partner_price_wo_nds`) + if(isNaN(`natural_block_bad_win_hits`), 0, `natural_block_bad_win_hits`) + if(isNaN(`natural_block_rpm_all_wo_nds`), 0, `natural_block_rpm_all_wo_nds`) + if(isNaN(`natural_block_visibility`), 0, `natural_block_visibility`) + if(isNaN(`natural_block_winrate`), 0, `natural_block_winrate`) + if(isNaN(`natural_block_rpm_partner_wo_nds`), 0, `natural_block_rpm_partner_wo_nds`) + if(isNaN(`natural_partner_wo_nds`), 0, `natural_partner_wo_nds`) + if(isNaN(`natural_block_shows`), 0, `natural_block_shows`) + if(isNaN(`natural_block_bad_shows_own_adv`), 0, `natural_block_bad_shows_own_adv`) + if(isNaN(`natural_block_cover_ratio`), 0, `natural_block_cover_ratio`) + if(isNaN(`natural_block_bad_win_hits_percent`), 0, `natural_block_bad_win_hits_percent`) + if(isNaN(`natural_block_direct_clicks`), 0, `natural_block_direct_clicks`)) > 0
) FORMAT JSONCompact
