SELECT
    `_all_wo_nds` AS `all_wo_nds`,
    `_caption` AS `caption`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_direct_search_ads` AS `direct_search_ads`,
    `_direct_search_all_wo_nds` AS `direct_search_all_wo_nds`,
    `_direct_search_clicks` AS `direct_search_clicks`,
    `_direct_search_cpc_direct_search_all_wo_nds` AS `direct_search_cpc_direct_search_all_wo_nds`,
    `_direct_search_cpc_direct_search_partner_wo_nds` AS `direct_search_cpc_direct_search_partner_wo_nds`,
    `_direct_search_cpm_direct_search_all_wo_nds` AS `direct_search_cpm_direct_search_all_wo_nds`,
    `_direct_search_cpm_direct_search_partner_wo_nds` AS `direct_search_cpm_direct_search_partner_wo_nds`,
    `_direct_search_cpmh_direct_search_all_wo_nds` AS `direct_search_cpmh_direct_search_all_wo_nds`,
    `_direct_search_cpmh_direct_search_partner_wo_nds` AS `direct_search_cpmh_direct_search_partner_wo_nds`,
    `_direct_search_ctr` AS `direct_search_ctr`,
    `_direct_search_hits` AS `direct_search_hits`,
    `_direct_search_page_ad_shows` AS `direct_search_page_ad_shows`,
    `_direct_search_partner_wo_nds` AS `direct_search_partner_wo_nds`,
    `_direct_search_shows` AS `direct_search_shows`,
    `_domain` AS `domain`,
    `_domain_id` AS `domain_id`,
    `_id` AS `id`,
    `_login` AS `login`,
    `_market_api_search_all_wo_nds` AS `market_api_search_all_wo_nds`,
    `_market_api_search_clicks` AS `market_api_search_clicks`,
    `_market_api_search_cpc_market_api_search_all_wo_nds` AS `market_api_search_cpc_market_api_search_all_wo_nds`,
    `_market_api_search_cpc_market_api_search_partner_wo_nds` AS `market_api_search_cpc_market_api_search_partner_wo_nds`,
    `_market_api_search_cpm_market_api_search_all_wo_nds` AS `market_api_search_cpm_market_api_search_all_wo_nds`,
    `_market_api_search_cpm_market_api_search_partner_wo_nds` AS `market_api_search_cpm_market_api_search_partner_wo_nds`,
    `_market_api_search_ctr` AS `market_api_search_ctr`,
    `_market_api_search_partner_wo_nds` AS `market_api_search_partner_wo_nds`,
    `_market_api_search_shows` AS `market_api_search_shows`,
    `_market_search_all_wo_nds` AS `market_search_all_wo_nds`,
    `_market_search_clicks` AS `market_search_clicks`,
    `_market_search_cpc_market_search_all_wo_nds` AS `market_search_cpc_market_search_all_wo_nds`,
    `_market_search_cpc_market_search_partner_wo_nds` AS `market_search_cpc_market_search_partner_wo_nds`,
    `_market_search_cpm_market_search_all_wo_nds` AS `market_search_cpm_market_search_all_wo_nds`,
    `_market_search_cpm_market_search_partner_wo_nds` AS `market_search_cpm_market_search_partner_wo_nds`,
    `_market_search_cpmh_market_search_all_wo_nds` AS `market_search_cpmh_market_search_all_wo_nds`,
    `_market_search_cpmh_market_search_partner_wo_nds` AS `market_search_cpmh_market_search_partner_wo_nds`,
    `_market_search_ctr` AS `market_search_ctr`,
    `_market_search_hits` AS `market_search_hits`,
    `_market_search_partner_wo_nds` AS `market_search_partner_wo_nds`,
    `_market_search_shows` AS `market_search_shows`,
    `_mcb_search_all_wo_nds` AS `mcb_search_all_wo_nds`,
    `_mcb_search_clicks` AS `mcb_search_clicks`,
    `_mcb_search_cpm_mcb_search_all_wo_nds` AS `mcb_search_cpm_mcb_search_all_wo_nds`,
    `_mcb_search_cpm_mcb_search_partner_wo_nds` AS `mcb_search_cpm_mcb_search_partner_wo_nds`,
    `_mcb_search_cpmh_mcb_search_all_wo_nds` AS `mcb_search_cpmh_mcb_search_all_wo_nds`,
    `_mcb_search_cpmh_mcb_search_partner_wo_nds` AS `mcb_search_cpmh_mcb_search_partner_wo_nds`,
    `_mcb_search_ctr` AS `mcb_search_ctr`,
    `_mcb_search_hits` AS `mcb_search_hits`,
    `_mcb_search_partner_wo_nds` AS `mcb_search_partner_wo_nds`,
    `_mcb_search_shows` AS `mcb_search_shows`,
    `_page_id` AS `page_id`,
    `_partner_wo_nds` AS `partner_wo_nds`,
    `_premium_ads` AS `premium_ads`,
    `_premium_all_wo_nds` AS `premium_all_wo_nds`,
    `_premium_clicks` AS `premium_clicks`,
    `_premium_cpc_all_wo_nds` AS `premium_cpc_all_wo_nds`,
    `_premium_cpc_partner_wo_nds` AS `premium_cpc_partner_wo_nds`,
    `_premium_cpm_all_wo_nds` AS `premium_cpm_all_wo_nds`,
    `_premium_cpm_partner_wo_nds` AS `premium_cpm_partner_wo_nds`,
    `_premium_cpmh_all_wo_nds` AS `premium_cpmh_all_wo_nds`,
    `_premium_cpmh_partner_wo_nds` AS `premium_cpmh_partner_wo_nds`,
    `_premium_ctr` AS `premium_ctr`,
    `_premium_hits` AS `premium_hits`,
    `_premium_page_ad_shows` AS `premium_page_ad_shows`,
    `_premium_partner_wo_nds` AS `premium_partner_wo_nds`,
    `_premium_shows` AS `premium_shows`
FROM (
    SELECT
        round((SUM((`all_wo_nds` / 1000)) / 10000000), 2) AS `_all_wo_nds`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_caption`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        (sumIf(`shows`, `product_id` = 'search_on_site_direct') / sumIf(`direct_page_ad_shows`, `product_id` = 'search_on_site_campaign')) AS `_direct_search_ads`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000), 2) AS `_direct_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_direct') AS `_direct_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpc_direct_search_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpc_direct_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpm_direct_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpm_direct_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) * 1000) / sumIf(`direct_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_direct_search_cpmh_direct_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) * 1000) / sumIf(`direct_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_direct_search_cpmh_direct_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_direct') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_direct')) AS `_direct_search_ctr`,
        sumIf(`direct_hits`, `product_id` = 'search_on_site_campaign') AS `_direct_search_hits`,
        sumIf(`direct_page_ad_shows`, `product_id` = 'search_on_site_campaign') AS `_direct_search_page_ad_shows`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000), 2) AS `_direct_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_direct') AS `_direct_search_shows`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_domain_id`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_id`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000), 2) AS `_market_api_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_market_api') AS `_market_api_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpc_market_api_search_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpc_market_api_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpm_market_api_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpm_market_api_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_market_api') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_market_api')) AS `_market_api_search_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000), 2) AS `_market_api_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_market_api') AS `_market_api_search_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000), 2) AS `_market_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_market') AS `_market_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpc_market_search_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpc_market_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpm_market_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpm_market_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`market_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_market_search_cpmh_market_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`market_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_market_search_cpmh_market_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_market') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_market')) AS `_market_search_ctr`,
        sumIf(`market_hits`, `product_id` = 'search_on_site_campaign') AS `_market_search_hits`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000), 2) AS `_market_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_market') AS `_market_search_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000), 2) AS `_mcb_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_mcb') AS `_mcb_search_clicks`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_mcb')), 2) AS `_mcb_search_cpm_mcb_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_mcb')), 2) AS `_mcb_search_cpm_mcb_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000) * 1000) / sumIf(`mcb_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_mcb_search_cpmh_mcb_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000) * 1000) / sumIf(`mcb_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_mcb_search_cpmh_mcb_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_mcb') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_mcb')) AS `_mcb_search_ctr`,
        sumIf(`mcb_hits`, `product_id` = 'search_on_site_campaign') AS `_mcb_search_hits`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000), 2) AS `_mcb_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_mcb') AS `_mcb_search_shows`,
        `page_id` AS `_page_id`,
        round((SUM((`partner_wo_nds` / 1000)) / 10000000), 2) AS `_partner_wo_nds`,
        (sumIf(`shows`, `product_id` = 'search_on_site_premium') / sumIf(`premium_page_ad_shows`, `product_id` = 'search_on_site_campaign')) AS `_premium_ads`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000), 2) AS `_premium_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_premium') AS `_premium_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpc_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpc_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) * 1000) / sumIf(`premium_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_premium_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) * 1000) / sumIf(`premium_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_premium_cpmh_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_premium') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_premium')) AS `_premium_ctr`,
        sumIf(`premium_hits`, `product_id` = 'search_on_site_campaign') AS `_premium_hits`,
        sumIf(`premium_page_ad_shows`, `product_id` = 'search_on_site_campaign') AS `_premium_page_ad_shows`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000), 2) AS `_premium_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_premium') AS `_premium_shows`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('search_on_site_campaign', 'search_on_site_premium', 'search_on_site_direct', 'search_on_site_mcb', 'search_on_site_market', 'search_on_site_market_api')
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["AND",[["login","=","mock__owner-login"]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["OR",[["is_efir_blogger","=",1],["is_video_blogger","=",1],["is_tutby","=",1],["is_adfox_partner","=",1],["is_mobile_mediation","=",1],["is_games","=",1]]]')
        )
        AND (
            `page_id` = 'mock__page_id'
        )
        AND (
            dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) = 'mock__caption'
        )
        AND (
            dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) IN ('id__from_table__site__with_filter__["AND",[["domain","=","mock__domain.domain"]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'multistate', toUInt64(`page_id`)) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
    )
    GROUP BY `_caption`, `_currency_id`, `_date`, `_domain`, `_domain_id`, `_id`, `_login`, `_page_id`
) `statistics`
WHERE (
    (if(isNaN(`market_search_hits`), 0, `market_search_hits`) + if(isNaN(`direct_search_cpc_direct_search_partner_wo_nds`), 0, `direct_search_cpc_direct_search_partner_wo_nds`) + if(isNaN(`direct_search_cpc_direct_search_all_wo_nds`), 0, `direct_search_cpc_direct_search_all_wo_nds`) + if(isNaN(`market_search_partner_wo_nds`), 0, `market_search_partner_wo_nds`) + if(isNaN(`mcb_search_cpmh_mcb_search_partner_wo_nds`), 0, `mcb_search_cpmh_mcb_search_partner_wo_nds`) + if(isNaN(`direct_search_ads`), 0, `direct_search_ads`) + if(isNaN(`market_search_shows`), 0, `market_search_shows`) + if(isNaN(`premium_clicks`), 0, `premium_clicks`) + if(isNaN(`direct_search_hits`), 0, `direct_search_hits`) + if(isNaN(`premium_cpmh_partner_wo_nds`), 0, `premium_cpmh_partner_wo_nds`) + if(isNaN(`market_search_all_wo_nds`), 0, `market_search_all_wo_nds`) + if(isNaN(`direct_search_cpm_direct_search_partner_wo_nds`), 0, `direct_search_cpm_direct_search_partner_wo_nds`) + if(isNaN(`mcb_search_all_wo_nds`), 0, `mcb_search_all_wo_nds`) + if(isNaN(`premium_cpm_all_wo_nds`), 0, `premium_cpm_all_wo_nds`) + if(isNaN(`direct_search_partner_wo_nds`), 0, `direct_search_partner_wo_nds`) + if(isNaN(`direct_search_cpmh_direct_search_all_wo_nds`), 0, `direct_search_cpmh_direct_search_all_wo_nds`) + if(isNaN(`mcb_search_cpm_mcb_search_partner_wo_nds`), 0, `mcb_search_cpm_mcb_search_partner_wo_nds`) + if(isNaN(`all_wo_nds`), 0, `all_wo_nds`) + if(isNaN(`premium_all_wo_nds`), 0, `premium_all_wo_nds`) + if(isNaN(`mcb_search_cpmh_mcb_search_all_wo_nds`), 0, `mcb_search_cpmh_mcb_search_all_wo_nds`) + if(isNaN(`market_search_ctr`), 0, `market_search_ctr`) + if(isNaN(`direct_search_page_ad_shows`), 0, `direct_search_page_ad_shows`) + if(isNaN(`market_api_search_clicks`), 0, `market_api_search_clicks`) + if(isNaN(`market_search_clicks`), 0, `market_search_clicks`) + if(isNaN(`mcb_search_shows`), 0, `mcb_search_shows`) + if(isNaN(`premium_cpc_all_wo_nds`), 0, `premium_cpc_all_wo_nds`) + if(isNaN(`premium_cpc_partner_wo_nds`), 0, `premium_cpc_partner_wo_nds`) + if(isNaN(`market_api_search_cpm_market_api_search_all_wo_nds`), 0, `market_api_search_cpm_market_api_search_all_wo_nds`) + if(isNaN(`premium_hits`), 0, `premium_hits`) + if(isNaN(`premium_cpm_partner_wo_nds`), 0, `premium_cpm_partner_wo_nds`) + if(isNaN(`market_search_cpc_market_search_all_wo_nds`), 0, `market_search_cpc_market_search_all_wo_nds`) + if(isNaN(`direct_search_cpm_direct_search_all_wo_nds`), 0, `direct_search_cpm_direct_search_all_wo_nds`) + if(isNaN(`market_search_cpmh_market_search_all_wo_nds`), 0, `market_search_cpmh_market_search_all_wo_nds`) + if(isNaN(`mcb_search_ctr`), 0, `mcb_search_ctr`) + if(isNaN(`direct_search_shows`), 0, `direct_search_shows`) + if(isNaN(`partner_wo_nds`), 0, `partner_wo_nds`) + if(isNaN(`mcb_search_hits`), 0, `mcb_search_hits`) + if(isNaN(`market_search_cpc_market_search_partner_wo_nds`), 0, `market_search_cpc_market_search_partner_wo_nds`) + if(isNaN(`market_api_search_ctr`), 0, `market_api_search_ctr`) + if(isNaN(`premium_ctr`), 0, `premium_ctr`) + if(isNaN(`direct_search_cpmh_direct_search_partner_wo_nds`), 0, `direct_search_cpmh_direct_search_partner_wo_nds`) + if(isNaN(`premium_page_ad_shows`), 0, `premium_page_ad_shows`) + if(isNaN(`direct_search_all_wo_nds`), 0, `direct_search_all_wo_nds`) + if(isNaN(`market_api_search_cpc_market_api_search_partner_wo_nds`), 0, `market_api_search_cpc_market_api_search_partner_wo_nds`) + if(isNaN(`mcb_search_cpm_mcb_search_all_wo_nds`), 0, `mcb_search_cpm_mcb_search_all_wo_nds`) + if(isNaN(`mcb_search_clicks`), 0, `mcb_search_clicks`) + if(isNaN(`premium_partner_wo_nds`), 0, `premium_partner_wo_nds`) + if(isNaN(`market_api_search_cpc_market_api_search_all_wo_nds`), 0, `market_api_search_cpc_market_api_search_all_wo_nds`) + if(isNaN(`direct_search_clicks`), 0, `direct_search_clicks`) + if(isNaN(`market_api_search_partner_wo_nds`), 0, `market_api_search_partner_wo_nds`) + if(isNaN(`mcb_search_partner_wo_nds`), 0, `mcb_search_partner_wo_nds`) + if(isNaN(`market_search_cpmh_market_search_partner_wo_nds`), 0, `market_search_cpmh_market_search_partner_wo_nds`) + if(isNaN(`market_api_search_shows`), 0, `market_api_search_shows`) + if(isNaN(`premium_shows`), 0, `premium_shows`) + if(isNaN(`premium_cpmh_all_wo_nds`), 0, `premium_cpmh_all_wo_nds`) + if(isNaN(`market_search_cpm_market_search_partner_wo_nds`), 0, `market_search_cpm_market_search_partner_wo_nds`) + if(isNaN(`market_search_cpm_market_search_all_wo_nds`), 0, `market_search_cpm_market_search_all_wo_nds`) + if(isNaN(`direct_search_ctr`), 0, `direct_search_ctr`) + if(isNaN(`market_api_search_all_wo_nds`), 0, `market_api_search_all_wo_nds`) + if(isNaN(`premium_ads`), 0, `premium_ads`) + if(isNaN(`market_api_search_cpm_market_api_search_partner_wo_nds`), 0, `market_api_search_cpm_market_api_search_partner_wo_nds`)) > 0
) FORMAT JSONCompact

SELECT
    `_all_wo_nds` AS `all_wo_nds`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_direct_search_all_wo_nds` AS `direct_search_all_wo_nds`,
    `_direct_search_clicks` AS `direct_search_clicks`,
    `_direct_search_cpc_direct_search_all_wo_nds` AS `direct_search_cpc_direct_search_all_wo_nds`,
    `_direct_search_cpc_direct_search_partner_wo_nds` AS `direct_search_cpc_direct_search_partner_wo_nds`,
    `_direct_search_cpm_direct_search_all_wo_nds` AS `direct_search_cpm_direct_search_all_wo_nds`,
    `_direct_search_cpm_direct_search_partner_wo_nds` AS `direct_search_cpm_direct_search_partner_wo_nds`,
    `_direct_search_ctr` AS `direct_search_ctr`,
    `_direct_search_partner_wo_nds` AS `direct_search_partner_wo_nds`,
    `_direct_search_shows` AS `direct_search_shows`,
    `_domain` AS `domain`,
    `_domain_id` AS `domain_id`,
    `_id` AS `id`,
    `_login` AS `login`,
    `_market_api_search_all_wo_nds` AS `market_api_search_all_wo_nds`,
    `_market_api_search_clicks` AS `market_api_search_clicks`,
    `_market_api_search_cpc_market_api_search_all_wo_nds` AS `market_api_search_cpc_market_api_search_all_wo_nds`,
    `_market_api_search_cpc_market_api_search_partner_wo_nds` AS `market_api_search_cpc_market_api_search_partner_wo_nds`,
    `_market_api_search_cpm_market_api_search_all_wo_nds` AS `market_api_search_cpm_market_api_search_all_wo_nds`,
    `_market_api_search_cpm_market_api_search_partner_wo_nds` AS `market_api_search_cpm_market_api_search_partner_wo_nds`,
    `_market_api_search_ctr` AS `market_api_search_ctr`,
    `_market_api_search_partner_wo_nds` AS `market_api_search_partner_wo_nds`,
    `_market_api_search_shows` AS `market_api_search_shows`,
    `_market_search_all_wo_nds` AS `market_search_all_wo_nds`,
    `_market_search_clicks` AS `market_search_clicks`,
    `_market_search_cpc_market_search_all_wo_nds` AS `market_search_cpc_market_search_all_wo_nds`,
    `_market_search_cpc_market_search_partner_wo_nds` AS `market_search_cpc_market_search_partner_wo_nds`,
    `_market_search_cpm_market_search_all_wo_nds` AS `market_search_cpm_market_search_all_wo_nds`,
    `_market_search_cpm_market_search_partner_wo_nds` AS `market_search_cpm_market_search_partner_wo_nds`,
    `_market_search_ctr` AS `market_search_ctr`,
    `_market_search_partner_wo_nds` AS `market_search_partner_wo_nds`,
    `_market_search_shows` AS `market_search_shows`,
    `_mcb_search_all_wo_nds` AS `mcb_search_all_wo_nds`,
    `_mcb_search_clicks` AS `mcb_search_clicks`,
    `_mcb_search_cpm_mcb_search_all_wo_nds` AS `mcb_search_cpm_mcb_search_all_wo_nds`,
    `_mcb_search_cpm_mcb_search_partner_wo_nds` AS `mcb_search_cpm_mcb_search_partner_wo_nds`,
    `_mcb_search_ctr` AS `mcb_search_ctr`,
    `_mcb_search_partner_wo_nds` AS `mcb_search_partner_wo_nds`,
    `_mcb_search_shows` AS `mcb_search_shows`,
    `_page_id` AS `page_id`,
    `_partner_wo_nds` AS `partner_wo_nds`,
    `_premium_all_wo_nds` AS `premium_all_wo_nds`,
    `_premium_clicks` AS `premium_clicks`,
    `_premium_cpc_all_wo_nds` AS `premium_cpc_all_wo_nds`,
    `_premium_cpc_partner_wo_nds` AS `premium_cpc_partner_wo_nds`,
    `_premium_cpm_all_wo_nds` AS `premium_cpm_all_wo_nds`,
    `_premium_cpm_partner_wo_nds` AS `premium_cpm_partner_wo_nds`,
    `_premium_ctr` AS `premium_ctr`,
    `_premium_partner_wo_nds` AS `premium_partner_wo_nds`,
    `_premium_shows` AS `premium_shows`,
    `_public_id` AS `public_id`
FROM (
    SELECT
        round((SUM((`all_wo_nds` / 1000)) / 10000000), 2) AS `_all_wo_nds`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000), 2) AS `_direct_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_direct') AS `_direct_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpc_direct_search_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpc_direct_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpm_direct_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpm_direct_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_direct') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_direct')) AS `_direct_search_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000), 2) AS `_direct_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_direct') AS `_direct_search_shows`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_domain_id`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_id`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000), 2) AS `_market_api_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_market_api') AS `_market_api_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpc_market_api_search_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpc_market_api_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpm_market_api_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpm_market_api_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_market_api') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_market_api')) AS `_market_api_search_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000), 2) AS `_market_api_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_market_api') AS `_market_api_search_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000), 2) AS `_market_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_market') AS `_market_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpc_market_search_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpc_market_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpm_market_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpm_market_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_market') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_market')) AS `_market_search_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000), 2) AS `_market_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_market') AS `_market_search_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000), 2) AS `_mcb_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_mcb') AS `_mcb_search_clicks`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_mcb')), 2) AS `_mcb_search_cpm_mcb_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_mcb')), 2) AS `_mcb_search_cpm_mcb_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_mcb') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_mcb')) AS `_mcb_search_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000), 2) AS `_mcb_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_mcb') AS `_mcb_search_shows`,
        `page_id` AS `_page_id`,
        round((SUM((`partner_wo_nds` / 1000)) / 10000000), 2) AS `_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000), 2) AS `_premium_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_premium') AS `_premium_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpc_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpc_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpm_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_premium') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_premium')) AS `_premium_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000), 2) AS `_premium_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_premium') AS `_premium_shows`,
        concat(transform(toString(`product_id`), ['search_on_site_direct', 'search_on_site_market', 'search_on_site_market_api', 'search_on_site_mcb', 'search_on_site_premium'], ['D-A-', 'M-A-', 'MA-A-', 'C-A-', 'P-A-']), toString(`page_id`), '-', toString(`block_id`)) AS `_public_id`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('search_on_site_premium', 'search_on_site_direct', 'search_on_site_mcb', 'search_on_site_market', 'search_on_site_market_api')
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["AND",[["login","=","mock__owner-login"]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["OR",[["is_efir_blogger","=",1],["is_video_blogger","=",1],["is_tutby","=",1],["is_adfox_partner","=",1],["is_mobile_mediation","=",1],["is_games","=",1]]]')
        )
        AND (
            `page_id` = 'mock__page_id'
        )
        AND (
            dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) IN ('id__from_table__site__with_filter__["AND",[["domain","=","mock__domain.domain"]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'multistate', toUInt64(`page_id`)) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
    )
    GROUP BY `_currency_id`, `_date`, `_domain`, `_domain_id`, `_id`, `_login`, `_page_id`, `_public_id`
) `statistics`
WHERE (
    (if(isNaN(`premium_cpm_partner_wo_nds`), 0, `premium_cpm_partner_wo_nds`) + if(isNaN(`direct_search_cpc_direct_search_partner_wo_nds`), 0, `direct_search_cpc_direct_search_partner_wo_nds`) + if(isNaN(`direct_search_cpc_direct_search_all_wo_nds`), 0, `direct_search_cpc_direct_search_all_wo_nds`) + if(isNaN(`direct_search_cpm_direct_search_all_wo_nds`), 0, `direct_search_cpm_direct_search_all_wo_nds`) + if(isNaN(`market_search_cpc_market_search_all_wo_nds`), 0, `market_search_cpc_market_search_all_wo_nds`) + if(isNaN(`market_search_partner_wo_nds`), 0, `market_search_partner_wo_nds`) + if(isNaN(`market_search_shows`), 0, `market_search_shows`) + if(isNaN(`mcb_search_ctr`), 0, `mcb_search_ctr`) + if(isNaN(`premium_clicks`), 0, `premium_clicks`) + if(isNaN(`direct_search_shows`), 0, `direct_search_shows`) + if(isNaN(`market_search_all_wo_nds`), 0, `market_search_all_wo_nds`) + if(isNaN(`direct_search_cpm_direct_search_partner_wo_nds`), 0, `direct_search_cpm_direct_search_partner_wo_nds`) + if(isNaN(`mcb_search_all_wo_nds`), 0, `mcb_search_all_wo_nds`) + if(isNaN(`partner_wo_nds`), 0, `partner_wo_nds`) + if(isNaN(`premium_cpm_all_wo_nds`), 0, `premium_cpm_all_wo_nds`) + if(isNaN(`direct_search_partner_wo_nds`), 0, `direct_search_partner_wo_nds`) + if(isNaN(`market_api_search_ctr`), 0, `market_api_search_ctr`) + if(isNaN(`market_search_cpc_market_search_partner_wo_nds`), 0, `market_search_cpc_market_search_partner_wo_nds`) + if(isNaN(`premium_ctr`), 0, `premium_ctr`) + if(isNaN(`mcb_search_cpm_mcb_search_partner_wo_nds`), 0, `mcb_search_cpm_mcb_search_partner_wo_nds`) + if(isNaN(`direct_search_all_wo_nds`), 0, `direct_search_all_wo_nds`) + if(isNaN(`market_api_search_cpc_market_api_search_partner_wo_nds`), 0, `market_api_search_cpc_market_api_search_partner_wo_nds`) + if(isNaN(`mcb_search_cpm_mcb_search_all_wo_nds`), 0, `mcb_search_cpm_mcb_search_all_wo_nds`) + if(isNaN(`mcb_search_clicks`), 0, `mcb_search_clicks`) + if(isNaN(`premium_partner_wo_nds`), 0, `premium_partner_wo_nds`) + if(isNaN(`all_wo_nds`), 0, `all_wo_nds`) + if(isNaN(`premium_all_wo_nds`), 0, `premium_all_wo_nds`) + if(isNaN(`market_api_search_cpc_market_api_search_all_wo_nds`), 0, `market_api_search_cpc_market_api_search_all_wo_nds`) + if(isNaN(`direct_search_clicks`), 0, `direct_search_clicks`) + if(isNaN(`market_api_search_partner_wo_nds`), 0, `market_api_search_partner_wo_nds`) + if(isNaN(`mcb_search_partner_wo_nds`), 0, `mcb_search_partner_wo_nds`) + if(isNaN(`market_search_ctr`), 0, `market_search_ctr`) + if(isNaN(`premium_shows`), 0, `premium_shows`) + if(isNaN(`market_api_search_shows`), 0, `market_api_search_shows`) + if(isNaN(`market_search_clicks`), 0, `market_search_clicks`) + if(isNaN(`market_api_search_clicks`), 0, `market_api_search_clicks`) + if(isNaN(`market_search_cpm_market_search_partner_wo_nds`), 0, `market_search_cpm_market_search_partner_wo_nds`) + if(isNaN(`market_search_cpm_market_search_all_wo_nds`), 0, `market_search_cpm_market_search_all_wo_nds`) + if(isNaN(`mcb_search_shows`), 0, `mcb_search_shows`) + if(isNaN(`direct_search_ctr`), 0, `direct_search_ctr`) + if(isNaN(`market_api_search_all_wo_nds`), 0, `market_api_search_all_wo_nds`) + if(isNaN(`premium_cpc_all_wo_nds`), 0, `premium_cpc_all_wo_nds`) + if(isNaN(`market_api_search_cpm_market_api_search_partner_wo_nds`), 0, `market_api_search_cpm_market_api_search_partner_wo_nds`) + if(isNaN(`premium_cpc_partner_wo_nds`), 0, `premium_cpc_partner_wo_nds`) + if(isNaN(`market_api_search_cpm_market_api_search_all_wo_nds`), 0, `market_api_search_cpm_market_api_search_all_wo_nds`)) > 0
) FORMAT JSONCompact

SELECT
    `_all_wo_nds` AS `all_wo_nds`,
    `_caption` AS `caption`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_direct_search_ads` AS `direct_search_ads`,
    `_direct_search_all_wo_nds` AS `direct_search_all_wo_nds`,
    `_direct_search_clicks` AS `direct_search_clicks`,
    `_direct_search_cpc_direct_search_all_wo_nds` AS `direct_search_cpc_direct_search_all_wo_nds`,
    `_direct_search_cpc_direct_search_partner_wo_nds` AS `direct_search_cpc_direct_search_partner_wo_nds`,
    `_direct_search_cpm_direct_search_all_wo_nds` AS `direct_search_cpm_direct_search_all_wo_nds`,
    `_direct_search_cpm_direct_search_partner_wo_nds` AS `direct_search_cpm_direct_search_partner_wo_nds`,
    `_direct_search_cpmh_direct_search_all_wo_nds` AS `direct_search_cpmh_direct_search_all_wo_nds`,
    `_direct_search_cpmh_direct_search_partner_wo_nds` AS `direct_search_cpmh_direct_search_partner_wo_nds`,
    `_direct_search_ctr` AS `direct_search_ctr`,
    `_direct_search_hits` AS `direct_search_hits`,
    `_direct_search_page_ad_shows` AS `direct_search_page_ad_shows`,
    `_direct_search_partner_wo_nds` AS `direct_search_partner_wo_nds`,
    `_direct_search_shows` AS `direct_search_shows`,
    `_domain` AS `domain`,
    `_domain_id` AS `domain_id`,
    `_id` AS `id`,
    `_login` AS `login`,
    `_market_api_search_all_wo_nds` AS `market_api_search_all_wo_nds`,
    `_market_api_search_clicks` AS `market_api_search_clicks`,
    `_market_api_search_cpc_market_api_search_all_wo_nds` AS `market_api_search_cpc_market_api_search_all_wo_nds`,
    `_market_api_search_cpc_market_api_search_partner_wo_nds` AS `market_api_search_cpc_market_api_search_partner_wo_nds`,
    `_market_api_search_cpm_market_api_search_all_wo_nds` AS `market_api_search_cpm_market_api_search_all_wo_nds`,
    `_market_api_search_cpm_market_api_search_partner_wo_nds` AS `market_api_search_cpm_market_api_search_partner_wo_nds`,
    `_market_api_search_ctr` AS `market_api_search_ctr`,
    `_market_api_search_partner_wo_nds` AS `market_api_search_partner_wo_nds`,
    `_market_api_search_shows` AS `market_api_search_shows`,
    `_market_search_all_wo_nds` AS `market_search_all_wo_nds`,
    `_market_search_clicks` AS `market_search_clicks`,
    `_market_search_cpc_market_search_all_wo_nds` AS `market_search_cpc_market_search_all_wo_nds`,
    `_market_search_cpc_market_search_partner_wo_nds` AS `market_search_cpc_market_search_partner_wo_nds`,
    `_market_search_cpm_market_search_all_wo_nds` AS `market_search_cpm_market_search_all_wo_nds`,
    `_market_search_cpm_market_search_partner_wo_nds` AS `market_search_cpm_market_search_partner_wo_nds`,
    `_market_search_cpmh_market_search_all_wo_nds` AS `market_search_cpmh_market_search_all_wo_nds`,
    `_market_search_cpmh_market_search_partner_wo_nds` AS `market_search_cpmh_market_search_partner_wo_nds`,
    `_market_search_ctr` AS `market_search_ctr`,
    `_market_search_hits` AS `market_search_hits`,
    `_market_search_partner_wo_nds` AS `market_search_partner_wo_nds`,
    `_market_search_shows` AS `market_search_shows`,
    `_mcb_search_all_wo_nds` AS `mcb_search_all_wo_nds`,
    `_mcb_search_clicks` AS `mcb_search_clicks`,
    `_mcb_search_cpm_mcb_search_all_wo_nds` AS `mcb_search_cpm_mcb_search_all_wo_nds`,
    `_mcb_search_cpm_mcb_search_partner_wo_nds` AS `mcb_search_cpm_mcb_search_partner_wo_nds`,
    `_mcb_search_cpmh_mcb_search_all_wo_nds` AS `mcb_search_cpmh_mcb_search_all_wo_nds`,
    `_mcb_search_cpmh_mcb_search_partner_wo_nds` AS `mcb_search_cpmh_mcb_search_partner_wo_nds`,
    `_mcb_search_ctr` AS `mcb_search_ctr`,
    `_mcb_search_hits` AS `mcb_search_hits`,
    `_mcb_search_partner_wo_nds` AS `mcb_search_partner_wo_nds`,
    `_mcb_search_shows` AS `mcb_search_shows`,
    `_page_id` AS `page_id`,
    `_partner_wo_nds` AS `partner_wo_nds`,
    `_premium_ads` AS `premium_ads`,
    `_premium_all_wo_nds` AS `premium_all_wo_nds`,
    `_premium_clicks` AS `premium_clicks`,
    `_premium_cpc_all_wo_nds` AS `premium_cpc_all_wo_nds`,
    `_premium_cpc_partner_wo_nds` AS `premium_cpc_partner_wo_nds`,
    `_premium_cpm_all_wo_nds` AS `premium_cpm_all_wo_nds`,
    `_premium_cpm_partner_wo_nds` AS `premium_cpm_partner_wo_nds`,
    `_premium_cpmh_all_wo_nds` AS `premium_cpmh_all_wo_nds`,
    `_premium_cpmh_partner_wo_nds` AS `premium_cpmh_partner_wo_nds`,
    `_premium_ctr` AS `premium_ctr`,
    `_premium_hits` AS `premium_hits`,
    `_premium_page_ad_shows` AS `premium_page_ad_shows`,
    `_premium_partner_wo_nds` AS `premium_partner_wo_nds`,
    `_premium_shows` AS `premium_shows`
FROM (
    SELECT
        round((SUM((`all_wo_nds` / 1000)) / 10000000), 2) AS `_all_wo_nds`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_caption`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        (sumIf(`shows`, `product_id` = 'search_on_site_direct') / sumIf(`direct_page_ad_shows`, `product_id` = 'search_on_site_campaign')) AS `_direct_search_ads`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000), 2) AS `_direct_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_direct') AS `_direct_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpc_direct_search_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpc_direct_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpm_direct_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpm_direct_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) * 1000) / sumIf(`direct_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_direct_search_cpmh_direct_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) * 1000) / sumIf(`direct_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_direct_search_cpmh_direct_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_direct') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_direct')) AS `_direct_search_ctr`,
        sumIf(`direct_hits`, `product_id` = 'search_on_site_campaign') AS `_direct_search_hits`,
        sumIf(`direct_page_ad_shows`, `product_id` = 'search_on_site_campaign') AS `_direct_search_page_ad_shows`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000), 2) AS `_direct_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_direct') AS `_direct_search_shows`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_domain_id`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_id`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000), 2) AS `_market_api_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_market_api') AS `_market_api_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpc_market_api_search_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpc_market_api_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpm_market_api_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpm_market_api_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_market_api') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_market_api')) AS `_market_api_search_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000), 2) AS `_market_api_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_market_api') AS `_market_api_search_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000), 2) AS `_market_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_market') AS `_market_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpc_market_search_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpc_market_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpm_market_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpm_market_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`market_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_market_search_cpmh_market_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`market_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_market_search_cpmh_market_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_market') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_market')) AS `_market_search_ctr`,
        sumIf(`market_hits`, `product_id` = 'search_on_site_campaign') AS `_market_search_hits`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000), 2) AS `_market_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_market') AS `_market_search_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000), 2) AS `_mcb_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_mcb') AS `_mcb_search_clicks`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_mcb')), 2) AS `_mcb_search_cpm_mcb_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_mcb')), 2) AS `_mcb_search_cpm_mcb_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000) * 1000) / sumIf(`mcb_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_mcb_search_cpmh_mcb_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000) * 1000) / sumIf(`mcb_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_mcb_search_cpmh_mcb_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_mcb') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_mcb')) AS `_mcb_search_ctr`,
        sumIf(`mcb_hits`, `product_id` = 'search_on_site_campaign') AS `_mcb_search_hits`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000), 2) AS `_mcb_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_mcb') AS `_mcb_search_shows`,
        `page_id` AS `_page_id`,
        round((SUM((`partner_wo_nds` / 1000)) / 10000000), 2) AS `_partner_wo_nds`,
        (sumIf(`shows`, `product_id` = 'search_on_site_premium') / sumIf(`premium_page_ad_shows`, `product_id` = 'search_on_site_campaign')) AS `_premium_ads`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000), 2) AS `_premium_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_premium') AS `_premium_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpc_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpc_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) * 1000) / sumIf(`premium_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_premium_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) * 1000) / sumIf(`premium_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_premium_cpmh_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_premium') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_premium')) AS `_premium_ctr`,
        sumIf(`premium_hits`, `product_id` = 'search_on_site_campaign') AS `_premium_hits`,
        sumIf(`premium_page_ad_shows`, `product_id` = 'search_on_site_campaign') AS `_premium_page_ad_shows`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000), 2) AS `_premium_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_premium') AS `_premium_shows`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('search_on_site_campaign', 'search_on_site_premium', 'search_on_site_direct', 'search_on_site_mcb', 'search_on_site_market', 'search_on_site_market_api')
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["AND",[["login","=","mock__owner-login"]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["OR",[["is_efir_blogger","=",1],["is_video_blogger","=",1],["is_tutby","=",1],["is_adfox_partner","=",1],["is_mobile_mediation","=",1],["is_games","=",1]]]')
        )
        AND (
            `page_id` = 'mock__page_id'
        )
        AND (
            dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) = 'mock__caption'
        )
        AND (
            dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) IN ('id__from_table__site__with_filter__["AND",[["domain","=","mock__domain.domain"]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'multistate', toUInt64(`page_id`)) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
    )
    GROUP BY `_caption`, `_currency_id`, `_date`, `_domain`, `_domain_id`, `_id`, `_login`, `_page_id`
) `statistics`
WHERE (
    (if(isNaN(`market_search_hits`), 0, `market_search_hits`) + if(isNaN(`direct_search_cpc_direct_search_partner_wo_nds`), 0, `direct_search_cpc_direct_search_partner_wo_nds`) + if(isNaN(`direct_search_cpc_direct_search_all_wo_nds`), 0, `direct_search_cpc_direct_search_all_wo_nds`) + if(isNaN(`market_search_partner_wo_nds`), 0, `market_search_partner_wo_nds`) + if(isNaN(`mcb_search_cpmh_mcb_search_partner_wo_nds`), 0, `mcb_search_cpmh_mcb_search_partner_wo_nds`) + if(isNaN(`direct_search_ads`), 0, `direct_search_ads`) + if(isNaN(`market_search_shows`), 0, `market_search_shows`) + if(isNaN(`premium_clicks`), 0, `premium_clicks`) + if(isNaN(`direct_search_hits`), 0, `direct_search_hits`) + if(isNaN(`premium_cpmh_partner_wo_nds`), 0, `premium_cpmh_partner_wo_nds`) + if(isNaN(`market_search_all_wo_nds`), 0, `market_search_all_wo_nds`) + if(isNaN(`direct_search_cpm_direct_search_partner_wo_nds`), 0, `direct_search_cpm_direct_search_partner_wo_nds`) + if(isNaN(`mcb_search_all_wo_nds`), 0, `mcb_search_all_wo_nds`) + if(isNaN(`premium_cpm_all_wo_nds`), 0, `premium_cpm_all_wo_nds`) + if(isNaN(`direct_search_partner_wo_nds`), 0, `direct_search_partner_wo_nds`) + if(isNaN(`direct_search_cpmh_direct_search_all_wo_nds`), 0, `direct_search_cpmh_direct_search_all_wo_nds`) + if(isNaN(`mcb_search_cpm_mcb_search_partner_wo_nds`), 0, `mcb_search_cpm_mcb_search_partner_wo_nds`) + if(isNaN(`all_wo_nds`), 0, `all_wo_nds`) + if(isNaN(`premium_all_wo_nds`), 0, `premium_all_wo_nds`) + if(isNaN(`mcb_search_cpmh_mcb_search_all_wo_nds`), 0, `mcb_search_cpmh_mcb_search_all_wo_nds`) + if(isNaN(`market_search_ctr`), 0, `market_search_ctr`) + if(isNaN(`direct_search_page_ad_shows`), 0, `direct_search_page_ad_shows`) + if(isNaN(`market_api_search_clicks`), 0, `market_api_search_clicks`) + if(isNaN(`market_search_clicks`), 0, `market_search_clicks`) + if(isNaN(`mcb_search_shows`), 0, `mcb_search_shows`) + if(isNaN(`premium_cpc_all_wo_nds`), 0, `premium_cpc_all_wo_nds`) + if(isNaN(`premium_cpc_partner_wo_nds`), 0, `premium_cpc_partner_wo_nds`) + if(isNaN(`market_api_search_cpm_market_api_search_all_wo_nds`), 0, `market_api_search_cpm_market_api_search_all_wo_nds`) + if(isNaN(`premium_hits`), 0, `premium_hits`) + if(isNaN(`premium_cpm_partner_wo_nds`), 0, `premium_cpm_partner_wo_nds`) + if(isNaN(`market_search_cpc_market_search_all_wo_nds`), 0, `market_search_cpc_market_search_all_wo_nds`) + if(isNaN(`direct_search_cpm_direct_search_all_wo_nds`), 0, `direct_search_cpm_direct_search_all_wo_nds`) + if(isNaN(`market_search_cpmh_market_search_all_wo_nds`), 0, `market_search_cpmh_market_search_all_wo_nds`) + if(isNaN(`mcb_search_ctr`), 0, `mcb_search_ctr`) + if(isNaN(`direct_search_shows`), 0, `direct_search_shows`) + if(isNaN(`partner_wo_nds`), 0, `partner_wo_nds`) + if(isNaN(`mcb_search_hits`), 0, `mcb_search_hits`) + if(isNaN(`market_search_cpc_market_search_partner_wo_nds`), 0, `market_search_cpc_market_search_partner_wo_nds`) + if(isNaN(`market_api_search_ctr`), 0, `market_api_search_ctr`) + if(isNaN(`premium_ctr`), 0, `premium_ctr`) + if(isNaN(`direct_search_cpmh_direct_search_partner_wo_nds`), 0, `direct_search_cpmh_direct_search_partner_wo_nds`) + if(isNaN(`premium_page_ad_shows`), 0, `premium_page_ad_shows`) + if(isNaN(`direct_search_all_wo_nds`), 0, `direct_search_all_wo_nds`) + if(isNaN(`market_api_search_cpc_market_api_search_partner_wo_nds`), 0, `market_api_search_cpc_market_api_search_partner_wo_nds`) + if(isNaN(`mcb_search_cpm_mcb_search_all_wo_nds`), 0, `mcb_search_cpm_mcb_search_all_wo_nds`) + if(isNaN(`mcb_search_clicks`), 0, `mcb_search_clicks`) + if(isNaN(`premium_partner_wo_nds`), 0, `premium_partner_wo_nds`) + if(isNaN(`market_api_search_cpc_market_api_search_all_wo_nds`), 0, `market_api_search_cpc_market_api_search_all_wo_nds`) + if(isNaN(`direct_search_clicks`), 0, `direct_search_clicks`) + if(isNaN(`market_api_search_partner_wo_nds`), 0, `market_api_search_partner_wo_nds`) + if(isNaN(`mcb_search_partner_wo_nds`), 0, `mcb_search_partner_wo_nds`) + if(isNaN(`market_search_cpmh_market_search_partner_wo_nds`), 0, `market_search_cpmh_market_search_partner_wo_nds`) + if(isNaN(`market_api_search_shows`), 0, `market_api_search_shows`) + if(isNaN(`premium_shows`), 0, `premium_shows`) + if(isNaN(`premium_cpmh_all_wo_nds`), 0, `premium_cpmh_all_wo_nds`) + if(isNaN(`market_search_cpm_market_search_partner_wo_nds`), 0, `market_search_cpm_market_search_partner_wo_nds`) + if(isNaN(`market_search_cpm_market_search_all_wo_nds`), 0, `market_search_cpm_market_search_all_wo_nds`) + if(isNaN(`direct_search_ctr`), 0, `direct_search_ctr`) + if(isNaN(`market_api_search_all_wo_nds`), 0, `market_api_search_all_wo_nds`) + if(isNaN(`premium_ads`), 0, `premium_ads`) + if(isNaN(`market_api_search_cpm_market_api_search_partner_wo_nds`), 0, `market_api_search_cpm_market_api_search_partner_wo_nds`)) > 0
) FORMAT JSONCompact
