SELECT
    `_campaign_id` AS `campaign_id`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_domain` AS `domain`,
    `_domain_id` AS `domain_id`,
    `_internal_campaign_id` AS `internal_campaign_id`,
    `_login` AS `login`,
    `_market_search_all_wo_nds` AS `market_search_all_wo_nds`,
    `_market_search_clicks` AS `market_search_clicks`,
    `_market_search_cpc_market_search_all_wo_nds` AS `market_search_cpc_market_search_all_wo_nds`,
    `_market_search_cpc_market_search_partner_wo_nds` AS `market_search_cpc_market_search_partner_wo_nds`,
    `_market_search_cpm_market_search_all_wo_nds` AS `market_search_cpm_market_search_all_wo_nds`,
    `_market_search_cpm_market_search_partner_wo_nds` AS `market_search_cpm_market_search_partner_wo_nds`,
    `_market_search_ctr` AS `market_search_ctr`,
    `_market_search_partner_wo_nds` AS `market_search_partner_wo_nds`,
    `_market_search_shows` AS `market_search_shows`,
    `_public_id` AS `public_id`,
    `_search_campaign_caption` AS `search_campaign_caption`
FROM (
    SELECT
        `page_id` AS `_campaign_id`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_domain_id`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_internal_campaign_id`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000), 2) AS `_market_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_market') AS `_market_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpc_market_search_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpc_market_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpm_market_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpm_market_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_market') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_market')) AS `_market_search_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000), 2) AS `_market_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_market') AS `_market_search_shows`,
        concat(transform(toString(`product_id`), ['search_on_site_market'], ['M-A-']), toString(`page_id`), '-', toString(`block_id`)) AS `_public_id`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_search_campaign_caption`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('search_on_site_market')
        AND (
            `page_id` IN ('page_id__from_table__search_on_site_campaign__with_filter__["AND",[["owner_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"login\\",\\"=\\",\\"mock__campaign-owner-login\\"]]]"]]]]')
        )
        AND (
            `page_id` IN ('page_id__from_table__search_on_site_campaign__with_filter__["AND",[["owner_id","= ANY",["id__from_table__users__with_filter__[\\"OR\\",[[\\"is_efir_blogger\\",\\"=\\",1],[\\"is_video_blogger\\",\\"=\\",1],[\\"is_tutby\\",\\"=\\",1],[\\"is_adfox_partner\\",\\"=\\",1],[\\"is_mobile_mediation\\",\\"=\\",1],[\\"is_games\\",\\"=\\",1]]]"]]]]')
        )
        AND (
            `block_id` = 1
        )
        AND (
            `page_id` = 'mock__campaign_id'
        )
        AND (
            `page_id` IN ('page_id__from_table__search_on_site_campaign__with_filter__["OR",[["AND",[["domain_id","= ANY",["id__from_table__site__with_filter__[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]]"]]]],["AND",[["id","= ANY",["campaign_id__from_table__search_on_site_mirrors__with_filter__[\\"AND\\",[[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]],[\\"AND\\",[[\\"multistate\\",\\"=\\",[\\"mock_multistate\\"]]]]]]"]]]]]]')
        )
        AND (
            dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
        AND `page_id` = 'mock__search_campaign_caption'
    )
    GROUP BY `_campaign_id`, `_currency_id`, `_date`, `_domain`, `_domain_id`, `_internal_campaign_id`, `_login`, `_public_id`, `_search_campaign_caption`
) `statistics`
WHERE (
    (if(isNaN(`market_search_cpc_market_search_all_wo_nds`), 0, `market_search_cpc_market_search_all_wo_nds`) + if(isNaN(`market_search_partner_wo_nds`), 0, `market_search_partner_wo_nds`) + if(isNaN(`market_search_shows`), 0, `market_search_shows`) + if(isNaN(`market_search_ctr`), 0, `market_search_ctr`) + if(isNaN(`market_search_all_wo_nds`), 0, `market_search_all_wo_nds`) + if(isNaN(`market_search_clicks`), 0, `market_search_clicks`) + if(isNaN(`market_search_cpm_market_search_partner_wo_nds`), 0, `market_search_cpm_market_search_partner_wo_nds`) + if(isNaN(`market_search_cpm_market_search_all_wo_nds`), 0, `market_search_cpm_market_search_all_wo_nds`) + if(isNaN(`market_search_cpc_market_search_partner_wo_nds`), 0, `market_search_cpc_market_search_partner_wo_nds`)) > 0
) FORMAT JSONCompact

SELECT
    `_campaign_id` AS `campaign_id`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_domain` AS `domain`,
    `_domain_id` AS `domain_id`,
    `_internal_campaign_id` AS `internal_campaign_id`,
    `_login` AS `login`,
    `_market_search_all_wo_nds` AS `market_search_all_wo_nds`,
    `_market_search_clicks` AS `market_search_clicks`,
    `_market_search_cpc_market_search_all_wo_nds` AS `market_search_cpc_market_search_all_wo_nds`,
    `_market_search_cpc_market_search_partner_wo_nds` AS `market_search_cpc_market_search_partner_wo_nds`,
    `_market_search_cpm_market_search_all_wo_nds` AS `market_search_cpm_market_search_all_wo_nds`,
    `_market_search_cpm_market_search_partner_wo_nds` AS `market_search_cpm_market_search_partner_wo_nds`,
    `_market_search_ctr` AS `market_search_ctr`,
    `_market_search_partner_wo_nds` AS `market_search_partner_wo_nds`,
    `_market_search_shows` AS `market_search_shows`,
    `_search_campaign_caption` AS `search_campaign_caption`,
    `_tag_caption` AS `tag_caption`
FROM (
    SELECT
        `page_id` AS `_campaign_id`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_domain_id`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_internal_campaign_id`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000), 2) AS `_market_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_market') AS `_market_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpc_market_search_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpc_market_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpm_market_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpm_market_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_market') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_market')) AS `_market_search_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000), 2) AS `_market_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_market') AS `_market_search_shows`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_search_campaign_caption`,
        dictGetStringOrDefault('block_tags_dict', 'caption', tuple(toUInt32(`page_id`), toUInt64(`tag_id`)), concat('Slice #', toString(`tag_id`))) AS `_tag_caption`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('search_on_site_market')
        AND (
            `page_id` IN ('page_id__from_table__search_on_site_campaign__with_filter__["AND",[["owner_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"login\\",\\"=\\",\\"mock__campaign-owner-login\\"]]]"]]]]')
        )
        AND (
            `page_id` IN ('page_id__from_table__search_on_site_campaign__with_filter__["AND",[["owner_id","= ANY",["id__from_table__users__with_filter__[\\"OR\\",[[\\"is_efir_blogger\\",\\"=\\",1],[\\"is_video_blogger\\",\\"=\\",1],[\\"is_tutby\\",\\"=\\",1],[\\"is_adfox_partner\\",\\"=\\",1],[\\"is_mobile_mediation\\",\\"=\\",1],[\\"is_games\\",\\"=\\",1]]]"]]]]')
        )
        AND (
            `block_id` = 1
        )
        AND (
            `page_id` = 'mock__campaign_id'
        )
        AND (
            `page_id` IN ('page_id__from_table__search_on_site_campaign__with_filter__["OR",[["AND",[["domain_id","= ANY",["id__from_table__site__with_filter__[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]]"]]]],["AND",[["id","= ANY",["campaign_id__from_table__search_on_site_mirrors__with_filter__[\\"AND\\",[[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]],[\\"AND\\",[[\\"multistate\\",\\"=\\",[\\"mock_multistate\\"]]]]]]"]]]]]]')
        )
        AND (
            dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
        AND `page_id` = 'mock__search_campaign_caption'
    )
    GROUP BY `_campaign_id`, `_currency_id`, `_date`, `_domain`, `_domain_id`, `_internal_campaign_id`, `_login`, `_search_campaign_caption`, `_tag_caption`
) `statistics`
WHERE (
    (if(isNaN(`market_search_cpc_market_search_all_wo_nds`), 0, `market_search_cpc_market_search_all_wo_nds`) + if(isNaN(`market_search_partner_wo_nds`), 0, `market_search_partner_wo_nds`) + if(isNaN(`market_search_shows`), 0, `market_search_shows`) + if(isNaN(`market_search_ctr`), 0, `market_search_ctr`) + if(isNaN(`market_search_all_wo_nds`), 0, `market_search_all_wo_nds`) + if(isNaN(`market_search_clicks`), 0, `market_search_clicks`) + if(isNaN(`market_search_cpm_market_search_partner_wo_nds`), 0, `market_search_cpm_market_search_partner_wo_nds`) + if(isNaN(`market_search_cpm_market_search_all_wo_nds`), 0, `market_search_cpm_market_search_all_wo_nds`) + if(isNaN(`market_search_cpc_market_search_partner_wo_nds`), 0, `market_search_cpc_market_search_partner_wo_nds`)) > 0
) FORMAT JSONCompact

SELECT
    `_campaign_id` AS `campaign_id`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_domain` AS `domain`,
    `_domain_id` AS `domain_id`,
    `_internal_campaign_id` AS `internal_campaign_id`,
    `_login` AS `login`,
    `_market_search_all_wo_nds` AS `market_search_all_wo_nds`,
    `_market_search_clicks` AS `market_search_clicks`,
    `_market_search_cpc_market_search_all_wo_nds` AS `market_search_cpc_market_search_all_wo_nds`,
    `_market_search_cpc_market_search_partner_wo_nds` AS `market_search_cpc_market_search_partner_wo_nds`,
    `_market_search_cpm_market_search_all_wo_nds` AS `market_search_cpm_market_search_all_wo_nds`,
    `_market_search_cpm_market_search_partner_wo_nds` AS `market_search_cpm_market_search_partner_wo_nds`,
    `_market_search_ctr` AS `market_search_ctr`,
    `_market_search_partner_wo_nds` AS `market_search_partner_wo_nds`,
    `_market_search_shows` AS `market_search_shows`,
    `_search_campaign_caption` AS `search_campaign_caption`,
    `_tag_id` AS `tag_id`
FROM (
    SELECT
        `page_id` AS `_campaign_id`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_domain_id`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_internal_campaign_id`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000), 2) AS `_market_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_market') AS `_market_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpc_market_search_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpc_market_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpm_market_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpm_market_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_market') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_market')) AS `_market_search_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000), 2) AS `_market_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_market') AS `_market_search_shows`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_search_campaign_caption`,
        `tag_id` AS `_tag_id`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('search_on_site_market')
        AND (
            `page_id` IN ('page_id__from_table__search_on_site_campaign__with_filter__["AND",[["owner_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"login\\",\\"=\\",\\"mock__campaign-owner-login\\"]]]"]]]]')
        )
        AND (
            `page_id` IN ('page_id__from_table__search_on_site_campaign__with_filter__["AND",[["owner_id","= ANY",["id__from_table__users__with_filter__[\\"OR\\",[[\\"is_efir_blogger\\",\\"=\\",1],[\\"is_video_blogger\\",\\"=\\",1],[\\"is_tutby\\",\\"=\\",1],[\\"is_adfox_partner\\",\\"=\\",1],[\\"is_mobile_mediation\\",\\"=\\",1],[\\"is_games\\",\\"=\\",1]]]"]]]]')
        )
        AND (
            `block_id` = 1
        )
        AND (
            `page_id` = 'mock__campaign_id'
        )
        AND (
            `page_id` IN ('page_id__from_table__search_on_site_campaign__with_filter__["OR",[["AND",[["domain_id","= ANY",["id__from_table__site__with_filter__[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]]"]]]],["AND",[["id","= ANY",["campaign_id__from_table__search_on_site_mirrors__with_filter__[\\"AND\\",[[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]],[\\"AND\\",[[\\"multistate\\",\\"=\\",[\\"mock_multistate\\"]]]]]]"]]]]]]')
        )
        AND (
            dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
        AND `tag_id` = 'mock__tag_id'
        AND `page_id` = 'mock__search_campaign_caption'
    )
    GROUP BY `_campaign_id`, `_currency_id`, `_date`, `_domain`, `_domain_id`, `_internal_campaign_id`, `_login`, `_search_campaign_caption`, `_tag_id`
) `statistics`
WHERE (
    (if(isNaN(`market_search_cpc_market_search_all_wo_nds`), 0, `market_search_cpc_market_search_all_wo_nds`) + if(isNaN(`market_search_partner_wo_nds`), 0, `market_search_partner_wo_nds`) + if(isNaN(`market_search_shows`), 0, `market_search_shows`) + if(isNaN(`market_search_ctr`), 0, `market_search_ctr`) + if(isNaN(`market_search_all_wo_nds`), 0, `market_search_all_wo_nds`) + if(isNaN(`market_search_clicks`), 0, `market_search_clicks`) + if(isNaN(`market_search_cpm_market_search_partner_wo_nds`), 0, `market_search_cpm_market_search_partner_wo_nds`) + if(isNaN(`market_search_cpm_market_search_all_wo_nds`), 0, `market_search_cpm_market_search_all_wo_nds`) + if(isNaN(`market_search_cpc_market_search_partner_wo_nds`), 0, `market_search_cpc_market_search_partner_wo_nds`)) > 0
) FORMAT JSONCompact
