SELECT
    `_campaign_id` AS `campaign_id`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_disposition_name` AS `disposition_name`,
    `_domain` AS `domain`,
    `_domain_id` AS `domain_id`,
    `_internal_campaign_id` AS `internal_campaign_id`,
    `_public_id` AS `public_id`,
    `_stripe_all_wo_nds` AS `stripe_all_wo_nds`,
    `_stripe_clicks` AS `stripe_clicks`,
    `_stripe_cpc_all_wo_nds` AS `stripe_cpc_all_wo_nds`,
    `_stripe_cpm_all_wo_nds` AS `stripe_cpm_all_wo_nds`,
    `_stripe_cpmh_all_wo_nds` AS `stripe_cpmh_all_wo_nds`,
    `_stripe_ctr` AS `stripe_ctr`,
    `_stripe_hits` AS `stripe_hits`,
    `_stripe_shows` AS `stripe_shows`,
    `_title` AS `title`
FROM (
    SELECT
        `page_id` AS `_campaign_id`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        transform(dictGetUInt8('blocks_dict', 'disposition_id', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))), [0, 1], ['Top', 'Bottom'], 'Top') AS `_disposition_name`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_domain_id`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_internal_campaign_id`,
        concat(transform(toString(`product_id`), ['internal_context_on_site_stripe'], ['S-I-']), toString(`page_id`), '-', toString(`block_id`)) AS `_public_id`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_context_on_site_stripe') / 10000000), 2) AS `_stripe_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'internal_context_on_site_stripe') AS `_stripe_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_context_on_site_stripe') / 10000000) / sumIf(`clicks`, `product_id` = 'internal_context_on_site_stripe')), 2) AS `_stripe_cpc_all_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_context_on_site_stripe') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'internal_context_on_site_stripe')), 2) AS `_stripe_cpm_all_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_context_on_site_stripe') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'internal_context_on_site_stripe')), 2) AS `_stripe_cpmh_all_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'internal_context_on_site_stripe') * 100) / sumIf(`shows`, `product_id` = 'internal_context_on_site_stripe')) AS `_stripe_ctr`,
        sumIf(`hits`, `product_id` = 'internal_context_on_site_stripe') AS `_stripe_hits`,
        sumIf(`shows`, `product_id` = 'internal_context_on_site_stripe') AS `_stripe_shows`,
        dictGetString('blocks_dict', 'caption', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_title`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('internal_context_on_site_stripe')
        AND (
            `page_id` IN ('page_id__from_table__managers__with_filter__["AND",[["manager_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"login\\",\\"=\\",\\"mock__managers-manager-login\\"]]]"]]]]')
        )
        AND (
            `block_id` = 1
        )
        AND (
            `page_id` = 'mock__campaign_id'
        )
        AND (
            dictGetString('blocks_dict', 'caption', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 'mock__title'
        )
        AND (
            `page_id` IN ('page_id__from_table__internal_context_on_site_campaign__with_filter__["OR",[["AND",[["site_id","= ANY",["id__from_table__internal_site__with_filter__[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]]"]]]],["AND",[["id","= ANY",["campaign_id__from_table__internal_context_on_site_mirrors__with_filter__[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]]"]]]]]]')
        )
        AND (
            dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
    )
    GROUP BY `_campaign_id`, `_currency_id`, `_date`, `_disposition_name`, `_domain`, `_domain_id`, `_internal_campaign_id`, `_public_id`, `_title`
) `statistics`
WHERE (
    (if(isNaN(`stripe_cpc_all_wo_nds`), 0, `stripe_cpc_all_wo_nds`) + if(isNaN(`stripe_ctr`), 0, `stripe_ctr`) + if(isNaN(`stripe_hits`), 0, `stripe_hits`) + if(isNaN(`stripe_clicks`), 0, `stripe_clicks`) + if(isNaN(`stripe_cpmh_all_wo_nds`), 0, `stripe_cpmh_all_wo_nds`) + if(isNaN(`stripe_shows`), 0, `stripe_shows`) + if(isNaN(`stripe_cpm_all_wo_nds`), 0, `stripe_cpm_all_wo_nds`) + if(isNaN(`stripe_all_wo_nds`), 0, `stripe_all_wo_nds`)) > 0
) FORMAT JSONCompact
