SELECT
    `_all_wo_nds` AS `all_wo_nds`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_direct_search_all_wo_nds` AS `direct_search_all_wo_nds`,
    `_direct_search_clicks` AS `direct_search_clicks`,
    `_direct_search_cpc_direct_search_all_wo_nds` AS `direct_search_cpc_direct_search_all_wo_nds`,
    `_direct_search_cpm_direct_search_all_wo_nds` AS `direct_search_cpm_direct_search_all_wo_nds`,
    `_direct_search_ctr` AS `direct_search_ctr`,
    `_direct_search_shows` AS `direct_search_shows`,
    `_domain` AS `domain`,
    `_id` AS `id`,
    `_premium_all_wo_nds` AS `premium_all_wo_nds`,
    `_premium_clicks` AS `premium_clicks`,
    `_premium_cpc_all_wo_nds` AS `premium_cpc_all_wo_nds`,
    `_premium_cpm_all_wo_nds` AS `premium_cpm_all_wo_nds`,
    `_premium_ctr` AS `premium_ctr`,
    `_premium_shows` AS `premium_shows`,
    `_public_id` AS `public_id`,
    `_site_id` AS `site_id`
FROM (
    SELECT
        round((SUM((`all_wo_nds` / 1000)) / 10000000), 2) AS `_all_wo_nds`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_direct') / 10000000), 2) AS `_direct_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'internal_search_on_site_direct') AS `_direct_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'internal_search_on_site_direct')), 2) AS `_direct_search_cpc_direct_search_all_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'internal_search_on_site_direct')), 2) AS `_direct_search_cpm_direct_search_all_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'internal_search_on_site_direct') * 100) / sumIf(`shows`, `product_id` = 'internal_search_on_site_direct')) AS `_direct_search_ctr`,
        sumIf(`shows`, `product_id` = 'internal_search_on_site_direct') AS `_direct_search_shows`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_id`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000), 2) AS `_premium_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium') AS `_premium_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000) / sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium')), 2) AS `_premium_cpc_all_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'internal_search_on_site_premium')), 2) AS `_premium_cpm_all_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium') * 100) / sumIf(`shows`, `product_id` = 'internal_search_on_site_premium')) AS `_premium_ctr`,
        sumIf(`shows`, `product_id` = 'internal_search_on_site_premium') AS `_premium_shows`,
        concat(transform(toString(`product_id`), ['internal_search_on_site_direct', 'internal_search_on_site_premium'], ['D-I-', 'P-I-']), toString(`page_id`), '-', toString(`block_id`)) AS `_public_id`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_site_id`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('internal_search_on_site_premium', 'internal_search_on_site_direct')
        AND (
            dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) IN ('page_id__from_table__managers__with_filter__["AND",[["manager_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"login\\",\\"=\\",\\"mock__managers-manager-login\\"]]]"]]]]')
        )
        AND (
            dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) = 'mock__id'
        )
        AND (
            (
                dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) IN ('id__from_table__internal_site__with_filter__["AND",[["domain","=","mock__all_domain"]]]')
            )
            OR (
                dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) IN ('campaign_id__from_table__internal_search_on_site_mirrors__with_filter__["AND",[["domain","=","mock__all_domain"]]]')
            )
        )
        AND (
            dictGetUInt64('pages_dict', 'multistate', toUInt64(`page_id`)) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
    )
    GROUP BY `_currency_id`, `_date`, `_domain`, `_id`, `_public_id`, `_site_id`
) `statistics`
WHERE (
    (if(isNaN(`direct_search_all_wo_nds`), 0, `direct_search_all_wo_nds`) + if(isNaN(`direct_search_cpc_direct_search_all_wo_nds`), 0, `direct_search_cpc_direct_search_all_wo_nds`) + if(isNaN(`direct_search_cpm_direct_search_all_wo_nds`), 0, `direct_search_cpm_direct_search_all_wo_nds`) + if(isNaN(`all_wo_nds`), 0, `all_wo_nds`) + if(isNaN(`premium_all_wo_nds`), 0, `premium_all_wo_nds`) + if(isNaN(`direct_search_clicks`), 0, `direct_search_clicks`) + if(isNaN(`premium_clicks`), 0, `premium_clicks`) + if(isNaN(`direct_search_shows`), 0, `direct_search_shows`) + if(isNaN(`premium_shows`), 0, `premium_shows`) + if(isNaN(`direct_search_ctr`), 0, `direct_search_ctr`) + if(isNaN(`premium_cpm_all_wo_nds`), 0, `premium_cpm_all_wo_nds`) + if(isNaN(`premium_cpc_all_wo_nds`), 0, `premium_cpc_all_wo_nds`) + if(isNaN(`premium_ctr`), 0, `premium_ctr`)) > 0
) FORMAT JSONCompact

SELECT
    `_all_wo_nds` AS `all_wo_nds`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_direct_search_ads` AS `direct_search_ads`,
    `_direct_search_all_wo_nds` AS `direct_search_all_wo_nds`,
    `_direct_search_clicks` AS `direct_search_clicks`,
    `_direct_search_cpc_direct_search_all_wo_nds` AS `direct_search_cpc_direct_search_all_wo_nds`,
    `_direct_search_cpm_direct_search_all_wo_nds` AS `direct_search_cpm_direct_search_all_wo_nds`,
    `_direct_search_cpmh_direct_search_all_wo_nds` AS `direct_search_cpmh_direct_search_all_wo_nds`,
    `_direct_search_ctr` AS `direct_search_ctr`,
    `_direct_search_hits` AS `direct_search_hits`,
    `_direct_search_page_ad_shows` AS `direct_search_page_ad_shows`,
    `_direct_search_shows` AS `direct_search_shows`,
    `_domain` AS `domain`,
    `_id` AS `id`,
    `_premium_ads` AS `premium_ads`,
    `_premium_all_wo_nds` AS `premium_all_wo_nds`,
    `_premium_clicks` AS `premium_clicks`,
    `_premium_cpc_all_wo_nds` AS `premium_cpc_all_wo_nds`,
    `_premium_cpm_all_wo_nds` AS `premium_cpm_all_wo_nds`,
    `_premium_cpmh_all_wo_nds` AS `premium_cpmh_all_wo_nds`,
    `_premium_ctr` AS `premium_ctr`,
    `_premium_hits` AS `premium_hits`,
    `_premium_page_ad_shows` AS `premium_page_ad_shows`,
    `_premium_shows` AS `premium_shows`,
    `_site_id` AS `site_id`
FROM (
    SELECT
        round((SUM((`all_wo_nds` / 1000)) / 10000000), 2) AS `_all_wo_nds`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        (sumIf(`shows`, `product_id` = 'internal_search_on_site_direct') / sumIf(`direct_page_ad_shows`, `product_id` = 'internal_search_on_site_campaign')) AS `_direct_search_ads`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_direct') / 10000000), 2) AS `_direct_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'internal_search_on_site_direct') AS `_direct_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'internal_search_on_site_direct')), 2) AS `_direct_search_cpc_direct_search_all_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'internal_search_on_site_direct')), 2) AS `_direct_search_cpm_direct_search_all_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_direct') / 10000000) * 1000) / sumIf(`direct_hits`, `product_id` = 'internal_search_on_site_campaign')), 2) AS `_direct_search_cpmh_direct_search_all_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'internal_search_on_site_direct') * 100) / sumIf(`shows`, `product_id` = 'internal_search_on_site_direct')) AS `_direct_search_ctr`,
        sumIf(`direct_hits`, `product_id` = 'internal_search_on_site_campaign') AS `_direct_search_hits`,
        sumIf(`direct_page_ad_shows`, `product_id` = 'internal_search_on_site_campaign') AS `_direct_search_page_ad_shows`,
        sumIf(`shows`, `product_id` = 'internal_search_on_site_direct') AS `_direct_search_shows`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_id`,
        (sumIf(`shows`, `product_id` = 'internal_search_on_site_premium') / sumIf(`premium_page_ad_shows`, `product_id` = 'internal_search_on_site_campaign')) AS `_premium_ads`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000), 2) AS `_premium_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium') AS `_premium_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000) / sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium')), 2) AS `_premium_cpc_all_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'internal_search_on_site_premium')), 2) AS `_premium_cpm_all_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000) * 1000) / sumIf(`premium_hits`, `product_id` = 'internal_search_on_site_campaign')), 2) AS `_premium_cpmh_all_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium') * 100) / sumIf(`shows`, `product_id` = 'internal_search_on_site_premium')) AS `_premium_ctr`,
        sumIf(`premium_hits`, `product_id` = 'internal_search_on_site_campaign') AS `_premium_hits`,
        sumIf(`premium_page_ad_shows`, `product_id` = 'internal_search_on_site_campaign') AS `_premium_page_ad_shows`,
        sumIf(`shows`, `product_id` = 'internal_search_on_site_premium') AS `_premium_shows`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_site_id`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('internal_search_on_site_campaign', 'internal_search_on_site_premium', 'internal_search_on_site_direct')
        AND (
            dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) IN ('page_id__from_table__managers__with_filter__["AND",[["manager_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"login\\",\\"=\\",\\"mock__managers-manager-login\\"]]]"]]]]')
        )
        AND (
            dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) = 'mock__id'
        )
        AND (
            (
                dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) IN ('id__from_table__internal_site__with_filter__["AND",[["domain","=","mock__all_domain"]]]')
            )
            OR (
                dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) IN ('campaign_id__from_table__internal_search_on_site_mirrors__with_filter__["AND",[["domain","=","mock__all_domain"]]]')
            )
        )
        AND (
            dictGetUInt64('pages_dict', 'multistate', toUInt64(`page_id`)) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
    )
    GROUP BY `_currency_id`, `_date`, `_domain`, `_id`, `_site_id`
) `statistics`
WHERE (
    (if(isNaN(`premium_hits`), 0, `premium_hits`) + if(isNaN(`direct_search_all_wo_nds`), 0, `direct_search_all_wo_nds`) + if(isNaN(`direct_search_cpc_direct_search_all_wo_nds`), 0, `direct_search_cpc_direct_search_all_wo_nds`) + if(isNaN(`direct_search_cpm_direct_search_all_wo_nds`), 0, `direct_search_cpm_direct_search_all_wo_nds`) + if(isNaN(`all_wo_nds`), 0, `all_wo_nds`) + if(isNaN(`premium_all_wo_nds`), 0, `premium_all_wo_nds`) + if(isNaN(`direct_search_clicks`), 0, `direct_search_clicks`) + if(isNaN(`direct_search_ads`), 0, `direct_search_ads`) + if(isNaN(`premium_clicks`), 0, `premium_clicks`) + if(isNaN(`direct_search_shows`), 0, `direct_search_shows`) + if(isNaN(`direct_search_hits`), 0, `direct_search_hits`) + if(isNaN(`direct_search_page_ad_shows`), 0, `direct_search_page_ad_shows`) + if(isNaN(`premium_shows`), 0, `premium_shows`) + if(isNaN(`premium_cpmh_all_wo_nds`), 0, `premium_cpmh_all_wo_nds`) + if(isNaN(`direct_search_ctr`), 0, `direct_search_ctr`) + if(isNaN(`premium_cpm_all_wo_nds`), 0, `premium_cpm_all_wo_nds`) + if(isNaN(`premium_ads`), 0, `premium_ads`) + if(isNaN(`premium_cpc_all_wo_nds`), 0, `premium_cpc_all_wo_nds`) + if(isNaN(`premium_ctr`), 0, `premium_ctr`) + if(isNaN(`premium_page_ad_shows`), 0, `premium_page_ad_shows`) + if(isNaN(`direct_search_cpmh_direct_search_all_wo_nds`), 0, `direct_search_cpmh_direct_search_all_wo_nds`)) > 0
) FORMAT JSONCompact
