SELECT
    `_campaign_id` AS `campaign_id`,
    `_caption` AS `caption`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_domain` AS `domain`,
    `_domain_id` AS `domain_id`,
    `_internal_campaign_id` AS `internal_campaign_id`,
    `_premium_all_wo_nds` AS `premium_all_wo_nds`,
    `_premium_clicks` AS `premium_clicks`,
    `_premium_cpc_all_wo_nds` AS `premium_cpc_all_wo_nds`,
    `_premium_cpm_all_wo_nds` AS `premium_cpm_all_wo_nds`,
    `_premium_ctr` AS `premium_ctr`,
    `_premium_shows` AS `premium_shows`
FROM (
    SELECT
        `page_id` AS `_campaign_id`,
        dictGetString('blocks_dict', 'caption', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_caption`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_domain_id`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_internal_campaign_id`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000), 2) AS `_premium_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium') AS `_premium_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000) / sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium')), 2) AS `_premium_cpc_all_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'internal_search_on_site_premium')), 2) AS `_premium_cpm_all_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium') * 100) / sumIf(`shows`, `product_id` = 'internal_search_on_site_premium')) AS `_premium_ctr`,
        sumIf(`shows`, `product_id` = 'internal_search_on_site_premium') AS `_premium_shows`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('internal_search_on_site_premium')
        AND (
            `page_id` IN ('page_id__from_table__managers__with_filter__["AND",[["manager_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"login\\",\\"=\\",\\"mock__managers-manager-login\\"]]]"]]]]')
        )
        AND (
            `block_id` = 1
        )
        AND (
            `page_id` = 'mock__campaign_id'
        )
        AND (
            dictGetString('blocks_dict', 'caption', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 'mock__caption'
        )
        AND (
            `page_id` IN ('page_id__from_table__internal_search_on_site_campaign__with_filter__["OR",[["AND",[["site_id","= ANY",["id__from_table__internal_site__with_filter__[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]]"]]]],["AND",[["id","= ANY",["campaign_id__from_table__internal_search_on_site_mirrors__with_filter__[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]]"]]]]]]')
        )
        AND (
            dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
    )
    GROUP BY `_campaign_id`, `_caption`, `_currency_id`, `_date`, `_domain`, `_domain_id`, `_internal_campaign_id`
) `statistics`
WHERE (
    (if(isNaN(`premium_clicks`), 0, `premium_clicks`) + if(isNaN(`premium_shows`), 0, `premium_shows`) + if(isNaN(`premium_cpm_all_wo_nds`), 0, `premium_cpm_all_wo_nds`) + if(isNaN(`premium_all_wo_nds`), 0, `premium_all_wo_nds`) + if(isNaN(`premium_cpc_all_wo_nds`), 0, `premium_cpc_all_wo_nds`) + if(isNaN(`premium_ctr`), 0, `premium_ctr`)) > 0
) FORMAT JSONCompact

SELECT
    `_campaign_id` AS `campaign_id`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_domain` AS `domain`,
    `_domain_id` AS `domain_id`,
    `_internal_campaign_id` AS `internal_campaign_id`,
    `_premium_all_wo_nds` AS `premium_all_wo_nds`,
    `_premium_clicks` AS `premium_clicks`,
    `_premium_cpc_all_wo_nds` AS `premium_cpc_all_wo_nds`,
    `_premium_cpm_all_wo_nds` AS `premium_cpm_all_wo_nds`,
    `_premium_ctr` AS `premium_ctr`,
    `_premium_shows` AS `premium_shows`,
    `_public_id` AS `public_id`
FROM (
    SELECT
        `page_id` AS `_campaign_id`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_domain_id`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_internal_campaign_id`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000), 2) AS `_premium_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium') AS `_premium_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000) / sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium')), 2) AS `_premium_cpc_all_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'internal_search_on_site_premium')), 2) AS `_premium_cpm_all_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium') * 100) / sumIf(`shows`, `product_id` = 'internal_search_on_site_premium')) AS `_premium_ctr`,
        sumIf(`shows`, `product_id` = 'internal_search_on_site_premium') AS `_premium_shows`,
        concat(transform(toString(`product_id`), ['internal_search_on_site_premium'], ['P-I-']), toString(`page_id`), '-', toString(`block_id`)) AS `_public_id`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('internal_search_on_site_premium')
        AND (
            `page_id` IN ('page_id__from_table__managers__with_filter__["AND",[["manager_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"login\\",\\"=\\",\\"mock__managers-manager-login\\"]]]"]]]]')
        )
        AND (
            `block_id` = 1
        )
        AND (
            `page_id` = 'mock__campaign_id'
        )
        AND (
            `page_id` IN ('page_id__from_table__internal_search_on_site_campaign__with_filter__["OR",[["AND",[["site_id","= ANY",["id__from_table__internal_site__with_filter__[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]]"]]]],["AND",[["id","= ANY",["campaign_id__from_table__internal_search_on_site_mirrors__with_filter__[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]]"]]]]]]')
        )
        AND (
            dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
    )
    GROUP BY `_campaign_id`, `_currency_id`, `_date`, `_domain`, `_domain_id`, `_internal_campaign_id`, `_public_id`
) `statistics`
WHERE (
    (if(isNaN(`premium_clicks`), 0, `premium_clicks`) + if(isNaN(`premium_shows`), 0, `premium_shows`) + if(isNaN(`premium_cpm_all_wo_nds`), 0, `premium_cpm_all_wo_nds`) + if(isNaN(`premium_all_wo_nds`), 0, `premium_all_wo_nds`) + if(isNaN(`premium_cpc_all_wo_nds`), 0, `premium_cpc_all_wo_nds`) + if(isNaN(`premium_ctr`), 0, `premium_ctr`)) > 0
) FORMAT JSONCompact

SELECT
    `_campaign_id` AS `campaign_id`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_domain` AS `domain`,
    `_domain_id` AS `domain_id`,
    `_internal_campaign_id` AS `internal_campaign_id`,
    `_premium_all_wo_nds` AS `premium_all_wo_nds`,
    `_premium_clicks` AS `premium_clicks`,
    `_premium_cpc_all_wo_nds` AS `premium_cpc_all_wo_nds`,
    `_premium_cpm_all_wo_nds` AS `premium_cpm_all_wo_nds`,
    `_premium_ctr` AS `premium_ctr`,
    `_premium_shows` AS `premium_shows`,
    `_tag_caption` AS `tag_caption`
FROM (
    SELECT
        `page_id` AS `_campaign_id`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_domain_id`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_internal_campaign_id`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000), 2) AS `_premium_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium') AS `_premium_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000) / sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium')), 2) AS `_premium_cpc_all_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'internal_search_on_site_premium')), 2) AS `_premium_cpm_all_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium') * 100) / sumIf(`shows`, `product_id` = 'internal_search_on_site_premium')) AS `_premium_ctr`,
        sumIf(`shows`, `product_id` = 'internal_search_on_site_premium') AS `_premium_shows`,
        dictGetStringOrDefault('block_tags_dict', 'caption', tuple(toUInt32(`page_id`), toUInt64(`tag_id`)), concat('Slice #', toString(`tag_id`))) AS `_tag_caption`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('internal_search_on_site_premium')
        AND (
            `page_id` IN ('page_id__from_table__managers__with_filter__["AND",[["manager_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"login\\",\\"=\\",\\"mock__managers-manager-login\\"]]]"]]]]')
        )
        AND (
            `block_id` = 1
        )
        AND (
            `page_id` = 'mock__campaign_id'
        )
        AND (
            `page_id` IN ('page_id__from_table__internal_search_on_site_campaign__with_filter__["OR",[["AND",[["site_id","= ANY",["id__from_table__internal_site__with_filter__[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]]"]]]],["AND",[["id","= ANY",["campaign_id__from_table__internal_search_on_site_mirrors__with_filter__[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]]"]]]]]]')
        )
        AND (
            dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
    )
    GROUP BY `_campaign_id`, `_currency_id`, `_date`, `_domain`, `_domain_id`, `_internal_campaign_id`, `_tag_caption`
) `statistics`
WHERE (
    (if(isNaN(`premium_clicks`), 0, `premium_clicks`) + if(isNaN(`premium_shows`), 0, `premium_shows`) + if(isNaN(`premium_cpm_all_wo_nds`), 0, `premium_cpm_all_wo_nds`) + if(isNaN(`premium_all_wo_nds`), 0, `premium_all_wo_nds`) + if(isNaN(`premium_cpc_all_wo_nds`), 0, `premium_cpc_all_wo_nds`) + if(isNaN(`premium_ctr`), 0, `premium_ctr`)) > 0
) FORMAT JSONCompact

SELECT
    `_campaign_id` AS `campaign_id`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_domain` AS `domain`,
    `_domain_id` AS `domain_id`,
    `_internal_campaign_id` AS `internal_campaign_id`,
    `_premium_all_wo_nds` AS `premium_all_wo_nds`,
    `_premium_clicks` AS `premium_clicks`,
    `_premium_cpc_all_wo_nds` AS `premium_cpc_all_wo_nds`,
    `_premium_cpm_all_wo_nds` AS `premium_cpm_all_wo_nds`,
    `_premium_ctr` AS `premium_ctr`,
    `_premium_shows` AS `premium_shows`,
    `_tag_id` AS `tag_id`
FROM (
    SELECT
        `page_id` AS `_campaign_id`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_domain_id`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_internal_campaign_id`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000), 2) AS `_premium_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium') AS `_premium_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000) / sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium')), 2) AS `_premium_cpc_all_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'internal_search_on_site_premium')), 2) AS `_premium_cpm_all_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium') * 100) / sumIf(`shows`, `product_id` = 'internal_search_on_site_premium')) AS `_premium_ctr`,
        sumIf(`shows`, `product_id` = 'internal_search_on_site_premium') AS `_premium_shows`,
        `tag_id` AS `_tag_id`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('internal_search_on_site_premium')
        AND (
            `page_id` IN ('page_id__from_table__managers__with_filter__["AND",[["manager_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"login\\",\\"=\\",\\"mock__managers-manager-login\\"]]]"]]]]')
        )
        AND (
            `block_id` = 1
        )
        AND (
            `page_id` = 'mock__campaign_id'
        )
        AND (
            `page_id` IN ('page_id__from_table__internal_search_on_site_campaign__with_filter__["OR",[["AND",[["site_id","= ANY",["id__from_table__internal_site__with_filter__[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]]"]]]],["AND",[["id","= ANY",["campaign_id__from_table__internal_search_on_site_mirrors__with_filter__[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]]"]]]]]]')
        )
        AND (
            dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
        AND `tag_id` = 'mock__tag_id'
    )
    GROUP BY `_campaign_id`, `_currency_id`, `_date`, `_domain`, `_domain_id`, `_internal_campaign_id`, `_tag_id`
) `statistics`
WHERE (
    (if(isNaN(`premium_clicks`), 0, `premium_clicks`) + if(isNaN(`premium_shows`), 0, `premium_shows`) + if(isNaN(`premium_cpm_all_wo_nds`), 0, `premium_cpm_all_wo_nds`) + if(isNaN(`premium_all_wo_nds`), 0, `premium_all_wo_nds`) + if(isNaN(`premium_cpc_all_wo_nds`), 0, `premium_cpc_all_wo_nds`) + if(isNaN(`premium_ctr`), 0, `premium_ctr`)) > 0
) FORMAT JSONCompact

SELECT
    `_campaign_id` AS `campaign_id`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_domain` AS `domain`,
    `_domain_id` AS `domain_id`,
    `_internal_campaign_id` AS `internal_campaign_id`,
    `_premium_all_wo_nds` AS `premium_all_wo_nds`,
    `_premium_clicks` AS `premium_clicks`,
    `_premium_cpc_all_wo_nds` AS `premium_cpc_all_wo_nds`,
    `_premium_cpm_all_wo_nds` AS `premium_cpm_all_wo_nds`,
    `_premium_ctr` AS `premium_ctr`,
    `_premium_shows` AS `premium_shows`,
    `_type` AS `type`
FROM (
    SELECT
        `page_id` AS `_campaign_id`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_domain_id`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_internal_campaign_id`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000), 2) AS `_premium_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium') AS `_premium_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000) / sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium')), 2) AS `_premium_cpc_all_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'internal_search_on_site_premium') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'internal_search_on_site_premium')), 2) AS `_premium_cpm_all_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'internal_search_on_site_premium') * 100) / sumIf(`shows`, `product_id` = 'internal_search_on_site_premium')) AS `_premium_ctr`,
        sumIf(`shows`, `product_id` = 'internal_search_on_site_premium') AS `_premium_shows`,
        dictGetString('blocks_dict', 'direct_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_type`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('internal_search_on_site_premium')
        AND (
            `page_id` IN ('page_id__from_table__managers__with_filter__["AND",[["manager_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"login\\",\\"=\\",\\"mock__managers-manager-login\\"]]]"]]]]')
        )
        AND (
            `block_id` = 1
        )
        AND (
            `page_id` = 'mock__campaign_id'
        )
        AND (
            `page_id` IN ('page_id__from_table__internal_search_on_site_campaign__with_filter__["OR",[["AND",[["site_id","= ANY",["id__from_table__internal_site__with_filter__[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]]"]]]],["AND",[["id","= ANY",["campaign_id__from_table__internal_search_on_site_mirrors__with_filter__[\\"AND\\",[[\\"domain\\",\\"=\\",\\"mock__campaign.all_domain\\"]]]"]]]]]]')
        )
        AND (
            dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
    )
    GROUP BY `_campaign_id`, `_currency_id`, `_date`, `_domain`, `_domain_id`, `_internal_campaign_id`, `_type`
) `statistics`
WHERE (
    (if(isNaN(`premium_clicks`), 0, `premium_clicks`) + if(isNaN(`premium_shows`), 0, `premium_shows`) + if(isNaN(`premium_cpm_all_wo_nds`), 0, `premium_cpm_all_wo_nds`) + if(isNaN(`premium_all_wo_nds`), 0, `premium_all_wo_nds`) + if(isNaN(`premium_cpc_all_wo_nds`), 0, `premium_cpc_all_wo_nds`) + if(isNaN(`premium_ctr`), 0, `premium_ctr`)) > 0
) FORMAT JSONCompact
