SELECT
    `_adfox_block` AS `adfox_block`,
    `_all_wo_nds` AS `all_wo_nds`,
    `_application_id` AS `application_id`,
    `_bad_win_partner_price_wo_nds` AS `bad_win_partner_price_wo_nds`,
    `_bad_win_price_wo_nds` AS `bad_win_price_wo_nds`,
    `_caption` AS `caption`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_id` AS `id`,
    `_login` AS `login`,
    `_mobile_block_type_label` AS `mobile_block_type_label`,
    `_mobile_rtb_all_wo_nds` AS `mobile_rtb_all_wo_nds`,
    `_mobile_rtb_bad_win_partner_price_wo_nds` AS `mobile_rtb_bad_win_partner_price_wo_nds`,
    `_mobile_rtb_bad_win_price_wo_nds` AS `mobile_rtb_bad_win_price_wo_nds`,
    `_mobile_rtb_block_all_hits` AS `mobile_rtb_block_all_hits`,
    `_mobile_rtb_block_bad_shows` AS `mobile_rtb_block_bad_shows`,
    `_mobile_rtb_block_bad_shows_own_adv` AS `mobile_rtb_block_bad_shows_own_adv`,
    `_mobile_rtb_block_bad_shows_percent` AS `mobile_rtb_block_bad_shows_percent`,
    `_mobile_rtb_block_bad_win_hits` AS `mobile_rtb_block_bad_win_hits`,
    `_mobile_rtb_block_bad_win_hits_own_adv` AS `mobile_rtb_block_bad_win_hits_own_adv`,
    `_mobile_rtb_block_bad_win_hits_percent` AS `mobile_rtb_block_bad_win_hits_percent`,
    `_mobile_rtb_block_bad_win_hits_unsold` AS `mobile_rtb_block_bad_win_hits_unsold`,
    `_mobile_rtb_block_cover_ratio` AS `mobile_rtb_block_cover_ratio`,
    `_mobile_rtb_block_cpm_all_wo_nds` AS `mobile_rtb_block_cpm_all_wo_nds`,
    `_mobile_rtb_block_cpm_partner_wo_nds` AS `mobile_rtb_block_cpm_partner_wo_nds`,
    `_mobile_rtb_block_cpmh_all_wo_nds` AS `mobile_rtb_block_cpmh_all_wo_nds`,
    `_mobile_rtb_block_cpmh_partner_wo_nds` AS `mobile_rtb_block_cpmh_partner_wo_nds`,
    `_mobile_rtb_block_direct_clicks` AS `mobile_rtb_block_direct_clicks`,
    `_mobile_rtb_block_direct_ctr` AS `mobile_rtb_block_direct_ctr`,
    `_mobile_rtb_block_direct_shows` AS `mobile_rtb_block_direct_shows`,
    `_mobile_rtb_block_hits` AS `mobile_rtb_block_hits`,
    `_mobile_rtb_block_hits_own_adv` AS `mobile_rtb_block_hits_own_adv`,
    `_mobile_rtb_block_hits_unsold` AS `mobile_rtb_block_hits_unsold`,
    `_mobile_rtb_block_rpm_all_wo_nds` AS `mobile_rtb_block_rpm_all_wo_nds`,
    `_mobile_rtb_block_rpm_partner_wo_nds` AS `mobile_rtb_block_rpm_partner_wo_nds`,
    `_mobile_rtb_block_shows` AS `mobile_rtb_block_shows`,
    `_mobile_rtb_block_shows_own_adv` AS `mobile_rtb_block_shows_own_adv`,
    `_mobile_rtb_block_visibility` AS `mobile_rtb_block_visibility`,
    `_mobile_rtb_block_winrate` AS `mobile_rtb_block_winrate`,
    `_mobile_rtb_partner_wo_nds` AS `mobile_rtb_partner_wo_nds`,
    `_page_id` AS `page_id`,
    `_partner_wo_nds` AS `partner_wo_nds`,
    `_percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds` AS `percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`,
    `_percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds` AS `percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`,
    `_public_id` AS `public_id`,
    `_store_id` AS `store_id`
FROM (
    SELECT
        dictGetUInt8('blocks_dict', 'adfox_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_adfox_block`,
        round((SUM((`all_wo_nds` / 1000)) / 10000000), 2) AS `_all_wo_nds`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_application_id`,
        round((SUM((`bad_win_partner_price_wo_nds` / 1000)) / 10000000), 2) AS `_bad_win_partner_price_wo_nds`,
        round((SUM((`bad_win_price_wo_nds` / 1000)) / 10000000), 2) AS `_bad_win_price_wo_nds`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_caption`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_id`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        transform(dictGetString('blocks_dict', 'mobile_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))), ['banner', 'interstitial', 'rewarded', 'adaptive_banner', 'native'], ['block_type_banner', 'block_type_interstitial', 'block_type_rewarded', 'block_type_adaptive_banner', 'block_type_native']) AS `_mobile_block_type_label`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'mobile_app_rtb') AS `_mobile_rtb_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )))) AS `_mobile_rtb_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )))) AS `_mobile_rtb_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / sumIf(`hits`, `product_id` = 'mobile_app_rtb')) AS `_mobile_rtb_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'mobile_app_rtb')) AS `_mobile_rtb_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'mobile_app_rtb') AS `_mobile_rtb_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'mobile_app_rtb')), 2) AS `_mobile_rtb_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'mobile_app_rtb')), 2) AS `_mobile_rtb_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'mobile_app_rtb'
        ))) AS `_mobile_rtb_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'mobile_app_rtb'
            )))) AS `_mobile_rtb_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_partner_wo_nds`,
        `page_id` AS `_page_id`,
        round((SUM((`partner_wo_nds` / 1000)) / 10000000), 2) AS `_partner_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb'))) AS `_percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb'))) AS `_percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`,
        concat(transform(toString(`product_id`), ['mobile_app_rtb'], ['R-M-']), toString(`page_id`), '-', toString(`block_id`)) AS `_public_id`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_store_id`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('mobile_app_rtb')
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["AND",[["login","=","mock__owner-login"]]]')
        )
        AND (
            `page_id` IN ('page_id__from_table__assistants__with_filter__["AND",[["user_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"login\\",\\"=\\",\\"mock__assistants-user-login\\"]]]"]]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["AND",[["client_id","=","mock__owner.client_id"]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["OR",[["is_efir_blogger","=",1],["is_video_blogger","=",1],["is_tutby","=",1],["is_adfox_partner","=",1],["is_mobile_mediation","=",1],["is_games","=",1]]]')
        )
        AND (
            `page_id` = 'mock__page_id'
        )
        AND (
            dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) IN ('id__from_table__mobile_app__with_filter__["AND",[["store_id","=","mock__application.store_id"]]]')
        )
        AND (
            dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) = 'mock__application_id'
        )
        AND (
            dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) = 'mock__caption'
        )
        AND (
            dictGetUInt64('pages_dict', 'multistate', toUInt64(`page_id`)) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
        AND (
            dictGetUInt8('blocks_dict', 'adfox_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 1
        )
    )
    GROUP BY `_adfox_block`, `_application_id`, `_caption`, `_currency_id`, `_date`, `_id`, `_login`, `_mobile_block_type_label`, `_page_id`, `_public_id`, `_store_id`
) `statistics`
WHERE (
    (if(isNaN(`mobile_rtb_block_cpmh_all_wo_nds`), 0, `mobile_rtb_block_cpmh_all_wo_nds`) + if(isNaN(`mobile_rtb_bad_win_partner_price_wo_nds`), 0, `mobile_rtb_bad_win_partner_price_wo_nds`) + if(isNaN(`mobile_rtb_partner_wo_nds`), 0, `mobile_rtb_partner_wo_nds`) + if(isNaN(`mobile_rtb_block_bad_win_hits`), 0, `mobile_rtb_block_bad_win_hits`) + if(isNaN(`mobile_rtb_block_bad_shows`), 0, `mobile_rtb_block_bad_shows`) + if(isNaN(`bad_win_partner_price_wo_nds`), 0, `bad_win_partner_price_wo_nds`) + if(isNaN(`mobile_rtb_block_all_hits`), 0, `mobile_rtb_block_all_hits`) + if(isNaN(`mobile_rtb_block_bad_shows_percent`), 0, `mobile_rtb_block_bad_shows_percent`) + if(isNaN(`mobile_rtb_block_bad_win_hits_percent`), 0, `mobile_rtb_block_bad_win_hits_percent`) + if(isNaN(`mobile_rtb_block_shows`), 0, `mobile_rtb_block_shows`) + if(isNaN(`mobile_rtb_block_bad_win_hits_unsold`), 0, `mobile_rtb_block_bad_win_hits_unsold`) + if(isNaN(`mobile_rtb_block_rpm_partner_wo_nds`), 0, `mobile_rtb_block_rpm_partner_wo_nds`) + if(isNaN(`mobile_rtb_block_cover_ratio`), 0, `mobile_rtb_block_cover_ratio`) + if(isNaN(`mobile_rtb_block_bad_shows_own_adv`), 0, `mobile_rtb_block_bad_shows_own_adv`) + if(isNaN(`partner_wo_nds`), 0, `partner_wo_nds`) + if(isNaN(`mobile_rtb_block_direct_ctr`), 0, `mobile_rtb_block_direct_ctr`) + if(isNaN(`bad_win_price_wo_nds`), 0, `bad_win_price_wo_nds`) + if(isNaN(`mobile_rtb_block_bad_win_hits_own_adv`), 0, `mobile_rtb_block_bad_win_hits_own_adv`) + if(isNaN(`mobile_rtb_block_hits_unsold`), 0, `mobile_rtb_block_hits_unsold`) + if(isNaN(`mobile_rtb_block_shows_own_adv`), 0, `mobile_rtb_block_shows_own_adv`) + if(isNaN(`mobile_rtb_block_visibility`), 0, `mobile_rtb_block_visibility`) + if(isNaN(`mobile_rtb_block_winrate`), 0, `mobile_rtb_block_winrate`) + if(isNaN(`mobile_rtb_block_rpm_all_wo_nds`), 0, `mobile_rtb_block_rpm_all_wo_nds`) + if(isNaN(`percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`), 0, `percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`) + if(isNaN(`all_wo_nds`), 0, `all_wo_nds`) + if(isNaN(`percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`), 0, `percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`) + if(isNaN(`mobile_rtb_bad_win_price_wo_nds`), 0, `mobile_rtb_bad_win_price_wo_nds`) + if(isNaN(`mobile_rtb_block_cpm_all_wo_nds`), 0, `mobile_rtb_block_cpm_all_wo_nds`) + if(isNaN(`mobile_rtb_block_hits`), 0, `mobile_rtb_block_hits`) + if(isNaN(`mobile_rtb_block_direct_clicks`), 0, `mobile_rtb_block_direct_clicks`) + if(isNaN(`mobile_rtb_block_cpm_partner_wo_nds`), 0, `mobile_rtb_block_cpm_partner_wo_nds`) + if(isNaN(`mobile_rtb_block_direct_shows`), 0, `mobile_rtb_block_direct_shows`) + if(isNaN(`mobile_rtb_block_hits_own_adv`), 0, `mobile_rtb_block_hits_own_adv`) + if(isNaN(`mobile_rtb_block_cpmh_partner_wo_nds`), 0, `mobile_rtb_block_cpmh_partner_wo_nds`) + if(isNaN(`mobile_rtb_all_wo_nds`), 0, `mobile_rtb_all_wo_nds`)) > 0
) FORMAT JSONCompact

SELECT
    `_all_wo_nds` AS `all_wo_nds`,
    `_an_mobile_rtb_cover_direct_hits` AS `an_mobile_rtb_cover_direct_hits`,
    `_an_mobile_rtb_cover_hits` AS `an_mobile_rtb_cover_hits`,
    `_an_mobile_rtb_cover_senthits` AS `an_mobile_rtb_cover_senthits`,
    `_application_id` AS `application_id`,
    `_bad_win_partner_price_wo_nds` AS `bad_win_partner_price_wo_nds`,
    `_bad_win_price_wo_nds` AS `bad_win_price_wo_nds`,
    `_caption` AS `caption`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_id` AS `id`,
    `_login` AS `login`,
    `_mobile_rtb_all_wo_nds` AS `mobile_rtb_all_wo_nds`,
    `_mobile_rtb_bad_win_partner_price_wo_nds` AS `mobile_rtb_bad_win_partner_price_wo_nds`,
    `_mobile_rtb_bad_win_price_wo_nds` AS `mobile_rtb_bad_win_price_wo_nds`,
    `_mobile_rtb_block_all_hits` AS `mobile_rtb_block_all_hits`,
    `_mobile_rtb_block_bad_shows` AS `mobile_rtb_block_bad_shows`,
    `_mobile_rtb_block_bad_shows_own_adv` AS `mobile_rtb_block_bad_shows_own_adv`,
    `_mobile_rtb_block_bad_shows_percent` AS `mobile_rtb_block_bad_shows_percent`,
    `_mobile_rtb_block_bad_win_hits` AS `mobile_rtb_block_bad_win_hits`,
    `_mobile_rtb_block_bad_win_hits_own_adv` AS `mobile_rtb_block_bad_win_hits_own_adv`,
    `_mobile_rtb_block_bad_win_hits_percent` AS `mobile_rtb_block_bad_win_hits_percent`,
    `_mobile_rtb_block_bad_win_hits_unsold` AS `mobile_rtb_block_bad_win_hits_unsold`,
    `_mobile_rtb_block_cover_ratio` AS `mobile_rtb_block_cover_ratio`,
    `_mobile_rtb_block_cpm_all_wo_nds` AS `mobile_rtb_block_cpm_all_wo_nds`,
    `_mobile_rtb_block_cpm_partner_wo_nds` AS `mobile_rtb_block_cpm_partner_wo_nds`,
    `_mobile_rtb_block_cpmh_all_wo_nds` AS `mobile_rtb_block_cpmh_all_wo_nds`,
    `_mobile_rtb_block_cpmh_partner_wo_nds` AS `mobile_rtb_block_cpmh_partner_wo_nds`,
    `_mobile_rtb_block_direct_clicks` AS `mobile_rtb_block_direct_clicks`,
    `_mobile_rtb_block_direct_ctr` AS `mobile_rtb_block_direct_ctr`,
    `_mobile_rtb_block_direct_shows` AS `mobile_rtb_block_direct_shows`,
    `_mobile_rtb_block_hits` AS `mobile_rtb_block_hits`,
    `_mobile_rtb_block_hits_own_adv` AS `mobile_rtb_block_hits_own_adv`,
    `_mobile_rtb_block_hits_unsold` AS `mobile_rtb_block_hits_unsold`,
    `_mobile_rtb_block_rpm_all_wo_nds` AS `mobile_rtb_block_rpm_all_wo_nds`,
    `_mobile_rtb_block_rpm_partner_wo_nds` AS `mobile_rtb_block_rpm_partner_wo_nds`,
    `_mobile_rtb_block_shows` AS `mobile_rtb_block_shows`,
    `_mobile_rtb_block_shows_own_adv` AS `mobile_rtb_block_shows_own_adv`,
    `_mobile_rtb_block_visibility` AS `mobile_rtb_block_visibility`,
    `_mobile_rtb_block_winrate` AS `mobile_rtb_block_winrate`,
    `_mobile_rtb_partner_wo_nds` AS `mobile_rtb_partner_wo_nds`,
    `_page_id` AS `page_id`,
    `_partner_wo_nds` AS `partner_wo_nds`,
    `_percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds` AS `percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`,
    `_percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds` AS `percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`,
    `_store_id` AS `store_id`
FROM (
    SELECT
        round((SUM((`all_wo_nds` / 1000)) / 10000000), 2) AS `_all_wo_nds`,
        sumIf(`an_rtb_cover_direct_hits`, `product_id` = 'mobile_app_settings') AS `_an_mobile_rtb_cover_direct_hits`,
        sumIf(`an_rtb_cover_hits`, `product_id` = 'mobile_app_settings') AS `_an_mobile_rtb_cover_hits`,
        sumIf(`an_rtb_cover_senthits`, `product_id` = 'mobile_app_settings') AS `_an_mobile_rtb_cover_senthits`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_application_id`,
        round((SUM((`bad_win_partner_price_wo_nds` / 1000)) / 10000000), 2) AS `_bad_win_partner_price_wo_nds`,
        round((SUM((`bad_win_price_wo_nds` / 1000)) / 10000000), 2) AS `_bad_win_price_wo_nds`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_caption`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_id`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'mobile_app_rtb') AS `_mobile_rtb_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )))) AS `_mobile_rtb_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )))) AS `_mobile_rtb_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / sumIf(`hits`, `product_id` = 'mobile_app_rtb')) AS `_mobile_rtb_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'mobile_app_rtb')) AS `_mobile_rtb_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'mobile_app_rtb') AS `_mobile_rtb_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'mobile_app_rtb')), 2) AS `_mobile_rtb_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'mobile_app_rtb')), 2) AS `_mobile_rtb_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'mobile_app_rtb'
        ))) AS `_mobile_rtb_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'mobile_app_rtb'
            )))) AS `_mobile_rtb_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_partner_wo_nds`,
        `page_id` AS `_page_id`,
        round((SUM((`partner_wo_nds` / 1000)) / 10000000), 2) AS `_partner_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb'))) AS `_percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb'))) AS `_percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_store_id`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('mobile_app_settings', 'mobile_app_rtb')
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["AND",[["login","=","mock__owner-login"]]]')
        )
        AND (
            `page_id` IN ('page_id__from_table__assistants__with_filter__["AND",[["user_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"login\\",\\"=\\",\\"mock__assistants-user-login\\"]]]"]]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["AND",[["client_id","=","mock__owner.client_id"]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["OR",[["is_efir_blogger","=",1],["is_video_blogger","=",1],["is_tutby","=",1],["is_adfox_partner","=",1],["is_mobile_mediation","=",1],["is_games","=",1]]]')
        )
        AND (
            `page_id` = 'mock__page_id'
        )
        AND (
            dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) IN ('id__from_table__mobile_app__with_filter__["AND",[["store_id","=","mock__application.store_id"]]]')
        )
        AND (
            dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) = 'mock__application_id'
        )
        AND (
            dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) = 'mock__caption'
        )
        AND (
            dictGetUInt64('pages_dict', 'multistate', toUInt64(`page_id`)) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
    )
    GROUP BY `_application_id`, `_caption`, `_currency_id`, `_date`, `_id`, `_login`, `_page_id`, `_store_id`
) `statistics`
WHERE (
    (if(isNaN(`mobile_rtb_block_cpmh_all_wo_nds`), 0, `mobile_rtb_block_cpmh_all_wo_nds`) + if(isNaN(`mobile_rtb_bad_win_partner_price_wo_nds`), 0, `mobile_rtb_bad_win_partner_price_wo_nds`) + if(isNaN(`mobile_rtb_partner_wo_nds`), 0, `mobile_rtb_partner_wo_nds`) + if(isNaN(`mobile_rtb_block_bad_win_hits`), 0, `mobile_rtb_block_bad_win_hits`) + if(isNaN(`mobile_rtb_block_bad_shows`), 0, `mobile_rtb_block_bad_shows`) + if(isNaN(`bad_win_partner_price_wo_nds`), 0, `bad_win_partner_price_wo_nds`) + if(isNaN(`mobile_rtb_block_all_hits`), 0, `mobile_rtb_block_all_hits`) + if(isNaN(`mobile_rtb_block_bad_shows_percent`), 0, `mobile_rtb_block_bad_shows_percent`) + if(isNaN(`mobile_rtb_block_bad_win_hits_percent`), 0, `mobile_rtb_block_bad_win_hits_percent`) + if(isNaN(`mobile_rtb_block_shows`), 0, `mobile_rtb_block_shows`) + if(isNaN(`an_mobile_rtb_cover_direct_hits`), 0, `an_mobile_rtb_cover_direct_hits`) + if(isNaN(`mobile_rtb_block_bad_win_hits_unsold`), 0, `mobile_rtb_block_bad_win_hits_unsold`) + if(isNaN(`mobile_rtb_block_rpm_partner_wo_nds`), 0, `mobile_rtb_block_rpm_partner_wo_nds`) + if(isNaN(`mobile_rtb_block_cover_ratio`), 0, `mobile_rtb_block_cover_ratio`) + if(isNaN(`mobile_rtb_block_bad_shows_own_adv`), 0, `mobile_rtb_block_bad_shows_own_adv`) + if(isNaN(`partner_wo_nds`), 0, `partner_wo_nds`) + if(isNaN(`mobile_rtb_block_direct_ctr`), 0, `mobile_rtb_block_direct_ctr`) + if(isNaN(`bad_win_price_wo_nds`), 0, `bad_win_price_wo_nds`) + if(isNaN(`mobile_rtb_block_bad_win_hits_own_adv`), 0, `mobile_rtb_block_bad_win_hits_own_adv`) + if(isNaN(`mobile_rtb_block_hits_unsold`), 0, `mobile_rtb_block_hits_unsold`) + if(isNaN(`mobile_rtb_block_shows_own_adv`), 0, `mobile_rtb_block_shows_own_adv`) + if(isNaN(`mobile_rtb_block_visibility`), 0, `mobile_rtb_block_visibility`) + if(isNaN(`mobile_rtb_block_winrate`), 0, `mobile_rtb_block_winrate`) + if(isNaN(`mobile_rtb_block_rpm_all_wo_nds`), 0, `mobile_rtb_block_rpm_all_wo_nds`) + if(isNaN(`percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`), 0, `percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`) + if(isNaN(`all_wo_nds`), 0, `all_wo_nds`) + if(isNaN(`percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`), 0, `percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`) + if(isNaN(`an_mobile_rtb_cover_senthits`), 0, `an_mobile_rtb_cover_senthits`) + if(isNaN(`mobile_rtb_bad_win_price_wo_nds`), 0, `mobile_rtb_bad_win_price_wo_nds`) + if(isNaN(`mobile_rtb_block_cpm_all_wo_nds`), 0, `mobile_rtb_block_cpm_all_wo_nds`) + if(isNaN(`mobile_rtb_block_hits`), 0, `mobile_rtb_block_hits`) + if(isNaN(`mobile_rtb_block_direct_clicks`), 0, `mobile_rtb_block_direct_clicks`) + if(isNaN(`mobile_rtb_block_cpm_partner_wo_nds`), 0, `mobile_rtb_block_cpm_partner_wo_nds`) + if(isNaN(`an_mobile_rtb_cover_hits`), 0, `an_mobile_rtb_cover_hits`) + if(isNaN(`mobile_rtb_block_direct_shows`), 0, `mobile_rtb_block_direct_shows`) + if(isNaN(`mobile_rtb_block_hits_own_adv`), 0, `mobile_rtb_block_hits_own_adv`) + if(isNaN(`mobile_rtb_block_cpmh_partner_wo_nds`), 0, `mobile_rtb_block_cpmh_partner_wo_nds`) + if(isNaN(`mobile_rtb_all_wo_nds`), 0, `mobile_rtb_all_wo_nds`)) > 0
) FORMAT JSONCompact
