SELECT
    `_adfox_block` AS `adfox_block`,
    `_application_id` AS `application_id`,
    `_block_type_label` AS `block_type_label`,
    `_caption` AS `caption`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_direct_block` AS `direct_block`,
    `_dsp_caption` AS `dsp_caption`,
    `_dsp_id_name` AS `dsp_id_name`,
    `_login` AS `login`,
    `_media_formats_list` AS `media_formats_list`,
    `_mobile_caption` AS `mobile_caption`,
    `_mobile_rtb_all_wo_nds` AS `mobile_rtb_all_wo_nds`,
    `_mobile_rtb_bad_win_partner_price_wo_nds` AS `mobile_rtb_bad_win_partner_price_wo_nds`,
    `_mobile_rtb_bad_win_price_wo_nds` AS `mobile_rtb_bad_win_price_wo_nds`,
    `_mobile_rtb_block_all_hits` AS `mobile_rtb_block_all_hits`,
    `_mobile_rtb_block_bad_shows` AS `mobile_rtb_block_bad_shows`,
    `_mobile_rtb_block_bad_shows_own_adv` AS `mobile_rtb_block_bad_shows_own_adv`,
    `_mobile_rtb_block_bad_shows_percent` AS `mobile_rtb_block_bad_shows_percent`,
    `_mobile_rtb_block_bad_win_hits` AS `mobile_rtb_block_bad_win_hits`,
    `_mobile_rtb_block_bad_win_hits_own_adv` AS `mobile_rtb_block_bad_win_hits_own_adv`,
    `_mobile_rtb_block_bad_win_hits_percent` AS `mobile_rtb_block_bad_win_hits_percent`,
    `_mobile_rtb_block_bad_win_hits_unsold` AS `mobile_rtb_block_bad_win_hits_unsold`,
    `_mobile_rtb_block_cover_ratio` AS `mobile_rtb_block_cover_ratio`,
    `_mobile_rtb_block_cpm_all_wo_nds` AS `mobile_rtb_block_cpm_all_wo_nds`,
    `_mobile_rtb_block_cpm_partner_wo_nds` AS `mobile_rtb_block_cpm_partner_wo_nds`,
    `_mobile_rtb_block_cpmh_all_wo_nds` AS `mobile_rtb_block_cpmh_all_wo_nds`,
    `_mobile_rtb_block_cpmh_partner_wo_nds` AS `mobile_rtb_block_cpmh_partner_wo_nds`,
    `_mobile_rtb_block_direct_clicks` AS `mobile_rtb_block_direct_clicks`,
    `_mobile_rtb_block_direct_ctr` AS `mobile_rtb_block_direct_ctr`,
    `_mobile_rtb_block_direct_shows` AS `mobile_rtb_block_direct_shows`,
    `_mobile_rtb_block_hits` AS `mobile_rtb_block_hits`,
    `_mobile_rtb_block_hits_own_adv` AS `mobile_rtb_block_hits_own_adv`,
    `_mobile_rtb_block_hits_unsold` AS `mobile_rtb_block_hits_unsold`,
    `_mobile_rtb_block_rpm_all_wo_nds` AS `mobile_rtb_block_rpm_all_wo_nds`,
    `_mobile_rtb_block_rpm_partner_wo_nds` AS `mobile_rtb_block_rpm_partner_wo_nds`,
    `_mobile_rtb_block_shows` AS `mobile_rtb_block_shows`,
    `_mobile_rtb_block_shows_own_adv` AS `mobile_rtb_block_shows_own_adv`,
    `_mobile_rtb_block_visibility` AS `mobile_rtb_block_visibility`,
    `_mobile_rtb_block_winrate` AS `mobile_rtb_block_winrate`,
    `_mobile_rtb_partner_wo_nds` AS `mobile_rtb_partner_wo_nds`,
    `_page_id` AS `page_id`,
    `_page_public_id` AS `page_public_id`,
    `_percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds` AS `percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`,
    `_percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds` AS `percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`,
    `_public_id` AS `public_id`,
    `_store_id` AS `store_id`,
    `_tag_caption` AS `tag_caption`,
    `_tag_id` AS `tag_id`
FROM (
    SELECT
        dictGetUInt8('blocks_dict', 'adfox_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_adfox_block`,
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_application_id`,
        transform(dictGetString('blocks_dict', 'mobile_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))), ['banner', 'interstitial', 'rewarded', 'adaptive_banner', 'native'], ['block_type_banner', 'block_type_interstitial', 'block_type_rewarded', 'block_type_adaptive_banner', 'block_type_native']) AS `_block_type_label`,
        dictGetString('blocks_dict', 'caption', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_caption`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetString('blocks_dict', 'direct_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_direct_block`,
        dictGetStringOrDefault('dsps_dict', 'short_caption', toUInt64(`dsp_id`), concat('DSP #', toString(`dsp_id`))) AS `_dsp_caption`,
        `dsp_id` AS `_dsp_id_name`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        dictGetString('blocks_dict', 'media_formats_list', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_media_formats_list`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_mobile_caption`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'mobile_app_rtb') AS `_mobile_rtb_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )))) AS `_mobile_rtb_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )))) AS `_mobile_rtb_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / sumIf(`hits`, `product_id` = 'mobile_app_rtb')) AS `_mobile_rtb_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'mobile_app_rtb')) AS `_mobile_rtb_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'mobile_app_rtb') AS `_mobile_rtb_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'mobile_app_rtb')), 2) AS `_mobile_rtb_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'mobile_app_rtb')), 2) AS `_mobile_rtb_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'mobile_app_rtb'
        ))) AS `_mobile_rtb_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'mobile_app_rtb'
            )))) AS `_mobile_rtb_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_partner_wo_nds`,
        `page_id` AS `_page_id`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_page_public_id`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb'))) AS `_percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb'))) AS `_percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`,
        concat(transform(toString(`product_id`), ['mobile_app_rtb'], ['R-M-']), toString(`page_id`), '-', toString(`block_id`)) AS `_public_id`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_store_id`,
        dictGetStringOrDefault('block_tags_dict', 'caption', tuple(toUInt32(`page_id`), toUInt64(`tag_id`)), concat('Slice #', toString(`tag_id`))) AS `_tag_caption`,
        `tag_id` AS `_tag_id`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('mobile_app_rtb')
        AND (
            `page_id` IN ('context_page_id__from_table__mobile_app_settings__with_filter__["AND",[["owner_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"login\\",\\"=\\",\\"mock__login\\"]]]"]]]]')
        )
        AND (
            `page_id` IN ('context_page_id__from_table__mobile_app_settings__with_filter__["AND",[["owner_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"client_id\\",\\"=\\",\\"mock__application.owner.client_id\\"]]]"]]]]')
        )
        AND (
            `page_id` IN ('context_page_id__from_table__mobile_app_settings__with_filter__["AND",[["owner_id","= ANY",["id__from_table__users__with_filter__[\\"OR\\",[[\\"is_efir_blogger\\",\\"=\\",1],[\\"is_video_blogger\\",\\"=\\",1],[\\"is_tutby\\",\\"=\\",1],[\\"is_adfox_partner\\",\\"=\\",1],[\\"is_mobile_mediation\\",\\"=\\",1],[\\"is_games\\",\\"=\\",1]]]"]]]]')
        )
        AND (
            `page_id` = 'mock__page_id'
        )
        AND (
            `page_id` IN ('context_page_id__from_table__mobile_app_settings__with_filter__["AND",[["application_id","= ANY",["id__from_table__mobile_app__with_filter__[\\"AND\\",[[\\"store_id\\",\\"=\\",\\"mock__application.application.store_id\\"]]]"]]]]')
        )
        AND (
            `page_id` IN ('context_page_id__from_table__mobile_app_settings__with_filter__["AND",[["application_id","= ANY",["id__from_table__mobile_app__with_filter__[\\"AND\\",[[\\"type\\",\\"=\\",[\\"1\\",\\"2\\"]]]]"]]]]')
        )
        AND (
            `page_id` IN ('context_page_id__from_table__mobile_app_settings__with_filter__["AND",[["application_id","=","mock__application.application_id"]]]')
        )
        AND (
            dictGetString('blocks_dict', 'mobile_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) IN ('adaptive_banner', 'banner', 'interstitial', 'native', 'rewarded')
        )
        AND (
            `block_id` = 1
        )
        AND (
            dictGetString('blocks_dict', 'caption', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 'mock__caption'
        )
        AND (
            dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) IN ('mock_multistate')
        )
        AND (
            dictGetUInt8('blocks_dict', 'adfox_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 0
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
        AND `dsp_id` = 'mock__dsp_id_name'
        AND `dsp_id` = 'mock__dsp_caption'
        AND `tag_id` = 'mock__tag_id'
        AND `page_id` = 'mock__mobile_caption'
    )
    GROUP BY `_adfox_block`, `_application_id`, `_block_type_label`, `_caption`, `_currency_id`, `_date`, `_direct_block`, `_dsp_caption`, `_dsp_id_name`, `_login`, `_media_formats_list`, `_mobile_caption`, `_page_id`, `_page_public_id`, `_public_id`, `_store_id`, `_tag_caption`, `_tag_id`
) `statistics`
WHERE (
    (if(isNaN(`mobile_rtb_block_cpmh_all_wo_nds`), 0, `mobile_rtb_block_cpmh_all_wo_nds`) + if(isNaN(`mobile_rtb_bad_win_partner_price_wo_nds`), 0, `mobile_rtb_bad_win_partner_price_wo_nds`) + if(isNaN(`mobile_rtb_partner_wo_nds`), 0, `mobile_rtb_partner_wo_nds`) + if(isNaN(`mobile_rtb_block_bad_win_hits`), 0, `mobile_rtb_block_bad_win_hits`) + if(isNaN(`mobile_rtb_block_bad_shows`), 0, `mobile_rtb_block_bad_shows`) + if(isNaN(`mobile_rtb_block_all_hits`), 0, `mobile_rtb_block_all_hits`) + if(isNaN(`mobile_rtb_block_bad_shows_percent`), 0, `mobile_rtb_block_bad_shows_percent`) + if(isNaN(`mobile_rtb_block_bad_win_hits_percent`), 0, `mobile_rtb_block_bad_win_hits_percent`) + if(isNaN(`mobile_rtb_block_shows`), 0, `mobile_rtb_block_shows`) + if(isNaN(`mobile_rtb_block_bad_win_hits_unsold`), 0, `mobile_rtb_block_bad_win_hits_unsold`) + if(isNaN(`mobile_rtb_block_rpm_partner_wo_nds`), 0, `mobile_rtb_block_rpm_partner_wo_nds`) + if(isNaN(`mobile_rtb_block_cover_ratio`), 0, `mobile_rtb_block_cover_ratio`) + if(isNaN(`mobile_rtb_block_bad_shows_own_adv`), 0, `mobile_rtb_block_bad_shows_own_adv`) + if(isNaN(`mobile_rtb_block_direct_ctr`), 0, `mobile_rtb_block_direct_ctr`) + if(isNaN(`mobile_rtb_block_bad_win_hits_own_adv`), 0, `mobile_rtb_block_bad_win_hits_own_adv`) + if(isNaN(`mobile_rtb_block_hits_unsold`), 0, `mobile_rtb_block_hits_unsold`) + if(isNaN(`mobile_rtb_block_shows_own_adv`), 0, `mobile_rtb_block_shows_own_adv`) + if(isNaN(`mobile_rtb_block_visibility`), 0, `mobile_rtb_block_visibility`) + if(isNaN(`mobile_rtb_block_winrate`), 0, `mobile_rtb_block_winrate`) + if(isNaN(`mobile_rtb_block_rpm_all_wo_nds`), 0, `mobile_rtb_block_rpm_all_wo_nds`) + if(isNaN(`percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`), 0, `percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`) + if(isNaN(`percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`), 0, `percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`) + if(isNaN(`mobile_rtb_bad_win_price_wo_nds`), 0, `mobile_rtb_bad_win_price_wo_nds`) + if(isNaN(`mobile_rtb_block_cpm_all_wo_nds`), 0, `mobile_rtb_block_cpm_all_wo_nds`) + if(isNaN(`mobile_rtb_block_hits`), 0, `mobile_rtb_block_hits`) + if(isNaN(`mobile_rtb_block_direct_clicks`), 0, `mobile_rtb_block_direct_clicks`) + if(isNaN(`mobile_rtb_block_cpm_partner_wo_nds`), 0, `mobile_rtb_block_cpm_partner_wo_nds`) + if(isNaN(`mobile_rtb_block_direct_shows`), 0, `mobile_rtb_block_direct_shows`) + if(isNaN(`mobile_rtb_block_hits_own_adv`), 0, `mobile_rtb_block_hits_own_adv`) + if(isNaN(`mobile_rtb_block_cpmh_partner_wo_nds`), 0, `mobile_rtb_block_cpmh_partner_wo_nds`) + if(isNaN(`mobile_rtb_all_wo_nds`), 0, `mobile_rtb_all_wo_nds`)) > 0
) FORMAT JSONCompact
