SELECT
    `_application_id` AS `application_id`,
    `_block_type_label` AS `block_type_label`,
    `_caption` AS `caption`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_geo_name` AS `geo_name`,
    `_login` AS `login`,
    `_mobile_caption` AS `mobile_caption`,
    `_mobile_mediation_block_calculated_revenue` AS `mobile_mediation_block_calculated_revenue`,
    `_mobile_mediation_block_calculated_revenue_original` AS `mobile_mediation_block_calculated_revenue_original`,
    `_mobile_mediation_block_hits` AS `mobile_mediation_block_hits`,
    `_mobile_mediation_block_impressions` AS `mobile_mediation_block_impressions`,
    `_mobile_mediation_block_visibility` AS `mobile_mediation_block_visibility`,
    `_monetizer_caption` AS `monetizer_caption`,
    `_page_id` AS `page_id`,
    `_page_public_id` AS `page_public_id`,
    `_place_id` AS `place_id`,
    `_public_id` AS `public_id`,
    `_store_id` AS `store_id`
FROM (
    SELECT
        dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) AS `_application_id`,
        transform(dictGetString('blocks_dict', 'mobile_block_type', tuple('mobile_app_rtb', toUInt32(`page_id`), toUInt32(`block_id`))), ['banner', 'interstitial', 'rewarded', 'adaptive_banner', 'native'], ['block_type_banner', 'block_type_interstitial', 'block_type_rewarded', 'block_type_adaptive_banner', 'block_type_native']) AS `_block_type_label`,
        dictGetString('blocks_dict', 'caption', tuple('mobile_app_rtb', toUInt32(`page_id`), toUInt32(`block_id`))) AS `_caption`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        if(`geo_id` = 0, 'All world', regionToName(toUInt32(`geo_id`))) AS `_geo_name`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_mobile_caption`,
        round(sumIf((`calculated_revenue` / 10000000000), `product_id` = 'mobile_mediation_block'), 2) AS `_mobile_mediation_block_calculated_revenue`,
        round((sumIf((`calculated_revenue_original` / 1000), `product_id` = 'mobile_mediation_block') / 10000000), 2) AS `_mobile_mediation_block_calculated_revenue_original`,
        sumIf(`hits`, `product_id` = 'mobile_mediation_block') AS `_mobile_mediation_block_hits`,
        sumIf(`impressions`, `product_id` = 'mobile_mediation_block') AS `_mobile_mediation_block_impressions`,
        ((sumIf(`impressions`, `product_id` = 'mobile_mediation_block') * 100) / sumIf(`hits`, `product_id` = 'mobile_mediation_block')) AS `_mobile_mediation_block_visibility`,
        dictGetStringOrDefault('monetizers_dict', 'caption', toUInt64(`monetizer_id`), concat('Monetizer #', toString(`monetizer_id`))) AS `_monetizer_caption`,
        `page_id` AS `_page_id`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_page_public_id`,
        dictGetUInt32('blocks_dict', 'place_id', tuple('mobile_app_rtb', toUInt32(`page_id`), toUInt32(`block_id`))) AS `_place_id`,
        concat(transform(toString(`product_id`), ['mobile_mediation_block'], ['R-M-']), toString(`page_id`), '-', toString(`block_id`)) AS `_public_id`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_store_id`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('mobile_mediation_block')
        AND (
            `page_id` IN ('context_page_id__from_table__mobile_app_settings__with_filter__["AND",[["owner_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"login\\",\\"=\\",\\"mock__login\\"]]]"]]]]')
        )
        AND (
            `page_id` IN ('context_page_id__from_table__mobile_app_settings__with_filter__["AND",[["owner_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"client_id\\",\\"=\\",\\"mock__client_id\\"]]]"]]]]')
        )
        AND (
            `page_id` IN ('context_page_id__from_table__mobile_app_settings__with_filter__["AND",[["owner_id","= ANY",["id__from_table__users__with_filter__[\\"OR\\",[[\\"is_efir_blogger\\",\\"=\\",1],[\\"is_video_blogger\\",\\"=\\",1],[\\"is_tutby\\",\\"=\\",1],[\\"is_adfox_partner\\",\\"=\\",1],[\\"is_mobile_mediation\\",\\"=\\",1],[\\"is_games\\",\\"=\\",1]]]"]]]]')
        )
        AND (
            `page_id` IN ('context_page_id__from_table__mobile_app_settings__with_filter__["AND",[["application_id","=","mock__application_id"]]]')
        )
        AND (
            `page_id` IN ('context_page_id__from_table__mobile_app_settings__with_filter__["AND",[["caption","=","mock__page_caption"]]]')
        )
        AND (
            `page_id` IN ('context_page_id__from_table__mobile_app_settings__with_filter__["AND",[["application_id","= ANY",["id__from_table__mobile_app__with_filter__[\\"AND\\",[[\\"type\\",\\"=\\",[\\"1\\",\\"2\\"]]]]"]]]]')
        )
        AND (
            `page_id` IN ('context_page_id__from_table__mobile_app_settings__with_filter__["AND",[["application_id","= ANY",["id__from_table__mobile_app__with_filter__[\\"AND\\",[[\\"store_id\\",\\"=\\",\\"mock__store_id\\"]]]"]]]]')
        )
        AND (
            dictGetUInt32('blocks_dict', 'place_id', tuple('mobile_app_rtb', toUInt32(`page_id`), toUInt32(`block_id`))) = 'mock__place_id'
        )
        AND (
            dictGetString('blocks_dict', 'caption', tuple('mobile_app_rtb', toUInt32(`page_id`), toUInt32(`block_id`))) = 'mock__caption'
        )
        AND (
            dictGetString('blocks_dict', 'mobile_block_type', tuple('mobile_app_rtb', toUInt32(`page_id`), toUInt32(`block_id`))) IN ('adaptive_banner', 'banner', 'interstitial', 'native', 'rewarded')
        )
        AND (
            `page_id` = 'mock__page_id'
        )
        AND (
            `block_id` = 1
        )
        AND (
            dictGetUInt64('blocks_dict', 'multistate', tuple('mobile_app_rtb', toUInt32(`page_id`), toUInt32(`block_id`))) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
        AND `page_id` = 'mock__mobile_caption'
        AND `monetizer_id` = 'mock__monetizer_caption'
    )
    GROUP BY `_application_id`, `_block_type_label`, `_caption`, `_currency_id`, `_date`, `_geo_name`, `_login`, `_mobile_caption`, `_monetizer_caption`, `_page_id`, `_page_public_id`, `_place_id`, `_public_id`, `_store_id`
) `statistics`
WHERE (
    (if(isNaN(`mobile_mediation_block_calculated_revenue`), 0, `mobile_mediation_block_calculated_revenue`) + if(isNaN(`mobile_mediation_block_impressions`), 0, `mobile_mediation_block_impressions`) + if(isNaN(`mobile_mediation_block_calculated_revenue_original`), 0, `mobile_mediation_block_calculated_revenue_original`) + if(isNaN(`mobile_mediation_block_hits`), 0, `mobile_mediation_block_hits`) + if(isNaN(`mobile_mediation_block_visibility`), 0, `mobile_mediation_block_visibility`)) > 0
) FORMAT JSONCompact
