SELECT
    `_adblock_all_wo_nds` AS `adblock_all_wo_nds`,
    `_adblock_block_all_hits` AS `adblock_block_all_hits`,
    `_adblock_block_cover_ratio` AS `adblock_block_cover_ratio`,
    `_adblock_block_cpm_all_wo_nds` AS `adblock_block_cpm_all_wo_nds`,
    `_adblock_block_cpm_partner_wo_nds` AS `adblock_block_cpm_partner_wo_nds`,
    `_adblock_block_cpmh_all_wo_nds` AS `adblock_block_cpmh_all_wo_nds`,
    `_adblock_block_cpmh_partner_wo_nds` AS `adblock_block_cpmh_partner_wo_nds`,
    `_adblock_block_hits` AS `adblock_block_hits`,
    `_adblock_block_hits_own_adv` AS `adblock_block_hits_own_adv`,
    `_adblock_block_hits_unsold` AS `adblock_block_hits_unsold`,
    `_adblock_block_rpm_all_wo_nds` AS `adblock_block_rpm_all_wo_nds`,
    `_adblock_block_rpm_partner_wo_nds` AS `adblock_block_rpm_partner_wo_nds`,
    `_adblock_block_shows` AS `adblock_block_shows`,
    `_adblock_block_shows_own_adv` AS `adblock_block_shows_own_adv`,
    `_adblock_block_visibility` AS `adblock_block_visibility`,
    `_adblock_block_winrate` AS `adblock_block_winrate`,
    `_adblock_partner_wo_nds` AS `adblock_partner_wo_nds`,
    `_adfox_block` AS `adfox_block`,
    `_all_wo_nds` AS `all_wo_nds`,
    `_bad_win_partner_price_wo_nds` AS `bad_win_partner_price_wo_nds`,
    `_bad_win_price_wo_nds` AS `bad_win_price_wo_nds`,
    `_content_all_wo_nds` AS `content_all_wo_nds`,
    `_content_bad_win_partner_price_wo_nds` AS `content_bad_win_partner_price_wo_nds`,
    `_content_bad_win_price_wo_nds` AS `content_bad_win_price_wo_nds`,
    `_content_block_all_hits` AS `content_block_all_hits`,
    `_content_block_bad_shows` AS `content_block_bad_shows`,
    `_content_block_bad_shows_own_adv` AS `content_block_bad_shows_own_adv`,
    `_content_block_bad_shows_percent` AS `content_block_bad_shows_percent`,
    `_content_block_bad_win_hits` AS `content_block_bad_win_hits`,
    `_content_block_bad_win_hits_own_adv` AS `content_block_bad_win_hits_own_adv`,
    `_content_block_bad_win_hits_percent` AS `content_block_bad_win_hits_percent`,
    `_content_block_bad_win_hits_unsold` AS `content_block_bad_win_hits_unsold`,
    `_content_block_cover_ratio` AS `content_block_cover_ratio`,
    `_content_block_cpm_all_wo_nds` AS `content_block_cpm_all_wo_nds`,
    `_content_block_cpm_partner_wo_nds` AS `content_block_cpm_partner_wo_nds`,
    `_content_block_cpmh_all_wo_nds` AS `content_block_cpmh_all_wo_nds`,
    `_content_block_cpmh_partner_wo_nds` AS `content_block_cpmh_partner_wo_nds`,
    `_content_block_direct_clicks` AS `content_block_direct_clicks`,
    `_content_block_direct_ctr` AS `content_block_direct_ctr`,
    `_content_block_direct_shows` AS `content_block_direct_shows`,
    `_content_block_hits` AS `content_block_hits`,
    `_content_block_hits_own_adv` AS `content_block_hits_own_adv`,
    `_content_block_hits_unsold` AS `content_block_hits_unsold`,
    `_content_block_rpm_all_wo_nds` AS `content_block_rpm_all_wo_nds`,
    `_content_block_rpm_partner_wo_nds` AS `content_block_rpm_partner_wo_nds`,
    `_content_block_shows` AS `content_block_shows`,
    `_content_block_shows_own_adv` AS `content_block_shows_own_adv`,
    `_content_block_visibility` AS `content_block_visibility`,
    `_content_block_winrate` AS `content_block_winrate`,
    `_content_partner_wo_nds` AS `content_partner_wo_nds`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_direct_context_all_wo_nds` AS `direct_context_all_wo_nds`,
    `_direct_context_clicks` AS `direct_context_clicks`,
    `_direct_context_cpc_direct_context_all_wo_nds` AS `direct_context_cpc_direct_context_all_wo_nds`,
    `_direct_context_cpc_direct_context_partner_wo_nds` AS `direct_context_cpc_direct_context_partner_wo_nds`,
    `_direct_context_cpm_direct_context_all_wo_nds` AS `direct_context_cpm_direct_context_all_wo_nds`,
    `_direct_context_cpm_direct_context_partner_wo_nds` AS `direct_context_cpm_direct_context_partner_wo_nds`,
    `_direct_context_ctr` AS `direct_context_ctr`,
    `_direct_context_partner_wo_nds` AS `direct_context_partner_wo_nds`,
    `_direct_context_shows` AS `direct_context_shows`,
    `_direct_search_all_wo_nds` AS `direct_search_all_wo_nds`,
    `_direct_search_clicks` AS `direct_search_clicks`,
    `_direct_search_cpc_direct_search_all_wo_nds` AS `direct_search_cpc_direct_search_all_wo_nds`,
    `_direct_search_cpc_direct_search_partner_wo_nds` AS `direct_search_cpc_direct_search_partner_wo_nds`,
    `_direct_search_cpm_direct_search_all_wo_nds` AS `direct_search_cpm_direct_search_all_wo_nds`,
    `_direct_search_cpm_direct_search_partner_wo_nds` AS `direct_search_cpm_direct_search_partner_wo_nds`,
    `_direct_search_ctr` AS `direct_search_ctr`,
    `_direct_search_partner_wo_nds` AS `direct_search_partner_wo_nds`,
    `_direct_search_shows` AS `direct_search_shows`,
    `_fullscreen_all_wo_nds` AS `fullscreen_all_wo_nds`,
    `_fullscreen_block_all_hits` AS `fullscreen_block_all_hits`,
    `_fullscreen_block_bad_shows` AS `fullscreen_block_bad_shows`,
    `_fullscreen_block_bad_shows_own_adv` AS `fullscreen_block_bad_shows_own_adv`,
    `_fullscreen_block_bad_shows_percent` AS `fullscreen_block_bad_shows_percent`,
    `_fullscreen_block_bad_win_hits` AS `fullscreen_block_bad_win_hits`,
    `_fullscreen_block_bad_win_hits_own_adv` AS `fullscreen_block_bad_win_hits_own_adv`,
    `_fullscreen_block_bad_win_hits_percent` AS `fullscreen_block_bad_win_hits_percent`,
    `_fullscreen_block_bad_win_hits_unsold` AS `fullscreen_block_bad_win_hits_unsold`,
    `_fullscreen_block_cover_ratio` AS `fullscreen_block_cover_ratio`,
    `_fullscreen_block_cpm_all_wo_nds` AS `fullscreen_block_cpm_all_wo_nds`,
    `_fullscreen_block_cpm_partner_wo_nds` AS `fullscreen_block_cpm_partner_wo_nds`,
    `_fullscreen_block_cpmh_all_wo_nds` AS `fullscreen_block_cpmh_all_wo_nds`,
    `_fullscreen_block_cpmh_partner_wo_nds` AS `fullscreen_block_cpmh_partner_wo_nds`,
    `_fullscreen_block_direct_clicks` AS `fullscreen_block_direct_clicks`,
    `_fullscreen_block_direct_ctr` AS `fullscreen_block_direct_ctr`,
    `_fullscreen_block_direct_shows` AS `fullscreen_block_direct_shows`,
    `_fullscreen_block_hits` AS `fullscreen_block_hits`,
    `_fullscreen_block_hits_own_adv` AS `fullscreen_block_hits_own_adv`,
    `_fullscreen_block_hits_unsold` AS `fullscreen_block_hits_unsold`,
    `_fullscreen_block_shows` AS `fullscreen_block_shows`,
    `_fullscreen_block_shows_own_adv` AS `fullscreen_block_shows_own_adv`,
    `_fullscreen_block_visibility` AS `fullscreen_block_visibility`,
    `_fullscreen_block_winrate` AS `fullscreen_block_winrate`,
    `_fullscreen_partner_wo_nds` AS `fullscreen_partner_wo_nds`,
    `_indoor_all_wo_nds` AS `indoor_all_wo_nds`,
    `_indoor_block_all_hits` AS `indoor_block_all_hits`,
    `_indoor_block_bad_shows` AS `indoor_block_bad_shows`,
    `_indoor_block_bad_shows_own_adv` AS `indoor_block_bad_shows_own_adv`,
    `_indoor_block_bad_shows_percent` AS `indoor_block_bad_shows_percent`,
    `_indoor_block_bad_win_hits` AS `indoor_block_bad_win_hits`,
    `_indoor_block_bad_win_hits_own_adv` AS `indoor_block_bad_win_hits_own_adv`,
    `_indoor_block_bad_win_hits_percent` AS `indoor_block_bad_win_hits_percent`,
    `_indoor_block_bad_win_hits_unsold` AS `indoor_block_bad_win_hits_unsold`,
    `_indoor_block_cover_ratio` AS `indoor_block_cover_ratio`,
    `_indoor_block_cpm_all_wo_nds` AS `indoor_block_cpm_all_wo_nds`,
    `_indoor_block_cpm_partner_wo_nds` AS `indoor_block_cpm_partner_wo_nds`,
    `_indoor_block_cpmh_all_wo_nds` AS `indoor_block_cpmh_all_wo_nds`,
    `_indoor_block_cpmh_partner_wo_nds` AS `indoor_block_cpmh_partner_wo_nds`,
    `_indoor_block_direct_clicks` AS `indoor_block_direct_clicks`,
    `_indoor_block_direct_ctr` AS `indoor_block_direct_ctr`,
    `_indoor_block_direct_shows` AS `indoor_block_direct_shows`,
    `_indoor_block_hits` AS `indoor_block_hits`,
    `_indoor_block_hits_own_adv` AS `indoor_block_hits_own_adv`,
    `_indoor_block_hits_unsold` AS `indoor_block_hits_unsold`,
    `_indoor_block_shows` AS `indoor_block_shows`,
    `_indoor_block_shows_own_adv` AS `indoor_block_shows_own_adv`,
    `_indoor_block_visibility` AS `indoor_block_visibility`,
    `_indoor_block_winrate` AS `indoor_block_winrate`,
    `_indoor_partner_wo_nds` AS `indoor_partner_wo_nds`,
    `_inpage_all_wo_nds` AS `inpage_all_wo_nds`,
    `_inpage_block_all_hits` AS `inpage_block_all_hits`,
    `_inpage_block_bad_shows` AS `inpage_block_bad_shows`,
    `_inpage_block_bad_shows_own_adv` AS `inpage_block_bad_shows_own_adv`,
    `_inpage_block_bad_shows_percent` AS `inpage_block_bad_shows_percent`,
    `_inpage_block_bad_win_hits` AS `inpage_block_bad_win_hits`,
    `_inpage_block_bad_win_hits_own_adv` AS `inpage_block_bad_win_hits_own_adv`,
    `_inpage_block_bad_win_hits_percent` AS `inpage_block_bad_win_hits_percent`,
    `_inpage_block_bad_win_hits_unsold` AS `inpage_block_bad_win_hits_unsold`,
    `_inpage_block_cover_ratio` AS `inpage_block_cover_ratio`,
    `_inpage_block_cpm_all_wo_nds` AS `inpage_block_cpm_all_wo_nds`,
    `_inpage_block_cpm_partner_wo_nds` AS `inpage_block_cpm_partner_wo_nds`,
    `_inpage_block_cpmh_all_wo_nds` AS `inpage_block_cpmh_all_wo_nds`,
    `_inpage_block_cpmh_partner_wo_nds` AS `inpage_block_cpmh_partner_wo_nds`,
    `_inpage_block_direct_clicks` AS `inpage_block_direct_clicks`,
    `_inpage_block_direct_ctr` AS `inpage_block_direct_ctr`,
    `_inpage_block_direct_shows` AS `inpage_block_direct_shows`,
    `_inpage_block_hits` AS `inpage_block_hits`,
    `_inpage_block_hits_own_adv` AS `inpage_block_hits_own_adv`,
    `_inpage_block_hits_unsold` AS `inpage_block_hits_unsold`,
    `_inpage_block_shows` AS `inpage_block_shows`,
    `_inpage_block_shows_own_adv` AS `inpage_block_shows_own_adv`,
    `_inpage_block_visibility` AS `inpage_block_visibility`,
    `_inpage_block_winrate` AS `inpage_block_winrate`,
    `_inpage_partner_wo_nds` AS `inpage_partner_wo_nds`,
    `_instream_all_wo_nds` AS `instream_all_wo_nds`,
    `_instream_block_all_hits` AS `instream_block_all_hits`,
    `_instream_block_bad_shows` AS `instream_block_bad_shows`,
    `_instream_block_bad_shows_own_adv` AS `instream_block_bad_shows_own_adv`,
    `_instream_block_bad_shows_percent` AS `instream_block_bad_shows_percent`,
    `_instream_block_bad_win_hits` AS `instream_block_bad_win_hits`,
    `_instream_block_bad_win_hits_own_adv` AS `instream_block_bad_win_hits_own_adv`,
    `_instream_block_bad_win_hits_percent` AS `instream_block_bad_win_hits_percent`,
    `_instream_block_bad_win_hits_unsold` AS `instream_block_bad_win_hits_unsold`,
    `_instream_block_cover_ratio` AS `instream_block_cover_ratio`,
    `_instream_block_cpm_all_wo_nds` AS `instream_block_cpm_all_wo_nds`,
    `_instream_block_cpm_partner_wo_nds` AS `instream_block_cpm_partner_wo_nds`,
    `_instream_block_cpmh_all_wo_nds` AS `instream_block_cpmh_all_wo_nds`,
    `_instream_block_cpmh_partner_wo_nds` AS `instream_block_cpmh_partner_wo_nds`,
    `_instream_block_direct_clicks` AS `instream_block_direct_clicks`,
    `_instream_block_direct_ctr` AS `instream_block_direct_ctr`,
    `_instream_block_direct_shows` AS `instream_block_direct_shows`,
    `_instream_block_hits` AS `instream_block_hits`,
    `_instream_block_hits_own_adv` AS `instream_block_hits_own_adv`,
    `_instream_block_hits_unsold` AS `instream_block_hits_unsold`,
    `_instream_block_shows` AS `instream_block_shows`,
    `_instream_block_shows_own_adv` AS `instream_block_shows_own_adv`,
    `_instream_block_visibility` AS `instream_block_visibility`,
    `_instream_block_winrate` AS `instream_block_winrate`,
    `_instream_partner_wo_nds` AS `instream_partner_wo_nds`,
    `_login` AS `login`,
    `_market_api_context_all_wo_nds` AS `market_api_context_all_wo_nds`,
    `_market_api_context_clicks` AS `market_api_context_clicks`,
    `_market_api_context_cpc_market_api_context_all_wo_nds` AS `market_api_context_cpc_market_api_context_all_wo_nds`,
    `_market_api_context_cpc_market_api_context_partner_wo_nds` AS `market_api_context_cpc_market_api_context_partner_wo_nds`,
    `_market_api_context_cpm_market_api_context_all_wo_nds` AS `market_api_context_cpm_market_api_context_all_wo_nds`,
    `_market_api_context_cpm_market_api_context_partner_wo_nds` AS `market_api_context_cpm_market_api_context_partner_wo_nds`,
    `_market_api_context_ctr` AS `market_api_context_ctr`,
    `_market_api_context_partner_wo_nds` AS `market_api_context_partner_wo_nds`,
    `_market_api_context_shows` AS `market_api_context_shows`,
    `_market_api_search_all_wo_nds` AS `market_api_search_all_wo_nds`,
    `_market_api_search_clicks` AS `market_api_search_clicks`,
    `_market_api_search_cpc_market_api_search_all_wo_nds` AS `market_api_search_cpc_market_api_search_all_wo_nds`,
    `_market_api_search_cpc_market_api_search_partner_wo_nds` AS `market_api_search_cpc_market_api_search_partner_wo_nds`,
    `_market_api_search_cpm_market_api_search_all_wo_nds` AS `market_api_search_cpm_market_api_search_all_wo_nds`,
    `_market_api_search_cpm_market_api_search_partner_wo_nds` AS `market_api_search_cpm_market_api_search_partner_wo_nds`,
    `_market_api_search_ctr` AS `market_api_search_ctr`,
    `_market_api_search_partner_wo_nds` AS `market_api_search_partner_wo_nds`,
    `_market_api_search_shows` AS `market_api_search_shows`,
    `_market_context_all_wo_nds` AS `market_context_all_wo_nds`,
    `_market_context_clicks` AS `market_context_clicks`,
    `_market_context_cpc_market_context_all_wo_nds` AS `market_context_cpc_market_context_all_wo_nds`,
    `_market_context_cpc_market_context_partner_wo_nds` AS `market_context_cpc_market_context_partner_wo_nds`,
    `_market_context_cpm_market_context_all_wo_nds` AS `market_context_cpm_market_context_all_wo_nds`,
    `_market_context_cpm_market_context_partner_wo_nds` AS `market_context_cpm_market_context_partner_wo_nds`,
    `_market_context_ctr` AS `market_context_ctr`,
    `_market_context_partner_wo_nds` AS `market_context_partner_wo_nds`,
    `_market_context_shows` AS `market_context_shows`,
    `_market_search_all_wo_nds` AS `market_search_all_wo_nds`,
    `_market_search_clicks` AS `market_search_clicks`,
    `_market_search_cpc_market_search_all_wo_nds` AS `market_search_cpc_market_search_all_wo_nds`,
    `_market_search_cpc_market_search_partner_wo_nds` AS `market_search_cpc_market_search_partner_wo_nds`,
    `_market_search_cpm_market_search_all_wo_nds` AS `market_search_cpm_market_search_all_wo_nds`,
    `_market_search_cpm_market_search_partner_wo_nds` AS `market_search_cpm_market_search_partner_wo_nds`,
    `_market_search_ctr` AS `market_search_ctr`,
    `_market_search_partner_wo_nds` AS `market_search_partner_wo_nds`,
    `_market_search_shows` AS `market_search_shows`,
    `_mcb_context_all_wo_nds` AS `mcb_context_all_wo_nds`,
    `_mcb_context_clicks` AS `mcb_context_clicks`,
    `_mcb_context_cpm_mcb_context_all_wo_nds` AS `mcb_context_cpm_mcb_context_all_wo_nds`,
    `_mcb_context_cpm_mcb_context_partner_wo_nds` AS `mcb_context_cpm_mcb_context_partner_wo_nds`,
    `_mcb_context_ctr` AS `mcb_context_ctr`,
    `_mcb_context_partner_wo_nds` AS `mcb_context_partner_wo_nds`,
    `_mcb_context_shows` AS `mcb_context_shows`,
    `_mcb_search_all_wo_nds` AS `mcb_search_all_wo_nds`,
    `_mcb_search_clicks` AS `mcb_search_clicks`,
    `_mcb_search_cpm_mcb_search_all_wo_nds` AS `mcb_search_cpm_mcb_search_all_wo_nds`,
    `_mcb_search_cpm_mcb_search_partner_wo_nds` AS `mcb_search_cpm_mcb_search_partner_wo_nds`,
    `_mcb_search_ctr` AS `mcb_search_ctr`,
    `_mcb_search_partner_wo_nds` AS `mcb_search_partner_wo_nds`,
    `_mcb_search_shows` AS `mcb_search_shows`,
    `_mobile_rtb_all_wo_nds` AS `mobile_rtb_all_wo_nds`,
    `_mobile_rtb_bad_win_partner_price_wo_nds` AS `mobile_rtb_bad_win_partner_price_wo_nds`,
    `_mobile_rtb_bad_win_price_wo_nds` AS `mobile_rtb_bad_win_price_wo_nds`,
    `_mobile_rtb_block_all_hits` AS `mobile_rtb_block_all_hits`,
    `_mobile_rtb_block_bad_shows` AS `mobile_rtb_block_bad_shows`,
    `_mobile_rtb_block_bad_shows_own_adv` AS `mobile_rtb_block_bad_shows_own_adv`,
    `_mobile_rtb_block_bad_shows_percent` AS `mobile_rtb_block_bad_shows_percent`,
    `_mobile_rtb_block_bad_win_hits` AS `mobile_rtb_block_bad_win_hits`,
    `_mobile_rtb_block_bad_win_hits_own_adv` AS `mobile_rtb_block_bad_win_hits_own_adv`,
    `_mobile_rtb_block_bad_win_hits_percent` AS `mobile_rtb_block_bad_win_hits_percent`,
    `_mobile_rtb_block_bad_win_hits_unsold` AS `mobile_rtb_block_bad_win_hits_unsold`,
    `_mobile_rtb_block_cover_ratio` AS `mobile_rtb_block_cover_ratio`,
    `_mobile_rtb_block_cpm_all_wo_nds` AS `mobile_rtb_block_cpm_all_wo_nds`,
    `_mobile_rtb_block_cpm_partner_wo_nds` AS `mobile_rtb_block_cpm_partner_wo_nds`,
    `_mobile_rtb_block_cpmh_all_wo_nds` AS `mobile_rtb_block_cpmh_all_wo_nds`,
    `_mobile_rtb_block_cpmh_partner_wo_nds` AS `mobile_rtb_block_cpmh_partner_wo_nds`,
    `_mobile_rtb_block_direct_clicks` AS `mobile_rtb_block_direct_clicks`,
    `_mobile_rtb_block_direct_ctr` AS `mobile_rtb_block_direct_ctr`,
    `_mobile_rtb_block_direct_shows` AS `mobile_rtb_block_direct_shows`,
    `_mobile_rtb_block_hits` AS `mobile_rtb_block_hits`,
    `_mobile_rtb_block_hits_own_adv` AS `mobile_rtb_block_hits_own_adv`,
    `_mobile_rtb_block_hits_unsold` AS `mobile_rtb_block_hits_unsold`,
    `_mobile_rtb_block_rpm_all_wo_nds` AS `mobile_rtb_block_rpm_all_wo_nds`,
    `_mobile_rtb_block_rpm_partner_wo_nds` AS `mobile_rtb_block_rpm_partner_wo_nds`,
    `_mobile_rtb_block_shows` AS `mobile_rtb_block_shows`,
    `_mobile_rtb_block_shows_own_adv` AS `mobile_rtb_block_shows_own_adv`,
    `_mobile_rtb_block_visibility` AS `mobile_rtb_block_visibility`,
    `_mobile_rtb_block_winrate` AS `mobile_rtb_block_winrate`,
    `_mobile_rtb_partner_wo_nds` AS `mobile_rtb_partner_wo_nds`,
    `_natural_all_wo_nds` AS `natural_all_wo_nds`,
    `_natural_bad_win_partner_price_wo_nds` AS `natural_bad_win_partner_price_wo_nds`,
    `_natural_bad_win_price_wo_nds` AS `natural_bad_win_price_wo_nds`,
    `_natural_block_all_hits` AS `natural_block_all_hits`,
    `_natural_block_bad_shows` AS `natural_block_bad_shows`,
    `_natural_block_bad_shows_own_adv` AS `natural_block_bad_shows_own_adv`,
    `_natural_block_bad_shows_percent` AS `natural_block_bad_shows_percent`,
    `_natural_block_bad_win_hits` AS `natural_block_bad_win_hits`,
    `_natural_block_bad_win_hits_own_adv` AS `natural_block_bad_win_hits_own_adv`,
    `_natural_block_bad_win_hits_percent` AS `natural_block_bad_win_hits_percent`,
    `_natural_block_bad_win_hits_unsold` AS `natural_block_bad_win_hits_unsold`,
    `_natural_block_cover_ratio` AS `natural_block_cover_ratio`,
    `_natural_block_cpm_all_wo_nds` AS `natural_block_cpm_all_wo_nds`,
    `_natural_block_cpm_partner_wo_nds` AS `natural_block_cpm_partner_wo_nds`,
    `_natural_block_cpmh_all_wo_nds` AS `natural_block_cpmh_all_wo_nds`,
    `_natural_block_cpmh_partner_wo_nds` AS `natural_block_cpmh_partner_wo_nds`,
    `_natural_block_direct_clicks` AS `natural_block_direct_clicks`,
    `_natural_block_direct_ctr` AS `natural_block_direct_ctr`,
    `_natural_block_direct_shows` AS `natural_block_direct_shows`,
    `_natural_block_hits` AS `natural_block_hits`,
    `_natural_block_hits_own_adv` AS `natural_block_hits_own_adv`,
    `_natural_block_hits_unsold` AS `natural_block_hits_unsold`,
    `_natural_block_rpm_all_wo_nds` AS `natural_block_rpm_all_wo_nds`,
    `_natural_block_rpm_partner_wo_nds` AS `natural_block_rpm_partner_wo_nds`,
    `_natural_block_shows` AS `natural_block_shows`,
    `_natural_block_shows_own_adv` AS `natural_block_shows_own_adv`,
    `_natural_block_visibility` AS `natural_block_visibility`,
    `_natural_block_winrate` AS `natural_block_winrate`,
    `_natural_partner_wo_nds` AS `natural_partner_wo_nds`,
    `_outdoor_all_wo_nds` AS `outdoor_all_wo_nds`,
    `_outdoor_block_all_hits` AS `outdoor_block_all_hits`,
    `_outdoor_block_bad_shows` AS `outdoor_block_bad_shows`,
    `_outdoor_block_bad_shows_own_adv` AS `outdoor_block_bad_shows_own_adv`,
    `_outdoor_block_bad_shows_percent` AS `outdoor_block_bad_shows_percent`,
    `_outdoor_block_bad_win_hits` AS `outdoor_block_bad_win_hits`,
    `_outdoor_block_bad_win_hits_own_adv` AS `outdoor_block_bad_win_hits_own_adv`,
    `_outdoor_block_bad_win_hits_percent` AS `outdoor_block_bad_win_hits_percent`,
    `_outdoor_block_bad_win_hits_unsold` AS `outdoor_block_bad_win_hits_unsold`,
    `_outdoor_block_cover_ratio` AS `outdoor_block_cover_ratio`,
    `_outdoor_block_cpm_all_wo_nds` AS `outdoor_block_cpm_all_wo_nds`,
    `_outdoor_block_cpm_partner_wo_nds` AS `outdoor_block_cpm_partner_wo_nds`,
    `_outdoor_block_cpmh_all_wo_nds` AS `outdoor_block_cpmh_all_wo_nds`,
    `_outdoor_block_cpmh_partner_wo_nds` AS `outdoor_block_cpmh_partner_wo_nds`,
    `_outdoor_block_direct_clicks` AS `outdoor_block_direct_clicks`,
    `_outdoor_block_direct_ctr` AS `outdoor_block_direct_ctr`,
    `_outdoor_block_direct_shows` AS `outdoor_block_direct_shows`,
    `_outdoor_block_hits` AS `outdoor_block_hits`,
    `_outdoor_block_hits_own_adv` AS `outdoor_block_hits_own_adv`,
    `_outdoor_block_hits_unsold` AS `outdoor_block_hits_unsold`,
    `_outdoor_block_shows` AS `outdoor_block_shows`,
    `_outdoor_block_shows_own_adv` AS `outdoor_block_shows_own_adv`,
    `_outdoor_block_visibility` AS `outdoor_block_visibility`,
    `_outdoor_block_winrate` AS `outdoor_block_winrate`,
    `_outdoor_partner_wo_nds` AS `outdoor_partner_wo_nds`,
    `_partner_wo_nds` AS `partner_wo_nds`,
    `_percent_content_bad_win_partner_price_content_partner_wo_nds` AS `percent_content_bad_win_partner_price_content_partner_wo_nds`,
    `_percent_content_bad_win_price_content_all_wo_nds` AS `percent_content_bad_win_price_content_all_wo_nds`,
    `_percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds` AS `percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`,
    `_percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds` AS `percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`,
    `_percent_natural_bad_win_partner_price_natural_partner_wo_nds` AS `percent_natural_bad_win_partner_price_natural_partner_wo_nds`,
    `_percent_natural_bad_win_price_natural_all_wo_nds` AS `percent_natural_bad_win_price_natural_all_wo_nds`,
    `_percent_rtb_bad_win_partner_price_rtb_partner_wo_nds` AS `percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`,
    `_percent_rtb_bad_win_price_rtb_all_wo_nds` AS `percent_rtb_bad_win_price_rtb_all_wo_nds`,
    `_premium_all_wo_nds` AS `premium_all_wo_nds`,
    `_premium_clicks` AS `premium_clicks`,
    `_premium_cpc_all_wo_nds` AS `premium_cpc_all_wo_nds`,
    `_premium_cpc_partner_wo_nds` AS `premium_cpc_partner_wo_nds`,
    `_premium_cpm_all_wo_nds` AS `premium_cpm_all_wo_nds`,
    `_premium_cpm_partner_wo_nds` AS `premium_cpm_partner_wo_nds`,
    `_premium_ctr` AS `premium_ctr`,
    `_premium_partner_wo_nds` AS `premium_partner_wo_nds`,
    `_premium_shows` AS `premium_shows`,
    `_rtb_all_wo_nds` AS `rtb_all_wo_nds`,
    `_rtb_bad_win_partner_price_wo_nds` AS `rtb_bad_win_partner_price_wo_nds`,
    `_rtb_bad_win_price_wo_nds` AS `rtb_bad_win_price_wo_nds`,
    `_rtb_block_all_hits` AS `rtb_block_all_hits`,
    `_rtb_block_bad_shows` AS `rtb_block_bad_shows`,
    `_rtb_block_bad_shows_own_adv` AS `rtb_block_bad_shows_own_adv`,
    `_rtb_block_bad_shows_percent` AS `rtb_block_bad_shows_percent`,
    `_rtb_block_bad_win_hits` AS `rtb_block_bad_win_hits`,
    `_rtb_block_bad_win_hits_own_adv` AS `rtb_block_bad_win_hits_own_adv`,
    `_rtb_block_bad_win_hits_percent` AS `rtb_block_bad_win_hits_percent`,
    `_rtb_block_bad_win_hits_unsold` AS `rtb_block_bad_win_hits_unsold`,
    `_rtb_block_cover_ratio` AS `rtb_block_cover_ratio`,
    `_rtb_block_cpm_all_wo_nds` AS `rtb_block_cpm_all_wo_nds`,
    `_rtb_block_cpm_partner_wo_nds` AS `rtb_block_cpm_partner_wo_nds`,
    `_rtb_block_cpmh_all_wo_nds` AS `rtb_block_cpmh_all_wo_nds`,
    `_rtb_block_cpmh_partner_wo_nds` AS `rtb_block_cpmh_partner_wo_nds`,
    `_rtb_block_direct_clicks` AS `rtb_block_direct_clicks`,
    `_rtb_block_direct_ctr` AS `rtb_block_direct_ctr`,
    `_rtb_block_direct_shows` AS `rtb_block_direct_shows`,
    `_rtb_block_hits` AS `rtb_block_hits`,
    `_rtb_block_hits_own_adv` AS `rtb_block_hits_own_adv`,
    `_rtb_block_hits_unsold` AS `rtb_block_hits_unsold`,
    `_rtb_block_rpm_all_wo_nds` AS `rtb_block_rpm_all_wo_nds`,
    `_rtb_block_rpm_partner_wo_nds` AS `rtb_block_rpm_partner_wo_nds`,
    `_rtb_block_shows` AS `rtb_block_shows`,
    `_rtb_block_shows_own_adv` AS `rtb_block_shows_own_adv`,
    `_rtb_block_visibility` AS `rtb_block_visibility`,
    `_rtb_block_winrate` AS `rtb_block_winrate`,
    `_rtb_partner_wo_nds` AS `rtb_partner_wo_nds`,
    `_ssp_mobile_rtb_all_wo_nds` AS `ssp_mobile_rtb_all_wo_nds`,
    `_ssp_mobile_rtb_block_all_hits` AS `ssp_mobile_rtb_block_all_hits`,
    `_ssp_mobile_rtb_block_cover_ratio` AS `ssp_mobile_rtb_block_cover_ratio`,
    `_ssp_mobile_rtb_block_cpm_all_wo_nds` AS `ssp_mobile_rtb_block_cpm_all_wo_nds`,
    `_ssp_mobile_rtb_block_cpm_partner_wo_nds` AS `ssp_mobile_rtb_block_cpm_partner_wo_nds`,
    `_ssp_mobile_rtb_block_cpmh_all_wo_nds` AS `ssp_mobile_rtb_block_cpmh_all_wo_nds`,
    `_ssp_mobile_rtb_block_cpmh_partner_wo_nds` AS `ssp_mobile_rtb_block_cpmh_partner_wo_nds`,
    `_ssp_mobile_rtb_block_hits` AS `ssp_mobile_rtb_block_hits`,
    `_ssp_mobile_rtb_block_hits_own_adv` AS `ssp_mobile_rtb_block_hits_own_adv`,
    `_ssp_mobile_rtb_block_hits_unsold` AS `ssp_mobile_rtb_block_hits_unsold`,
    `_ssp_mobile_rtb_block_rpm_all_wo_nds` AS `ssp_mobile_rtb_block_rpm_all_wo_nds`,
    `_ssp_mobile_rtb_block_rpm_partner_wo_nds` AS `ssp_mobile_rtb_block_rpm_partner_wo_nds`,
    `_ssp_mobile_rtb_block_shows` AS `ssp_mobile_rtb_block_shows`,
    `_ssp_mobile_rtb_block_visibility` AS `ssp_mobile_rtb_block_visibility`,
    `_ssp_mobile_rtb_block_winrate` AS `ssp_mobile_rtb_block_winrate`,
    `_ssp_mobile_rtb_partner_wo_nds` AS `ssp_mobile_rtb_partner_wo_nds`,
    `_stripe_all_wo_nds` AS `stripe_all_wo_nds`,
    `_stripe_clicks` AS `stripe_clicks`,
    `_stripe_cpc_all_wo_nds` AS `stripe_cpc_all_wo_nds`,
    `_stripe_cpc_partner_wo_nds` AS `stripe_cpc_partner_wo_nds`,
    `_stripe_cpm_all_wo_nds` AS `stripe_cpm_all_wo_nds`,
    `_stripe_cpm_partner_wo_nds` AS `stripe_cpm_partner_wo_nds`,
    `_stripe_cpmh_all_wo_nds` AS `stripe_cpmh_all_wo_nds`,
    `_stripe_cpmh_partner_wo_nds` AS `stripe_cpmh_partner_wo_nds`,
    `_stripe_ctr` AS `stripe_ctr`,
    `_stripe_hits` AS `stripe_hits`,
    `_stripe_partner_wo_nds` AS `stripe_partner_wo_nds`,
    `_stripe_shows` AS `stripe_shows`
FROM (
    SELECT
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000), 2) AS `_adblock_all_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_adblock') AS `_adblock_block_all_hits`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_adblock')) AS `_adblock_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpmh_partner_wo_nds`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_adblock')), 2) AS `_adblock_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_adblock')), 2) AS `_adblock_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_adblock'
        ))) AS `_adblock_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_adblock'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_adblock'
            )))) AS `_adblock_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000), 2) AS `_adblock_partner_wo_nds`,
        dictGetUInt8('blocks_dict', 'adfox_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_adfox_block`,
        round((SUM((`all_wo_nds` / 1000)) / 10000000), 2) AS `_all_wo_nds`,
        round((SUM((`bad_win_partner_price_wo_nds` / 1000)) / 10000000), 2) AS `_bad_win_partner_price_wo_nds`,
        round((SUM((`bad_win_price_wo_nds` / 1000)) / 10000000), 2) AS `_bad_win_price_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_content') AS `_content_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )))) AS `_content_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )))) AS `_content_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_content')) AS `_content_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'context_on_site_content'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'context_on_site_content')) AS `_content_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'context_on_site_content') AS `_content_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_content')), 2) AS `_content_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_content')), 2) AS `_content_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_content'
        ))) AS `_content_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_content'
            )))) AS `_content_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_partner_wo_nds`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000), 2) AS `_direct_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_direct') AS `_direct_context_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpc_direct_context_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpc_direct_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpm_direct_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpm_direct_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_direct') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_direct')) AS `_direct_context_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000), 2) AS `_direct_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_direct') AS `_direct_context_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000), 2) AS `_direct_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_direct') AS `_direct_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpc_direct_search_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpc_direct_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpm_direct_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpm_direct_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_direct') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_direct')) AS `_direct_search_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000), 2) AS `_direct_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_direct') AS `_direct_search_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000), 2) AS `_fullscreen_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen') AS `_fullscreen_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )))) AS `_fullscreen_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )))) AS `_fullscreen_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen')) AS `_fullscreen_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'video_an_site_fullscreen')) AS `_fullscreen_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'video_an_site_fullscreen') AS `_fullscreen_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_fullscreen'
            )))) AS `_fullscreen_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_fullscreen'
        ))) AS `_fullscreen_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'video_an_site_fullscreen'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'video_an_site_fullscreen'
                    )))))) AS `_fullscreen_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000), 2) AS `_fullscreen_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'indoor_block') / 10000000), 2) AS `_indoor_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'indoor_block') AS `_indoor_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            )))) AS `_indoor_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            )))) AS `_indoor_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'indoor_block')) AS `_indoor_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'indoor_block') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            ))), 2) AS `_indoor_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'indoor_block') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            ))), 2) AS `_indoor_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'indoor_block') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            ))), 2) AS `_indoor_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'indoor_block') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            ))), 2) AS `_indoor_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'indoor_block'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'indoor_block')) AS `_indoor_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'indoor_block') AS `_indoor_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'indoor_block') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'indoor_block'
            )))) AS `_indoor_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'indoor_block'
        ))) AS `_indoor_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'indoor_block'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'indoor_block') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'indoor_block'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'indoor_block'
                    )))))) AS `_indoor_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'indoor_block') / 10000000), 2) AS `_indoor_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000), 2) AS `_inpage_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage') AS `_inpage_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )))) AS `_inpage_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )))) AS `_inpage_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage')) AS `_inpage_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'video_an_site_inpage')) AS `_inpage_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'video_an_site_inpage') AS `_inpage_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_inpage'
            )))) AS `_inpage_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_inpage'
        ))) AS `_inpage_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_inpage'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'video_an_site_inpage'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'video_an_site_inpage'
                    )))))) AS `_inpage_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000), 2) AS `_inpage_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000), 2) AS `_instream_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') AS `_instream_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )))) AS `_instream_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )))) AS `_instream_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream')) AS `_instream_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'video_an_site_instream')) AS `_instream_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'video_an_site_instream') AS `_instream_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_instream'
            )))) AS `_instream_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_instream'
        ))) AS `_instream_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_instream'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'video_an_site_instream'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'video_an_site_instream'
                    )))))) AS `_instream_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000), 2) AS `_instream_partner_wo_nds`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000), 2) AS `_market_api_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_market_api') AS `_market_api_context_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpc_market_api_context_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpc_market_api_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpm_market_api_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpm_market_api_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_market_api') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_market_api')) AS `_market_api_context_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000), 2) AS `_market_api_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_market_api') AS `_market_api_context_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000), 2) AS `_market_api_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_market_api') AS `_market_api_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpc_market_api_search_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpc_market_api_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpm_market_api_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpm_market_api_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_market_api') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_market_api')) AS `_market_api_search_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000), 2) AS `_market_api_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_market_api') AS `_market_api_search_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000), 2) AS `_market_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_market') AS `_market_context_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpc_market_context_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpc_market_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpm_market_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpm_market_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_market') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_market')) AS `_market_context_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000), 2) AS `_market_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_market') AS `_market_context_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000), 2) AS `_market_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_market') AS `_market_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpc_market_search_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpc_market_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpm_market_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpm_market_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_market') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_market')) AS `_market_search_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000), 2) AS `_market_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_market') AS `_market_search_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000), 2) AS `_mcb_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_mcb') AS `_mcb_context_clicks`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_mcb')), 2) AS `_mcb_context_cpm_mcb_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_mcb')), 2) AS `_mcb_context_cpm_mcb_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_mcb') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_mcb')) AS `_mcb_context_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000), 2) AS `_mcb_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_mcb') AS `_mcb_context_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000), 2) AS `_mcb_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_mcb') AS `_mcb_search_clicks`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_mcb')), 2) AS `_mcb_search_cpm_mcb_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_mcb')), 2) AS `_mcb_search_cpm_mcb_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_mcb') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_mcb')) AS `_mcb_search_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000), 2) AS `_mcb_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_mcb') AS `_mcb_search_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'mobile_app_rtb') AS `_mobile_rtb_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )))) AS `_mobile_rtb_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )))) AS `_mobile_rtb_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / sumIf(`hits`, `product_id` = 'mobile_app_rtb')) AS `_mobile_rtb_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'mobile_app_rtb')) AS `_mobile_rtb_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'mobile_app_rtb') AS `_mobile_rtb_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'mobile_app_rtb')), 2) AS `_mobile_rtb_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'mobile_app_rtb')), 2) AS `_mobile_rtb_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'mobile_app_rtb'
        ))) AS `_mobile_rtb_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'mobile_app_rtb'
            )))) AS `_mobile_rtb_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_natural') AS `_natural_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )))) AS `_natural_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )))) AS `_natural_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_natural')) AS `_natural_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'context_on_site_natural')) AS `_natural_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'context_on_site_natural') AS `_natural_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_natural')), 2) AS `_natural_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_natural')), 2) AS `_natural_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_natural'
        ))) AS `_natural_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_natural'
            )))) AS `_natural_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000), 2) AS `_outdoor_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'outdoor_block') AS `_outdoor_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )))) AS `_outdoor_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )))) AS `_outdoor_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'outdoor_block')) AS `_outdoor_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            ))), 2) AS `_outdoor_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            ))), 2) AS `_outdoor_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            ))), 2) AS `_outdoor_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            ))), 2) AS `_outdoor_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'outdoor_block'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'outdoor_block')) AS `_outdoor_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'outdoor_block') AS `_outdoor_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'outdoor_block') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'outdoor_block'
            )))) AS `_outdoor_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'outdoor_block'
        ))) AS `_outdoor_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'outdoor_block'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'outdoor_block') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'outdoor_block'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'outdoor_block'
                    )))))) AS `_outdoor_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000), 2) AS `_outdoor_partner_wo_nds`,
        round((SUM((`partner_wo_nds` / 1000)) / 10000000), 2) AS `_partner_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_content'))) AS `_percent_content_bad_win_partner_price_content_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_content'))) AS `_percent_content_bad_win_price_content_all_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb'))) AS `_percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb'))) AS `_percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural'))) AS `_percent_natural_bad_win_partner_price_natural_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural'))) AS `_percent_natural_bad_win_price_natural_all_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')))) AS `_percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')))) AS `_percent_rtb_bad_win_price_rtb_all_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000), 2) AS `_premium_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_premium') AS `_premium_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpc_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpc_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpm_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_premium') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_premium')) AS `_premium_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000), 2) AS `_premium_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_premium') AS `_premium_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000), 2) AS `_rtb_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000), 2) AS `_rtb_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000), 2) AS `_rtb_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) AS `_rtb_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )))) AS `_rtb_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )))) AS `_rtb_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) * 100) / sumIf(`hits`, `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb'))) AS `_rtb_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            ))), 2) AS `_rtb_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            ))), 2) AS `_rtb_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            ))), 2) AS `_rtb_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            ))), 2) AS `_rtb_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) * 100) / sumIf(`direct_shows`, `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb'))) AS `_rtb_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) AS `_rtb_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000) * 1000) / sumIf(`hits`, `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb'))), 2) AS `_rtb_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000) * 1000) / sumIf(`hits`, `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb'))), 2) AS `_rtb_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
        ))) AS `_rtb_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )))) AS `_rtb_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000), 2) AS `_rtb_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000), 2) AS `_ssp_mobile_rtb_all_wo_nds`,
        sumIf(`hits`, `product_id` = 'ssp_mobile_app_rtb') AS `_ssp_mobile_rtb_block_all_hits`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_mobile_app_rtb'
            )) * 100) / sumIf(`hits`, `product_id` = 'ssp_mobile_app_rtb')) AS `_ssp_mobile_rtb_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_mobile_app_rtb'
            ))), 2) AS `_ssp_mobile_rtb_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_mobile_app_rtb'
            ))), 2) AS `_ssp_mobile_rtb_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_mobile_app_rtb'
            ))), 2) AS `_ssp_mobile_rtb_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_mobile_app_rtb'
            ))), 2) AS `_ssp_mobile_rtb_block_cpmh_partner_wo_nds`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'ssp_mobile_app_rtb'
    )) AS `_ssp_mobile_rtb_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'ssp_mobile_app_rtb'
    )) AS `_ssp_mobile_rtb_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'ssp_mobile_app_rtb'
    )) AS `_ssp_mobile_rtb_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'ssp_mobile_app_rtb')), 2) AS `_ssp_mobile_rtb_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'ssp_mobile_app_rtb')), 2) AS `_ssp_mobile_rtb_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'ssp_mobile_app_rtb'
    )) AS `_ssp_mobile_rtb_block_shows`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_mobile_app_rtb'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'ssp_mobile_app_rtb'
        ))) AS `_ssp_mobile_rtb_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_mobile_app_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_mobile_app_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'ssp_mobile_app_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'ssp_mobile_app_rtb'
            )))) AS `_ssp_mobile_rtb_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000), 2) AS `_ssp_mobile_rtb_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000), 2) AS `_stripe_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_stripe') AS `_stripe_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpc_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpc_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpmh_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_stripe') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_stripe')) AS `_stripe_ctr`,
        sumIf(`hits`, `product_id` = 'context_on_site_stripe') AS `_stripe_hits`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000), 2) AS `_stripe_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_stripe') AS `_stripe_shows`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('context_on_site_rtb', 'context_on_site_direct', 'context_on_site_stripe', 'context_on_site_mcb', 'context_on_site_market', 'context_on_site_adblock', 'context_on_site_market_api', 'context_on_site_content', 'context_on_site_natural', 'search_on_site_premium', 'search_on_site_direct', 'search_on_site_mcb', 'search_on_site_market', 'search_on_site_market_api', 'mobile_app_rtb', 'video_an_site_instream', 'video_an_site_inpage', 'video_an_site_fullscreen', 'ssp_mobile_app_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb', 'indoor_block', 'outdoor_block')
        AND (
            dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 'mock__login'
        )
        AND (
            dictGetUInt8('users_dict', 'is_efir_blogger', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 1
            OR dictGetUInt8('users_dict', 'is_video_blogger', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 1
            OR dictGetUInt8('users_dict', 'is_tutby', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 1
            OR dictGetUInt8('users_dict', 'is_adfox_partner', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 1
            OR dictGetUInt8('users_dict', 'is_mobile_mediation', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 1
            OR dictGetUInt8('users_dict', 'is_games', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 1
        )
        AND (
            dictGetString('users_dict', 'email', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 'mock__email'
        )
        AND (
            dictGetString('users_dict', 'phone', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 'mock__phone'
        )
        AND (
            dictGetUInt32('users_dict', 'client_id', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 'mock__client_id'
        )
        AND (
            dictGetUInt32('users_dict', 'client_id', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) IN ('mock__contract_id')
        )
        AND (
            dictGetString('users_dict', 'lastname', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 'mock__lastname'
        )
        AND (
            dictGetString('users_dict', 'name', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 'mock__name'
        )
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) = 'mock__id'
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
        AND (
            dictGetUInt8('blocks_dict', 'adfox_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 1
        )
    )
    GROUP BY `_adfox_block`, `_currency_id`, `_date`, `_login`
) `statistics`
WHERE (
    (if(isNaN(`outdoor_block_direct_shows`), 0, `outdoor_block_direct_shows`) + if(isNaN(`outdoor_block_all_hits`), 0, `outdoor_block_all_hits`) + if(isNaN(`market_context_ctr`), 0, `market_context_ctr`) + if(isNaN(`indoor_block_bad_shows_percent`), 0, `indoor_block_bad_shows_percent`) + if(isNaN(`direct_search_cpc_direct_search_partner_wo_nds`), 0, `direct_search_cpc_direct_search_partner_wo_nds`) + if(isNaN(`rtb_bad_win_price_wo_nds`), 0, `rtb_bad_win_price_wo_nds`) + if(isNaN(`indoor_block_bad_win_hits_own_adv`), 0, `indoor_block_bad_win_hits_own_adv`) + if(isNaN(`instream_block_bad_shows_percent`), 0, `instream_block_bad_shows_percent`) + if(isNaN(`instream_block_hits_unsold`), 0, `instream_block_hits_unsold`) + if(isNaN(`content_block_bad_shows_percent`), 0, `content_block_bad_shows_percent`) + if(isNaN(`fullscreen_block_bad_shows`), 0, `fullscreen_block_bad_shows`) + if(isNaN(`outdoor_block_bad_shows_own_adv`), 0, `outdoor_block_bad_shows_own_adv`) + if(isNaN(`outdoor_block_shows_own_adv`), 0, `outdoor_block_shows_own_adv`) + if(isNaN(`premium_clicks`), 0, `premium_clicks`) + if(isNaN(`inpage_partner_wo_nds`), 0, `inpage_partner_wo_nds`) + if(isNaN(`content_block_bad_win_hits_unsold`), 0, `content_block_bad_win_hits_unsold`) + if(isNaN(`inpage_block_bad_win_hits_percent`), 0, `inpage_block_bad_win_hits_percent`) + if(isNaN(`instream_block_cpm_all_wo_nds`), 0, `instream_block_cpm_all_wo_nds`) + if(isNaN(`premium_cpm_all_wo_nds`), 0, `premium_cpm_all_wo_nds`) + if(isNaN(`inpage_block_bad_shows`), 0, `inpage_block_bad_shows`) + if(isNaN(`content_block_bad_shows`), 0, `content_block_bad_shows`) + if(isNaN(`direct_search_partner_wo_nds`), 0, `direct_search_partner_wo_nds`) + if(isNaN(`market_api_context_clicks`), 0, `market_api_context_clicks`) + if(isNaN(`adblock_block_hits_unsold`), 0, `adblock_block_hits_unsold`) + if(isNaN(`instream_block_visibility`), 0, `instream_block_visibility`) + if(isNaN(`stripe_all_wo_nds`), 0, `stripe_all_wo_nds`) + if(isNaN(`fullscreen_block_hits`), 0, `fullscreen_block_hits`) + if(isNaN(`percent_content_bad_win_partner_price_content_partner_wo_nds`), 0, `percent_content_bad_win_partner_price_content_partner_wo_nds`) + if(isNaN(`adblock_block_shows`), 0, `adblock_block_shows`) + if(isNaN(`natural_bad_win_partner_price_wo_nds`), 0, `natural_bad_win_partner_price_wo_nds`) + if(isNaN(`fullscreen_block_cpmh_partner_wo_nds`), 0, `fullscreen_block_cpmh_partner_wo_nds`) + if(isNaN(`rtb_block_direct_shows`), 0, `rtb_block_direct_shows`) + if(isNaN(`outdoor_block_direct_ctr`), 0, `outdoor_block_direct_ctr`) + if(isNaN(`indoor_block_cpm_partner_wo_nds`), 0, `indoor_block_cpm_partner_wo_nds`) + if(isNaN(`content_block_cpmh_all_wo_nds`), 0, `content_block_cpmh_all_wo_nds`) + if(isNaN(`mobile_rtb_bad_win_price_wo_nds`), 0, `mobile_rtb_bad_win_price_wo_nds`) + if(isNaN(`content_block_rpm_partner_wo_nds`), 0, `content_block_rpm_partner_wo_nds`) + if(isNaN(`ssp_mobile_rtb_block_visibility`), 0, `ssp_mobile_rtb_block_visibility`) + if(isNaN(`inpage_block_direct_shows`), 0, `inpage_block_direct_shows`) + if(isNaN(`market_search_clicks`), 0, `market_search_clicks`) + if(isNaN(`natural_block_shows`), 0, `natural_block_shows`) + if(isNaN(`instream_block_cpmh_partner_wo_nds`), 0, `instream_block_cpmh_partner_wo_nds`) + if(isNaN(`inpage_block_hits`), 0, `inpage_block_hits`) + if(isNaN(`adblock_block_visibility`), 0, `adblock_block_visibility`) + if(isNaN(`stripe_cpm_all_wo_nds`), 0, `stripe_cpm_all_wo_nds`) + if(isNaN(`natural_block_direct_clicks`), 0, `natural_block_direct_clicks`) + if(isNaN(`fullscreen_block_bad_win_hits_unsold`), 0, `fullscreen_block_bad_win_hits_unsold`) + if(isNaN(`mobile_rtb_bad_win_partner_price_wo_nds`), 0, `mobile_rtb_bad_win_partner_price_wo_nds`) + if(isNaN(`premium_cpm_partner_wo_nds`), 0, `premium_cpm_partner_wo_nds`) + if(isNaN(`content_bad_win_price_wo_nds`), 0, `content_bad_win_price_wo_nds`) + if(isNaN(`content_block_direct_shows`), 0, `content_block_direct_shows`) + if(isNaN(`bad_win_partner_price_wo_nds`), 0, `bad_win_partner_price_wo_nds`) + if(isNaN(`ssp_mobile_rtb_block_cpm_partner_wo_nds`), 0, `ssp_mobile_rtb_block_cpm_partner_wo_nds`) + if(isNaN(`content_block_all_hits`), 0, `content_block_all_hits`) + if(isNaN(`adblock_block_cpmh_partner_wo_nds`), 0, `adblock_block_cpmh_partner_wo_nds`) + if(isNaN(`rtb_block_hits`), 0, `rtb_block_hits`) + if(isNaN(`mobile_rtb_block_bad_win_hits_percent`), 0, `mobile_rtb_block_bad_win_hits_percent`) + if(isNaN(`market_context_shows`), 0, `market_context_shows`) + if(isNaN(`ssp_mobile_rtb_block_shows`), 0, `ssp_mobile_rtb_block_shows`) + if(isNaN(`natural_block_cpm_all_wo_nds`), 0, `natural_block_cpm_all_wo_nds`) + if(isNaN(`mcb_context_clicks`), 0, `mcb_context_clicks`) + if(isNaN(`partner_wo_nds`), 0, `partner_wo_nds`) + if(isNaN(`market_api_context_cpc_market_api_context_partner_wo_nds`), 0, `market_api_context_cpc_market_api_context_partner_wo_nds`) + if(isNaN(`ssp_mobile_rtb_block_hits_own_adv`), 0, `ssp_mobile_rtb_block_hits_own_adv`) + if(isNaN(`market_api_search_ctr`), 0, `market_api_search_ctr`) + if(isNaN(`percent_rtb_bad_win_price_rtb_all_wo_nds`), 0, `percent_rtb_bad_win_price_rtb_all_wo_nds`) + if(isNaN(`fullscreen_block_visibility`), 0, `fullscreen_block_visibility`) + if(isNaN(`fullscreen_partner_wo_nds`), 0, `fullscreen_partner_wo_nds`) + if(isNaN(`ssp_mobile_rtb_block_cpm_all_wo_nds`), 0, `ssp_mobile_rtb_block_cpm_all_wo_nds`) + if(isNaN(`market_api_search_cpc_market_api_search_partner_wo_nds`), 0, `market_api_search_cpc_market_api_search_partner_wo_nds`) + if(isNaN(`mcb_search_clicks`), 0, `mcb_search_clicks`) + if(isNaN(`stripe_ctr`), 0, `stripe_ctr`) + if(isNaN(`percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`), 0, `percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`) + if(isNaN(`adblock_block_cpm_all_wo_nds`), 0, `adblock_block_cpm_all_wo_nds`) + if(isNaN(`stripe_cpc_partner_wo_nds`), 0, `stripe_cpc_partner_wo_nds`) + if(isNaN(`mobile_rtb_block_cpm_all_wo_nds`), 0, `mobile_rtb_block_cpm_all_wo_nds`) + if(isNaN(`stripe_clicks`), 0, `stripe_clicks`) + if(isNaN(`market_api_search_partner_wo_nds`), 0, `market_api_search_partner_wo_nds`) + if(isNaN(`market_context_all_wo_nds`), 0, `market_context_all_wo_nds`) + if(isNaN(`percent_content_bad_win_price_content_all_wo_nds`), 0, `percent_content_bad_win_price_content_all_wo_nds`) + if(isNaN(`mobile_rtb_block_direct_clicks`), 0, `mobile_rtb_block_direct_clicks`) + if(isNaN(`market_api_search_shows`), 0, `market_api_search_shows`) + if(isNaN(`natural_block_visibility`), 0, `natural_block_visibility`) + if(isNaN(`mobile_rtb_block_cpm_partner_wo_nds`), 0, `mobile_rtb_block_cpm_partner_wo_nds`) + if(isNaN(`content_block_shows`), 0, `content_block_shows`) + if(isNaN(`market_api_context_all_wo_nds`), 0, `market_api_context_all_wo_nds`) + if(isNaN(`rtb_bad_win_partner_price_wo_nds`), 0, `rtb_bad_win_partner_price_wo_nds`) + if(isNaN(`direct_search_ctr`), 0, `direct_search_ctr`) + if(isNaN(`rtb_block_cpm_all_wo_nds`), 0, `rtb_block_cpm_all_wo_nds`) + if(isNaN(`rtb_block_visibility`), 0, `rtb_block_visibility`) + if(isNaN(`rtb_block_rpm_all_wo_nds`), 0, `rtb_block_rpm_all_wo_nds`) + if(isNaN(`instream_block_bad_shows`), 0, `instream_block_bad_shows`) + if(isNaN(`ssp_mobile_rtb_block_rpm_partner_wo_nds`), 0, `ssp_mobile_rtb_block_rpm_partner_wo_nds`) + if(isNaN(`market_api_search_cpm_market_api_search_partner_wo_nds`), 0, `market_api_search_cpm_market_api_search_partner_wo_nds`) + if(isNaN(`indoor_block_bad_win_hits_unsold`), 0, `indoor_block_bad_win_hits_unsold`) + if(isNaN(`inpage_block_cover_ratio`), 0, `inpage_block_cover_ratio`) + if(isNaN(`market_context_cpm_market_context_all_wo_nds`), 0, `market_context_cpm_market_context_all_wo_nds`) + if(isNaN(`mobile_rtb_block_cpmh_all_wo_nds`), 0, `mobile_rtb_block_cpmh_all_wo_nds`) + if(isNaN(`indoor_partner_wo_nds`), 0, `indoor_partner_wo_nds`) + if(isNaN(`direct_search_cpc_direct_search_all_wo_nds`), 0, `direct_search_cpc_direct_search_all_wo_nds`) + if(isNaN(`market_search_partner_wo_nds`), 0, `market_search_partner_wo_nds`) + if(isNaN(`fullscreen_block_shows`), 0, `fullscreen_block_shows`) + if(isNaN(`indoor_block_shows_own_adv`), 0, `indoor_block_shows_own_adv`) + if(isNaN(`fullscreen_block_shows_own_adv`), 0, `fullscreen_block_shows_own_adv`) + if(isNaN(`ssp_mobile_rtb_partner_wo_nds`), 0, `ssp_mobile_rtb_partner_wo_nds`) + if(isNaN(`indoor_block_cpmh_partner_wo_nds`), 0, `indoor_block_cpmh_partner_wo_nds`) + if(isNaN(`adblock_block_cover_ratio`), 0, `adblock_block_cover_ratio`) + if(isNaN(`adblock_block_winrate`), 0, `adblock_block_winrate`) + if(isNaN(`outdoor_block_hits_own_adv`), 0, `outdoor_block_hits_own_adv`) + if(isNaN(`adblock_block_hits_own_adv`), 0, `adblock_block_hits_own_adv`) + if(isNaN(`indoor_block_direct_clicks`), 0, `indoor_block_direct_clicks`) + if(isNaN(`market_search_all_wo_nds`), 0, `market_search_all_wo_nds`) + if(isNaN(`market_api_context_cpc_market_api_context_all_wo_nds`), 0, `market_api_context_cpc_market_api_context_all_wo_nds`) + if(isNaN(`stripe_cpmh_all_wo_nds`), 0, `stripe_cpmh_all_wo_nds`) + if(isNaN(`direct_context_cpc_direct_context_partner_wo_nds`), 0, `direct_context_cpc_direct_context_partner_wo_nds`) + if(isNaN(`mobile_rtb_block_cover_ratio`), 0, `mobile_rtb_block_cover_ratio`) + if(isNaN(`natural_block_bad_shows`), 0, `natural_block_bad_shows`) + if(isNaN(`mobile_rtb_block_bad_shows_own_adv`), 0, `mobile_rtb_block_bad_shows_own_adv`) + if(isNaN(`mcb_context_cpm_mcb_context_all_wo_nds`), 0, `mcb_context_cpm_mcb_context_all_wo_nds`) + if(isNaN(`outdoor_block_bad_win_hits_percent`), 0, `outdoor_block_bad_win_hits_percent`) + if(isNaN(`natural_block_hits_unsold`), 0, `natural_block_hits_unsold`) + if(isNaN(`direct_context_cpc_direct_context_all_wo_nds`), 0, `direct_context_cpc_direct_context_all_wo_nds`) + if(isNaN(`indoor_block_shows`), 0, `indoor_block_shows`) + if(isNaN(`content_block_bad_shows_own_adv`), 0, `content_block_bad_shows_own_adv`) + if(isNaN(`mobile_rtb_block_visibility`), 0, `mobile_rtb_block_visibility`) + if(isNaN(`mobile_rtb_block_winrate`), 0, `mobile_rtb_block_winrate`) + if(isNaN(`mcb_context_cpm_mcb_context_partner_wo_nds`), 0, `mcb_context_cpm_mcb_context_partner_wo_nds`) + if(isNaN(`mcb_search_cpm_mcb_search_partner_wo_nds`), 0, `mcb_search_cpm_mcb_search_partner_wo_nds`) + if(isNaN(`fullscreen_block_bad_win_hits_own_adv`), 0, `fullscreen_block_bad_win_hits_own_adv`) + if(isNaN(`percent_natural_bad_win_partner_price_natural_partner_wo_nds`), 0, `percent_natural_bad_win_partner_price_natural_partner_wo_nds`) + if(isNaN(`outdoor_all_wo_nds`), 0, `outdoor_all_wo_nds`) + if(isNaN(`percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`), 0, `percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`) + if(isNaN(`mcb_context_partner_wo_nds`), 0, `mcb_context_partner_wo_nds`) + if(isNaN(`rtb_block_cover_ratio`), 0, `rtb_block_cover_ratio`) + if(isNaN(`adblock_block_rpm_all_wo_nds`), 0, `adblock_block_rpm_all_wo_nds`) + if(isNaN(`all_wo_nds`), 0, `all_wo_nds`) + if(isNaN(`direct_context_all_wo_nds`), 0, `direct_context_all_wo_nds`) + if(isNaN(`natural_block_rpm_all_wo_nds`), 0, `natural_block_rpm_all_wo_nds`) + if(isNaN(`outdoor_block_hits_unsold`), 0, `outdoor_block_hits_unsold`) + if(isNaN(`rtb_block_rpm_partner_wo_nds`), 0, `rtb_block_rpm_partner_wo_nds`) + if(isNaN(`market_api_search_clicks`), 0, `market_api_search_clicks`) + if(isNaN(`mcb_search_shows`), 0, `mcb_search_shows`) + if(isNaN(`indoor_block_hits`), 0, `indoor_block_hits`) + if(isNaN(`percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`), 0, `percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`) + if(isNaN(`mobile_rtb_all_wo_nds`), 0, `mobile_rtb_all_wo_nds`) + if(isNaN(`natural_block_bad_shows_own_adv`), 0, `natural_block_bad_shows_own_adv`) + if(isNaN(`outdoor_block_bad_win_hits_own_adv`), 0, `outdoor_block_bad_win_hits_own_adv`) + if(isNaN(`inpage_block_bad_win_hits`), 0, `inpage_block_bad_win_hits`) + if(isNaN(`inpage_block_winrate`), 0, `inpage_block_winrate`) + if(isNaN(`market_api_search_cpm_market_api_search_all_wo_nds`), 0, `market_api_search_cpm_market_api_search_all_wo_nds`) + if(isNaN(`market_context_cpc_market_context_all_wo_nds`), 0, `market_context_cpc_market_context_all_wo_nds`) + if(isNaN(`inpage_block_cpmh_all_wo_nds`), 0, `inpage_block_cpmh_all_wo_nds`) + if(isNaN(`fullscreen_block_cpm_all_wo_nds`), 0, `fullscreen_block_cpm_all_wo_nds`) + if(isNaN(`outdoor_block_bad_win_hits_unsold`), 0, `outdoor_block_bad_win_hits_unsold`) + if(isNaN(`indoor_block_bad_win_hits_percent`), 0, `indoor_block_bad_win_hits_percent`) + if(isNaN(`mobile_rtb_block_all_hits`), 0, `mobile_rtb_block_all_hits`) + if(isNaN(`instream_block_winrate`), 0, `instream_block_winrate`) + if(isNaN(`content_block_winrate`), 0, `content_block_winrate`) + if(isNaN(`instream_block_bad_win_hits_unsold`), 0, `instream_block_bad_win_hits_unsold`) + if(isNaN(`content_block_hits_unsold`), 0, `content_block_hits_unsold`) + if(isNaN(`rtb_block_bad_win_hits_unsold`), 0, `rtb_block_bad_win_hits_unsold`) + if(isNaN(`rtb_block_hits_own_adv`), 0, `rtb_block_hits_own_adv`) + if(isNaN(`instream_block_all_hits`), 0, `instream_block_all_hits`) + if(isNaN(`instream_block_cpm_partner_wo_nds`), 0, `instream_block_cpm_partner_wo_nds`) + if(isNaN(`natural_block_shows_own_adv`), 0, `natural_block_shows_own_adv`) + if(isNaN(`premium_ctr`), 0, `premium_ctr`) + if(isNaN(`adblock_block_shows_own_adv`), 0, `adblock_block_shows_own_adv`) + if(isNaN(`rtb_block_shows`), 0, `rtb_block_shows`) + if(isNaN(`natural_block_cpmh_all_wo_nds`), 0, `natural_block_cpmh_all_wo_nds`) + if(isNaN(`outdoor_partner_wo_nds`), 0, `outdoor_partner_wo_nds`) + if(isNaN(`outdoor_block_hits`), 0, `outdoor_block_hits`) + if(isNaN(`outdoor_block_cpmh_all_wo_nds`), 0, `outdoor_block_cpmh_all_wo_nds`) + if(isNaN(`inpage_block_hits_unsold`), 0, `inpage_block_hits_unsold`) + if(isNaN(`mcb_search_cpm_mcb_search_all_wo_nds`), 0, `mcb_search_cpm_mcb_search_all_wo_nds`) + if(isNaN(`natural_block_bad_win_hits`), 0, `natural_block_bad_win_hits`) + if(isNaN(`fullscreen_block_all_hits`), 0, `fullscreen_block_all_hits`) + if(isNaN(`rtb_block_all_hits`), 0, `rtb_block_all_hits`) + if(isNaN(`market_api_context_cpm_market_api_context_partner_wo_nds`), 0, `market_api_context_cpm_market_api_context_partner_wo_nds`) + if(isNaN(`market_api_context_ctr`), 0, `market_api_context_ctr`) + if(isNaN(`instream_all_wo_nds`), 0, `instream_all_wo_nds`) + if(isNaN(`rtb_all_wo_nds`), 0, `rtb_all_wo_nds`) + if(isNaN(`instream_partner_wo_nds`), 0, `instream_partner_wo_nds`) + if(isNaN(`content_block_rpm_all_wo_nds`), 0, `content_block_rpm_all_wo_nds`) + if(isNaN(`ssp_mobile_rtb_block_cover_ratio`), 0, `ssp_mobile_rtb_block_cover_ratio`) + if(isNaN(`stripe_cpm_partner_wo_nds`), 0, `stripe_cpm_partner_wo_nds`) + if(isNaN(`rtb_block_bad_shows_own_adv`), 0, `rtb_block_bad_shows_own_adv`) + if(isNaN(`indoor_block_hits_own_adv`), 0, `indoor_block_hits_own_adv`) + if(isNaN(`instream_block_cover_ratio`), 0, `instream_block_cover_ratio`) + if(isNaN(`rtb_block_cpm_partner_wo_nds`), 0, `rtb_block_cpm_partner_wo_nds`) + if(isNaN(`content_block_bad_win_hits_percent`), 0, `content_block_bad_win_hits_percent`) + if(isNaN(`ssp_mobile_rtb_block_cpmh_all_wo_nds`), 0, `ssp_mobile_rtb_block_cpmh_all_wo_nds`) + if(isNaN(`natural_block_rpm_partner_wo_nds`), 0, `natural_block_rpm_partner_wo_nds`) + if(isNaN(`fullscreen_block_bad_shows_own_adv`), 0, `fullscreen_block_bad_shows_own_adv`) + if(isNaN(`outdoor_block_visibility`), 0, `outdoor_block_visibility`) + if(isNaN(`rtb_block_bad_shows`), 0, `rtb_block_bad_shows`) + if(isNaN(`fullscreen_block_bad_shows_percent`), 0, `fullscreen_block_bad_shows_percent`) + if(isNaN(`ssp_mobile_rtb_block_winrate`), 0, `ssp_mobile_rtb_block_winrate`) + if(isNaN(`percent_natural_bad_win_price_natural_all_wo_nds`), 0, `percent_natural_bad_win_price_natural_all_wo_nds`) + if(isNaN(`fullscreen_block_direct_clicks`), 0, `fullscreen_block_direct_clicks`) + if(isNaN(`rtb_block_cpmh_partner_wo_nds`), 0, `rtb_block_cpmh_partner_wo_nds`) + if(isNaN(`adblock_block_all_hits`), 0, `adblock_block_all_hits`) + if(isNaN(`adblock_block_cpm_partner_wo_nds`), 0, `adblock_block_cpm_partner_wo_nds`) + if(isNaN(`mobile_rtb_block_shows`), 0, `mobile_rtb_block_shows`) + if(isNaN(`indoor_block_cpm_all_wo_nds`), 0, `indoor_block_cpm_all_wo_nds`) + if(isNaN(`natural_block_direct_shows`), 0, `natural_block_direct_shows`) + if(isNaN(`mobile_rtb_block_bad_win_hits_unsold`), 0, `mobile_rtb_block_bad_win_hits_unsold`) + if(isNaN(`ssp_mobile_rtb_block_hits_unsold`), 0, `ssp_mobile_rtb_block_hits_unsold`) + if(isNaN(`mobile_rtb_block_direct_ctr`), 0, `mobile_rtb_block_direct_ctr`) + if(isNaN(`natural_block_hits`), 0, `natural_block_hits`) + if(isNaN(`mobile_rtb_block_hits_unsold`), 0, `mobile_rtb_block_hits_unsold`) + if(isNaN(`inpage_block_shows_own_adv`), 0, `inpage_block_shows_own_adv`) + if(isNaN(`inpage_block_bad_shows_own_adv`), 0, `inpage_block_bad_shows_own_adv`) + if(isNaN(`rtb_block_direct_ctr`), 0, `rtb_block_direct_ctr`) + if(isNaN(`stripe_shows`), 0, `stripe_shows`) + if(isNaN(`natural_block_cpm_partner_wo_nds`), 0, `natural_block_cpm_partner_wo_nds`) + if(isNaN(`outdoor_block_winrate`), 0, `outdoor_block_winrate`) + if(isNaN(`adblock_all_wo_nds`), 0, `adblock_all_wo_nds`) + if(isNaN(`rtb_partner_wo_nds`), 0, `rtb_partner_wo_nds`) + if(isNaN(`premium_all_wo_nds`), 0, `premium_all_wo_nds`) + if(isNaN(`direct_context_cpm_direct_context_all_wo_nds`), 0, `direct_context_cpm_direct_context_all_wo_nds`) + if(isNaN(`mcb_context_ctr`), 0, `mcb_context_ctr`) + if(isNaN(`instream_block_bad_win_hits_percent`), 0, `instream_block_bad_win_hits_percent`) + if(isNaN(`market_search_ctr`), 0, `market_search_ctr`) + if(isNaN(`indoor_block_cover_ratio`), 0, `indoor_block_cover_ratio`) + if(isNaN(`natural_block_winrate`), 0, `natural_block_winrate`) + if(isNaN(`instream_block_hits`), 0, `instream_block_hits`) + if(isNaN(`premium_cpc_partner_wo_nds`), 0, `premium_cpc_partner_wo_nds`) + if(isNaN(`direct_context_cpm_direct_context_partner_wo_nds`), 0, `direct_context_cpm_direct_context_partner_wo_nds`) + if(isNaN(`content_block_direct_clicks`), 0, `content_block_direct_clicks`) + if(isNaN(`natural_block_hits_own_adv`), 0, `natural_block_hits_own_adv`) + if(isNaN(`instream_block_shows`), 0, `instream_block_shows`) + if(isNaN(`adblock_block_hits`), 0, `adblock_block_hits`) + if(isNaN(`ssp_mobile_rtb_block_hits`), 0, `ssp_mobile_rtb_block_hits`) + if(isNaN(`inpage_block_all_hits`), 0, `inpage_block_all_hits`) + if(isNaN(`instream_block_bad_win_hits_own_adv`), 0, `instream_block_bad_win_hits_own_adv`) + if(isNaN(`natural_block_bad_win_hits_unsold`), 0, `natural_block_bad_win_hits_unsold`) + if(isNaN(`outdoor_block_cpm_partner_wo_nds`), 0, `outdoor_block_cpm_partner_wo_nds`) + if(isNaN(`market_search_cpc_market_search_all_wo_nds`), 0, `market_search_cpc_market_search_all_wo_nds`) + if(isNaN(`fullscreen_block_bad_win_hits`), 0, `fullscreen_block_bad_win_hits`) + if(isNaN(`stripe_hits`), 0, `stripe_hits`) + if(isNaN(`mcb_context_all_wo_nds`), 0, `mcb_context_all_wo_nds`) + if(isNaN(`inpage_all_wo_nds`), 0, `inpage_all_wo_nds`) + if(isNaN(`natural_block_bad_win_hits_own_adv`), 0, `natural_block_bad_win_hits_own_adv`) + if(isNaN(`direct_search_shows`), 0, `direct_search_shows`) + if(isNaN(`market_context_cpc_market_context_partner_wo_nds`), 0, `market_context_cpc_market_context_partner_wo_nds`) + if(isNaN(`natural_bad_win_price_wo_nds`), 0, `natural_bad_win_price_wo_nds`) + if(isNaN(`indoor_block_direct_shows`), 0, `indoor_block_direct_shows`) + if(isNaN(`content_partner_wo_nds`), 0, `content_partner_wo_nds`) + if(isNaN(`ssp_mobile_rtb_block_all_hits`), 0, `ssp_mobile_rtb_block_all_hits`) + if(isNaN(`adblock_partner_wo_nds`), 0, `adblock_partner_wo_nds`) + if(isNaN(`instream_block_hits_own_adv`), 0, `instream_block_hits_own_adv`) + if(isNaN(`market_search_cpc_market_search_partner_wo_nds`), 0, `market_search_cpc_market_search_partner_wo_nds`) + if(isNaN(`indoor_block_winrate`), 0, `indoor_block_winrate`) + if(isNaN(`instream_block_bad_win_hits`), 0, `instream_block_bad_win_hits`) + if(isNaN(`content_block_shows_own_adv`), 0, `content_block_shows_own_adv`) + if(isNaN(`instream_block_bad_shows_own_adv`), 0, `instream_block_bad_shows_own_adv`) + if(isNaN(`indoor_block_cpmh_all_wo_nds`), 0, `indoor_block_cpmh_all_wo_nds`) + if(isNaN(`direct_context_shows`), 0, `direct_context_shows`) + if(isNaN(`stripe_cpc_all_wo_nds`), 0, `stripe_cpc_all_wo_nds`) + if(isNaN(`content_block_cpmh_partner_wo_nds`), 0, `content_block_cpmh_partner_wo_nds`) + if(isNaN(`premium_partner_wo_nds`), 0, `premium_partner_wo_nds`) + if(isNaN(`instream_block_cpmh_all_wo_nds`), 0, `instream_block_cpmh_all_wo_nds`) + if(isNaN(`fullscreen_block_direct_ctr`), 0, `fullscreen_block_direct_ctr`) + if(isNaN(`content_block_direct_ctr`), 0, `content_block_direct_ctr`) + if(isNaN(`content_block_cpm_partner_wo_nds`), 0, `content_block_cpm_partner_wo_nds`) + if(isNaN(`direct_search_clicks`), 0, `direct_search_clicks`) + if(isNaN(`market_api_search_cpc_market_api_search_all_wo_nds`), 0, `market_api_search_cpc_market_api_search_all_wo_nds`) + if(isNaN(`outdoor_block_shows`), 0, `outdoor_block_shows`) + if(isNaN(`ssp_mobile_rtb_block_rpm_all_wo_nds`), 0, `ssp_mobile_rtb_block_rpm_all_wo_nds`) + if(isNaN(`content_block_visibility`), 0, `content_block_visibility`) + if(isNaN(`mcb_search_partner_wo_nds`), 0, `mcb_search_partner_wo_nds`) + if(isNaN(`rtb_block_bad_win_hits_own_adv`), 0, `rtb_block_bad_win_hits_own_adv`) + if(isNaN(`content_block_bad_win_hits_own_adv`), 0, `content_block_bad_win_hits_own_adv`) + if(isNaN(`direct_context_clicks`), 0, `direct_context_clicks`) + if(isNaN(`mobile_rtb_block_direct_shows`), 0, `mobile_rtb_block_direct_shows`) + if(isNaN(`inpage_block_visibility`), 0, `inpage_block_visibility`) + if(isNaN(`adblock_block_rpm_partner_wo_nds`), 0, `adblock_block_rpm_partner_wo_nds`) + if(isNaN(`market_search_cpm_market_search_partner_wo_nds`), 0, `market_search_cpm_market_search_partner_wo_nds`) + if(isNaN(`mobile_rtb_block_hits_own_adv`), 0, `mobile_rtb_block_hits_own_adv`) + if(isNaN(`market_api_context_cpm_market_api_context_all_wo_nds`), 0, `market_api_context_cpm_market_api_context_all_wo_nds`) + if(isNaN(`fullscreen_block_hits_unsold`), 0, `fullscreen_block_hits_unsold`) + if(isNaN(`inpage_block_bad_win_hits_own_adv`), 0, `inpage_block_bad_win_hits_own_adv`) + if(isNaN(`mobile_rtb_block_cpmh_partner_wo_nds`), 0, `mobile_rtb_block_cpmh_partner_wo_nds`) + if(isNaN(`fullscreen_block_cpm_partner_wo_nds`), 0, `fullscreen_block_cpm_partner_wo_nds`) + if(isNaN(`natural_partner_wo_nds`), 0, `natural_partner_wo_nds`) + if(isNaN(`market_context_clicks`), 0, `market_context_clicks`) + if(isNaN(`natural_block_cover_ratio`), 0, `natural_block_cover_ratio`) + if(isNaN(`adblock_block_cpmh_all_wo_nds`), 0, `adblock_block_cpmh_all_wo_nds`) + if(isNaN(`indoor_all_wo_nds`), 0, `indoor_all_wo_nds`) + if(isNaN(`content_block_cpm_all_wo_nds`), 0, `content_block_cpm_all_wo_nds`) + if(isNaN(`direct_context_ctr`), 0, `direct_context_ctr`) + if(isNaN(`fullscreen_block_cover_ratio`), 0, `fullscreen_block_cover_ratio`) + if(isNaN(`indoor_block_bad_shows`), 0, `indoor_block_bad_shows`) + if(isNaN(`natural_block_direct_ctr`), 0, `natural_block_direct_ctr`) + if(isNaN(`mobile_rtb_partner_wo_nds`), 0, `mobile_rtb_partner_wo_nds`) + if(isNaN(`mobile_rtb_block_bad_win_hits`), 0, `mobile_rtb_block_bad_win_hits`) + if(isNaN(`outdoor_block_cpmh_partner_wo_nds`), 0, `outdoor_block_cpmh_partner_wo_nds`) + if(isNaN(`mobile_rtb_block_bad_shows`), 0, `mobile_rtb_block_bad_shows`) + if(isNaN(`inpage_block_bad_win_hits_unsold`), 0, `inpage_block_bad_win_hits_unsold`) + if(isNaN(`content_block_cover_ratio`), 0, `content_block_cover_ratio`) + if(isNaN(`mobile_rtb_block_bad_shows_percent`), 0, `mobile_rtb_block_bad_shows_percent`) + if(isNaN(`direct_context_partner_wo_nds`), 0, `direct_context_partner_wo_nds`) + if(isNaN(`inpage_block_cpmh_partner_wo_nds`), 0, `inpage_block_cpmh_partner_wo_nds`) + if(isNaN(`market_search_shows`), 0, `market_search_shows`) + if(isNaN(`stripe_partner_wo_nds`), 0, `stripe_partner_wo_nds`) + if(isNaN(`direct_search_cpm_direct_search_partner_wo_nds`), 0, `direct_search_cpm_direct_search_partner_wo_nds`) + if(isNaN(`indoor_block_all_hits`), 0, `indoor_block_all_hits`) + if(isNaN(`mcb_search_all_wo_nds`), 0, `mcb_search_all_wo_nds`) + if(isNaN(`outdoor_block_cover_ratio`), 0, `outdoor_block_cover_ratio`) + if(isNaN(`natural_block_bad_shows_percent`), 0, `natural_block_bad_shows_percent`) + if(isNaN(`instream_block_direct_clicks`), 0, `instream_block_direct_clicks`) + if(isNaN(`fullscreen_block_direct_shows`), 0, `fullscreen_block_direct_shows`) + if(isNaN(`outdoor_block_bad_win_hits`), 0, `outdoor_block_bad_win_hits`) + if(isNaN(`market_context_cpm_market_context_partner_wo_nds`), 0, `market_context_cpm_market_context_partner_wo_nds`) + if(isNaN(`indoor_block_hits_unsold`), 0, `indoor_block_hits_unsold`) + if(isNaN(`rtb_block_bad_shows_percent`), 0, `rtb_block_bad_shows_percent`) + if(isNaN(`content_block_hits`), 0, `content_block_hits`) + if(isNaN(`indoor_block_bad_win_hits`), 0, `indoor_block_bad_win_hits`) + if(isNaN(`rtb_block_bad_win_hits_percent`), 0, `rtb_block_bad_win_hits_percent`) + if(isNaN(`mobile_rtb_block_hits`), 0, `mobile_rtb_block_hits`) + if(isNaN(`inpage_block_hits_own_adv`), 0, `inpage_block_hits_own_adv`) + if(isNaN(`inpage_block_cpm_all_wo_nds`), 0, `inpage_block_cpm_all_wo_nds`) + if(isNaN(`inpage_block_direct_clicks`), 0, `inpage_block_direct_clicks`) + if(isNaN(`fullscreen_block_hits_own_adv`), 0, `fullscreen_block_hits_own_adv`) + if(isNaN(`inpage_block_cpm_partner_wo_nds`), 0, `inpage_block_cpm_partner_wo_nds`) + if(isNaN(`inpage_block_shows`), 0, `inpage_block_shows`) + if(isNaN(`content_block_bad_win_hits`), 0, `content_block_bad_win_hits`) + if(isNaN(`premium_cpc_all_wo_nds`), 0, `premium_cpc_all_wo_nds`) + if(isNaN(`fullscreen_all_wo_nds`), 0, `fullscreen_all_wo_nds`) + if(isNaN(`content_block_hits_own_adv`), 0, `content_block_hits_own_adv`) + if(isNaN(`natural_block_bad_win_hits_percent`), 0, `natural_block_bad_win_hits_percent`) + if(isNaN(`instream_block_direct_ctr`), 0, `instream_block_direct_ctr`) + if(isNaN(`natural_block_cpmh_partner_wo_nds`), 0, `natural_block_cpmh_partner_wo_nds`) + if(isNaN(`natural_all_wo_nds`), 0, `natural_all_wo_nds`) + if(isNaN(`rtb_block_direct_clicks`), 0, `rtb_block_direct_clicks`) + if(isNaN(`mcb_context_shows`), 0, `mcb_context_shows`) + if(isNaN(`fullscreen_block_winrate`), 0, `fullscreen_block_winrate`) + if(isNaN(`rtb_block_winrate`), 0, `rtb_block_winrate`) + if(isNaN(`market_api_context_shows`), 0, `market_api_context_shows`) + if(isNaN(`direct_search_cpm_direct_search_all_wo_nds`), 0, `direct_search_cpm_direct_search_all_wo_nds`) + if(isNaN(`mcb_search_ctr`), 0, `mcb_search_ctr`) + if(isNaN(`indoor_block_direct_ctr`), 0, `indoor_block_direct_ctr`) + if(isNaN(`instream_block_shows_own_adv`), 0, `instream_block_shows_own_adv`) + if(isNaN(`indoor_block_bad_shows_own_adv`), 0, `indoor_block_bad_shows_own_adv`) + if(isNaN(`natural_block_all_hits`), 0, `natural_block_all_hits`) + if(isNaN(`rtb_block_bad_win_hits`), 0, `rtb_block_bad_win_hits`) + if(isNaN(`rtb_block_hits_unsold`), 0, `rtb_block_hits_unsold`) + if(isNaN(`mobile_rtb_block_rpm_partner_wo_nds`), 0, `mobile_rtb_block_rpm_partner_wo_nds`) + if(isNaN(`outdoor_block_cpm_all_wo_nds`), 0, `outdoor_block_cpm_all_wo_nds`) + if(isNaN(`fullscreen_block_bad_win_hits_percent`), 0, `fullscreen_block_bad_win_hits_percent`) + if(isNaN(`bad_win_price_wo_nds`), 0, `bad_win_price_wo_nds`) + if(isNaN(`mobile_rtb_block_bad_win_hits_own_adv`), 0, `mobile_rtb_block_bad_win_hits_own_adv`) + if(isNaN(`mobile_rtb_block_shows_own_adv`), 0, `mobile_rtb_block_shows_own_adv`) + if(isNaN(`content_bad_win_partner_price_wo_nds`), 0, `content_bad_win_partner_price_wo_nds`) + if(isNaN(`mobile_rtb_block_rpm_all_wo_nds`), 0, `mobile_rtb_block_rpm_all_wo_nds`) + if(isNaN(`content_all_wo_nds`), 0, `content_all_wo_nds`) + if(isNaN(`stripe_cpmh_partner_wo_nds`), 0, `stripe_cpmh_partner_wo_nds`) + if(isNaN(`outdoor_block_bad_shows_percent`), 0, `outdoor_block_bad_shows_percent`) + if(isNaN(`direct_search_all_wo_nds`), 0, `direct_search_all_wo_nds`) + if(isNaN(`inpage_block_bad_shows_percent`), 0, `inpage_block_bad_shows_percent`) + if(isNaN(`ssp_mobile_rtb_all_wo_nds`), 0, `ssp_mobile_rtb_all_wo_nds`) + if(isNaN(`rtb_block_shows_own_adv`), 0, `rtb_block_shows_own_adv`) + if(isNaN(`market_api_context_partner_wo_nds`), 0, `market_api_context_partner_wo_nds`) + if(isNaN(`market_context_partner_wo_nds`), 0, `market_context_partner_wo_nds`) + if(isNaN(`outdoor_block_bad_shows`), 0, `outdoor_block_bad_shows`) + if(isNaN(`ssp_mobile_rtb_block_cpmh_partner_wo_nds`), 0, `ssp_mobile_rtb_block_cpmh_partner_wo_nds`) + if(isNaN(`indoor_block_visibility`), 0, `indoor_block_visibility`) + if(isNaN(`instream_block_direct_shows`), 0, `instream_block_direct_shows`) + if(isNaN(`fullscreen_block_cpmh_all_wo_nds`), 0, `fullscreen_block_cpmh_all_wo_nds`) + if(isNaN(`rtb_block_cpmh_all_wo_nds`), 0, `rtb_block_cpmh_all_wo_nds`) + if(isNaN(`premium_shows`), 0, `premium_shows`) + if(isNaN(`inpage_block_direct_ctr`), 0, `inpage_block_direct_ctr`) + if(isNaN(`outdoor_block_direct_clicks`), 0, `outdoor_block_direct_clicks`) + if(isNaN(`market_search_cpm_market_search_all_wo_nds`), 0, `market_search_cpm_market_search_all_wo_nds`) + if(isNaN(`market_api_search_all_wo_nds`), 0, `market_api_search_all_wo_nds`)) > 0
) FORMAT JSONCompact

SELECT
    `_adblock_all_wo_nds` AS `adblock_all_wo_nds`,
    `_adblock_block_all_hits` AS `adblock_block_all_hits`,
    `_adblock_block_cover_ratio` AS `adblock_block_cover_ratio`,
    `_adblock_block_cpm_all_wo_nds` AS `adblock_block_cpm_all_wo_nds`,
    `_adblock_block_cpm_partner_wo_nds` AS `adblock_block_cpm_partner_wo_nds`,
    `_adblock_block_cpmh_all_wo_nds` AS `adblock_block_cpmh_all_wo_nds`,
    `_adblock_block_cpmh_partner_wo_nds` AS `adblock_block_cpmh_partner_wo_nds`,
    `_adblock_block_hits` AS `adblock_block_hits`,
    `_adblock_block_hits_own_adv` AS `adblock_block_hits_own_adv`,
    `_adblock_block_hits_unsold` AS `adblock_block_hits_unsold`,
    `_adblock_block_rpm_all_wo_nds` AS `adblock_block_rpm_all_wo_nds`,
    `_adblock_block_rpm_partner_wo_nds` AS `adblock_block_rpm_partner_wo_nds`,
    `_adblock_block_shows` AS `adblock_block_shows`,
    `_adblock_block_shows_own_adv` AS `adblock_block_shows_own_adv`,
    `_adblock_block_visibility` AS `adblock_block_visibility`,
    `_adblock_block_winrate` AS `adblock_block_winrate`,
    `_adblock_partner_wo_nds` AS `adblock_partner_wo_nds`,
    `_all_wo_nds` AS `all_wo_nds`,
    `_an_cover_direct_hits` AS `an_cover_direct_hits`,
    `_an_cover_hits` AS `an_cover_hits`,
    `_an_cover_market_hits` AS `an_cover_market_hits`,
    `_an_cover_mcb_hits` AS `an_cover_mcb_hits`,
    `_an_cover_senthits` AS `an_cover_senthits`,
    `_an_fraud_clicks` AS `an_fraud_clicks`,
    `_an_fraud_shows` AS `an_fraud_shows`,
    `_an_mobile_rtb_cover_direct_hits` AS `an_mobile_rtb_cover_direct_hits`,
    `_an_mobile_rtb_cover_hits` AS `an_mobile_rtb_cover_hits`,
    `_an_mobile_rtb_cover_senthits` AS `an_mobile_rtb_cover_senthits`,
    `_an_rtb_cover_direct_hits` AS `an_rtb_cover_direct_hits`,
    `_an_rtb_cover_hits` AS `an_rtb_cover_hits`,
    `_an_rtb_cover_senthits` AS `an_rtb_cover_senthits`,
    `_an_ssp_mobile_rtb_cover_direct_hits` AS `an_ssp_mobile_rtb_cover_direct_hits`,
    `_an_ssp_mobile_rtb_cover_hits` AS `an_ssp_mobile_rtb_cover_hits`,
    `_an_ssp_mobile_rtb_cover_senthits` AS `an_ssp_mobile_rtb_cover_senthits`,
    `_bad_win_partner_price_wo_nds` AS `bad_win_partner_price_wo_nds`,
    `_bad_win_price_wo_nds` AS `bad_win_price_wo_nds`,
    `_content_all_wo_nds` AS `content_all_wo_nds`,
    `_content_bad_win_partner_price_wo_nds` AS `content_bad_win_partner_price_wo_nds`,
    `_content_bad_win_price_wo_nds` AS `content_bad_win_price_wo_nds`,
    `_content_block_all_hits` AS `content_block_all_hits`,
    `_content_block_bad_shows` AS `content_block_bad_shows`,
    `_content_block_bad_shows_own_adv` AS `content_block_bad_shows_own_adv`,
    `_content_block_bad_shows_percent` AS `content_block_bad_shows_percent`,
    `_content_block_bad_win_hits` AS `content_block_bad_win_hits`,
    `_content_block_bad_win_hits_own_adv` AS `content_block_bad_win_hits_own_adv`,
    `_content_block_bad_win_hits_percent` AS `content_block_bad_win_hits_percent`,
    `_content_block_bad_win_hits_unsold` AS `content_block_bad_win_hits_unsold`,
    `_content_block_cover_ratio` AS `content_block_cover_ratio`,
    `_content_block_cpm_all_wo_nds` AS `content_block_cpm_all_wo_nds`,
    `_content_block_cpm_partner_wo_nds` AS `content_block_cpm_partner_wo_nds`,
    `_content_block_cpmh_all_wo_nds` AS `content_block_cpmh_all_wo_nds`,
    `_content_block_cpmh_partner_wo_nds` AS `content_block_cpmh_partner_wo_nds`,
    `_content_block_direct_clicks` AS `content_block_direct_clicks`,
    `_content_block_direct_ctr` AS `content_block_direct_ctr`,
    `_content_block_direct_shows` AS `content_block_direct_shows`,
    `_content_block_hits` AS `content_block_hits`,
    `_content_block_hits_own_adv` AS `content_block_hits_own_adv`,
    `_content_block_hits_unsold` AS `content_block_hits_unsold`,
    `_content_block_rpm_all_wo_nds` AS `content_block_rpm_all_wo_nds`,
    `_content_block_rpm_partner_wo_nds` AS `content_block_rpm_partner_wo_nds`,
    `_content_block_shows` AS `content_block_shows`,
    `_content_block_shows_own_adv` AS `content_block_shows_own_adv`,
    `_content_block_visibility` AS `content_block_visibility`,
    `_content_block_winrate` AS `content_block_winrate`,
    `_content_partner_wo_nds` AS `content_partner_wo_nds`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_direct_ad_coverage` AS `direct_ad_coverage`,
    `_direct_ad_reach` AS `direct_ad_reach`,
    `_direct_ad_visibility` AS `direct_ad_visibility`,
    `_direct_context_ads` AS `direct_context_ads`,
    `_direct_context_all_wo_nds` AS `direct_context_all_wo_nds`,
    `_direct_context_clicks` AS `direct_context_clicks`,
    `_direct_context_cpc_direct_context_all_wo_nds` AS `direct_context_cpc_direct_context_all_wo_nds`,
    `_direct_context_cpc_direct_context_partner_wo_nds` AS `direct_context_cpc_direct_context_partner_wo_nds`,
    `_direct_context_cpm_direct_context_all_wo_nds` AS `direct_context_cpm_direct_context_all_wo_nds`,
    `_direct_context_cpm_direct_context_partner_wo_nds` AS `direct_context_cpm_direct_context_partner_wo_nds`,
    `_direct_context_cpmh_direct_context_all_wo_nds` AS `direct_context_cpmh_direct_context_all_wo_nds`,
    `_direct_context_cpmh_direct_context_partner_wo_nds` AS `direct_context_cpmh_direct_context_partner_wo_nds`,
    `_direct_context_ctr` AS `direct_context_ctr`,
    `_direct_context_hits` AS `direct_context_hits`,
    `_direct_context_page_ad_shows` AS `direct_context_page_ad_shows`,
    `_direct_context_partner_wo_nds` AS `direct_context_partner_wo_nds`,
    `_direct_context_shows` AS `direct_context_shows`,
    `_direct_search_ads` AS `direct_search_ads`,
    `_direct_search_all_wo_nds` AS `direct_search_all_wo_nds`,
    `_direct_search_clicks` AS `direct_search_clicks`,
    `_direct_search_cpc_direct_search_all_wo_nds` AS `direct_search_cpc_direct_search_all_wo_nds`,
    `_direct_search_cpc_direct_search_partner_wo_nds` AS `direct_search_cpc_direct_search_partner_wo_nds`,
    `_direct_search_cpm_direct_search_all_wo_nds` AS `direct_search_cpm_direct_search_all_wo_nds`,
    `_direct_search_cpm_direct_search_partner_wo_nds` AS `direct_search_cpm_direct_search_partner_wo_nds`,
    `_direct_search_cpmh_direct_search_all_wo_nds` AS `direct_search_cpmh_direct_search_all_wo_nds`,
    `_direct_search_cpmh_direct_search_partner_wo_nds` AS `direct_search_cpmh_direct_search_partner_wo_nds`,
    `_direct_search_ctr` AS `direct_search_ctr`,
    `_direct_search_hits` AS `direct_search_hits`,
    `_direct_search_page_ad_shows` AS `direct_search_page_ad_shows`,
    `_direct_search_partner_wo_nds` AS `direct_search_partner_wo_nds`,
    `_direct_search_shows` AS `direct_search_shows`,
    `_fullscreen_all_wo_nds` AS `fullscreen_all_wo_nds`,
    `_fullscreen_block_all_hits` AS `fullscreen_block_all_hits`,
    `_fullscreen_block_bad_shows` AS `fullscreen_block_bad_shows`,
    `_fullscreen_block_bad_shows_own_adv` AS `fullscreen_block_bad_shows_own_adv`,
    `_fullscreen_block_bad_shows_percent` AS `fullscreen_block_bad_shows_percent`,
    `_fullscreen_block_bad_win_hits` AS `fullscreen_block_bad_win_hits`,
    `_fullscreen_block_bad_win_hits_own_adv` AS `fullscreen_block_bad_win_hits_own_adv`,
    `_fullscreen_block_bad_win_hits_percent` AS `fullscreen_block_bad_win_hits_percent`,
    `_fullscreen_block_bad_win_hits_unsold` AS `fullscreen_block_bad_win_hits_unsold`,
    `_fullscreen_block_cover_ratio` AS `fullscreen_block_cover_ratio`,
    `_fullscreen_block_cpm_all_wo_nds` AS `fullscreen_block_cpm_all_wo_nds`,
    `_fullscreen_block_cpm_partner_wo_nds` AS `fullscreen_block_cpm_partner_wo_nds`,
    `_fullscreen_block_cpmh_all_wo_nds` AS `fullscreen_block_cpmh_all_wo_nds`,
    `_fullscreen_block_cpmh_partner_wo_nds` AS `fullscreen_block_cpmh_partner_wo_nds`,
    `_fullscreen_block_direct_clicks` AS `fullscreen_block_direct_clicks`,
    `_fullscreen_block_direct_ctr` AS `fullscreen_block_direct_ctr`,
    `_fullscreen_block_direct_shows` AS `fullscreen_block_direct_shows`,
    `_fullscreen_block_hits` AS `fullscreen_block_hits`,
    `_fullscreen_block_hits_own_adv` AS `fullscreen_block_hits_own_adv`,
    `_fullscreen_block_hits_unsold` AS `fullscreen_block_hits_unsold`,
    `_fullscreen_block_shows` AS `fullscreen_block_shows`,
    `_fullscreen_block_shows_own_adv` AS `fullscreen_block_shows_own_adv`,
    `_fullscreen_block_visibility` AS `fullscreen_block_visibility`,
    `_fullscreen_block_winrate` AS `fullscreen_block_winrate`,
    `_fullscreen_partner_wo_nds` AS `fullscreen_partner_wo_nds`,
    `_indoor_all_wo_nds` AS `indoor_all_wo_nds`,
    `_indoor_block_all_hits` AS `indoor_block_all_hits`,
    `_indoor_block_bad_shows` AS `indoor_block_bad_shows`,
    `_indoor_block_bad_shows_own_adv` AS `indoor_block_bad_shows_own_adv`,
    `_indoor_block_bad_shows_percent` AS `indoor_block_bad_shows_percent`,
    `_indoor_block_bad_win_hits` AS `indoor_block_bad_win_hits`,
    `_indoor_block_bad_win_hits_own_adv` AS `indoor_block_bad_win_hits_own_adv`,
    `_indoor_block_bad_win_hits_percent` AS `indoor_block_bad_win_hits_percent`,
    `_indoor_block_bad_win_hits_unsold` AS `indoor_block_bad_win_hits_unsold`,
    `_indoor_block_cover_ratio` AS `indoor_block_cover_ratio`,
    `_indoor_block_cpm_all_wo_nds` AS `indoor_block_cpm_all_wo_nds`,
    `_indoor_block_cpm_partner_wo_nds` AS `indoor_block_cpm_partner_wo_nds`,
    `_indoor_block_cpmh_all_wo_nds` AS `indoor_block_cpmh_all_wo_nds`,
    `_indoor_block_cpmh_partner_wo_nds` AS `indoor_block_cpmh_partner_wo_nds`,
    `_indoor_block_direct_clicks` AS `indoor_block_direct_clicks`,
    `_indoor_block_direct_ctr` AS `indoor_block_direct_ctr`,
    `_indoor_block_direct_shows` AS `indoor_block_direct_shows`,
    `_indoor_block_hits` AS `indoor_block_hits`,
    `_indoor_block_hits_own_adv` AS `indoor_block_hits_own_adv`,
    `_indoor_block_hits_unsold` AS `indoor_block_hits_unsold`,
    `_indoor_block_shows` AS `indoor_block_shows`,
    `_indoor_block_shows_own_adv` AS `indoor_block_shows_own_adv`,
    `_indoor_block_visibility` AS `indoor_block_visibility`,
    `_indoor_block_winrate` AS `indoor_block_winrate`,
    `_indoor_partner_wo_nds` AS `indoor_partner_wo_nds`,
    `_inpage_all_wo_nds` AS `inpage_all_wo_nds`,
    `_inpage_block_all_hits` AS `inpage_block_all_hits`,
    `_inpage_block_bad_shows` AS `inpage_block_bad_shows`,
    `_inpage_block_bad_shows_own_adv` AS `inpage_block_bad_shows_own_adv`,
    `_inpage_block_bad_shows_percent` AS `inpage_block_bad_shows_percent`,
    `_inpage_block_bad_win_hits` AS `inpage_block_bad_win_hits`,
    `_inpage_block_bad_win_hits_own_adv` AS `inpage_block_bad_win_hits_own_adv`,
    `_inpage_block_bad_win_hits_percent` AS `inpage_block_bad_win_hits_percent`,
    `_inpage_block_bad_win_hits_unsold` AS `inpage_block_bad_win_hits_unsold`,
    `_inpage_block_cover_ratio` AS `inpage_block_cover_ratio`,
    `_inpage_block_cpm_all_wo_nds` AS `inpage_block_cpm_all_wo_nds`,
    `_inpage_block_cpm_partner_wo_nds` AS `inpage_block_cpm_partner_wo_nds`,
    `_inpage_block_cpmh_all_wo_nds` AS `inpage_block_cpmh_all_wo_nds`,
    `_inpage_block_cpmh_partner_wo_nds` AS `inpage_block_cpmh_partner_wo_nds`,
    `_inpage_block_direct_clicks` AS `inpage_block_direct_clicks`,
    `_inpage_block_direct_ctr` AS `inpage_block_direct_ctr`,
    `_inpage_block_direct_shows` AS `inpage_block_direct_shows`,
    `_inpage_block_hits` AS `inpage_block_hits`,
    `_inpage_block_hits_own_adv` AS `inpage_block_hits_own_adv`,
    `_inpage_block_hits_unsold` AS `inpage_block_hits_unsold`,
    `_inpage_block_shows` AS `inpage_block_shows`,
    `_inpage_block_shows_own_adv` AS `inpage_block_shows_own_adv`,
    `_inpage_block_visibility` AS `inpage_block_visibility`,
    `_inpage_block_winrate` AS `inpage_block_winrate`,
    `_inpage_partner_wo_nds` AS `inpage_partner_wo_nds`,
    `_instream_all_wo_nds` AS `instream_all_wo_nds`,
    `_instream_block_all_hits` AS `instream_block_all_hits`,
    `_instream_block_bad_shows` AS `instream_block_bad_shows`,
    `_instream_block_bad_shows_own_adv` AS `instream_block_bad_shows_own_adv`,
    `_instream_block_bad_shows_percent` AS `instream_block_bad_shows_percent`,
    `_instream_block_bad_win_hits` AS `instream_block_bad_win_hits`,
    `_instream_block_bad_win_hits_own_adv` AS `instream_block_bad_win_hits_own_adv`,
    `_instream_block_bad_win_hits_percent` AS `instream_block_bad_win_hits_percent`,
    `_instream_block_bad_win_hits_unsold` AS `instream_block_bad_win_hits_unsold`,
    `_instream_block_cover_ratio` AS `instream_block_cover_ratio`,
    `_instream_block_cpm_all_wo_nds` AS `instream_block_cpm_all_wo_nds`,
    `_instream_block_cpm_partner_wo_nds` AS `instream_block_cpm_partner_wo_nds`,
    `_instream_block_cpmh_all_wo_nds` AS `instream_block_cpmh_all_wo_nds`,
    `_instream_block_cpmh_partner_wo_nds` AS `instream_block_cpmh_partner_wo_nds`,
    `_instream_block_ctr` AS `instream_block_ctr`,
    `_instream_block_direct_clicks` AS `instream_block_direct_clicks`,
    `_instream_block_direct_ctr` AS `instream_block_direct_ctr`,
    `_instream_block_direct_shows` AS `instream_block_direct_shows`,
    `_instream_block_hits` AS `instream_block_hits`,
    `_instream_block_hits_own_adv` AS `instream_block_hits_own_adv`,
    `_instream_block_hits_unsold` AS `instream_block_hits_unsold`,
    `_instream_block_midroll_conversion_percent` AS `instream_block_midroll_conversion_percent`,
    `_instream_block_midroll_hits` AS `instream_block_midroll_hits`,
    `_instream_block_midroll_shows` AS `instream_block_midroll_shows`,
    `_instream_block_open_player` AS `instream_block_open_player`,
    `_instream_block_pauseroll_conversion_percent` AS `instream_block_pauseroll_conversion_percent`,
    `_instream_block_pauseroll_hits` AS `instream_block_pauseroll_hits`,
    `_instream_block_pauseroll_shows` AS `instream_block_pauseroll_shows`,
    `_instream_block_postroll_conversion_percent` AS `instream_block_postroll_conversion_percent`,
    `_instream_block_postroll_hits` AS `instream_block_postroll_hits`,
    `_instream_block_postroll_shows` AS `instream_block_postroll_shows`,
    `_instream_block_preroll_conversion_percent` AS `instream_block_preroll_conversion_percent`,
    `_instream_block_preroll_hits` AS `instream_block_preroll_hits`,
    `_instream_block_preroll_shows` AS `instream_block_preroll_shows`,
    `_instream_block_shows` AS `instream_block_shows`,
    `_instream_block_shows_own_adv` AS `instream_block_shows_own_adv`,
    `_instream_block_view` AS `instream_block_view`,
    `_instream_block_visibility` AS `instream_block_visibility`,
    `_instream_block_winrate` AS `instream_block_winrate`,
    `_instream_partner_wo_nds` AS `instream_partner_wo_nds`,
    `_login` AS `login`,
    `_market_api_context_all_wo_nds` AS `market_api_context_all_wo_nds`,
    `_market_api_context_clicks` AS `market_api_context_clicks`,
    `_market_api_context_cpc_market_api_context_all_wo_nds` AS `market_api_context_cpc_market_api_context_all_wo_nds`,
    `_market_api_context_cpc_market_api_context_partner_wo_nds` AS `market_api_context_cpc_market_api_context_partner_wo_nds`,
    `_market_api_context_cpm_market_api_context_all_wo_nds` AS `market_api_context_cpm_market_api_context_all_wo_nds`,
    `_market_api_context_cpm_market_api_context_partner_wo_nds` AS `market_api_context_cpm_market_api_context_partner_wo_nds`,
    `_market_api_context_ctr` AS `market_api_context_ctr`,
    `_market_api_context_partner_wo_nds` AS `market_api_context_partner_wo_nds`,
    `_market_api_context_shows` AS `market_api_context_shows`,
    `_market_api_search_all_wo_nds` AS `market_api_search_all_wo_nds`,
    `_market_api_search_clicks` AS `market_api_search_clicks`,
    `_market_api_search_cpc_market_api_search_all_wo_nds` AS `market_api_search_cpc_market_api_search_all_wo_nds`,
    `_market_api_search_cpc_market_api_search_partner_wo_nds` AS `market_api_search_cpc_market_api_search_partner_wo_nds`,
    `_market_api_search_cpm_market_api_search_all_wo_nds` AS `market_api_search_cpm_market_api_search_all_wo_nds`,
    `_market_api_search_cpm_market_api_search_partner_wo_nds` AS `market_api_search_cpm_market_api_search_partner_wo_nds`,
    `_market_api_search_ctr` AS `market_api_search_ctr`,
    `_market_api_search_partner_wo_nds` AS `market_api_search_partner_wo_nds`,
    `_market_api_search_shows` AS `market_api_search_shows`,
    `_market_context_all_wo_nds` AS `market_context_all_wo_nds`,
    `_market_context_clicks` AS `market_context_clicks`,
    `_market_context_cpc_market_context_all_wo_nds` AS `market_context_cpc_market_context_all_wo_nds`,
    `_market_context_cpc_market_context_partner_wo_nds` AS `market_context_cpc_market_context_partner_wo_nds`,
    `_market_context_cpm_market_context_all_wo_nds` AS `market_context_cpm_market_context_all_wo_nds`,
    `_market_context_cpm_market_context_partner_wo_nds` AS `market_context_cpm_market_context_partner_wo_nds`,
    `_market_context_cpmh_market_context_all_wo_nds` AS `market_context_cpmh_market_context_all_wo_nds`,
    `_market_context_cpmh_market_context_partner_wo_nds` AS `market_context_cpmh_market_context_partner_wo_nds`,
    `_market_context_ctr` AS `market_context_ctr`,
    `_market_context_hits` AS `market_context_hits`,
    `_market_context_partner_wo_nds` AS `market_context_partner_wo_nds`,
    `_market_context_shows` AS `market_context_shows`,
    `_market_search_all_wo_nds` AS `market_search_all_wo_nds`,
    `_market_search_clicks` AS `market_search_clicks`,
    `_market_search_cpc_market_search_all_wo_nds` AS `market_search_cpc_market_search_all_wo_nds`,
    `_market_search_cpc_market_search_partner_wo_nds` AS `market_search_cpc_market_search_partner_wo_nds`,
    `_market_search_cpm_market_search_all_wo_nds` AS `market_search_cpm_market_search_all_wo_nds`,
    `_market_search_cpm_market_search_partner_wo_nds` AS `market_search_cpm_market_search_partner_wo_nds`,
    `_market_search_cpmh_market_search_all_wo_nds` AS `market_search_cpmh_market_search_all_wo_nds`,
    `_market_search_cpmh_market_search_partner_wo_nds` AS `market_search_cpmh_market_search_partner_wo_nds`,
    `_market_search_ctr` AS `market_search_ctr`,
    `_market_search_hits` AS `market_search_hits`,
    `_market_search_partner_wo_nds` AS `market_search_partner_wo_nds`,
    `_market_search_shows` AS `market_search_shows`,
    `_mcb_context_all_wo_nds` AS `mcb_context_all_wo_nds`,
    `_mcb_context_clicks` AS `mcb_context_clicks`,
    `_mcb_context_cpm_mcb_context_all_wo_nds` AS `mcb_context_cpm_mcb_context_all_wo_nds`,
    `_mcb_context_cpm_mcb_context_partner_wo_nds` AS `mcb_context_cpm_mcb_context_partner_wo_nds`,
    `_mcb_context_cpmh_mcb_context_all_wo_nds` AS `mcb_context_cpmh_mcb_context_all_wo_nds`,
    `_mcb_context_cpmh_mcb_context_partner_wo_nds` AS `mcb_context_cpmh_mcb_context_partner_wo_nds`,
    `_mcb_context_ctr` AS `mcb_context_ctr`,
    `_mcb_context_hits` AS `mcb_context_hits`,
    `_mcb_context_partner_wo_nds` AS `mcb_context_partner_wo_nds`,
    `_mcb_context_shows` AS `mcb_context_shows`,
    `_mcb_search_all_wo_nds` AS `mcb_search_all_wo_nds`,
    `_mcb_search_clicks` AS `mcb_search_clicks`,
    `_mcb_search_cpm_mcb_search_all_wo_nds` AS `mcb_search_cpm_mcb_search_all_wo_nds`,
    `_mcb_search_cpm_mcb_search_partner_wo_nds` AS `mcb_search_cpm_mcb_search_partner_wo_nds`,
    `_mcb_search_cpmh_mcb_search_all_wo_nds` AS `mcb_search_cpmh_mcb_search_all_wo_nds`,
    `_mcb_search_cpmh_mcb_search_partner_wo_nds` AS `mcb_search_cpmh_mcb_search_partner_wo_nds`,
    `_mcb_search_ctr` AS `mcb_search_ctr`,
    `_mcb_search_hits` AS `mcb_search_hits`,
    `_mcb_search_partner_wo_nds` AS `mcb_search_partner_wo_nds`,
    `_mcb_search_shows` AS `mcb_search_shows`,
    `_mobile_rtb_all_wo_nds` AS `mobile_rtb_all_wo_nds`,
    `_mobile_rtb_bad_win_partner_price_wo_nds` AS `mobile_rtb_bad_win_partner_price_wo_nds`,
    `_mobile_rtb_bad_win_price_wo_nds` AS `mobile_rtb_bad_win_price_wo_nds`,
    `_mobile_rtb_block_all_hits` AS `mobile_rtb_block_all_hits`,
    `_mobile_rtb_block_bad_shows` AS `mobile_rtb_block_bad_shows`,
    `_mobile_rtb_block_bad_shows_own_adv` AS `mobile_rtb_block_bad_shows_own_adv`,
    `_mobile_rtb_block_bad_shows_percent` AS `mobile_rtb_block_bad_shows_percent`,
    `_mobile_rtb_block_bad_win_hits` AS `mobile_rtb_block_bad_win_hits`,
    `_mobile_rtb_block_bad_win_hits_own_adv` AS `mobile_rtb_block_bad_win_hits_own_adv`,
    `_mobile_rtb_block_bad_win_hits_percent` AS `mobile_rtb_block_bad_win_hits_percent`,
    `_mobile_rtb_block_bad_win_hits_unsold` AS `mobile_rtb_block_bad_win_hits_unsold`,
    `_mobile_rtb_block_cover_ratio` AS `mobile_rtb_block_cover_ratio`,
    `_mobile_rtb_block_cpm_all_wo_nds` AS `mobile_rtb_block_cpm_all_wo_nds`,
    `_mobile_rtb_block_cpm_partner_wo_nds` AS `mobile_rtb_block_cpm_partner_wo_nds`,
    `_mobile_rtb_block_cpmh_all_wo_nds` AS `mobile_rtb_block_cpmh_all_wo_nds`,
    `_mobile_rtb_block_cpmh_partner_wo_nds` AS `mobile_rtb_block_cpmh_partner_wo_nds`,
    `_mobile_rtb_block_direct_clicks` AS `mobile_rtb_block_direct_clicks`,
    `_mobile_rtb_block_direct_ctr` AS `mobile_rtb_block_direct_ctr`,
    `_mobile_rtb_block_direct_shows` AS `mobile_rtb_block_direct_shows`,
    `_mobile_rtb_block_hits` AS `mobile_rtb_block_hits`,
    `_mobile_rtb_block_hits_own_adv` AS `mobile_rtb_block_hits_own_adv`,
    `_mobile_rtb_block_hits_unsold` AS `mobile_rtb_block_hits_unsold`,
    `_mobile_rtb_block_rpm_all_wo_nds` AS `mobile_rtb_block_rpm_all_wo_nds`,
    `_mobile_rtb_block_rpm_partner_wo_nds` AS `mobile_rtb_block_rpm_partner_wo_nds`,
    `_mobile_rtb_block_shows` AS `mobile_rtb_block_shows`,
    `_mobile_rtb_block_shows_own_adv` AS `mobile_rtb_block_shows_own_adv`,
    `_mobile_rtb_block_visibility` AS `mobile_rtb_block_visibility`,
    `_mobile_rtb_block_winrate` AS `mobile_rtb_block_winrate`,
    `_mobile_rtb_partner_wo_nds` AS `mobile_rtb_partner_wo_nds`,
    `_natural_all_wo_nds` AS `natural_all_wo_nds`,
    `_natural_bad_win_partner_price_wo_nds` AS `natural_bad_win_partner_price_wo_nds`,
    `_natural_bad_win_price_wo_nds` AS `natural_bad_win_price_wo_nds`,
    `_natural_block_all_hits` AS `natural_block_all_hits`,
    `_natural_block_bad_shows` AS `natural_block_bad_shows`,
    `_natural_block_bad_shows_own_adv` AS `natural_block_bad_shows_own_adv`,
    `_natural_block_bad_shows_percent` AS `natural_block_bad_shows_percent`,
    `_natural_block_bad_win_hits` AS `natural_block_bad_win_hits`,
    `_natural_block_bad_win_hits_own_adv` AS `natural_block_bad_win_hits_own_adv`,
    `_natural_block_bad_win_hits_percent` AS `natural_block_bad_win_hits_percent`,
    `_natural_block_bad_win_hits_unsold` AS `natural_block_bad_win_hits_unsold`,
    `_natural_block_cover_ratio` AS `natural_block_cover_ratio`,
    `_natural_block_cpm_all_wo_nds` AS `natural_block_cpm_all_wo_nds`,
    `_natural_block_cpm_partner_wo_nds` AS `natural_block_cpm_partner_wo_nds`,
    `_natural_block_cpmh_all_wo_nds` AS `natural_block_cpmh_all_wo_nds`,
    `_natural_block_cpmh_partner_wo_nds` AS `natural_block_cpmh_partner_wo_nds`,
    `_natural_block_direct_clicks` AS `natural_block_direct_clicks`,
    `_natural_block_direct_ctr` AS `natural_block_direct_ctr`,
    `_natural_block_direct_shows` AS `natural_block_direct_shows`,
    `_natural_block_hits` AS `natural_block_hits`,
    `_natural_block_hits_own_adv` AS `natural_block_hits_own_adv`,
    `_natural_block_hits_unsold` AS `natural_block_hits_unsold`,
    `_natural_block_rpm_all_wo_nds` AS `natural_block_rpm_all_wo_nds`,
    `_natural_block_rpm_partner_wo_nds` AS `natural_block_rpm_partner_wo_nds`,
    `_natural_block_shows` AS `natural_block_shows`,
    `_natural_block_shows_own_adv` AS `natural_block_shows_own_adv`,
    `_natural_block_visibility` AS `natural_block_visibility`,
    `_natural_block_winrate` AS `natural_block_winrate`,
    `_natural_partner_wo_nds` AS `natural_partner_wo_nds`,
    `_outdoor_all_wo_nds` AS `outdoor_all_wo_nds`,
    `_outdoor_block_all_hits` AS `outdoor_block_all_hits`,
    `_outdoor_block_bad_shows` AS `outdoor_block_bad_shows`,
    `_outdoor_block_bad_shows_own_adv` AS `outdoor_block_bad_shows_own_adv`,
    `_outdoor_block_bad_shows_percent` AS `outdoor_block_bad_shows_percent`,
    `_outdoor_block_bad_win_hits` AS `outdoor_block_bad_win_hits`,
    `_outdoor_block_bad_win_hits_own_adv` AS `outdoor_block_bad_win_hits_own_adv`,
    `_outdoor_block_bad_win_hits_percent` AS `outdoor_block_bad_win_hits_percent`,
    `_outdoor_block_bad_win_hits_unsold` AS `outdoor_block_bad_win_hits_unsold`,
    `_outdoor_block_cover_ratio` AS `outdoor_block_cover_ratio`,
    `_outdoor_block_cpm_all_wo_nds` AS `outdoor_block_cpm_all_wo_nds`,
    `_outdoor_block_cpm_partner_wo_nds` AS `outdoor_block_cpm_partner_wo_nds`,
    `_outdoor_block_cpmh_all_wo_nds` AS `outdoor_block_cpmh_all_wo_nds`,
    `_outdoor_block_cpmh_partner_wo_nds` AS `outdoor_block_cpmh_partner_wo_nds`,
    `_outdoor_block_direct_clicks` AS `outdoor_block_direct_clicks`,
    `_outdoor_block_direct_ctr` AS `outdoor_block_direct_ctr`,
    `_outdoor_block_direct_shows` AS `outdoor_block_direct_shows`,
    `_outdoor_block_hits` AS `outdoor_block_hits`,
    `_outdoor_block_hits_own_adv` AS `outdoor_block_hits_own_adv`,
    `_outdoor_block_hits_unsold` AS `outdoor_block_hits_unsold`,
    `_outdoor_block_shows` AS `outdoor_block_shows`,
    `_outdoor_block_shows_own_adv` AS `outdoor_block_shows_own_adv`,
    `_outdoor_block_visibility` AS `outdoor_block_visibility`,
    `_outdoor_block_winrate` AS `outdoor_block_winrate`,
    `_outdoor_partner_wo_nds` AS `outdoor_partner_wo_nds`,
    `_partner_wo_nds` AS `partner_wo_nds`,
    `_percent_content_bad_win_partner_price_content_partner_wo_nds` AS `percent_content_bad_win_partner_price_content_partner_wo_nds`,
    `_percent_content_bad_win_price_content_all_wo_nds` AS `percent_content_bad_win_price_content_all_wo_nds`,
    `_percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds` AS `percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`,
    `_percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds` AS `percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`,
    `_percent_natural_bad_win_partner_price_natural_partner_wo_nds` AS `percent_natural_bad_win_partner_price_natural_partner_wo_nds`,
    `_percent_natural_bad_win_price_natural_all_wo_nds` AS `percent_natural_bad_win_price_natural_all_wo_nds`,
    `_percent_rtb_bad_win_partner_price_rtb_partner_wo_nds` AS `percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`,
    `_percent_rtb_bad_win_price_rtb_all_wo_nds` AS `percent_rtb_bad_win_price_rtb_all_wo_nds`,
    `_premium_ads` AS `premium_ads`,
    `_premium_all_wo_nds` AS `premium_all_wo_nds`,
    `_premium_clicks` AS `premium_clicks`,
    `_premium_cpc_all_wo_nds` AS `premium_cpc_all_wo_nds`,
    `_premium_cpc_partner_wo_nds` AS `premium_cpc_partner_wo_nds`,
    `_premium_cpm_all_wo_nds` AS `premium_cpm_all_wo_nds`,
    `_premium_cpm_partner_wo_nds` AS `premium_cpm_partner_wo_nds`,
    `_premium_cpmh_all_wo_nds` AS `premium_cpmh_all_wo_nds`,
    `_premium_cpmh_partner_wo_nds` AS `premium_cpmh_partner_wo_nds`,
    `_premium_ctr` AS `premium_ctr`,
    `_premium_hits` AS `premium_hits`,
    `_premium_page_ad_shows` AS `premium_page_ad_shows`,
    `_premium_partner_wo_nds` AS `premium_partner_wo_nds`,
    `_premium_shows` AS `premium_shows`,
    `_rtb_all_wo_nds` AS `rtb_all_wo_nds`,
    `_rtb_bad_win_partner_price_wo_nds` AS `rtb_bad_win_partner_price_wo_nds`,
    `_rtb_bad_win_price_wo_nds` AS `rtb_bad_win_price_wo_nds`,
    `_rtb_block_all_hits` AS `rtb_block_all_hits`,
    `_rtb_block_bad_shows` AS `rtb_block_bad_shows`,
    `_rtb_block_bad_shows_own_adv` AS `rtb_block_bad_shows_own_adv`,
    `_rtb_block_bad_shows_percent` AS `rtb_block_bad_shows_percent`,
    `_rtb_block_bad_win_hits` AS `rtb_block_bad_win_hits`,
    `_rtb_block_bad_win_hits_own_adv` AS `rtb_block_bad_win_hits_own_adv`,
    `_rtb_block_bad_win_hits_percent` AS `rtb_block_bad_win_hits_percent`,
    `_rtb_block_bad_win_hits_unsold` AS `rtb_block_bad_win_hits_unsold`,
    `_rtb_block_cover_ratio` AS `rtb_block_cover_ratio`,
    `_rtb_block_cpm_all_wo_nds` AS `rtb_block_cpm_all_wo_nds`,
    `_rtb_block_cpm_partner_wo_nds` AS `rtb_block_cpm_partner_wo_nds`,
    `_rtb_block_cpmh_all_wo_nds` AS `rtb_block_cpmh_all_wo_nds`,
    `_rtb_block_cpmh_partner_wo_nds` AS `rtb_block_cpmh_partner_wo_nds`,
    `_rtb_block_direct_clicks` AS `rtb_block_direct_clicks`,
    `_rtb_block_direct_ctr` AS `rtb_block_direct_ctr`,
    `_rtb_block_direct_shows` AS `rtb_block_direct_shows`,
    `_rtb_block_hits` AS `rtb_block_hits`,
    `_rtb_block_hits_own_adv` AS `rtb_block_hits_own_adv`,
    `_rtb_block_hits_unsold` AS `rtb_block_hits_unsold`,
    `_rtb_block_rpm_all_wo_nds` AS `rtb_block_rpm_all_wo_nds`,
    `_rtb_block_rpm_partner_wo_nds` AS `rtb_block_rpm_partner_wo_nds`,
    `_rtb_block_shows` AS `rtb_block_shows`,
    `_rtb_block_shows_own_adv` AS `rtb_block_shows_own_adv`,
    `_rtb_block_visibility` AS `rtb_block_visibility`,
    `_rtb_block_winrate` AS `rtb_block_winrate`,
    `_rtb_partner_wo_nds` AS `rtb_partner_wo_nds`,
    `_ssp_mobile_rtb_all_wo_nds` AS `ssp_mobile_rtb_all_wo_nds`,
    `_ssp_mobile_rtb_block_all_hits` AS `ssp_mobile_rtb_block_all_hits`,
    `_ssp_mobile_rtb_block_cover_ratio` AS `ssp_mobile_rtb_block_cover_ratio`,
    `_ssp_mobile_rtb_block_cpm_all_wo_nds` AS `ssp_mobile_rtb_block_cpm_all_wo_nds`,
    `_ssp_mobile_rtb_block_cpm_partner_wo_nds` AS `ssp_mobile_rtb_block_cpm_partner_wo_nds`,
    `_ssp_mobile_rtb_block_cpmh_all_wo_nds` AS `ssp_mobile_rtb_block_cpmh_all_wo_nds`,
    `_ssp_mobile_rtb_block_cpmh_partner_wo_nds` AS `ssp_mobile_rtb_block_cpmh_partner_wo_nds`,
    `_ssp_mobile_rtb_block_hits` AS `ssp_mobile_rtb_block_hits`,
    `_ssp_mobile_rtb_block_hits_own_adv` AS `ssp_mobile_rtb_block_hits_own_adv`,
    `_ssp_mobile_rtb_block_hits_unsold` AS `ssp_mobile_rtb_block_hits_unsold`,
    `_ssp_mobile_rtb_block_rpm_all_wo_nds` AS `ssp_mobile_rtb_block_rpm_all_wo_nds`,
    `_ssp_mobile_rtb_block_rpm_partner_wo_nds` AS `ssp_mobile_rtb_block_rpm_partner_wo_nds`,
    `_ssp_mobile_rtb_block_shows` AS `ssp_mobile_rtb_block_shows`,
    `_ssp_mobile_rtb_block_visibility` AS `ssp_mobile_rtb_block_visibility`,
    `_ssp_mobile_rtb_block_winrate` AS `ssp_mobile_rtb_block_winrate`,
    `_ssp_mobile_rtb_partner_wo_nds` AS `ssp_mobile_rtb_partner_wo_nds`,
    `_stripe_all_wo_nds` AS `stripe_all_wo_nds`,
    `_stripe_clicks` AS `stripe_clicks`,
    `_stripe_cpc_all_wo_nds` AS `stripe_cpc_all_wo_nds`,
    `_stripe_cpc_partner_wo_nds` AS `stripe_cpc_partner_wo_nds`,
    `_stripe_cpm_all_wo_nds` AS `stripe_cpm_all_wo_nds`,
    `_stripe_cpm_partner_wo_nds` AS `stripe_cpm_partner_wo_nds`,
    `_stripe_cpmh_all_wo_nds` AS `stripe_cpmh_all_wo_nds`,
    `_stripe_cpmh_partner_wo_nds` AS `stripe_cpmh_partner_wo_nds`,
    `_stripe_ctr` AS `stripe_ctr`,
    `_stripe_hits` AS `stripe_hits`,
    `_stripe_partner_wo_nds` AS `stripe_partner_wo_nds`,
    `_stripe_shows` AS `stripe_shows`,
    `_video_an_site_all_hits` AS `video_an_site_all_hits`,
    `_video_an_site_all_hits_own_adv` AS `video_an_site_all_hits_own_adv`,
    `_video_an_site_all_hits_unsold` AS `video_an_site_all_hits_unsold`,
    `_video_an_site_all_shows` AS `video_an_site_all_shows`,
    `_video_an_site_all_shows_own_adv` AS `video_an_site_all_shows_own_adv`,
    `_video_an_site_sum_all_hits` AS `video_an_site_sum_all_hits`,
    `_video_an_site_sum_all_wo_nds` AS `video_an_site_sum_all_wo_nds`,
    `_video_an_site_sum_partner_wo_nds` AS `video_an_site_sum_partner_wo_nds`
FROM (
    SELECT
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000), 2) AS `_adblock_all_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_adblock') AS `_adblock_block_all_hits`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_adblock')) AS `_adblock_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            ))), 2) AS `_adblock_block_cpmh_partner_wo_nds`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_adblock')), 2) AS `_adblock_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_adblock')), 2) AS `_adblock_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_adblock'
    )) AS `_adblock_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_adblock'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_adblock'
        ))) AS `_adblock_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_adblock'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_adblock'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_adblock'
            )))) AS `_adblock_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_adblock') / 10000000), 2) AS `_adblock_partner_wo_nds`,
        round((SUM((`all_wo_nds` / 1000)) / 10000000), 2) AS `_all_wo_nds`,
        sumIf(`an_cover_direct_hits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site')) AS `_an_cover_direct_hits`,
        sumIf(`an_cover_hits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site')) AS `_an_cover_hits`,
        sumIf(`an_cover_market_hits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site')) AS `_an_cover_market_hits`,
        sumIf(`an_cover_mcb_hits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site')) AS `_an_cover_mcb_hits`,
        sumIf(`an_cover_senthits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site')) AS `_an_cover_senthits`,
        sumIf(`an_fraud_clicks`, `product_id` IN ('context_on_site_campaign', 'video_an_site', 'ssp_context_on_site_campaign', 'ssp_video_an_site', 'indoor', 'outdoor')) AS `_an_fraud_clicks`,
        sumIf(`an_fraud_shows`, `product_id` IN ('context_on_site_campaign', 'video_an_site', 'ssp_context_on_site_campaign', 'ssp_video_an_site', 'indoor', 'outdoor')) AS `_an_fraud_shows`,
        sumIf(`an_rtb_cover_direct_hits`, `product_id` = 'mobile_app_settings') AS `_an_mobile_rtb_cover_direct_hits`,
        sumIf(`an_rtb_cover_hits`, `product_id` = 'mobile_app_settings') AS `_an_mobile_rtb_cover_hits`,
        sumIf(`an_rtb_cover_senthits`, `product_id` = 'mobile_app_settings') AS `_an_mobile_rtb_cover_senthits`,
        sumIf(`an_rtb_cover_direct_hits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site')) AS `_an_rtb_cover_direct_hits`,
        sumIf(`an_rtb_cover_hits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site')) AS `_an_rtb_cover_hits`,
        sumIf(`an_rtb_cover_senthits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site')) AS `_an_rtb_cover_senthits`,
        sumIf(`an_rtb_cover_direct_hits`, `product_id` = 'ssp_mobile_app_settings') AS `_an_ssp_mobile_rtb_cover_direct_hits`,
        sumIf(`an_rtb_cover_hits`, `product_id` = 'ssp_mobile_app_settings') AS `_an_ssp_mobile_rtb_cover_hits`,
        sumIf(`an_rtb_cover_senthits`, `product_id` = 'ssp_mobile_app_settings') AS `_an_ssp_mobile_rtb_cover_senthits`,
        round((SUM((`bad_win_partner_price_wo_nds` / 1000)) / 10000000), 2) AS `_bad_win_partner_price_wo_nds`,
        round((SUM((`bad_win_price_wo_nds` / 1000)) / 10000000), 2) AS `_bad_win_price_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_content') AS `_content_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )))) AS `_content_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )))) AS `_content_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_content')) AS `_content_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            ))), 2) AS `_content_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'context_on_site_content'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'context_on_site_content')) AS `_content_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'context_on_site_content') AS `_content_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_content')), 2) AS `_content_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_content')), 2) AS `_content_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_content'
    )) AS `_content_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_content'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_content'
        ))) AS `_content_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_content'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_content'
            )))) AS `_content_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') / 10000000), 2) AS `_content_partner_wo_nds`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        ((sumIf(`an_cover_direct_hits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site')) * 100) / sumIf(`an_cover_hits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site'))) AS `_direct_ad_coverage`,
        ((sumIf(`an_cover_senthits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site')) * 100) / sumIf(`an_cover_hits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site'))) AS `_direct_ad_reach`,
        ((sumIf(`an_cover_direct_hits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site')) * 100) / sumIf(`an_cover_senthits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site'))) AS `_direct_ad_visibility`,
        (sumIf(`shows`, `product_id` = 'context_on_site_direct') / sumIf(`direct_page_ad_shows`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site'))) AS `_direct_context_ads`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000), 2) AS `_direct_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_direct') AS `_direct_context_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpc_direct_context_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpc_direct_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpm_direct_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_direct')), 2) AS `_direct_context_cpm_direct_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) * 1000) / sumIf(`direct_hits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site'))), 2) AS `_direct_context_cpmh_direct_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000) * 1000) / sumIf(`direct_hits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site'))), 2) AS `_direct_context_cpmh_direct_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_direct') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_direct')) AS `_direct_context_ctr`,
        sumIf(`direct_hits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site')) AS `_direct_context_hits`,
        sumIf(`direct_page_ad_shows`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site')) AS `_direct_context_page_ad_shows`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_direct') / 10000000), 2) AS `_direct_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_direct') AS `_direct_context_shows`,
        (sumIf(`shows`, `product_id` = 'search_on_site_direct') / sumIf(`direct_page_ad_shows`, `product_id` = 'search_on_site_campaign')) AS `_direct_search_ads`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000), 2) AS `_direct_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_direct') AS `_direct_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpc_direct_search_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpc_direct_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpm_direct_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_direct')), 2) AS `_direct_search_cpm_direct_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) * 1000) / sumIf(`direct_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_direct_search_cpmh_direct_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000) * 1000) / sumIf(`direct_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_direct_search_cpmh_direct_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_direct') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_direct')) AS `_direct_search_ctr`,
        sumIf(`direct_hits`, `product_id` = 'search_on_site_campaign') AS `_direct_search_hits`,
        sumIf(`direct_page_ad_shows`, `product_id` = 'search_on_site_campaign') AS `_direct_search_page_ad_shows`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_direct') / 10000000), 2) AS `_direct_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_direct') AS `_direct_search_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000), 2) AS `_fullscreen_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen') AS `_fullscreen_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )))) AS `_fullscreen_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )))) AS `_fullscreen_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen')) AS `_fullscreen_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'video_an_site_fullscreen')) AS `_fullscreen_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'video_an_site_fullscreen') AS `_fullscreen_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_fullscreen'
            )))) AS `_fullscreen_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_fullscreen'
        ))) AS `_fullscreen_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'video_an_site_fullscreen'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'video_an_site_fullscreen'
                    )))))) AS `_fullscreen_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000), 2) AS `_fullscreen_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'indoor_block') / 10000000), 2) AS `_indoor_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'indoor_block') AS `_indoor_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            )))) AS `_indoor_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            )))) AS `_indoor_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'indoor_block')) AS `_indoor_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'indoor_block') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            ))), 2) AS `_indoor_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'indoor_block') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            ))), 2) AS `_indoor_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'indoor_block') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            ))), 2) AS `_indoor_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'indoor_block') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            ))), 2) AS `_indoor_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'indoor_block'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'indoor_block')) AS `_indoor_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'indoor_block') AS `_indoor_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'indoor_block') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'indoor_block'
            )))) AS `_indoor_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'indoor_block'
        ))) AS `_indoor_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'indoor_block'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'indoor_block') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'indoor_block'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'indoor_block'
                    )))))) AS `_indoor_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'indoor_block') / 10000000), 2) AS `_indoor_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000), 2) AS `_inpage_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage') AS `_inpage_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )))) AS `_inpage_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )))) AS `_inpage_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage')) AS `_inpage_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'video_an_site_inpage')) AS `_inpage_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'video_an_site_inpage') AS `_inpage_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_inpage'
            )))) AS `_inpage_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_inpage'
        ))) AS `_inpage_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_inpage'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'video_an_site_inpage'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'video_an_site_inpage'
                    )))))) AS `_inpage_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000), 2) AS `_inpage_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000), 2) AS `_instream_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') AS `_instream_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )))) AS `_instream_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )))) AS `_instream_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream')) AS `_instream_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpmh_partner_wo_nds`,
        ((sumIf(`open_player`, `product_id` = 'video_an_site') * 100) / sumIf(`view`, `product_id` = 'video_an_site')) AS `_instream_block_ctr`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'video_an_site_instream')) AS `_instream_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'video_an_site_instream') AS `_instream_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_instream'
            )))) AS `_instream_block_hits_unsold`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
                AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 2
            )) * 100) / sumIf(`open_player`, `product_id` = 'video_an_site')) AS `_instream_block_midroll_conversion_percent`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
        AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 2
    )) AS `_instream_block_midroll_hits`,
        sumIf(`shows`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
        AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 2
    )) AS `_instream_block_midroll_shows`,
        sumIf(`open_player`, `product_id` = 'video_an_site') AS `_instream_block_open_player`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
                AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 4
            )) * 100) / sumIf(`open_player`, `product_id` = 'video_an_site')) AS `_instream_block_pauseroll_conversion_percent`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
        AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 4
    )) AS `_instream_block_pauseroll_hits`,
        sumIf(`shows`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
        AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 4
    )) AS `_instream_block_pauseroll_shows`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
                AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 1
            )) * 100) / sumIf(`open_player`, `product_id` = 'video_an_site')) AS `_instream_block_postroll_conversion_percent`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
        AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 1
    )) AS `_instream_block_postroll_hits`,
        sumIf(`shows`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
        AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 1
    )) AS `_instream_block_postroll_shows`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
                AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 0
            )) * 100) / sumIf(`open_player`, `product_id` = 'video_an_site')) AS `_instream_block_preroll_conversion_percent`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
        AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 0
    )) AS `_instream_block_preroll_hits`,
        sumIf(`shows`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
        AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 0
    )) AS `_instream_block_preroll_shows`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_shows_own_adv`,
        sumIf(`view`, `product_id` = 'video_an_site') AS `_instream_block_view`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_instream'
        ))) AS `_instream_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_instream'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'video_an_site_instream'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'video_an_site_instream'
                    )))))) AS `_instream_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000), 2) AS `_instream_partner_wo_nds`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000), 2) AS `_market_api_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_market_api') AS `_market_api_context_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpc_market_api_context_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpc_market_api_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpm_market_api_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market_api')), 2) AS `_market_api_context_cpm_market_api_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_market_api') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_market_api')) AS `_market_api_context_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market_api') / 10000000), 2) AS `_market_api_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_market_api') AS `_market_api_context_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000), 2) AS `_market_api_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_market_api') AS `_market_api_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpc_market_api_search_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpc_market_api_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpm_market_api_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market_api')), 2) AS `_market_api_search_cpm_market_api_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_market_api') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_market_api')) AS `_market_api_search_ctr`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market_api') / 10000000), 2) AS `_market_api_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_market_api') AS `_market_api_search_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000), 2) AS `_market_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_market') AS `_market_context_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpc_market_context_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpc_market_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpm_market_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_market')), 2) AS `_market_context_cpm_market_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) * 1000) / sumIf(`market_hits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site'))), 2) AS `_market_context_cpmh_market_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000) * 1000) / sumIf(`market_hits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site'))), 2) AS `_market_context_cpmh_market_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_market') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_market')) AS `_market_context_ctr`,
        sumIf(`market_hits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site')) AS `_market_context_hits`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_market') / 10000000), 2) AS `_market_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_market') AS `_market_context_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000), 2) AS `_market_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_market') AS `_market_search_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpc_market_search_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpc_market_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpm_market_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_market')), 2) AS `_market_search_cpm_market_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`market_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_market_search_cpmh_market_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000) * 1000) / sumIf(`market_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_market_search_cpmh_market_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_market') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_market')) AS `_market_search_ctr`,
        sumIf(`market_hits`, `product_id` = 'search_on_site_campaign') AS `_market_search_hits`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_market') / 10000000), 2) AS `_market_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_market') AS `_market_search_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000), 2) AS `_mcb_context_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_mcb') AS `_mcb_context_clicks`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_mcb')), 2) AS `_mcb_context_cpm_mcb_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_mcb')), 2) AS `_mcb_context_cpm_mcb_context_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000) * 1000) / sumIf(`mcb_hits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site'))), 2) AS `_mcb_context_cpmh_mcb_context_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000) * 1000) / sumIf(`mcb_hits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site'))), 2) AS `_mcb_context_cpmh_mcb_context_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_mcb') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_mcb')) AS `_mcb_context_ctr`,
        sumIf(`mcb_hits`, `product_id` IN ('context_on_site_campaign', 'ssp_context_on_site_campaign', 'ssp_video_an_site')) AS `_mcb_context_hits`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_mcb') / 10000000), 2) AS `_mcb_context_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_mcb') AS `_mcb_context_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000), 2) AS `_mcb_search_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_mcb') AS `_mcb_search_clicks`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_mcb')), 2) AS `_mcb_search_cpm_mcb_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_mcb')), 2) AS `_mcb_search_cpm_mcb_search_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000) * 1000) / sumIf(`mcb_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_mcb_search_cpmh_mcb_search_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000) * 1000) / sumIf(`mcb_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_mcb_search_cpmh_mcb_search_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_mcb') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_mcb')) AS `_mcb_search_ctr`,
        sumIf(`mcb_hits`, `product_id` = 'search_on_site_campaign') AS `_mcb_search_hits`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_mcb') / 10000000), 2) AS `_mcb_search_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_mcb') AS `_mcb_search_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'mobile_app_rtb') AS `_mobile_rtb_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )))) AS `_mobile_rtb_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )))) AS `_mobile_rtb_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / sumIf(`hits`, `product_id` = 'mobile_app_rtb')) AS `_mobile_rtb_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            ))), 2) AS `_mobile_rtb_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'mobile_app_rtb')) AS `_mobile_rtb_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'mobile_app_rtb') AS `_mobile_rtb_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'mobile_app_rtb')), 2) AS `_mobile_rtb_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'mobile_app_rtb')), 2) AS `_mobile_rtb_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'mobile_app_rtb'
    )) AS `_mobile_rtb_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'mobile_app_rtb'
        ))) AS `_mobile_rtb_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'mobile_app_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'mobile_app_rtb'
            )))) AS `_mobile_rtb_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') / 10000000), 2) AS `_mobile_rtb_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'context_on_site_natural') AS `_natural_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )))) AS `_natural_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )))) AS `_natural_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / sumIf(`hits`, `product_id` = 'context_on_site_natural')) AS `_natural_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            ))), 2) AS `_natural_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'context_on_site_natural')) AS `_natural_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'context_on_site_natural') AS `_natural_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_natural')), 2) AS `_natural_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_natural')), 2) AS `_natural_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'context_on_site_natural'
    )) AS `_natural_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'context_on_site_natural'
        ))) AS `_natural_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'context_on_site_natural'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'context_on_site_natural'
            )))) AS `_natural_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') / 10000000), 2) AS `_natural_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000), 2) AS `_outdoor_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'outdoor_block') AS `_outdoor_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )))) AS `_outdoor_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )))) AS `_outdoor_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'outdoor_block')) AS `_outdoor_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            ))), 2) AS `_outdoor_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            ))), 2) AS `_outdoor_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            ))), 2) AS `_outdoor_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            ))), 2) AS `_outdoor_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'outdoor_block'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'outdoor_block')) AS `_outdoor_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'outdoor_block') AS `_outdoor_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'outdoor_block') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'outdoor_block'
            )))) AS `_outdoor_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'outdoor_block'
        ))) AS `_outdoor_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'outdoor_block'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'outdoor_block') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'outdoor_block'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'outdoor_block'
                    )))))) AS `_outdoor_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000), 2) AS `_outdoor_partner_wo_nds`,
        round((SUM((`partner_wo_nds` / 1000)) / 10000000), 2) AS `_partner_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_content') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_content'))) AS `_percent_content_bad_win_partner_price_content_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_content') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_content') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_content'))) AS `_percent_content_bad_win_price_content_all_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb'))) AS `_percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'mobile_app_rtb') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'mobile_app_rtb'))) AS `_percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_natural') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural'))) AS `_percent_natural_bad_win_partner_price_natural_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_natural') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'context_on_site_natural'))) AS `_percent_natural_bad_win_price_natural_all_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')))) AS `_percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')))) AS `_percent_rtb_bad_win_price_rtb_all_wo_nds`,
        (sumIf(`shows`, `product_id` = 'search_on_site_premium') / sumIf(`premium_page_ad_shows`, `product_id` = 'search_on_site_campaign')) AS `_premium_ads`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000), 2) AS `_premium_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'search_on_site_premium') AS `_premium_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpc_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) / sumIf(`clicks`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpc_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'search_on_site_premium')), 2) AS `_premium_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) * 1000) / sumIf(`premium_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_premium_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000) * 1000) / sumIf(`premium_hits`, `product_id` = 'search_on_site_campaign')), 2) AS `_premium_cpmh_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'search_on_site_premium') * 100) / sumIf(`shows`, `product_id` = 'search_on_site_premium')) AS `_premium_ctr`,
        sumIf(`premium_hits`, `product_id` = 'search_on_site_campaign') AS `_premium_hits`,
        sumIf(`premium_page_ad_shows`, `product_id` = 'search_on_site_campaign') AS `_premium_page_ad_shows`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'search_on_site_premium') / 10000000), 2) AS `_premium_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'search_on_site_premium') AS `_premium_shows`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000), 2) AS `_rtb_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000), 2) AS `_rtb_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000), 2) AS `_rtb_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) AS `_rtb_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )))) AS `_rtb_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )))) AS `_rtb_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) * 100) / sumIf(`hits`, `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb'))) AS `_rtb_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            ))), 2) AS `_rtb_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            ))), 2) AS `_rtb_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            ))), 2) AS `_rtb_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            ))), 2) AS `_rtb_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) * 100) / sumIf(`direct_shows`, `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb'))) AS `_rtb_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) AS `_rtb_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000) * 1000) / sumIf(`hits`, `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb'))), 2) AS `_rtb_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000) * 1000) / sumIf(`hits`, `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb'))), 2) AS `_rtb_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
    )) AS `_rtb_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
        ))) AS `_rtb_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')
            )))) AS `_rtb_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` IN ('context_on_site_rtb', 'ssp_context_on_site_rtb', 'ssp_video_an_site_rtb')) / 10000000), 2) AS `_rtb_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000), 2) AS `_ssp_mobile_rtb_all_wo_nds`,
        sumIf(`hits`, `product_id` = 'ssp_mobile_app_rtb') AS `_ssp_mobile_rtb_block_all_hits`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_mobile_app_rtb'
            )) * 100) / sumIf(`hits`, `product_id` = 'ssp_mobile_app_rtb')) AS `_ssp_mobile_rtb_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_mobile_app_rtb'
            ))), 2) AS `_ssp_mobile_rtb_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_mobile_app_rtb'
            ))), 2) AS `_ssp_mobile_rtb_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_mobile_app_rtb'
            ))), 2) AS `_ssp_mobile_rtb_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_mobile_app_rtb'
            ))), 2) AS `_ssp_mobile_rtb_block_cpmh_partner_wo_nds`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'ssp_mobile_app_rtb'
    )) AS `_ssp_mobile_rtb_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'ssp_mobile_app_rtb'
    )) AS `_ssp_mobile_rtb_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'ssp_mobile_app_rtb'
    )) AS `_ssp_mobile_rtb_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'ssp_mobile_app_rtb')), 2) AS `_ssp_mobile_rtb_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'ssp_mobile_app_rtb')), 2) AS `_ssp_mobile_rtb_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'ssp_mobile_app_rtb'
    )) AS `_ssp_mobile_rtb_block_shows`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_mobile_app_rtb'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'ssp_mobile_app_rtb'
        ))) AS `_ssp_mobile_rtb_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_mobile_app_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_mobile_app_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'ssp_mobile_app_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'ssp_mobile_app_rtb'
            )))) AS `_ssp_mobile_rtb_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000), 2) AS `_ssp_mobile_rtb_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000), 2) AS `_stripe_all_wo_nds`,
        sumIf(`clicks`, `product_id` = 'context_on_site_stripe') AS `_stripe_clicks`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpc_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) / sumIf(`clicks`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpc_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`shows`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'context_on_site_stripe')), 2) AS `_stripe_cpmh_partner_wo_nds`,
        ((sumIf(`clicks`, `product_id` = 'context_on_site_stripe') * 100) / sumIf(`shows`, `product_id` = 'context_on_site_stripe')) AS `_stripe_ctr`,
        sumIf(`hits`, `product_id` = 'context_on_site_stripe') AS `_stripe_hits`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'context_on_site_stripe') / 10000000), 2) AS `_stripe_partner_wo_nds`,
        sumIf(`shows`, `product_id` = 'context_on_site_stripe') AS `_stripe_shows`,
        (sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_instream'
        )) + sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_inpage'
        )) + sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_fullscreen'
        ))) AS `_video_an_site_all_hits`,
        (sumIf(`hits`, (
            `dsp_id` = 5
            AND `product_id` = 'video_an_site_instream'
        )) + sumIf(`hits`, (
            `dsp_id` = 5
            AND `product_id` = 'video_an_site_inpage'
        )) + sumIf(`hits`, (
            `dsp_id` = 5
            AND `product_id` = 'video_an_site_fullscreen'
        ))) AS `_video_an_site_all_hits_own_adv`,
        ((sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') - (sumIf(`hits`, (
                    `dsp_id` NOT IN (5, 10)
                    AND `product_id` = 'video_an_site_instream'
                )) + sumIf(`hits`, (
                    `dsp_id` = 5
                    AND `product_id` = 'video_an_site_instream'
                )))) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage') - (sumIf(`hits`, (
                    `dsp_id` NOT IN (5, 10)
                    AND `product_id` = 'video_an_site_inpage'
                )) + sumIf(`hits`, (
                    `dsp_id` = 5
                    AND `product_id` = 'video_an_site_inpage'
                )))) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen') - (sumIf(`hits`, (
                    `dsp_id` NOT IN (5, 10)
                    AND `product_id` = 'video_an_site_fullscreen'
                )) + sumIf(`hits`, (
                    `dsp_id` = 5
                    AND `product_id` = 'video_an_site_fullscreen'
                ))))) AS `_video_an_site_all_hits_unsold`,
        (sumIf(`shows`, (
            `dsp_id` <> 5
            AND `product_id` = 'video_an_site_instream'
        )) + sumIf(`shows`, (
            `dsp_id` <> 5
            AND `product_id` = 'video_an_site_inpage'
        )) + sumIf(`shows`, (
            `dsp_id` <> 5
            AND `product_id` = 'video_an_site_fullscreen'
        ))) AS `_video_an_site_all_shows`,
        (sumIf(`shows`, (
            `dsp_id` = 5
            AND `product_id` = 'video_an_site_instream'
        )) + sumIf(`shows`, (
            `dsp_id` = 5
            AND `product_id` = 'video_an_site_inpage'
        )) + sumIf(`shows`, (
            `dsp_id` = 5
            AND `product_id` = 'video_an_site_fullscreen'
        ))) AS `_video_an_site_all_shows_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') + sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage') + sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen')) AS `_video_an_site_sum_all_hits`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') + sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') + sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_inpage')) / 10000000), 2) AS `_video_an_site_sum_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') + sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') + sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen')) / 10000000), 2) AS `_video_an_site_sum_partner_wo_nds`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('context_on_site_campaign', 'context_on_site_rtb', 'context_on_site_direct', 'context_on_site_stripe', 'context_on_site_mcb', 'context_on_site_market', 'context_on_site_adblock', 'context_on_site_market_api', 'context_on_site_content', 'context_on_site_natural', 'search_on_site_campaign', 'search_on_site_premium', 'search_on_site_direct', 'search_on_site_mcb', 'search_on_site_market', 'search_on_site_market_api', 'mobile_app_settings', 'mobile_app_rtb', 'video_an_site', 'video_an_site_instream', 'video_an_site_inpage', 'video_an_site_fullscreen', 'ssp_mobile_app_settings', 'ssp_mobile_app_rtb', 'ssp_context_on_site_campaign', 'ssp_context_on_site_rtb', 'ssp_video_an_site', 'ssp_video_an_site_rtb', 'indoor', 'indoor_block', 'outdoor', 'outdoor_block')
        AND (
            dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 'mock__login'
        )
        AND (
            dictGetUInt8('users_dict', 'is_efir_blogger', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 1
            OR dictGetUInt8('users_dict', 'is_video_blogger', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 1
            OR dictGetUInt8('users_dict', 'is_tutby', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 1
            OR dictGetUInt8('users_dict', 'is_adfox_partner', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 1
            OR dictGetUInt8('users_dict', 'is_mobile_mediation', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 1
            OR dictGetUInt8('users_dict', 'is_games', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 1
        )
        AND (
            dictGetString('users_dict', 'email', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 'mock__email'
        )
        AND (
            dictGetString('users_dict', 'phone', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 'mock__phone'
        )
        AND (
            dictGetUInt32('users_dict', 'client_id', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 'mock__client_id'
        )
        AND (
            dictGetUInt32('users_dict', 'client_id', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) IN ('mock__contract_id')
        )
        AND (
            dictGetString('users_dict', 'lastname', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 'mock__lastname'
        )
        AND (
            dictGetString('users_dict', 'name', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 'mock__name'
        )
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) = 'mock__id'
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
    )
    GROUP BY `_currency_id`, `_date`, `_login`
) `statistics`
WHERE (
    (if(isNaN(`an_fraud_clicks`), 0, `an_fraud_clicks`) + if(isNaN(`outdoor_block_direct_shows`), 0, `outdoor_block_direct_shows`) + if(isNaN(`outdoor_block_all_hits`), 0, `outdoor_block_all_hits`) + if(isNaN(`market_context_ctr`), 0, `market_context_ctr`) + if(isNaN(`market_search_hits`), 0, `market_search_hits`) + if(isNaN(`indoor_block_bad_shows_percent`), 0, `indoor_block_bad_shows_percent`) + if(isNaN(`direct_search_cpc_direct_search_partner_wo_nds`), 0, `direct_search_cpc_direct_search_partner_wo_nds`) + if(isNaN(`rtb_bad_win_price_wo_nds`), 0, `rtb_bad_win_price_wo_nds`) + if(isNaN(`indoor_block_bad_win_hits_own_adv`), 0, `indoor_block_bad_win_hits_own_adv`) + if(isNaN(`instream_block_bad_shows_percent`), 0, `instream_block_bad_shows_percent`) + if(isNaN(`instream_block_hits_unsold`), 0, `instream_block_hits_unsold`) + if(isNaN(`content_block_bad_shows_percent`), 0, `content_block_bad_shows_percent`) + if(isNaN(`fullscreen_block_bad_shows`), 0, `fullscreen_block_bad_shows`) + if(isNaN(`outdoor_block_bad_shows_own_adv`), 0, `outdoor_block_bad_shows_own_adv`) + if(isNaN(`outdoor_block_shows_own_adv`), 0, `outdoor_block_shows_own_adv`) + if(isNaN(`an_cover_direct_hits`), 0, `an_cover_direct_hits`) + if(isNaN(`premium_clicks`), 0, `premium_clicks`) + if(isNaN(`inpage_partner_wo_nds`), 0, `inpage_partner_wo_nds`) + if(isNaN(`content_block_bad_win_hits_unsold`), 0, `content_block_bad_win_hits_unsold`) + if(isNaN(`inpage_block_bad_win_hits_percent`), 0, `inpage_block_bad_win_hits_percent`) + if(isNaN(`instream_block_cpm_all_wo_nds`), 0, `instream_block_cpm_all_wo_nds`) + if(isNaN(`premium_cpm_all_wo_nds`), 0, `premium_cpm_all_wo_nds`) + if(isNaN(`inpage_block_bad_shows`), 0, `inpage_block_bad_shows`) + if(isNaN(`content_block_bad_shows`), 0, `content_block_bad_shows`) + if(isNaN(`direct_search_partner_wo_nds`), 0, `direct_search_partner_wo_nds`) + if(isNaN(`instream_block_ctr`), 0, `instream_block_ctr`) + if(isNaN(`direct_ad_coverage`), 0, `direct_ad_coverage`) + if(isNaN(`market_api_context_clicks`), 0, `market_api_context_clicks`) + if(isNaN(`adblock_block_hits_unsold`), 0, `adblock_block_hits_unsold`) + if(isNaN(`instream_block_visibility`), 0, `instream_block_visibility`) + if(isNaN(`an_cover_senthits`), 0, `an_cover_senthits`) + if(isNaN(`direct_search_cpmh_direct_search_all_wo_nds`), 0, `direct_search_cpmh_direct_search_all_wo_nds`) + if(isNaN(`stripe_all_wo_nds`), 0, `stripe_all_wo_nds`) + if(isNaN(`fullscreen_block_hits`), 0, `fullscreen_block_hits`) + if(isNaN(`adblock_block_shows`), 0, `adblock_block_shows`) + if(isNaN(`percent_content_bad_win_partner_price_content_partner_wo_nds`), 0, `percent_content_bad_win_partner_price_content_partner_wo_nds`) + if(isNaN(`natural_bad_win_partner_price_wo_nds`), 0, `natural_bad_win_partner_price_wo_nds`) + if(isNaN(`fullscreen_block_cpmh_partner_wo_nds`), 0, `fullscreen_block_cpmh_partner_wo_nds`) + if(isNaN(`instream_block_preroll_hits`), 0, `instream_block_preroll_hits`) + if(isNaN(`rtb_block_direct_shows`), 0, `rtb_block_direct_shows`) + if(isNaN(`outdoor_block_direct_ctr`), 0, `outdoor_block_direct_ctr`) + if(isNaN(`indoor_block_cpm_partner_wo_nds`), 0, `indoor_block_cpm_partner_wo_nds`) + if(isNaN(`content_block_cpmh_all_wo_nds`), 0, `content_block_cpmh_all_wo_nds`) + if(isNaN(`mobile_rtb_bad_win_price_wo_nds`), 0, `mobile_rtb_bad_win_price_wo_nds`) + if(isNaN(`content_block_rpm_partner_wo_nds`), 0, `content_block_rpm_partner_wo_nds`) + if(isNaN(`an_fraud_shows`), 0, `an_fraud_shows`) + if(isNaN(`ssp_mobile_rtb_block_visibility`), 0, `ssp_mobile_rtb_block_visibility`) + if(isNaN(`direct_search_page_ad_shows`), 0, `direct_search_page_ad_shows`) + if(isNaN(`inpage_block_direct_shows`), 0, `inpage_block_direct_shows`) + if(isNaN(`market_search_clicks`), 0, `market_search_clicks`) + if(isNaN(`market_context_cpmh_market_context_partner_wo_nds`), 0, `market_context_cpmh_market_context_partner_wo_nds`) + if(isNaN(`instream_block_open_player`), 0, `instream_block_open_player`) + if(isNaN(`natural_block_shows`), 0, `natural_block_shows`) + if(isNaN(`instream_block_cpmh_partner_wo_nds`), 0, `instream_block_cpmh_partner_wo_nds`) + if(isNaN(`inpage_block_hits`), 0, `inpage_block_hits`) + if(isNaN(`adblock_block_visibility`), 0, `adblock_block_visibility`) + if(isNaN(`stripe_cpm_all_wo_nds`), 0, `stripe_cpm_all_wo_nds`) + if(isNaN(`natural_block_direct_clicks`), 0, `natural_block_direct_clicks`) + if(isNaN(`fullscreen_block_bad_win_hits_unsold`), 0, `fullscreen_block_bad_win_hits_unsold`) + if(isNaN(`mobile_rtb_bad_win_partner_price_wo_nds`), 0, `mobile_rtb_bad_win_partner_price_wo_nds`) + if(isNaN(`premium_cpm_partner_wo_nds`), 0, `premium_cpm_partner_wo_nds`) + if(isNaN(`content_block_direct_shows`), 0, `content_block_direct_shows`) + if(isNaN(`content_bad_win_price_wo_nds`), 0, `content_bad_win_price_wo_nds`) + if(isNaN(`content_block_all_hits`), 0, `content_block_all_hits`) + if(isNaN(`ssp_mobile_rtb_block_cpm_partner_wo_nds`), 0, `ssp_mobile_rtb_block_cpm_partner_wo_nds`) + if(isNaN(`bad_win_partner_price_wo_nds`), 0, `bad_win_partner_price_wo_nds`) + if(isNaN(`rtb_block_hits`), 0, `rtb_block_hits`) + if(isNaN(`adblock_block_cpmh_partner_wo_nds`), 0, `adblock_block_cpmh_partner_wo_nds`) + if(isNaN(`market_context_shows`), 0, `market_context_shows`) + if(isNaN(`mobile_rtb_block_bad_win_hits_percent`), 0, `mobile_rtb_block_bad_win_hits_percent`) + if(isNaN(`ssp_mobile_rtb_block_shows`), 0, `ssp_mobile_rtb_block_shows`) + if(isNaN(`natural_block_cpm_all_wo_nds`), 0, `natural_block_cpm_all_wo_nds`) + if(isNaN(`mcb_context_clicks`), 0, `mcb_context_clicks`) + if(isNaN(`partner_wo_nds`), 0, `partner_wo_nds`) + if(isNaN(`market_api_context_cpc_market_api_context_partner_wo_nds`), 0, `market_api_context_cpc_market_api_context_partner_wo_nds`) + if(isNaN(`video_an_site_all_hits_own_adv`), 0, `video_an_site_all_hits_own_adv`) + if(isNaN(`ssp_mobile_rtb_block_hits_own_adv`), 0, `ssp_mobile_rtb_block_hits_own_adv`) + if(isNaN(`market_api_search_ctr`), 0, `market_api_search_ctr`) + if(isNaN(`percent_rtb_bad_win_price_rtb_all_wo_nds`), 0, `percent_rtb_bad_win_price_rtb_all_wo_nds`) + if(isNaN(`fullscreen_block_visibility`), 0, `fullscreen_block_visibility`) + if(isNaN(`direct_search_cpmh_direct_search_partner_wo_nds`), 0, `direct_search_cpmh_direct_search_partner_wo_nds`) + if(isNaN(`instream_block_preroll_conversion_percent`), 0, `instream_block_preroll_conversion_percent`) + if(isNaN(`fullscreen_partner_wo_nds`), 0, `fullscreen_partner_wo_nds`) + if(isNaN(`ssp_mobile_rtb_block_cpm_all_wo_nds`), 0, `ssp_mobile_rtb_block_cpm_all_wo_nds`) + if(isNaN(`market_api_search_cpc_market_api_search_partner_wo_nds`), 0, `market_api_search_cpc_market_api_search_partner_wo_nds`) + if(isNaN(`direct_context_page_ad_shows`), 0, `direct_context_page_ad_shows`) + if(isNaN(`instream_block_midroll_hits`), 0, `instream_block_midroll_hits`) + if(isNaN(`mcb_search_clicks`), 0, `mcb_search_clicks`) + if(isNaN(`instream_block_preroll_shows`), 0, `instream_block_preroll_shows`) + if(isNaN(`stripe_ctr`), 0, `stripe_ctr`) + if(isNaN(`percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`), 0, `percent_mobile_rtb_bad_win_price_mobile_rtb_all_wo_nds`) + if(isNaN(`adblock_block_cpm_all_wo_nds`), 0, `adblock_block_cpm_all_wo_nds`) + if(isNaN(`stripe_cpc_partner_wo_nds`), 0, `stripe_cpc_partner_wo_nds`) + if(isNaN(`mobile_rtb_block_cpm_all_wo_nds`), 0, `mobile_rtb_block_cpm_all_wo_nds`) + if(isNaN(`stripe_clicks`), 0, `stripe_clicks`) + if(isNaN(`market_api_search_partner_wo_nds`), 0, `market_api_search_partner_wo_nds`) + if(isNaN(`market_context_all_wo_nds`), 0, `market_context_all_wo_nds`) + if(isNaN(`percent_content_bad_win_price_content_all_wo_nds`), 0, `percent_content_bad_win_price_content_all_wo_nds`) + if(isNaN(`mobile_rtb_block_direct_clicks`), 0, `mobile_rtb_block_direct_clicks`) + if(isNaN(`market_api_search_shows`), 0, `market_api_search_shows`) + if(isNaN(`natural_block_visibility`), 0, `natural_block_visibility`) + if(isNaN(`mobile_rtb_block_cpm_partner_wo_nds`), 0, `mobile_rtb_block_cpm_partner_wo_nds`) + if(isNaN(`content_block_shows`), 0, `content_block_shows`) + if(isNaN(`market_api_context_all_wo_nds`), 0, `market_api_context_all_wo_nds`) + if(isNaN(`rtb_bad_win_partner_price_wo_nds`), 0, `rtb_bad_win_partner_price_wo_nds`) + if(isNaN(`direct_search_ctr`), 0, `direct_search_ctr`) + if(isNaN(`rtb_block_cpm_all_wo_nds`), 0, `rtb_block_cpm_all_wo_nds`) + if(isNaN(`rtb_block_visibility`), 0, `rtb_block_visibility`) + if(isNaN(`rtb_block_rpm_all_wo_nds`), 0, `rtb_block_rpm_all_wo_nds`) + if(isNaN(`instream_block_bad_shows`), 0, `instream_block_bad_shows`) + if(isNaN(`ssp_mobile_rtb_block_rpm_partner_wo_nds`), 0, `ssp_mobile_rtb_block_rpm_partner_wo_nds`) + if(isNaN(`market_api_search_cpm_market_api_search_partner_wo_nds`), 0, `market_api_search_cpm_market_api_search_partner_wo_nds`) + if(isNaN(`indoor_block_bad_win_hits_unsold`), 0, `indoor_block_bad_win_hits_unsold`) + if(isNaN(`inpage_block_cover_ratio`), 0, `inpage_block_cover_ratio`) + if(isNaN(`market_context_cpm_market_context_all_wo_nds`), 0, `market_context_cpm_market_context_all_wo_nds`) + if(isNaN(`mobile_rtb_block_cpmh_all_wo_nds`), 0, `mobile_rtb_block_cpmh_all_wo_nds`) + if(isNaN(`indoor_partner_wo_nds`), 0, `indoor_partner_wo_nds`) + if(isNaN(`direct_search_cpc_direct_search_all_wo_nds`), 0, `direct_search_cpc_direct_search_all_wo_nds`) + if(isNaN(`instream_block_midroll_shows`), 0, `instream_block_midroll_shows`) + if(isNaN(`market_search_partner_wo_nds`), 0, `market_search_partner_wo_nds`) + if(isNaN(`fullscreen_block_shows`), 0, `fullscreen_block_shows`) + if(isNaN(`indoor_block_shows_own_adv`), 0, `indoor_block_shows_own_adv`) + if(isNaN(`fullscreen_block_shows_own_adv`), 0, `fullscreen_block_shows_own_adv`) + if(isNaN(`ssp_mobile_rtb_partner_wo_nds`), 0, `ssp_mobile_rtb_partner_wo_nds`) + if(isNaN(`indoor_block_cpmh_partner_wo_nds`), 0, `indoor_block_cpmh_partner_wo_nds`) + if(isNaN(`adblock_block_cover_ratio`), 0, `adblock_block_cover_ratio`) + if(isNaN(`outdoor_block_hits_own_adv`), 0, `outdoor_block_hits_own_adv`) + if(isNaN(`adblock_block_winrate`), 0, `adblock_block_winrate`) + if(isNaN(`adblock_block_hits_own_adv`), 0, `adblock_block_hits_own_adv`) + if(isNaN(`indoor_block_direct_clicks`), 0, `indoor_block_direct_clicks`) + if(isNaN(`stripe_cpmh_all_wo_nds`), 0, `stripe_cpmh_all_wo_nds`) + if(isNaN(`market_api_context_cpc_market_api_context_all_wo_nds`), 0, `market_api_context_cpc_market_api_context_all_wo_nds`) + if(isNaN(`market_search_all_wo_nds`), 0, `market_search_all_wo_nds`) + if(isNaN(`natural_block_bad_shows`), 0, `natural_block_bad_shows`) + if(isNaN(`mobile_rtb_block_cover_ratio`), 0, `mobile_rtb_block_cover_ratio`) + if(isNaN(`direct_context_cpc_direct_context_partner_wo_nds`), 0, `direct_context_cpc_direct_context_partner_wo_nds`) + if(isNaN(`mobile_rtb_block_bad_shows_own_adv`), 0, `mobile_rtb_block_bad_shows_own_adv`) + if(isNaN(`mcb_context_cpm_mcb_context_all_wo_nds`), 0, `mcb_context_cpm_mcb_context_all_wo_nds`) + if(isNaN(`outdoor_block_bad_win_hits_percent`), 0, `outdoor_block_bad_win_hits_percent`) + if(isNaN(`natural_block_hits_unsold`), 0, `natural_block_hits_unsold`) + if(isNaN(`indoor_block_shows`), 0, `indoor_block_shows`) + if(isNaN(`content_block_bad_shows_own_adv`), 0, `content_block_bad_shows_own_adv`) + if(isNaN(`direct_context_cpc_direct_context_all_wo_nds`), 0, `direct_context_cpc_direct_context_all_wo_nds`) + if(isNaN(`mobile_rtb_block_visibility`), 0, `mobile_rtb_block_visibility`) + if(isNaN(`mobile_rtb_block_winrate`), 0, `mobile_rtb_block_winrate`) + if(isNaN(`mcb_context_cpm_mcb_context_partner_wo_nds`), 0, `mcb_context_cpm_mcb_context_partner_wo_nds`) + if(isNaN(`mcb_search_cpm_mcb_search_partner_wo_nds`), 0, `mcb_search_cpm_mcb_search_partner_wo_nds`) + if(isNaN(`video_an_site_sum_partner_wo_nds`), 0, `video_an_site_sum_partner_wo_nds`) + if(isNaN(`fullscreen_block_bad_win_hits_own_adv`), 0, `fullscreen_block_bad_win_hits_own_adv`) + if(isNaN(`percent_natural_bad_win_partner_price_natural_partner_wo_nds`), 0, `percent_natural_bad_win_partner_price_natural_partner_wo_nds`) + if(isNaN(`direct_ad_reach`), 0, `direct_ad_reach`) + if(isNaN(`outdoor_all_wo_nds`), 0, `outdoor_all_wo_nds`) + if(isNaN(`percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`), 0, `percent_mobile_rtb_bad_win_partner_price_mobile_rtb_partner_wo_nds`) + if(isNaN(`mcb_context_partner_wo_nds`), 0, `mcb_context_partner_wo_nds`) + if(isNaN(`rtb_block_cover_ratio`), 0, `rtb_block_cover_ratio`) + if(isNaN(`adblock_block_rpm_all_wo_nds`), 0, `adblock_block_rpm_all_wo_nds`) + if(isNaN(`all_wo_nds`), 0, `all_wo_nds`) + if(isNaN(`direct_context_ads`), 0, `direct_context_ads`) + if(isNaN(`an_rtb_cover_hits`), 0, `an_rtb_cover_hits`) + if(isNaN(`direct_context_all_wo_nds`), 0, `direct_context_all_wo_nds`) + if(isNaN(`natural_block_rpm_all_wo_nds`), 0, `natural_block_rpm_all_wo_nds`) + if(isNaN(`outdoor_block_hits_unsold`), 0, `outdoor_block_hits_unsold`) + if(isNaN(`rtb_block_rpm_partner_wo_nds`), 0, `rtb_block_rpm_partner_wo_nds`) + if(isNaN(`market_api_search_clicks`), 0, `market_api_search_clicks`) + if(isNaN(`mcb_search_shows`), 0, `mcb_search_shows`) + if(isNaN(`indoor_block_hits`), 0, `indoor_block_hits`) + if(isNaN(`percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`), 0, `percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`) + if(isNaN(`mobile_rtb_all_wo_nds`), 0, `mobile_rtb_all_wo_nds`) + if(isNaN(`outdoor_block_bad_win_hits_own_adv`), 0, `outdoor_block_bad_win_hits_own_adv`) + if(isNaN(`inpage_block_bad_win_hits`), 0, `inpage_block_bad_win_hits`) + if(isNaN(`natural_block_bad_shows_own_adv`), 0, `natural_block_bad_shows_own_adv`) + if(isNaN(`inpage_block_winrate`), 0, `inpage_block_winrate`) + if(isNaN(`mcb_context_hits`), 0, `mcb_context_hits`) + if(isNaN(`market_api_search_cpm_market_api_search_all_wo_nds`), 0, `market_api_search_cpm_market_api_search_all_wo_nds`) + if(isNaN(`market_context_cpc_market_context_all_wo_nds`), 0, `market_context_cpc_market_context_all_wo_nds`) + if(isNaN(`direct_context_cpmh_direct_context_all_wo_nds`), 0, `direct_context_cpmh_direct_context_all_wo_nds`) + if(isNaN(`inpage_block_cpmh_all_wo_nds`), 0, `inpage_block_cpmh_all_wo_nds`) + if(isNaN(`fullscreen_block_cpm_all_wo_nds`), 0, `fullscreen_block_cpm_all_wo_nds`) + if(isNaN(`instream_block_postroll_shows`), 0, `instream_block_postroll_shows`) + if(isNaN(`outdoor_block_bad_win_hits_unsold`), 0, `outdoor_block_bad_win_hits_unsold`) + if(isNaN(`indoor_block_bad_win_hits_percent`), 0, `indoor_block_bad_win_hits_percent`) + if(isNaN(`mobile_rtb_block_all_hits`), 0, `mobile_rtb_block_all_hits`) + if(isNaN(`instream_block_winrate`), 0, `instream_block_winrate`) + if(isNaN(`mcb_context_cpmh_mcb_context_partner_wo_nds`), 0, `mcb_context_cpmh_mcb_context_partner_wo_nds`) + if(isNaN(`market_search_cpmh_market_search_all_wo_nds`), 0, `market_search_cpmh_market_search_all_wo_nds`) + if(isNaN(`content_block_winrate`), 0, `content_block_winrate`) + if(isNaN(`instream_block_bad_win_hits_unsold`), 0, `instream_block_bad_win_hits_unsold`) + if(isNaN(`content_block_hits_unsold`), 0, `content_block_hits_unsold`) + if(isNaN(`rtb_block_bad_win_hits_unsold`), 0, `rtb_block_bad_win_hits_unsold`) + if(isNaN(`rtb_block_hits_own_adv`), 0, `rtb_block_hits_own_adv`) + if(isNaN(`instream_block_all_hits`), 0, `instream_block_all_hits`) + if(isNaN(`instream_block_cpm_partner_wo_nds`), 0, `instream_block_cpm_partner_wo_nds`) + if(isNaN(`natural_block_shows_own_adv`), 0, `natural_block_shows_own_adv`) + if(isNaN(`premium_ctr`), 0, `premium_ctr`) + if(isNaN(`rtb_block_shows`), 0, `rtb_block_shows`) + if(isNaN(`an_cover_market_hits`), 0, `an_cover_market_hits`) + if(isNaN(`adblock_block_shows_own_adv`), 0, `adblock_block_shows_own_adv`) + if(isNaN(`natural_block_cpmh_all_wo_nds`), 0, `natural_block_cpmh_all_wo_nds`) + if(isNaN(`outdoor_partner_wo_nds`), 0, `outdoor_partner_wo_nds`) + if(isNaN(`outdoor_block_hits`), 0, `outdoor_block_hits`) + if(isNaN(`outdoor_block_cpmh_all_wo_nds`), 0, `outdoor_block_cpmh_all_wo_nds`) + if(isNaN(`inpage_block_hits_unsold`), 0, `inpage_block_hits_unsold`) + if(isNaN(`mcb_search_cpm_mcb_search_all_wo_nds`), 0, `mcb_search_cpm_mcb_search_all_wo_nds`) + if(isNaN(`natural_block_bad_win_hits`), 0, `natural_block_bad_win_hits`) + if(isNaN(`fullscreen_block_all_hits`), 0, `fullscreen_block_all_hits`) + if(isNaN(`rtb_block_all_hits`), 0, `rtb_block_all_hits`) + if(isNaN(`market_api_context_cpm_market_api_context_partner_wo_nds`), 0, `market_api_context_cpm_market_api_context_partner_wo_nds`) + if(isNaN(`market_api_context_ctr`), 0, `market_api_context_ctr`) + if(isNaN(`instream_all_wo_nds`), 0, `instream_all_wo_nds`) + if(isNaN(`rtb_all_wo_nds`), 0, `rtb_all_wo_nds`) + if(isNaN(`instream_partner_wo_nds`), 0, `instream_partner_wo_nds`) + if(isNaN(`content_block_rpm_all_wo_nds`), 0, `content_block_rpm_all_wo_nds`) + if(isNaN(`ssp_mobile_rtb_block_cover_ratio`), 0, `ssp_mobile_rtb_block_cover_ratio`) + if(isNaN(`stripe_cpm_partner_wo_nds`), 0, `stripe_cpm_partner_wo_nds`) + if(isNaN(`rtb_block_bad_shows_own_adv`), 0, `rtb_block_bad_shows_own_adv`) + if(isNaN(`indoor_block_hits_own_adv`), 0, `indoor_block_hits_own_adv`) + if(isNaN(`market_search_cpmh_market_search_partner_wo_nds`), 0, `market_search_cpmh_market_search_partner_wo_nds`) + if(isNaN(`instream_block_cover_ratio`), 0, `instream_block_cover_ratio`) + if(isNaN(`an_mobile_rtb_cover_hits`), 0, `an_mobile_rtb_cover_hits`) + if(isNaN(`rtb_block_cpm_partner_wo_nds`), 0, `rtb_block_cpm_partner_wo_nds`) + if(isNaN(`content_block_bad_win_hits_percent`), 0, `content_block_bad_win_hits_percent`) + if(isNaN(`ssp_mobile_rtb_block_cpmh_all_wo_nds`), 0, `ssp_mobile_rtb_block_cpmh_all_wo_nds`) + if(isNaN(`premium_ads`), 0, `premium_ads`) + if(isNaN(`market_context_cpmh_market_context_all_wo_nds`), 0, `market_context_cpmh_market_context_all_wo_nds`) + if(isNaN(`natural_block_rpm_partner_wo_nds`), 0, `natural_block_rpm_partner_wo_nds`) + if(isNaN(`fullscreen_block_bad_shows_own_adv`), 0, `fullscreen_block_bad_shows_own_adv`) + if(isNaN(`outdoor_block_visibility`), 0, `outdoor_block_visibility`) + if(isNaN(`rtb_block_bad_shows`), 0, `rtb_block_bad_shows`) + if(isNaN(`percent_natural_bad_win_price_natural_all_wo_nds`), 0, `percent_natural_bad_win_price_natural_all_wo_nds`) + if(isNaN(`fullscreen_block_bad_shows_percent`), 0, `fullscreen_block_bad_shows_percent`) + if(isNaN(`ssp_mobile_rtb_block_winrate`), 0, `ssp_mobile_rtb_block_winrate`) + if(isNaN(`an_rtb_cover_direct_hits`), 0, `an_rtb_cover_direct_hits`) + if(isNaN(`fullscreen_block_direct_clicks`), 0, `fullscreen_block_direct_clicks`) + if(isNaN(`rtb_block_cpmh_partner_wo_nds`), 0, `rtb_block_cpmh_partner_wo_nds`) + if(isNaN(`an_cover_hits`), 0, `an_cover_hits`) + if(isNaN(`mcb_search_cpmh_mcb_search_partner_wo_nds`), 0, `mcb_search_cpmh_mcb_search_partner_wo_nds`) + if(isNaN(`adblock_block_all_hits`), 0, `adblock_block_all_hits`) + if(isNaN(`adblock_block_cpm_partner_wo_nds`), 0, `adblock_block_cpm_partner_wo_nds`) + if(isNaN(`instream_block_postroll_hits`), 0, `instream_block_postroll_hits`) + if(isNaN(`direct_search_ads`), 0, `direct_search_ads`) + if(isNaN(`mobile_rtb_block_shows`), 0, `mobile_rtb_block_shows`) + if(isNaN(`indoor_block_cpm_all_wo_nds`), 0, `indoor_block_cpm_all_wo_nds`) + if(isNaN(`natural_block_direct_shows`), 0, `natural_block_direct_shows`) + if(isNaN(`an_ssp_mobile_rtb_cover_hits`), 0, `an_ssp_mobile_rtb_cover_hits`) + if(isNaN(`mobile_rtb_block_bad_win_hits_unsold`), 0, `mobile_rtb_block_bad_win_hits_unsold`) + if(isNaN(`ssp_mobile_rtb_block_hits_unsold`), 0, `ssp_mobile_rtb_block_hits_unsold`) + if(isNaN(`mobile_rtb_block_direct_ctr`), 0, `mobile_rtb_block_direct_ctr`) + if(isNaN(`natural_block_hits`), 0, `natural_block_hits`) + if(isNaN(`mobile_rtb_block_hits_unsold`), 0, `mobile_rtb_block_hits_unsold`) + if(isNaN(`inpage_block_shows_own_adv`), 0, `inpage_block_shows_own_adv`) + if(isNaN(`rtb_block_direct_ctr`), 0, `rtb_block_direct_ctr`) + if(isNaN(`inpage_block_bad_shows_own_adv`), 0, `inpage_block_bad_shows_own_adv`) + if(isNaN(`stripe_shows`), 0, `stripe_shows`) + if(isNaN(`natural_block_cpm_partner_wo_nds`), 0, `natural_block_cpm_partner_wo_nds`) + if(isNaN(`outdoor_block_winrate`), 0, `outdoor_block_winrate`) + if(isNaN(`direct_context_cpmh_direct_context_partner_wo_nds`), 0, `direct_context_cpmh_direct_context_partner_wo_nds`) + if(isNaN(`adblock_all_wo_nds`), 0, `adblock_all_wo_nds`) + if(isNaN(`rtb_partner_wo_nds`), 0, `rtb_partner_wo_nds`) + if(isNaN(`premium_all_wo_nds`), 0, `premium_all_wo_nds`) + if(isNaN(`instream_block_view`), 0, `instream_block_view`) + if(isNaN(`direct_context_cpm_direct_context_all_wo_nds`), 0, `direct_context_cpm_direct_context_all_wo_nds`) + if(isNaN(`mcb_context_ctr`), 0, `mcb_context_ctr`) + if(isNaN(`instream_block_bad_win_hits_percent`), 0, `instream_block_bad_win_hits_percent`) + if(isNaN(`market_search_ctr`), 0, `market_search_ctr`) + if(isNaN(`indoor_block_cover_ratio`), 0, `indoor_block_cover_ratio`) + if(isNaN(`natural_block_winrate`), 0, `natural_block_winrate`) + if(isNaN(`instream_block_hits`), 0, `instream_block_hits`) + if(isNaN(`premium_cpc_partner_wo_nds`), 0, `premium_cpc_partner_wo_nds`) + if(isNaN(`content_block_direct_clicks`), 0, `content_block_direct_clicks`) + if(isNaN(`instream_block_pauseroll_hits`), 0, `instream_block_pauseroll_hits`) + if(isNaN(`direct_context_cpm_direct_context_partner_wo_nds`), 0, `direct_context_cpm_direct_context_partner_wo_nds`) + if(isNaN(`natural_block_hits_own_adv`), 0, `natural_block_hits_own_adv`) + if(isNaN(`instream_block_shows`), 0, `instream_block_shows`) + if(isNaN(`inpage_block_all_hits`), 0, `inpage_block_all_hits`) + if(isNaN(`adblock_block_hits`), 0, `adblock_block_hits`) + if(isNaN(`ssp_mobile_rtb_block_hits`), 0, `ssp_mobile_rtb_block_hits`) + if(isNaN(`natural_block_bad_win_hits_unsold`), 0, `natural_block_bad_win_hits_unsold`) + if(isNaN(`instream_block_bad_win_hits_own_adv`), 0, `instream_block_bad_win_hits_own_adv`) + if(isNaN(`outdoor_block_cpm_partner_wo_nds`), 0, `outdoor_block_cpm_partner_wo_nds`) + if(isNaN(`fullscreen_block_bad_win_hits`), 0, `fullscreen_block_bad_win_hits`) + if(isNaN(`market_search_cpc_market_search_all_wo_nds`), 0, `market_search_cpc_market_search_all_wo_nds`) + if(isNaN(`stripe_hits`), 0, `stripe_hits`) + if(isNaN(`instream_block_midroll_conversion_percent`), 0, `instream_block_midroll_conversion_percent`) + if(isNaN(`mcb_context_all_wo_nds`), 0, `mcb_context_all_wo_nds`) + if(isNaN(`inpage_all_wo_nds`), 0, `inpage_all_wo_nds`) + if(isNaN(`natural_block_bad_win_hits_own_adv`), 0, `natural_block_bad_win_hits_own_adv`) + if(isNaN(`direct_search_shows`), 0, `direct_search_shows`) + if(isNaN(`an_mobile_rtb_cover_direct_hits`), 0, `an_mobile_rtb_cover_direct_hits`) + if(isNaN(`market_context_cpc_market_context_partner_wo_nds`), 0, `market_context_cpc_market_context_partner_wo_nds`) + if(isNaN(`natural_bad_win_price_wo_nds`), 0, `natural_bad_win_price_wo_nds`) + if(isNaN(`indoor_block_direct_shows`), 0, `indoor_block_direct_shows`) + if(isNaN(`ssp_mobile_rtb_block_all_hits`), 0, `ssp_mobile_rtb_block_all_hits`) + if(isNaN(`content_partner_wo_nds`), 0, `content_partner_wo_nds`) + if(isNaN(`instream_block_hits_own_adv`), 0, `instream_block_hits_own_adv`) + if(isNaN(`adblock_partner_wo_nds`), 0, `adblock_partner_wo_nds`) + if(isNaN(`market_search_cpc_market_search_partner_wo_nds`), 0, `market_search_cpc_market_search_partner_wo_nds`) + if(isNaN(`indoor_block_winrate`), 0, `indoor_block_winrate`) + if(isNaN(`instream_block_bad_win_hits`), 0, `instream_block_bad_win_hits`) + if(isNaN(`content_block_shows_own_adv`), 0, `content_block_shows_own_adv`) + if(isNaN(`premium_page_ad_shows`), 0, `premium_page_ad_shows`) + if(isNaN(`an_cover_mcb_hits`), 0, `an_cover_mcb_hits`) + if(isNaN(`instream_block_bad_shows_own_adv`), 0, `instream_block_bad_shows_own_adv`) + if(isNaN(`direct_context_shows`), 0, `direct_context_shows`) + if(isNaN(`indoor_block_cpmh_all_wo_nds`), 0, `indoor_block_cpmh_all_wo_nds`) + if(isNaN(`stripe_cpc_all_wo_nds`), 0, `stripe_cpc_all_wo_nds`) + if(isNaN(`content_block_cpmh_partner_wo_nds`), 0, `content_block_cpmh_partner_wo_nds`) + if(isNaN(`premium_partner_wo_nds`), 0, `premium_partner_wo_nds`) + if(isNaN(`fullscreen_block_direct_ctr`), 0, `fullscreen_block_direct_ctr`) + if(isNaN(`instream_block_cpmh_all_wo_nds`), 0, `instream_block_cpmh_all_wo_nds`) + if(isNaN(`content_block_direct_ctr`), 0, `content_block_direct_ctr`) + if(isNaN(`instream_block_pauseroll_shows`), 0, `instream_block_pauseroll_shows`) + if(isNaN(`content_block_cpm_partner_wo_nds`), 0, `content_block_cpm_partner_wo_nds`) + if(isNaN(`direct_search_clicks`), 0, `direct_search_clicks`) + if(isNaN(`direct_context_hits`), 0, `direct_context_hits`) + if(isNaN(`market_api_search_cpc_market_api_search_all_wo_nds`), 0, `market_api_search_cpc_market_api_search_all_wo_nds`) + if(isNaN(`video_an_site_sum_all_hits`), 0, `video_an_site_sum_all_hits`) + if(isNaN(`outdoor_block_shows`), 0, `outdoor_block_shows`) + if(isNaN(`ssp_mobile_rtb_block_rpm_all_wo_nds`), 0, `ssp_mobile_rtb_block_rpm_all_wo_nds`) + if(isNaN(`content_block_visibility`), 0, `content_block_visibility`) + if(isNaN(`mcb_search_partner_wo_nds`), 0, `mcb_search_partner_wo_nds`) + if(isNaN(`rtb_block_bad_win_hits_own_adv`), 0, `rtb_block_bad_win_hits_own_adv`) + if(isNaN(`an_ssp_mobile_rtb_cover_senthits`), 0, `an_ssp_mobile_rtb_cover_senthits`) + if(isNaN(`content_block_bad_win_hits_own_adv`), 0, `content_block_bad_win_hits_own_adv`) + if(isNaN(`direct_context_clicks`), 0, `direct_context_clicks`) + if(isNaN(`mobile_rtb_block_direct_shows`), 0, `mobile_rtb_block_direct_shows`) + if(isNaN(`inpage_block_visibility`), 0, `inpage_block_visibility`) + if(isNaN(`mcb_context_cpmh_mcb_context_all_wo_nds`), 0, `mcb_context_cpmh_mcb_context_all_wo_nds`) + if(isNaN(`adblock_block_rpm_partner_wo_nds`), 0, `adblock_block_rpm_partner_wo_nds`) + if(isNaN(`market_search_cpm_market_search_partner_wo_nds`), 0, `market_search_cpm_market_search_partner_wo_nds`) + if(isNaN(`mobile_rtb_block_hits_own_adv`), 0, `mobile_rtb_block_hits_own_adv`) + if(isNaN(`market_api_context_cpm_market_api_context_all_wo_nds`), 0, `market_api_context_cpm_market_api_context_all_wo_nds`) + if(isNaN(`video_an_site_all_shows`), 0, `video_an_site_all_shows`) + if(isNaN(`fullscreen_block_hits_unsold`), 0, `fullscreen_block_hits_unsold`) + if(isNaN(`inpage_block_bad_win_hits_own_adv`), 0, `inpage_block_bad_win_hits_own_adv`) + if(isNaN(`mobile_rtb_block_cpmh_partner_wo_nds`), 0, `mobile_rtb_block_cpmh_partner_wo_nds`) + if(isNaN(`fullscreen_block_cpm_partner_wo_nds`), 0, `fullscreen_block_cpm_partner_wo_nds`) + if(isNaN(`natural_partner_wo_nds`), 0, `natural_partner_wo_nds`) + if(isNaN(`market_context_clicks`), 0, `market_context_clicks`) + if(isNaN(`natural_block_cover_ratio`), 0, `natural_block_cover_ratio`) + if(isNaN(`video_an_site_all_shows_own_adv`), 0, `video_an_site_all_shows_own_adv`) + if(isNaN(`adblock_block_cpmh_all_wo_nds`), 0, `adblock_block_cpmh_all_wo_nds`) + if(isNaN(`indoor_all_wo_nds`), 0, `indoor_all_wo_nds`) + if(isNaN(`content_block_cpm_all_wo_nds`), 0, `content_block_cpm_all_wo_nds`) + if(isNaN(`direct_context_ctr`), 0, `direct_context_ctr`) + if(isNaN(`fullscreen_block_cover_ratio`), 0, `fullscreen_block_cover_ratio`) + if(isNaN(`indoor_block_bad_shows`), 0, `indoor_block_bad_shows`) + if(isNaN(`natural_block_direct_ctr`), 0, `natural_block_direct_ctr`) + if(isNaN(`video_an_site_all_hits`), 0, `video_an_site_all_hits`) + if(isNaN(`mobile_rtb_partner_wo_nds`), 0, `mobile_rtb_partner_wo_nds`) + if(isNaN(`mobile_rtb_block_bad_win_hits`), 0, `mobile_rtb_block_bad_win_hits`) + if(isNaN(`inpage_block_bad_win_hits_unsold`), 0, `inpage_block_bad_win_hits_unsold`) + if(isNaN(`mobile_rtb_block_bad_shows`), 0, `mobile_rtb_block_bad_shows`) + if(isNaN(`outdoor_block_cpmh_partner_wo_nds`), 0, `outdoor_block_cpmh_partner_wo_nds`) + if(isNaN(`content_block_cover_ratio`), 0, `content_block_cover_ratio`) + if(isNaN(`mobile_rtb_block_bad_shows_percent`), 0, `mobile_rtb_block_bad_shows_percent`) + if(isNaN(`direct_context_partner_wo_nds`), 0, `direct_context_partner_wo_nds`) + if(isNaN(`market_search_shows`), 0, `market_search_shows`) + if(isNaN(`inpage_block_cpmh_partner_wo_nds`), 0, `inpage_block_cpmh_partner_wo_nds`) + if(isNaN(`video_an_site_all_hits_unsold`), 0, `video_an_site_all_hits_unsold`) + if(isNaN(`stripe_partner_wo_nds`), 0, `stripe_partner_wo_nds`) + if(isNaN(`direct_search_hits`), 0, `direct_search_hits`) + if(isNaN(`premium_cpmh_partner_wo_nds`), 0, `premium_cpmh_partner_wo_nds`) + if(isNaN(`instream_block_pauseroll_conversion_percent`), 0, `instream_block_pauseroll_conversion_percent`) + if(isNaN(`direct_search_cpm_direct_search_partner_wo_nds`), 0, `direct_search_cpm_direct_search_partner_wo_nds`) + if(isNaN(`indoor_block_all_hits`), 0, `indoor_block_all_hits`) + if(isNaN(`mcb_search_all_wo_nds`), 0, `mcb_search_all_wo_nds`) + if(isNaN(`outdoor_block_cover_ratio`), 0, `outdoor_block_cover_ratio`) + if(isNaN(`natural_block_bad_shows_percent`), 0, `natural_block_bad_shows_percent`) + if(isNaN(`instream_block_direct_clicks`), 0, `instream_block_direct_clicks`) + if(isNaN(`fullscreen_block_direct_shows`), 0, `fullscreen_block_direct_shows`) + if(isNaN(`outdoor_block_bad_win_hits`), 0, `outdoor_block_bad_win_hits`) + if(isNaN(`market_context_cpm_market_context_partner_wo_nds`), 0, `market_context_cpm_market_context_partner_wo_nds`) + if(isNaN(`indoor_block_hits_unsold`), 0, `indoor_block_hits_unsold`) + if(isNaN(`video_an_site_sum_all_wo_nds`), 0, `video_an_site_sum_all_wo_nds`) + if(isNaN(`rtb_block_bad_shows_percent`), 0, `rtb_block_bad_shows_percent`) + if(isNaN(`content_block_hits`), 0, `content_block_hits`) + if(isNaN(`an_mobile_rtb_cover_senthits`), 0, `an_mobile_rtb_cover_senthits`) + if(isNaN(`indoor_block_bad_win_hits`), 0, `indoor_block_bad_win_hits`) + if(isNaN(`rtb_block_bad_win_hits_percent`), 0, `rtb_block_bad_win_hits_percent`) + if(isNaN(`mcb_search_cpmh_mcb_search_all_wo_nds`), 0, `mcb_search_cpmh_mcb_search_all_wo_nds`) + if(isNaN(`mobile_rtb_block_hits`), 0, `mobile_rtb_block_hits`) + if(isNaN(`inpage_block_hits_own_adv`), 0, `inpage_block_hits_own_adv`) + if(isNaN(`instream_block_postroll_conversion_percent`), 0, `instream_block_postroll_conversion_percent`) + if(isNaN(`inpage_block_cpm_all_wo_nds`), 0, `inpage_block_cpm_all_wo_nds`) + if(isNaN(`fullscreen_block_hits_own_adv`), 0, `fullscreen_block_hits_own_adv`) + if(isNaN(`inpage_block_direct_clicks`), 0, `inpage_block_direct_clicks`) + if(isNaN(`inpage_block_cpm_partner_wo_nds`), 0, `inpage_block_cpm_partner_wo_nds`) + if(isNaN(`inpage_block_shows`), 0, `inpage_block_shows`) + if(isNaN(`content_block_bad_win_hits`), 0, `content_block_bad_win_hits`) + if(isNaN(`an_rtb_cover_senthits`), 0, `an_rtb_cover_senthits`) + if(isNaN(`premium_cpc_all_wo_nds`), 0, `premium_cpc_all_wo_nds`) + if(isNaN(`fullscreen_all_wo_nds`), 0, `fullscreen_all_wo_nds`) + if(isNaN(`content_block_hits_own_adv`), 0, `content_block_hits_own_adv`) + if(isNaN(`direct_ad_visibility`), 0, `direct_ad_visibility`) + if(isNaN(`natural_block_bad_win_hits_percent`), 0, `natural_block_bad_win_hits_percent`) + if(isNaN(`instream_block_direct_ctr`), 0, `instream_block_direct_ctr`) + if(isNaN(`natural_block_cpmh_partner_wo_nds`), 0, `natural_block_cpmh_partner_wo_nds`) + if(isNaN(`natural_all_wo_nds`), 0, `natural_all_wo_nds`) + if(isNaN(`premium_hits`), 0, `premium_hits`) + if(isNaN(`rtb_block_direct_clicks`), 0, `rtb_block_direct_clicks`) + if(isNaN(`mcb_context_shows`), 0, `mcb_context_shows`) + if(isNaN(`fullscreen_block_winrate`), 0, `fullscreen_block_winrate`) + if(isNaN(`rtb_block_winrate`), 0, `rtb_block_winrate`) + if(isNaN(`market_api_context_shows`), 0, `market_api_context_shows`) + if(isNaN(`direct_search_cpm_direct_search_all_wo_nds`), 0, `direct_search_cpm_direct_search_all_wo_nds`) + if(isNaN(`indoor_block_direct_ctr`), 0, `indoor_block_direct_ctr`) + if(isNaN(`mcb_search_ctr`), 0, `mcb_search_ctr`) + if(isNaN(`instream_block_shows_own_adv`), 0, `instream_block_shows_own_adv`) + if(isNaN(`indoor_block_bad_shows_own_adv`), 0, `indoor_block_bad_shows_own_adv`) + if(isNaN(`natural_block_all_hits`), 0, `natural_block_all_hits`) + if(isNaN(`rtb_block_bad_win_hits`), 0, `rtb_block_bad_win_hits`) + if(isNaN(`rtb_block_hits_unsold`), 0, `rtb_block_hits_unsold`) + if(isNaN(`mobile_rtb_block_rpm_partner_wo_nds`), 0, `mobile_rtb_block_rpm_partner_wo_nds`) + if(isNaN(`outdoor_block_cpm_all_wo_nds`), 0, `outdoor_block_cpm_all_wo_nds`) + if(isNaN(`fullscreen_block_bad_win_hits_percent`), 0, `fullscreen_block_bad_win_hits_percent`) + if(isNaN(`bad_win_price_wo_nds`), 0, `bad_win_price_wo_nds`) + if(isNaN(`mobile_rtb_block_bad_win_hits_own_adv`), 0, `mobile_rtb_block_bad_win_hits_own_adv`) + if(isNaN(`mobile_rtb_block_shows_own_adv`), 0, `mobile_rtb_block_shows_own_adv`) + if(isNaN(`mcb_search_hits`), 0, `mcb_search_hits`) + if(isNaN(`content_bad_win_partner_price_wo_nds`), 0, `content_bad_win_partner_price_wo_nds`) + if(isNaN(`mobile_rtb_block_rpm_all_wo_nds`), 0, `mobile_rtb_block_rpm_all_wo_nds`) + if(isNaN(`content_all_wo_nds`), 0, `content_all_wo_nds`) + if(isNaN(`outdoor_block_bad_shows_percent`), 0, `outdoor_block_bad_shows_percent`) + if(isNaN(`stripe_cpmh_partner_wo_nds`), 0, `stripe_cpmh_partner_wo_nds`) + if(isNaN(`direct_search_all_wo_nds`), 0, `direct_search_all_wo_nds`) + if(isNaN(`inpage_block_bad_shows_percent`), 0, `inpage_block_bad_shows_percent`) + if(isNaN(`ssp_mobile_rtb_all_wo_nds`), 0, `ssp_mobile_rtb_all_wo_nds`) + if(isNaN(`rtb_block_shows_own_adv`), 0, `rtb_block_shows_own_adv`) + if(isNaN(`market_api_context_partner_wo_nds`), 0, `market_api_context_partner_wo_nds`) + if(isNaN(`market_context_partner_wo_nds`), 0, `market_context_partner_wo_nds`) + if(isNaN(`outdoor_block_bad_shows`), 0, `outdoor_block_bad_shows`) + if(isNaN(`ssp_mobile_rtb_block_cpmh_partner_wo_nds`), 0, `ssp_mobile_rtb_block_cpmh_partner_wo_nds`) + if(isNaN(`indoor_block_visibility`), 0, `indoor_block_visibility`) + if(isNaN(`instream_block_direct_shows`), 0, `instream_block_direct_shows`) + if(isNaN(`fullscreen_block_cpmh_all_wo_nds`), 0, `fullscreen_block_cpmh_all_wo_nds`) + if(isNaN(`an_ssp_mobile_rtb_cover_direct_hits`), 0, `an_ssp_mobile_rtb_cover_direct_hits`) + if(isNaN(`rtb_block_cpmh_all_wo_nds`), 0, `rtb_block_cpmh_all_wo_nds`) + if(isNaN(`premium_shows`), 0, `premium_shows`) + if(isNaN(`inpage_block_direct_ctr`), 0, `inpage_block_direct_ctr`) + if(isNaN(`premium_cpmh_all_wo_nds`), 0, `premium_cpmh_all_wo_nds`) + if(isNaN(`outdoor_block_direct_clicks`), 0, `outdoor_block_direct_clicks`) + if(isNaN(`market_context_hits`), 0, `market_context_hits`) + if(isNaN(`market_search_cpm_market_search_all_wo_nds`), 0, `market_search_cpm_market_search_all_wo_nds`) + if(isNaN(`market_api_search_all_wo_nds`), 0, `market_api_search_all_wo_nds`)) > 0
) FORMAT JSONCompact
