SELECT
    `_all_wo_nds` AS `all_wo_nds`,
    `_an_cover_direct_hits` AS `an_cover_direct_hits`,
    `_an_cover_hits` AS `an_cover_hits`,
    `_an_cover_market_hits` AS `an_cover_market_hits`,
    `_an_cover_mcb_hits` AS `an_cover_mcb_hits`,
    `_an_cover_senthits` AS `an_cover_senthits`,
    `_an_fraud_clicks` AS `an_fraud_clicks`,
    `_an_fraud_shows` AS `an_fraud_shows`,
    `_an_rtb_cover_direct_hits` AS `an_rtb_cover_direct_hits`,
    `_an_rtb_cover_hits` AS `an_rtb_cover_hits`,
    `_an_rtb_cover_senthits` AS `an_rtb_cover_senthits`,
    `_bad_win_partner_price_wo_nds` AS `bad_win_partner_price_wo_nds`,
    `_bad_win_price_wo_nds` AS `bad_win_price_wo_nds`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_direct_ad_coverage` AS `direct_ad_coverage`,
    `_direct_ad_reach` AS `direct_ad_reach`,
    `_direct_ad_visibility` AS `direct_ad_visibility`,
    `_direct_context_hits` AS `direct_context_hits`,
    `_direct_context_page_ad_shows` AS `direct_context_page_ad_shows`,
    `_domain` AS `domain`,
    `_market_context_hits` AS `market_context_hits`,
    `_mcb_context_hits` AS `mcb_context_hits`,
    `_page_id` AS `page_id`,
    `_partner_wo_nds` AS `partner_wo_nds`,
    `_percent_rtb_bad_win_partner_price_rtb_partner_wo_nds` AS `percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`,
    `_percent_rtb_bad_win_price_rtb_all_wo_nds` AS `percent_rtb_bad_win_price_rtb_all_wo_nds`,
    `_rtb_all_wo_nds` AS `rtb_all_wo_nds`,
    `_rtb_bad_win_partner_price_wo_nds` AS `rtb_bad_win_partner_price_wo_nds`,
    `_rtb_bad_win_price_wo_nds` AS `rtb_bad_win_price_wo_nds`,
    `_rtb_block_all_hits` AS `rtb_block_all_hits`,
    `_rtb_block_bad_shows` AS `rtb_block_bad_shows`,
    `_rtb_block_bad_shows_own_adv` AS `rtb_block_bad_shows_own_adv`,
    `_rtb_block_bad_shows_percent` AS `rtb_block_bad_shows_percent`,
    `_rtb_block_bad_win_hits` AS `rtb_block_bad_win_hits`,
    `_rtb_block_bad_win_hits_own_adv` AS `rtb_block_bad_win_hits_own_adv`,
    `_rtb_block_bad_win_hits_percent` AS `rtb_block_bad_win_hits_percent`,
    `_rtb_block_bad_win_hits_unsold` AS `rtb_block_bad_win_hits_unsold`,
    `_rtb_block_cover_ratio` AS `rtb_block_cover_ratio`,
    `_rtb_block_cpm_all_wo_nds` AS `rtb_block_cpm_all_wo_nds`,
    `_rtb_block_cpm_partner_wo_nds` AS `rtb_block_cpm_partner_wo_nds`,
    `_rtb_block_cpmh_all_wo_nds` AS `rtb_block_cpmh_all_wo_nds`,
    `_rtb_block_cpmh_partner_wo_nds` AS `rtb_block_cpmh_partner_wo_nds`,
    `_rtb_block_direct_clicks` AS `rtb_block_direct_clicks`,
    `_rtb_block_direct_ctr` AS `rtb_block_direct_ctr`,
    `_rtb_block_direct_shows` AS `rtb_block_direct_shows`,
    `_rtb_block_hits` AS `rtb_block_hits`,
    `_rtb_block_hits_own_adv` AS `rtb_block_hits_own_adv`,
    `_rtb_block_hits_unsold` AS `rtb_block_hits_unsold`,
    `_rtb_block_rpm_all_wo_nds` AS `rtb_block_rpm_all_wo_nds`,
    `_rtb_block_rpm_partner_wo_nds` AS `rtb_block_rpm_partner_wo_nds`,
    `_rtb_block_shows` AS `rtb_block_shows`,
    `_rtb_block_shows_own_adv` AS `rtb_block_shows_own_adv`,
    `_rtb_block_visibility` AS `rtb_block_visibility`,
    `_rtb_block_winrate` AS `rtb_block_winrate`,
    `_rtb_partner_wo_nds` AS `rtb_partner_wo_nds`,
    `_seller_name` AS `seller_name`
FROM (
    SELECT
        round((SUM((`all_wo_nds` / 1000)) / 10000000), 2) AS `_all_wo_nds`,
        sumIf(`an_cover_direct_hits`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_cover_direct_hits`,
        sumIf(`an_cover_hits`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_cover_hits`,
        sumIf(`an_cover_market_hits`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_cover_market_hits`,
        sumIf(`an_cover_mcb_hits`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_cover_mcb_hits`,
        sumIf(`an_cover_senthits`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_cover_senthits`,
        sumIf(`an_fraud_clicks`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_fraud_clicks`,
        sumIf(`an_fraud_shows`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_fraud_shows`,
        sumIf(`an_rtb_cover_direct_hits`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_rtb_cover_direct_hits`,
        sumIf(`an_rtb_cover_hits`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_rtb_cover_hits`,
        sumIf(`an_rtb_cover_senthits`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_rtb_cover_senthits`,
        round((SUM((`bad_win_partner_price_wo_nds` / 1000)) / 10000000), 2) AS `_bad_win_partner_price_wo_nds`,
        round((SUM((`bad_win_price_wo_nds` / 1000)) / 10000000), 2) AS `_bad_win_price_wo_nds`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        ((sumIf(`an_cover_direct_hits`, `product_id` = 'ssp_context_on_site_campaign') * 100) / sumIf(`an_cover_hits`, `product_id` = 'ssp_context_on_site_campaign')) AS `_direct_ad_coverage`,
        ((sumIf(`an_cover_senthits`, `product_id` = 'ssp_context_on_site_campaign') * 100) / sumIf(`an_cover_hits`, `product_id` = 'ssp_context_on_site_campaign')) AS `_direct_ad_reach`,
        ((sumIf(`an_cover_direct_hits`, `product_id` = 'ssp_context_on_site_campaign') * 100) / sumIf(`an_cover_senthits`, `product_id` = 'ssp_context_on_site_campaign')) AS `_direct_ad_visibility`,
        sumIf(`direct_hits`, `product_id` = 'ssp_context_on_site_campaign') AS `_direct_context_hits`,
        sumIf(`direct_page_ad_shows`, `product_id` = 'ssp_context_on_site_campaign') AS `_direct_context_page_ad_shows`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        sumIf(`market_hits`, `product_id` = 'ssp_context_on_site_campaign') AS `_market_context_hits`,
        sumIf(`mcb_hits`, `product_id` = 'ssp_context_on_site_campaign') AS `_mcb_context_hits`,
        `page_id` AS `_page_id`,
        round((SUM((`partner_wo_nds` / 1000)) / 10000000), 2) AS `_partner_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb'))) AS `_percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb'))) AS `_percent_rtb_bad_win_price_rtb_all_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000), 2) AS `_rtb_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000), 2) AS `_rtb_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000), 2) AS `_rtb_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'ssp_context_on_site_rtb') AS `_rtb_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_context_on_site_rtb'
            )))) AS `_rtb_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_context_on_site_rtb'
            )))) AS `_rtb_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) * 100) / sumIf(`hits`, `product_id` = 'ssp_context_on_site_rtb')) AS `_rtb_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'ssp_context_on_site_rtb')) AS `_rtb_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'ssp_context_on_site_rtb') AS `_rtb_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'ssp_context_on_site_rtb')), 2) AS `_rtb_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'ssp_context_on_site_rtb')), 2) AS `_rtb_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'ssp_context_on_site_rtb'
        ))) AS `_rtb_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'ssp_context_on_site_rtb'
            )))) AS `_rtb_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000), 2) AS `_rtb_partner_wo_nds`,
        dictGetString('sellers_dict', 'name', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_seller_name`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('ssp_context_on_site_campaign', 'ssp_context_on_site_rtb')
        AND (
            `page_id` = 'mock__page_id'
        )
        AND (
            dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) IN ('id__from_table__ssp_site__with_filter__["AND",[["domain","=","mock__ssp_source.domain"]]]')
        )
        AND (
            dictGetUInt32('users_dict', 'client_id', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 'mock__seller_id'
        )
        AND (
            dictGetUInt64('pages_dict', 'multistate', toUInt64(`page_id`)) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
    )
    GROUP BY `_currency_id`, `_date`, `_domain`, `_page_id`, `_seller_name`
) `statistics`
WHERE (
    (if(isNaN(`an_fraud_clicks`), 0, `an_fraud_clicks`) + if(isNaN(`rtb_block_bad_shows`), 0, `rtb_block_bad_shows`) + if(isNaN(`rtb_block_direct_clicks`), 0, `rtb_block_direct_clicks`) + if(isNaN(`rtb_bad_win_price_wo_nds`), 0, `rtb_bad_win_price_wo_nds`) + if(isNaN(`an_rtb_cover_direct_hits`), 0, `an_rtb_cover_direct_hits`) + if(isNaN(`rtb_block_winrate`), 0, `rtb_block_winrate`) + if(isNaN(`rtb_block_cpmh_partner_wo_nds`), 0, `rtb_block_cpmh_partner_wo_nds`) + if(isNaN(`an_cover_hits`), 0, `an_cover_hits`) + if(isNaN(`bad_win_partner_price_wo_nds`), 0, `bad_win_partner_price_wo_nds`) + if(isNaN(`rtb_block_hits`), 0, `rtb_block_hits`) + if(isNaN(`an_cover_direct_hits`), 0, `an_cover_direct_hits`) + if(isNaN(`rtb_block_bad_win_hits`), 0, `rtb_block_bad_win_hits`) + if(isNaN(`rtb_block_hits_unsold`), 0, `rtb_block_hits_unsold`) + if(isNaN(`rtb_block_bad_win_hits_unsold`), 0, `rtb_block_bad_win_hits_unsold`) + if(isNaN(`partner_wo_nds`), 0, `partner_wo_nds`) + if(isNaN(`bad_win_price_wo_nds`), 0, `bad_win_price_wo_nds`) + if(isNaN(`rtb_block_hits_own_adv`), 0, `rtb_block_hits_own_adv`) + if(isNaN(`rtb_block_direct_ctr`), 0, `rtb_block_direct_ctr`) + if(isNaN(`percent_rtb_bad_win_price_rtb_all_wo_nds`), 0, `percent_rtb_bad_win_price_rtb_all_wo_nds`) + if(isNaN(`direct_ad_coverage`), 0, `direct_ad_coverage`) + if(isNaN(`an_cover_market_hits`), 0, `an_cover_market_hits`) + if(isNaN(`rtb_block_shows`), 0, `rtb_block_shows`) + if(isNaN(`an_cover_senthits`), 0, `an_cover_senthits`) + if(isNaN(`an_cover_mcb_hits`), 0, `an_cover_mcb_hits`) + if(isNaN(`direct_ad_reach`), 0, `direct_ad_reach`) + if(isNaN(`direct_context_page_ad_shows`), 0, `direct_context_page_ad_shows`) + if(isNaN(`rtb_block_bad_shows_percent`), 0, `rtb_block_bad_shows_percent`) + if(isNaN(`rtb_block_direct_shows`), 0, `rtb_block_direct_shows`) + if(isNaN(`rtb_block_all_hits`), 0, `rtb_block_all_hits`) + if(isNaN(`rtb_block_cover_ratio`), 0, `rtb_block_cover_ratio`) + if(isNaN(`rtb_all_wo_nds`), 0, `rtb_all_wo_nds`) + if(isNaN(`rtb_partner_wo_nds`), 0, `rtb_partner_wo_nds`) + if(isNaN(`rtb_block_shows_own_adv`), 0, `rtb_block_shows_own_adv`) + if(isNaN(`all_wo_nds`), 0, `all_wo_nds`) + if(isNaN(`rtb_block_bad_win_hits_percent`), 0, `rtb_block_bad_win_hits_percent`) + if(isNaN(`direct_context_hits`), 0, `direct_context_hits`) + if(isNaN(`an_rtb_cover_hits`), 0, `an_rtb_cover_hits`) + if(isNaN(`an_fraud_shows`), 0, `an_fraud_shows`) + if(isNaN(`rtb_block_rpm_partner_wo_nds`), 0, `rtb_block_rpm_partner_wo_nds`) + if(isNaN(`rtb_block_bad_shows_own_adv`), 0, `rtb_block_bad_shows_own_adv`) + if(isNaN(`rtb_block_bad_win_hits_own_adv`), 0, `rtb_block_bad_win_hits_own_adv`) + if(isNaN(`rtb_block_cpmh_all_wo_nds`), 0, `rtb_block_cpmh_all_wo_nds`) + if(isNaN(`rtb_block_cpm_partner_wo_nds`), 0, `rtb_block_cpm_partner_wo_nds`) + if(isNaN(`rtb_bad_win_partner_price_wo_nds`), 0, `rtb_bad_win_partner_price_wo_nds`) + if(isNaN(`market_context_hits`), 0, `market_context_hits`) + if(isNaN(`rtb_block_cpm_all_wo_nds`), 0, `rtb_block_cpm_all_wo_nds`) + if(isNaN(`rtb_block_visibility`), 0, `rtb_block_visibility`) + if(isNaN(`rtb_block_rpm_all_wo_nds`), 0, `rtb_block_rpm_all_wo_nds`) + if(isNaN(`an_rtb_cover_senthits`), 0, `an_rtb_cover_senthits`) + if(isNaN(`direct_ad_visibility`), 0, `direct_ad_visibility`) + if(isNaN(`percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`), 0, `percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`) + if(isNaN(`mcb_context_hits`), 0, `mcb_context_hits`)) > 0
) FORMAT JSONCompact

SELECT
    `_all_wo_nds` AS `all_wo_nds`,
    `_an_cover_direct_hits` AS `an_cover_direct_hits`,
    `_an_cover_hits` AS `an_cover_hits`,
    `_an_cover_market_hits` AS `an_cover_market_hits`,
    `_an_cover_mcb_hits` AS `an_cover_mcb_hits`,
    `_an_cover_senthits` AS `an_cover_senthits`,
    `_an_fraud_clicks` AS `an_fraud_clicks`,
    `_an_fraud_shows` AS `an_fraud_shows`,
    `_an_rtb_cover_direct_hits` AS `an_rtb_cover_direct_hits`,
    `_an_rtb_cover_hits` AS `an_rtb_cover_hits`,
    `_an_rtb_cover_senthits` AS `an_rtb_cover_senthits`,
    `_bad_win_partner_price_wo_nds` AS `bad_win_partner_price_wo_nds`,
    `_bad_win_price_wo_nds` AS `bad_win_price_wo_nds`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_direct_ad_coverage` AS `direct_ad_coverage`,
    `_direct_ad_reach` AS `direct_ad_reach`,
    `_direct_ad_visibility` AS `direct_ad_visibility`,
    `_direct_context_hits` AS `direct_context_hits`,
    `_direct_context_page_ad_shows` AS `direct_context_page_ad_shows`,
    `_domain` AS `domain`,
    `_market_context_hits` AS `market_context_hits`,
    `_mcb_context_hits` AS `mcb_context_hits`,
    `_page_id` AS `page_id`,
    `_partner_wo_nds` AS `partner_wo_nds`,
    `_percent_rtb_bad_win_partner_price_rtb_partner_wo_nds` AS `percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`,
    `_percent_rtb_bad_win_price_rtb_all_wo_nds` AS `percent_rtb_bad_win_price_rtb_all_wo_nds`,
    `_rtb_all_wo_nds` AS `rtb_all_wo_nds`,
    `_rtb_bad_win_partner_price_wo_nds` AS `rtb_bad_win_partner_price_wo_nds`,
    `_rtb_bad_win_price_wo_nds` AS `rtb_bad_win_price_wo_nds`,
    `_rtb_block_all_hits` AS `rtb_block_all_hits`,
    `_rtb_block_bad_shows` AS `rtb_block_bad_shows`,
    `_rtb_block_bad_shows_own_adv` AS `rtb_block_bad_shows_own_adv`,
    `_rtb_block_bad_shows_percent` AS `rtb_block_bad_shows_percent`,
    `_rtb_block_bad_win_hits` AS `rtb_block_bad_win_hits`,
    `_rtb_block_bad_win_hits_own_adv` AS `rtb_block_bad_win_hits_own_adv`,
    `_rtb_block_bad_win_hits_percent` AS `rtb_block_bad_win_hits_percent`,
    `_rtb_block_bad_win_hits_unsold` AS `rtb_block_bad_win_hits_unsold`,
    `_rtb_block_cover_ratio` AS `rtb_block_cover_ratio`,
    `_rtb_block_cpm_all_wo_nds` AS `rtb_block_cpm_all_wo_nds`,
    `_rtb_block_cpm_partner_wo_nds` AS `rtb_block_cpm_partner_wo_nds`,
    `_rtb_block_cpmh_all_wo_nds` AS `rtb_block_cpmh_all_wo_nds`,
    `_rtb_block_cpmh_partner_wo_nds` AS `rtb_block_cpmh_partner_wo_nds`,
    `_rtb_block_direct_clicks` AS `rtb_block_direct_clicks`,
    `_rtb_block_direct_ctr` AS `rtb_block_direct_ctr`,
    `_rtb_block_direct_shows` AS `rtb_block_direct_shows`,
    `_rtb_block_hits` AS `rtb_block_hits`,
    `_rtb_block_hits_own_adv` AS `rtb_block_hits_own_adv`,
    `_rtb_block_hits_unsold` AS `rtb_block_hits_unsold`,
    `_rtb_block_rpm_all_wo_nds` AS `rtb_block_rpm_all_wo_nds`,
    `_rtb_block_rpm_partner_wo_nds` AS `rtb_block_rpm_partner_wo_nds`,
    `_rtb_block_shows` AS `rtb_block_shows`,
    `_rtb_block_shows_own_adv` AS `rtb_block_shows_own_adv`,
    `_rtb_block_visibility` AS `rtb_block_visibility`,
    `_rtb_block_winrate` AS `rtb_block_winrate`,
    `_rtb_partner_wo_nds` AS `rtb_partner_wo_nds`,
    `_seller_name` AS `seller_name`
FROM (
    SELECT
        round((SUM((`all_wo_nds` / 1000)) / 10000000), 2) AS `_all_wo_nds`,
        sumIf(`an_cover_direct_hits`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_cover_direct_hits`,
        sumIf(`an_cover_hits`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_cover_hits`,
        sumIf(`an_cover_market_hits`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_cover_market_hits`,
        sumIf(`an_cover_mcb_hits`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_cover_mcb_hits`,
        sumIf(`an_cover_senthits`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_cover_senthits`,
        sumIf(`an_fraud_clicks`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_fraud_clicks`,
        sumIf(`an_fraud_shows`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_fraud_shows`,
        sumIf(`an_rtb_cover_direct_hits`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_rtb_cover_direct_hits`,
        sumIf(`an_rtb_cover_hits`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_rtb_cover_hits`,
        sumIf(`an_rtb_cover_senthits`, `product_id` = 'ssp_context_on_site_campaign') AS `_an_rtb_cover_senthits`,
        round((SUM((`bad_win_partner_price_wo_nds` / 1000)) / 10000000), 2) AS `_bad_win_partner_price_wo_nds`,
        round((SUM((`bad_win_price_wo_nds` / 1000)) / 10000000), 2) AS `_bad_win_price_wo_nds`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        ((sumIf(`an_cover_direct_hits`, `product_id` = 'ssp_context_on_site_campaign') * 100) / sumIf(`an_cover_hits`, `product_id` = 'ssp_context_on_site_campaign')) AS `_direct_ad_coverage`,
        ((sumIf(`an_cover_senthits`, `product_id` = 'ssp_context_on_site_campaign') * 100) / sumIf(`an_cover_hits`, `product_id` = 'ssp_context_on_site_campaign')) AS `_direct_ad_reach`,
        ((sumIf(`an_cover_direct_hits`, `product_id` = 'ssp_context_on_site_campaign') * 100) / sumIf(`an_cover_senthits`, `product_id` = 'ssp_context_on_site_campaign')) AS `_direct_ad_visibility`,
        sumIf(`direct_hits`, `product_id` = 'ssp_context_on_site_campaign') AS `_direct_context_hits`,
        sumIf(`direct_page_ad_shows`, `product_id` = 'ssp_context_on_site_campaign') AS `_direct_context_page_ad_shows`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        sumIf(`market_hits`, `product_id` = 'ssp_context_on_site_campaign') AS `_market_context_hits`,
        sumIf(`mcb_hits`, `product_id` = 'ssp_context_on_site_campaign') AS `_mcb_context_hits`,
        `page_id` AS `_page_id`,
        round((SUM((`partner_wo_nds` / 1000)) / 10000000), 2) AS `_partner_wo_nds`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb'))) AS `_percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb'))) AS `_percent_rtb_bad_win_price_rtb_all_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000), 2) AS `_rtb_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000), 2) AS `_rtb_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000), 2) AS `_rtb_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'ssp_context_on_site_rtb') AS `_rtb_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_context_on_site_rtb'
            )))) AS `_rtb_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_context_on_site_rtb'
            )))) AS `_rtb_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) * 100) / sumIf(`hits`, `product_id` = 'ssp_context_on_site_rtb')) AS `_rtb_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_context_on_site_rtb'
            ))), 2) AS `_rtb_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'ssp_context_on_site_rtb')) AS `_rtb_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'ssp_context_on_site_rtb') AS `_rtb_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'ssp_context_on_site_rtb')), 2) AS `_rtb_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'ssp_context_on_site_rtb')), 2) AS `_rtb_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'ssp_context_on_site_rtb'
    )) AS `_rtb_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'ssp_context_on_site_rtb'
        ))) AS `_rtb_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'ssp_context_on_site_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'ssp_context_on_site_rtb'
            )))) AS `_rtb_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_context_on_site_rtb') / 10000000), 2) AS `_rtb_partner_wo_nds`,
        dictGetString('sellers_dict', 'name', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_seller_name`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('ssp_context_on_site_campaign', 'ssp_context_on_site_rtb')
        AND (
            `page_id` = 'mock__page_id'
        )
        AND (
            dictGetUInt32('pages_dict', 'domain_id', toUInt64(`page_id`)) IN ('id__from_table__ssp_site__with_filter__["AND",[["domain","=","mock__ssp_source.domain"]]]')
        )
        AND (
            dictGetUInt32('users_dict', 'client_id', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) = 'mock__seller_id'
        )
        AND (
            dictGetUInt64('pages_dict', 'multistate', toUInt64(`page_id`)) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
    )
    GROUP BY `_currency_id`, `_date`, `_domain`, `_page_id`, `_seller_name`
) `statistics`
WHERE (
    (if(isNaN(`an_fraud_clicks`), 0, `an_fraud_clicks`) + if(isNaN(`rtb_block_bad_shows`), 0, `rtb_block_bad_shows`) + if(isNaN(`rtb_block_direct_clicks`), 0, `rtb_block_direct_clicks`) + if(isNaN(`rtb_bad_win_price_wo_nds`), 0, `rtb_bad_win_price_wo_nds`) + if(isNaN(`an_rtb_cover_direct_hits`), 0, `an_rtb_cover_direct_hits`) + if(isNaN(`rtb_block_winrate`), 0, `rtb_block_winrate`) + if(isNaN(`rtb_block_cpmh_partner_wo_nds`), 0, `rtb_block_cpmh_partner_wo_nds`) + if(isNaN(`an_cover_hits`), 0, `an_cover_hits`) + if(isNaN(`bad_win_partner_price_wo_nds`), 0, `bad_win_partner_price_wo_nds`) + if(isNaN(`rtb_block_hits`), 0, `rtb_block_hits`) + if(isNaN(`an_cover_direct_hits`), 0, `an_cover_direct_hits`) + if(isNaN(`rtb_block_bad_win_hits`), 0, `rtb_block_bad_win_hits`) + if(isNaN(`rtb_block_hits_unsold`), 0, `rtb_block_hits_unsold`) + if(isNaN(`rtb_block_bad_win_hits_unsold`), 0, `rtb_block_bad_win_hits_unsold`) + if(isNaN(`partner_wo_nds`), 0, `partner_wo_nds`) + if(isNaN(`bad_win_price_wo_nds`), 0, `bad_win_price_wo_nds`) + if(isNaN(`rtb_block_hits_own_adv`), 0, `rtb_block_hits_own_adv`) + if(isNaN(`rtb_block_direct_ctr`), 0, `rtb_block_direct_ctr`) + if(isNaN(`percent_rtb_bad_win_price_rtb_all_wo_nds`), 0, `percent_rtb_bad_win_price_rtb_all_wo_nds`) + if(isNaN(`direct_ad_coverage`), 0, `direct_ad_coverage`) + if(isNaN(`an_cover_market_hits`), 0, `an_cover_market_hits`) + if(isNaN(`rtb_block_shows`), 0, `rtb_block_shows`) + if(isNaN(`an_cover_senthits`), 0, `an_cover_senthits`) + if(isNaN(`an_cover_mcb_hits`), 0, `an_cover_mcb_hits`) + if(isNaN(`direct_ad_reach`), 0, `direct_ad_reach`) + if(isNaN(`direct_context_page_ad_shows`), 0, `direct_context_page_ad_shows`) + if(isNaN(`rtb_block_bad_shows_percent`), 0, `rtb_block_bad_shows_percent`) + if(isNaN(`rtb_block_direct_shows`), 0, `rtb_block_direct_shows`) + if(isNaN(`rtb_block_all_hits`), 0, `rtb_block_all_hits`) + if(isNaN(`rtb_block_cover_ratio`), 0, `rtb_block_cover_ratio`) + if(isNaN(`rtb_all_wo_nds`), 0, `rtb_all_wo_nds`) + if(isNaN(`rtb_partner_wo_nds`), 0, `rtb_partner_wo_nds`) + if(isNaN(`rtb_block_shows_own_adv`), 0, `rtb_block_shows_own_adv`) + if(isNaN(`all_wo_nds`), 0, `all_wo_nds`) + if(isNaN(`rtb_block_bad_win_hits_percent`), 0, `rtb_block_bad_win_hits_percent`) + if(isNaN(`direct_context_hits`), 0, `direct_context_hits`) + if(isNaN(`an_rtb_cover_hits`), 0, `an_rtb_cover_hits`) + if(isNaN(`an_fraud_shows`), 0, `an_fraud_shows`) + if(isNaN(`rtb_block_rpm_partner_wo_nds`), 0, `rtb_block_rpm_partner_wo_nds`) + if(isNaN(`rtb_block_bad_shows_own_adv`), 0, `rtb_block_bad_shows_own_adv`) + if(isNaN(`rtb_block_bad_win_hits_own_adv`), 0, `rtb_block_bad_win_hits_own_adv`) + if(isNaN(`rtb_block_cpmh_all_wo_nds`), 0, `rtb_block_cpmh_all_wo_nds`) + if(isNaN(`rtb_block_cpm_partner_wo_nds`), 0, `rtb_block_cpm_partner_wo_nds`) + if(isNaN(`rtb_bad_win_partner_price_wo_nds`), 0, `rtb_bad_win_partner_price_wo_nds`) + if(isNaN(`market_context_hits`), 0, `market_context_hits`) + if(isNaN(`rtb_block_cpm_all_wo_nds`), 0, `rtb_block_cpm_all_wo_nds`) + if(isNaN(`rtb_block_visibility`), 0, `rtb_block_visibility`) + if(isNaN(`rtb_block_rpm_all_wo_nds`), 0, `rtb_block_rpm_all_wo_nds`) + if(isNaN(`an_rtb_cover_senthits`), 0, `an_rtb_cover_senthits`) + if(isNaN(`direct_ad_visibility`), 0, `direct_ad_visibility`) + if(isNaN(`percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`), 0, `percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`) + if(isNaN(`mcb_context_hits`), 0, `mcb_context_hits`)) > 0
) FORMAT JSONCompact
