SELECT
    `_bundle_id` AS `bundle_id`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_dsp_caption` AS `dsp_caption`,
    `_dsp_id_name` AS `dsp_id_name`,
    `_page_id` AS `page_id`,
    `_seller_name` AS `seller_name`,
    `_ssp_mobile_rtb_all_wo_nds` AS `ssp_mobile_rtb_all_wo_nds`,
    `_ssp_mobile_rtb_block_all_hits` AS `ssp_mobile_rtb_block_all_hits`,
    `_ssp_mobile_rtb_block_cover_ratio` AS `ssp_mobile_rtb_block_cover_ratio`,
    `_ssp_mobile_rtb_block_cpm_all_wo_nds` AS `ssp_mobile_rtb_block_cpm_all_wo_nds`,
    `_ssp_mobile_rtb_block_cpm_partner_wo_nds` AS `ssp_mobile_rtb_block_cpm_partner_wo_nds`,
    `_ssp_mobile_rtb_block_cpmh_all_wo_nds` AS `ssp_mobile_rtb_block_cpmh_all_wo_nds`,
    `_ssp_mobile_rtb_block_cpmh_partner_wo_nds` AS `ssp_mobile_rtb_block_cpmh_partner_wo_nds`,
    `_ssp_mobile_rtb_block_hits` AS `ssp_mobile_rtb_block_hits`,
    `_ssp_mobile_rtb_block_hits_own_adv` AS `ssp_mobile_rtb_block_hits_own_adv`,
    `_ssp_mobile_rtb_block_hits_unsold` AS `ssp_mobile_rtb_block_hits_unsold`,
    `_ssp_mobile_rtb_block_rpm_all_wo_nds` AS `ssp_mobile_rtb_block_rpm_all_wo_nds`,
    `_ssp_mobile_rtb_block_rpm_partner_wo_nds` AS `ssp_mobile_rtb_block_rpm_partner_wo_nds`,
    `_ssp_mobile_rtb_block_shows` AS `ssp_mobile_rtb_block_shows`,
    `_ssp_mobile_rtb_block_visibility` AS `ssp_mobile_rtb_block_visibility`,
    `_ssp_mobile_rtb_block_winrate` AS `ssp_mobile_rtb_block_winrate`,
    `_ssp_mobile_rtb_partner_wo_nds` AS `ssp_mobile_rtb_partner_wo_nds`
FROM (
    SELECT
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_bundle_id`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetStringOrDefault('dsps_dict', 'short_caption', toUInt64(`dsp_id`), concat('DSP #', toString(`dsp_id`))) AS `_dsp_caption`,
        `dsp_id` AS `_dsp_id_name`,
        `page_id` AS `_page_id`,
        dictGetString('sellers_dict', 'name', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_seller_name`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000), 2) AS `_ssp_mobile_rtb_all_wo_nds`,
        sumIf(`hits`, `product_id` = 'ssp_mobile_app_rtb') AS `_ssp_mobile_rtb_block_all_hits`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_mobile_app_rtb'
            )) * 100) / sumIf(`hits`, `product_id` = 'ssp_mobile_app_rtb')) AS `_ssp_mobile_rtb_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_mobile_app_rtb'
            ))), 2) AS `_ssp_mobile_rtb_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_mobile_app_rtb'
            ))), 2) AS `_ssp_mobile_rtb_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_mobile_app_rtb'
            ))), 2) AS `_ssp_mobile_rtb_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_mobile_app_rtb'
            ))), 2) AS `_ssp_mobile_rtb_block_cpmh_partner_wo_nds`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'ssp_mobile_app_rtb'
    )) AS `_ssp_mobile_rtb_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'ssp_mobile_app_rtb'
    )) AS `_ssp_mobile_rtb_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'ssp_mobile_app_rtb'
    )) AS `_ssp_mobile_rtb_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'ssp_mobile_app_rtb')), 2) AS `_ssp_mobile_rtb_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'ssp_mobile_app_rtb')), 2) AS `_ssp_mobile_rtb_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'ssp_mobile_app_rtb'
    )) AS `_ssp_mobile_rtb_block_shows`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_mobile_app_rtb'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'ssp_mobile_app_rtb'
        ))) AS `_ssp_mobile_rtb_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_mobile_app_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_mobile_app_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'ssp_mobile_app_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'ssp_mobile_app_rtb'
            )))) AS `_ssp_mobile_rtb_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_mobile_app_rtb') / 10000000), 2) AS `_ssp_mobile_rtb_partner_wo_nds`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('ssp_mobile_app_rtb')
        AND (
            `page_id` = 'mock__campaign_id'
        )
        AND (
            `page_id` IN ('page_id__from_table__ssp_mobile_app_settings__with_filter__["AND",[["source_id","= ANY",["id__from_table__ssp_application__with_filter__[\\"AND\\",[[\\"bundle_id\\",\\"=\\",\\"mock__page.ssp_source.bundle_id\\"]]]"]]]]')
        )
        AND (
            `page_id` IN ('page_id__from_table__ssp_mobile_app_settings__with_filter__["AND",[["seller_id","=","mock__page.seller_id"]]]')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
        AND `dsp_id` = 'mock__dsp_id_name'
        AND `dsp_id` = 'mock__dsp_caption'
    )
    GROUP BY `_bundle_id`, `_currency_id`, `_date`, `_dsp_caption`, `_dsp_id_name`, `_page_id`, `_seller_name`
) `statistics`
WHERE (
    (if(isNaN(`ssp_mobile_rtb_block_hits`), 0, `ssp_mobile_rtb_block_hits`) + if(isNaN(`ssp_mobile_rtb_block_cpm_all_wo_nds`), 0, `ssp_mobile_rtb_block_cpm_all_wo_nds`) + if(isNaN(`ssp_mobile_rtb_block_winrate`), 0, `ssp_mobile_rtb_block_winrate`) + if(isNaN(`ssp_mobile_rtb_all_wo_nds`), 0, `ssp_mobile_rtb_all_wo_nds`) + if(isNaN(`ssp_mobile_rtb_block_cpm_partner_wo_nds`), 0, `ssp_mobile_rtb_block_cpm_partner_wo_nds`) + if(isNaN(`ssp_mobile_rtb_block_cpmh_partner_wo_nds`), 0, `ssp_mobile_rtb_block_cpmh_partner_wo_nds`) + if(isNaN(`ssp_mobile_rtb_block_cover_ratio`), 0, `ssp_mobile_rtb_block_cover_ratio`) + if(isNaN(`ssp_mobile_rtb_partner_wo_nds`), 0, `ssp_mobile_rtb_partner_wo_nds`) + if(isNaN(`ssp_mobile_rtb_block_rpm_all_wo_nds`), 0, `ssp_mobile_rtb_block_rpm_all_wo_nds`) + if(isNaN(`ssp_mobile_rtb_block_visibility`), 0, `ssp_mobile_rtb_block_visibility`) + if(isNaN(`ssp_mobile_rtb_block_shows`), 0, `ssp_mobile_rtb_block_shows`) + if(isNaN(`ssp_mobile_rtb_block_cpmh_all_wo_nds`), 0, `ssp_mobile_rtb_block_cpmh_all_wo_nds`) + if(isNaN(`ssp_mobile_rtb_block_hits_unsold`), 0, `ssp_mobile_rtb_block_hits_unsold`) + if(isNaN(`ssp_mobile_rtb_block_all_hits`), 0, `ssp_mobile_rtb_block_all_hits`) + if(isNaN(`ssp_mobile_rtb_block_hits_own_adv`), 0, `ssp_mobile_rtb_block_hits_own_adv`) + if(isNaN(`ssp_mobile_rtb_block_rpm_partner_wo_nds`), 0, `ssp_mobile_rtb_block_rpm_partner_wo_nds`)) > 0
) FORMAT JSONCompact
