SELECT
    `_bundle_id` AS `bundle_id`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_dsp_caption` AS `dsp_caption`,
    `_dsp_id_name` AS `dsp_id_name`,
    `_page_id` AS `page_id`,
    `_percent_rtb_bad_win_partner_price_rtb_partner_wo_nds` AS `percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`,
    `_percent_rtb_bad_win_price_rtb_all_wo_nds` AS `percent_rtb_bad_win_price_rtb_all_wo_nds`,
    `_rtb_all_wo_nds` AS `rtb_all_wo_nds`,
    `_rtb_bad_win_partner_price_wo_nds` AS `rtb_bad_win_partner_price_wo_nds`,
    `_rtb_bad_win_price_wo_nds` AS `rtb_bad_win_price_wo_nds`,
    `_rtb_block_all_hits` AS `rtb_block_all_hits`,
    `_rtb_block_bad_shows` AS `rtb_block_bad_shows`,
    `_rtb_block_bad_shows_own_adv` AS `rtb_block_bad_shows_own_adv`,
    `_rtb_block_bad_shows_percent` AS `rtb_block_bad_shows_percent`,
    `_rtb_block_bad_win_hits` AS `rtb_block_bad_win_hits`,
    `_rtb_block_bad_win_hits_own_adv` AS `rtb_block_bad_win_hits_own_adv`,
    `_rtb_block_bad_win_hits_percent` AS `rtb_block_bad_win_hits_percent`,
    `_rtb_block_bad_win_hits_unsold` AS `rtb_block_bad_win_hits_unsold`,
    `_rtb_block_cover_ratio` AS `rtb_block_cover_ratio`,
    `_rtb_block_cpm_all_wo_nds` AS `rtb_block_cpm_all_wo_nds`,
    `_rtb_block_cpm_partner_wo_nds` AS `rtb_block_cpm_partner_wo_nds`,
    `_rtb_block_cpmh_all_wo_nds` AS `rtb_block_cpmh_all_wo_nds`,
    `_rtb_block_cpmh_partner_wo_nds` AS `rtb_block_cpmh_partner_wo_nds`,
    `_rtb_block_direct_clicks` AS `rtb_block_direct_clicks`,
    `_rtb_block_direct_ctr` AS `rtb_block_direct_ctr`,
    `_rtb_block_direct_shows` AS `rtb_block_direct_shows`,
    `_rtb_block_hits` AS `rtb_block_hits`,
    `_rtb_block_hits_own_adv` AS `rtb_block_hits_own_adv`,
    `_rtb_block_hits_unsold` AS `rtb_block_hits_unsold`,
    `_rtb_block_rpm_all_wo_nds` AS `rtb_block_rpm_all_wo_nds`,
    `_rtb_block_rpm_partner_wo_nds` AS `rtb_block_rpm_partner_wo_nds`,
    `_rtb_block_shows` AS `rtb_block_shows`,
    `_rtb_block_shows_own_adv` AS `rtb_block_shows_own_adv`,
    `_rtb_block_visibility` AS `rtb_block_visibility`,
    `_rtb_block_winrate` AS `rtb_block_winrate`,
    `_rtb_partner_wo_nds` AS `rtb_partner_wo_nds`,
    `_seller_name` AS `seller_name`
FROM (
    SELECT
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_bundle_id`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetStringOrDefault('dsps_dict', 'short_caption', toUInt64(`dsp_id`), concat('DSP #', toString(`dsp_id`))) AS `_dsp_caption`,
        `dsp_id` AS `_dsp_id_name`,
        `page_id` AS `_page_id`,
        ((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'ssp_video_an_site_rtb') * 100) / (sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_video_an_site_rtb') + sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'ssp_video_an_site_rtb'))) AS `_percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`,
        ((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'ssp_video_an_site_rtb') * 100) / (sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_video_an_site_rtb') + sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'ssp_video_an_site_rtb'))) AS `_percent_rtb_bad_win_price_rtb_all_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_video_an_site_rtb') / 10000000), 2) AS `_rtb_all_wo_nds`,
        round((sumIf((`bad_win_partner_price_wo_nds` / 1000), `product_id` = 'ssp_video_an_site_rtb') / 10000000), 2) AS `_rtb_bad_win_partner_price_wo_nds`,
        round((sumIf((`bad_win_price_wo_nds` / 1000), `product_id` = 'ssp_video_an_site_rtb') / 10000000), 2) AS `_rtb_bad_win_price_wo_nds`,
        sumIf(`hits`, `product_id` = 'ssp_video_an_site_rtb') AS `_rtb_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'ssp_video_an_site_rtb'
    )) AS `_rtb_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'ssp_video_an_site_rtb'
    )) AS `_rtb_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_video_an_site_rtb'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_video_an_site_rtb'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_video_an_site_rtb'
            )))) AS `_rtb_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'ssp_video_an_site_rtb'
    )) AS `_rtb_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'ssp_video_an_site_rtb'
    )) AS `_rtb_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_video_an_site_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_video_an_site_rtb'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_video_an_site_rtb'
            )))) AS `_rtb_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'ssp_video_an_site_rtb'
    )) AS `_rtb_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_video_an_site_rtb'
            )) * 100) / sumIf(`hits`, `product_id` = 'ssp_video_an_site_rtb')) AS `_rtb_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_video_an_site_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_video_an_site_rtb'
            ))), 2) AS `_rtb_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_video_an_site_rtb') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_video_an_site_rtb'
            ))), 2) AS `_rtb_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_video_an_site_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_video_an_site_rtb'
            ))), 2) AS `_rtb_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_video_an_site_rtb') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_video_an_site_rtb'
            ))), 2) AS `_rtb_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'ssp_video_an_site_rtb'
    )) AS `_rtb_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'ssp_video_an_site_rtb'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'ssp_video_an_site_rtb')) AS `_rtb_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'ssp_video_an_site_rtb') AS `_rtb_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'ssp_video_an_site_rtb'
    )) AS `_rtb_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'ssp_video_an_site_rtb'
    )) AS `_rtb_block_hits_own_adv`,
        sumIf(`hits`, (
        `dsp_id` = 10
        AND `product_id` = 'ssp_video_an_site_rtb'
    )) AS `_rtb_block_hits_unsold`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'ssp_video_an_site_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'ssp_video_an_site_rtb')), 2) AS `_rtb_block_rpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_video_an_site_rtb') / 10000000) * 1000) / sumIf(`hits`, `product_id` = 'ssp_video_an_site_rtb')), 2) AS `_rtb_block_rpm_partner_wo_nds`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'ssp_video_an_site_rtb'
    )) AS `_rtb_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'ssp_video_an_site_rtb'
    )) AS `_rtb_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'ssp_video_an_site_rtb'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'ssp_video_an_site_rtb'
        ))) AS `_rtb_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_video_an_site_rtb'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'ssp_video_an_site_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'ssp_video_an_site_rtb'
            )) + sumIf(`hits`, (
                `dsp_id` = 10
                AND `product_id` = 'ssp_video_an_site_rtb'
            )))) AS `_rtb_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'ssp_video_an_site_rtb') / 10000000), 2) AS `_rtb_partner_wo_nds`,
        dictGetString('sellers_dict', 'name', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_seller_name`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('ssp_video_an_site_rtb')
        AND (
            `page_id` = 'mock__campaign_id'
        )
        AND (
            `page_id` IN ('page_id__from_table__ssp_video_an_site__with_filter__["AND",[["source_id","= ANY",["id__from_table__ssp_application__with_filter__[\\"AND\\",[[\\"bundle_id\\",\\"=\\",\\"mock__page.ssp_source.bundle_id\\"]]]"]]]]')
        )
        AND (
            `page_id` IN ('page_id__from_table__ssp_video_an_site__with_filter__["AND",[["seller_id","=","mock__page.seller_id"]]]')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
        AND `dsp_id` = 'mock__dsp_id_name'
        AND `dsp_id` = 'mock__dsp_caption'
    )
    GROUP BY `_bundle_id`, `_currency_id`, `_date`, `_dsp_caption`, `_dsp_id_name`, `_page_id`, `_seller_name`
) `statistics`
WHERE (
    (if(isNaN(`rtb_block_bad_shows`), 0, `rtb_block_bad_shows`) + if(isNaN(`rtb_block_direct_clicks`), 0, `rtb_block_direct_clicks`) + if(isNaN(`rtb_bad_win_price_wo_nds`), 0, `rtb_bad_win_price_wo_nds`) + if(isNaN(`rtb_block_winrate`), 0, `rtb_block_winrate`) + if(isNaN(`rtb_block_cpmh_partner_wo_nds`), 0, `rtb_block_cpmh_partner_wo_nds`) + if(isNaN(`rtb_block_hits`), 0, `rtb_block_hits`) + if(isNaN(`rtb_block_bad_win_hits`), 0, `rtb_block_bad_win_hits`) + if(isNaN(`rtb_block_hits_unsold`), 0, `rtb_block_hits_unsold`) + if(isNaN(`rtb_block_bad_win_hits_unsold`), 0, `rtb_block_bad_win_hits_unsold`) + if(isNaN(`rtb_block_hits_own_adv`), 0, `rtb_block_hits_own_adv`) + if(isNaN(`rtb_block_direct_ctr`), 0, `rtb_block_direct_ctr`) + if(isNaN(`percent_rtb_bad_win_price_rtb_all_wo_nds`), 0, `percent_rtb_bad_win_price_rtb_all_wo_nds`) + if(isNaN(`rtb_block_shows`), 0, `rtb_block_shows`) + if(isNaN(`rtb_block_bad_shows_percent`), 0, `rtb_block_bad_shows_percent`) + if(isNaN(`rtb_block_direct_shows`), 0, `rtb_block_direct_shows`) + if(isNaN(`rtb_block_all_hits`), 0, `rtb_block_all_hits`) + if(isNaN(`rtb_block_cover_ratio`), 0, `rtb_block_cover_ratio`) + if(isNaN(`rtb_partner_wo_nds`), 0, `rtb_partner_wo_nds`) + if(isNaN(`rtb_all_wo_nds`), 0, `rtb_all_wo_nds`) + if(isNaN(`rtb_block_shows_own_adv`), 0, `rtb_block_shows_own_adv`) + if(isNaN(`rtb_block_bad_win_hits_percent`), 0, `rtb_block_bad_win_hits_percent`) + if(isNaN(`rtb_block_rpm_partner_wo_nds`), 0, `rtb_block_rpm_partner_wo_nds`) + if(isNaN(`rtb_block_bad_shows_own_adv`), 0, `rtb_block_bad_shows_own_adv`) + if(isNaN(`rtb_block_bad_win_hits_own_adv`), 0, `rtb_block_bad_win_hits_own_adv`) + if(isNaN(`rtb_block_cpmh_all_wo_nds`), 0, `rtb_block_cpmh_all_wo_nds`) + if(isNaN(`rtb_block_cpm_partner_wo_nds`), 0, `rtb_block_cpm_partner_wo_nds`) + if(isNaN(`rtb_bad_win_partner_price_wo_nds`), 0, `rtb_bad_win_partner_price_wo_nds`) + if(isNaN(`rtb_block_cpm_all_wo_nds`), 0, `rtb_block_cpm_all_wo_nds`) + if(isNaN(`rtb_block_visibility`), 0, `rtb_block_visibility`) + if(isNaN(`rtb_block_rpm_all_wo_nds`), 0, `rtb_block_rpm_all_wo_nds`) + if(isNaN(`percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`), 0, `percent_rtb_bad_win_partner_price_rtb_partner_wo_nds`)) > 0
) FORMAT JSONCompact
