SELECT
    `_adfox_block` AS `adfox_block`,
    `_all_wo_nds` AS `all_wo_nds`,
    `_caption` AS `caption`,
    `_categories` AS `categories`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_domain` AS `domain`,
    `_fullscreen_all_wo_nds` AS `fullscreen_all_wo_nds`,
    `_fullscreen_block_all_hits` AS `fullscreen_block_all_hits`,
    `_fullscreen_block_bad_shows` AS `fullscreen_block_bad_shows`,
    `_fullscreen_block_bad_shows_own_adv` AS `fullscreen_block_bad_shows_own_adv`,
    `_fullscreen_block_bad_shows_percent` AS `fullscreen_block_bad_shows_percent`,
    `_fullscreen_block_bad_win_hits` AS `fullscreen_block_bad_win_hits`,
    `_fullscreen_block_bad_win_hits_own_adv` AS `fullscreen_block_bad_win_hits_own_adv`,
    `_fullscreen_block_bad_win_hits_percent` AS `fullscreen_block_bad_win_hits_percent`,
    `_fullscreen_block_bad_win_hits_unsold` AS `fullscreen_block_bad_win_hits_unsold`,
    `_fullscreen_block_cover_ratio` AS `fullscreen_block_cover_ratio`,
    `_fullscreen_block_cpm_all_wo_nds` AS `fullscreen_block_cpm_all_wo_nds`,
    `_fullscreen_block_cpm_partner_wo_nds` AS `fullscreen_block_cpm_partner_wo_nds`,
    `_fullscreen_block_cpmh_all_wo_nds` AS `fullscreen_block_cpmh_all_wo_nds`,
    `_fullscreen_block_cpmh_partner_wo_nds` AS `fullscreen_block_cpmh_partner_wo_nds`,
    `_fullscreen_block_direct_clicks` AS `fullscreen_block_direct_clicks`,
    `_fullscreen_block_direct_ctr` AS `fullscreen_block_direct_ctr`,
    `_fullscreen_block_direct_shows` AS `fullscreen_block_direct_shows`,
    `_fullscreen_block_hits` AS `fullscreen_block_hits`,
    `_fullscreen_block_hits_own_adv` AS `fullscreen_block_hits_own_adv`,
    `_fullscreen_block_hits_unsold` AS `fullscreen_block_hits_unsold`,
    `_fullscreen_block_shows` AS `fullscreen_block_shows`,
    `_fullscreen_block_shows_own_adv` AS `fullscreen_block_shows_own_adv`,
    `_fullscreen_block_visibility` AS `fullscreen_block_visibility`,
    `_fullscreen_block_winrate` AS `fullscreen_block_winrate`,
    `_fullscreen_partner_wo_nds` AS `fullscreen_partner_wo_nds`,
    `_id` AS `id`,
    `_inpage_all_wo_nds` AS `inpage_all_wo_nds`,
    `_inpage_block_all_hits` AS `inpage_block_all_hits`,
    `_inpage_block_bad_shows` AS `inpage_block_bad_shows`,
    `_inpage_block_bad_shows_own_adv` AS `inpage_block_bad_shows_own_adv`,
    `_inpage_block_bad_shows_percent` AS `inpage_block_bad_shows_percent`,
    `_inpage_block_bad_win_hits` AS `inpage_block_bad_win_hits`,
    `_inpage_block_bad_win_hits_own_adv` AS `inpage_block_bad_win_hits_own_adv`,
    `_inpage_block_bad_win_hits_percent` AS `inpage_block_bad_win_hits_percent`,
    `_inpage_block_bad_win_hits_unsold` AS `inpage_block_bad_win_hits_unsold`,
    `_inpage_block_cover_ratio` AS `inpage_block_cover_ratio`,
    `_inpage_block_cpm_all_wo_nds` AS `inpage_block_cpm_all_wo_nds`,
    `_inpage_block_cpm_partner_wo_nds` AS `inpage_block_cpm_partner_wo_nds`,
    `_inpage_block_cpmh_all_wo_nds` AS `inpage_block_cpmh_all_wo_nds`,
    `_inpage_block_cpmh_partner_wo_nds` AS `inpage_block_cpmh_partner_wo_nds`,
    `_inpage_block_direct_clicks` AS `inpage_block_direct_clicks`,
    `_inpage_block_direct_ctr` AS `inpage_block_direct_ctr`,
    `_inpage_block_direct_shows` AS `inpage_block_direct_shows`,
    `_inpage_block_hits` AS `inpage_block_hits`,
    `_inpage_block_hits_own_adv` AS `inpage_block_hits_own_adv`,
    `_inpage_block_hits_unsold` AS `inpage_block_hits_unsold`,
    `_inpage_block_shows` AS `inpage_block_shows`,
    `_inpage_block_shows_own_adv` AS `inpage_block_shows_own_adv`,
    `_inpage_block_visibility` AS `inpage_block_visibility`,
    `_inpage_block_winrate` AS `inpage_block_winrate`,
    `_inpage_partner_wo_nds` AS `inpage_partner_wo_nds`,
    `_instream_all_wo_nds` AS `instream_all_wo_nds`,
    `_instream_block_all_hits` AS `instream_block_all_hits`,
    `_instream_block_bad_shows` AS `instream_block_bad_shows`,
    `_instream_block_bad_shows_own_adv` AS `instream_block_bad_shows_own_adv`,
    `_instream_block_bad_shows_percent` AS `instream_block_bad_shows_percent`,
    `_instream_block_bad_win_hits` AS `instream_block_bad_win_hits`,
    `_instream_block_bad_win_hits_own_adv` AS `instream_block_bad_win_hits_own_adv`,
    `_instream_block_bad_win_hits_percent` AS `instream_block_bad_win_hits_percent`,
    `_instream_block_bad_win_hits_unsold` AS `instream_block_bad_win_hits_unsold`,
    `_instream_block_cover_ratio` AS `instream_block_cover_ratio`,
    `_instream_block_cpm_all_wo_nds` AS `instream_block_cpm_all_wo_nds`,
    `_instream_block_cpm_partner_wo_nds` AS `instream_block_cpm_partner_wo_nds`,
    `_instream_block_cpmh_all_wo_nds` AS `instream_block_cpmh_all_wo_nds`,
    `_instream_block_cpmh_partner_wo_nds` AS `instream_block_cpmh_partner_wo_nds`,
    `_instream_block_direct_clicks` AS `instream_block_direct_clicks`,
    `_instream_block_direct_ctr` AS `instream_block_direct_ctr`,
    `_instream_block_direct_shows` AS `instream_block_direct_shows`,
    `_instream_block_hits` AS `instream_block_hits`,
    `_instream_block_hits_own_adv` AS `instream_block_hits_own_adv`,
    `_instream_block_hits_unsold` AS `instream_block_hits_unsold`,
    `_instream_block_shows` AS `instream_block_shows`,
    `_instream_block_shows_own_adv` AS `instream_block_shows_own_adv`,
    `_instream_block_visibility` AS `instream_block_visibility`,
    `_instream_block_winrate` AS `instream_block_winrate`,
    `_instream_partner_wo_nds` AS `instream_partner_wo_nds`,
    `_login` AS `login`,
    `_partner_wo_nds` AS `partner_wo_nds`
FROM (
    SELECT
        dictGetUInt8('blocks_dict', 'adfox_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_adfox_block`,
        round((SUM((`all_wo_nds` / 1000)) / 10000000), 2) AS `_all_wo_nds`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_caption`,
        dictGetStringOrDefault('video_categories_dict', 'name_ru', tuple(if(`product_id` = 'video_an_site', `category_id`, dictGetUInt32('blocks_dict', 'category_id', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`)))), `page_id`), toString(if(`product_id` = 'video_an_site', `category_id`, dictGetUInt32('blocks_dict', 'category_id', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`)))))) AS `_categories`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000), 2) AS `_fullscreen_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen') AS `_fullscreen_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )))) AS `_fullscreen_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )))) AS `_fullscreen_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen')) AS `_fullscreen_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'video_an_site_fullscreen')) AS `_fullscreen_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'video_an_site_fullscreen') AS `_fullscreen_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_fullscreen'
            )))) AS `_fullscreen_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_fullscreen'
        ))) AS `_fullscreen_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'video_an_site_fullscreen'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'video_an_site_fullscreen'
                    )))))) AS `_fullscreen_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000), 2) AS `_fullscreen_partner_wo_nds`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_id`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000), 2) AS `_inpage_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage') AS `_inpage_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )))) AS `_inpage_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )))) AS `_inpage_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage')) AS `_inpage_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'video_an_site_inpage')) AS `_inpage_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'video_an_site_inpage') AS `_inpage_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_inpage'
            )))) AS `_inpage_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_inpage'
        ))) AS `_inpage_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_inpage'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'video_an_site_inpage'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'video_an_site_inpage'
                    )))))) AS `_inpage_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000), 2) AS `_inpage_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000), 2) AS `_instream_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') AS `_instream_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )))) AS `_instream_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )))) AS `_instream_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream')) AS `_instream_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'video_an_site_instream')) AS `_instream_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'video_an_site_instream') AS `_instream_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_instream'
            )))) AS `_instream_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_instream'
        ))) AS `_instream_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_instream'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'video_an_site_instream'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'video_an_site_instream'
                    )))))) AS `_instream_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000), 2) AS `_instream_partner_wo_nds`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        round((SUM((`partner_wo_nds` / 1000)) / 10000000), 2) AS `_partner_wo_nds`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('video_an_site_instream', 'video_an_site_inpage', 'video_an_site_fullscreen')
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["AND",[["login","=","mock__owner-login"]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["OR",[["is_efir_blogger","=",1],["is_video_blogger","=",1],["is_tutby","=",1],["is_adfox_partner","=",1],["is_mobile_mediation","=",1],["is_games","=",1]]]')
        )
        AND (
            dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) = 'mock__id'
        )
        AND (
            dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) = 'mock__domain'
        )
        AND (
            dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) = 'mock__caption'
        )
        AND (
            dictGetUInt64('pages_dict', 'multistate', toUInt64(`page_id`)) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
        AND (
            dictGetUInt8('blocks_dict', 'adfox_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 1
        )
        AND if(`product_id` = 'video_an_site', `category_id`, dictGetUInt32('blocks_dict', 'category_id', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`)))) = 'mock__categories'
    )
    GROUP BY `_adfox_block`, `_caption`, `_categories`, `_currency_id`, `_date`, `_domain`, `_id`, `_login`
) `statistics`
WHERE (
    (if(isNaN(`inpage_block_cover_ratio`), 0, `inpage_block_cover_ratio`) + if(isNaN(`fullscreen_block_bad_shows_own_adv`), 0, `fullscreen_block_bad_shows_own_adv`) + if(isNaN(`fullscreen_block_cover_ratio`), 0, `fullscreen_block_cover_ratio`) + if(isNaN(`fullscreen_block_bad_shows_percent`), 0, `fullscreen_block_bad_shows_percent`) + if(isNaN(`fullscreen_block_direct_clicks`), 0, `fullscreen_block_direct_clicks`) + if(isNaN(`fullscreen_block_shows`), 0, `fullscreen_block_shows`) + if(isNaN(`instream_block_bad_shows_percent`), 0, `instream_block_bad_shows_percent`) + if(isNaN(`inpage_block_bad_win_hits_unsold`), 0, `inpage_block_bad_win_hits_unsold`) + if(isNaN(`instream_block_hits_unsold`), 0, `instream_block_hits_unsold`) + if(isNaN(`fullscreen_block_bad_shows`), 0, `fullscreen_block_bad_shows`) + if(isNaN(`fullscreen_block_shows_own_adv`), 0, `fullscreen_block_shows_own_adv`) + if(isNaN(`inpage_block_cpmh_partner_wo_nds`), 0, `inpage_block_cpmh_partner_wo_nds`) + if(isNaN(`inpage_partner_wo_nds`), 0, `inpage_partner_wo_nds`) + if(isNaN(`inpage_block_bad_win_hits_percent`), 0, `inpage_block_bad_win_hits_percent`) + if(isNaN(`instream_block_cpm_all_wo_nds`), 0, `instream_block_cpm_all_wo_nds`) + if(isNaN(`inpage_block_bad_shows`), 0, `inpage_block_bad_shows`) + if(isNaN(`instream_block_direct_clicks`), 0, `instream_block_direct_clicks`) + if(isNaN(`inpage_block_shows_own_adv`), 0, `inpage_block_shows_own_adv`) + if(isNaN(`fullscreen_block_direct_shows`), 0, `fullscreen_block_direct_shows`) + if(isNaN(`inpage_block_bad_shows_own_adv`), 0, `inpage_block_bad_shows_own_adv`) + if(isNaN(`instream_block_visibility`), 0, `instream_block_visibility`) + if(isNaN(`fullscreen_block_hits`), 0, `fullscreen_block_hits`) + if(isNaN(`fullscreen_block_bad_win_hits_own_adv`), 0, `fullscreen_block_bad_win_hits_own_adv`) + if(isNaN(`fullscreen_block_cpmh_partner_wo_nds`), 0, `fullscreen_block_cpmh_partner_wo_nds`) + if(isNaN(`all_wo_nds`), 0, `all_wo_nds`) + if(isNaN(`instream_block_bad_win_hits_percent`), 0, `instream_block_bad_win_hits_percent`) + if(isNaN(`inpage_block_hits_own_adv`), 0, `inpage_block_hits_own_adv`) + if(isNaN(`inpage_block_direct_shows`), 0, `inpage_block_direct_shows`) + if(isNaN(`inpage_block_cpm_all_wo_nds`), 0, `inpage_block_cpm_all_wo_nds`) + if(isNaN(`fullscreen_block_hits_own_adv`), 0, `fullscreen_block_hits_own_adv`) + if(isNaN(`inpage_block_direct_clicks`), 0, `inpage_block_direct_clicks`) + if(isNaN(`inpage_block_cpm_partner_wo_nds`), 0, `inpage_block_cpm_partner_wo_nds`) + if(isNaN(`inpage_block_shows`), 0, `inpage_block_shows`) + if(isNaN(`fullscreen_all_wo_nds`), 0, `fullscreen_all_wo_nds`) + if(isNaN(`instream_block_cpmh_partner_wo_nds`), 0, `instream_block_cpmh_partner_wo_nds`) + if(isNaN(`inpage_block_hits`), 0, `inpage_block_hits`) + if(isNaN(`instream_block_hits`), 0, `instream_block_hits`) + if(isNaN(`inpage_block_bad_win_hits`), 0, `inpage_block_bad_win_hits`) + if(isNaN(`inpage_block_winrate`), 0, `inpage_block_winrate`) + if(isNaN(`instream_block_direct_ctr`), 0, `instream_block_direct_ctr`) + if(isNaN(`fullscreen_block_bad_win_hits_unsold`), 0, `fullscreen_block_bad_win_hits_unsold`) + if(isNaN(`instream_block_shows`), 0, `instream_block_shows`) + if(isNaN(`inpage_block_cpmh_all_wo_nds`), 0, `inpage_block_cpmh_all_wo_nds`) + if(isNaN(`inpage_block_all_hits`), 0, `inpage_block_all_hits`) + if(isNaN(`instream_block_bad_win_hits_own_adv`), 0, `instream_block_bad_win_hits_own_adv`) + if(isNaN(`fullscreen_block_winrate`), 0, `fullscreen_block_winrate`) + if(isNaN(`fullscreen_block_bad_win_hits`), 0, `fullscreen_block_bad_win_hits`) + if(isNaN(`fullscreen_block_cpm_all_wo_nds`), 0, `fullscreen_block_cpm_all_wo_nds`) + if(isNaN(`instream_block_winrate`), 0, `instream_block_winrate`) + if(isNaN(`inpage_all_wo_nds`), 0, `inpage_all_wo_nds`) + if(isNaN(`instream_block_shows_own_adv`), 0, `instream_block_shows_own_adv`) + if(isNaN(`instream_block_bad_win_hits_unsold`), 0, `instream_block_bad_win_hits_unsold`) + if(isNaN(`partner_wo_nds`), 0, `partner_wo_nds`) + if(isNaN(`fullscreen_block_bad_win_hits_percent`), 0, `fullscreen_block_bad_win_hits_percent`) + if(isNaN(`instream_block_all_hits`), 0, `instream_block_all_hits`) + if(isNaN(`instream_block_cpm_partner_wo_nds`), 0, `instream_block_cpm_partner_wo_nds`) + if(isNaN(`instream_block_hits_own_adv`), 0, `instream_block_hits_own_adv`) + if(isNaN(`instream_block_bad_win_hits`), 0, `instream_block_bad_win_hits`) + if(isNaN(`fullscreen_block_visibility`), 0, `fullscreen_block_visibility`) + if(isNaN(`instream_block_bad_shows_own_adv`), 0, `instream_block_bad_shows_own_adv`) + if(isNaN(`fullscreen_partner_wo_nds`), 0, `fullscreen_partner_wo_nds`) + if(isNaN(`inpage_block_hits_unsold`), 0, `inpage_block_hits_unsold`) + if(isNaN(`fullscreen_block_all_hits`), 0, `fullscreen_block_all_hits`) + if(isNaN(`inpage_block_bad_shows_percent`), 0, `inpage_block_bad_shows_percent`) + if(isNaN(`instream_block_cpmh_all_wo_nds`), 0, `instream_block_cpmh_all_wo_nds`) + if(isNaN(`fullscreen_block_direct_ctr`), 0, `fullscreen_block_direct_ctr`) + if(isNaN(`instream_all_wo_nds`), 0, `instream_all_wo_nds`) + if(isNaN(`instream_partner_wo_nds`), 0, `instream_partner_wo_nds`) + if(isNaN(`instream_block_direct_shows`), 0, `instream_block_direct_shows`) + if(isNaN(`fullscreen_block_cpmh_all_wo_nds`), 0, `fullscreen_block_cpmh_all_wo_nds`) + if(isNaN(`instream_block_cover_ratio`), 0, `instream_block_cover_ratio`) + if(isNaN(`inpage_block_direct_ctr`), 0, `inpage_block_direct_ctr`) + if(isNaN(`inpage_block_visibility`), 0, `inpage_block_visibility`) + if(isNaN(`fullscreen_block_hits_unsold`), 0, `fullscreen_block_hits_unsold`) + if(isNaN(`instream_block_bad_shows`), 0, `instream_block_bad_shows`) + if(isNaN(`inpage_block_bad_win_hits_own_adv`), 0, `inpage_block_bad_win_hits_own_adv`) + if(isNaN(`fullscreen_block_cpm_partner_wo_nds`), 0, `fullscreen_block_cpm_partner_wo_nds`)) > 0
) FORMAT JSONCompact

SELECT
    `_adfox_block` AS `adfox_block`,
    `_all_wo_nds` AS `all_wo_nds`,
    `_caption` AS `caption`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_domain` AS `domain`,
    `_fullscreen_all_wo_nds` AS `fullscreen_all_wo_nds`,
    `_fullscreen_block_all_hits` AS `fullscreen_block_all_hits`,
    `_fullscreen_block_bad_shows` AS `fullscreen_block_bad_shows`,
    `_fullscreen_block_bad_shows_own_adv` AS `fullscreen_block_bad_shows_own_adv`,
    `_fullscreen_block_bad_shows_percent` AS `fullscreen_block_bad_shows_percent`,
    `_fullscreen_block_bad_win_hits` AS `fullscreen_block_bad_win_hits`,
    `_fullscreen_block_bad_win_hits_own_adv` AS `fullscreen_block_bad_win_hits_own_adv`,
    `_fullscreen_block_bad_win_hits_percent` AS `fullscreen_block_bad_win_hits_percent`,
    `_fullscreen_block_bad_win_hits_unsold` AS `fullscreen_block_bad_win_hits_unsold`,
    `_fullscreen_block_cover_ratio` AS `fullscreen_block_cover_ratio`,
    `_fullscreen_block_cpm_all_wo_nds` AS `fullscreen_block_cpm_all_wo_nds`,
    `_fullscreen_block_cpm_partner_wo_nds` AS `fullscreen_block_cpm_partner_wo_nds`,
    `_fullscreen_block_cpmh_all_wo_nds` AS `fullscreen_block_cpmh_all_wo_nds`,
    `_fullscreen_block_cpmh_partner_wo_nds` AS `fullscreen_block_cpmh_partner_wo_nds`,
    `_fullscreen_block_direct_clicks` AS `fullscreen_block_direct_clicks`,
    `_fullscreen_block_direct_ctr` AS `fullscreen_block_direct_ctr`,
    `_fullscreen_block_direct_shows` AS `fullscreen_block_direct_shows`,
    `_fullscreen_block_hits` AS `fullscreen_block_hits`,
    `_fullscreen_block_hits_own_adv` AS `fullscreen_block_hits_own_adv`,
    `_fullscreen_block_hits_unsold` AS `fullscreen_block_hits_unsold`,
    `_fullscreen_block_shows` AS `fullscreen_block_shows`,
    `_fullscreen_block_shows_own_adv` AS `fullscreen_block_shows_own_adv`,
    `_fullscreen_block_visibility` AS `fullscreen_block_visibility`,
    `_fullscreen_block_winrate` AS `fullscreen_block_winrate`,
    `_fullscreen_partner_wo_nds` AS `fullscreen_partner_wo_nds`,
    `_id` AS `id`,
    `_inpage_all_wo_nds` AS `inpage_all_wo_nds`,
    `_inpage_block_all_hits` AS `inpage_block_all_hits`,
    `_inpage_block_bad_shows` AS `inpage_block_bad_shows`,
    `_inpage_block_bad_shows_own_adv` AS `inpage_block_bad_shows_own_adv`,
    `_inpage_block_bad_shows_percent` AS `inpage_block_bad_shows_percent`,
    `_inpage_block_bad_win_hits` AS `inpage_block_bad_win_hits`,
    `_inpage_block_bad_win_hits_own_adv` AS `inpage_block_bad_win_hits_own_adv`,
    `_inpage_block_bad_win_hits_percent` AS `inpage_block_bad_win_hits_percent`,
    `_inpage_block_bad_win_hits_unsold` AS `inpage_block_bad_win_hits_unsold`,
    `_inpage_block_cover_ratio` AS `inpage_block_cover_ratio`,
    `_inpage_block_cpm_all_wo_nds` AS `inpage_block_cpm_all_wo_nds`,
    `_inpage_block_cpm_partner_wo_nds` AS `inpage_block_cpm_partner_wo_nds`,
    `_inpage_block_cpmh_all_wo_nds` AS `inpage_block_cpmh_all_wo_nds`,
    `_inpage_block_cpmh_partner_wo_nds` AS `inpage_block_cpmh_partner_wo_nds`,
    `_inpage_block_direct_clicks` AS `inpage_block_direct_clicks`,
    `_inpage_block_direct_ctr` AS `inpage_block_direct_ctr`,
    `_inpage_block_direct_shows` AS `inpage_block_direct_shows`,
    `_inpage_block_hits` AS `inpage_block_hits`,
    `_inpage_block_hits_own_adv` AS `inpage_block_hits_own_adv`,
    `_inpage_block_hits_unsold` AS `inpage_block_hits_unsold`,
    `_inpage_block_shows` AS `inpage_block_shows`,
    `_inpage_block_shows_own_adv` AS `inpage_block_shows_own_adv`,
    `_inpage_block_visibility` AS `inpage_block_visibility`,
    `_inpage_block_winrate` AS `inpage_block_winrate`,
    `_inpage_partner_wo_nds` AS `inpage_partner_wo_nds`,
    `_instream_all_wo_nds` AS `instream_all_wo_nds`,
    `_instream_block_all_hits` AS `instream_block_all_hits`,
    `_instream_block_bad_shows` AS `instream_block_bad_shows`,
    `_instream_block_bad_shows_own_adv` AS `instream_block_bad_shows_own_adv`,
    `_instream_block_bad_shows_percent` AS `instream_block_bad_shows_percent`,
    `_instream_block_bad_win_hits` AS `instream_block_bad_win_hits`,
    `_instream_block_bad_win_hits_own_adv` AS `instream_block_bad_win_hits_own_adv`,
    `_instream_block_bad_win_hits_percent` AS `instream_block_bad_win_hits_percent`,
    `_instream_block_bad_win_hits_unsold` AS `instream_block_bad_win_hits_unsold`,
    `_instream_block_cover_ratio` AS `instream_block_cover_ratio`,
    `_instream_block_cpm_all_wo_nds` AS `instream_block_cpm_all_wo_nds`,
    `_instream_block_cpm_partner_wo_nds` AS `instream_block_cpm_partner_wo_nds`,
    `_instream_block_cpmh_all_wo_nds` AS `instream_block_cpmh_all_wo_nds`,
    `_instream_block_cpmh_partner_wo_nds` AS `instream_block_cpmh_partner_wo_nds`,
    `_instream_block_direct_clicks` AS `instream_block_direct_clicks`,
    `_instream_block_direct_ctr` AS `instream_block_direct_ctr`,
    `_instream_block_direct_shows` AS `instream_block_direct_shows`,
    `_instream_block_hits` AS `instream_block_hits`,
    `_instream_block_hits_own_adv` AS `instream_block_hits_own_adv`,
    `_instream_block_hits_unsold` AS `instream_block_hits_unsold`,
    `_instream_block_shows` AS `instream_block_shows`,
    `_instream_block_shows_own_adv` AS `instream_block_shows_own_adv`,
    `_instream_block_visibility` AS `instream_block_visibility`,
    `_instream_block_winrate` AS `instream_block_winrate`,
    `_instream_partner_wo_nds` AS `instream_partner_wo_nds`,
    `_login` AS `login`,
    `_partner_wo_nds` AS `partner_wo_nds`,
    `_public_id` AS `public_id`
FROM (
    SELECT
        dictGetUInt8('blocks_dict', 'adfox_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_adfox_block`,
        round((SUM((`all_wo_nds` / 1000)) / 10000000), 2) AS `_all_wo_nds`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_caption`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000), 2) AS `_fullscreen_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen') AS `_fullscreen_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )))) AS `_fullscreen_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )))) AS `_fullscreen_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen')) AS `_fullscreen_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'video_an_site_fullscreen')) AS `_fullscreen_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'video_an_site_fullscreen') AS `_fullscreen_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_fullscreen'
            )))) AS `_fullscreen_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_fullscreen'
        ))) AS `_fullscreen_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'video_an_site_fullscreen'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'video_an_site_fullscreen'
                    )))))) AS `_fullscreen_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000), 2) AS `_fullscreen_partner_wo_nds`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_id`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000), 2) AS `_inpage_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage') AS `_inpage_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )))) AS `_inpage_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )))) AS `_inpage_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage')) AS `_inpage_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'video_an_site_inpage')) AS `_inpage_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'video_an_site_inpage') AS `_inpage_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_inpage'
            )))) AS `_inpage_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_inpage'
        ))) AS `_inpage_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_inpage'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'video_an_site_inpage'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'video_an_site_inpage'
                    )))))) AS `_inpage_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000), 2) AS `_inpage_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000), 2) AS `_instream_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') AS `_instream_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )))) AS `_instream_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )))) AS `_instream_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream')) AS `_instream_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'video_an_site_instream')) AS `_instream_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'video_an_site_instream') AS `_instream_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_instream'
            )))) AS `_instream_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_instream'
        ))) AS `_instream_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_instream'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'video_an_site_instream'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'video_an_site_instream'
                    )))))) AS `_instream_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000), 2) AS `_instream_partner_wo_nds`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        round((SUM((`partner_wo_nds` / 1000)) / 10000000), 2) AS `_partner_wo_nds`,
        concat(transform(toString(`product_id`), ['video_an_site_fullscreen', 'video_an_site_inpage', 'video_an_site_instream'], ['R-VF-', 'R-VI-', 'R-V-']), toString(`page_id`), '-', toString(`block_id`)) AS `_public_id`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('video_an_site_instream', 'video_an_site_inpage', 'video_an_site_fullscreen')
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["AND",[["login","=","mock__owner-login"]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["OR",[["is_efir_blogger","=",1],["is_video_blogger","=",1],["is_tutby","=",1],["is_adfox_partner","=",1],["is_mobile_mediation","=",1],["is_games","=",1]]]')
        )
        AND (
            dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) = 'mock__id'
        )
        AND (
            dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) = 'mock__domain'
        )
        AND (
            dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) = 'mock__caption'
        )
        AND (
            dictGetUInt64('pages_dict', 'multistate', toUInt64(`page_id`)) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
        AND (
            dictGetUInt8('blocks_dict', 'adfox_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 1
        )
    )
    GROUP BY `_adfox_block`, `_caption`, `_currency_id`, `_date`, `_domain`, `_id`, `_login`, `_public_id`
) `statistics`
WHERE (
    (if(isNaN(`inpage_block_cover_ratio`), 0, `inpage_block_cover_ratio`) + if(isNaN(`fullscreen_block_bad_shows_own_adv`), 0, `fullscreen_block_bad_shows_own_adv`) + if(isNaN(`fullscreen_block_cover_ratio`), 0, `fullscreen_block_cover_ratio`) + if(isNaN(`fullscreen_block_bad_shows_percent`), 0, `fullscreen_block_bad_shows_percent`) + if(isNaN(`fullscreen_block_direct_clicks`), 0, `fullscreen_block_direct_clicks`) + if(isNaN(`fullscreen_block_shows`), 0, `fullscreen_block_shows`) + if(isNaN(`instream_block_bad_shows_percent`), 0, `instream_block_bad_shows_percent`) + if(isNaN(`inpage_block_bad_win_hits_unsold`), 0, `inpage_block_bad_win_hits_unsold`) + if(isNaN(`instream_block_hits_unsold`), 0, `instream_block_hits_unsold`) + if(isNaN(`fullscreen_block_bad_shows`), 0, `fullscreen_block_bad_shows`) + if(isNaN(`fullscreen_block_shows_own_adv`), 0, `fullscreen_block_shows_own_adv`) + if(isNaN(`inpage_block_cpmh_partner_wo_nds`), 0, `inpage_block_cpmh_partner_wo_nds`) + if(isNaN(`inpage_partner_wo_nds`), 0, `inpage_partner_wo_nds`) + if(isNaN(`inpage_block_bad_win_hits_percent`), 0, `inpage_block_bad_win_hits_percent`) + if(isNaN(`instream_block_cpm_all_wo_nds`), 0, `instream_block_cpm_all_wo_nds`) + if(isNaN(`inpage_block_bad_shows`), 0, `inpage_block_bad_shows`) + if(isNaN(`instream_block_direct_clicks`), 0, `instream_block_direct_clicks`) + if(isNaN(`inpage_block_shows_own_adv`), 0, `inpage_block_shows_own_adv`) + if(isNaN(`fullscreen_block_direct_shows`), 0, `fullscreen_block_direct_shows`) + if(isNaN(`inpage_block_bad_shows_own_adv`), 0, `inpage_block_bad_shows_own_adv`) + if(isNaN(`instream_block_visibility`), 0, `instream_block_visibility`) + if(isNaN(`fullscreen_block_hits`), 0, `fullscreen_block_hits`) + if(isNaN(`fullscreen_block_bad_win_hits_own_adv`), 0, `fullscreen_block_bad_win_hits_own_adv`) + if(isNaN(`fullscreen_block_cpmh_partner_wo_nds`), 0, `fullscreen_block_cpmh_partner_wo_nds`) + if(isNaN(`all_wo_nds`), 0, `all_wo_nds`) + if(isNaN(`instream_block_bad_win_hits_percent`), 0, `instream_block_bad_win_hits_percent`) + if(isNaN(`inpage_block_hits_own_adv`), 0, `inpage_block_hits_own_adv`) + if(isNaN(`inpage_block_direct_shows`), 0, `inpage_block_direct_shows`) + if(isNaN(`inpage_block_cpm_all_wo_nds`), 0, `inpage_block_cpm_all_wo_nds`) + if(isNaN(`fullscreen_block_hits_own_adv`), 0, `fullscreen_block_hits_own_adv`) + if(isNaN(`inpage_block_direct_clicks`), 0, `inpage_block_direct_clicks`) + if(isNaN(`inpage_block_cpm_partner_wo_nds`), 0, `inpage_block_cpm_partner_wo_nds`) + if(isNaN(`inpage_block_shows`), 0, `inpage_block_shows`) + if(isNaN(`fullscreen_all_wo_nds`), 0, `fullscreen_all_wo_nds`) + if(isNaN(`instream_block_cpmh_partner_wo_nds`), 0, `instream_block_cpmh_partner_wo_nds`) + if(isNaN(`inpage_block_hits`), 0, `inpage_block_hits`) + if(isNaN(`instream_block_hits`), 0, `instream_block_hits`) + if(isNaN(`inpage_block_bad_win_hits`), 0, `inpage_block_bad_win_hits`) + if(isNaN(`inpage_block_winrate`), 0, `inpage_block_winrate`) + if(isNaN(`instream_block_direct_ctr`), 0, `instream_block_direct_ctr`) + if(isNaN(`fullscreen_block_bad_win_hits_unsold`), 0, `fullscreen_block_bad_win_hits_unsold`) + if(isNaN(`instream_block_shows`), 0, `instream_block_shows`) + if(isNaN(`inpage_block_cpmh_all_wo_nds`), 0, `inpage_block_cpmh_all_wo_nds`) + if(isNaN(`inpage_block_all_hits`), 0, `inpage_block_all_hits`) + if(isNaN(`instream_block_bad_win_hits_own_adv`), 0, `instream_block_bad_win_hits_own_adv`) + if(isNaN(`fullscreen_block_winrate`), 0, `fullscreen_block_winrate`) + if(isNaN(`fullscreen_block_bad_win_hits`), 0, `fullscreen_block_bad_win_hits`) + if(isNaN(`fullscreen_block_cpm_all_wo_nds`), 0, `fullscreen_block_cpm_all_wo_nds`) + if(isNaN(`instream_block_winrate`), 0, `instream_block_winrate`) + if(isNaN(`inpage_all_wo_nds`), 0, `inpage_all_wo_nds`) + if(isNaN(`instream_block_shows_own_adv`), 0, `instream_block_shows_own_adv`) + if(isNaN(`instream_block_bad_win_hits_unsold`), 0, `instream_block_bad_win_hits_unsold`) + if(isNaN(`partner_wo_nds`), 0, `partner_wo_nds`) + if(isNaN(`fullscreen_block_bad_win_hits_percent`), 0, `fullscreen_block_bad_win_hits_percent`) + if(isNaN(`instream_block_all_hits`), 0, `instream_block_all_hits`) + if(isNaN(`instream_block_cpm_partner_wo_nds`), 0, `instream_block_cpm_partner_wo_nds`) + if(isNaN(`instream_block_hits_own_adv`), 0, `instream_block_hits_own_adv`) + if(isNaN(`instream_block_bad_win_hits`), 0, `instream_block_bad_win_hits`) + if(isNaN(`fullscreen_block_visibility`), 0, `fullscreen_block_visibility`) + if(isNaN(`instream_block_bad_shows_own_adv`), 0, `instream_block_bad_shows_own_adv`) + if(isNaN(`fullscreen_partner_wo_nds`), 0, `fullscreen_partner_wo_nds`) + if(isNaN(`inpage_block_hits_unsold`), 0, `inpage_block_hits_unsold`) + if(isNaN(`fullscreen_block_all_hits`), 0, `fullscreen_block_all_hits`) + if(isNaN(`inpage_block_bad_shows_percent`), 0, `inpage_block_bad_shows_percent`) + if(isNaN(`instream_block_cpmh_all_wo_nds`), 0, `instream_block_cpmh_all_wo_nds`) + if(isNaN(`fullscreen_block_direct_ctr`), 0, `fullscreen_block_direct_ctr`) + if(isNaN(`instream_all_wo_nds`), 0, `instream_all_wo_nds`) + if(isNaN(`instream_partner_wo_nds`), 0, `instream_partner_wo_nds`) + if(isNaN(`instream_block_direct_shows`), 0, `instream_block_direct_shows`) + if(isNaN(`fullscreen_block_cpmh_all_wo_nds`), 0, `fullscreen_block_cpmh_all_wo_nds`) + if(isNaN(`instream_block_cover_ratio`), 0, `instream_block_cover_ratio`) + if(isNaN(`inpage_block_direct_ctr`), 0, `inpage_block_direct_ctr`) + if(isNaN(`inpage_block_visibility`), 0, `inpage_block_visibility`) + if(isNaN(`fullscreen_block_hits_unsold`), 0, `fullscreen_block_hits_unsold`) + if(isNaN(`instream_block_bad_shows`), 0, `instream_block_bad_shows`) + if(isNaN(`inpage_block_bad_win_hits_own_adv`), 0, `inpage_block_bad_win_hits_own_adv`) + if(isNaN(`fullscreen_block_cpm_partner_wo_nds`), 0, `fullscreen_block_cpm_partner_wo_nds`)) > 0
) FORMAT JSONCompact

SELECT
    `_all_wo_nds` AS `all_wo_nds`,
    `_an_fraud_clicks` AS `an_fraud_clicks`,
    `_an_fraud_shows` AS `an_fraud_shows`,
    `_caption` AS `caption`,
    `_categories` AS `categories`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_domain` AS `domain`,
    `_fullscreen_all_wo_nds` AS `fullscreen_all_wo_nds`,
    `_fullscreen_block_all_hits` AS `fullscreen_block_all_hits`,
    `_fullscreen_block_bad_shows` AS `fullscreen_block_bad_shows`,
    `_fullscreen_block_bad_shows_own_adv` AS `fullscreen_block_bad_shows_own_adv`,
    `_fullscreen_block_bad_shows_percent` AS `fullscreen_block_bad_shows_percent`,
    `_fullscreen_block_bad_win_hits` AS `fullscreen_block_bad_win_hits`,
    `_fullscreen_block_bad_win_hits_own_adv` AS `fullscreen_block_bad_win_hits_own_adv`,
    `_fullscreen_block_bad_win_hits_percent` AS `fullscreen_block_bad_win_hits_percent`,
    `_fullscreen_block_bad_win_hits_unsold` AS `fullscreen_block_bad_win_hits_unsold`,
    `_fullscreen_block_cover_ratio` AS `fullscreen_block_cover_ratio`,
    `_fullscreen_block_cpm_all_wo_nds` AS `fullscreen_block_cpm_all_wo_nds`,
    `_fullscreen_block_cpm_partner_wo_nds` AS `fullscreen_block_cpm_partner_wo_nds`,
    `_fullscreen_block_cpmh_all_wo_nds` AS `fullscreen_block_cpmh_all_wo_nds`,
    `_fullscreen_block_cpmh_partner_wo_nds` AS `fullscreen_block_cpmh_partner_wo_nds`,
    `_fullscreen_block_direct_clicks` AS `fullscreen_block_direct_clicks`,
    `_fullscreen_block_direct_ctr` AS `fullscreen_block_direct_ctr`,
    `_fullscreen_block_direct_shows` AS `fullscreen_block_direct_shows`,
    `_fullscreen_block_hits` AS `fullscreen_block_hits`,
    `_fullscreen_block_hits_own_adv` AS `fullscreen_block_hits_own_adv`,
    `_fullscreen_block_hits_unsold` AS `fullscreen_block_hits_unsold`,
    `_fullscreen_block_shows` AS `fullscreen_block_shows`,
    `_fullscreen_block_shows_own_adv` AS `fullscreen_block_shows_own_adv`,
    `_fullscreen_block_visibility` AS `fullscreen_block_visibility`,
    `_fullscreen_block_winrate` AS `fullscreen_block_winrate`,
    `_fullscreen_partner_wo_nds` AS `fullscreen_partner_wo_nds`,
    `_id` AS `id`,
    `_inpage_all_wo_nds` AS `inpage_all_wo_nds`,
    `_inpage_block_all_hits` AS `inpage_block_all_hits`,
    `_inpage_block_bad_shows` AS `inpage_block_bad_shows`,
    `_inpage_block_bad_shows_own_adv` AS `inpage_block_bad_shows_own_adv`,
    `_inpage_block_bad_shows_percent` AS `inpage_block_bad_shows_percent`,
    `_inpage_block_bad_win_hits` AS `inpage_block_bad_win_hits`,
    `_inpage_block_bad_win_hits_own_adv` AS `inpage_block_bad_win_hits_own_adv`,
    `_inpage_block_bad_win_hits_percent` AS `inpage_block_bad_win_hits_percent`,
    `_inpage_block_bad_win_hits_unsold` AS `inpage_block_bad_win_hits_unsold`,
    `_inpage_block_cover_ratio` AS `inpage_block_cover_ratio`,
    `_inpage_block_cpm_all_wo_nds` AS `inpage_block_cpm_all_wo_nds`,
    `_inpage_block_cpm_partner_wo_nds` AS `inpage_block_cpm_partner_wo_nds`,
    `_inpage_block_cpmh_all_wo_nds` AS `inpage_block_cpmh_all_wo_nds`,
    `_inpage_block_cpmh_partner_wo_nds` AS `inpage_block_cpmh_partner_wo_nds`,
    `_inpage_block_direct_clicks` AS `inpage_block_direct_clicks`,
    `_inpage_block_direct_ctr` AS `inpage_block_direct_ctr`,
    `_inpage_block_direct_shows` AS `inpage_block_direct_shows`,
    `_inpage_block_hits` AS `inpage_block_hits`,
    `_inpage_block_hits_own_adv` AS `inpage_block_hits_own_adv`,
    `_inpage_block_hits_unsold` AS `inpage_block_hits_unsold`,
    `_inpage_block_shows` AS `inpage_block_shows`,
    `_inpage_block_shows_own_adv` AS `inpage_block_shows_own_adv`,
    `_inpage_block_visibility` AS `inpage_block_visibility`,
    `_inpage_block_winrate` AS `inpage_block_winrate`,
    `_inpage_partner_wo_nds` AS `inpage_partner_wo_nds`,
    `_instream_all_wo_nds` AS `instream_all_wo_nds`,
    `_instream_block_all_hits` AS `instream_block_all_hits`,
    `_instream_block_bad_shows` AS `instream_block_bad_shows`,
    `_instream_block_bad_shows_own_adv` AS `instream_block_bad_shows_own_adv`,
    `_instream_block_bad_shows_percent` AS `instream_block_bad_shows_percent`,
    `_instream_block_bad_win_hits` AS `instream_block_bad_win_hits`,
    `_instream_block_bad_win_hits_own_adv` AS `instream_block_bad_win_hits_own_adv`,
    `_instream_block_bad_win_hits_percent` AS `instream_block_bad_win_hits_percent`,
    `_instream_block_bad_win_hits_unsold` AS `instream_block_bad_win_hits_unsold`,
    `_instream_block_cover_ratio` AS `instream_block_cover_ratio`,
    `_instream_block_cpm_all_wo_nds` AS `instream_block_cpm_all_wo_nds`,
    `_instream_block_cpm_partner_wo_nds` AS `instream_block_cpm_partner_wo_nds`,
    `_instream_block_cpmh_all_wo_nds` AS `instream_block_cpmh_all_wo_nds`,
    `_instream_block_cpmh_partner_wo_nds` AS `instream_block_cpmh_partner_wo_nds`,
    `_instream_block_ctr` AS `instream_block_ctr`,
    `_instream_block_direct_clicks` AS `instream_block_direct_clicks`,
    `_instream_block_direct_ctr` AS `instream_block_direct_ctr`,
    `_instream_block_direct_shows` AS `instream_block_direct_shows`,
    `_instream_block_hits` AS `instream_block_hits`,
    `_instream_block_hits_own_adv` AS `instream_block_hits_own_adv`,
    `_instream_block_hits_unsold` AS `instream_block_hits_unsold`,
    `_instream_block_midroll_conversion_percent` AS `instream_block_midroll_conversion_percent`,
    `_instream_block_midroll_hits` AS `instream_block_midroll_hits`,
    `_instream_block_midroll_shows` AS `instream_block_midroll_shows`,
    `_instream_block_open_player` AS `instream_block_open_player`,
    `_instream_block_pauseroll_conversion_percent` AS `instream_block_pauseroll_conversion_percent`,
    `_instream_block_pauseroll_hits` AS `instream_block_pauseroll_hits`,
    `_instream_block_pauseroll_shows` AS `instream_block_pauseroll_shows`,
    `_instream_block_postroll_conversion_percent` AS `instream_block_postroll_conversion_percent`,
    `_instream_block_postroll_hits` AS `instream_block_postroll_hits`,
    `_instream_block_postroll_shows` AS `instream_block_postroll_shows`,
    `_instream_block_preroll_conversion_percent` AS `instream_block_preroll_conversion_percent`,
    `_instream_block_preroll_hits` AS `instream_block_preroll_hits`,
    `_instream_block_preroll_shows` AS `instream_block_preroll_shows`,
    `_instream_block_shows` AS `instream_block_shows`,
    `_instream_block_shows_own_adv` AS `instream_block_shows_own_adv`,
    `_instream_block_view` AS `instream_block_view`,
    `_instream_block_visibility` AS `instream_block_visibility`,
    `_instream_block_winrate` AS `instream_block_winrate`,
    `_instream_partner_wo_nds` AS `instream_partner_wo_nds`,
    `_login` AS `login`,
    `_partner_wo_nds` AS `partner_wo_nds`,
    `_video_an_site_all_hits` AS `video_an_site_all_hits`,
    `_video_an_site_all_hits_own_adv` AS `video_an_site_all_hits_own_adv`,
    `_video_an_site_all_hits_unsold` AS `video_an_site_all_hits_unsold`,
    `_video_an_site_all_shows` AS `video_an_site_all_shows`,
    `_video_an_site_all_shows_own_adv` AS `video_an_site_all_shows_own_adv`,
    `_video_an_site_sum_all_hits` AS `video_an_site_sum_all_hits`,
    `_video_an_site_sum_all_wo_nds` AS `video_an_site_sum_all_wo_nds`,
    `_video_an_site_sum_partner_wo_nds` AS `video_an_site_sum_partner_wo_nds`
FROM (
    SELECT
        round((SUM((`all_wo_nds` / 1000)) / 10000000), 2) AS `_all_wo_nds`,
        sumIf(`an_fraud_clicks`, `product_id` = 'video_an_site') AS `_an_fraud_clicks`,
        sumIf(`an_fraud_shows`, `product_id` = 'video_an_site') AS `_an_fraud_shows`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_caption`,
        dictGetStringOrDefault('video_categories_dict', 'name_ru', tuple(if(`product_id` = 'video_an_site', `category_id`, dictGetUInt32('blocks_dict', 'category_id', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`)))), `page_id`), toString(if(`product_id` = 'video_an_site', `category_id`, dictGetUInt32('blocks_dict', 'category_id', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`)))))) AS `_categories`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000), 2) AS `_fullscreen_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen') AS `_fullscreen_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )))) AS `_fullscreen_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )))) AS `_fullscreen_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen')) AS `_fullscreen_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            ))), 2) AS `_fullscreen_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'video_an_site_fullscreen')) AS `_fullscreen_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'video_an_site_fullscreen') AS `_fullscreen_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_fullscreen'
            )))) AS `_fullscreen_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_fullscreen'
    )) AS `_fullscreen_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_fullscreen'
        ))) AS `_fullscreen_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_fullscreen'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_fullscreen'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'video_an_site_fullscreen'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'video_an_site_fullscreen'
                    )))))) AS `_fullscreen_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') / 10000000), 2) AS `_fullscreen_partner_wo_nds`,
        dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) AS `_id`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000), 2) AS `_inpage_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage') AS `_inpage_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )))) AS `_inpage_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )))) AS `_inpage_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage')) AS `_inpage_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            ))), 2) AS `_inpage_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'video_an_site_inpage')) AS `_inpage_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'video_an_site_inpage') AS `_inpage_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_inpage'
            )))) AS `_inpage_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_inpage'
    )) AS `_inpage_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_inpage'
        ))) AS `_inpage_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_inpage'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_inpage'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'video_an_site_inpage'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'video_an_site_inpage'
                    )))))) AS `_inpage_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') / 10000000), 2) AS `_inpage_partner_wo_nds`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000), 2) AS `_instream_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') AS `_instream_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )))) AS `_instream_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )))) AS `_instream_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream')) AS `_instream_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpmh_partner_wo_nds`,
        ((sumIf(`open_player`, `product_id` = 'video_an_site') * 100) / sumIf(`view`, `product_id` = 'video_an_site')) AS `_instream_block_ctr`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'video_an_site_instream')) AS `_instream_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'video_an_site_instream') AS `_instream_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_instream'
            )))) AS `_instream_block_hits_unsold`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
                AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 2
            )) * 100) / sumIf(`open_player`, `product_id` = 'video_an_site')) AS `_instream_block_midroll_conversion_percent`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
        AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 2
    )) AS `_instream_block_midroll_hits`,
        sumIf(`shows`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
        AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 2
    )) AS `_instream_block_midroll_shows`,
        sumIf(`open_player`, `product_id` = 'video_an_site') AS `_instream_block_open_player`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
                AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 4
            )) * 100) / sumIf(`open_player`, `product_id` = 'video_an_site')) AS `_instream_block_pauseroll_conversion_percent`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
        AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 4
    )) AS `_instream_block_pauseroll_hits`,
        sumIf(`shows`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
        AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 4
    )) AS `_instream_block_pauseroll_shows`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
                AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 1
            )) * 100) / sumIf(`open_player`, `product_id` = 'video_an_site')) AS `_instream_block_postroll_conversion_percent`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
        AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 1
    )) AS `_instream_block_postroll_hits`,
        sumIf(`shows`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
        AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 1
    )) AS `_instream_block_postroll_shows`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
                AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 0
            )) * 100) / sumIf(`open_player`, `product_id` = 'video_an_site')) AS `_instream_block_preroll_conversion_percent`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
        AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 0
    )) AS `_instream_block_preroll_hits`,
        sumIf(`shows`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
        AND dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 0
    )) AS `_instream_block_preroll_shows`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_shows_own_adv`,
        sumIf(`view`, `product_id` = 'video_an_site') AS `_instream_block_view`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_instream'
        ))) AS `_instream_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_instream'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'video_an_site_instream'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'video_an_site_instream'
                    )))))) AS `_instream_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000), 2) AS `_instream_partner_wo_nds`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        round((SUM((`partner_wo_nds` / 1000)) / 10000000), 2) AS `_partner_wo_nds`,
        (sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_instream'
        )) + sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_inpage'
        )) + sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_fullscreen'
        ))) AS `_video_an_site_all_hits`,
        (sumIf(`hits`, (
            `dsp_id` = 5
            AND `product_id` = 'video_an_site_instream'
        )) + sumIf(`hits`, (
            `dsp_id` = 5
            AND `product_id` = 'video_an_site_inpage'
        )) + sumIf(`hits`, (
            `dsp_id` = 5
            AND `product_id` = 'video_an_site_fullscreen'
        ))) AS `_video_an_site_all_hits_own_adv`,
        ((sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') - (sumIf(`hits`, (
                    `dsp_id` NOT IN (5, 10)
                    AND `product_id` = 'video_an_site_instream'
                )) + sumIf(`hits`, (
                    `dsp_id` = 5
                    AND `product_id` = 'video_an_site_instream'
                )))) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage') - (sumIf(`hits`, (
                    `dsp_id` NOT IN (5, 10)
                    AND `product_id` = 'video_an_site_inpage'
                )) + sumIf(`hits`, (
                    `dsp_id` = 5
                    AND `product_id` = 'video_an_site_inpage'
                )))) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen') - (sumIf(`hits`, (
                    `dsp_id` NOT IN (5, 10)
                    AND `product_id` = 'video_an_site_fullscreen'
                )) + sumIf(`hits`, (
                    `dsp_id` = 5
                    AND `product_id` = 'video_an_site_fullscreen'
                ))))) AS `_video_an_site_all_hits_unsold`,
        (sumIf(`shows`, (
            `dsp_id` <> 5
            AND `product_id` = 'video_an_site_instream'
        )) + sumIf(`shows`, (
            `dsp_id` <> 5
            AND `product_id` = 'video_an_site_inpage'
        )) + sumIf(`shows`, (
            `dsp_id` <> 5
            AND `product_id` = 'video_an_site_fullscreen'
        ))) AS `_video_an_site_all_shows`,
        (sumIf(`shows`, (
            `dsp_id` = 5
            AND `product_id` = 'video_an_site_instream'
        )) + sumIf(`shows`, (
            `dsp_id` = 5
            AND `product_id` = 'video_an_site_inpage'
        )) + sumIf(`shows`, (
            `dsp_id` = 5
            AND `product_id` = 'video_an_site_fullscreen'
        ))) AS `_video_an_site_all_shows_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') + sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_inpage') + sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_fullscreen')) AS `_video_an_site_sum_all_hits`,
        round(((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') + sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen') + sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_inpage')) / 10000000), 2) AS `_video_an_site_sum_all_wo_nds`,
        round(((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') + sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_inpage') + sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_fullscreen')) / 10000000), 2) AS `_video_an_site_sum_partner_wo_nds`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('video_an_site', 'video_an_site_instream', 'video_an_site_inpage', 'video_an_site_fullscreen')
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["AND",[["login","=","mock__owner-login"]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["OR",[["is_efir_blogger","=",1],["is_video_blogger","=",1],["is_tutby","=",1],["is_adfox_partner","=",1],["is_mobile_mediation","=",1],["is_games","=",1]]]')
        )
        AND (
            dictGetUInt32('pages_dict', 'id', toUInt64(`page_id`)) = 'mock__id'
        )
        AND (
            dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) = 'mock__domain'
        )
        AND (
            dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) = 'mock__caption'
        )
        AND (
            dictGetUInt64('pages_dict', 'multistate', toUInt64(`page_id`)) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
        AND if(`product_id` = 'video_an_site', `category_id`, dictGetUInt32('blocks_dict', 'category_id', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`)))) = 'mock__categories'
    )
    GROUP BY `_caption`, `_categories`, `_currency_id`, `_date`, `_domain`, `_id`, `_login`
) `statistics`
WHERE (
    (if(isNaN(`an_fraud_clicks`), 0, `an_fraud_clicks`) + if(isNaN(`inpage_block_cover_ratio`), 0, `inpage_block_cover_ratio`) + if(isNaN(`fullscreen_block_bad_shows_own_adv`), 0, `fullscreen_block_bad_shows_own_adv`) + if(isNaN(`fullscreen_block_cover_ratio`), 0, `fullscreen_block_cover_ratio`) + if(isNaN(`video_an_site_all_hits`), 0, `video_an_site_all_hits`) + if(isNaN(`instream_block_midroll_shows`), 0, `instream_block_midroll_shows`) + if(isNaN(`fullscreen_block_bad_shows_percent`), 0, `fullscreen_block_bad_shows_percent`) + if(isNaN(`fullscreen_block_direct_clicks`), 0, `fullscreen_block_direct_clicks`) + if(isNaN(`fullscreen_block_shows`), 0, `fullscreen_block_shows`) + if(isNaN(`instream_block_bad_shows_percent`), 0, `instream_block_bad_shows_percent`) + if(isNaN(`inpage_block_bad_win_hits_unsold`), 0, `inpage_block_bad_win_hits_unsold`) + if(isNaN(`instream_block_hits_unsold`), 0, `instream_block_hits_unsold`) + if(isNaN(`fullscreen_block_bad_shows`), 0, `fullscreen_block_bad_shows`) + if(isNaN(`fullscreen_block_shows_own_adv`), 0, `fullscreen_block_shows_own_adv`) + if(isNaN(`instream_block_postroll_hits`), 0, `instream_block_postroll_hits`) + if(isNaN(`inpage_block_cpmh_partner_wo_nds`), 0, `inpage_block_cpmh_partner_wo_nds`) + if(isNaN(`video_an_site_all_hits_unsold`), 0, `video_an_site_all_hits_unsold`) + if(isNaN(`instream_block_pauseroll_conversion_percent`), 0, `instream_block_pauseroll_conversion_percent`) + if(isNaN(`inpage_partner_wo_nds`), 0, `inpage_partner_wo_nds`) + if(isNaN(`inpage_block_bad_win_hits_percent`), 0, `inpage_block_bad_win_hits_percent`) + if(isNaN(`instream_block_cpm_all_wo_nds`), 0, `instream_block_cpm_all_wo_nds`) + if(isNaN(`inpage_block_bad_shows`), 0, `inpage_block_bad_shows`) + if(isNaN(`instream_block_direct_clicks`), 0, `instream_block_direct_clicks`) + if(isNaN(`inpage_block_shows_own_adv`), 0, `inpage_block_shows_own_adv`) + if(isNaN(`fullscreen_block_direct_shows`), 0, `fullscreen_block_direct_shows`) + if(isNaN(`inpage_block_bad_shows_own_adv`), 0, `inpage_block_bad_shows_own_adv`) + if(isNaN(`instream_block_ctr`), 0, `instream_block_ctr`) + if(isNaN(`instream_block_visibility`), 0, `instream_block_visibility`) + if(isNaN(`video_an_site_sum_partner_wo_nds`), 0, `video_an_site_sum_partner_wo_nds`) + if(isNaN(`fullscreen_block_hits`), 0, `fullscreen_block_hits`) + if(isNaN(`fullscreen_block_bad_win_hits_own_adv`), 0, `fullscreen_block_bad_win_hits_own_adv`) + if(isNaN(`video_an_site_sum_all_wo_nds`), 0, `video_an_site_sum_all_wo_nds`) + if(isNaN(`fullscreen_block_cpmh_partner_wo_nds`), 0, `fullscreen_block_cpmh_partner_wo_nds`) + if(isNaN(`instream_block_preroll_hits`), 0, `instream_block_preroll_hits`) + if(isNaN(`all_wo_nds`), 0, `all_wo_nds`) + if(isNaN(`instream_block_view`), 0, `instream_block_view`) + if(isNaN(`an_fraud_shows`), 0, `an_fraud_shows`) + if(isNaN(`instream_block_bad_win_hits_percent`), 0, `instream_block_bad_win_hits_percent`) + if(isNaN(`inpage_block_hits_own_adv`), 0, `inpage_block_hits_own_adv`) + if(isNaN(`inpage_block_direct_shows`), 0, `inpage_block_direct_shows`) + if(isNaN(`instream_block_postroll_conversion_percent`), 0, `instream_block_postroll_conversion_percent`) + if(isNaN(`inpage_block_cpm_all_wo_nds`), 0, `inpage_block_cpm_all_wo_nds`) + if(isNaN(`inpage_block_direct_clicks`), 0, `inpage_block_direct_clicks`) + if(isNaN(`fullscreen_block_hits_own_adv`), 0, `fullscreen_block_hits_own_adv`) + if(isNaN(`inpage_block_cpm_partner_wo_nds`), 0, `inpage_block_cpm_partner_wo_nds`) + if(isNaN(`inpage_block_shows`), 0, `inpage_block_shows`) + if(isNaN(`instream_block_open_player`), 0, `instream_block_open_player`) + if(isNaN(`fullscreen_all_wo_nds`), 0, `fullscreen_all_wo_nds`) + if(isNaN(`instream_block_cpmh_partner_wo_nds`), 0, `instream_block_cpmh_partner_wo_nds`) + if(isNaN(`inpage_block_hits`), 0, `inpage_block_hits`) + if(isNaN(`inpage_block_bad_win_hits`), 0, `inpage_block_bad_win_hits`) + if(isNaN(`instream_block_hits`), 0, `instream_block_hits`) + if(isNaN(`inpage_block_winrate`), 0, `inpage_block_winrate`) + if(isNaN(`instream_block_direct_ctr`), 0, `instream_block_direct_ctr`) + if(isNaN(`instream_block_pauseroll_hits`), 0, `instream_block_pauseroll_hits`) + if(isNaN(`fullscreen_block_bad_win_hits_unsold`), 0, `fullscreen_block_bad_win_hits_unsold`) + if(isNaN(`instream_block_shows`), 0, `instream_block_shows`) + if(isNaN(`inpage_block_cpmh_all_wo_nds`), 0, `inpage_block_cpmh_all_wo_nds`) + if(isNaN(`inpage_block_all_hits`), 0, `inpage_block_all_hits`) + if(isNaN(`instream_block_bad_win_hits_own_adv`), 0, `instream_block_bad_win_hits_own_adv`) + if(isNaN(`fullscreen_block_winrate`), 0, `fullscreen_block_winrate`) + if(isNaN(`fullscreen_block_bad_win_hits`), 0, `fullscreen_block_bad_win_hits`) + if(isNaN(`fullscreen_block_cpm_all_wo_nds`), 0, `fullscreen_block_cpm_all_wo_nds`) + if(isNaN(`instream_block_postroll_shows`), 0, `instream_block_postroll_shows`) + if(isNaN(`instream_block_winrate`), 0, `instream_block_winrate`) + if(isNaN(`instream_block_midroll_conversion_percent`), 0, `instream_block_midroll_conversion_percent`) + if(isNaN(`inpage_all_wo_nds`), 0, `inpage_all_wo_nds`) + if(isNaN(`instream_block_shows_own_adv`), 0, `instream_block_shows_own_adv`) + if(isNaN(`instream_block_bad_win_hits_unsold`), 0, `instream_block_bad_win_hits_unsold`) + if(isNaN(`partner_wo_nds`), 0, `partner_wo_nds`) + if(isNaN(`fullscreen_block_bad_win_hits_percent`), 0, `fullscreen_block_bad_win_hits_percent`) + if(isNaN(`video_an_site_all_hits_own_adv`), 0, `video_an_site_all_hits_own_adv`) + if(isNaN(`instream_block_all_hits`), 0, `instream_block_all_hits`) + if(isNaN(`instream_block_hits_own_adv`), 0, `instream_block_hits_own_adv`) + if(isNaN(`instream_block_cpm_partner_wo_nds`), 0, `instream_block_cpm_partner_wo_nds`) + if(isNaN(`instream_block_bad_win_hits`), 0, `instream_block_bad_win_hits`) + if(isNaN(`fullscreen_block_visibility`), 0, `fullscreen_block_visibility`) + if(isNaN(`instream_block_preroll_conversion_percent`), 0, `instream_block_preroll_conversion_percent`) + if(isNaN(`instream_block_bad_shows_own_adv`), 0, `instream_block_bad_shows_own_adv`) + if(isNaN(`fullscreen_partner_wo_nds`), 0, `fullscreen_partner_wo_nds`) + if(isNaN(`inpage_block_hits_unsold`), 0, `inpage_block_hits_unsold`) + if(isNaN(`instream_block_midroll_hits`), 0, `instream_block_midroll_hits`) + if(isNaN(`fullscreen_block_all_hits`), 0, `fullscreen_block_all_hits`) + if(isNaN(`instream_block_preroll_shows`), 0, `instream_block_preroll_shows`) + if(isNaN(`inpage_block_bad_shows_percent`), 0, `inpage_block_bad_shows_percent`) + if(isNaN(`fullscreen_block_direct_ctr`), 0, `fullscreen_block_direct_ctr`) + if(isNaN(`instream_block_cpmh_all_wo_nds`), 0, `instream_block_cpmh_all_wo_nds`) + if(isNaN(`instream_all_wo_nds`), 0, `instream_all_wo_nds`) + if(isNaN(`instream_block_pauseroll_shows`), 0, `instream_block_pauseroll_shows`) + if(isNaN(`instream_partner_wo_nds`), 0, `instream_partner_wo_nds`) + if(isNaN(`video_an_site_sum_all_hits`), 0, `video_an_site_sum_all_hits`) + if(isNaN(`instream_block_direct_shows`), 0, `instream_block_direct_shows`) + if(isNaN(`fullscreen_block_cpmh_all_wo_nds`), 0, `fullscreen_block_cpmh_all_wo_nds`) + if(isNaN(`instream_block_cover_ratio`), 0, `instream_block_cover_ratio`) + if(isNaN(`inpage_block_direct_ctr`), 0, `inpage_block_direct_ctr`) + if(isNaN(`inpage_block_visibility`), 0, `inpage_block_visibility`) + if(isNaN(`video_an_site_all_shows`), 0, `video_an_site_all_shows`) + if(isNaN(`fullscreen_block_hits_unsold`), 0, `fullscreen_block_hits_unsold`) + if(isNaN(`instream_block_bad_shows`), 0, `instream_block_bad_shows`) + if(isNaN(`inpage_block_bad_win_hits_own_adv`), 0, `inpage_block_bad_win_hits_own_adv`) + if(isNaN(`fullscreen_block_cpm_partner_wo_nds`), 0, `fullscreen_block_cpm_partner_wo_nds`) + if(isNaN(`video_an_site_all_shows_own_adv`), 0, `video_an_site_all_shows_own_adv`)) > 0
) FORMAT JSONCompact
