SELECT
    `_adfox_block` AS `adfox_block`,
    `_caption` AS `caption`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_domain` AS `domain`,
    `_dsp_caption` AS `dsp_caption`,
    `_dsp_id_name` AS `dsp_id_name`,
    `_instream_all_wo_nds` AS `instream_all_wo_nds`,
    `_instream_block_all_hits` AS `instream_block_all_hits`,
    `_instream_block_bad_shows` AS `instream_block_bad_shows`,
    `_instream_block_bad_shows_own_adv` AS `instream_block_bad_shows_own_adv`,
    `_instream_block_bad_shows_percent` AS `instream_block_bad_shows_percent`,
    `_instream_block_bad_win_hits` AS `instream_block_bad_win_hits`,
    `_instream_block_bad_win_hits_own_adv` AS `instream_block_bad_win_hits_own_adv`,
    `_instream_block_bad_win_hits_percent` AS `instream_block_bad_win_hits_percent`,
    `_instream_block_bad_win_hits_unsold` AS `instream_block_bad_win_hits_unsold`,
    `_instream_block_cover_ratio` AS `instream_block_cover_ratio`,
    `_instream_block_cpm_all_wo_nds` AS `instream_block_cpm_all_wo_nds`,
    `_instream_block_cpm_partner_wo_nds` AS `instream_block_cpm_partner_wo_nds`,
    `_instream_block_cpmh_all_wo_nds` AS `instream_block_cpmh_all_wo_nds`,
    `_instream_block_cpmh_partner_wo_nds` AS `instream_block_cpmh_partner_wo_nds`,
    `_instream_block_direct_clicks` AS `instream_block_direct_clicks`,
    `_instream_block_direct_ctr` AS `instream_block_direct_ctr`,
    `_instream_block_direct_shows` AS `instream_block_direct_shows`,
    `_instream_block_hits` AS `instream_block_hits`,
    `_instream_block_hits_own_adv` AS `instream_block_hits_own_adv`,
    `_instream_block_hits_unsold` AS `instream_block_hits_unsold`,
    `_instream_block_shows` AS `instream_block_shows`,
    `_instream_block_shows_own_adv` AS `instream_block_shows_own_adv`,
    `_instream_block_visibility` AS `instream_block_visibility`,
    `_instream_block_winrate` AS `instream_block_winrate`,
    `_instream_partner_wo_nds` AS `instream_partner_wo_nds`,
    `_login` AS `login`,
    `_page_id` AS `page_id`,
    `_public_id` AS `public_id`,
    `_tag_id` AS `tag_id`,
    `_type_label` AS `type_label`,
    `_video_caption` AS `video_caption`
FROM (
    SELECT
        dictGetUInt8('blocks_dict', 'adfox_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_adfox_block`,
        dictGetString('blocks_dict', 'caption', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_caption`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetStringOrDefault('dsps_dict', 'short_caption', toUInt64(`dsp_id`), concat('DSP #', toString(`dsp_id`))) AS `_dsp_caption`,
        `dsp_id` AS `_dsp_id_name`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000), 2) AS `_instream_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') AS `_instream_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )))) AS `_instream_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )))) AS `_instream_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream')) AS `_instream_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            ))), 2) AS `_instream_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'video_an_site_instream')) AS `_instream_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'video_an_site_instream') AS `_instream_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_instream'
            )))) AS `_instream_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'video_an_site_instream'
    )) AS `_instream_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'video_an_site_instream'
        ))) AS `_instream_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'video_an_site_instream'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'video_an_site_instream'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'video_an_site_instream') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'video_an_site_instream'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'video_an_site_instream'
                    )))))) AS `_instream_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'video_an_site_instream') / 10000000), 2) AS `_instream_partner_wo_nds`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        `page_id` AS `_page_id`,
        concat(transform(toString(`product_id`), ['video_an_site_instream'], ['R-V-']), toString(`page_id`), '-', toString(`block_id`)) AS `_public_id`,
        `tag_id` AS `_tag_id`,
        transform(dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))), [0, 1, 2, 4, 6, 7, 8, 9], ['Pre', 'Post', 'Mid', 'Pause', 'Inroll', 'S2sroll', 'Overlay', 'Inroll-overlay'], 'Pre') AS `_type_label`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_video_caption`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('video_an_site_instream')
        AND (
            `page_id` IN ('id__from_table__video_an_site__with_filter__["AND",[["owner_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"login\\",\\"=\\",\\"mock__login\\"]]]"]]]]')
        )
        AND (
            `page_id` IN ('id__from_table__video_an_site__with_filter__["AND",[["owner_id","= ANY",["id__from_table__users__with_filter__[\\"OR\\",[[\\"is_efir_blogger\\",\\"=\\",1],[\\"is_video_blogger\\",\\"=\\",1],[\\"is_tutby\\",\\"=\\",1],[\\"is_adfox_partner\\",\\"=\\",1],[\\"is_mobile_mediation\\",\\"=\\",1],[\\"is_games\\",\\"=\\",1]]]"]]]]')
        )
        AND (
            `page_id` = 'mock__page_id'
        )
        AND (
            if(`product_id` = 'video_an_site', `category_id`, dictGetUInt32('blocks_dict', 'category_id', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`)))) = 'mock__category_id'
        )
        AND (
            `block_id` = 1
        )
        AND (
            dictGetString('blocks_dict', 'caption', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 'mock__caption'
        )
        AND (
            `page_id` IN ('id__from_table__video_an_site__with_filter__["AND",[["domain","=","mock__page.domain"]]]')
        )
        AND (
            dictGetUInt8('blocks_dict', 'video_block_type', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) IN (0, 1, 2, 4, 6, 7, 8, 9)
        )
        AND (
            dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) IN ('mock_multistate')
        )
        AND (
            dictGetUInt8('blocks_dict', 'adfox_block', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) = 1
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
        AND `dsp_id` = 'mock__dsp_id_name'
        AND `dsp_id` = 'mock__dsp_caption'
        AND `tag_id` = 'mock__tag_id'
        AND `page_id` = 'mock__video_caption'
    )
    GROUP BY `_adfox_block`, `_caption`, `_currency_id`, `_date`, `_domain`, `_dsp_caption`, `_dsp_id_name`, `_login`, `_page_id`, `_public_id`, `_tag_id`, `_type_label`, `_video_caption`
) `statistics`
WHERE (
    (if(isNaN(`instream_block_shows`), 0, `instream_block_shows`) + if(isNaN(`instream_block_bad_win_hits_own_adv`), 0, `instream_block_bad_win_hits_own_adv`) + if(isNaN(`instream_block_bad_shows_percent`), 0, `instream_block_bad_shows_percent`) + if(isNaN(`instream_block_hits_unsold`), 0, `instream_block_hits_unsold`) + if(isNaN(`instream_block_winrate`), 0, `instream_block_winrate`) + if(isNaN(`instream_block_shows_own_adv`), 0, `instream_block_shows_own_adv`) + if(isNaN(`instream_block_bad_win_hits_unsold`), 0, `instream_block_bad_win_hits_unsold`) + if(isNaN(`instream_block_cpm_all_wo_nds`), 0, `instream_block_cpm_all_wo_nds`) + if(isNaN(`instream_block_all_hits`), 0, `instream_block_all_hits`) + if(isNaN(`instream_block_direct_clicks`), 0, `instream_block_direct_clicks`) + if(isNaN(`instream_block_hits_own_adv`), 0, `instream_block_hits_own_adv`) + if(isNaN(`instream_block_cpm_partner_wo_nds`), 0, `instream_block_cpm_partner_wo_nds`) + if(isNaN(`instream_block_bad_win_hits`), 0, `instream_block_bad_win_hits`) + if(isNaN(`instream_block_visibility`), 0, `instream_block_visibility`) + if(isNaN(`instream_block_bad_shows_own_adv`), 0, `instream_block_bad_shows_own_adv`) + if(isNaN(`instream_block_cpmh_all_wo_nds`), 0, `instream_block_cpmh_all_wo_nds`) + if(isNaN(`instream_all_wo_nds`), 0, `instream_all_wo_nds`) + if(isNaN(`instream_partner_wo_nds`), 0, `instream_partner_wo_nds`) + if(isNaN(`instream_block_direct_shows`), 0, `instream_block_direct_shows`) + if(isNaN(`instream_block_bad_win_hits_percent`), 0, `instream_block_bad_win_hits_percent`) + if(isNaN(`instream_block_cover_ratio`), 0, `instream_block_cover_ratio`) + if(isNaN(`instream_block_bad_shows`), 0, `instream_block_bad_shows`) + if(isNaN(`instream_block_cpmh_partner_wo_nds`), 0, `instream_block_cpmh_partner_wo_nds`) + if(isNaN(`instream_block_hits`), 0, `instream_block_hits`) + if(isNaN(`instream_block_direct_ctr`), 0, `instream_block_direct_ctr`)) > 0
) FORMAT JSONCompact
