#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use lib::abs;

use Test::Partner2::Simple;
use Test::Partner::Utils qw(mock_curdate);

use Test::More;
use Test::Deep;

use qbit;

my $TESTS = [
    {
        name     => 'daily',
        opts     => {from => '2018-01-07', to => '2018-01-07', for_month => FALSE, storage => 'clickhouse'},
        expected => ['2018-01-07']
    },
    {
        name => 'monthly',
        opts => {from => '2018-01-01', to => '2018-01-06', for_month => TRUE, storage => 'clickhouse'},
        expected => ['2018-01-01', '2018-01-02', '2018-01-03', '2018-01-04', '2018-01-05', '2018-01-06',]
    },
];

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2018-01-07 15:00:00');

        foreach my $test (@$TESTS) {
            my ($name, $opts, $expected) = @$test{qw(name opts expected)};

            cmp_deeply([$app->statistics_advnet_context_on_site_rtb->__get_dates_by_period(%$opts)],
                $expected, "days for $name update");

            my $key_last_run =
                $opts->{'for_month'}
              ? $app->statistics_advnet_context_on_site_rtb->__get_kv_store_key_for_month(%$opts)
              : $app->statistics_advnet_context_on_site_rtb->__get_kv_store_key(%$opts);

            $app->kv_store->set($key_last_run, '2018-01-07');

            cmp_deeply(
                [$app->statistics_advnet_context_on_site_rtb->__get_dates_by_period(%$opts)],
                ($opts->{'for_month'} ? [] : $expected),
                "days for $name update with last run"
            );

            my $key_for_dates_with_errors =
              $app->statistics_advnet_context_on_site_rtb->__get_kv_store_key_for_dates_with_errors(%$opts);

            is($key_for_dates_with_errors, 'dates_with_errors_advnet_context_on_site_rtb_clickhouse',
                'check store key');

            my @dates_with_errors = ('2017-12-25', '2017-12-31', '2018-01-03');

            $app->kv_store->set($key_for_dates_with_errors, to_json(\@dates_with_errors));

            cmp_deeply(
                [$app->statistics_advnet_context_on_site_rtb->__get_dates_by_period(%$opts)],
                ($opts->{'for_month'} ? \@dates_with_errors : $expected),
                "days for $name update with last run and skipped days"
            );

            $app->kv_store->delete($key_last_run);

            cmp_deeply(
                [$app->statistics_advnet_context_on_site_rtb->__get_dates_by_period(%$opts)],
                [($opts->{'for_month'} ? @dates_with_errors[0 .. 1] : ()), @$expected],
                "days for $name update with skipped days"
            );

            $app->kv_store->delete($key_for_dates_with_errors);
        }
    },
    init => ['statistics_advnet_context_on_site_rtb'],
);
