#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use lib::abs;

use Test::Partner2::Simple;
use Test::Partner2::Utils qw($SKIP_MODELS);

use Test::More;
use Test::Deep;

use qbit;

my $IGNORE_STAT_LEVELS = {
    'statistics_additional_income'       => 1,
    'statistics_advnet_on_site'          => 1,
    'statistics_charging'                => 1,
    'statistics_dsp'                     => 1,
    'statistics_internal_advnet_on_site' => 1,
    'statistics_internal_mobile_app'     => 1,
    'statistics_payment'                 => 1,
    'statistics_ssp'                     => 1,
    'statistics_yandex'                  => 1,
};

run_tests(
    sub {
        my ($app) = @_;

        my $path = lib::abs::path('./convert_mysql_to_clickhouse_data');

        my $res = $app->product_manager->get_accessors_by_tag('statistics');

        foreach my $level (grep {!$IGNORE_STAT_LEVELS->{$_}} @{$res}) {
            if ($app->$level->can('product')) {
                my $model_name = $app->$level->product->accessor;
                next if $SKIP_MODELS->{$model_name};
            }

            my $path = "$path/$level.json";

            my $test_data = from_json(readfile($path));

            my $ch_data = $app->$level->convert_mysql_to_clickhouse($test_data->{'mysql'});

            if (need_self_update()) {
                $test_data->{'clickhouse'} = $ch_data;

                writefile($path, to_json($test_data, pretty => TRUE));
            }

            cmp_deeply($ch_data, $test_data->{'clickhouse'}, "convert for $level");
        }
    },
    dont_create_database => 1,
);
