#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use lib::abs;

use Test::Partner2::Simple;
use Test::Partner::Utils qw(mock_curdate);

use Test::More;
use Test::Deep;

use Utils::Logger;

use qbit;

my $TESTS = [
    {
        name            => 'daily',
        method          => '__get_kv_store_key',
        opts            => {from => '2018-01-07', to => '2018-01-07', for_month => FALSE, storage => 'clickhouse'},
        days_with_error => ['2018-01-07'],
        expected        => [],
        expected2       => [],
        last_run_date   => '2018-01-06',
    },
    {
        name   => 'monthly',
        method => '__get_kv_store_key_for_month',
        opts   => {from => '2018-01-01', to => '2018-01-06', for_month => TRUE, storage => 'clickhouse'},
        days_with_error => ['2018-01-02', '2018-01-04'],
        expected        => ['2018-01-04', '2018-01-02', '2018-01-06'],
        expected2     => ['2018-01-06'],
        last_run_date => '2018-01-07',
    },
];

my $DAYS_WITH_ERROR;

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2018-01-07 15:00:00');

        {
            no warnings 'redefine';
            no strict 'refs';

            *{'Application::Model::Statistics::RTB::_get_stat_from_balance'} = sub {
                my ($self, %opts) = @_;

                throw 'Error' if in_array($opts{'from'}, $DAYS_WITH_ERROR);
            };

            *{'Application::Model::Sentry::send_exception'} = sub { };
        }

        foreach my $test (@$TESTS) {
            my ($name, $method, $opts, $days_with_errors, $expected, $expected2, $last_run_date) =
              @$test{qw(name method opts days_with_error expected expected2 last_run_date)};

            my $key = $app->statistics_advnet_context_on_site_rtb->$method(%$opts);
            $app->kv_store->set($key, '2018-01-06');

            $DAYS_WITH_ERROR = $days_with_errors;

            try {
                $app->statistics_advnet_context_on_site_rtb->regular_update_statistics(%$opts);
            };

            is($app->kv_store->get($key), $last_run_date, "$name: check last run");

            my $key_for_dates_with_errors =
              $app->statistics_advnet_context_on_site_rtb->__get_kv_store_key_for_dates_with_errors(%$opts);

            is($app->kv_store->get($key_for_dates_with_errors) // '[]',
                to_json($expected), "$name: check skipped dates");

            $DAYS_WITH_ERROR = [];

            $app->statistics_advnet_context_on_site_rtb->regular_update_statistics(%$opts);

            is($app->kv_store->get($key_for_dates_with_errors) // '[]',
                to_json($expected2), "$name: check that all dates removed (except yesterday)");

            $app->kv_store->delete($key_for_dates_with_errors);
        }
    },
    init  => ['statistics_advnet_context_on_site_rtb', 'sentry'],
    mocks => [qw(mock_check_statistics_by_blocks)],
);
