#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use qbit;

require Application::Model::Statistics::Update;

run_tests(
    sub {
        my $key_data = {
            dt       => '2017-01-01',
            page_id  => 33,
            block_id => undef,
        };

        {
            my $testname = 'Valid values added';
            my $metrics_data = {shows => 1,};

            my $got = Application::Model::Statistics::Update->without_only_zero_values([{%$key_data, %$metrics_data}],
                ['shows']);
            my $expect = [{%$key_data, %$metrics_data}];

            cmp_deeply($got, $expect, $testname);
        }

        {
            my $testname = 'Got exception on undef value';
            my $metrics_data = {shows => undef,};

            my $got = '';
            try {
                Application::Model::Statistics::Update->without_only_zero_values([{%$key_data, %$metrics_data}],
                    ['shows']);
            }
            catch {
                my ($exception) = @_;
                $got = $exception->message;
            };

            my $expect = 'Uninitialized value found: shows=undef (block_id=undef, dt=2017-01-01, page_id=33)';

            cmp_ok($got, 'eq', $expect, $testname);
        }

    },
    dont_create_database => 1
);
