use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_internal_context_on_site_campaign_db_filter_fields);

use Test::Most;
use Test::Deep qw(cmp_deeply ignore);
use Test::Differences qw( eq_or_diff );

use Test::Partner2::Statistics::Subs qw( _mock_app_with_hands_and_dbh sort_fields build_statistics_levels );
use Test::Partner2::Statistics::Data qw(
  @common_fields
  $entity_filter_field_managers
  $fields_internal_advnet_context_on_site_rtb
  $common_filter_fields
  );

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        _mock_app_with_hands_and_dbh($app);

        my %currencies = (1 => 'USD', 2 => 'RUB', 3 => 'EUR',);
        $app->partner_db->get_dbh->do("INSERT INTO currencies (id, code) VALUES  (?, ?), (?, ?), (?, ?) ;",
            {}, %currencies);

        {
            no strict 'refs';
            no warnings 'redefine';
            *{'QBit::Application::check_rights'} = sub {TRUE};
        }

        my $tree     = $app->statistics->get_tree();
        my $levels   = build_statistics_levels($tree);
        my $level_id = 'internal_advnet_context_on_site_rtb';
        my $level    = $levels->{$level_id};

        cmp_deeply($level->{'conflict_fields'}, [], 'conflict_fields');

        cmp_deeply(
            $level->{'dimension_fields'},
            [
                @common_fields,
                {
                    'ajax'     => 1,
                    'verbatim' => 1,
                    'type'     => 'dictionary',
                    'title'    => re(qr(\w)),
                    'id'       => 'dsp_id_name',
                    'sort_as'  => 'number',
                },
                {
                    'verbatim' => 1,
                    'type'     => 'dictionary',
                    'title'    => re(qr(\w)),
                    'id'       => 'dsp_caption',
                    'ajax'     => 1
                },
                {
                    'id'       => 'tag_id',
                    'sort_as'  => 'number',
                    'title'    => re(qr(\w)),
                    'type'     => 'number',
                    'verbatim' => 1,
                },
                {
                    'id'         => 'tag_caption',
                    'title'      => re(qr(\w)),
                    'type'       => 'dictionary',
                    'verbatim'   => 1,
                    'only_group' => 1,
                },
            ],
            'dimension_fields'
        );

        cmp_deeply(
            $level->{'entity_fields'},
            [
                {'verbatim' => 1, 'type' => 'text', 'label' => re(qr(\w)), 'id' => 'domain', 'only_group' => 1},
                {'type' => 'page_id',   'label' => re(qr(\w)), 'id' => 'campaign_id', 'only_group' => 1},
                {'type' => 'public_id', 'label' => re(qr(\w)), 'id' => 'public_id',   'only_group' => 1},
                {'verbatim' => 1, 'type' => 'text', 'label' => re(qr(\w)), 'id' => 'caption', 'only_group' => 1},
                {
                    'verbatim'   => 1,
                    'type'       => 'text',
                    'label'      => re(qr(\w)),
                    'id'         => 'media_formats_list',
                    'only_group' => 1
                },
                {'id' => 'domain_id',            'only_group' => 1},
                {'id' => 'internal_campaign_id', 'only_group' => 1}
            ],
            'entity_fields'
        );

        cmp_deeply(
            $level->{'entity_filter_fields'},
            {
                %$common_filter_fields,
                'adfox_block' => {'label' => re(qr(\w)), 'type' => 'boolean'},
                'caption'     => {'label' => re(qr(\w)), 'type' => 'text'},
                'campaign'    => {
                    'subfields' => get_internal_context_on_site_campaign_db_filter_fields($app),
                    'label'     => re(qr(\w)),
                    'type'      => 'subfilter'
                },
                'page' => {
                    'subfields' => get_internal_context_on_site_campaign_db_filter_fields($app),
                    'label'     => re(qr(\w)),
                    'type'      => 'subfilter'
                },
                'is_custom_bk_data' => {
                    'label' => 'Custom BK data enabled',
                    'type'  => 'boolean'
                },
                'managers'   => $entity_filter_field_managers,
                'id'         => {'label' => re(qr(\w)), 'type' => 'publicid'},
                'multistate' => {
                    'values' => {
                        'check_statistics' => re(qr(\w)),
                        'working'          => re(qr(\w)),
                        'deleted'          => re(qr(\w)),
                        'need_update'      => re(qr(\w)),
                        'updating'         => re(qr(\w)),
                    },
                    'label' => re(qr(\w)),
                    'type'  => 'multistate'
                },
                'campaign_id' => {'label' => re(qr(\w)), 'type' => 'number'},
                'create_date' => {'label' => re(qr(\w)), 'type' => 'date'},
                'page_id'     => {'label' => re(qr(\w)), 'type' => 'number'},
                'public_id'   => {'type'  => 'text'},
                'resource'    => {
                    'label'  => 'Resource',
                    'type'   => 'dictionary',
                    'values' => ignore(),
                },
                'site_version' => {
                    'label'  => 'Site version',
                    'type'   => 'dictionary',
                    'values' => [
                        {
                            'id'    => 'desktop',
                            'key'   => 'desktop',
                            'label' => 'Desktop'
                        },
                        {
                            'id'    => 'mobile',
                            'key'   => 'mobile',
                            'label' => 'Mobile'
                        },
                        {
                            'id'    => 'turbo',
                            'key'   => 'turbo',
                            'label' => 'Turbo-pages'
                        },
                        {
                            'id'    => 'turbo_desktop',
                            'key'   => 'turbo_desktop',
                            'label' => 'Turbo-pages desktop'
                        }
                    ]
                },
                'show_video' => {'type' => 'boolean'},
                'strategy'   => {
                    'values' => [
                        {
                            'label' => re(qr(\w)),
                            'id'    => 1,
                            'key'   => 'id1'
                        },
                        {
                            'label' => re(qr(\w)),
                            'id'    => 3,
                            'key'   => 'id3'
                        },
                        {
                            'label' => re(qr(\w)),
                            'id'    => 0,
                            'key'   => 'id0'
                        }
                    ],
                    'label' => re(qr(\w)),
                    'type'  => 'dictionary'
                },
                'mincpm' => {
                    'label' => re(qr(\w)),
                    'type'  => 'number'
                },
                'text_cpm' => {
                    'label' => re(qr(\w)),
                    'type'  => 'number'
                },
                'text_blocked' => {
                    'label' => re(qr(\w)),
                    'type'  => 'boolean'
                },
                'media_cpm' => {
                    'label' => re(qr(\w)),
                    'type'  => 'number'
                },
                'media_blocked' => {
                    'label' => re(qr(\w)),
                    'type'  => 'boolean'
                },
                'video_cpm' => {
                    'label' => re(qr(\w)),
                    'type'  => 'number'
                },
                'video_blocked' => {
                    'label' => re(qr(\w)),
                    'type'  => 'boolean'
                },
            },
            'entity_filter_fields'
        );

        cmp_deeply(
            [sort {$a->{name} cmp $b->{name}} @{$level->{'entity_filter_simple_fields'}}],
            [
                {'name' => 'campaign.all_domain',    'label' => re(qr(\w))},
                {'name' => 'campaign_id',            'label' => re(qr(\w))},
                {'name' => 'caption',                'label' => re(qr(\w))},
                {'name' => 'id',                     'label' => re(qr(\w))},
                {'name' => 'managers.manager.login', 'label' => re(qr(\w))},
                {'name' => 'multistate',             'label' => re(qr(\w))},
                {'name' => 'site_version',           'label' => re(qr(\w))},
            ],
            'entity_filter_simple_fields'
        );

        cmp_deeply(sort_fields($level->{'fields'}),
            sort_fields([grep {$_->{id} !~ /_w_nds$/} @$fields_internal_advnet_context_on_site_rtb]), 'fields');

        cmp_deeply(sort_fields($app->statistics->get_level($level_id)->get_fields()),
            sort_fields($fields_internal_advnet_context_on_site_rtb), 'get_fields');

        cmp_deeply($level->{'has_raw_stat'}, '', 'has_raw_stat');

        cmp_deeply($level->{'id'}, $level_id, 'id');
    },
    locale => "C",
);
