use Test::Partner2::Simple;

use Test::Most;
use Test::Deep qw(cmp_deeply ignore);
use Test::Differences qw( eq_or_diff );

use Test::Partner2::Statistics::Subs qw( _mock_app_with_hands_and_dbh restore_tables _do _cmp_bag );

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my (undef, undef, $stat_add_recs) = _mock_app_with_hands_and_dbh($app);

        my $table_dumps_dir = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01/table_dumps';
        my $data_dir        = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01';
        my $hands_dir       = "$data_dir/hands";

        {
            no strict 'refs';
            no warnings 'redefine';
            *{'QBit::Application::check_rights'} = sub {$_[1] !~ /^statistics[a-z_]+always_view$/;};
        }

        restore_tables(
            $app->partner_db->get_dbh, $table_dumps_dir, qw(
              users
              internal_site
              internal_context_on_site_campaign
              internal_context_on_site_rtb
              )
        );

        my %currencies = (1 => 'USD', 2 => 'RUB', 3 => 'EUR',);
        $app->partner_db->get_dbh->do("INSERT INTO currencies (id, code) VALUES  (?, ?), (?, ?), (?, ?) ;",
            {}, %currencies);

        ##### 1
        {
            my $sort_func = sub {
                     $a->{'campaign_id'} <=> $b->{'campaign_id'}
                  || $a->{'block_id'} <=> $b->{'block_id'}
                  || $a->{'dsp_id'} <=> $b->{'dsp_id'}
                  || $a->{'currency_id'} <=> $b->{'currency_id'};
            };

            $app->statistics_internal_advnet_context_on_site_rtb->_get_stat_from_balance(
                map {$_ => curdate(oformat => 'db')} qw(from to));

            my $file_path = "$data_dir/_get_stat_from_balance/internal_context_on_site_rtb.json";
            my $expect    = [sort $sort_func @{_do($file_path)}];
            my $got       = [sort $sort_func @$stat_add_recs];

            cmp_deeply($got, $expect, '_get_stat_from_balance is correct');

            if (need_self_update()) {
                writefile($file_path, to_json($got, pretty => TRUE));
            }
        }

        ##### 2
        {
            my %get_statistics_arguments = (
                dimension_fields => [],
                entity_fields    => ["public_id",],
                fields           => [
                    "rtb_block_shows",         "rtb_block_cpm_all_wo_nds",
                    "rtb_block_cpm_all_w_nds", "rtb_all_wo_nds",
                    "rtb_all_w_nds",
                ],
                levels => [{id => "internal_advnet_context_on_site_rtb",},],
                period => "today",
                total  => 0,
                vat    => 2,
            );

            $app->statistics_internal_advnet_context_on_site_rtb->update_statistics(
                storage => 'clickhouse',
                map {$_ => curdate(oformat => 'db')} qw(from to)
            );

            my $sort_func = sub {
                $a->{'public_id'} cmp $b->{'public_id'}
                  || $a->{'currency_id'} <=> $b->{'currency_id'};
            };

            my $file_path = "$data_dir/get_statistics/internal_context_on_site_rtb.json";
            my $expect    = [sort $sort_func @{_do($file_path)}];
            my $got       = [sort $sort_func @{$app->statistics->get_statistics(%get_statistics_arguments)->{'data'}}];

            cmp_deeply($got, $expect, 'get_statistics is correct');
        }
    },
    locale               => "en",
    fill_databases       => 0,
    create_clickhouse_db => TRUE,
    mocks                => [qw(mock_check_statistics_by_blocks)],
    do_not_die_on_fail   => need_self_update() ? 1 : 0
);
