use Test::Partner2::Simple;

use Test::Most;
use Test::Deep qw(cmp_deeply ignore);
use Test::Differences qw( eq_or_diff );

use Test::Partner2::Statistics::Subs qw( _mock_app_with_hands_and_dbh restore_tables _do );

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        _mock_app_with_hands_and_dbh($app);

        my $table_dumps_dir = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01/table_dumps';
        my $data_dir        = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01';
        my $hands_dir       = "$data_dir/hands";

        {
            no strict 'refs';
            no warnings 'redefine';
            *{'QBit::Application::check_rights'} = sub {$_[1] !~ /^statistics[a-z_]+always_view$/;};
        }

        restore_tables(
            $app->partner_db->get_dbh, $table_dumps_dir, qw(
              users
              internal_site
              internal_context_on_site_campaign
              internal_context_on_site_stripe
              )
        );

        my %currencies = (1 => 'USD', 2 => 'RUB', 3 => 'EUR',);
        $app->partner_db->get_dbh->do("INSERT INTO currencies (id, code) VALUES  (?, ?), (?, ?), (?, ?) ;",
            {}, %currencies);

        my %get_statistics_arguments = (
            dimension_fields => [],
            entity_fields    => ["public_id",],
            fields           => [
                "stripe_hits",           "stripe_shows",         "stripe_clicks",          "stripe_ctr",
                "stripe_cpm_all_wo_nds", "stripe_cpm_all_w_nds", "stripe_cpmh_all_wo_nds", "stripe_cpmh_all_w_nds",
                "stripe_cpc_all_wo_nds", "stripe_cpc_all_w_nds", "stripe_all_wo_nds",      "stripe_all_w_nds",
            ],
            levels => [{id => "internal_advnet_context_on_site_stripe",},],
            period => "today",
            total  => 0,
            vat    => 2,
        );

        my $_get_stat_from_balance_data = [
            sort {
                     $a->{'campaign_id'} <=> $b->{'campaign_id'}
                  || $a->{'block_id'} <=> $b->{'block_id'}
                  || $a->{'currency_id'} <=> $b->{'currency_id'}
              } @{_do("$data_dir/_get_stat_from_balance/internal_context_on_site_stripe.json")}
        ];

        rename_internal_context_on_site_stripe_fields($_get_stat_from_balance_data);

        is_deeply(
            [
                sort {
                         $a->{'campaign_id'} <=> $b->{'campaign_id'}
                      || $a->{'block_id'} <=> $b->{'block_id'}
                      || $a->{'currency_id'} <=> $b->{'currency_id'}
                  } @{
                    $app->statistics_internal_advnet_context_on_site_stripe->_get_stat_from_balance(
                        map {
                            $_ => curdate(oformat => 'db')
                          } qw(from to)
                    )
                  }
            ],
            $_get_stat_from_balance_data,
            '_get_stat_from_balance is correct'
        );

        $app->statistics_internal_advnet_context_on_site_stripe->update_statistics(
            storage => 'clickhouse',
            map {$_ => curdate(oformat => 'db')} qw(from to)
        );

        my $update_statistics_data =
          [sort {$a->{'public_id'} cmp $b->{'public_id'} || $a->{'currency_id'} <=> $b->{'currency_id'}}
              @{_do("$data_dir/get_statistics/internal_context_on_site_stripe.json")}];

        is_deeply(
            [
                sort {$a->{'public_id'} cmp $b->{'public_id'} || $a->{'currency_id'} <=> $b->{'currency_id'}}
                  @{$app->statistics->get_statistics(%get_statistics_arguments)->{'data'}}
            ],
            $update_statistics_data,
            'get_statistics is correct'
        );
    },
    locale               => "en",
    fill_databases       => 0,
    create_clickhouse_db => TRUE,
    mocks                => [qw(mock_check_statistics_by_blocks)],
);

sub rename_internal_context_on_site_stripe_fields {
    my ($data) = @_;

    my $prefix = 'stripe_';
    my @move   = qw(
      hits
      shows
      clicks
      ctr
      cpm_all_wo_nds
      cpm_all_w_nds
      cpmh_all_wo_nds
      cpmh_all_w_nds
      cpc_all_wo_nds
      cpc_all_w_nds
      );
    my @copy = qw(
      all_wo_nds
      all_w_nds
      );

    foreach my $item (@$data) {
        foreach my $param (@move) {
            if (exists($item->{$param})) {
                $item->{$prefix . $param} = $item->{$param};
                delete($item->{$param});
            }
        }
        $item->{$prefix . $_} = $item->{$_} foreach @copy;
    }
}
