use Test::Partner2::Simple;

use Test::Most;
use Test::Deep qw(cmp_deeply ignore);
use Test::Differences qw( eq_or_diff );

use Test::Partner2::Statistics::Subs qw( _mock_app_with_hands_and_dbh restore_tables _do );

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        _mock_app_with_hands_and_dbh($app);

        my $table_dumps_dir = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01/table_dumps';
        my $data_dir        = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01';

        {
            no strict 'refs';
            no warnings 'redefine';
            *{'QBit::Application::check_rights'} = sub {$_[1] !~ /^statistics[a-z_]+always_view$/;};
        }

        restore_tables(
            $app->partner_db->get_dbh, $table_dumps_dir, qw(
              users
              internal_site
              internal_context_on_site_campaign
              internal_context_on_site_stripe
              internal_context_on_site_rtb
              internal_context_on_site_direct
              )
        );

        my %currencies = (1 => 'USD', 2 => 'RUB', 3 => 'EUR',);
        $app->partner_db->get_dbh->do("INSERT INTO currencies (id, code) VALUES  (?, ?), (?, ?), (?, ?) ;",
            {}, %currencies);

        $app->statistics_internal_advnet_context_on_site_direct->update_statistics(
            storage => 'clickhouse',
            map {$_ => curdate(oformat => 'db')} qw(from to)
        );
        $app->statistics_internal_advnet_context_on_site_rtb->update_statistics(
            storage => 'clickhouse',
            map {$_ => curdate(oformat => 'db')} qw(from to)
        );
        $app->statistics_internal_advnet_context_on_site_stripe->update_statistics(
            storage => 'clickhouse',
            map {$_ => curdate(oformat => 'db')} qw(from to)
        );

        ##### 1
        {
            my %get_statistics_arguments = (
                dimension_fields => [],
                entity_fields    => [],
                fields           => ["all_wo_nds", "all_w_nds",],
                levels           => [{id => "internal_advnet_context_on_site",},],
                period           => "today",
                total            => 0,
                vat              => 2,
            );

            my $sort_func = sub {$a->{'currency_id'} <=> $b->{'currency_id'}};

            my $file_path = "$data_dir/get_statistics/internal_advnet_context_on_site.json";
            my $expect    = [sort $sort_func @{_do($file_path)}];
            my $got       = [sort $sort_func @{$app->statistics->get_statistics(%get_statistics_arguments)->{'data'}}];

            cmp_deeply($got, $expect, 'get_statistics is correct without addition fields');

            if (need_self_update()) {
                writefile($file_path, to_json($got, pretty => TRUE));
            }
        }

        ##### 2
        {
            my $sort_func = sub {$a->{'campaign_id'} <=> $b->{'campaign_id'}};

            my $file_path = "$data_dir/_get_stat_from_balance/internal_advnet_context_on_site_page.json";
            my $expect    = [sort $sort_func @{_do($file_path)}];
            my $got       = [
                sort $sort_func @{
                    $app->statistics_internal_advnet_context_on_site->_get_stat_from_balance(
                        map {$_ => curdate(oformat => 'db')} qw(from to)
                    )
                  }
            ];

            cmp_deeply($got, $expect, '_get_stat_from_balance is correct');

            if (need_self_update()) {
                writefile($file_path, to_json($got, pretty => TRUE));
            }
        }

        $app->statistics_internal_advnet_context_on_site->update_statistics(
            storage => 'clickhouse',
            map {$_ => curdate(oformat => 'db')} qw(from to)
        );

        my %get_statistics_arguments = (
            dimension_fields => [],
            entity_fields    => [],
            fields           => [
                "an_fraud_shows",               "an_fraud_clicks",
                "an_cover_direct_hits",         "an_cover_mcb_hits",
                "an_cover_senthits",            "an_rtb_cover_hits",
                "an_rtb_cover_senthits",        "an_rtb_cover_direct_hits",
                "direct_context_page_ad_shows", "an_cover_hits",
            ],
            levels => [{id => "internal_advnet_context_on_site"},],
            period => "today",
            total  => 0,
            vat    => -1,
        );

        ##### 3
        {
            my $sort_func = sub {$a->{'currency_id'} <=> $b->{'currency_id'}};

            my $file_path              = "$data_dir/get_statistics/internal_advnet_context_on_site_page.json";
            my $update_statistics_data = [sort $sort_func @{_do($file_path)}];
            my $got = [sort $sort_func @{$app->statistics->get_statistics(%get_statistics_arguments)->{'data'}}];

            cmp_deeply($got, $update_statistics_data, 'get_statistics is correct');

            if (need_self_update()) {
                writefile($file_path, to_json($got, pretty => TRUE));
            }
        }

        ##### 4
        {
            my $sort_func = sub {$a->{'currency_id'} <=> $b->{'currency_id'}};

            my $file_path = "$data_dir/get_statistics/internal_advnet_context_on_site_page__mix_fields.json";
            my $update_statistics_data = [sort $sort_func @{_do($file_path)}];
            my $got                    = [
                sort $sort_func @{
                    $app->statistics->get_statistics(
                        %get_statistics_arguments,
                        fields => ["an_fraud_shows", "an_fraud_clicks", "all_w_nds", "direct_context_ads"],
                        vat    => 0
                      )->{'data'}
                  }
            ];

            cmp_deeply($got, $update_statistics_data, 'get_statistics with mix fields is correct');

            if (need_self_update()) {
                writefile($file_path, to_json($got, pretty => TRUE));
            }
        }
    },
    locale               => "en",
    fill_databases       => 0,
    create_clickhouse_db => TRUE,
    mocks                => [qw(mock_check_statistics_by_blocks)],
    do_not_die_on_fail   => need_self_update() ? 1 : 0
);
