use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_internal_search_on_site_campaign_db_filter_fields);

use Test::Most;
use Test::Deep qw(cmp_deeply ignore);
use Test::Differences qw( eq_or_diff );

use Test::Partner2::Statistics::Data qw(
  @common_fields
  $entity_filter_field_managers
  $fields_internal_advnet_search_on_site_direct
  $fields_internal_advnet_search_on_site_direct
  $common_filter_fields
  );
use Test::Partner2::Statistics::Subs qw(sort_fields _mock_app_with_hands_and_dbh build_statistics_levels );

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        _mock_app_with_hands_and_dbh($app);

        {
            no strict 'refs';
            no warnings 'redefine';
            *{'QBit::Application::check_rights'} = sub {TRUE};
        }

        my %currencies = (1 => 'USD', 2 => 'RUB', 3 => 'EUR',);
        $app->partner_db->get_dbh->do("INSERT INTO currencies (id, code) VALUES  (?, ?), (?, ?), (?, ?) ;",
            {}, %currencies);

        my $tree     = $app->statistics->get_tree();
        my $levels   = build_statistics_levels($tree);
        my $level_id = 'internal_advnet_search_on_site_direct';
        my $level    = $levels->{$level_id};

        cmp_deeply(
            $level->{'conflict_fields'},
            [
                ['public_id', 'tag_id'],
                ['caption',   'tag_id'],
                ['type',      'tag_id'],
                ['public_id', 'tag_caption'],
                ['caption',   'tag_caption'],
                ['type',      'tag_caption'],
            ],
            'conflict_fields'
        );

        cmp_deeply(
            $level->{'dimension_fields'},
            [
                @common_fields,
                {
                    'verbatim' => 1,
                    'type'     => 'number',
                    'title'    => re(qr(\w)),
                    'id'       => 'tag_id',
                    'sort_as'  => 'number',
                },
                {
                    'verbatim'   => 1,
                    'type'       => 'dictionary',
                    'title'      => re(qr(\w)),
                    'id'         => 'tag_caption',
                    'only_group' => 1,
                }
            ],
            'dimension_fields'
        );

        cmp_deeply(
            $level->{'entity_fields'},
            [
                {'verbatim' => 1, 'type' => 'text', 'label' => re(qr(\w)), 'id' => 'domain', 'only_group' => 1},
                {'type' => 'page_id',   'label' => re(qr(\w)), 'id' => 'campaign_id', 'only_group' => 1},
                {'type' => 'public_id', 'label' => re(qr(\w)), 'id' => 'public_id',   'only_group' => 1},
                {'verbatim' => 1, 'type' => 'text', 'label' => re(qr(\w)), 'id' => 'caption', 'only_group' => 1},
                {'verbatim' => 1, 'type' => 'text', 'label' => re(qr(\w)), 'id' => 'type',    'only_group' => 1},
                {'id' => 'domain_id',            'only_group' => 1},
                {'id' => 'internal_campaign_id', 'only_group' => 1},
            ],
            'entity_fields'
        );

        cmp_deeply(
            $level->{'entity_filter_fields'},
            {
                %$common_filter_fields,
                'caption'  => {'label' => re(qr(\w)), 'type' => 'text'},
                'campaign' => {
                    'subfields' => get_internal_search_on_site_campaign_db_filter_fields($app),
                    'label'     => re(qr(\w)),
                    'type'      => 'subfilter'
                },
                'page' => {
                    'subfields' => get_internal_search_on_site_campaign_db_filter_fields($app),
                    'label'     => re(qr(\w)),
                    'type'      => 'subfilter'
                },
                'managers'   => $entity_filter_field_managers,
                'id'         => {'label' => re(qr(\w)), 'type' => 'publicid'},
                'multistate' => {
                    'values' => {
                        'check_statistics' => re(qr(\w)),
                        'working'          => re(qr(\w)),
                        'deleted'          => re(qr(\w)),
                        'need_update'      => re(qr(\w)),
                        'updating'         => re(qr(\w)),

                    },
                    'label' => re(qr(\w)),
                    'type'  => 'multistate'
                },
                'page_id'     => {'label' => re(qr(\w)), 'type' => 'number'},
                'public_id'   => {'type'  => 'text'},
                'campaign_id' => {'label' => re(qr(\w)), 'type' => 'number'},
                'resource'    => {
                    'label'  => 'Resource',
                    'type'   => 'dictionary',
                    'values' => ignore(),
                },
            },
            'entity_filter_fields'
        );

        cmp_deeply(
            $level->{'entity_filter_simple_fields'},
            [
                [
                    {'name' => 'managers.manager.login', 'label' => re(qr(\w))},
                    {'name' => 'id',                     'label' => re(qr(\w))},
                    {'name' => 'campaign_id',            'label' => re(qr(\w))}
                ],
                [
                    {'name' => 'caption',             'label' => re(qr(\w))},
                    {'name' => 'campaign.all_domain', 'label' => re(qr(\w))},
                    {'name' => 'multistate',          'label' => re(qr(\w))}
                ]
            ],
            'entity_filter_simple_fields'
        );

        cmp_deeply(sort_fields($level->{'fields'}),
            sort_fields([grep {$_->{id} !~ /_w_nds$/} @$fields_internal_advnet_search_on_site_direct]), 'fields');

        cmp_deeply(sort_fields($app->statistics->get_level($level_id)->get_fields()),
            sort_fields($fields_internal_advnet_search_on_site_direct), 'get_fields');

        cmp_deeply($level->{'has_raw_stat'}, '', 'has_raw_stat');

        cmp_deeply($level->{'id'}, $level_id, 'id');
    },
    locale => "C",
);
