use Test::Partner2::Simple;

use Test::Most;
use Test::Deep qw(cmp_deeply ignore);
use Test::Differences qw( eq_or_diff );

use Test::Partner2::Statistics::Subs qw( _mock_app_with_hands_and_dbh _do restore_tables );

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        _mock_app_with_hands_and_dbh($app);

        my $table_dumps_dir = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01/table_dumps';
        my $data_dir        = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01';
        my $hands_dir       = "$data_dir/hands";

        {
            no strict 'refs';
            no warnings 'redefine';
            *{'QBit::Application::check_rights'} = sub {$_[1] !~ /^statistics[a-z_]+always_view$/;};
        }

        restore_tables(
            $app->partner_db->get_dbh, $table_dumps_dir, qw(
              users
              internal_site
              internal_search_on_site_campaign
              internal_search_on_site_premium
              )
        );

        my %currencies = (1 => 'USD', 2 => 'RUB', 3 => 'EUR',);
        $app->partner_db->get_dbh->do("INSERT INTO currencies (id, code) VALUES  (?, ?), (?, ?), (?, ?) ;",
            {}, %currencies);

        ##### 1
        {
            my $sort_func = sub {
                $a->{'campaign_id'} <=> $b->{'campaign_id'}
                  || $a->{'block_id'} <=> $b->{'block_id'}
                  || $a->{'currency_id'} <=> $b->{'currency_id'};
            };

            my $file_path = "$data_dir/_get_stat_from_balance/internal_search_on_site_premium.json";
            my $expect    = [sort $sort_func @{_do($file_path)}];
            my $got       = [
                sort $sort_func @{
                    $app->statistics_internal_advnet_search_on_site_premium->_get_stat_from_balance(
                        map {$_ => curdate(oformat => 'db')} qw(from to)
                    )
                  }
            ];

            cmp_deeply($got, $expect, '_get_stat_from_balance is correct');

            if (need_self_update()) {
                use JSON::PP qw();
                my $json = JSON::PP->new->ascii->pretty->allow_nonref->allow_bignum->canonical;
                writefile($file_path, $json->encode($got));
            }
        }

        $app->statistics_internal_advnet_search_on_site_premium->update_statistics(
            storage => 'clickhouse',
            map {$_ => curdate(oformat => 'db')} qw(from to)
        );

        ##### 1
        {
            my %get_statistics_arguments = (
                dimension_fields => [],
                entity_fields    => ["public_id",],
                fields           => [
                    "premium_shows",          "premium_clicks",
                    "premium_cpm_all_wo_nds", "premium_cpm_all_w_nds",
                    "premium_cpc_all_wo_nds", "premium_cpc_all_w_nds",
                    "premium_all_wo_nds",     "premium_all_w_nds",
                ],
                levels => [{id => "internal_advnet_search_on_site_premium",},],
                period => "today",
                total  => 0,
                vat    => 2,
            );

            my $sort_func =
              sub {$a->{'public_id'} cmp $b->{'public_id'} || $a->{'currency_id'} <=> $b->{'currency_id'}};

            my $file_path              = "$data_dir/get_statistics/internal_search_on_site_premium.json";
            my $update_statistics_data = [sort $sort_func @{_do($file_path)}];
            my $got = [sort $sort_func @{$app->statistics->get_statistics(%get_statistics_arguments)->{'data'}}];

            cmp_deeply($got, $update_statistics_data, 'get_statistics is correct');

            if (need_self_update()) {
                writefile($file_path, to_json($got, pretty => TRUE));
            }
        }
    },
    locale               => "en",
    fill_databases       => 0,
    create_clickhouse_db => TRUE,
    mocks                => [qw(mock_check_statistics_by_blocks)],
    do_not_die_on_fail   => need_self_update() ? 1 : 0
);
