use Test::Partner2::Simple;

use Test::Most;
use Test::Deep qw(cmp_deeply ignore);
use Test::Differences qw( eq_or_diff );

use Test::Partner2::Statistics::Subs
  qw( unify_fields sort_fields _mock_app_with_hands_and_dbh build_statistics_levels );
use Test::Partner2::Statistics::Data qw(
  $dimension_field_date
  $dimension_field_currency_id
  $dimension_field_public_id
  $fields_internal_advnet_search_on_site_page
  $fields_internal_advnet_search_on_site_direct
  $fields_internal_advnet_search_on_site_premium
  );

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        _mock_app_with_hands_and_dbh($app);

        my %currencies = (1 => 'USD', 2 => 'RUB', 3 => 'EUR',);
        $app->partner_db->get_dbh->do("INSERT INTO currencies (id, code) VALUES  (?, ?), (?, ?), (?, ?) ;",
            {}, %currencies);

        {
            no strict 'refs';
            no warnings 'redefine';
            *{'QBit::Application::check_rights'} = sub {TRUE};
        }

        my $tree     = $app->statistics->get_tree();
        my $levels   = build_statistics_levels($tree);
        my $level_id = 'internal_advnet_search_on_site';
        my $level    = $levels->{$level_id};

        cmp_deeply(
            $level->{'conflict_fields'},
            [["public_id", "tag_id"], ["public_id", "tag_caption"]],
            'conflict_fields'
        );

        cmp_deeply(
            $level->{'dimension_fields'},
            [$dimension_field_date, $dimension_field_currency_id, $dimension_field_public_id],
            'dimension_fields'
        );

        cmp_deeply(
            $level->{'entity_fields'},
            [
                {'type' => 'page_id', 'label' => re(qr(\w)), 'id' => 'id', 'only_group' => 1},
                {'verbatim' => 1, 'type' => 'text', 'label' => re(qr(\w)), 'id' => 'domain', 'only_group' => 1},
                {'id' => 'site_id', 'only_group' => 1},
            ],
            'entity_fields'
        );

        cmp_deeply(
            $level->{'entity_filter_simple_fields'},
            [
                [
                    {
                        'name'  => 'managers.manager.login',
                        'label' => re(qr(\w))
                    },
                    {
                        'name'  => 'id',
                        'label' => re(qr(\w))
                    }
                ],
                [
                    {
                        'name'  => 'all_domain',
                        'label' => re(qr(\w))
                    },
                    {
                        'name'  => 'multistate',
                        'label' => re(qr(\w))
                    }
                ]
            ],
            'entity_filter_simple_fields'
        );

        my $fields = [
            unify_fields(
                @$fields_internal_advnet_search_on_site_page, @$fields_internal_advnet_search_on_site_premium,
                @$fields_internal_advnet_search_on_site_direct,
            ),
            {
                'hint'        => re(qr(\w)),
                'type'        => 'money',
                'title'       => re(qr(\w)),
                'id'          => 'all_w_nds',
                'short_title' => re(qr(\w)),
                'shared'      => TRUE,
                'category'    => ignore(),
            },
            {
                'hint'        => re(qr(\w)),
                'type'        => 'money',
                'title'       => re(qr(\w)),
                'id'          => 'all_wo_nds',
                'short_title' => re(qr(\w)),
                'shared'      => TRUE,
                'category'    => ignore(),
                'section'     => 'default',
            },
        ];

        cmp_deeply(sort_fields($level->{'fields'}), sort_fields([grep {$_->{id} !~ /_w_nds$/} @$fields]), 'fields');

        cmp_deeply(sort_fields($app->statistics->get_level($level_id)->get_fields()),
            sort_fields($fields), 'get_fields');

        cmp_deeply($level->{'has_raw_stat'}, '', 'has_raw_stat');

        cmp_deeply($level->{'id'}, $level_id, 'id');
    },
    locale         => "C",
    fill_databases => 0
);
