use Test::Partner2::Simple;

use Test::Most;
use Test::Deep qw(cmp_deeply ignore);
use Test::Differences qw( eq_or_diff );

use Test::Partner2::Statistics::Data
  qw(@common_fields $fields_internal_mobile_app_rtb $entity_filter_field_managers $common_filter_fields);
use Test::Partner2::Statistics::Subs
  qw( _mock_app_with_hands_and_dbh unify_fields sort_fields build_statistics_levels restore_tables _do );

use qbit;

run_tests(
    sub {
        my ($app) = @_;
        _mock_app_with_hands_and_dbh($app);

        my %currencies = (1 => 'USD', 2 => 'RUB', 3 => 'EUR',);
        $app->partner_db->get_dbh->do("INSERT INTO currencies (id, code) VALUES  (?, ?), (?, ?), (?, ?) ;",
            {}, %currencies);

        my $tree     = $app->statistics->get_tree();
        my $levels   = build_statistics_levels($tree);
        my $level_id = 'internal_mobile_app_rtb';
        my $level    = $levels->{$level_id};

        cmp_deeply($level->{'conflict_fields'}, [], 'conflict_fields');

        cmp_deeply(
            $level->{'dimension_fields'},
            [
                @common_fields,
                {
                    'ajax'     => 1,
                    'verbatim' => 1,
                    'type'     => 'dictionary',
                    'title'    => re(qr(\w)),
                    'id'       => 'dsp_id_name',
                    'sort_as'  => 'number',
                },
                {
                    'verbatim' => 1,
                    'type'     => 'dictionary',
                    'title'    => re(qr(\w)),
                    'id'       => 'dsp_caption',
                    'ajax'     => 1
                },
                {
                    'id'       => 'tag_id',
                    'sort_as'  => 'number',
                    'title'    => re(qr(\w)),
                    'type'     => 'number',
                    'verbatim' => 1,
                },
                {
                    'id'         => 'tag_caption',
                    'title'      => re(qr(\w)),
                    'type'       => 'dictionary',
                    'verbatim'   => 1,
                    'only_group' => 1,
                },
                {
                    'sort_as'  => 'text',
                    'ajax'     => 1,
                    'verbatim' => 1,
                    'type'     => 'dictionary',
                    'title'    => re(qr(\w)),
                    'id'       => 'internal_mobile_caption'
                }
            ],
            'dimension_fields'
        );

        cmp_deeply(
            $level->{'entity_fields'},
            [
                {
                    'verbatim'   => 1,
                    'type'       => 'text',
                    'label'      => re(qr(\w)),
                    'id'         => 'store_id',
                    'only_group' => 1,
                },
                {
                    'type'       => 'page_id',
                    'label'      => re(qr(\w)),
                    'id'         => 'page_id',
                    'only_group' => 1,
                },
                {
                    'type'       => 'public_id',
                    'label'      => re(qr(\w)),
                    'id'         => 'public_id',
                    'only_group' => 1,
                },
                {
                    'verbatim'   => 1,
                    'type'       => 'text',
                    'label'      => re(qr(\w)),
                    'id'         => 'caption',
                    'only_group' => 1,
                },
                {
                    'verbatim'   => 1,
                    'type'       => 'text',
                    'label'      => re(qr(\w)),
                    'id'         => 'direct_block',
                    'only_group' => 1,
                },
                {
                    'verbatim'   => 1,
                    'type'       => 'text',
                    'label'      => re(qr(\w)),
                    'id'         => 'media_formats_list',
                    'only_group' => 1,
                },
                {
                    'verbatim'   => 1,
                    'type'       => 'text',
                    'label'      => re(qr(\w)),
                    'id'         => 'block_type_label',
                    'only_group' => 1,
                }
            ],
            'entity_fields'
        );

        my $page = {
            'subfields' => {
                'store_id' => {
                    'label' => re(qr(\w)),
                    'type'  => 'text'
                },
                'caption' => {
                    'label' => re(qr(\w)),
                    'type'  => 'text'
                },
                'create_date' => {
                    'label' => re(qr(\w)),
                    'type'  => 'date'
                },
                'type' => {
                    'values' => [
                        {
                            'id'    => 1,
                            'label' => re(qr(\w)),
                            'key'   => 'id1'
                        },
                        {
                            'id'    => 2,
                            'label' => re(qr(\w)),
                            'key'   => 'id2'
                        }
                    ],
                    'label' => re(qr(\w)),
                    'type'  => 'dictionary'
                },
                'id' => {
                    'label' => re(qr(\w)),
                    'type'  => 'number'
                },
                'page_id' => {
                    'label' => 'Page ID',
                    'type'  => 'number'
                },
                'multistate' => {
                    'values' => {
                        'stopped'          => re(qr(\w)),
                        'testing'          => re(qr(\w)),
                        'check_statistics' => re(qr(\w)),
                        'working'          => re(qr(\w)),
                        'deleted'          => re(qr(\w)),
                        'protected'        => re(qr(\w)),
                        'need_update'      => re(qr(\w)),
                        'updating'         => re(qr(\w)),
                    },
                    'label' => re(qr(\w)),
                    'type'  => 'multistate'
                },
                'managers'    => $entity_filter_field_managers,
                'update_time' => {
                    'label' => re(qr(\w)),
                    'type'  => 'date'
                },
                'send_time' => {
                    'label' => re(qr(\w)),
                    'type'  => 'date'
                },
                'tier' => {
                    label  => ignore(),
                    type   => 'dictionary',
                    values => ignore(),
                },
                creator_id => {
                    'label' => re(qr(\w)),
                    'type'  => 'number'
                },
                'caption_text' => {
                    label => ignore(),
                    type  => 'text',
                },
                'domain_text' => {
                    label => ignore(),
                    type  => 'text',
                },
            },
            'label' => re(qr(\w)),
            'type'  => 'subfilter'
        };
        cmp_deeply(
            $level->{'entity_filter_fields'},
            {
                %$common_filter_fields,
                'caption' => {
                    'label' => re(qr(\w)),
                    'type'  => 'text'
                },
                'page'        => $page,
                'application' => $page,
                'id'          => {
                    'label' => re(qr(\w)),
                    'type'  => 'publicid'
                },
                'multistate' => {
                    'values' => {
                        'check_statistics' => re(qr(\w)),
                        'working'          => re(qr(\w)),
                        'deleted'          => re(qr(\w)),
                        'need_update'      => re(qr(\w)),
                        'updating'         => re(qr(\w)),
                    },
                    'label' => re(qr(\w)),
                    'type'  => 'multistate'
                },
                'application_id' => {
                    'label' => re(qr(\w)),
                    'type'  => 'number'
                },
                'block_type' => {
                    'label'  => re(qr(\w)),
                    'type'   => 'dictionary',
                    'values' => ignore()
                },
                'create_date' => {
                    'label' => re(qr(\w)),
                    'type'  => 'date'
                },
                'is_custom_bk_data' => {
                    'label' => 'Custom BK data enabled',
                    'type'  => 'boolean'
                },
                'managers' => $entity_filter_field_managers,
                'page_id'  => {
                    'label' => re(qr(\w)),
                    'type'  => 'number'
                },
                'public_id' => {'type' => 'text'},
                'resource'  => {
                    'label'  => 'Resource',
                    'type'   => 'dictionary',
                    'values' => ignore(),
                },
                'show_video' => {'type' => 'boolean'},
            },
            'entity_filter_fields'
        );

        cmp_deeply(
            $level->{'entity_filter_simple_fields'},
            [
                [
                    {
                        'name'  => 'managers.manager.login',
                        'label' => re(qr(\w))
                    },
                    {
                        'name'  => 'id',
                        'label' => re(qr(\w))
                    },
                    {
                        'name'  => 'caption',
                        'label' => re(qr(\w))
                    },
                    {
                        'name'  => 'multistate',
                        'label' => re(qr(\w))
                    }
                ],
                [
                    {
                        'name'  => 'page_id',
                        'label' => re(qr(\w))
                    },
                    {
                        'name'  => 'application.store_id',
                        'label' => re(qr(\w))
                    },
                    {
                        'name'  => 'application.type',
                        'label' => re(qr(\w))
                    },
                    {
                        'name'  => 'block_type',
                        'label' => re(qr(\w))
                    }
                ]
            ],
            'entity_filter_simple_fields'
        );

        cmp_deeply(sort_fields($level->{'fields'}),
            sort_fields([grep {$_->{id} !~ /_w_nds$/} @$fields_internal_mobile_app_rtb]), 'fields');

        cmp_deeply(sort_fields($app->statistics->get_level($level_id)->get_fields()),
            sort_fields($fields_internal_mobile_app_rtb), 'get_fields');

        cmp_deeply($level->{'has_raw_stat'}, '', 'has_raw_stat');

        cmp_deeply($level->{'id'}, $level_id, 'id');
    },
    locale => "C",
);
