use Test::Partner2::Simple;

use Test::Most;
use Test::Deep qw(cmp_deeply ignore);
use Test::Differences qw( eq_or_diff );

use Test::Partner2::Statistics::Subs qw( _mock_app_with_hands_and_dbh sort_fields  restore_tables _do _cmp_bag);

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my (undef, undef, $stat_add_recs) = _mock_app_with_hands_and_dbh($app);

        my $table_dumps_dir = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01/table_dumps';
        my $data_dir        = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01';
        my $hands_dir       = "$data_dir/hands";

        {
            no strict 'refs';
            no warnings 'redefine';
            *{'QBit::Application::check_rights'} = sub {$_[1] !~ /^statistics[a-z_]+always_view$/;};
            *{'Application::Model::Statistics::Product::check_statistics_by_blocks'} = sub { };
        }

        restore_tables(
            $app->partner_db->get_dbh, $table_dumps_dir, qw(
              users
              dsp
              internal_mobile_app
              internal_mobile_app_rtb
              )
        );

        my %currencies = (1 => 'USD', 2 => 'RUB', 3 => 'EUR',);
        $app->partner_db->get_dbh->do("INSERT INTO currencies (id, code) VALUES  (?, ?), (?, ?), (?, ?) ;",
            {}, %currencies);

        ##### 1
        {
            my $sort_func = sub {
                     $a->{'application_id'} <=> $b->{'application_id'}
                  || $a->{'block_id'} <=> $b->{'block_id'}
                  || $a->{'dsp_id'} <=> $b->{'dsp_id'}
                  || $a->{'currency_id'} <=> $b->{'currency_id'};
            };

            $app->statistics_internal_mobile_app_rtb->_get_stat_from_balance(map {$_ => curdate(oformat => 'db')}
                  qw(from to));

            my $file_path = "$data_dir/_get_stat_from_balance/internal_mobile_app_rtb.json";
            my $expect    = [sort @{_do($file_path)}];
            my $got       = [sort $sort_func @$stat_add_recs];

            cmp_deeply($got, $expect, '_get_stat_from_balance is correct');

            if (need_self_update()) {
                writefile($file_path, to_json($got, pretty => TRUE));
            }

        }

        ##### 1
        {
            my %get_statistics_arguments = (
                dimension_fields => [],
                entity_fields    => ["page_id"],
                fields           => [
                    "mobile_rtb_block_shows",          "mobile_rtb_block_shows_own_adv",
                    "mobile_rtb_block_hits",           "mobile_rtb_block_hits_own_adv",
                    "mobile_rtb_block_hits_unsold",    "mobile_rtb_block_cpm_all_w_nds",
                    "mobile_rtb_block_cpmh_all_w_nds", "mobile_rtb_all_w_nds"
                ],
                levels => [{id => "internal_mobile_app_rtb",},],
                period => "today",
                total  => 0,
                vat    => 0,
            );

            $app->statistics_internal_mobile_app_rtb->update_statistics(
                storage => 'clickhouse',
                map {$_ => curdate(oformat => 'db')} qw(from to)
            );

            my $sort_func = sub {
                $a->{'page_id'} cmp $b->{'page_id'} || $a->{'currency_id'} <=> $b->{'currency_id'};
            };

            my $file_path = "$data_dir/get_statistics/internal_mobile_app_rtb.json";
            my $expect    = [sort $sort_func @{_do($file_path)}];
            my $got       = [sort $sort_func @{$app->statistics->get_statistics(%get_statistics_arguments)->{'data'}}];

            cmp_deeply($got, $expect, 'get_statistics is correct');

            if (need_self_update()) {
                writefile($file_path, to_json($got, pretty => TRUE));
            }
        }
    },
    fill_databases       => 0,
    create_clickhouse_db => TRUE,
    do_not_die_on_fail   => need_self_update() ? 1 : 0
);
