use Test::Partner2::Simple;

use Test::Most;
use Test::Deep qw(cmp_deeply ignore);
use Test::Differences qw( eq_or_diff );

use Test::Partner2::Statistics::Data
  qw(@common_fields $dimension_field_currency_id $dimension_field_public_id $dimension_field_internal_mobile_block_type_label $entity_filter_field_managers $fields_internal_mobile_app_rtb);
use Test::Partner2::Statistics::Subs
  qw( unify_fields sort_fields _mock_app_with_hands_and_dbh build_statistics_levels );

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        _mock_app_with_hands_and_dbh($app);

        my $table_dumps_dir = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01/table_dumps';
        my $data_dir        = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01';
        my $hands_dir       = "$data_dir/hands";

        {
            no strict 'refs';
            no warnings 'redefine';
            *{'QBit::Application::check_rights'} = sub {1};
        }

        my %currencies = (1 => 'USD', 2 => 'RUB', 3 => 'EUR',);
        $app->partner_db->get_dbh->do("INSERT INTO currencies (id, code) VALUES  (?, ?), (?, ?), (?, ?) ;",
            {}, %currencies);

        my $tree     = $app->statistics->get_tree();
        my $levels   = build_statistics_levels($tree);
        my $level_id = 'internal_mobile_app';
        my $level    = $levels->{$level_id};

        cmp_deeply($level->{'conflict_fields'}, [], 'conflict_fields');

        cmp_deeply(
            $level->{'dimension_fields'},
            [
                $common_fields[0],          $dimension_field_currency_id,
                $dimension_field_public_id, $dimension_field_internal_mobile_block_type_label
            ],
            'dimension_fields'
        );

        cmp_deeply(
            $level->{'entity_fields'},
            [
                {
                    'type'       => 'page_id',
                    'label'      => re(qr(\w)),
                    'id'         => 'page_id',
                    'only_group' => 1,
                },
                {'id' => 'store_id', 'label' => re(qr(\w)), 'type' => 'text', 'only_group' => 1,},
                {'id' => 'caption',  'label' => re(qr(\w)), 'type' => 'text', 'only_group' => 1,},
                {
                    'id'         => 'public_id',
                    'only_group' => 1
                },
            ],
            'entity_fields'
        );

        cmp_deeply(
            $level->{'entity_filter_fields'},
            {
                'store_id' => {
                    'label' => re(qr(\w)),
                    'type'  => 'text'
                },
                'caption' => {
                    'label' => re(qr(\w)),
                    'type'  => 'text'
                },
                'create_date' => {
                    'label' => re(qr(\w)),
                    'type'  => 'date'
                },
                'type' => {
                    'values' => [
                        {
                            'id'    => 1,
                            'label' => re(qr(\w)),
                            'key'   => 'id1'
                        },
                        {
                            'id'    => 2,
                            'label' => re(qr(\w)),
                            'key'   => 'id2'
                        }
                    ],
                    'label' => re(qr(\w)),
                    'type'  => 'dictionary'
                },
                'id' => {
                    'label' => re(qr(\w)),
                    'type'  => 'number'
                },
                'page_id' => {
                    'label' => 'Page ID',
                    'type'  => 'number'
                },
                'multistate' => {
                    'values' => {
                        'stopped'          => re(qr(\w)),
                        'testing'          => re(qr(\w)),
                        'check_statistics' => re(qr(\w)),
                        'working'          => re(qr(\w)),
                        'deleted'          => re(qr(\w)),
                        'protected'        => re(qr(\w)),
                        'need_update'      => re(qr(\w)),
                        'updating'         => re(qr(\w)),
                    },
                    'label' => re(qr(\w)),
                    'type'  => 'multistate'
                },
                'managers'    => $entity_filter_field_managers,
                'update_time' => {
                    'label' => re(qr(\w)),
                    'type'  => 'date'
                },
                'send_time' => {
                    'label' => re(qr(\w)),
                    'type'  => 'date'
                },
                'tier' => {
                    label  => ignore(),
                    type   => 'dictionary',
                    values => ignore(),
                },
                'creator_id' => {
                    'label' => re(qr(\w)),
                    'type'  => 'number'
                },
                'caption_text' => {
                    label => ignore(),
                    type  => 'text',
                },
                'domain_text' => {
                    label => ignore(),
                    type  => 'text',
                }
            },
            'entity_filter_fields'
        );

        cmp_deeply(
            $level->{'entity_filter_simple_fields'},
            [
                [
                    {
                        'name'  => 'managers.manager.login',
                        'label' => re(qr(\w)),
                    },
                    {
                        'name'  => 'page_id',
                        'label' => re(qr(\w)),
                    },
                    {
                        'name'  => 'store_id',
                        'label' => re(qr(\w)),
                    }
                ],
                [
                    {
                        'name'  => 'caption',
                        'label' => re(qr(\w)),
                    },
                    {
                        'name'  => 'type',
                        'label' => re(qr(\w)),
                    },
                    {
                        'name'  => 'multistate',
                        'label' => re(qr(\w)),
                    }
                ]
            ],
            'entity_filter_simple_fields'
        );

        my $fields = [
            unify_fields(@$fields_internal_mobile_app_rtb),
            {
                'hint'        => re(qr(\w)),
                'type'        => 'money',
                'title'       => re(qr(\w)),
                'id'          => 'all_w_nds',
                'short_title' => re(qr(\w)),
                'shared'      => TRUE,
                'category'    => ignore(),
            },
            {
                'hint'        => re(qr(\w)),
                'type'        => 'money',
                'title'       => re(qr(\w)),
                'id'          => 'all_wo_nds',
                'short_title' => re(qr(\w)),
                'shared'      => TRUE,
                'category'    => ignore(),
                'section'     => 'default',
            },
            {
                'shared'      => 1,
                'hint'        => re(qr(\w)),
                'category'    => 3,
                'type'        => 'money',
                'title'       => re(qr(\w)),
                'id'          => 'bad_win_price_w_nds',
                'short_title' => re(qr(\w)),
            },
            {
                'shared'      => 1,
                'hint'        => re(qr(\w)),
                'category'    => 3,
                'type'        => 'money',
                'title'       => re(qr(\w)),
                'id'          => 'bad_win_price_wo_nds',
                'short_title' => re(qr(\w)),
            }
        ];

        cmp_deeply(sort_fields($level->{'fields'}), sort_fields([grep {$_->{id} !~ /_w_nds$/} @$fields]), 'fields');

        cmp_deeply(sort_fields($app->statistics->get_level($level_id)->get_fields()),
            sort_fields($fields), 'get_fields');

        cmp_deeply($level->{'has_raw_stat'}, '', 'has_raw_stat');

        cmp_deeply($level->{'id'}, $level_id, 'id');
    },
    locale => "C"
);
