use Test::Partner2::Simple;

use Test::Most;
use Test::Deep qw(cmp_deeply ignore);
use Test::Differences qw( eq_or_diff );

use Test::Partner2::Statistics::Data qw(
  $dimension_field_date
  $dimension_field_currency_id
  $dimension_field_public_id
  $fields_internal_advnet_context_on_site_page
  $fields_internal_advnet_context_on_site_content
  $fields_internal_advnet_context_on_site_natural
  $fields_internal_advnet_context_on_site_rtb
  $fields_internal_advnet_context_on_site_direct
  $fields_internal_advnet_context_on_site_stripe
  $fields_internal_advnet_search_on_site_page
  $fields_internal_advnet_search_on_site_direct
  $fields_internal_advnet_search_on_site_premium
  $fields_internal_mobile_app_rtb
  );
use Test::Partner2::Statistics::Subs
  qw( _mock_app_with_hands_and_dbh unify_fields sort_fields build_statistics_levels );

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        _mock_app_with_hands_and_dbh($app);

        my %currencies = (1 => 'USD', 2 => 'RUB', 3 => 'EUR',);
        $app->partner_db->get_dbh->do("INSERT INTO currencies (id, code) VALUES  (?, ?), (?, ?), (?, ?) ;",
            {}, %currencies);

        my $tree     = $app->statistics->get_tree();
        my $levels   = build_statistics_levels($tree);
        my $level_id = 'yandex';
        my $level    = $levels->{$level_id};

        cmp_deeply(
            $level->{'conflict_fields'},
            [["public_id", "tag_caption"], ["public_id", "tag_id"]],
            'conflict_fields'
        );

        cmp_deeply(
            $level->{'dimension_fields'},
            [$dimension_field_date, $dimension_field_currency_id, $dimension_field_public_id],
            'dimension_fields'
        );

        cmp_deeply($level->{'entity_fields'}, [], 'entity_fields');

        cmp_deeply($level->{'entity_filter_fields'}, {}, 'entity_filter_fields');

        cmp_deeply($level->{'entity_filter_simple_fields'}, [], 'entity_filter_simple_fields');

        my $fields = [
            unify_fields(
                @$fields_internal_advnet_context_on_site_page,    @$fields_internal_advnet_context_on_site_rtb,
                @$fields_internal_advnet_context_on_site_direct,  @$fields_internal_advnet_context_on_site_stripe,
                @$fields_internal_advnet_search_on_site_page,     @$fields_internal_advnet_search_on_site_direct,
                @$fields_internal_advnet_search_on_site_premium,  @$fields_internal_mobile_app_rtb,
                @$fields_internal_advnet_context_on_site_natural, @$fields_internal_advnet_context_on_site_content,
            ),
            {
                'hint'        => re(qr(\w)),
                'type'        => 'money',
                'title'       => re(qr(\w)),
                'id'          => 'all_w_nds',
                'short_title' => re(qr(\w)),
                'shared'      => TRUE,
                'category'    => ignore(),
            },
            {
                'hint'        => re(qr(\w)),
                'type'        => 'money',
                'title'       => re(qr(\w)),
                'id'          => 'all_wo_nds',
                'short_title' => re(qr(\w)),
                'shared'      => TRUE,
                'category'    => ignore(),
                'section'     => 'default',
            },
            {
                'hint'     => re(qr(\w)),
                'type'     => 'percent',
                'title'    => re(qr(\w)),
                'id'       => 'direct_ad_visibility',
                'category' => ignore(),
                conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
            },
            {
                'hint'     => re(qr(\w)),
                'type'     => 'percent',
                'title'    => re(qr(\w)),
                'id'       => 'direct_ad_reach',
                'category' => ignore(),
                conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
            },
            {
                'hint'     => re(qr(\w)),
                'type'     => 'percent',
                'title'    => re(qr(\w)),
                'id'       => 'direct_ad_coverage',
                'category' => ignore(),
                conflicts  => {dimension_fields => ['public_id', 'adfox_block']},
            },
            {
                'shared'      => 1,
                'hint'        => re(qr(\w)),
                'category'    => 3,
                'type'        => 'money',
                'title'       => re(qr(\w)),
                'id'          => 'bad_win_price_w_nds',
                'short_title' => re(qr(\w)),
            },
            {
                'shared'      => 1,
                'hint'        => re(qr(\w)),
                'category'    => 3,
                'type'        => 'money',
                'title'       => re(qr(\w)),
                'id'          => 'bad_win_price_wo_nds',
                'short_title' => re(qr(\w)),
            }
        ];

        cmp_deeply(sort_fields($level->{'fields'}), sort_fields([grep {$_->{id} !~ /_w_nds$/} @$fields]), 'fields');

        cmp_deeply(sort_fields($app->statistics->get_level($level_id)->get_fields()),
            sort_fields($fields), 'get_fields');

        cmp_deeply($level->{'has_raw_stat'}, '', 'has_raw_stat');

        cmp_deeply($level->{'id'}, $level_id, 'id');
    },
    locale => "C"
);
