use Test::Partner2::Simple;

use Test::Most;
use Test::Deep qw(cmp_deeply ignore);
use Test::Differences qw( eq_or_diff );

use Test::Partner2::Statistics::Data qw(
  $dimension_field_date
  $dimension_field_currency_id
  $dimension_field_public_id
  $fields_internal_advnet_context_on_site_page
  $fields_internal_advnet_context_on_site_rtb
  $fields_internal_advnet_context_on_site_direct
  $fields_internal_advnet_context_on_site_stripe
  $fields_internal_advnet_search_on_site_page
  $fields_internal_advnet_search_on_site_direct
  $fields_internal_advnet_search_on_site_premium
  $fields_internal_mobile_app_rtb
  );
use Test::Partner2::Statistics::Subs
  qw( _mock_app_with_hands_and_dbh unify_fields sort_fields build_statistics_levels restore_tables _do );

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        _mock_app_with_hands_and_dbh($app);

        my $table_dumps_dir = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01/table_dumps';
        my $data_dir        = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01';
        my $hands_dir       = "$data_dir/hands";

        {
            no strict 'refs';
            no warnings 'redefine';
            *{'QBit::Application::check_rights'} = sub {$_[1] !~ /^statistics[a-z_]+always_view$/;};
        }

        restore_tables(
            $app->partner_db->get_dbh, $table_dumps_dir, qw(
              users
              internal_site
              internal_search_on_site_campaign
              internal_context_on_site_campaign
              internal_search_on_site_premium
              internal_search_on_site_direct
              internal_context_on_site_stripe
              internal_context_on_site_rtb
              internal_context_on_site_direct
              internal_mobile_app
              internal_mobile_app_rtb
              )
        );

        my %currencies = (1 => 'USD', 2 => 'RUB', 3 => 'EUR',);
        $app->partner_db->get_dbh->do("INSERT INTO currencies (id, code) VALUES  (?, ?), (?, ?), (?, ?) ;",
            {}, %currencies);

        $app->statistics_internal_advnet_context_on_site_direct->update_statistics(
            storage => 'clickhouse',
            map {$_ => curdate(oformat => 'db')} qw(from to)
        );
        $app->statistics_internal_advnet_context_on_site_rtb->update_statistics(
            storage => 'clickhouse',
            map {$_ => curdate(oformat => 'db')} qw(from to)
        );
        $app->statistics_internal_advnet_context_on_site_stripe->update_statistics(
            storage => 'clickhouse',
            map {$_ => curdate(oformat => 'db')} qw(from to)
        );
        $app->statistics_internal_advnet_search_on_site_direct->update_statistics(
            storage => 'clickhouse',
            map {$_ => curdate(oformat => 'db')} qw(from to)
        );
        $app->statistics_internal_advnet_search_on_site_premium->update_statistics(
            storage => 'clickhouse',
            map {$_ => curdate(oformat => 'db')} qw(from to)
        );
        $app->statistics_internal_mobile_app_rtb->update_statistics(
            storage => 'clickhouse',
            map {$_ => curdate(oformat => 'db')} qw(from to)
        );

        ##### 1
        {

            my %get_statistics_arguments = (
                dimension_fields => [],
                entity_fields    => [],
                fields           => ["all_wo_nds", "all_w_nds",],
                levels           => [{id => "yandex",},],
                period           => "today",
                total            => 0,
                vat              => 2,
            );

            my $sort_func = sub {$a->{'currency_id'} <=> $b->{'currency_id'}};

            my $file_path = "$data_dir/get_statistics/yandex.json";
            my $expect    = [sort $sort_func @{_do($file_path)}];
            my $got       = [sort $sort_func @{$app->statistics->get_statistics(%get_statistics_arguments)->{'data'}}];

            cmp_deeply($got, $expect, 'get_statistics is correct');

            if (need_self_update()) {
                writefile($file_path, to_json($got, pretty => TRUE));
            }
        }
    },
    fill_databases       => 0,
    create_clickhouse_db => TRUE,
    mocks                => [qw(mock_check_statistics_by_blocks)],
);
