use Test::More;
use Test::Most;
use qbit;

require Application::Model::Statistics::_Utils::Money;

is(Application::Model::Statistics::_Utils::Money::_get_int(undef, undef), 0,               '_get_int(undef)');
is(Application::Model::Statistics::_Utils::Money::_get_int(undef, 0),     0,               '_get_int(0)');
is(Application::Model::Statistics::_Utils::Money::_get_int(undef, 0.00),  0,               '_get_int(0.00)');
is(Application::Model::Statistics::_Utils::Money::_get_int(undef, 3.45),  34500000000,     '_get_int(3.45)');
is(Application::Model::Statistics::_Utils::Money::_get_int(undef, 50),    500_000_000_000, '_get_int(50)');

is(Application::Model::Statistics::_Utils::Money::_get_int(undef, 3.45, 5), 345000, '_get_int(3.45, 5)');

is(Application::Model::Statistics::_Utils::Money::_get_int(undef, 5.78997286984141e-05),
    578997, '_get_int(5.78997286984141e-05)');

my @exceptions = (
    {
        value => '-',
        text  => gettext('Expected real number, but got "%s"', '-'),
    },
    {
        value => '453,345',
        text  => gettext('Expected real number, but got "%s"', '453,345'),
    },
    {
        value => '231.453.345',
        text  => gettext('Expected real number, but got "%s"', '231.453.345'),
    },
    {
        value => 'nan',
        text  => gettext('Expected real number, but got "%s"', 'nan'),
    },
    {
        value => 'inf',
        text  => gettext('Expected real number, but got "%s"', 'inf'),
    },

);

foreach my $el (@exceptions) {
    eval {Application::Model::Statistics::_Utils::Money::_get_int(undef, $el->{value});};

    is(ref($@), 'Exception', 'Exception is throwed.');
    is(ref($@) ? $@->message() : $@, $el->{text}, 'Exception message: ' . $el->{text});
}

done_testing();
