use qbit;
use Test::More;

require Application::Model::Statistics::_Utils::Money;

is(Application::Model::Statistics::_Utils::Money::money2float(undef, undef),       '-',    'money2float(undef)');
is(Application::Model::Statistics::_Utils::Money::money2float(undef, "-"),         '-',    'money2float("-")');
is(Application::Model::Statistics::_Utils::Money::money2float(undef, 34500000000), '3.45', 'money2float(34500000000)');
is(Application::Model::Statistics::_Utils::Money::money2float(undef, 500_000_000), '0.05', 'money2float(500_000_000)');
is(Application::Model::Statistics::_Utils::Money::money2float(undef, 590_000_000), '0.06', 'money2float(500_000_000)');
is(Application::Model::Statistics::_Utils::Money::money2float(undef, 9_000_000),   '0.00', 'money2float(9_000_000)');
is(Application::Model::Statistics::_Utils::Money::money2float(undef, 49_000_000),  '0.00', 'money2float(49_000_000)');
is(Application::Model::Statistics::_Utils::Money::money2float(undef, 59_000_000),  '0.01', 'money2float(59_000_000)');
is(Application::Model::Statistics::_Utils::Money::money2float(undef, 539_000_000), '0.05', 'money2float(539_000_000)');
is(Application::Model::Statistics::_Utils::Money::money2float(undef, 599_000_000), '0.06', 'money2float(599_000_000)');
is(Application::Model::Statistics::_Utils::Money::money2float(undef, 999_000_000), '0.10', 'money2float(999_000_000)');

done_testing();
