#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;

use qbit;

use Application::Model::Statistics::_Utils::Query;

my $FIXTURES = [
    {
        name   => 'is_currency_needed = TRUE',
        args   => {is_currency_needed => TRUE},
        result => 1,
    },
    {
        name   => 'currency_id in dimension_fields',
        args   => {dimension_fields => [qw(currency_id)]},
        result => 1,
    },
    {
        name   => 'has money fields',
        args   => {fields => [qw(rtb_all_wo_nds)]},
        result => 1,
    },
    {
        name   => 'no money fields',
        args   => {fields => [qw(rtb_block_shows)]},
        result => 0,
    },
    {
        name   => 'without groupping by currency_id',
        args   => {},
        result => 0,
    },
];

run_tests(
    sub {
        my ($app) = @_;

        foreach my $test (@$FIXTURES) {
            my $query = Application::Model::Statistics::_Utils::Query->new(
                $app->statistics,
                levels => [{id => 'advnet_context_on_site_rtb'}],
                period => ['today'],
                %{$test->{'args'}}
            );

            is($query->is_currency_needed, $test->{'result'}, $test->{'name'});
        }
    },
);
