#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Deep;

use qbit;

use Test::Partner2::Mock qw(mock_subs);

use Application::Model::Statistics::_Utils::Query;

my $FIXTURES = [
    {
        name => 'order by exists fields',
        args => {
            fields   => [qw(rtb_all_wo_nds rtb_all_w_nds)],
            order_by => [{field => 'rtb_all_wo_nds', dir => 'desc'}, {field => 'rtb_all_w_nds', dir => 'asc'}]
        },
        result => [{field => 'rtb_all_wo_nds', dir => 'desc'}, {field => 'rtb_all_w_nds', dir => 'asc'}],
    },
    {
        name => 'order by not exists fields',
        args => {
            fields   => [qw(rtb_all_wo_nds rtb_all_w_nds)],
            order_by => [{field => 'direct_all_wo_nds', dir => 'desc'}, {field => 'direct_all_w_nds', dir => 'asc'}]
        },
        result => [],
    },
    {
        name => 'order by exists entity_fields',
        args => {
            entity_fields => [qw(domain campaign_id)],
            order_by      => [{field => 'domain', dir => 'desc'}, {field => 'campaign_id', dir => 'asc'}]
        },
        result => [{field => 'domain', dir => 'desc'}, {field => 'campaign_id', dir => 'asc'}],
    },
    {
        name => 'order by not exists entity_fields',
        args => {
            entity_fields => [qw(domain campaign_id)],
            order_by      => [{field => 'public_id', dir => 'desc'}, {field => 'caption', dir => 'asc'}]
        },
        result => [],
    },
    {
        name => 'order by exists dimension_fields',
        args => {
            dimension_fields => [qw(dsp_id_name dsp_caption)],
            order_by         => [{field => 'dsp_id_name', dir => 'desc'}, {field => 'dsp_caption', dir => 'asc'}]
        },
        result => [{field => 'dsp_id_name', dir => 'desc'}, {field => 'dsp_caption', dir => 'asc'}],
    },
    {
        name => 'order by not exists dimension_fields',
        args => {
            dimension_fields => [qw(dsp_id_name dsp_caption)],
            order_by         => [{field => 'tag_id', dir => 'desc'}, {field => 'tag_caption', dir => 'asc'}]
        },
        result => [],
    },
];

run_tests(
    sub {
        my ($app) = @_;

        mock_subs(
            {
                'Application::Model::Statistics::Product::is_available' => sub {TRUE}
            }
        );

        foreach my $test (@$FIXTURES) {
            my $query = Application::Model::Statistics::_Utils::Query->new(
                $app->statistics,
                levels => [{id => 'advnet_context_on_site_rtb'}],
                period => ['today'],
                %{$test->{'args'}}
            );

            cmp_deeply($query->order_by(), $test->{'result'}, $test->{'name'});
        }
    },
    init => [qw(statistics_advnet_context_on_site_rtb)],
);
