use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Deep;

require Application::Model::Statistics;

sub main_in_test {

    my $result = Application::Model::Statistics::_get_filter_from_tags(
        undef,
        [
            {
                campaign_id => 149863,
                tag_id      => 7,
            },
            {
                campaign_id => 123194,
                tag_id      => 16,
            },
        ],
        'campaign_id',
    );

    cmp_deeply(
        $result,
        [
            'OR',
            [
                ['AND', [['campaign_id', '=', \149863,], ['tag_id', '=', \7,],],],
                ['AND', [['campaign_id', '=', \123194,], ['tag_id', '=', \16,],],],
            ],
        ],
    );

    my $result2 = Application::Model::Statistics::_get_filter_from_tags(
        undef,
        [

            {
                context_page_id => 183230,
                tag_id          => 0,
            },
            {
                context_page_id => 163240,
                tag_id          => 0,
            },
        ],
        'context_page_id',
    );

    cmp_deeply(
        $result2,
        [
            'OR',
            [
                ['AND', [['context_page_id', '=', \183230,], ['tag_id', '=', \0,],],],
                ['AND', [['context_page_id', '=', \163240,], ['tag_id', '=', \0,],],],
            ],
        ],
    );

    my $result3 = Application::Model::Statistics::_get_filter_from_tags(undef, []);

    cmp_deeply($result3, [\0 => '=' => \1],);

    done_testing();

}
main_in_test();
