#!/usr/bin/perl

use Test::Deep qw(cmp_deeply);

use qbit;

use Test::Partner2::Simple;

my $DATA = [
    {
        number => 1,
        string => 'a',
        order  => 1,
    },
    {
        number => undef,
        string => undef,
        order  => 2,
    },
    {
        number => '-',
        string => '-',
        order  => 3,
    },
    {
        number => 2,
        string => 'b',
        order  => 4,
    },
    {
        number => 1,
        string => 'a',
        order  => 5,
    },
];

my $FIXTURES = [
    {
        sort_by    => [qw(number order)],
        sort_order => 'asc',
        expected   => [
            {
                'number' => undef,
                'order'  => 2,
                'string' => undef
            },
            {
                'number' => '-',
                'order'  => 3,
                'string' => '-'
            },
            {
                'number' => 1,
                'order'  => 1,
                'string' => 'a'
            },
            {
                'number' => 1,
                'order'  => 5,
                'string' => 'a'
            },
            {
                'number' => 2,
                'order'  => 4,
                'string' => 'b'
            }
        ],
    },
    {
        sort_by    => [qw(number order)],
        sort_order => 'desc',
        expected   => [
            {
                'number' => 2,
                'order'  => 4,
                'string' => 'b'
            },
            {
                'number' => 1,
                'order'  => 5,
                'string' => 'a'
            },
            {
                'number' => 1,
                'order'  => 1,
                'string' => 'a'
            },
            {
                'number' => '-',
                'order'  => 3,
                'string' => '-'
            },
            {
                'number' => undef,
                'order'  => 2,
                'string' => undef
            }
        ],
    },
    {
        sort_by    => [qw(string order)],
        sort_order => 'asc',
        expected   => [
            {
                'number' => undef,
                'order'  => 2,
                'string' => undef
            },
            {
                'number' => '-',
                'order'  => 3,
                'string' => '-'
            },
            {
                'number' => 1,
                'order'  => 1,
                'string' => 'a'
            },
            {
                'number' => 1,
                'order'  => 5,
                'string' => 'a'
            },
            {
                'number' => 2,
                'order'  => 4,
                'string' => 'b'
            }
        ],
    },
    {
        sort_by    => [qw(string order)],
        sort_order => 'desc',
        expected   => [
            {
                'number' => 2,
                'order'  => 4,
                'string' => 'b'
            },
            {
                'number' => 1,
                'order'  => 5,
                'string' => 'a'
            },
            {
                'number' => 1,
                'order'  => 1,
                'string' => 'a'
            },
            {
                'number' => '-',
                'order'  => 3,
                'string' => '-'
            },
            {
                'number' => undef,
                'order'  => 2,
                'string' => undef
            }
        ],
    },
    {
        sort_by    => [qw(number string order)],
        sort_order => 'asc',
        expected   => [
            {
                'number' => undef,
                'order'  => 2,
                'string' => undef
            },
            {
                'number' => '-',
                'order'  => 3,
                'string' => '-'
            },
            {
                'number' => 1,
                'order'  => 1,
                'string' => 'a'
            },
            {
                'number' => 1,
                'order'  => 5,
                'string' => 'a'
            },
            {
                'number' => 2,
                'order'  => 4,
                'string' => 'b'
            }
        ],
    },
    {
        sort_by    => [qw(number string order)],
        sort_order => 'desc',
        expected   => [
            {
                'number' => 2,
                'order'  => 4,
                'string' => 'b'
            },
            {
                'number' => 1,
                'order'  => 5,
                'string' => 'a'
            },
            {
                'number' => 1,
                'order'  => 1,
                'string' => 'a'
            },
            {
                'number' => '-',
                'order'  => 3,
                'string' => '-'
            },
            {
                'number' => undef,
                'order'  => 2,
                'string' => undef
            }
        ],
    },
];

run_tests(
    sub {
        my ($app) = @_;

        foreach my $test (@$FIXTURES) {
            my $sort_data =
              $app->statistics->_sort_stat_data($DATA,
                {number => {sort_as => 'number'}, string => {sort_as => 'string'}, order => {sort_as => 'number'}},
                $test->{'sort_by'}, $test->{'sort_order'});

            cmp_deeply($sort_data, $test->{'expected'},
                'fields: ' . join(', ', @{$test->{'sort_by'}}) . "; order: $test->{'sort_order'}");
        }
    },
    dont_create_database => TRUE,
);
