use strict;
use warnings FATAL => 'all';

use qbit;

use RoleRights;

use Test::Partner2::Simple;
use Test::More;

my $RIGHT_POSTFIX = '_always_view';
my $SKIP_PRODUCTS = {statistics_ssp_video_app_rtb => 1,};

run_tests(
    sub {
        my ($app) = @_;

        my $role_rights = RoleRights->new('production')->get_rights();

        my $statistics_product_list = [sort @{$app->product_manager->get_statistics_products()}];

        my @rights2check = map {$_ . $RIGHT_POSTFIX} grep {!exists $SKIP_PRODUCTS->{$_}} @$statistics_product_list;

        my @ne = grep {!exists $role_rights->{$_}} @rights2check;
        is(scalar @ne, 0, 'all rights exist');

        for my $right (grep {$_ =~ 'internal'} @rights2check) {
            is_deeply(
                $role_rights->{$right},
                {
                    '2' => 1,
                    '3' => 1,
                    '4' => 1
                },
                "$right -> roles 2,3,4"
            );
        }

        for my $right (grep {$_ =~ '^statistics_ssp_' && $_ !~ 'api_always_view' && $_ !~ 'dsp' && $_ !~ 'internal'}
            @rights2check)
        {
            is_deeply(
                $role_rights->{$right},
                {
                    '2'  => 1,
                    '15' => 1,
                },
                "$right -> roles 2,15"
            );
        }

        for my $right (grep {$_ !~ 'statistics_ssp_' && $_ !~ 'api_always_view' && $_ !~ 'dsp' && $_ !~ 'internal'}
            @rights2check)
        {
            is_deeply(
                $role_rights->{$right},
                {
                    '2'  => 1,
                    '15' => 1,
                    '17' => 1,
                },
                "$right -> roles 2,15"
            );
        }

        for my $right (grep {$_ =~ 'dsp'} @rights2check) {
            is_deeply(
                $role_rights->{$right},
                {
                    '2' => 1,
                    '8' => 1
                },
                "$right -> roles 2,8"
            );
        }
    },
    dont_create_database => TRUE,
);
