#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        {
            no strict 'refs';
            no warnings 'redefine';
            *{'QBit::Application::check_rights'} = sub {TRUE};
        }

        foreach my $statistics_product (sort @{$app->product_manager->get_statistics_products()}) {
            subtest(
                $statistics_product => sub {

                    ok($app->$statistics_product->can('product'),
                        "Statistics level $statistics_product has method product.");

                    my %fields = map {$_ => TRUE} keys(%{$app->$statistics_product->product->get_model_fields()});
                    my @statistics_fields = map {$_->{'id'}} @{$app->$statistics_product->entity_fields()};

                    my @not_existing_fields = grep {!$fields{$_}} @statistics_fields;
                    ok(!@not_existing_fields, 'All entity_fields in statistics level are present in product.');
                    if (@not_existing_fields) {
                        diag(   "\tFields doesn't exist in product ("
                              . ref($app->$statistics_product->product) . "),\n"
                              . "\tbut defined in statistics level $statistics_product:\n" . "\t\t"
                              . join(', ', @not_existing_fields)
                              . ".\n");
                    }
                }
            );
        }

    },
    dont_create_database => 1
);
