#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $tmp_rights = $app->add_tmp_rights('event_log_view_all_statistic_fields');

        my @stat_accessors = map {'statistics_' . $_}
          grep {!m/publisher$/}
          sort keys %{$app->statistics->{__TREE_ENTITIES_HS__}};

        foreach my $accessor (@stat_accessors) {
            subtest(
                $accessor => sub {
                    note("Start $accessor");

                    ok($app->$accessor->can('parent_accessor'),  'Has parent_accessor() method');
                    ok($app->$accessor->can('get_event_fields'), 'Has get_event_fields() method');

                    my $parent_accessor = $app->$accessor->parent_accessor();

                    my $event_fields = eval {$app->$accessor->get_event_fields()};

                    cmp_deeply(
                        $event_fields,
                        $parent_accessor
                        ? all(
                            isa('ARRAY'),
                            array_each(
                                all(
                                    isa('HASH'),
                                    #--- Опциональные ключи
                                    superhashof(
                                        {
                                            name  => ignore(),
                                            field => ignore(),
                                        }
                                    )
                                   )
                              )

                             )
                        : [],
                        'get_event_fields() satisfy the pattern'
                    );

                    # Проверяем что все поля из get_event_fields() есть в entity_fields()
                    if ($parent_accessor) {

                        my $entity_fields       = $app->$accessor->entity_fields();
                        my %entity_fields_hash  = map {$_->{id} => 1} @$entity_fields;
                        my @not_existing_fields = grep {!$entity_fields_hash{$_}} map {$_->{field}} @$event_fields;

                        ok(!@not_existing_fields, "All fields from get_event_fields() are present in entity_fields()");
                        if (@not_existing_fields) {
                            diag(
                                sprintf(
                                    qq[Fields doesn't exist in entity_fields() for level '%s':\n\t\t%s],
                                    $accessor, join(', ', @not_existing_fields)
                                )
                            );
                        }
                    }

                    # Проверяем что все поля из get_event_fields() есть в get_model_fields() продуктовой модели
                    if ($parent_accessor) {

                        my $product = $app->$accessor->product();
                        my $product_accessor =
                            $product->can('accessor')
                          ? $product->accessor()
                          : ref($product);

                        my $product_model_fields = $product->get_model_fields();
                        my %model_fields_hash    = map {$_ => 1} keys %$product_model_fields;
                        my @not_existing_fields  = grep {!$model_fields_hash{$_}} map {$_->{field}} @$event_fields;

                        ok(!@not_existing_fields,
                            "All fields from get_event_fields() are present in product $product_accessor.");
                        if (@not_existing_fields) {
                            diag(
                                sprintf(
                                    qq[Fields doesn't exist in product but defined in statistics "%s":\n\t\t%s],
                                    $product_accessor, join(', ', @not_existing_fields)
                                )
                            );
                        }
                    }
                }
            );
        }
    },
    dont_create_database => 1
);
