#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Differences qw(eq_or_diff);
use Test::Partner2::Mock qw(mock_curdate mock_subs);
use Test::Partner::Utils qw(get_clickhouse_statistics_test_data);

use qbit;

use Application::Model::Statistics::_Utils::Query;

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2019-03-20 18:11:23');

        mock_stat($app);

        my @queries = ();
        mock_subs(
            {
                'QBit::Application::Model::DB::_get_all' => sub {
                    push(@queries, $_[1]);

                    return $Test::Partner2::Mock::original_subs->{'QBit::Application::Model::DB::_get_all'}->(@_);
                  }
            }
        );

        my $data = $app->statistics->get_filter_values(
            "levels"        => [{"id" => "advnet_context_on_site_rtb", "filter" => undef}],
            "fields"        => ["rtb_all_wo_nds"],
            "entity_fields" => ["campaign_id"],
            "dimension_fields" => ["date|day", "dsp_id_name"],
            "period"           => "yesterday",
        );

        eq_or_diff(
            $queries[0], qq[SELECT DISTINCT
    `_dsp_id` AS `dsp_id`
FROM (
    SELECT
        `dsp_id` AS `_dsp_id`
    FROM `statistics`
    WHERE (
        `dt` >= '2019-03-19'
        AND `dt` <= '2019-03-19'
        AND `product_id` IN ('context_on_site_rtb')
    )
) `statistics` FORMAT JSONCompact], 'get dictionary', {context => 1}
        );

        eq_or_diff(
            $data,
            {
                'dsp_id_name' => [
                    {
                        'id'    => '1',
                        'key'   => 'id1',
                        'label' => 1
                    },
                    {
                        'id'    => '23452',
                        'key'   => 'id23452',
                        'label' => 23452
                    }
                ]
            },
            'get filter values'
        );
    },
    create_clickhouse_db => TRUE,
);

sub mock_stat {
    my ($app) = @_;

    my $data = get_clickhouse_statistics_test_data(
        $app,
        pk_data => [
            {dt => '2019-03-19', page_id => 2345,   dsp_id => 1},
            {dt => '2019-03-19', page_id => 496124, dsp_id => 23452},
        ],
        accessors => [qw(statistics_advnet_context_on_site_rtb)]
    );

    $app->clickhouse_db->statistics->add_multi($data);
}
