use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_clickhouse_statistics_test_data);
use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        my $rtb = $app->context_on_site_rtb->get_all(fields => [qw(campaign_id id caption)], limit => 1)->[0];

        my $public_id = $app->context_on_site_rtb->public_id($rtb);

        mock_ch_table(
            $app,
            {
                page_id     => $rtb->{'campaign_id'},
                block_id    => $rtb->{'id'},
                dsp_id      => 1,
                currency_id => 2,
                tag_id      => 0,
            }
        );

        my $data = $app->statistics->get_statistics(
            period           => ['2017-08-16', '2017-12-31'],
            fields           => ['rtb_partner_wo_nds'],
            dimension_fields => ['date|day',   'currency_id'],
            dimension_filter => undef,
            entity_fields    => ['public_id'],
            total            => 1,             # <-- PI-13616
            vat              => -1,
            levels           => [
                {
                    'filter' => ['AND', [['id', '=', $public_id]]],
                    'id' => 'advnet_context_on_site_rtb'
                }
            ],
            # ordering is not implemented atm
            order_by => [{'field' => 'rtb_partner_wo_nds', 'dir' => 'asc'}],
            storage  => 'clickhouse',
        );
        # sorting here bc ordering is not implemented atm
        my $fn_sort_by_key_date = sub {$a->{date} cmp $b->{date}};
        $data->{'data'} = [sort $fn_sort_by_key_date @{$data->{'data'}}];
        is_deeply(
            $data,
            {
                'currencies' => [
                    {
                        'code' => 'EUR',
                        'id'   => '3'
                    },
                    {
                        'code' => 'RUB',
                        'id'   => '2'
                    },
                    {
                        'code' => 'USD',
                        'id'   => '1'
                    }
                ],
                # sorting here bc ordering is not implemented atm
                'data' => [
                    sort $fn_sort_by_key_date (
                        {
                            'currency_id'        => 2,
                            'date'               => '2017-08-16',
                            'public_id'          => $public_id,
                            'rtb_partner_wo_nds' => '3420.34'
                        },
                        {
                            'currency_id'        => 2,
                            'date'               => '2017-08-17',
                            'public_id'          => $public_id,
                            'rtb_partner_wo_nds' => '3420.34'
                        },
                        {
                            'currency_id'        => 2,
                            'date'               => '2017-08-19',
                            'public_id'          => $public_id,
                            'rtb_partner_wo_nds' => '3420.34'
                        },
                    )
                ],
                'measures' => {
                    'rtb_partner_wo_nds' => {
                        'index' => 1,
                        'title' => 'Partnerships for RTB-blocks (w/o&nbsp;VAT)',
                        'type'  => 'money',
                        'unit'  => 'money'
                    }
                },
                'report_title' => 'Report for period 16.08.2017 - 31.12.2017',
                'total'        => {'2' => {'rtb_partner_wo_nds' => '10261.02'}}
            },
            'get_statistics() from CH with total',
        );
    },
    create_clickhouse_db => TRUE,
);

sub mock_ch_table {
    my ($app, $pk) = @_;

    my $data = get_clickhouse_statistics_test_data(
        $app,
        accessors => [qw(statistics_advnet_context_on_site_rtb)],
        pk_data   => [map {{dt => $_, partner_wo_nds => 34203400045208, %$pk}} qw(2017-08-16 2017-08-17 2017-08-19)]
    );

    $app->clickhouse_db->statistics->add_multi($data);
}
