use strict;
use warnings FATAL => 'all';

use Clone qw(clone);
use Test::Partner2::Simple;

use Test::More;

my @CHECKS;

sub generate_checks {
    my ($app) = @_;
    my $tree = $app->statistics->get_tree();

    foreach my $element (@$tree) {

        next if $element->{id} ne 'payment';

        parse_tree($element, []);
    }
}

sub parse_tree {
    my ($hash, $levels) = @_;

    $levels = clone($levels);

    my @all_fields = map {$_->{id}} @{$hash->{fields}};

    push @$levels, $hash->{id};

    my $has_adfox_block_in_entity_fields    = !!grep {$_->{id} eq 'adfox_block'} @{$hash->{entity_fields}};
    my $has_adfox_block_in_dimension_fields = !!grep {$_->{id} eq 'adfox_block'} @{$hash->{dimension_fields}};

    push @CHECKS,
      {
        level_id                            => $hash->{id},
        fields                              => [$all_fields[0]],
        levels                              => $levels,
        has_adfox_block_in_entity_fields    => $has_adfox_block_in_entity_fields,
        has_adfox_block_in_dimension_fields => $has_adfox_block_in_dimension_fields,
      };

    if ($hash->{children}) {
        foreach my $element (@{$hash->{children}}) {
            parse_tree($element, $levels);
        }
    }

    return 1;
}

run_tests(
    sub {
        my ($app) = @_;

        $app->{'__CURRENT_USER_RIGHTS__'} = {};

        my $user_id = 1022;    # yndx-developer
        $app->set_cur_user({id => $user_id});

        generate_checks($app);

        my %level_ids_can_group_by_adfox_block = map {$_ => 1} qw(
          payment
          advnet_on_site
          advnet_context_on_site
          advnet_context_on_site_content
          advnet_context_on_site_natural
          advnet_context_on_site_rtb
          video_an_site
          mobile_app
          mobile_app_rtb
          video_an_site
          video_an_site_fullscreen
          video_an_site_inpage
          video_an_site_instream
          );

        foreach my $check (@CHECKS) {
            my $level_name = join(' / ', @{$check->{levels}});

            if ($level_ids_can_group_by_adfox_block{$check->{'level_id'}}) {
                ok(
                    ($check->{has_adfox_block_in_entity_fields} || $check->{has_adfox_block_in_dimension_fields}) eq
                      '1',
                    "Can GROUP BY 'adfox_block' in '$level_name'",
                  );
            } else {
                ok(
                    ($check->{has_adfox_block_in_entity_fields} || $check->{has_adfox_block_in_dimension_fields}) eq '',
                    "Can not GROUP BY 'adfox_block' in '$level_name'",
                  );
            }
        }

    },
    do_not_die_on_fail   => 1,
    create_clickhouse_db => 1,
);
