use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        no strict 'refs';
        no warnings 'redefine';
        *{'QBit::Application::check_rights'} = sub {1};

        my %opts = (
            dimension_fields => [],
            dimension_filter => undef,
            entity_fields    => [],
            fields           => ['rtb_block_shows',],
            levels           => [
                {
                    filter => undef,
                    id     => 'advnet_context_on_site_rtb',
                },
            ],
            order_by => [],
            total    => 0,
            vat      => -1,
        );

        eval {my $data = $app->statistics->get_statistics(%opts, period => '7days',);};
        is($@, '', 'No exception');

        my @incorrect_periods = ('some_string', undef, ['2016-03-24', '2016-03-01'], ['2016-01-01', '2016-03-34'],);

        foreach my $period (@incorrect_periods) {
            eval {my $data = $app->statistics->get_statistics(%opts, period => $period);};
            is(
                ref($@),
                'Exception::Validation::Statistics::InvalidPeriod',
                'Exception::Validation::Statistics::InvalidPeriod'
              );
        }

    },
    create_clickhouse_db => 1,
);
