use qbit;
use Test::Partner2::Simple;
use Test::Partner2::Mock;
use Test::Partner::Utils qw(get_new_an_rtb mock_curdate);
use Test::More;
use Test::Deep qw(cmp_deeply);

sub add_adfox_block {
    my (%opts) = @_;

    my $app = $opts{app};
    my $page_id = $opts{page_id} // throw 'No page_id';

    my %data      = (campaign_id => $opts{page_id}, dsps => ['2317563']);
    my $public_id = $app->context_on_site_rtb->add(%{get_new_an_rtb(\%data)});
    my $ids       = $app->context_on_site_rtb->_split_id($public_id);

    # На момент написания теста поле adfox_block нельзя было изменить через модель, поэтому
    # тут это поле изменяется через partner_db
    $app->partner_db->context_on_site_rtb->edit($ids, {adfox_block => 1});

    return $ids;
}

run_tests(
    sub {
        my ($app) = @_;

        my $page_id = 41443;

        my $date = '2017-08-28';
        mock_curdate("$date 00:00:00");
        mock_format_system($app);
        mock_yt_picategory_mapping($app);

        my $ids = add_adfox_block(app => $app, page_id => $page_id);

        # Статистика для блока который есть в mocked_databases
        $app->clickhouse_db->statistics->add(
            {
                product_id  => 'context_on_site_rtb',
                all_wo_nds  => 6695539952000,
                block_id    => 1,
                page_id     => $page_id,
                dt          => $date,
                all_wo_nds  => 6695539952000,
                currency_id => 2,
            }
        );

        # Статистика для нового блока, который создается в этом тесте
        $app->clickhouse_db->statistics->add(
            {
                product_id  => 'context_on_site_rtb',
                all_wo_nds  => 97335250000,
                block_id    => $ids->{id},
                page_id     => $ids->{campaign_id},
                dt          => $date,
                all_wo_nds  => 97335250000,
                currency_id => 2,
            }
        );

        my $stat = $app->statistics->get_statistics(
            dimension_fields => ['currency_id'],
            dimension_filter => undef,
            entity_fields    => ['public_id'],
            fields           => ['rtb_all_wo_nds'],
            levels           => [{'filter' => undef, 'id' => 'advnet_context_on_site_rtb'}],
            order_by         => [{field => 'public_id', dir => 'asc'}],
            period           => '30days',
            total            => 0,
            vat              => -1,
        );

        cmp_deeply(
            $stat,
            {
                currencies => [
                    {
                        code => 'EUR',
                        id   => 3,
                    },
                    {
                        code => 'RUB',
                        id   => 2,
                    },
                    {
                        code => 'USD',
                        id   => 1,
                    },
                ],
                data => [
                    {
                        public_id      => 'R-A-41443-1',
                        currency_id    => 2,
                        rtb_all_wo_nds => 669.55,
                    },
                    {
                        public_id      => 'R-A-41443-42',
                        currency_id    => 2,
                        rtb_all_wo_nds => 9.73,
                    },
                ],
                measures => {
                    rtb_all_wo_nds => {
                        index => 1,
                        title => 'Turnover for RTB-blocks (w/o&nbsp;VAT)',
                        type  => 'money',
                        unit  => 'money',
                    },
                },
                report_title => 'Report for period 30.07.2017 - 28.08.2017',
            },
            'Got expected statistics',
        );

        return 1;
    },
    create_clickhouse_db => TRUE,
);
