SELECT
    `_caption` AS `caption`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_domain` AS `domain`,
    `_dsp_caption` AS `dsp_caption`,
    `_dsp_id_name` AS `dsp_id_name`,
    `_indoor_all_wo_nds` AS `indoor_all_wo_nds`,
    `_indoor_block_all_hits` AS `indoor_block_all_hits`,
    `_indoor_block_bad_shows` AS `indoor_block_bad_shows`,
    `_indoor_block_bad_shows_own_adv` AS `indoor_block_bad_shows_own_adv`,
    `_indoor_block_bad_shows_percent` AS `indoor_block_bad_shows_percent`,
    `_indoor_block_bad_win_hits` AS `indoor_block_bad_win_hits`,
    `_indoor_block_bad_win_hits_own_adv` AS `indoor_block_bad_win_hits_own_adv`,
    `_indoor_block_bad_win_hits_percent` AS `indoor_block_bad_win_hits_percent`,
    `_indoor_block_bad_win_hits_unsold` AS `indoor_block_bad_win_hits_unsold`,
    `_indoor_block_cover_ratio` AS `indoor_block_cover_ratio`,
    `_indoor_block_cpm_all_wo_nds` AS `indoor_block_cpm_all_wo_nds`,
    `_indoor_block_cpm_partner_wo_nds` AS `indoor_block_cpm_partner_wo_nds`,
    `_indoor_block_cpmh_all_wo_nds` AS `indoor_block_cpmh_all_wo_nds`,
    `_indoor_block_cpmh_partner_wo_nds` AS `indoor_block_cpmh_partner_wo_nds`,
    `_indoor_block_direct_clicks` AS `indoor_block_direct_clicks`,
    `_indoor_block_direct_ctr` AS `indoor_block_direct_ctr`,
    `_indoor_block_direct_shows` AS `indoor_block_direct_shows`,
    `_indoor_block_hits` AS `indoor_block_hits`,
    `_indoor_block_hits_own_adv` AS `indoor_block_hits_own_adv`,
    `_indoor_block_hits_unsold` AS `indoor_block_hits_unsold`,
    `_indoor_block_shows` AS `indoor_block_shows`,
    `_indoor_block_shows_own_adv` AS `indoor_block_shows_own_adv`,
    `_indoor_block_visibility` AS `indoor_block_visibility`,
    `_indoor_block_winrate` AS `indoor_block_winrate`,
    `_indoor_partner_wo_nds` AS `indoor_partner_wo_nds`,
    `_login` AS `login`,
    `_page_id` AS `page_id`,
    `_public_id` AS `public_id`,
    `_tag_id` AS `tag_id`,
    `_video_caption` AS `video_caption`
FROM (
    SELECT
        dictGetString('blocks_dict', 'caption', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) AS `_caption`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetStringOrDefault('dsps_dict', 'short_caption', toUInt64(`dsp_id`), concat('DSP #', toString(`dsp_id`))) AS `_dsp_caption`,
        `dsp_id` AS `_dsp_id_name`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'indoor_block') / 10000000), 2) AS `_indoor_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'indoor_block') AS `_indoor_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            )))) AS `_indoor_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            )))) AS `_indoor_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'indoor_block')) AS `_indoor_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'indoor_block') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            ))), 2) AS `_indoor_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'indoor_block') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            ))), 2) AS `_indoor_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'indoor_block') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            ))), 2) AS `_indoor_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'indoor_block') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            ))), 2) AS `_indoor_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'indoor_block'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'indoor_block')) AS `_indoor_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'indoor_block') AS `_indoor_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'indoor_block') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'indoor_block'
            )))) AS `_indoor_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'indoor_block'
    )) AS `_indoor_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'indoor_block'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'indoor_block'
        ))) AS `_indoor_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'indoor_block'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'indoor_block'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'indoor_block') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'indoor_block'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'indoor_block'
                    )))))) AS `_indoor_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'indoor_block') / 10000000), 2) AS `_indoor_partner_wo_nds`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        `page_id` AS `_page_id`,
        concat(transform(toString(`product_id`), ['indoor_block'], ['I-D-']), toString(`page_id`), '-', toString(`block_id`)) AS `_public_id`,
        `tag_id` AS `_tag_id`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_video_caption`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('indoor_block')
        AND (
            `page_id` IN ('page_id__from_table__indoor__with_filter__["AND",[["owner_id","= ANY",["id__from_table__users__with_filter__[\\"AND\\",[[\\"login\\",\\"=\\",\\"mock__login\\"]]]"]]]]')
        )
        AND (
            `page_id` = 'mock__page_id'
        )
        AND (
            `block_id` = 1
        )
        AND (
            `page_id` IN ('page_id__from_table__indoor__with_filter__["AND",[["indoor.ya","=","mock__page.domain"]]]')
        )
        AND (
            (`page_id`, `block_id`) IN (('page_id__from_table__indoor_block__with_filter__["AND",[[{"json_unquote":[{"json_extract":["opts","$.caption"]}]},"=","mock__caption"]]]', 'id__from_table__indoor_block__with_filter__["AND",[[{"json_unquote":[{"json_extract":["opts","$.caption"]}]},"=","mock__caption"]]]'))
        )
        AND (
            dictGetUInt64('blocks_dict', 'multistate', tuple(toString(`product_id`), toUInt32(`page_id`), toUInt32(`block_id`))) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
        AND `dsp_id` = 'mock__dsp_id_name'
        AND `dsp_id` = 'mock__dsp_caption'
        AND `tag_id` = 'mock__tag_id'
        AND `page_id` = 'mock__video_caption'
    )
    GROUP BY `_caption`, `_currency_id`, `_date`, `_domain`, `_dsp_caption`, `_dsp_id_name`, `_login`, `_page_id`, `_public_id`, `_tag_id`, `_video_caption`
) `statistics`
WHERE (
    (if(isNaN(`indoor_block_bad_shows`), 0, `indoor_block_bad_shows`) + if(isNaN(`indoor_partner_wo_nds`), 0, `indoor_partner_wo_nds`) + if(isNaN(`indoor_block_bad_shows_percent`), 0, `indoor_block_bad_shows_percent`) + if(isNaN(`indoor_block_bad_win_hits_own_adv`), 0, `indoor_block_bad_win_hits_own_adv`) + if(isNaN(`indoor_block_shows_own_adv`), 0, `indoor_block_shows_own_adv`) + if(isNaN(`indoor_block_bad_win_hits_percent`), 0, `indoor_block_bad_win_hits_percent`) + if(isNaN(`indoor_block_cpmh_partner_wo_nds`), 0, `indoor_block_cpmh_partner_wo_nds`) + if(isNaN(`indoor_block_direct_ctr`), 0, `indoor_block_direct_ctr`) + if(isNaN(`indoor_block_bad_shows_own_adv`), 0, `indoor_block_bad_shows_own_adv`) + if(isNaN(`indoor_block_direct_clicks`), 0, `indoor_block_direct_clicks`) + if(isNaN(`indoor_block_cpm_all_wo_nds`), 0, `indoor_block_cpm_all_wo_nds`) + if(isNaN(`indoor_block_all_hits`), 0, `indoor_block_all_hits`) + if(isNaN(`indoor_block_direct_shows`), 0, `indoor_block_direct_shows`) + if(isNaN(`indoor_block_shows`), 0, `indoor_block_shows`) + if(isNaN(`indoor_block_winrate`), 0, `indoor_block_winrate`) + if(isNaN(`indoor_block_cpmh_all_wo_nds`), 0, `indoor_block_cpmh_all_wo_nds`) + if(isNaN(`indoor_block_hits_unsold`), 0, `indoor_block_hits_unsold`) + if(isNaN(`indoor_block_cpm_partner_wo_nds`), 0, `indoor_block_cpm_partner_wo_nds`) + if(isNaN(`indoor_block_bad_win_hits`), 0, `indoor_block_bad_win_hits`) + if(isNaN(`indoor_block_visibility`), 0, `indoor_block_visibility`) + if(isNaN(`indoor_block_hits_own_adv`), 0, `indoor_block_hits_own_adv`) + if(isNaN(`indoor_block_cover_ratio`), 0, `indoor_block_cover_ratio`) + if(isNaN(`indoor_block_hits`), 0, `indoor_block_hits`) + if(isNaN(`indoor_all_wo_nds`), 0, `indoor_all_wo_nds`) + if(isNaN(`indoor_block_bad_win_hits_unsold`), 0, `indoor_block_bad_win_hits_unsold`)) > 0
) FORMAT JSONCompact
